/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.compositediagram.command;

import net.sourceforge.plantuml.LineLocation;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOptional;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.compositediagram.CompositeDiagram;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.LinkDecor;
import net.sourceforge.plantuml.cucadiagram.LinkType;

public class CommandLinkBlock
extends SingleLineCommand2<CompositeDiagram> {
    public CommandLinkBlock() {
        super(CommandLinkBlock.getRegexConcat());
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandLinkBlock.class.getName(), RegexLeaf.start(), new RegexLeaf("ENT1", "([\\p{L}0-9_.]+)"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("DECO1", "(\\[\\]|\\*\\))?"), new RegexLeaf("QUEUE", "([=-]+|\\.+)"), new RegexLeaf("DECO2", "(\\[\\]|\\(\\*)?"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("ENT2", "([\\p{L}0-9_.]+)"), RegexLeaf.spaceZeroOrMore(), new RegexOptional((IRegex)new RegexConcat(new RegexLeaf(":"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("DISPLAY", "(\\S*+)"))), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeArg(CompositeDiagram diagram, LineLocation location, RegexResult arg) {
        IEntity cl1 = diagram.getOrCreateLeaf(Code.of(arg.get("ENT1", 0)), null, null);
        IEntity cl2 = diagram.getOrCreateLeaf(Code.of(arg.get("ENT2", 0)), null, null);
        String deco1 = arg.get("DECO1", 0);
        String deco2 = arg.get("DECO2", 0);
        LinkType linkType = new LinkType(this.getLinkDecor(deco1), this.getLinkDecor(deco2));
        String queue = arg.get("QUEUE", 0);
        Link link = new Link(cl1, cl2, linkType, Display.getWithNewlines(arg.get("DISPLAY", 0)), queue.length(), diagram.getSkinParam().getCurrentStyleBuilder());
        diagram.addLink(link);
        return CommandExecutionResult.ok();
    }

    private LinkDecor getLinkDecor(String s) {
        if ("[]".equals(s)) {
            return LinkDecor.SQUARRE_toberemoved;
        }
        return LinkDecor.NONE;
    }
}

