/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.geom.kinetic;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sourceforge.plantuml.geom.kinetic.Point2DCharge;
import net.sourceforge.plantuml.geom.kinetic.Quadrant;

public class QuadrantMapper {
    private final Map<Point2DCharge, Quadrant> quadrants = new HashMap<Point2DCharge, Quadrant>();
    private final Map<Quadrant, HashSet<Point2DCharge>> setOfPoints = new HashMap<Quadrant, HashSet<Point2DCharge>>();

    public void addPoint(Point2DCharge pt) {
        if (this.quadrants.containsKey(pt)) {
            throw new IllegalArgumentException();
        }
        Quadrant q = new Quadrant(pt);
        this.quadrants.put(pt, q);
        this.getSetOfPoints(q).add(pt);
        assert (this.getSetOfPoints(q).contains(pt));
        assert (this.getSetOfPoints(new Quadrant(pt)).contains(pt));
    }

    public Set<Point2DCharge> getAllPoints(Quadrant qt) {
        return Collections.unmodifiableSet(this.getSetOfPoints(qt));
    }

    public Set<Point2DCharge> getAllPoints() {
        assert (this.quadrants.keySet().equals(this.mergeOfSetOfPoints()));
        return Collections.unmodifiableSet(this.quadrants.keySet());
    }

    private Set<Point2DCharge> mergeOfSetOfPoints() {
        HashSet<Point2DCharge> result = new HashSet<Point2DCharge>();
        for (Set set : this.setOfPoints.values()) {
            assert (Collections.disjoint(set, result));
            result.addAll(set);
        }
        return result;
    }

    public void updatePoint(Point2DCharge pt) {
        Quadrant newQ = new Quadrant(pt);
        Quadrant old = this.quadrants.get(pt);
        assert (this.getSetOfPoints(old).contains(pt));
        if (!old.equals(newQ)) {
            assert (!this.getSetOfPoints(newQ).contains(pt));
            assert (this.getSetOfPoints(old).contains(pt));
            boolean remove = this.getSetOfPoints(old).remove(pt);
            assert (remove);
            boolean add = this.getSetOfPoints(newQ).add(pt);
            assert (add);
            assert (this.getSetOfPoints(newQ).contains(pt));
            assert (!this.getSetOfPoints(old).contains(pt));
            this.quadrants.put(pt, newQ);
        }
        assert (this.getSetOfPoints(new Quadrant(pt)).contains(pt));
    }

    private HashSet<Point2DCharge> getSetOfPoints(Quadrant q) {
        HashSet<Point2DCharge> result = this.setOfPoints.get(q);
        if (result == null) {
            result = new HashSet();
            this.setOfPoints.put(q, result);
        }
        return result;
    }
}

