/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project3;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import net.sourceforge.plantuml.project3.ComplementColors;
import net.sourceforge.plantuml.project3.Instant;
import net.sourceforge.plantuml.project3.InstantDay;
import net.sourceforge.plantuml.project3.Load;
import net.sourceforge.plantuml.project3.LoadInDays;
import net.sourceforge.plantuml.project3.LoadPlanable;
import net.sourceforge.plantuml.project3.PlanUtils;
import net.sourceforge.plantuml.project3.Resource;
import net.sourceforge.plantuml.project3.Solver3;
import net.sourceforge.plantuml.project3.Task;
import net.sourceforge.plantuml.project3.TaskAttribute;
import net.sourceforge.plantuml.project3.TaskCode;
import net.sourceforge.plantuml.project3.TaskDraw;

public class TaskImpl
implements Task,
LoadPlanable {
    private final TaskCode code;
    private final Solver3 solver;
    private final Map<Resource, Integer> resources2 = new LinkedHashMap<Resource, Integer>();
    private final LoadPlanable defaultPlan;
    private boolean diamond;
    private TaskDraw taskDraw;
    private ComplementColors colors;

    public TaskImpl(TaskCode code, LoadPlanable defaultPlan) {
        this.code = code;
        this.defaultPlan = defaultPlan;
        this.solver = new Solver3(this);
        this.setStart(new InstantDay(0));
        this.setLoad(LoadInDays.inDay(1));
    }

    @Override
    public int getLoadAt(Instant instant) {
        LoadPlanable result = this.defaultPlan;
        if (this.resources2.size() > 0) {
            result = PlanUtils.multiply(this.defaultPlan, this.getRessourcePlan());
        }
        return result.getLoadAt(instant);
    }

    public int loadForResource(Resource res, Instant instant) {
        if (this.resources2.keySet().contains(res) && instant.compareTo(this.getStart()) >= 0 && instant.compareTo(this.getEnd()) <= 0) {
            if (res.isClosedAt(instant)) {
                return 0;
            }
            return this.resources2.get(res);
        }
        return 0;
    }

    private LoadPlanable getRessourcePlan() {
        if (this.resources2.size() == 0) {
            throw new IllegalStateException();
        }
        return new LoadPlanable(){

            @Override
            public int getLoadAt(Instant instant) {
                int result = 0;
                for (Map.Entry ent : TaskImpl.this.resources2.entrySet()) {
                    Resource res = (Resource)ent.getKey();
                    if (res.isClosedAt(instant)) continue;
                    int percentage = (Integer)ent.getValue();
                    result += percentage;
                }
                return result;
            }
        };
    }

    public String getPrettyDisplay() {
        if (this.resources2.size() > 0) {
            StringBuilder result = new StringBuilder(this.code.getSimpleDisplay());
            result.append(" ");
            Iterator<Map.Entry<Resource, Integer>> it = this.resources2.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Resource, Integer> ent = it.next();
                result.append("{");
                result.append(ent.getKey().getName());
                int percentage = ent.getValue();
                if (percentage != 100) {
                    result.append(":" + percentage + "%");
                }
                result.append("}");
                if (!it.hasNext()) continue;
                result.append(" ");
            }
            return result.toString();
        }
        return this.code.getSimpleDisplay();
    }

    public String toString() {
        return this.code.toString();
    }

    public String debug() {
        return "" + this.getStart() + " ---> " + this.getEnd() + "   [" + this.getLoad() + "]";
    }

    @Override
    public TaskCode getCode() {
        return this.code;
    }

    @Override
    public Instant getStart() {
        Instant result = (Instant)this.solver.getData(TaskAttribute.START);
        while (this.getLoadAt(result) == 0) {
            result = result.increment();
        }
        return result;
    }

    @Override
    public Instant getEnd() {
        return (Instant)this.solver.getData(TaskAttribute.END);
    }

    @Override
    public Load getLoad() {
        return (Load)this.solver.getData(TaskAttribute.LOAD);
    }

    @Override
    public void setLoad(Load load) {
        this.solver.setData(TaskAttribute.LOAD, load);
    }

    @Override
    public void setStart(Instant start) {
        this.solver.setData(TaskAttribute.START, start);
    }

    @Override
    public void setEnd(Instant end) {
        this.solver.setData(TaskAttribute.END, end);
    }

    @Override
    public void setTaskDraw(TaskDraw taskDraw) {
        taskDraw.setColors(this.colors);
        this.taskDraw = taskDraw;
    }

    @Override
    public TaskDraw getTaskDraw() {
        return this.taskDraw;
    }

    @Override
    public void setColors(ComplementColors colors) {
        this.colors = colors;
    }

    @Override
    public void addResource(Resource resource, int percentage) {
        this.resources2.put(resource, percentage);
    }

    @Override
    public void setDiamond(boolean diamond) {
        this.diamond = diamond;
    }

    @Override
    public boolean isDiamond() {
        return this.diamond;
    }
}

