/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project3;

import java.util.Arrays;
import java.util.Collection;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOptional;
import net.sourceforge.plantuml.command.regex.RegexOr;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.project3.Complement;
import net.sourceforge.plantuml.project3.ComplementDate;
import net.sourceforge.plantuml.project3.ComplementPattern;
import net.sourceforge.plantuml.project3.DayAsDate;
import net.sourceforge.plantuml.project3.GanttDiagram;
import net.sourceforge.plantuml.project3.Subject;
import net.sourceforge.plantuml.project3.Verb;
import net.sourceforge.plantuml.project3.VerbPattern;

public class VerbProjectStarts
implements VerbPattern {
    @Override
    public Collection<ComplementPattern> getComplements() {
        return Arrays.asList(new ComplementDate());
    }

    public IRegex toRegexOld() {
        return new RegexLeaf("starts[%s]*(the[%s]*|on[%s]*)*");
    }

    @Override
    public IRegex toRegex() {
        return new RegexConcat(new RegexLeaf("start"), new RegexOptional((IRegex)new RegexLeaf("s")), RegexLeaf.spaceZeroOrMore(), new RegexOptional((IRegex)new RegexOr(new RegexLeaf("on"), new RegexLeaf("for"), new RegexLeaf("the"), new RegexLeaf("at"))));
    }

    @Override
    public Verb getVerb(final GanttDiagram project, RegexResult arg) {
        return new Verb(){

            @Override
            public CommandExecutionResult execute(Subject subject, Complement complement) {
                DayAsDate start = (DayAsDate)complement;
                assert (project == subject);
                project.setStartingDate(start);
                return CommandExecutionResult.ok();
            }
        };
    }
}

