/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import java.awt.geom.Dimension2D;
import java.util.Collection;
import java.util.HashSet;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.Guillemet;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.SkinParamUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.cucadiagram.BodyEnhanced;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.EntityPortion;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.PortionShower;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.SkinParameter;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.Margins;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.ugraphic.UComment;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.utils.MathUtils;

public class EntityImageDescription
extends AbstractEntityImage {
    private final ShapeType shapeType;
    private final Url url;
    private final TextBlock asSmall;
    private final TextBlock name;
    private final TextBlock desc;
    private TextBlock stereo;
    private final boolean hideText;
    private final Collection<Link> links;
    private final boolean useRankSame;
    private final boolean fixCircleLabelOverlapping;

    public EntityImageDescription(ILeaf entity, ISkinParam skinParam, PortionShower portionShower, Collection<Link> links) {
        super(entity, entity.getColors(skinParam).mute(skinParam));
        this.useRankSame = skinParam.useRankSame();
        this.fixCircleLabelOverlapping = skinParam.fixCircleLabelOverlapping();
        this.links = links;
        Stereotype stereotype = entity.getStereotype();
        USymbol symbol = this.getUSymbol(entity);
        this.shapeType = symbol == USymbol.FOLDER ? ShapeType.FOLDER : (symbol == USymbol.INTERFACE ? (skinParam.fixCircleLabelOverlapping() ? ShapeType.RECTANGLE_WITH_CIRCLE_INSIDE : ShapeType.RECTANGLE) : ShapeType.RECTANGLE);
        this.hideText = symbol == USymbol.INTERFACE;
        Display codeDisplay = Display.getWithNewlines(entity.getCode());
        this.desc = entity.getDisplay().equals(codeDisplay) && symbol.getSkinParameter() == SkinParameter.PACKAGE || entity.getDisplay().isWhite() ? TextBlockUtils.empty(0.0, 0.0) : new BodyEnhanced(entity.getDisplay(), symbol.getFontParam(), this.getSkinParam(), HorizontalAlignment.LEFT, stereotype, symbol.manageHorizontalLine(), false, entity);
        this.url = entity.getUrl99();
        Colors colors = entity.getColors(skinParam);
        HtmlColor backcolor = colors.getColor(ColorType.BACK);
        if (backcolor == null) {
            backcolor = SkinParamUtils.getColor(this.getSkinParam(), this.getStereo(), symbol.getColorParamBack());
        }
        assert (this.getStereo() == stereotype);
        HtmlColor forecolor = SkinParamUtils.getColor(this.getSkinParam(), stereotype, symbol.getColorParamBorder());
        double roundCorner = symbol.getSkinParameter().getRoundCorner(this.getSkinParam(), stereotype);
        double diagonalCorner = symbol.getSkinParameter().getDiagonalCorner(this.getSkinParam(), stereotype);
        UStroke stroke = colors.muteStroke(symbol.getSkinParameter().getStroke(this.getSkinParam(), stereotype));
        SymbolContext ctx = new SymbolContext(backcolor, forecolor).withStroke(stroke).withShadow(this.getSkinParam().shadowing2(this.getEntity().getStereotype(), symbol.getSkinParameter()) ? 3.0 : 0.0).withCorner(roundCorner, diagonalCorner);
        this.stereo = TextBlockUtils.empty(0.0, 0.0);
        if (stereotype != null && stereotype.getSprite(this.getSkinParam()) != null) {
            this.stereo = stereotype.getSprite(this.getSkinParam());
        } else if (stereotype != null && stereotype.getLabel(Guillemet.DOUBLE_COMPARATOR) != null && portionShower.showPortion(EntityPortion.STEREOTYPE, entity)) {
            this.stereo = Display.getWithNewlines(stereotype.getLabel(this.getSkinParam().guillemet())).create(new FontConfiguration(this.getSkinParam(), symbol.getFontParamStereotype(), stereotype), HorizontalAlignment.CENTER, this.getSkinParam());
        }
        this.name = new BodyEnhanced(codeDisplay, symbol.getFontParam(), this.getSkinParam(), HorizontalAlignment.CENTER, stereotype, symbol.manageHorizontalLine(), false, entity);
        this.asSmall = this.hideText ? symbol.asSmall(TextBlockUtils.empty(0.0, 0.0), TextBlockUtils.empty(0.0, 0.0), TextBlockUtils.empty(0.0, 0.0), ctx, skinParam.getStereotypeAlignment()) : symbol.asSmall(this.name, this.desc, this.stereo, ctx, skinParam.getStereotypeAlignment());
    }

    private USymbol getUSymbol(ILeaf entity) {
        USymbol result;
        USymbol uSymbol = entity.getUSymbol() == null ? (this.getSkinParam().useUml2ForComponent() ? USymbol.COMPONENT2 : USymbol.COMPONENT1) : (result = entity.getUSymbol());
        if (result == null) {
            throw new IllegalArgumentException();
        }
        return result;
    }

    public Dimension2D getNameDimension(StringBounder stringBounder) {
        if (this.hideText) {
            return new Dimension2DDouble(0.0, 0.0);
        }
        return this.name.calculateDimension(stringBounder);
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return this.asSmall.calculateDimension(stringBounder);
    }

    @Override
    public Margins getShield(StringBounder stringBounder) {
        if (!this.hideText) {
            return Margins.NONE;
        }
        if (this.isThereADoubleLink((ILeaf)this.getEntity(), this.links)) {
            return Margins.NONE;
        }
        if (!this.fixCircleLabelOverlapping && this.hasSomeHorizontalLinkVisible((ILeaf)this.getEntity(), this.links)) {
            return Margins.NONE;
        }
        if (this.hasSomeHorizontalLinkDoubleDecorated((ILeaf)this.getEntity(), this.links)) {
            return Margins.NONE;
        }
        Dimension2D dimStereo = this.stereo.calculateDimension(stringBounder);
        Dimension2D dimDesc = this.desc.calculateDimension(stringBounder);
        Dimension2D dimSmall = this.asSmall.calculateDimension(stringBounder);
        double x = Math.max(dimStereo.getWidth(), dimDesc.getWidth());
        double suppX = x - dimSmall.getWidth();
        if (suppX < 1.0) {
            suppX = 1.0;
        }
        double y = MathUtils.max(1.0, dimDesc.getHeight(), dimStereo.getHeight());
        return new Margins(suppX / 2.0, suppX / 2.0, y, y);
    }

    private boolean hasSomeHorizontalLinkVisible(ILeaf leaf, Collection<Link> links) {
        for (Link link : links) {
            if (link.getLength() != 1 || !link.contains(leaf) || link.isInvis()) continue;
            return true;
        }
        return false;
    }

    private boolean isThereADoubleLink(ILeaf leaf, Collection<Link> links) {
        HashSet<IEntity> others = new HashSet<IEntity>();
        for (Link link : links) {
            IEntity other;
            boolean changed;
            if (!link.contains(leaf) || (changed = others.add(other = link.getOther(leaf)))) continue;
            return true;
        }
        return false;
    }

    private boolean hasSomeHorizontalLinkDoubleDecorated(ILeaf leaf, Collection<Link> links) {
        for (Link link : links) {
            if (link.getLength() != 1 || !link.contains(leaf) || !link.getType().isDoubleDecorated()) continue;
            return true;
        }
        return false;
    }

    @Override
    public final void drawU(UGraphic ug) {
        ug.draw(new UComment("entity " + this.getEntity().getCode().getFullName()));
        if (this.url != null) {
            ug.startUrl(this.url);
        }
        this.asSmall.drawU(ug);
        if (this.hideText) {
            double space = 8.0;
            Dimension2D dimSmall = this.asSmall.calculateDimension(ug.getStringBounder());
            Dimension2D dimDesc = this.desc.calculateDimension(ug.getStringBounder());
            double posx1 = (dimSmall.getWidth() - dimDesc.getWidth()) / 2.0;
            this.desc.drawU(ug.apply(new UTranslate(posx1, 8.0 + dimSmall.getHeight())));
            Dimension2D dimStereo = this.stereo.calculateDimension(ug.getStringBounder());
            double posx2 = (dimSmall.getWidth() - dimStereo.getWidth()) / 2.0;
            this.stereo.drawU(ug.apply(new UTranslate(posx2, -8.0 - dimStereo.getHeight())));
        }
        if (this.url != null) {
            ug.closeAction();
        }
    }

    @Override
    public ShapeType getShapeType() {
        return this.shapeType;
    }

    @Override
    public double getOverscanX(StringBounder stringBounder) {
        if (this.hideText) {
            Dimension2D dimSmall = this.asSmall.calculateDimension(stringBounder);
            Dimension2D dimDesc = this.desc.calculateDimension(stringBounder);
            Dimension2D dimStereo = this.stereo.calculateDimension(stringBounder);
            double posx1 = (dimSmall.getWidth() - dimDesc.getWidth()) / 2.0;
            double posx2 = (dimSmall.getWidth() - dimStereo.getWidth()) / 2.0;
            return MathUtils.max(-posx1, -posx2, 0.0);
        }
        return 0.0;
    }
}

