/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.timingdiagram;

import java.math.BigDecimal;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOptional;
import net.sourceforge.plantuml.command.regex.RegexOr;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.timingdiagram.Clocks;
import net.sourceforge.plantuml.timingdiagram.TimeTick;
import net.sourceforge.plantuml.timingdiagram.TimingFormat;

public class TimeTickBuilder {
    public static IRegex expressionAtWithoutArobase(String name) {
        return new RegexOr(new RegexLeaf(name + "DATE", "(\\d+)/(\\d+)/(\\d+)"), new RegexLeaf(name + "HOUR", "(\\d+):(\\d+):(\\d+)"), new RegexLeaf(name + "DIGIT", "(\\+?)(-?\\d+\\.?\\d*)"), new RegexLeaf(name + "CLOCK", "([\\p{L}0-9_.@]+)\\*(\\d+)"));
    }

    public static IRegex expressionAtWithArobase(String name) {
        return new RegexConcat(new RegexLeaf("@"), TimeTickBuilder.expressionAtWithoutArobase(name));
    }

    public static IRegex optionalExpressionAtWithArobase(String name) {
        return new RegexOptional(TimeTickBuilder.expressionAtWithArobase(name));
    }

    public static TimeTick parseTimeTick(String name, RegexResult arg, Clocks clock) {
        String clockName = arg.get(name + "CLOCK", 0);
        if (clockName != null) {
            int number = Integer.parseInt(arg.get(name + "CLOCK", 1));
            return clock.getClockValue(clockName, number);
        }
        String hour = arg.get(name + "HOUR", 0);
        if (hour != null) {
            int h = Integer.parseInt(arg.get(name + "HOUR", 0));
            int m = Integer.parseInt(arg.get(name + "HOUR", 1));
            int s = Integer.parseInt(arg.get(name + "HOUR", 2));
            BigDecimal value = new BigDecimal(3600 * h + 60 * m + s);
            return new TimeTick(value, TimingFormat.HOUR);
        }
        String date = arg.get(name + "DATE", 0);
        if (date != null) {
            int yy = Integer.parseInt(arg.get(name + "DATE", 0));
            int mm = Integer.parseInt(arg.get(name + "DATE", 1));
            int dd = Integer.parseInt(arg.get(name + "DATE", 2));
            return TimingFormat.createDate(yy, mm, dd);
        }
        String number = arg.get(name + "DIGIT", 1);
        if (number == null) {
            return clock.getNow();
        }
        boolean isRelative = "+".equals(arg.get(name + "DIGIT", 0));
        BigDecimal value = new BigDecimal(number);
        if (isRelative) {
            value = clock.getNow().getTime().add(value);
        }
        return new TimeTick(value, TimingFormat.DECIMAL);
    }
}

