/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.util;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import net.sf.sdedit.util.CollectionState;

public class ListModelAdapter
implements ListModel,
CollectionState.CollectionStateChangeListener {
    private List<ListDataListener> listeners = new LinkedList<ListDataListener>();
    private CollectionState collectionState = new CollectionState();
    private Object[] data;

    public ListModelAdapter() {
        this.collectionState.addListener(this);
    }

    public void setData(Collection<?> data) {
        this.data = data.toArray();
        this.collectionState.update(data);
    }

    @Override
    public void addListDataListener(ListDataListener l) {
        this.listeners.add(l);
    }

    public Object[] getData() {
        return this.data;
    }

    public Object getElementAt(int index) {
        return this.data[index];
    }

    @Override
    public int getSize() {
        if (this.data == null) {
            return 0;
        }
        return this.data.length;
    }

    @Override
    public void removeListDataListener(ListDataListener l) {
        this.listeners.remove(l);
    }

    @Override
    public void itemsAdded(int[] indices) {
        ListDataEvent lde = new ListDataEvent(this, 1, indices[0], indices[indices.length - 1]);
        for (ListDataListener listener : this.listeners) {
            listener.intervalAdded(lde);
        }
    }

    @Override
    public void itemsChanged(int[] indices) {
        for (ListDataListener listener : this.listeners) {
            for (int i : indices) {
                ListDataEvent lde = new ListDataEvent(this, 0, i, i);
                listener.contentsChanged(lde);
            }
        }
    }

    @Override
    public void itemsRemoved(int[] indices) {
        ListDataEvent lde = new ListDataEvent(this, 2, indices[0], indices[indices.length - 1]);
        for (ListDataListener listener : this.listeners) {
            listener.intervalRemoved(lde);
        }
    }
}

