//
// Copyright (c) ZeroC, Inc. All rights reserved.
//
//
// Ice version 3.7.3
//
// <auto-generated>
//
// Generated from file `RemoteLogger.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

#ifndef __Ice_RemoteLogger_h__
#define __Ice_RemoteLogger_h__

#include <IceUtil/PushDisableWarnings.h>
#include <Ice/ProxyF.h>
#include <Ice/ObjectF.h>
#include <Ice/ValueF.h>
#include <Ice/Exception.h>
#include <Ice/LocalObject.h>
#include <Ice/StreamHelpers.h>
#include <Ice/Comparable.h>
#include <Ice/Proxy.h>
#include <Ice/Object.h>
#include <Ice/GCObject.h>
#include <Ice/Value.h>
#include <Ice/Incoming.h>
#include <Ice/FactoryTableInit.h>
#include <IceUtil/ScopedArray.h>
#include <Ice/Optional.h>
#include <Ice/ExceptionHelpers.h>
#include <Ice/BuiltinSequences.h>
#include <IceUtil/UndefSysMacros.h>
#include <list>

#ifndef ICE_IGNORE_VERSION
#   if ICE_INT_VERSION / 100 != 307
#       error Ice version mismatch!
#   endif
#   if ICE_INT_VERSION % 100 >= 50
#       error Beta header file detected
#   endif
#   if ICE_INT_VERSION % 100 < 3
#       error Ice patch level mismatch!
#   endif
#endif

#ifndef ICE_API
#   if defined(ICE_STATIC_LIBS)
#       define ICE_API /**/
#   elif defined(ICE_API_EXPORTS)
#       define ICE_API ICE_DECLSPEC_EXPORT
#   else
#       define ICE_API ICE_DECLSPEC_IMPORT
#   endif
#endif

#ifdef ICE_CPP11_MAPPING // C++11 mapping

namespace Ice
{

class RemoteLogger;
class RemoteLoggerPrx;
class LoggerAdmin;
class LoggerAdminPrx;

}

namespace Ice
{

/**
 * An enumeration representing the different types of log messages.
 */
enum class LogMessageType : unsigned char
{
    /**
     * The {@link Logger} received a print message.
     */
    PrintMessage,
    /**
     * The {@link Logger} received a trace message.
     */
    TraceMessage,
    /**
     * The {@link Logger} received a warning message.
     */
    WarningMessage,
    /**
     * The {@link Logger} received an error message.
     */
    ErrorMessage
};

/**
 * A sequence of {@link LogMessageType}
 */
using LogMessageTypeSeq = ::std::vector<LogMessageType>;

/**
 * A complete log message.
 * \headerfile Ice/Ice.h
 */
struct LogMessage
{
    /**
     * The type of message sent to the {@link Logger}.
     */
    ::Ice::LogMessageType type;
    /**
     * The date and time when the {@link Logger} received this message, expressed
     * as the number of microseconds since the Unix Epoch (00:00:00 UTC on 1 January 1970)
     */
    long long int timestamp;
    /**
     * For a message of type trace, the trace category of this log message;
     * otherwise, the empty string.
     */
    ::std::string traceCategory;
    /**
     * The log message itself.
     */
    ::std::string message;

    /**
     * Obtains a tuple containing all of the struct's data members.
     * @return The data members in a tuple.
     */
    std::tuple<const ::Ice::LogMessageType&, const long long int&, const ::std::string&, const ::std::string&> ice_tuple() const
    {
        return std::tie(type, timestamp, traceCategory, message);
    }
};

/**
 * A sequence of {@link LogMessage}.
 */
using LogMessageSeq = std::list<LogMessage>;

/**
 * Thrown when the provided RemoteLogger was previously attached to a LoggerAdmin.
 * \headerfile Ice/Ice.h
 */
class ICE_CLASS(ICE_API) RemoteLoggerAlreadyAttachedException : public UserExceptionHelper<RemoteLoggerAlreadyAttachedException, UserException>
{
public:

    ICE_MEMBER(ICE_API) virtual ~RemoteLoggerAlreadyAttachedException();

    RemoteLoggerAlreadyAttachedException(const RemoteLoggerAlreadyAttachedException&) = default;

    RemoteLoggerAlreadyAttachedException() = default;

    /**
     * Obtains a tuple containing all of the exception's data members.
     * @return The data members in a tuple.
     */
    std::tuple<> ice_tuple() const
    {
        return std::tie();
    }

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();
};

/// \cond INTERNAL
static RemoteLoggerAlreadyAttachedException _iceS_RemoteLoggerAlreadyAttachedException_init;
/// \endcond

using Ice::operator<;
using Ice::operator<=;
using Ice::operator>;
using Ice::operator>=;
using Ice::operator==;
using Ice::operator!=;

}

namespace Ice
{

/**
 * The Ice remote logger interface. An application can implement a
 * RemoteLogger to receive the log messages sent to the local {@link Logger}
 * of another Ice application.
 * \headerfile Ice/Ice.h
 */
class ICE_API RemoteLogger : public virtual Object
{
public:

    using ProxyType = RemoteLoggerPrx;

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(::std::string id, const Current& current) const override;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector<::std::string> ice_ids(const Current& current) const override;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual ::std::string ice_id(const Current& current) const override;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * init is called by attachRemoteLogger when a RemoteLogger proxy is attached.
     * @param prefix The prefix of the associated local Logger.
     * @param logMessages Old log messages generated before "now".
     * @param current The Current object for the invocation.
     */
    virtual void init(::std::string prefix, LogMessageSeq logMessages, const Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_init(::IceInternal::Incoming&, const Current&);
    /// \endcond

    /**
     * Log a LogMessage. Note that log may be called by LoggerAdmin before init.
     * @param message The message to log.
     * @param current The Current object for the invocation.
     */
    virtual void log(LogMessage message, const Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_log(::IceInternal::Incoming&, const Current&);
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const Current&) override;
    /// \endcond
};

/**
 * The interface of the admin object that allows an Ice application the attach its
 * {@link RemoteLogger} to the {@link Logger} of this admin object's Ice communicator.
 * \headerfile Ice/Ice.h
 */
class ICE_API LoggerAdmin : public virtual Object
{
public:

    using ProxyType = LoggerAdminPrx;

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(::std::string id, const Current& current) const override;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector<::std::string> ice_ids(const Current& current) const override;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual ::std::string ice_id(const Current& current) const override;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Attaches a RemoteLogger object to the local logger.
     * attachRemoteLogger calls init on the provided RemoteLogger proxy.
     * @param prx A proxy to the remote logger.
     * @param messageTypes The list of message types that the remote logger wishes to receive.
     * An empty list means no filtering (send all message types).
     * @param traceCategories The categories of traces that the remote logger wishes to receive.
     * This parameter is ignored if messageTypes is not empty and does not include trace.
     * An empty list means no filtering (send all trace categories).
     * @param messageMax The maximum number of log messages (of all types) to be provided
     * to init. A negative value requests all messages available.
     * @param current The Current object for the invocation.
     * @throws Ice::RemoteLoggerAlreadyAttachedException Raised if this remote logger is already
     * attached to this admin object.
     */
    virtual void attachRemoteLogger(::std::shared_ptr<RemoteLoggerPrx> prx, LogMessageTypeSeq messageTypes, StringSeq traceCategories, int messageMax, const Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_attachRemoteLogger(::IceInternal::Incoming&, const Current&);
    /// \endcond

    /**
     * Detaches a RemoteLogger object from the local logger.
     * @param prx A proxy to the remote logger.
     * @param current The Current object for the invocation.
     * @return True if the provided remote logger proxy was detached, and false otherwise.
     */
    virtual bool detachRemoteLogger(::std::shared_ptr<RemoteLoggerPrx> prx, const Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_detachRemoteLogger(::IceInternal::Incoming&, const Current&);
    /// \endcond

    /**
     * Encapsulates the results of a call to getLog.
     */
    struct GetLogResult
    {
        /** The Log messages. */
        LogMessageSeq returnValue;
        /** The prefix of the associated local logger. */
        ::std::string prefix;
    };

    /**
     * Retrieves log messages recently logged.
     * @param messageTypes The list of message types that the caller wishes to receive.
     * An empty list means no filtering (send all message types).
     * @param traceCategories The categories of traces that caller wish to receive.
     * This parameter is ignored if messageTypes is not empty and does not include trace.
     * An empty list means no filtering (send all trace categories).
     * @param messageMax The maximum number of log messages (of all types) to be returned.
     * A negative value requests all messages available.
     * @param prefix The prefix of the associated local logger.
     * @param current The Current object for the invocation.
     * @return The Log messages.
     */
    virtual LogMessageSeq getLog(LogMessageTypeSeq messageTypes, StringSeq traceCategories, int messageMax, ::std::string& prefix, const Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_getLog(::IceInternal::Incoming&, const Current&);
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const Current&) override;
    /// \endcond
};

}

namespace Ice
{

/**
 * The Ice remote logger interface. An application can implement a
 * RemoteLogger to receive the log messages sent to the local {@link Logger}
 * of another Ice application.
 * \headerfile Ice/Ice.h
 */
class ICE_CLASS(ICE_API) RemoteLoggerPrx : public virtual Proxy<RemoteLoggerPrx, ObjectPrx>
{
public:

    /**
     * init is called by attachRemoteLogger when a RemoteLogger proxy is attached.
     * @param prefix The prefix of the associated local Logger.
     * @param logMessages Old log messages generated before "now".
     * @param context The Context map to send with the invocation.
     */
    void init(const ::std::string& prefix, const LogMessageSeq& logMessages, const Context& context = noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &RemoteLoggerPrx::_iceI_init, prefix, logMessages, context).get();
    }

    /**
     * init is called by attachRemoteLogger when a RemoteLogger proxy is attached.
     * @param prefix The prefix of the associated local Logger.
     * @param logMessages Old log messages generated before "now".
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto initAsync(const ::std::string& prefix, const LogMessageSeq& logMessages, const Context& context = noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &RemoteLoggerPrx::_iceI_init, prefix, logMessages, context);
    }

    /**
     * init is called by attachRemoteLogger when a RemoteLogger proxy is attached.
     * @param prefix The prefix of the associated local Logger.
     * @param logMessages Old log messages generated before "now".
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    initAsync(const ::std::string& prefix, const LogMessageSeq& logMessages,
              ::std::function<void()> response,
              ::std::function<void(::std::exception_ptr)> ex = nullptr,
              ::std::function<void(bool)> sent = nullptr,
              const Context& context = noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(response, ex, sent, this, &Ice::RemoteLoggerPrx::_iceI_init, prefix, logMessages, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICE_API) void _iceI_init(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::std::string&, const LogMessageSeq&, const Context&);
    /// \endcond

    /**
     * Log a LogMessage. Note that log may be called by LoggerAdmin before init.
     * @param message The message to log.
     * @param context The Context map to send with the invocation.
     */
    void log(const LogMessage& message, const Context& context = noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &RemoteLoggerPrx::_iceI_log, message, context).get();
    }

    /**
     * Log a LogMessage. Note that log may be called by LoggerAdmin before init.
     * @param message The message to log.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto logAsync(const LogMessage& message, const Context& context = noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &RemoteLoggerPrx::_iceI_log, message, context);
    }

    /**
     * Log a LogMessage. Note that log may be called by LoggerAdmin before init.
     * @param message The message to log.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    logAsync(const LogMessage& message,
             ::std::function<void()> response,
             ::std::function<void(::std::exception_ptr)> ex = nullptr,
             ::std::function<void(bool)> sent = nullptr,
             const Context& context = noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(response, ex, sent, this, &Ice::RemoteLoggerPrx::_iceI_log, message, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICE_API) void _iceI_log(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const LogMessage&, const Context&);
    /// \endcond

    /**
     * Obtains the Slice type ID of this interface.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();

protected:

    /// \cond INTERNAL
    RemoteLoggerPrx() = default;
    friend ::std::shared_ptr<RemoteLoggerPrx> IceInternal::createProxy<RemoteLoggerPrx>();

    ICE_MEMBER(ICE_API) virtual ::std::shared_ptr<ObjectPrx> _newInstance() const override;
    /// \endcond
};

/**
 * The interface of the admin object that allows an Ice application the attach its
 * {@link RemoteLogger} to the {@link Logger} of this admin object's Ice communicator.
 * \headerfile Ice/Ice.h
 */
class ICE_CLASS(ICE_API) LoggerAdminPrx : public virtual Proxy<LoggerAdminPrx, ObjectPrx>
{
public:

    /**
     * Attaches a RemoteLogger object to the local logger.
     * attachRemoteLogger calls init on the provided RemoteLogger proxy.
     * @param prx A proxy to the remote logger.
     * @param messageTypes The list of message types that the remote logger wishes to receive.
     * An empty list means no filtering (send all message types).
     * @param traceCategories The categories of traces that the remote logger wishes to receive.
     * This parameter is ignored if messageTypes is not empty and does not include trace.
     * An empty list means no filtering (send all trace categories).
     * @param messageMax The maximum number of log messages (of all types) to be provided
     * to init. A negative value requests all messages available.
     * @param context The Context map to send with the invocation.
     * @throws Ice::RemoteLoggerAlreadyAttachedException Raised if this remote logger is already
     * attached to this admin object.
     */
    void attachRemoteLogger(const ::std::shared_ptr<RemoteLoggerPrx>& prx, const LogMessageTypeSeq& messageTypes, const StringSeq& traceCategories, int messageMax, const Context& context = noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &LoggerAdminPrx::_iceI_attachRemoteLogger, prx, messageTypes, traceCategories, messageMax, context).get();
    }

    /**
     * Attaches a RemoteLogger object to the local logger.
     * attachRemoteLogger calls init on the provided RemoteLogger proxy.
     * @param prx A proxy to the remote logger.
     * @param messageTypes The list of message types that the remote logger wishes to receive.
     * An empty list means no filtering (send all message types).
     * @param traceCategories The categories of traces that the remote logger wishes to receive.
     * This parameter is ignored if messageTypes is not empty and does not include trace.
     * An empty list means no filtering (send all trace categories).
     * @param messageMax The maximum number of log messages (of all types) to be provided
     * to init. A negative value requests all messages available.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto attachRemoteLoggerAsync(const ::std::shared_ptr<RemoteLoggerPrx>& prx, const LogMessageTypeSeq& messageTypes, const StringSeq& traceCategories, int messageMax, const Context& context = noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &LoggerAdminPrx::_iceI_attachRemoteLogger, prx, messageTypes, traceCategories, messageMax, context);
    }

    /**
     * Attaches a RemoteLogger object to the local logger.
     * attachRemoteLogger calls init on the provided RemoteLogger proxy.
     * @param prx A proxy to the remote logger.
     * @param messageTypes The list of message types that the remote logger wishes to receive.
     * An empty list means no filtering (send all message types).
     * @param traceCategories The categories of traces that the remote logger wishes to receive.
     * This parameter is ignored if messageTypes is not empty and does not include trace.
     * An empty list means no filtering (send all trace categories).
     * @param messageMax The maximum number of log messages (of all types) to be provided
     * to init. A negative value requests all messages available.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    attachRemoteLoggerAsync(const ::std::shared_ptr<RemoteLoggerPrx>& prx, const LogMessageTypeSeq& messageTypes, const StringSeq& traceCategories, int messageMax,
                            ::std::function<void()> response,
                            ::std::function<void(::std::exception_ptr)> ex = nullptr,
                            ::std::function<void(bool)> sent = nullptr,
                            const Context& context = noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(response, ex, sent, this, &Ice::LoggerAdminPrx::_iceI_attachRemoteLogger, prx, messageTypes, traceCategories, messageMax, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICE_API) void _iceI_attachRemoteLogger(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::std::shared_ptr<RemoteLoggerPrx>&, const LogMessageTypeSeq&, const StringSeq&, int, const Context&);
    /// \endcond

    /**
     * Detaches a RemoteLogger object from the local logger.
     * @param prx A proxy to the remote logger.
     * @param context The Context map to send with the invocation.
     * @return True if the provided remote logger proxy was detached, and false otherwise.
     */
    bool detachRemoteLogger(const ::std::shared_ptr<RemoteLoggerPrx>& prx, const Context& context = noExplicitContext)
    {
        return _makePromiseOutgoing<bool>(true, this, &LoggerAdminPrx::_iceI_detachRemoteLogger, prx, context).get();
    }

    /**
     * Detaches a RemoteLogger object from the local logger.
     * @param prx A proxy to the remote logger.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto detachRemoteLoggerAsync(const ::std::shared_ptr<RemoteLoggerPrx>& prx, const Context& context = noExplicitContext)
        -> decltype(::std::declval<P<bool>>().get_future())
    {
        return _makePromiseOutgoing<bool, P>(false, this, &LoggerAdminPrx::_iceI_detachRemoteLogger, prx, context);
    }

    /**
     * Detaches a RemoteLogger object from the local logger.
     * @param prx A proxy to the remote logger.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    detachRemoteLoggerAsync(const ::std::shared_ptr<RemoteLoggerPrx>& prx,
                            ::std::function<void(bool)> response,
                            ::std::function<void(::std::exception_ptr)> ex = nullptr,
                            ::std::function<void(bool)> sent = nullptr,
                            const Context& context = noExplicitContext)
    {
        return _makeLamdaOutgoing<bool>(response, ex, sent, this, &Ice::LoggerAdminPrx::_iceI_detachRemoteLogger, prx, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICE_API) void _iceI_detachRemoteLogger(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<bool>>&, const ::std::shared_ptr<RemoteLoggerPrx>&, const Context&);
    /// \endcond

    /**
     * Retrieves log messages recently logged.
     * @param messageTypes The list of message types that the caller wishes to receive.
     * An empty list means no filtering (send all message types).
     * @param traceCategories The categories of traces that caller wish to receive.
     * This parameter is ignored if messageTypes is not empty and does not include trace.
     * An empty list means no filtering (send all trace categories).
     * @param messageMax The maximum number of log messages (of all types) to be returned.
     * A negative value requests all messages available.
     * @param prefix The prefix of the associated local logger.
     * @param context The Context map to send with the invocation.
     * @return The Log messages.
     */
    LogMessageSeq getLog(const LogMessageTypeSeq& messageTypes, const StringSeq& traceCategories, int messageMax, ::std::string& prefix, const Context& context = noExplicitContext)
    {
        auto _result = _makePromiseOutgoing<LoggerAdmin::GetLogResult>(true, this, &LoggerAdminPrx::_iceI_getLog, messageTypes, traceCategories, messageMax, context).get();
        prefix = ::std::move(_result.prefix);
        return ::std::move(_result.returnValue);
    }

    /**
     * Retrieves log messages recently logged.
     * @param messageTypes The list of message types that the caller wishes to receive.
     * An empty list means no filtering (send all message types).
     * @param traceCategories The categories of traces that caller wish to receive.
     * This parameter is ignored if messageTypes is not empty and does not include trace.
     * An empty list means no filtering (send all trace categories).
     * @param messageMax The maximum number of log messages (of all types) to be returned.
     * A negative value requests all messages available.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getLogAsync(const LogMessageTypeSeq& messageTypes, const StringSeq& traceCategories, int messageMax, const Context& context = noExplicitContext)
        -> decltype(::std::declval<P<LoggerAdmin::GetLogResult>>().get_future())
    {
        return _makePromiseOutgoing<LoggerAdmin::GetLogResult, P>(false, this, &LoggerAdminPrx::_iceI_getLog, messageTypes, traceCategories, messageMax, context);
    }

    /**
     * Retrieves log messages recently logged.
     * @param messageTypes The list of message types that the caller wishes to receive.
     * An empty list means no filtering (send all message types).
     * @param traceCategories The categories of traces that caller wish to receive.
     * This parameter is ignored if messageTypes is not empty and does not include trace.
     * An empty list means no filtering (send all trace categories).
     * @param messageMax The maximum number of log messages (of all types) to be returned.
     * A negative value requests all messages available.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getLogAsync(const LogMessageTypeSeq& messageTypes, const StringSeq& traceCategories, int messageMax,
                ::std::function<void(::Ice::LogMessageSeq, ::std::string)> response,
                ::std::function<void(::std::exception_ptr)> ex = nullptr,
                ::std::function<void(bool)> sent = nullptr,
                const Context& context = noExplicitContext)
    {
        auto _responseCb = [response](LoggerAdmin::GetLogResult&& _result)
        {
            response(::std::move(_result.returnValue), ::std::move(_result.prefix));
        };
        return _makeLamdaOutgoing<LoggerAdmin::GetLogResult>(_responseCb, ex, sent, this, &Ice::LoggerAdminPrx::_iceI_getLog, messageTypes, traceCategories, messageMax, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICE_API) void _iceI_getLog(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<LoggerAdmin::GetLogResult>>&, const LogMessageTypeSeq&, const StringSeq&, int, const Context&);
    /// \endcond

    /**
     * Obtains the Slice type ID of this interface.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();

protected:

    /// \cond INTERNAL
    LoggerAdminPrx() = default;
    friend ::std::shared_ptr<LoggerAdminPrx> IceInternal::createProxy<LoggerAdminPrx>();

    ICE_MEMBER(ICE_API) virtual ::std::shared_ptr<ObjectPrx> _newInstance() const override;
    /// \endcond
};

}

/// \cond STREAM
namespace Ice
{

template<>
struct StreamableTraits< ::Ice::LogMessageType>
{
    static const StreamHelperCategory helper = StreamHelperCategoryEnum;
    static const int minValue = 0;
    static const int maxValue = 3;
    static const int minWireSize = 1;
    static const bool fixedLength = false;
};

template<>
struct StreamableTraits<::Ice::LogMessage>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 11;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamReader<::Ice::LogMessage, S>
{
    static void read(S* istr, ::Ice::LogMessage& v)
    {
        istr->readAll(v.type, v.timestamp, v.traceCategory, v.message);
    }
};

}
/// \endcond

/// \cond INTERNAL
namespace Ice
{

using RemoteLoggerPtr = ::std::shared_ptr<RemoteLogger>;
using RemoteLoggerPrxPtr = ::std::shared_ptr<RemoteLoggerPrx>;

using LoggerAdminPtr = ::std::shared_ptr<LoggerAdmin>;
using LoggerAdminPrxPtr = ::std::shared_ptr<LoggerAdminPrx>;

}
/// \endcond

#else // C++98 mapping

namespace IceProxy
{

namespace Ice
{

class RemoteLogger;
/// \cond INTERNAL
ICE_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< RemoteLogger>&);
ICE_API ::IceProxy::Ice::Object* upCast(RemoteLogger*);
/// \endcond

class LoggerAdmin;
/// \cond INTERNAL
ICE_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< LoggerAdmin>&);
ICE_API ::IceProxy::Ice::Object* upCast(LoggerAdmin*);
/// \endcond

}

}

namespace Ice
{

class RemoteLogger;
/// \cond INTERNAL
ICE_API Object* upCast(RemoteLogger*);
/// \endcond
typedef ::IceInternal::Handle< RemoteLogger> RemoteLoggerPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::Ice::RemoteLogger> RemoteLoggerPrx;
typedef RemoteLoggerPrx RemoteLoggerPrxPtr;
/// \cond INTERNAL
ICE_API void _icePatchObjectPtr(RemoteLoggerPtr&, const ObjectPtr&);
/// \endcond

class LoggerAdmin;
/// \cond INTERNAL
ICE_API Object* upCast(LoggerAdmin*);
/// \endcond
typedef ::IceInternal::Handle< LoggerAdmin> LoggerAdminPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::Ice::LoggerAdmin> LoggerAdminPrx;
typedef LoggerAdminPrx LoggerAdminPrxPtr;
/// \cond INTERNAL
ICE_API void _icePatchObjectPtr(LoggerAdminPtr&, const ObjectPtr&);
/// \endcond

}

namespace Ice
{

/**
 * An enumeration representing the different types of log messages.
 */
enum LogMessageType
{
    /**
     * The {@link Logger} received a print message.
     */
    PrintMessage,
    /**
     * The {@link Logger} received a trace message.
     */
    TraceMessage,
    /**
     * The {@link Logger} received a warning message.
     */
    WarningMessage,
    /**
     * The {@link Logger} received an error message.
     */
    ErrorMessage
};

/**
 * A sequence of {@link LogMessageType}
 */
typedef ::std::vector<LogMessageType> LogMessageTypeSeq;

/**
 * A complete log message.
 * \headerfile Ice/Ice.h
 */
struct LogMessage
{
    /**
     * The type of message sent to the {@link Logger}.
     */
    ::Ice::LogMessageType type;
    /**
     * The date and time when the {@link Logger} received this message, expressed
     * as the number of microseconds since the Unix Epoch (00:00:00 UTC on 1 January 1970)
     */
    ::Ice::Long timestamp;
    /**
     * For a message of type trace, the trace category of this log message;
     * otherwise, the empty string.
     */
    ::std::string traceCategory;
    /**
     * The log message itself.
     */
    ::std::string message;

    bool operator==(const LogMessage& rhs_) const
    {
        if(this == &rhs_)
        {
            return true;
        }
        if(type != rhs_.type)
        {
            return false;
        }
        if(timestamp != rhs_.timestamp)
        {
            return false;
        }
        if(traceCategory != rhs_.traceCategory)
        {
            return false;
        }
        if(message != rhs_.message)
        {
            return false;
        }
        return true;
    }

    bool operator<(const LogMessage& rhs_) const
    {
        if(this == &rhs_)
        {
            return false;
        }
        if(type < rhs_.type)
        {
            return true;
        }
        else if(rhs_.type < type)
        {
            return false;
        }
        if(timestamp < rhs_.timestamp)
        {
            return true;
        }
        else if(rhs_.timestamp < timestamp)
        {
            return false;
        }
        if(traceCategory < rhs_.traceCategory)
        {
            return true;
        }
        else if(rhs_.traceCategory < traceCategory)
        {
            return false;
        }
        if(message < rhs_.message)
        {
            return true;
        }
        else if(rhs_.message < message)
        {
            return false;
        }
        return false;
    }

    bool operator!=(const LogMessage& rhs_) const
    {
        return !operator==(rhs_);
    }
    bool operator<=(const LogMessage& rhs_) const
    {
        return operator<(rhs_) || operator==(rhs_);
    }
    bool operator>(const LogMessage& rhs_) const
    {
        return !operator<(rhs_) && !operator==(rhs_);
    }
    bool operator>=(const LogMessage& rhs_) const
    {
        return !operator<(rhs_);
    }
};

/**
 * A sequence of {@link LogMessage}.
 */
typedef std::list<LogMessage> LogMessageSeq;

/**
 * Thrown when the provided RemoteLogger was previously attached to a LoggerAdmin.
 * \headerfile Ice/Ice.h
 */
class ICE_API RemoteLoggerAlreadyAttachedException : public UserException
{
public:

    RemoteLoggerAlreadyAttachedException() {}
    virtual ~RemoteLoggerAlreadyAttachedException() throw();

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    virtual ::std::string ice_id() const;
    /**
     * Polymporphically clones this exception.
     * @return A shallow copy of this exception.
     */
    virtual RemoteLoggerAlreadyAttachedException* ice_clone() const;
    /**
     * Throws this exception.
     */
    virtual void ice_throw() const;

protected:

    /// \cond STREAM
    virtual void _writeImpl(OutputStream*) const;
    virtual void _readImpl(InputStream*);
    /// \endcond
};

/// \cond INTERNAL
static RemoteLoggerAlreadyAttachedException _iceS_RemoteLoggerAlreadyAttachedException_init;
/// \endcond

}

namespace Ice
{

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::Ice::RemoteLogger::begin_init.
 * Create a wrapper instance by calling ::Ice::newCallback_RemoteLogger_init.
 */
class Callback_RemoteLogger_init_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_RemoteLogger_init_Base> Callback_RemoteLogger_initPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::Ice::RemoteLogger::begin_log.
 * Create a wrapper instance by calling ::Ice::newCallback_RemoteLogger_log.
 */
class Callback_RemoteLogger_log_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_RemoteLogger_log_Base> Callback_RemoteLogger_logPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::Ice::LoggerAdmin::begin_attachRemoteLogger.
 * Create a wrapper instance by calling ::Ice::newCallback_LoggerAdmin_attachRemoteLogger.
 */
class Callback_LoggerAdmin_attachRemoteLogger_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_LoggerAdmin_attachRemoteLogger_Base> Callback_LoggerAdmin_attachRemoteLoggerPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::Ice::LoggerAdmin::begin_detachRemoteLogger.
 * Create a wrapper instance by calling ::Ice::newCallback_LoggerAdmin_detachRemoteLogger.
 */
class Callback_LoggerAdmin_detachRemoteLogger_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_LoggerAdmin_detachRemoteLogger_Base> Callback_LoggerAdmin_detachRemoteLoggerPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::Ice::LoggerAdmin::begin_getLog.
 * Create a wrapper instance by calling ::Ice::newCallback_LoggerAdmin_getLog.
 */
class Callback_LoggerAdmin_getLog_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_LoggerAdmin_getLog_Base> Callback_LoggerAdmin_getLogPtr;

}

namespace IceProxy
{

namespace Ice
{

class ICE_CLASS(ICE_API) RemoteLogger : public virtual ::Ice::Proxy<RemoteLogger, ::IceProxy::Ice::Object>
{
public:

    /**
     * init is called by attachRemoteLogger when a RemoteLogger proxy is attached.
     * @param prefix The prefix of the associated local Logger.
     * @param logMessages Old log messages generated before "now".
     * @param context The Context map to send with the invocation.
     */
    ICE_MEMBER(ICE_API) void init(const ::std::string& prefix, const ::Ice::LogMessageSeq& logMessages, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_init(_iceI_begin_init(prefix, logMessages, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * init is called by attachRemoteLogger when a RemoteLogger proxy is attached.
     * @param prefix The prefix of the associated local Logger.
     * @param logMessages Old log messages generated before "now".
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_init(const ::std::string& prefix, const ::Ice::LogMessageSeq& logMessages, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_init(prefix, logMessages, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * init is called by attachRemoteLogger when a RemoteLogger proxy is attached.
     * @param prefix The prefix of the associated local Logger.
     * @param logMessages Old log messages generated before "now".
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_init(const ::std::string& prefix, const ::Ice::LogMessageSeq& logMessages, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_init(prefix, logMessages, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * init is called by attachRemoteLogger when a RemoteLogger proxy is attached.
     * @param prefix The prefix of the associated local Logger.
     * @param logMessages Old log messages generated before "now".
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_init(const ::std::string& prefix, const ::Ice::LogMessageSeq& logMessages, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_init(prefix, logMessages, context, cb, cookie);
    }

    /**
     * init is called by attachRemoteLogger when a RemoteLogger proxy is attached.
     * @param prefix The prefix of the associated local Logger.
     * @param logMessages Old log messages generated before "now".
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_init(const ::std::string& prefix, const ::Ice::LogMessageSeq& logMessages, const ::Ice::Callback_RemoteLogger_initPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_init(prefix, logMessages, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * init is called by attachRemoteLogger when a RemoteLogger proxy is attached.
     * @param prefix The prefix of the associated local Logger.
     * @param logMessages Old log messages generated before "now".
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_init(const ::std::string& prefix, const ::Ice::LogMessageSeq& logMessages, const ::Ice::Context& context, const ::Ice::Callback_RemoteLogger_initPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_init(prefix, logMessages, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_init.
     * @param result The asynchronous result object for the invocation.
     */
    ICE_MEMBER(ICE_API) void end_init(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICE_API) ::Ice::AsyncResultPtr _iceI_begin_init(const ::std::string&, const ::Ice::LogMessageSeq&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Log a LogMessage. Note that log may be called by LoggerAdmin before init.
     * @param message The message to log.
     * @param context The Context map to send with the invocation.
     */
    ICE_MEMBER(ICE_API) void log(const ::Ice::LogMessage& message, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_log(_iceI_begin_log(message, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Log a LogMessage. Note that log may be called by LoggerAdmin before init.
     * @param message The message to log.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_log(const ::Ice::LogMessage& message, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_log(message, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Log a LogMessage. Note that log may be called by LoggerAdmin before init.
     * @param message The message to log.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_log(const ::Ice::LogMessage& message, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_log(message, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Log a LogMessage. Note that log may be called by LoggerAdmin before init.
     * @param message The message to log.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_log(const ::Ice::LogMessage& message, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_log(message, context, cb, cookie);
    }

    /**
     * Log a LogMessage. Note that log may be called by LoggerAdmin before init.
     * @param message The message to log.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_log(const ::Ice::LogMessage& message, const ::Ice::Callback_RemoteLogger_logPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_log(message, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Log a LogMessage. Note that log may be called by LoggerAdmin before init.
     * @param message The message to log.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_log(const ::Ice::LogMessage& message, const ::Ice::Context& context, const ::Ice::Callback_RemoteLogger_logPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_log(message, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_log.
     * @param result The asynchronous result object for the invocation.
     */
    ICE_MEMBER(ICE_API) void end_log(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICE_API) ::Ice::AsyncResultPtr _iceI_begin_log(const ::Ice::LogMessage&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Obtains the Slice type ID corresponding to this interface.
     * @return A fully-scoped type ID.
     */
    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();

protected:
    /// \cond INTERNAL

    ICE_MEMBER(ICE_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
    /// \endcond
};

class ICE_CLASS(ICE_API) LoggerAdmin : public virtual ::Ice::Proxy<LoggerAdmin, ::IceProxy::Ice::Object>
{
public:

    /**
     * Attaches a RemoteLogger object to the local logger.
     * attachRemoteLogger calls init on the provided RemoteLogger proxy.
     * @param prx A proxy to the remote logger.
     * @param messageTypes The list of message types that the remote logger wishes to receive.
     * An empty list means no filtering (send all message types).
     * @param traceCategories The categories of traces that the remote logger wishes to receive.
     * This parameter is ignored if messageTypes is not empty and does not include trace.
     * An empty list means no filtering (send all trace categories).
     * @param messageMax The maximum number of log messages (of all types) to be provided
     * to init. A negative value requests all messages available.
     * @param context The Context map to send with the invocation.
     * @throws Ice::RemoteLoggerAlreadyAttachedException Raised if this remote logger is already
     * attached to this admin object.
     */
    ICE_MEMBER(ICE_API) void attachRemoteLogger(const ::Ice::RemoteLoggerPrx& prx, const ::Ice::LogMessageTypeSeq& messageTypes, const ::Ice::StringSeq& traceCategories, ::Ice::Int messageMax, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_attachRemoteLogger(_iceI_begin_attachRemoteLogger(prx, messageTypes, traceCategories, messageMax, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Attaches a RemoteLogger object to the local logger.
     * attachRemoteLogger calls init on the provided RemoteLogger proxy.
     * @param prx A proxy to the remote logger.
     * @param messageTypes The list of message types that the remote logger wishes to receive.
     * An empty list means no filtering (send all message types).
     * @param traceCategories The categories of traces that the remote logger wishes to receive.
     * This parameter is ignored if messageTypes is not empty and does not include trace.
     * An empty list means no filtering (send all trace categories).
     * @param messageMax The maximum number of log messages (of all types) to be provided
     * to init. A negative value requests all messages available.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_attachRemoteLogger(const ::Ice::RemoteLoggerPrx& prx, const ::Ice::LogMessageTypeSeq& messageTypes, const ::Ice::StringSeq& traceCategories, ::Ice::Int messageMax, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_attachRemoteLogger(prx, messageTypes, traceCategories, messageMax, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Attaches a RemoteLogger object to the local logger.
     * attachRemoteLogger calls init on the provided RemoteLogger proxy.
     * @param prx A proxy to the remote logger.
     * @param messageTypes The list of message types that the remote logger wishes to receive.
     * An empty list means no filtering (send all message types).
     * @param traceCategories The categories of traces that the remote logger wishes to receive.
     * This parameter is ignored if messageTypes is not empty and does not include trace.
     * An empty list means no filtering (send all trace categories).
     * @param messageMax The maximum number of log messages (of all types) to be provided
     * to init. A negative value requests all messages available.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_attachRemoteLogger(const ::Ice::RemoteLoggerPrx& prx, const ::Ice::LogMessageTypeSeq& messageTypes, const ::Ice::StringSeq& traceCategories, ::Ice::Int messageMax, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_attachRemoteLogger(prx, messageTypes, traceCategories, messageMax, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Attaches a RemoteLogger object to the local logger.
     * attachRemoteLogger calls init on the provided RemoteLogger proxy.
     * @param prx A proxy to the remote logger.
     * @param messageTypes The list of message types that the remote logger wishes to receive.
     * An empty list means no filtering (send all message types).
     * @param traceCategories The categories of traces that the remote logger wishes to receive.
     * This parameter is ignored if messageTypes is not empty and does not include trace.
     * An empty list means no filtering (send all trace categories).
     * @param messageMax The maximum number of log messages (of all types) to be provided
     * to init. A negative value requests all messages available.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_attachRemoteLogger(const ::Ice::RemoteLoggerPrx& prx, const ::Ice::LogMessageTypeSeq& messageTypes, const ::Ice::StringSeq& traceCategories, ::Ice::Int messageMax, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_attachRemoteLogger(prx, messageTypes, traceCategories, messageMax, context, cb, cookie);
    }

    /**
     * Attaches a RemoteLogger object to the local logger.
     * attachRemoteLogger calls init on the provided RemoteLogger proxy.
     * @param prx A proxy to the remote logger.
     * @param messageTypes The list of message types that the remote logger wishes to receive.
     * An empty list means no filtering (send all message types).
     * @param traceCategories The categories of traces that the remote logger wishes to receive.
     * This parameter is ignored if messageTypes is not empty and does not include trace.
     * An empty list means no filtering (send all trace categories).
     * @param messageMax The maximum number of log messages (of all types) to be provided
     * to init. A negative value requests all messages available.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_attachRemoteLogger(const ::Ice::RemoteLoggerPrx& prx, const ::Ice::LogMessageTypeSeq& messageTypes, const ::Ice::StringSeq& traceCategories, ::Ice::Int messageMax, const ::Ice::Callback_LoggerAdmin_attachRemoteLoggerPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_attachRemoteLogger(prx, messageTypes, traceCategories, messageMax, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Attaches a RemoteLogger object to the local logger.
     * attachRemoteLogger calls init on the provided RemoteLogger proxy.
     * @param prx A proxy to the remote logger.
     * @param messageTypes The list of message types that the remote logger wishes to receive.
     * An empty list means no filtering (send all message types).
     * @param traceCategories The categories of traces that the remote logger wishes to receive.
     * This parameter is ignored if messageTypes is not empty and does not include trace.
     * An empty list means no filtering (send all trace categories).
     * @param messageMax The maximum number of log messages (of all types) to be provided
     * to init. A negative value requests all messages available.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_attachRemoteLogger(const ::Ice::RemoteLoggerPrx& prx, const ::Ice::LogMessageTypeSeq& messageTypes, const ::Ice::StringSeq& traceCategories, ::Ice::Int messageMax, const ::Ice::Context& context, const ::Ice::Callback_LoggerAdmin_attachRemoteLoggerPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_attachRemoteLogger(prx, messageTypes, traceCategories, messageMax, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_attachRemoteLogger.
     * @param result The asynchronous result object for the invocation.
     * @throws Ice::RemoteLoggerAlreadyAttachedException Raised if this remote logger is already
     * attached to this admin object.
     */
    ICE_MEMBER(ICE_API) void end_attachRemoteLogger(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICE_API) ::Ice::AsyncResultPtr _iceI_begin_attachRemoteLogger(const ::Ice::RemoteLoggerPrx&, const ::Ice::LogMessageTypeSeq&, const ::Ice::StringSeq&, ::Ice::Int, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Detaches a RemoteLogger object from the local logger.
     * @param prx A proxy to the remote logger.
     * @param context The Context map to send with the invocation.
     * @return True if the provided remote logger proxy was detached, and false otherwise.
     */
    ICE_MEMBER(ICE_API) bool detachRemoteLogger(const ::Ice::RemoteLoggerPrx& prx, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_detachRemoteLogger(_iceI_begin_detachRemoteLogger(prx, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Detaches a RemoteLogger object from the local logger.
     * @param prx A proxy to the remote logger.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_detachRemoteLogger(const ::Ice::RemoteLoggerPrx& prx, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_detachRemoteLogger(prx, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Detaches a RemoteLogger object from the local logger.
     * @param prx A proxy to the remote logger.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_detachRemoteLogger(const ::Ice::RemoteLoggerPrx& prx, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_detachRemoteLogger(prx, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Detaches a RemoteLogger object from the local logger.
     * @param prx A proxy to the remote logger.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_detachRemoteLogger(const ::Ice::RemoteLoggerPrx& prx, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_detachRemoteLogger(prx, context, cb, cookie);
    }

    /**
     * Detaches a RemoteLogger object from the local logger.
     * @param prx A proxy to the remote logger.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_detachRemoteLogger(const ::Ice::RemoteLoggerPrx& prx, const ::Ice::Callback_LoggerAdmin_detachRemoteLoggerPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_detachRemoteLogger(prx, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Detaches a RemoteLogger object from the local logger.
     * @param prx A proxy to the remote logger.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_detachRemoteLogger(const ::Ice::RemoteLoggerPrx& prx, const ::Ice::Context& context, const ::Ice::Callback_LoggerAdmin_detachRemoteLoggerPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_detachRemoteLogger(prx, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_detachRemoteLogger.
     * @param result The asynchronous result object for the invocation.
     * @return True if the provided remote logger proxy was detached, and false otherwise.
     */
    ICE_MEMBER(ICE_API) bool end_detachRemoteLogger(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICE_API) ::Ice::AsyncResultPtr _iceI_begin_detachRemoteLogger(const ::Ice::RemoteLoggerPrx&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Retrieves log messages recently logged.
     * @param messageTypes The list of message types that the caller wishes to receive.
     * An empty list means no filtering (send all message types).
     * @param traceCategories The categories of traces that caller wish to receive.
     * This parameter is ignored if messageTypes is not empty and does not include trace.
     * An empty list means no filtering (send all trace categories).
     * @param messageMax The maximum number of log messages (of all types) to be returned.
     * A negative value requests all messages available.
     * @param prefix The prefix of the associated local logger.
     * @param context The Context map to send with the invocation.
     * @return The Log messages.
     */
    ICE_MEMBER(ICE_API) ::Ice::LogMessageSeq getLog(const ::Ice::LogMessageTypeSeq& messageTypes, const ::Ice::StringSeq& traceCategories, ::Ice::Int messageMax, ::std::string& prefix, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getLog(prefix, _iceI_begin_getLog(messageTypes, traceCategories, messageMax, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Retrieves log messages recently logged.
     * @param messageTypes The list of message types that the caller wishes to receive.
     * An empty list means no filtering (send all message types).
     * @param traceCategories The categories of traces that caller wish to receive.
     * This parameter is ignored if messageTypes is not empty and does not include trace.
     * An empty list means no filtering (send all trace categories).
     * @param messageMax The maximum number of log messages (of all types) to be returned.
     * A negative value requests all messages available.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getLog(const ::Ice::LogMessageTypeSeq& messageTypes, const ::Ice::StringSeq& traceCategories, ::Ice::Int messageMax, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getLog(messageTypes, traceCategories, messageMax, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Retrieves log messages recently logged.
     * @param messageTypes The list of message types that the caller wishes to receive.
     * An empty list means no filtering (send all message types).
     * @param traceCategories The categories of traces that caller wish to receive.
     * This parameter is ignored if messageTypes is not empty and does not include trace.
     * An empty list means no filtering (send all trace categories).
     * @param messageMax The maximum number of log messages (of all types) to be returned.
     * A negative value requests all messages available.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getLog(const ::Ice::LogMessageTypeSeq& messageTypes, const ::Ice::StringSeq& traceCategories, ::Ice::Int messageMax, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getLog(messageTypes, traceCategories, messageMax, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Retrieves log messages recently logged.
     * @param messageTypes The list of message types that the caller wishes to receive.
     * An empty list means no filtering (send all message types).
     * @param traceCategories The categories of traces that caller wish to receive.
     * This parameter is ignored if messageTypes is not empty and does not include trace.
     * An empty list means no filtering (send all trace categories).
     * @param messageMax The maximum number of log messages (of all types) to be returned.
     * A negative value requests all messages available.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getLog(const ::Ice::LogMessageTypeSeq& messageTypes, const ::Ice::StringSeq& traceCategories, ::Ice::Int messageMax, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getLog(messageTypes, traceCategories, messageMax, context, cb, cookie);
    }

    /**
     * Retrieves log messages recently logged.
     * @param messageTypes The list of message types that the caller wishes to receive.
     * An empty list means no filtering (send all message types).
     * @param traceCategories The categories of traces that caller wish to receive.
     * This parameter is ignored if messageTypes is not empty and does not include trace.
     * An empty list means no filtering (send all trace categories).
     * @param messageMax The maximum number of log messages (of all types) to be returned.
     * A negative value requests all messages available.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getLog(const ::Ice::LogMessageTypeSeq& messageTypes, const ::Ice::StringSeq& traceCategories, ::Ice::Int messageMax, const ::Ice::Callback_LoggerAdmin_getLogPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getLog(messageTypes, traceCategories, messageMax, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Retrieves log messages recently logged.
     * @param messageTypes The list of message types that the caller wishes to receive.
     * An empty list means no filtering (send all message types).
     * @param traceCategories The categories of traces that caller wish to receive.
     * This parameter is ignored if messageTypes is not empty and does not include trace.
     * An empty list means no filtering (send all trace categories).
     * @param messageMax The maximum number of log messages (of all types) to be returned.
     * A negative value requests all messages available.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getLog(const ::Ice::LogMessageTypeSeq& messageTypes, const ::Ice::StringSeq& traceCategories, ::Ice::Int messageMax, const ::Ice::Context& context, const ::Ice::Callback_LoggerAdmin_getLogPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getLog(messageTypes, traceCategories, messageMax, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getLog.
     * @param prefix The prefix of the associated local logger.
     * @param result The asynchronous result object for the invocation.
     * @return The Log messages.
     */
    ICE_MEMBER(ICE_API) ::Ice::LogMessageSeq end_getLog(::std::string& prefix, const ::Ice::AsyncResultPtr& result);
    /// \cond INTERNAL

    ICE_MEMBER(ICE_API) void _iceI_end_getLog(::std::string& iceP_prefix, ::Ice::LogMessageSeq& ret, const ::Ice::AsyncResultPtr&);
    /// \endcond

private:

    ICE_MEMBER(ICE_API) ::Ice::AsyncResultPtr _iceI_begin_getLog(const ::Ice::LogMessageTypeSeq&, const ::Ice::StringSeq&, ::Ice::Int, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Obtains the Slice type ID corresponding to this interface.
     * @return A fully-scoped type ID.
     */
    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();

protected:
    /// \cond INTERNAL

    ICE_MEMBER(ICE_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
    /// \endcond
};

}

}

namespace Ice
{

/**
 * The Ice remote logger interface. An application can implement a
 * RemoteLogger to receive the log messages sent to the local {@link Logger}
 * of another Ice application.
 * \headerfile Ice/Ice.h
 */
class ICE_API RemoteLogger : public virtual Object
{
public:

    typedef RemoteLoggerPrx ProxyType;
    typedef RemoteLoggerPtr PointerType;

    virtual ~RemoteLogger();

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(const ::std::string& id, const Current& current = emptyCurrent) const;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector< ::std::string> ice_ids(const Current& current = emptyCurrent) const;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual const ::std::string& ice_id(const Current& current = emptyCurrent) const;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * init is called by attachRemoteLogger when a RemoteLogger proxy is attached.
     * @param prefix The prefix of the associated local Logger.
     * @param logMessages Old log messages generated before "now".
     * @param current The Current object for the invocation.
     */
    virtual void init(const ::std::string& prefix, const LogMessageSeq& logMessages, const Current& current = emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_init(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Log a LogMessage. Note that log may be called by LoggerAdmin before init.
     * @param message The message to log.
     * @param current The Current object for the invocation.
     */
    virtual void log(const LogMessage& message, const Current& current = emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_log(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const Current&);
    /// \endcond

protected:

    /// \cond STREAM
    virtual void _iceWriteImpl(OutputStream*) const;
    virtual void _iceReadImpl(InputStream*);
    /// \endcond
};

/// \cond INTERNAL
inline bool operator==(const RemoteLogger& lhs, const RemoteLogger& rhs)
{
    return static_cast<const Object&>(lhs) == static_cast<const Object&>(rhs);
}

inline bool operator<(const RemoteLogger& lhs, const RemoteLogger& rhs)
{
    return static_cast<const Object&>(lhs) < static_cast<const Object&>(rhs);
}
/// \endcond

/**
 * The interface of the admin object that allows an Ice application the attach its
 * {@link RemoteLogger} to the {@link Logger} of this admin object's Ice communicator.
 * \headerfile Ice/Ice.h
 */
class ICE_API LoggerAdmin : public virtual Object
{
public:

    typedef LoggerAdminPrx ProxyType;
    typedef LoggerAdminPtr PointerType;

    virtual ~LoggerAdmin();

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(const ::std::string& id, const Current& current = emptyCurrent) const;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector< ::std::string> ice_ids(const Current& current = emptyCurrent) const;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual const ::std::string& ice_id(const Current& current = emptyCurrent) const;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Attaches a RemoteLogger object to the local logger.
     * attachRemoteLogger calls init on the provided RemoteLogger proxy.
     * @param prx A proxy to the remote logger.
     * @param messageTypes The list of message types that the remote logger wishes to receive.
     * An empty list means no filtering (send all message types).
     * @param traceCategories The categories of traces that the remote logger wishes to receive.
     * This parameter is ignored if messageTypes is not empty and does not include trace.
     * An empty list means no filtering (send all trace categories).
     * @param messageMax The maximum number of log messages (of all types) to be provided
     * to init. A negative value requests all messages available.
     * @param current The Current object for the invocation.
     * @throws Ice::RemoteLoggerAlreadyAttachedException Raised if this remote logger is already
     * attached to this admin object.
     */
    virtual void attachRemoteLogger(const RemoteLoggerPrx& prx, const LogMessageTypeSeq& messageTypes, const StringSeq& traceCategories, Int messageMax, const Current& current = emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_attachRemoteLogger(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Detaches a RemoteLogger object from the local logger.
     * @param prx A proxy to the remote logger.
     * @param current The Current object for the invocation.
     * @return True if the provided remote logger proxy was detached, and false otherwise.
     */
    virtual bool detachRemoteLogger(const RemoteLoggerPrx& prx, const Current& current = emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_detachRemoteLogger(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Retrieves log messages recently logged.
     * @param messageTypes The list of message types that the caller wishes to receive.
     * An empty list means no filtering (send all message types).
     * @param traceCategories The categories of traces that caller wish to receive.
     * This parameter is ignored if messageTypes is not empty and does not include trace.
     * An empty list means no filtering (send all trace categories).
     * @param messageMax The maximum number of log messages (of all types) to be returned.
     * A negative value requests all messages available.
     * @param prefix The prefix of the associated local logger.
     * @param current The Current object for the invocation.
     * @return The Log messages.
     */
    virtual LogMessageSeq getLog(const LogMessageTypeSeq& messageTypes, const StringSeq& traceCategories, Int messageMax, ::std::string& prefix, const Current& current = emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_getLog(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const Current&);
    /// \endcond

protected:

    /// \cond STREAM
    virtual void _iceWriteImpl(OutputStream*) const;
    virtual void _iceReadImpl(InputStream*);
    /// \endcond
};

/// \cond INTERNAL
inline bool operator==(const LoggerAdmin& lhs, const LoggerAdmin& rhs)
{
    return static_cast<const Object&>(lhs) == static_cast<const Object&>(rhs);
}

inline bool operator<(const LoggerAdmin& lhs, const LoggerAdmin& rhs)
{
    return static_cast<const Object&>(lhs) < static_cast<const Object&>(rhs);
}
/// \endcond

}

/// \cond STREAM
namespace Ice
{

template<>
struct StreamableTraits< ::Ice::LogMessageType>
{
    static const StreamHelperCategory helper = StreamHelperCategoryEnum;
    static const int minValue = 0;
    static const int maxValue = 3;
    static const int minWireSize = 1;
    static const bool fixedLength = false;
};

template<>
struct StreamableTraits< ::Ice::LogMessage>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 11;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamWriter< ::Ice::LogMessage, S>
{
    static void write(S* ostr, const ::Ice::LogMessage& v)
    {
        ostr->write(v.type);
        ostr->write(v.timestamp);
        ostr->write(v.traceCategory);
        ostr->write(v.message);
    }
};

template<typename S>
struct StreamReader< ::Ice::LogMessage, S>
{
    static void read(S* istr, ::Ice::LogMessage& v)
    {
        istr->read(v.type);
        istr->read(v.timestamp);
        istr->read(v.traceCategory);
        istr->read(v.message);
    }
};

template<>
struct StreamableTraits< ::Ice::RemoteLoggerAlreadyAttachedException>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

}
/// \endcond

namespace Ice
{

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::Ice::RemoteLogger::begin_init.
 * Create a wrapper instance by calling ::Ice::newCallback_RemoteLogger_init.
 */
template<class T>
class CallbackNC_RemoteLogger_init : public Callback_RemoteLogger_init_Base, public ::IceInternal::OnewayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_RemoteLogger_init(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallbackNC<T>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::RemoteLogger::begin_init.
 */
template<class T> Callback_RemoteLogger_initPtr
newCallback_RemoteLogger_init(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_RemoteLogger_init<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::RemoteLogger::begin_init.
 */
template<class T> Callback_RemoteLogger_initPtr
newCallback_RemoteLogger_init(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_RemoteLogger_init<T>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::RemoteLogger::begin_init.
 */
template<class T> Callback_RemoteLogger_initPtr
newCallback_RemoteLogger_init(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_RemoteLogger_init<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::RemoteLogger::begin_init.
 */
template<class T> Callback_RemoteLogger_initPtr
newCallback_RemoteLogger_init(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_RemoteLogger_init<T>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::Ice::RemoteLogger::begin_init.
 * Create a wrapper instance by calling ::Ice::newCallback_RemoteLogger_init.
 */
template<class T, typename CT>
class Callback_RemoteLogger_init : public Callback_RemoteLogger_init_Base, public ::IceInternal::OnewayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_RemoteLogger_init(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallback<T, CT>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::RemoteLogger::begin_init.
 */
template<class T, typename CT> Callback_RemoteLogger_initPtr
newCallback_RemoteLogger_init(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_RemoteLogger_init<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::RemoteLogger::begin_init.
 */
template<class T, typename CT> Callback_RemoteLogger_initPtr
newCallback_RemoteLogger_init(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_RemoteLogger_init<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::RemoteLogger::begin_init.
 */
template<class T, typename CT> Callback_RemoteLogger_initPtr
newCallback_RemoteLogger_init(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_RemoteLogger_init<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::RemoteLogger::begin_init.
 */
template<class T, typename CT> Callback_RemoteLogger_initPtr
newCallback_RemoteLogger_init(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_RemoteLogger_init<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::Ice::RemoteLogger::begin_log.
 * Create a wrapper instance by calling ::Ice::newCallback_RemoteLogger_log.
 */
template<class T>
class CallbackNC_RemoteLogger_log : public Callback_RemoteLogger_log_Base, public ::IceInternal::OnewayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_RemoteLogger_log(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallbackNC<T>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::RemoteLogger::begin_log.
 */
template<class T> Callback_RemoteLogger_logPtr
newCallback_RemoteLogger_log(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_RemoteLogger_log<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::RemoteLogger::begin_log.
 */
template<class T> Callback_RemoteLogger_logPtr
newCallback_RemoteLogger_log(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_RemoteLogger_log<T>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::RemoteLogger::begin_log.
 */
template<class T> Callback_RemoteLogger_logPtr
newCallback_RemoteLogger_log(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_RemoteLogger_log<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::RemoteLogger::begin_log.
 */
template<class T> Callback_RemoteLogger_logPtr
newCallback_RemoteLogger_log(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_RemoteLogger_log<T>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::Ice::RemoteLogger::begin_log.
 * Create a wrapper instance by calling ::Ice::newCallback_RemoteLogger_log.
 */
template<class T, typename CT>
class Callback_RemoteLogger_log : public Callback_RemoteLogger_log_Base, public ::IceInternal::OnewayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_RemoteLogger_log(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallback<T, CT>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::RemoteLogger::begin_log.
 */
template<class T, typename CT> Callback_RemoteLogger_logPtr
newCallback_RemoteLogger_log(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_RemoteLogger_log<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::RemoteLogger::begin_log.
 */
template<class T, typename CT> Callback_RemoteLogger_logPtr
newCallback_RemoteLogger_log(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_RemoteLogger_log<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::RemoteLogger::begin_log.
 */
template<class T, typename CT> Callback_RemoteLogger_logPtr
newCallback_RemoteLogger_log(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_RemoteLogger_log<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::RemoteLogger::begin_log.
 */
template<class T, typename CT> Callback_RemoteLogger_logPtr
newCallback_RemoteLogger_log(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_RemoteLogger_log<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::Ice::LoggerAdmin::begin_attachRemoteLogger.
 * Create a wrapper instance by calling ::Ice::newCallback_LoggerAdmin_attachRemoteLogger.
 */
template<class T>
class CallbackNC_LoggerAdmin_attachRemoteLogger : public Callback_LoggerAdmin_attachRemoteLogger_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_LoggerAdmin_attachRemoteLogger(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const AsyncResultPtr& result) const
    {
        LoggerAdminPrx proxy = LoggerAdminPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_attachRemoteLogger(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)();
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::LoggerAdmin::begin_attachRemoteLogger.
 */
template<class T> Callback_LoggerAdmin_attachRemoteLoggerPtr
newCallback_LoggerAdmin_attachRemoteLogger(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_LoggerAdmin_attachRemoteLogger<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::LoggerAdmin::begin_attachRemoteLogger.
 */
template<class T> Callback_LoggerAdmin_attachRemoteLoggerPtr
newCallback_LoggerAdmin_attachRemoteLogger(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_LoggerAdmin_attachRemoteLogger<T>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::LoggerAdmin::begin_attachRemoteLogger.
 */
template<class T> Callback_LoggerAdmin_attachRemoteLoggerPtr
newCallback_LoggerAdmin_attachRemoteLogger(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_LoggerAdmin_attachRemoteLogger<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::LoggerAdmin::begin_attachRemoteLogger.
 */
template<class T> Callback_LoggerAdmin_attachRemoteLoggerPtr
newCallback_LoggerAdmin_attachRemoteLogger(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_LoggerAdmin_attachRemoteLogger<T>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::Ice::LoggerAdmin::begin_attachRemoteLogger.
 * Create a wrapper instance by calling ::Ice::newCallback_LoggerAdmin_attachRemoteLogger.
 */
template<class T, typename CT>
class Callback_LoggerAdmin_attachRemoteLogger : public Callback_LoggerAdmin_attachRemoteLogger_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_LoggerAdmin_attachRemoteLogger(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const AsyncResultPtr& result) const
    {
        LoggerAdminPrx proxy = LoggerAdminPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_attachRemoteLogger(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::LoggerAdmin::begin_attachRemoteLogger.
 */
template<class T, typename CT> Callback_LoggerAdmin_attachRemoteLoggerPtr
newCallback_LoggerAdmin_attachRemoteLogger(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_LoggerAdmin_attachRemoteLogger<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::LoggerAdmin::begin_attachRemoteLogger.
 */
template<class T, typename CT> Callback_LoggerAdmin_attachRemoteLoggerPtr
newCallback_LoggerAdmin_attachRemoteLogger(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_LoggerAdmin_attachRemoteLogger<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::LoggerAdmin::begin_attachRemoteLogger.
 */
template<class T, typename CT> Callback_LoggerAdmin_attachRemoteLoggerPtr
newCallback_LoggerAdmin_attachRemoteLogger(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_LoggerAdmin_attachRemoteLogger<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::LoggerAdmin::begin_attachRemoteLogger.
 */
template<class T, typename CT> Callback_LoggerAdmin_attachRemoteLoggerPtr
newCallback_LoggerAdmin_attachRemoteLogger(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_LoggerAdmin_attachRemoteLogger<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::Ice::LoggerAdmin::begin_detachRemoteLogger.
 * Create a wrapper instance by calling ::Ice::newCallback_LoggerAdmin_detachRemoteLogger.
 */
template<class T>
class CallbackNC_LoggerAdmin_detachRemoteLogger : public Callback_LoggerAdmin_detachRemoteLogger_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(bool);

    CallbackNC_LoggerAdmin_detachRemoteLogger(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const AsyncResultPtr& result) const
    {
        LoggerAdminPrx proxy = LoggerAdminPrx::uncheckedCast(result->getProxy());
        bool ret;
        try
        {
            ret = proxy->end_detachRemoteLogger(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::LoggerAdmin::begin_detachRemoteLogger.
 */
template<class T> Callback_LoggerAdmin_detachRemoteLoggerPtr
newCallback_LoggerAdmin_detachRemoteLogger(const IceUtil::Handle<T>& instance, void (T::*cb)(bool), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_LoggerAdmin_detachRemoteLogger<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::LoggerAdmin::begin_detachRemoteLogger.
 */
template<class T> Callback_LoggerAdmin_detachRemoteLoggerPtr
newCallback_LoggerAdmin_detachRemoteLogger(T* instance, void (T::*cb)(bool), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_LoggerAdmin_detachRemoteLogger<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::Ice::LoggerAdmin::begin_detachRemoteLogger.
 * Create a wrapper instance by calling ::Ice::newCallback_LoggerAdmin_detachRemoteLogger.
 */
template<class T, typename CT>
class Callback_LoggerAdmin_detachRemoteLogger : public Callback_LoggerAdmin_detachRemoteLogger_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(bool, const CT&);

    Callback_LoggerAdmin_detachRemoteLogger(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const AsyncResultPtr& result) const
    {
        LoggerAdminPrx proxy = LoggerAdminPrx::uncheckedCast(result->getProxy());
        bool ret;
        try
        {
            ret = proxy->end_detachRemoteLogger(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::LoggerAdmin::begin_detachRemoteLogger.
 */
template<class T, typename CT> Callback_LoggerAdmin_detachRemoteLoggerPtr
newCallback_LoggerAdmin_detachRemoteLogger(const IceUtil::Handle<T>& instance, void (T::*cb)(bool, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_LoggerAdmin_detachRemoteLogger<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::LoggerAdmin::begin_detachRemoteLogger.
 */
template<class T, typename CT> Callback_LoggerAdmin_detachRemoteLoggerPtr
newCallback_LoggerAdmin_detachRemoteLogger(T* instance, void (T::*cb)(bool, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_LoggerAdmin_detachRemoteLogger<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::Ice::LoggerAdmin::begin_getLog.
 * Create a wrapper instance by calling ::Ice::newCallback_LoggerAdmin_getLog.
 */
template<class T>
class CallbackNC_LoggerAdmin_getLog : public Callback_LoggerAdmin_getLog_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const LogMessageSeq&, const ::std::string&);

    CallbackNC_LoggerAdmin_getLog(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const AsyncResultPtr& result) const
    {
        LoggerAdminPrx proxy = LoggerAdminPrx::uncheckedCast(result->getProxy());
        ::std::string iceP_prefix;
        LogMessageSeq ret;
        try
        {
            ret = proxy->end_getLog(iceP_prefix, result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret, iceP_prefix);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::LoggerAdmin::begin_getLog.
 */
template<class T> Callback_LoggerAdmin_getLogPtr
newCallback_LoggerAdmin_getLog(const IceUtil::Handle<T>& instance, void (T::*cb)(const LogMessageSeq&, const ::std::string&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_LoggerAdmin_getLog<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::LoggerAdmin::begin_getLog.
 */
template<class T> Callback_LoggerAdmin_getLogPtr
newCallback_LoggerAdmin_getLog(T* instance, void (T::*cb)(const LogMessageSeq&, const ::std::string&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_LoggerAdmin_getLog<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::Ice::LoggerAdmin::begin_getLog.
 * Create a wrapper instance by calling ::Ice::newCallback_LoggerAdmin_getLog.
 */
template<class T, typename CT>
class Callback_LoggerAdmin_getLog : public Callback_LoggerAdmin_getLog_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const LogMessageSeq&, const ::std::string&, const CT&);

    Callback_LoggerAdmin_getLog(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const AsyncResultPtr& result) const
    {
        LoggerAdminPrx proxy = LoggerAdminPrx::uncheckedCast(result->getProxy());
        ::std::string iceP_prefix;
        LogMessageSeq ret;
        try
        {
            ret = proxy->end_getLog(iceP_prefix, result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, iceP_prefix, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::LoggerAdmin::begin_getLog.
 */
template<class T, typename CT> Callback_LoggerAdmin_getLogPtr
newCallback_LoggerAdmin_getLog(const IceUtil::Handle<T>& instance, void (T::*cb)(const LogMessageSeq&, const ::std::string&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_LoggerAdmin_getLog<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::LoggerAdmin::begin_getLog.
 */
template<class T, typename CT> Callback_LoggerAdmin_getLogPtr
newCallback_LoggerAdmin_getLog(T* instance, void (T::*cb)(const LogMessageSeq&, const ::std::string&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_LoggerAdmin_getLog<T, CT>(instance, cb, excb, sentcb);
}

}

#endif

#include <IceUtil/PopDisableWarnings.h>
#endif
