﻿/*
* Copyright 2010-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
*
* Licensed under the Apache License, Version 2.0 (the "License").
* You may not use this file except in compliance with the License.
* A copy of the License is located at
*
*  http://aws.amazon.com/apache2.0
*
* or in the "license" file accompanying this file. This file is distributed
* on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
* express or implied. See the License for the specific language governing
* permissions and limitations under the License.
*/

#pragma once
#include <aws/iot/IoT_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/iot/model/ServiceType.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace IoT
{
namespace Model
{

  /**
   * <p>The summary of a domain configuration. A domain configuration specifies
   * custom IoT-specific information about a domain. A domain configuration can be
   * associated with an AWS-managed domain (for example,
   * dbc123defghijk.iot.us-west-2.amazonaws.com), a customer managed domain, or a
   * default endpoint.</p> <ul> <li> <p>Data</p> </li> <li> <p>Jobs</p> </li> <li>
   * <p>CredentialProvider</p> </li> </ul> <note> <p>The domain configuration feature
   * is in public preview and is subject to change.</p> </note><p><h3>See Also:</h3> 
   * <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/iot-2015-05-28/DomainConfigurationSummary">AWS
   * API Reference</a></p>
   */
  class AWS_IOT_API DomainConfigurationSummary
  {
  public:
    DomainConfigurationSummary();
    DomainConfigurationSummary(Aws::Utils::Json::JsonView jsonValue);
    DomainConfigurationSummary& operator=(Aws::Utils::Json::JsonView jsonValue);
    Aws::Utils::Json::JsonValue Jsonize() const;


    /**
     * <p>The name of the domain configuration. This value must be unique to a
     * region.</p>
     */
    inline const Aws::String& GetDomainConfigurationName() const{ return m_domainConfigurationName; }

    /**
     * <p>The name of the domain configuration. This value must be unique to a
     * region.</p>
     */
    inline bool DomainConfigurationNameHasBeenSet() const { return m_domainConfigurationNameHasBeenSet; }

    /**
     * <p>The name of the domain configuration. This value must be unique to a
     * region.</p>
     */
    inline void SetDomainConfigurationName(const Aws::String& value) { m_domainConfigurationNameHasBeenSet = true; m_domainConfigurationName = value; }

    /**
     * <p>The name of the domain configuration. This value must be unique to a
     * region.</p>
     */
    inline void SetDomainConfigurationName(Aws::String&& value) { m_domainConfigurationNameHasBeenSet = true; m_domainConfigurationName = std::move(value); }

    /**
     * <p>The name of the domain configuration. This value must be unique to a
     * region.</p>
     */
    inline void SetDomainConfigurationName(const char* value) { m_domainConfigurationNameHasBeenSet = true; m_domainConfigurationName.assign(value); }

    /**
     * <p>The name of the domain configuration. This value must be unique to a
     * region.</p>
     */
    inline DomainConfigurationSummary& WithDomainConfigurationName(const Aws::String& value) { SetDomainConfigurationName(value); return *this;}

    /**
     * <p>The name of the domain configuration. This value must be unique to a
     * region.</p>
     */
    inline DomainConfigurationSummary& WithDomainConfigurationName(Aws::String&& value) { SetDomainConfigurationName(std::move(value)); return *this;}

    /**
     * <p>The name of the domain configuration. This value must be unique to a
     * region.</p>
     */
    inline DomainConfigurationSummary& WithDomainConfigurationName(const char* value) { SetDomainConfigurationName(value); return *this;}


    /**
     * <p>The ARN of the domain configuration.</p>
     */
    inline const Aws::String& GetDomainConfigurationArn() const{ return m_domainConfigurationArn; }

    /**
     * <p>The ARN of the domain configuration.</p>
     */
    inline bool DomainConfigurationArnHasBeenSet() const { return m_domainConfigurationArnHasBeenSet; }

    /**
     * <p>The ARN of the domain configuration.</p>
     */
    inline void SetDomainConfigurationArn(const Aws::String& value) { m_domainConfigurationArnHasBeenSet = true; m_domainConfigurationArn = value; }

    /**
     * <p>The ARN of the domain configuration.</p>
     */
    inline void SetDomainConfigurationArn(Aws::String&& value) { m_domainConfigurationArnHasBeenSet = true; m_domainConfigurationArn = std::move(value); }

    /**
     * <p>The ARN of the domain configuration.</p>
     */
    inline void SetDomainConfigurationArn(const char* value) { m_domainConfigurationArnHasBeenSet = true; m_domainConfigurationArn.assign(value); }

    /**
     * <p>The ARN of the domain configuration.</p>
     */
    inline DomainConfigurationSummary& WithDomainConfigurationArn(const Aws::String& value) { SetDomainConfigurationArn(value); return *this;}

    /**
     * <p>The ARN of the domain configuration.</p>
     */
    inline DomainConfigurationSummary& WithDomainConfigurationArn(Aws::String&& value) { SetDomainConfigurationArn(std::move(value)); return *this;}

    /**
     * <p>The ARN of the domain configuration.</p>
     */
    inline DomainConfigurationSummary& WithDomainConfigurationArn(const char* value) { SetDomainConfigurationArn(value); return *this;}


    /**
     * <p>The type of service delivered by the endpoint.</p>
     */
    inline const ServiceType& GetServiceType() const{ return m_serviceType; }

    /**
     * <p>The type of service delivered by the endpoint.</p>
     */
    inline bool ServiceTypeHasBeenSet() const { return m_serviceTypeHasBeenSet; }

    /**
     * <p>The type of service delivered by the endpoint.</p>
     */
    inline void SetServiceType(const ServiceType& value) { m_serviceTypeHasBeenSet = true; m_serviceType = value; }

    /**
     * <p>The type of service delivered by the endpoint.</p>
     */
    inline void SetServiceType(ServiceType&& value) { m_serviceTypeHasBeenSet = true; m_serviceType = std::move(value); }

    /**
     * <p>The type of service delivered by the endpoint.</p>
     */
    inline DomainConfigurationSummary& WithServiceType(const ServiceType& value) { SetServiceType(value); return *this;}

    /**
     * <p>The type of service delivered by the endpoint.</p>
     */
    inline DomainConfigurationSummary& WithServiceType(ServiceType&& value) { SetServiceType(std::move(value)); return *this;}

  private:

    Aws::String m_domainConfigurationName;
    bool m_domainConfigurationNameHasBeenSet;

    Aws::String m_domainConfigurationArn;
    bool m_domainConfigurationArnHasBeenSet;

    ServiceType m_serviceType;
    bool m_serviceTypeHasBeenSet;
  };

} // namespace Model
} // namespace IoT
} // namespace Aws
