/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.complexscripts.fonts;

import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Map;
import org.apache.fop.complexscripts.fonts.AdvancedTypographicTableFormatException;
import org.apache.fop.complexscripts.fonts.GlyphClassMapping;
import org.apache.fop.complexscripts.fonts.GlyphCoverageMapping;
import org.apache.fop.complexscripts.fonts.GlyphDefinitionTable;
import org.apache.fop.complexscripts.fonts.GlyphMappingTable;
import org.apache.fop.complexscripts.fonts.GlyphTable;

public abstract class GlyphSubtable
implements Comparable {
    public static final int LF_RIGHT_TO_LEFT = 1;
    public static final int LF_IGNORE_BASE = 2;
    public static final int LF_IGNORE_LIGATURE = 4;
    public static final int LF_IGNORE_MARK = 8;
    public static final int LF_USE_MARK_FILTERING_SET = 16;
    public static final int LF_RESERVED = 3584;
    public static final int LF_MARK_ATTACHMENT_TYPE = 65280;
    public static final int LF_INTERNAL_USE_REVERSE_SCAN = 65536;
    private String lookupId;
    private int sequence;
    private int flags;
    private int format;
    private GlyphMappingTable mapping;
    private WeakReference table;

    protected GlyphSubtable(String lookupId, int sequence, int flags, int format, GlyphMappingTable mapping) {
        if (lookupId == null || lookupId.length() == 0) {
            throw new AdvancedTypographicTableFormatException("invalid lookup identifier, must be non-empty string");
        }
        if (mapping == null) {
            throw new AdvancedTypographicTableFormatException("invalid mapping table, must not be null");
        }
        this.lookupId = lookupId;
        this.sequence = sequence;
        this.flags = flags;
        this.format = format;
        this.mapping = mapping;
    }

    public String getLookupId() {
        return this.lookupId;
    }

    public abstract int getTableType();

    public abstract int getType();

    public abstract String getTypeName();

    public abstract boolean isCompatible(GlyphSubtable var1);

    public abstract boolean usesReverseScan();

    public int getSequence() {
        return this.sequence;
    }

    public int getFlags() {
        return this.flags;
    }

    public int getFormat() {
        return this.format;
    }

    public GlyphDefinitionTable getGDEF() {
        GlyphTable gt = this.getTable();
        if (gt != null) {
            return gt.getGlyphDefinitions();
        }
        return null;
    }

    public GlyphCoverageMapping getCoverage() {
        if (this.mapping instanceof GlyphCoverageMapping) {
            return (GlyphCoverageMapping)((Object)this.mapping);
        }
        return null;
    }

    public GlyphClassMapping getClasses() {
        if (this.mapping instanceof GlyphClassMapping) {
            return (GlyphClassMapping)((Object)this.mapping);
        }
        return null;
    }

    public abstract List getEntries();

    public synchronized GlyphTable getTable() {
        WeakReference r = this.table;
        return r != null ? (GlyphTable)r.get() : null;
    }

    public synchronized void setTable(GlyphTable table) throws IllegalStateException {
        WeakReference r = this.table;
        if (table == null) {
            this.table = null;
            if (r != null) {
                r.clear();
            }
        } else if (r == null) {
            this.table = new WeakReference<GlyphTable>(table);
        } else {
            throw new IllegalStateException("table already set");
        }
    }

    public void resolveLookupReferences(Map<String, GlyphTable.LookupTable> lookupTables) {
    }

    public int getCoverageIndex(int gid) {
        if (this.mapping instanceof GlyphCoverageMapping) {
            return ((GlyphCoverageMapping)((Object)this.mapping)).getCoverageIndex(gid);
        }
        return -1;
    }

    public int getCoverageSize() {
        if (this.mapping instanceof GlyphCoverageMapping) {
            return ((GlyphCoverageMapping)((Object)this.mapping)).getCoverageSize();
        }
        return 0;
    }

    public int hashCode() {
        int hc = this.sequence;
        hc = hc * 3 + (this.lookupId.hashCode() ^ hc);
        return hc;
    }

    public boolean equals(Object o) {
        if (o instanceof GlyphSubtable) {
            GlyphSubtable st = (GlyphSubtable)o;
            return this.lookupId.equals(st.lookupId) && this.sequence == st.sequence;
        }
        return false;
    }

    public int compareTo(Object o) {
        int d;
        if (o instanceof GlyphSubtable) {
            GlyphSubtable st = (GlyphSubtable)o;
            d = this.lookupId.compareTo(st.lookupId);
            if (d == 0) {
                if (this.sequence < st.sequence) {
                    d = -1;
                } else if (this.sequence > st.sequence) {
                    d = 1;
                }
            }
        } else {
            d = -1;
        }
        return d;
    }

    public static boolean usesReverseScan(GlyphSubtable[] subtables) {
        if (subtables == null || subtables.length == 0) {
            return false;
        }
        for (GlyphSubtable subtable : subtables) {
            if (!subtable.usesReverseScan()) continue;
            return true;
        }
        return false;
    }

    public static int getFlags(GlyphSubtable[] subtables) throws IllegalStateException {
        int f;
        if (subtables == null || subtables.length == 0) {
            return 0;
        }
        int flags = 0;
        for (GlyphSubtable subtable1 : subtables) {
            f = subtable1.getFlags();
            if (flags != 0) continue;
            flags = f;
            break;
        }
        for (GlyphSubtable subtable : subtables) {
            f = subtable.getFlags();
            if (f == flags) continue;
            throw new IllegalStateException("inconsistent lookup flags " + f + ", expected " + flags);
        }
        return flags | (GlyphSubtable.usesReverseScan(subtables) ? 65536 : 0);
    }
}

