/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.visualization.model.edge;

import com.jogamp.common.nio.Buffers;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.glu.GLU;
import java.nio.FloatBuffer;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Node;
import org.gephi.lib.gleem.linalg.Vec3f;
import org.gephi.visualization.GraphLimits;
import org.gephi.visualization.VizModel;
import org.gephi.visualization.model.edge.EdgeModel;
import org.gephi.visualization.model.node.NodeModel;

public class SelfLoopModel
extends EdgeModel {
    private static final Vec3f UPVECTOR = new Vec3f(0.0f, 1.0f, 0.0f);
    private static final Vec3f SIDEVECTOR = new Vec3f(1.0f, 0.0f, 0.0f);
    protected static FloatBuffer buffer = Buffers.newDirectFloatBuffer((int)24);
    protected static int segments = 20;
    protected final NodeModel nodeModel;

    public SelfLoopModel(Edge edge, NodeModel nodeModel) {
        super(edge);
        this.nodeModel = nodeModel;
    }

    @Override
    public void display(GL2 gl, GLU glu, VizModel vizModel) {
        gl.glEnd();
        GraphLimits limits = vizModel.getLimits();
        float weightRatio = limits.getMinWeight() == limits.getMaxWeight() ? 0.4f / limits.getMinWeight() : Math.abs(7.6f / (limits.getMaxWeight() - limits.getMinWeight()));
        float w = this.weight;
        float edgeScale = vizModel.getEdgeScale();
        w = ((w - limits.getMinWeight()) * weightRatio + 0.4f) * edgeScale;
        Node node = this.edge.getSource();
        float x = node.x();
        float y = node.y();
        float z = node.z();
        float baseRightX = x + SIDEVECTOR.x() * w / 2.0f;
        float baseRightY = y + SIDEVECTOR.y() * w / 2.0f;
        float baseRightZ = z + SIDEVECTOR.z() * w / 2.0f;
        float baseLeftX = x - SIDEVECTOR.x() * w / 2.0f;
        float baseLeftY = y - SIDEVECTOR.y() * w / 2.0f;
        float baseLeftZ = z - SIDEVECTOR.z() * w / 2.0f;
        float baseTopX = x + UPVECTOR.x() * w / 2.0f;
        float baseTopY = y + UPVECTOR.y() * w / 2.0f;
        float baseTopZ = z + UPVECTOR.z() * w / 2.0f;
        float baseBottomX = x - UPVECTOR.x() * w / 2.0f;
        float baseBottomY = y - UPVECTOR.y() * w / 2.0f;
        float baseBottomZ = z - UPVECTOR.z() * w / 2.0f;
        float height = node.size() * 3.0f;
        float controlExterior1X = baseLeftX + UPVECTOR.x() * height;
        float controlExterior1Y = baseLeftY + UPVECTOR.y() * height;
        float controlExterior1Z = baseLeftZ + UPVECTOR.z() * height;
        float controlExterior2X = baseBottomX + SIDEVECTOR.x() * height;
        float controlExterior2Y = baseBottomY + SIDEVECTOR.y() * height;
        float controlExterior2Z = baseBottomZ + SIDEVECTOR.z() * height;
        float controlInterior1X = baseRightX + UPVECTOR.x() * (height /= 1.15f);
        float controlInterior1Y = baseRightY + UPVECTOR.y() * height;
        float controlInterior1Z = baseRightZ + UPVECTOR.z() * height;
        float controlInterior2X = baseTopX + SIDEVECTOR.x() * height;
        float controlInterior2Y = baseTopY + SIDEVECTOR.y() * height;
        float controlInterior2Z = baseTopZ + SIDEVECTOR.z() * height;
        buffer.rewind();
        buffer.put(baseRightX);
        buffer.put(baseRightY);
        buffer.put(baseRightZ);
        buffer.put(controlInterior1X);
        buffer.put(controlInterior1Y);
        buffer.put(controlInterior1Z);
        buffer.put(controlInterior2X);
        buffer.put(controlInterior2Y);
        buffer.put(controlInterior2Z);
        buffer.put(baseTopX);
        buffer.put(baseTopY);
        buffer.put(baseTopZ);
        buffer.put(baseLeftX);
        buffer.put(baseLeftY);
        buffer.put(baseLeftZ);
        buffer.put(controlExterior1X);
        buffer.put(controlExterior1Y);
        buffer.put(controlExterior1Z);
        buffer.put(controlExterior2X);
        buffer.put(controlExterior2Y);
        buffer.put(controlExterior2Z);
        buffer.put(baseBottomX);
        buffer.put(baseBottomY);
        buffer.put(baseBottomZ);
        buffer.rewind();
        if (!this.selected) {
            float b;
            float g;
            float r;
            float a = this.edge.alpha();
            if (vizModel.isEdgeHasUniColor()) {
                float[] uni = vizModel.getEdgeUniColor();
                r = uni[0];
                g = uni[1];
                b = uni[2];
                a = uni[3];
            } else if (a == 0.0f) {
                Node source = this.edge.getSource();
                r = source.r();
                g = source.g();
                b = source.b();
                a = source.alpha();
            } else {
                g = this.edge.g();
                b = this.edge.b();
                r = this.edge.r();
                a = this.edge.alpha();
            }
            if (vizModel.getConfig().isLightenNonSelected()) {
                float lightColorFactor = vizModel.getConfig().getLightenNonSelectedFactor();
                a -= (a - 0.01f) * lightColorFactor;
                gl.glColor4f(r, g, b, a);
            } else {
                gl.glColor4f(r, g, b, a);
            }
        } else {
            float r = 0.0f;
            float g = 0.0f;
            float b = 0.0f;
            if (vizModel.isEdgeSelectionColor()) {
                if (this.nodeModel.isSelected()) {
                    float[] both = vizModel.getEdgeBothSelectionColor();
                    r = both[0];
                    g = both[1];
                    b = both[2];
                }
            } else {
                r = this.edge.r();
                g = this.edge.g();
                b = this.edge.b();
                if (this.edge.alpha() == 0.0f) {
                    Node source = this.edge.getSource();
                    r = source.r();
                    g = source.g();
                    b = source.b();
                }
                r = Math.min(1.0f, 0.5f * r + 0.5f);
                g = Math.min(1.0f, 0.5f * g + 0.5f);
                b = Math.min(1.0f, 0.5f * b + 0.5f);
            }
            gl.glColor4f(r, g, b, 1.0f);
        }
        gl.glMap2f(3511, 0.0f, 1.0f, 3, 4, 0.0f, 1.0f, 12, 2, buffer);
        gl.glEnable(3511);
        gl.glMapGrid2f(segments, 0.0f, 1.0f, 1, 0.0f, 1.0f);
        gl.glEvalMesh2(6914, 0, segments, 0, 1);
        gl.glDisable(3511);
        gl.glEnd();
        gl.glBegin(4);
    }

    @Override
    public void displayArrow(GL2 gl, GLU glu, VizModel model) {
    }

    @Override
    public boolean isAutoSelected() {
        return this.nodeModel.isSelected();
    }

    @Override
    public NodeModel getSourceModel() {
        return this.nodeModel;
    }

    @Override
    public NodeModel getTargetModel() {
        return this.nodeModel;
    }
}

