/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.impl;

import cern.colt.matrix.impl.AbstractFormatter;
import cern.colt.matrix.impl.AbstractMatrix;

public abstract class AbstractMatrix1D
extends AbstractMatrix {
    protected int size;
    protected int zero;
    protected int stride;

    protected AbstractMatrix1D() {
    }

    protected int _offset(int n) {
        return n;
    }

    protected int _rank(int n) {
        return this.zero + n * this.stride;
    }

    protected void checkIndex(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException("Attempted to access " + this.toStringShort() + " at index=" + n);
        }
    }

    protected void checkIndexes(int[] nArray) {
        int n = nArray.length;
        while (--n >= 0) {
            int n2 = nArray[n];
            if (n2 >= 0 && n2 < this.size) continue;
            this.checkIndex(n2);
        }
    }

    protected void checkRange(int n, int n2) {
        if (n < 0 || n + n2 > this.size) {
            throw new IndexOutOfBoundsException("index: " + n + ", width: " + n2 + ", size=" + this.size);
        }
    }

    protected void checkSize(double[] dArray) {
        if (this.size != dArray.length) {
            throw new IllegalArgumentException("Incompatible sizes: " + this.toStringShort() + " and " + dArray.length);
        }
    }

    public void checkSize(AbstractMatrix1D abstractMatrix1D) {
        if (this.size != abstractMatrix1D.size) {
            throw new IllegalArgumentException("Incompatible sizes: " + this.toStringShort() + " and " + abstractMatrix1D.toStringShort());
        }
    }

    protected int index(int n) {
        return this._offset(this._rank(n));
    }

    protected void setUp(int n) {
        this.setUp(n, 0, 1);
    }

    protected void setUp(int n, int n2, int n3) {
        if (n < 0) {
            throw new IllegalArgumentException("negative size");
        }
        this.size = n;
        this.zero = n2;
        this.stride = n3;
        this.isNoView = true;
    }

    public int size() {
        return this.size;
    }

    protected int stride(int n) {
        if (n != 0) {
            throw new IllegalArgumentException("invalid dimension: " + n + "used to access" + this.toStringShort());
        }
        return this.stride;
    }

    public String toStringShort() {
        return AbstractFormatter.shape(this);
    }

    protected AbstractMatrix1D vFlip() {
        if (this.size > 0) {
            this.zero += (this.size - 1) * this.stride;
            this.stride = -this.stride;
            this.isNoView = false;
        }
        return this;
    }

    protected AbstractMatrix1D vPart(int n, int n2) {
        this.checkRange(n, n2);
        this.zero += this.stride * n;
        this.size = n2;
        this.isNoView = false;
        return this;
    }

    protected AbstractMatrix1D vStrides(int n) {
        if (n <= 0) {
            throw new IndexOutOfBoundsException("illegal stride: " + n);
        }
        this.stride *= n;
        if (this.size != 0) {
            this.size = (this.size - 1) / n + 1;
        }
        this.isNoView = false;
        return this;
    }
}

