/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.swing.ImageIcon;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.preferences.sources.SourceEntry;
import org.openstreetmap.josm.data.preferences.sources.SourceType;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;
import org.openstreetmap.josm.gui.mappaint.MultiCascade;
import org.openstreetmap.josm.gui.mappaint.StyleSetting;
import org.openstreetmap.josm.io.CachedFile;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageOverlay;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Utils;

public abstract class StyleSource
extends SourceEntry {
    private final List<Throwable> errors = new CopyOnWriteArrayList<Throwable>();
    private final Set<String> warnings = new CopyOnWriteArraySet<String>();
    protected boolean loaded;
    public File zipIcons;
    private ImageProvider imageIconProvider;
    private static ImageProvider defaultIconProvider;
    public String icon;
    public final List<StyleSetting> settings = new ArrayList<StyleSetting>();
    public Map<String, Object> settingValues = new HashMap<String, Object>();
    public final Map<StyleSetting.StyleSettingGroup, List<StyleSetting>> settingGroups = new TreeMap<StyleSetting.StyleSettingGroup, List<StyleSetting>>();

    public StyleSource(String url, String name, String title) {
        super(SourceType.MAP_PAINT_STYLE, url, name, title, true);
    }

    public StyleSource(SourceEntry entry) {
        super(entry);
    }

    public abstract void apply(MultiCascade var1, IPrimitive var2, double var3, boolean var5);

    public void loadStyleSource() {
        this.loadStyleSource(false);
    }

    public abstract void loadStyleSource(boolean var1);

    public abstract InputStream getSourceInputStream() throws IOException;

    public abstract CachedFile getCachedFile() throws IOException;

    public void closeSourceInputStream(InputStream is) {
        Utils.close(is);
    }

    public void logError(Throwable e) {
        this.errors.add(e);
    }

    public void logWarning(String w) {
        this.warnings.add(w);
    }

    public Collection<Throwable> getErrors() {
        return Collections.unmodifiableCollection(this.errors);
    }

    public Collection<String> getWarnings() {
        return Collections.unmodifiableCollection(this.warnings);
    }

    public boolean isValid() {
        return this.errors.isEmpty() && this.warnings.isEmpty();
    }

    protected void init() {
        this.errors.clear();
        this.imageIconProvider = null;
        this.icon = null;
    }

    private static synchronized ImageProvider getDefaultIconProvider() {
        if (defaultIconProvider == null) {
            defaultIconProvider = new ImageProvider("dialogs/mappaint", "pencil");
        }
        return defaultIconProvider;
    }

    protected ImageProvider getSourceIconProvider() {
        if (this.imageIconProvider == null) {
            if (this.icon != null) {
                this.imageIconProvider = MapPaintStyles.getIconProvider(new MapPaintStyles.IconReference(this.icon, this), true);
            }
            if (this.imageIconProvider == null) {
                this.imageIconProvider = StyleSource.getDefaultIconProvider();
            }
        }
        return this.imageIconProvider;
    }

    public final ImageProvider getIconProvider() {
        ImageProvider i = this.getSourceIconProvider();
        if (!this.getErrors().isEmpty()) {
            i = new ImageProvider(i).addOverlay(new ImageOverlay(new ImageProvider("misc", "error"), 0.5, 0.5, 1.0, 1.0));
        } else if (!this.getWarnings().isEmpty()) {
            i = new ImageProvider(i).addOverlay(new ImageOverlay(new ImageProvider("warning-small"), 0.5, 0.5, 1.0, 1.0));
        }
        return i.setOptional(true);
    }

    public final ImageIcon getIcon() {
        return this.getIconProvider().setMaxSize(ImageProvider.ImageSizes.MENU).get();
    }

    public String getToolTipText() {
        if (this.errors.isEmpty() && this.warnings.isEmpty()) {
            return null;
        }
        int n = this.errors.size() + this.warnings.size();
        return I18n.trn("There was an error when loading this style. Select ''Info'' from the right click menu for details.", "There were {0} errors when loading this style. Select ''Info'' from the right click menu for details.", n, n);
    }

    public Color getBackgroundColorOverride() {
        return null;
    }

    public final boolean isLoaded() {
        return this.loaded;
    }
}

