# This file was automatically generated by SWIG (http://www.swig.org).
# Version 4.0.1
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

from sys import version_info as _swig_python_version_info
if _swig_python_version_info < (2, 7, 0):
    raise RuntimeError("Python 2.7 or later required")

# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _openshot
else:
    import _openshot

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "thisown":
            self.this.own(value)
        elif name == "this":
            set(self, name, value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    r"""Proxy of C++ swig::SwigPyIterator class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _openshot.delete_SwigPyIterator

    def value(self):
        r"""value(SwigPyIterator self) -> PyObject *"""
        return _openshot.SwigPyIterator_value(self)

    def incr(self, n=1):
        r"""incr(SwigPyIterator self, size_t n=1) -> SwigPyIterator"""
        return _openshot.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        r"""decr(SwigPyIterator self, size_t n=1) -> SwigPyIterator"""
        return _openshot.SwigPyIterator_decr(self, n)

    def distance(self, x):
        r"""distance(SwigPyIterator self, SwigPyIterator x) -> ptrdiff_t"""
        return _openshot.SwigPyIterator_distance(self, x)

    def equal(self, x):
        r"""equal(SwigPyIterator self, SwigPyIterator x) -> bool"""
        return _openshot.SwigPyIterator_equal(self, x)

    def copy(self):
        r"""copy(SwigPyIterator self) -> SwigPyIterator"""
        return _openshot.SwigPyIterator_copy(self)

    def next(self):
        r"""next(SwigPyIterator self) -> PyObject *"""
        return _openshot.SwigPyIterator_next(self)

    def __next__(self):
        r"""__next__(SwigPyIterator self) -> PyObject *"""
        return _openshot.SwigPyIterator___next__(self)

    def previous(self):
        r"""previous(SwigPyIterator self) -> PyObject *"""
        return _openshot.SwigPyIterator_previous(self)

    def advance(self, n):
        r"""advance(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator"""
        return _openshot.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        r"""__eq__(SwigPyIterator self, SwigPyIterator x) -> bool"""
        return _openshot.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        r"""__ne__(SwigPyIterator self, SwigPyIterator x) -> bool"""
        return _openshot.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        r"""__iadd__(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator"""
        return _openshot.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        r"""__isub__(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator"""
        return _openshot.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        r"""__add__(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator"""
        return _openshot.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        r"""
        __sub__(SwigPyIterator self, ptrdiff_t n) -> SwigPyIterator
        __sub__(SwigPyIterator self, SwigPyIterator x) -> ptrdiff_t
        """
        return _openshot.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _openshot:
_openshot.SwigPyIterator_swigregister(SwigPyIterator)

SHARED_PTR_DISOWN = _openshot.SHARED_PTR_DISOWN

OPENSHOT_VERSION_MAJOR = _openshot.OPENSHOT_VERSION_MAJOR

OPENSHOT_VERSION_MINOR = _openshot.OPENSHOT_VERSION_MINOR

OPENSHOT_VERSION_BUILD = _openshot.OPENSHOT_VERSION_BUILD

OPENSHOT_VERSION_SO = _openshot.OPENSHOT_VERSION_SO

OPENSHOT_VERSION_MAJOR_MINOR = _openshot.OPENSHOT_VERSION_MAJOR_MINOR

OPENSHOT_VERSION_ALL = _openshot.OPENSHOT_VERSION_ALL

class OpenShotVersion(object):
    r"""Proxy of C++ openshot::OpenShotVersion class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    major = property(_openshot.OpenShotVersion_major_get, _openshot.OpenShotVersion_major_set, doc=r"""major : int""")
    minor = property(_openshot.OpenShotVersion_minor_get, _openshot.OpenShotVersion_minor_set, doc=r"""minor : int""")
    build = property(_openshot.OpenShotVersion_build_get, _openshot.OpenShotVersion_build_set, doc=r"""build : int""")
    so = property(_openshot.OpenShotVersion_so_get, _openshot.OpenShotVersion_so_set, doc=r"""so : int""")

    def ToString(self):
        r"""ToString(OpenShotVersion self) -> std::string"""
        return _openshot.OpenShotVersion_ToString(self)

    def __init__(self):
        r"""__init__(OpenShotVersion self) -> OpenShotVersion"""
        _openshot.OpenShotVersion_swiginit(self, _openshot.new_OpenShotVersion())
    __swig_destroy__ = _openshot.delete_OpenShotVersion

# Register OpenShotVersion in _openshot:
_openshot.OpenShotVersion_swigregister(OpenShotVersion)


def GetVersion():
    r"""GetVersion() -> OpenShotVersion"""
    return _openshot.GetVersion()
class ReaderInfo(object):
    r"""Proxy of C++ openshot::ReaderInfo class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    has_video = property(_openshot.ReaderInfo_has_video_get, _openshot.ReaderInfo_has_video_set, doc=r"""has_video : bool""")
    has_audio = property(_openshot.ReaderInfo_has_audio_get, _openshot.ReaderInfo_has_audio_set, doc=r"""has_audio : bool""")
    has_single_image = property(_openshot.ReaderInfo_has_single_image_get, _openshot.ReaderInfo_has_single_image_set, doc=r"""has_single_image : bool""")
    duration = property(_openshot.ReaderInfo_duration_get, _openshot.ReaderInfo_duration_set, doc=r"""duration : float""")
    file_size = property(_openshot.ReaderInfo_file_size_get, _openshot.ReaderInfo_file_size_set, doc=r"""file_size : int64_t""")
    height = property(_openshot.ReaderInfo_height_get, _openshot.ReaderInfo_height_set, doc=r"""height : int""")
    width = property(_openshot.ReaderInfo_width_get, _openshot.ReaderInfo_width_set, doc=r"""width : int""")
    pixel_format = property(_openshot.ReaderInfo_pixel_format_get, _openshot.ReaderInfo_pixel_format_set, doc=r"""pixel_format : int""")
    fps = property(_openshot.ReaderInfo_fps_get, _openshot.ReaderInfo_fps_set, doc=r"""fps : Fraction""")
    video_bit_rate = property(_openshot.ReaderInfo_video_bit_rate_get, _openshot.ReaderInfo_video_bit_rate_set, doc=r"""video_bit_rate : int""")
    pixel_ratio = property(_openshot.ReaderInfo_pixel_ratio_get, _openshot.ReaderInfo_pixel_ratio_set, doc=r"""pixel_ratio : Fraction""")
    display_ratio = property(_openshot.ReaderInfo_display_ratio_get, _openshot.ReaderInfo_display_ratio_set, doc=r"""display_ratio : Fraction""")
    vcodec = property(_openshot.ReaderInfo_vcodec_get, _openshot.ReaderInfo_vcodec_set, doc=r"""vcodec : std::string""")
    video_length = property(_openshot.ReaderInfo_video_length_get, _openshot.ReaderInfo_video_length_set, doc=r"""video_length : int64_t""")
    video_stream_index = property(_openshot.ReaderInfo_video_stream_index_get, _openshot.ReaderInfo_video_stream_index_set, doc=r"""video_stream_index : int""")
    video_timebase = property(_openshot.ReaderInfo_video_timebase_get, _openshot.ReaderInfo_video_timebase_set, doc=r"""video_timebase : Fraction""")
    interlaced_frame = property(_openshot.ReaderInfo_interlaced_frame_get, _openshot.ReaderInfo_interlaced_frame_set, doc=r"""interlaced_frame : bool""")
    top_field_first = property(_openshot.ReaderInfo_top_field_first_get, _openshot.ReaderInfo_top_field_first_set, doc=r"""top_field_first : bool""")
    acodec = property(_openshot.ReaderInfo_acodec_get, _openshot.ReaderInfo_acodec_set, doc=r"""acodec : std::string""")
    audio_bit_rate = property(_openshot.ReaderInfo_audio_bit_rate_get, _openshot.ReaderInfo_audio_bit_rate_set, doc=r"""audio_bit_rate : int""")
    sample_rate = property(_openshot.ReaderInfo_sample_rate_get, _openshot.ReaderInfo_sample_rate_set, doc=r"""sample_rate : int""")
    channels = property(_openshot.ReaderInfo_channels_get, _openshot.ReaderInfo_channels_set, doc=r"""channels : int""")
    channel_layout = property(_openshot.ReaderInfo_channel_layout_get, _openshot.ReaderInfo_channel_layout_set, doc=r"""channel_layout : ChannelLayout""")
    audio_stream_index = property(_openshot.ReaderInfo_audio_stream_index_get, _openshot.ReaderInfo_audio_stream_index_set, doc=r"""audio_stream_index : int""")
    audio_timebase = property(_openshot.ReaderInfo_audio_timebase_get, _openshot.ReaderInfo_audio_timebase_set, doc=r"""audio_timebase : Fraction""")
    metadata = property(_openshot.ReaderInfo_metadata_get, _openshot.ReaderInfo_metadata_set, doc=r"""metadata : std::map<(std::string,std::string,std::less<(std::string)>,std::allocator<(std::pair<(q(const).std::string,std::string)>)>)>""")

    def __init__(self):
        r"""__init__(ReaderInfo self) -> ReaderInfo"""
        _openshot.ReaderInfo_swiginit(self, _openshot.new_ReaderInfo())
    __swig_destroy__ = _openshot.delete_ReaderInfo

# Register ReaderInfo in _openshot:
_openshot.ReaderInfo_swigregister(ReaderInfo)

class ReaderBase(object):
    r"""Proxy of C++ openshot::ReaderBase class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    info = property(_openshot.ReaderBase_info_get, _openshot.ReaderBase_info_set, doc=r"""info : openshot::ReaderInfo""")

    def GetClip(self):
        r"""GetClip(ReaderBase self) -> ClipBase"""
        return _openshot.ReaderBase_GetClip(self)

    def SetClip(self, clip):
        r"""SetClip(ReaderBase self, ClipBase clip)"""
        return _openshot.ReaderBase_SetClip(self, clip)

    def Close(self):
        r"""Close(ReaderBase self)"""
        return _openshot.ReaderBase_Close(self)

    def DisplayInfo(self):
        r"""DisplayInfo(ReaderBase self)"""
        return _openshot.ReaderBase_DisplayInfo(self)

    def GetCache(self):
        r"""GetCache(ReaderBase self) -> CacheBase"""
        return _openshot.ReaderBase_GetCache(self)

    def GetFrame(self, number):
        r"""GetFrame(ReaderBase self, int64_t number) -> std::shared_ptr< openshot::Frame >"""
        return _openshot.ReaderBase_GetFrame(self, number)

    def IsOpen(self):
        r"""IsOpen(ReaderBase self) -> bool"""
        return _openshot.ReaderBase_IsOpen(self)

    def Name(self):
        r"""Name(ReaderBase self) -> std::string"""
        return _openshot.ReaderBase_Name(self)

    def Json(self):
        r"""Json(ReaderBase self) -> std::string"""
        return _openshot.ReaderBase_Json(self)

    def SetJson(self, value):
        r"""SetJson(ReaderBase self, std::string value)"""
        return _openshot.ReaderBase_SetJson(self, value)

    def JsonValue(self):
        r"""JsonValue(ReaderBase self) -> Json::Value"""
        return _openshot.ReaderBase_JsonValue(self)

    def SetJsonValue(self, root):
        r"""SetJsonValue(ReaderBase self, Json::Value root)"""
        return _openshot.ReaderBase_SetJsonValue(self, root)

    def Open(self):
        r"""Open(ReaderBase self)"""
        return _openshot.ReaderBase_Open(self)
    __swig_destroy__ = _openshot.delete_ReaderBase

# Register ReaderBase in _openshot:
_openshot.ReaderBase_swigregister(ReaderBase)

class WriterInfo(object):
    r"""Proxy of C++ openshot::WriterInfo class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    has_video = property(_openshot.WriterInfo_has_video_get, _openshot.WriterInfo_has_video_set, doc=r"""has_video : bool""")
    has_audio = property(_openshot.WriterInfo_has_audio_get, _openshot.WriterInfo_has_audio_set, doc=r"""has_audio : bool""")
    has_single_image = property(_openshot.WriterInfo_has_single_image_get, _openshot.WriterInfo_has_single_image_set, doc=r"""has_single_image : bool""")
    duration = property(_openshot.WriterInfo_duration_get, _openshot.WriterInfo_duration_set, doc=r"""duration : float""")
    file_size = property(_openshot.WriterInfo_file_size_get, _openshot.WriterInfo_file_size_set, doc=r"""file_size : int64_t""")
    height = property(_openshot.WriterInfo_height_get, _openshot.WriterInfo_height_set, doc=r"""height : int""")
    width = property(_openshot.WriterInfo_width_get, _openshot.WriterInfo_width_set, doc=r"""width : int""")
    pixel_format = property(_openshot.WriterInfo_pixel_format_get, _openshot.WriterInfo_pixel_format_set, doc=r"""pixel_format : int""")
    fps = property(_openshot.WriterInfo_fps_get, _openshot.WriterInfo_fps_set, doc=r"""fps : Fraction""")
    video_bit_rate = property(_openshot.WriterInfo_video_bit_rate_get, _openshot.WriterInfo_video_bit_rate_set, doc=r"""video_bit_rate : int""")
    pixel_ratio = property(_openshot.WriterInfo_pixel_ratio_get, _openshot.WriterInfo_pixel_ratio_set, doc=r"""pixel_ratio : Fraction""")
    display_ratio = property(_openshot.WriterInfo_display_ratio_get, _openshot.WriterInfo_display_ratio_set, doc=r"""display_ratio : Fraction""")
    vcodec = property(_openshot.WriterInfo_vcodec_get, _openshot.WriterInfo_vcodec_set, doc=r"""vcodec : std::string""")
    video_length = property(_openshot.WriterInfo_video_length_get, _openshot.WriterInfo_video_length_set, doc=r"""video_length : int64_t""")
    video_stream_index = property(_openshot.WriterInfo_video_stream_index_get, _openshot.WriterInfo_video_stream_index_set, doc=r"""video_stream_index : int""")
    video_timebase = property(_openshot.WriterInfo_video_timebase_get, _openshot.WriterInfo_video_timebase_set, doc=r"""video_timebase : Fraction""")
    interlaced_frame = property(_openshot.WriterInfo_interlaced_frame_get, _openshot.WriterInfo_interlaced_frame_set, doc=r"""interlaced_frame : bool""")
    top_field_first = property(_openshot.WriterInfo_top_field_first_get, _openshot.WriterInfo_top_field_first_set, doc=r"""top_field_first : bool""")
    acodec = property(_openshot.WriterInfo_acodec_get, _openshot.WriterInfo_acodec_set, doc=r"""acodec : std::string""")
    audio_bit_rate = property(_openshot.WriterInfo_audio_bit_rate_get, _openshot.WriterInfo_audio_bit_rate_set, doc=r"""audio_bit_rate : int""")
    sample_rate = property(_openshot.WriterInfo_sample_rate_get, _openshot.WriterInfo_sample_rate_set, doc=r"""sample_rate : int""")
    channels = property(_openshot.WriterInfo_channels_get, _openshot.WriterInfo_channels_set, doc=r"""channels : int""")
    channel_layout = property(_openshot.WriterInfo_channel_layout_get, _openshot.WriterInfo_channel_layout_set, doc=r"""channel_layout : ChannelLayout""")
    audio_stream_index = property(_openshot.WriterInfo_audio_stream_index_get, _openshot.WriterInfo_audio_stream_index_set, doc=r"""audio_stream_index : int""")
    audio_timebase = property(_openshot.WriterInfo_audio_timebase_get, _openshot.WriterInfo_audio_timebase_set, doc=r"""audio_timebase : Fraction""")
    metadata = property(_openshot.WriterInfo_metadata_get, _openshot.WriterInfo_metadata_set, doc=r"""metadata : std::map<(std::string,std::string,std::less<(std::string)>,std::allocator<(std::pair<(q(const).std::string,std::string)>)>)>""")

    def __init__(self):
        r"""__init__(WriterInfo self) -> WriterInfo"""
        _openshot.WriterInfo_swiginit(self, _openshot.new_WriterInfo())
    __swig_destroy__ = _openshot.delete_WriterInfo

# Register WriterInfo in _openshot:
_openshot.WriterInfo_swigregister(WriterInfo)

class WriterBase(object):
    r"""Proxy of C++ openshot::WriterBase class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    info = property(_openshot.WriterBase_info_get, _openshot.WriterBase_info_set, doc=r"""info : openshot::WriterInfo""")

    def CopyReaderInfo(self, reader):
        r"""CopyReaderInfo(WriterBase self, ReaderBase reader)"""
        return _openshot.WriterBase_CopyReaderInfo(self, reader)

    def IsOpen(self):
        r"""IsOpen(WriterBase self) -> bool"""
        return _openshot.WriterBase_IsOpen(self)

    def WriteFrame(self, *args):
        r"""
        WriteFrame(WriterBase self, std::shared_ptr< openshot::Frame > frame)
        WriteFrame(WriterBase self, ReaderBase reader, int64_t start, int64_t length)
        """
        return _openshot.WriterBase_WriteFrame(self, *args)

    def Json(self):
        r"""Json(WriterBase self) -> std::string"""
        return _openshot.WriterBase_Json(self)

    def JsonValue(self):
        r"""JsonValue(WriterBase self) -> Json::Value"""
        return _openshot.WriterBase_JsonValue(self)

    def SetJson(self, value):
        r"""SetJson(WriterBase self, std::string value)"""
        return _openshot.WriterBase_SetJson(self, value)

    def SetJsonValue(self, root):
        r"""SetJsonValue(WriterBase self, Json::Value root)"""
        return _openshot.WriterBase_SetJsonValue(self, root)

    def DisplayInfo(self):
        r"""DisplayInfo(WriterBase self)"""
        return _openshot.WriterBase_DisplayInfo(self)

    def Open(self):
        r"""Open(WriterBase self)"""
        return _openshot.WriterBase_Open(self)
    __swig_destroy__ = _openshot.delete_WriterBase

# Register WriterBase in _openshot:
_openshot.WriterBase_swigregister(WriterBase)

class CacheBase(object):
    r"""Proxy of C++ openshot::CacheBase class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    def Add(self, frame):
        r"""Add(CacheBase self, std::shared_ptr< openshot::Frame > frame)"""
        return _openshot.CacheBase_Add(self, frame)

    def Clear(self):
        r"""Clear(CacheBase self)"""
        return _openshot.CacheBase_Clear(self)

    def Count(self):
        r"""Count(CacheBase self) -> int64_t"""
        return _openshot.CacheBase_Count(self)

    def GetFrame(self, frame_number):
        r"""GetFrame(CacheBase self, int64_t frame_number) -> std::shared_ptr< openshot::Frame >"""
        return _openshot.CacheBase_GetFrame(self, frame_number)

    def GetBytes(self):
        r"""GetBytes(CacheBase self) -> int64_t"""
        return _openshot.CacheBase_GetBytes(self)

    def GetSmallestFrame(self):
        r"""GetSmallestFrame(CacheBase self) -> std::shared_ptr< openshot::Frame >"""
        return _openshot.CacheBase_GetSmallestFrame(self)

    def Remove(self, *args):
        r"""
        Remove(CacheBase self, int64_t frame_number)
        Remove(CacheBase self, int64_t start_frame_number, int64_t end_frame_number)
        """
        return _openshot.CacheBase_Remove(self, *args)

    def GetMaxBytes(self):
        r"""GetMaxBytes(CacheBase self) -> int64_t"""
        return _openshot.CacheBase_GetMaxBytes(self)

    def SetMaxBytes(self, number_of_bytes):
        r"""SetMaxBytes(CacheBase self, int64_t number_of_bytes)"""
        return _openshot.CacheBase_SetMaxBytes(self, number_of_bytes)

    def SetMaxBytesFromInfo(self, number_of_frames, width, height, sample_rate, channels):
        r"""SetMaxBytesFromInfo(CacheBase self, int64_t number_of_frames, int width, int height, int sample_rate, int channels)"""
        return _openshot.CacheBase_SetMaxBytesFromInfo(self, number_of_frames, width, height, sample_rate, channels)

    def Json(self):
        r"""Json(CacheBase self) -> std::string"""
        return _openshot.CacheBase_Json(self)

    def SetJson(self, value):
        r"""SetJson(CacheBase self, std::string value)"""
        return _openshot.CacheBase_SetJson(self, value)

    def JsonValue(self):
        r"""JsonValue(CacheBase self) -> Json::Value"""
        return _openshot.CacheBase_JsonValue(self)

    def SetJsonValue(self, root):
        r"""SetJsonValue(CacheBase self, Json::Value root)"""
        return _openshot.CacheBase_SetJsonValue(self, root)
    __swig_destroy__ = _openshot.delete_CacheBase

# Register CacheBase in _openshot:
_openshot.CacheBase_swigregister(CacheBase)

class CacheDisk(CacheBase):
    r"""Proxy of C++ openshot::CacheDisk class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(CacheDisk self, std::string cache_path, std::string format, float quality, float scale) -> CacheDisk
        __init__(CacheDisk self, std::string cache_path, std::string format, float quality, float scale, int64_t max_bytes) -> CacheDisk
        """
        _openshot.CacheDisk_swiginit(self, _openshot.new_CacheDisk(*args))
    __swig_destroy__ = _openshot.delete_CacheDisk

    def Add(self, frame):
        r"""Add(CacheDisk self, std::shared_ptr< openshot::Frame > frame)"""
        return _openshot.CacheDisk_Add(self, frame)

    def Clear(self):
        r"""Clear(CacheDisk self)"""
        return _openshot.CacheDisk_Clear(self)

    def Count(self):
        r"""Count(CacheDisk self) -> int64_t"""
        return _openshot.CacheDisk_Count(self)

    def GetFrame(self, frame_number):
        r"""GetFrame(CacheDisk self, int64_t frame_number) -> std::shared_ptr< openshot::Frame >"""
        return _openshot.CacheDisk_GetFrame(self, frame_number)

    def GetBytes(self):
        r"""GetBytes(CacheDisk self) -> int64_t"""
        return _openshot.CacheDisk_GetBytes(self)

    def GetSmallestFrame(self):
        r"""GetSmallestFrame(CacheDisk self) -> std::shared_ptr< openshot::Frame >"""
        return _openshot.CacheDisk_GetSmallestFrame(self)

    def MoveToFront(self, frame_number):
        r"""MoveToFront(CacheDisk self, int64_t frame_number)"""
        return _openshot.CacheDisk_MoveToFront(self, frame_number)

    def Remove(self, *args):
        r"""
        Remove(CacheDisk self, int64_t frame_number)
        Remove(CacheDisk self, int64_t start_frame_number, int64_t end_frame_number)
        """
        return _openshot.CacheDisk_Remove(self, *args)

    def Json(self):
        r"""Json(CacheDisk self) -> std::string"""
        return _openshot.CacheDisk_Json(self)

    def SetJson(self, value):
        r"""SetJson(CacheDisk self, std::string value)"""
        return _openshot.CacheDisk_SetJson(self, value)

    def JsonValue(self):
        r"""JsonValue(CacheDisk self) -> Json::Value"""
        return _openshot.CacheDisk_JsonValue(self)

    def SetJsonValue(self, root):
        r"""SetJsonValue(CacheDisk self, Json::Value root)"""
        return _openshot.CacheDisk_SetJsonValue(self, root)

# Register CacheDisk in _openshot:
_openshot.CacheDisk_swigregister(CacheDisk)

class CacheMemory(CacheBase):
    r"""Proxy of C++ openshot::CacheMemory class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(CacheMemory self) -> CacheMemory
        __init__(CacheMemory self, int64_t max_bytes) -> CacheMemory
        """
        _openshot.CacheMemory_swiginit(self, _openshot.new_CacheMemory(*args))
    __swig_destroy__ = _openshot.delete_CacheMemory

    def Add(self, frame):
        r"""Add(CacheMemory self, std::shared_ptr< openshot::Frame > frame)"""
        return _openshot.CacheMemory_Add(self, frame)

    def Clear(self):
        r"""Clear(CacheMemory self)"""
        return _openshot.CacheMemory_Clear(self)

    def Count(self):
        r"""Count(CacheMemory self) -> int64_t"""
        return _openshot.CacheMemory_Count(self)

    def GetFrame(self, frame_number):
        r"""GetFrame(CacheMemory self, int64_t frame_number) -> std::shared_ptr< openshot::Frame >"""
        return _openshot.CacheMemory_GetFrame(self, frame_number)

    def GetBytes(self):
        r"""GetBytes(CacheMemory self) -> int64_t"""
        return _openshot.CacheMemory_GetBytes(self)

    def GetSmallestFrame(self):
        r"""GetSmallestFrame(CacheMemory self) -> std::shared_ptr< openshot::Frame >"""
        return _openshot.CacheMemory_GetSmallestFrame(self)

    def MoveToFront(self, frame_number):
        r"""MoveToFront(CacheMemory self, int64_t frame_number)"""
        return _openshot.CacheMemory_MoveToFront(self, frame_number)

    def Remove(self, *args):
        r"""
        Remove(CacheMemory self, int64_t frame_number)
        Remove(CacheMemory self, int64_t start_frame_number, int64_t end_frame_number)
        """
        return _openshot.CacheMemory_Remove(self, *args)

    def Json(self):
        r"""Json(CacheMemory self) -> std::string"""
        return _openshot.CacheMemory_Json(self)

    def SetJson(self, value):
        r"""SetJson(CacheMemory self, std::string value)"""
        return _openshot.CacheMemory_SetJson(self, value)

    def JsonValue(self):
        r"""JsonValue(CacheMemory self) -> Json::Value"""
        return _openshot.CacheMemory_JsonValue(self)

    def SetJsonValue(self, root):
        r"""SetJsonValue(CacheMemory self, Json::Value root)"""
        return _openshot.CacheMemory_SetJsonValue(self, root)

# Register CacheMemory in _openshot:
_openshot.CacheMemory_swigregister(CacheMemory)

LAYOUT_MONO = _openshot.LAYOUT_MONO

LAYOUT_STEREO = _openshot.LAYOUT_STEREO

LAYOUT_2POINT1 = _openshot.LAYOUT_2POINT1

LAYOUT_2_1 = _openshot.LAYOUT_2_1

LAYOUT_SURROUND = _openshot.LAYOUT_SURROUND

LAYOUT_3POINT1 = _openshot.LAYOUT_3POINT1

LAYOUT_4POINT0 = _openshot.LAYOUT_4POINT0

LAYOUT_4POINT1 = _openshot.LAYOUT_4POINT1

LAYOUT_2_2 = _openshot.LAYOUT_2_2

LAYOUT_QUAD = _openshot.LAYOUT_QUAD

LAYOUT_5POINT0 = _openshot.LAYOUT_5POINT0

LAYOUT_5POINT1 = _openshot.LAYOUT_5POINT1

LAYOUT_5POINT0_BACK = _openshot.LAYOUT_5POINT0_BACK

LAYOUT_5POINT1_BACK = _openshot.LAYOUT_5POINT1_BACK

LAYOUT_6POINT0 = _openshot.LAYOUT_6POINT0

LAYOUT_6POINT0_FRONT = _openshot.LAYOUT_6POINT0_FRONT

LAYOUT_HEXAGONAL = _openshot.LAYOUT_HEXAGONAL

LAYOUT_6POINT1 = _openshot.LAYOUT_6POINT1

LAYOUT_6POINT1_BACK = _openshot.LAYOUT_6POINT1_BACK

LAYOUT_6POINT1_FRONT = _openshot.LAYOUT_6POINT1_FRONT

LAYOUT_7POINT0 = _openshot.LAYOUT_7POINT0

LAYOUT_7POINT0_FRONT = _openshot.LAYOUT_7POINT0_FRONT

LAYOUT_7POINT1 = _openshot.LAYOUT_7POINT1

LAYOUT_7POINT1_WIDE = _openshot.LAYOUT_7POINT1_WIDE

LAYOUT_7POINT1_WIDE_BACK = _openshot.LAYOUT_7POINT1_WIDE_BACK

LAYOUT_OCTAGONAL = _openshot.LAYOUT_OCTAGONAL

LAYOUT_STEREO_DOWNMIX = _openshot.LAYOUT_STEREO_DOWNMIX

class ChunkLocation(object):
    r"""Proxy of C++ openshot::ChunkLocation class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    number = property(_openshot.ChunkLocation_number_get, _openshot.ChunkLocation_number_set, doc=r"""number : int64_t""")
    frame = property(_openshot.ChunkLocation_frame_get, _openshot.ChunkLocation_frame_set, doc=r"""frame : int64_t""")

    def __init__(self):
        r"""__init__(ChunkLocation self) -> ChunkLocation"""
        _openshot.ChunkLocation_swiginit(self, _openshot.new_ChunkLocation())
    __swig_destroy__ = _openshot.delete_ChunkLocation

# Register ChunkLocation in _openshot:
_openshot.ChunkLocation_swigregister(ChunkLocation)

THUMBNAIL = _openshot.THUMBNAIL

PREVIEW = _openshot.PREVIEW

FINAL = _openshot.FINAL

class ChunkReader(ReaderBase):
    r"""Proxy of C++ openshot::ChunkReader class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, path, chunk_version):
        r"""__init__(ChunkReader self, std::string path, openshot::ChunkVersion chunk_version) -> ChunkReader"""
        _openshot.ChunkReader_swiginit(self, _openshot.new_ChunkReader(path, chunk_version))

    def Close(self):
        r"""Close(ChunkReader self)"""
        return _openshot.ChunkReader_Close(self)

    def GetChunkSize(self):
        r"""GetChunkSize(ChunkReader self) -> int64_t"""
        return _openshot.ChunkReader_GetChunkSize(self)

    def SetChunkSize(self, new_size):
        r"""SetChunkSize(ChunkReader self, int64_t new_size)"""
        return _openshot.ChunkReader_SetChunkSize(self, new_size)

    def GetCache(self):
        r"""GetCache(ChunkReader self) -> CacheMemory"""
        return _openshot.ChunkReader_GetCache(self)

    def GetFrame(self, requested_frame):
        r"""GetFrame(ChunkReader self, int64_t requested_frame) -> std::shared_ptr< openshot::Frame >"""
        return _openshot.ChunkReader_GetFrame(self, requested_frame)

    def IsOpen(self):
        r"""IsOpen(ChunkReader self) -> bool"""
        return _openshot.ChunkReader_IsOpen(self)

    def Name(self):
        r"""Name(ChunkReader self) -> std::string"""
        return _openshot.ChunkReader_Name(self)

    def Json(self):
        r"""Json(ChunkReader self) -> std::string"""
        return _openshot.ChunkReader_Json(self)

    def SetJson(self, value):
        r"""SetJson(ChunkReader self, std::string value)"""
        return _openshot.ChunkReader_SetJson(self, value)

    def JsonValue(self):
        r"""JsonValue(ChunkReader self) -> Json::Value"""
        return _openshot.ChunkReader_JsonValue(self)

    def SetJsonValue(self, root):
        r"""SetJsonValue(ChunkReader self, Json::Value root)"""
        return _openshot.ChunkReader_SetJsonValue(self, root)

    def Open(self):
        r"""Open(ChunkReader self)"""
        return _openshot.ChunkReader_Open(self)
    __swig_destroy__ = _openshot.delete_ChunkReader

# Register ChunkReader in _openshot:
_openshot.ChunkReader_swigregister(ChunkReader)

class ChunkWriter(WriterBase):
    r"""Proxy of C++ openshot::ChunkWriter class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, path, reader):
        r"""__init__(ChunkWriter self, std::string path, ReaderBase reader) -> ChunkWriter"""
        _openshot.ChunkWriter_swiginit(self, _openshot.new_ChunkWriter(path, reader))

    def Close(self):
        r"""Close(ChunkWriter self)"""
        return _openshot.ChunkWriter_Close(self)

    def GetChunkSize(self):
        r"""GetChunkSize(ChunkWriter self) -> int64_t"""
        return _openshot.ChunkWriter_GetChunkSize(self)

    def IsOpen(self):
        r"""IsOpen(ChunkWriter self) -> bool"""
        return _openshot.ChunkWriter_IsOpen(self)

    def Open(self):
        r"""Open(ChunkWriter self)"""
        return _openshot.ChunkWriter_Open(self)

    def SetChunkSize(self, new_size):
        r"""SetChunkSize(ChunkWriter self, int64_t new_size)"""
        return _openshot.ChunkWriter_SetChunkSize(self, new_size)

    def WriteFrame(self, *args):
        r"""
        WriteFrame(ChunkWriter self, std::shared_ptr< openshot::Frame > frame)
        WriteFrame(ChunkWriter self, int64_t start, int64_t length)
        WriteFrame(ChunkWriter self, ReaderBase reader, int64_t start, int64_t length)
        """
        return _openshot.ChunkWriter_WriteFrame(self, *args)
    __swig_destroy__ = _openshot.delete_ChunkWriter

# Register ChunkWriter in _openshot:
_openshot.ChunkWriter_swigregister(ChunkWriter)

class ClipBase(object):
    r"""Proxy of C++ openshot::ClipBase class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    def __lt__(self, a):
        r"""__lt__(ClipBase self, ClipBase a) -> bool"""
        return _openshot.ClipBase___lt__(self, a)

    def __le__(self, a):
        r"""__le__(ClipBase self, ClipBase a) -> bool"""
        return _openshot.ClipBase___le__(self, a)

    def __gt__(self, a):
        r"""__gt__(ClipBase self, ClipBase a) -> bool"""
        return _openshot.ClipBase___gt__(self, a)

    def __ge__(self, a):
        r"""__ge__(ClipBase self, ClipBase a) -> bool"""
        return _openshot.ClipBase___ge__(self, a)

    def Duration(self):
        r"""Duration(ClipBase self) -> float"""
        return _openshot.ClipBase_Duration(self)

    def Id(self, *args):
        r"""
        Id(ClipBase self) -> std::string
        Id(ClipBase self, std::string value)
        """
        return _openshot.ClipBase_Id(self, *args)

    def Position(self, *args):
        r"""
        Position(ClipBase self) -> float
        Position(ClipBase self, float value)
        """
        return _openshot.ClipBase_Position(self, *args)

    def Layer(self, *args):
        r"""
        Layer(ClipBase self) -> int
        Layer(ClipBase self, int value)
        """
        return _openshot.ClipBase_Layer(self, *args)

    def Start(self, *args):
        r"""
        Start(ClipBase self) -> float
        Start(ClipBase self, float value)
        """
        return _openshot.ClipBase_Start(self, *args)

    def End(self, *args):
        r"""
        End(ClipBase self) -> float
        End(ClipBase self, float value)
        """
        return _openshot.ClipBase_End(self, *args)

    def Json(self):
        r"""Json(ClipBase self) -> std::string"""
        return _openshot.ClipBase_Json(self)

    def SetJson(self, value):
        r"""SetJson(ClipBase self, std::string value)"""
        return _openshot.ClipBase_SetJson(self, value)

    def JsonValue(self):
        r"""JsonValue(ClipBase self) -> Json::Value"""
        return _openshot.ClipBase_JsonValue(self)

    def SetJsonValue(self, root):
        r"""SetJsonValue(ClipBase self, Json::Value root)"""
        return _openshot.ClipBase_SetJsonValue(self, root)

    def PropertiesJSON(self, requested_frame):
        r"""PropertiesJSON(ClipBase self, int64_t requested_frame) -> std::string"""
        return _openshot.ClipBase_PropertiesJSON(self, requested_frame)
    __swig_destroy__ = _openshot.delete_ClipBase

# Register ClipBase in _openshot:
_openshot.ClipBase_swigregister(ClipBase)

class CompareClipEffects(object):
    r"""Proxy of C++ openshot::CompareClipEffects class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __call__(self, lhs, rhs):
        r"""__call__(CompareClipEffects self, EffectBase lhs, EffectBase rhs) -> bool"""
        return _openshot.CompareClipEffects___call__(self, lhs, rhs)

    def __init__(self):
        r"""__init__(CompareClipEffects self) -> CompareClipEffects"""
        _openshot.CompareClipEffects_swiginit(self, _openshot.new_CompareClipEffects())
    __swig_destroy__ = _openshot.delete_CompareClipEffects

# Register CompareClipEffects in _openshot:
_openshot.CompareClipEffects_swigregister(CompareClipEffects)

class Clip(ClipBase):
    r"""Proxy of C++ openshot::Clip class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    gravity = property(_openshot.Clip_gravity_get, _openshot.Clip_gravity_set, doc=r"""gravity : GravityType""")
    scale = property(_openshot.Clip_scale_get, _openshot.Clip_scale_set, doc=r"""scale : ScaleType""")
    anchor = property(_openshot.Clip_anchor_get, _openshot.Clip_anchor_set, doc=r"""anchor : AnchorType""")
    display = property(_openshot.Clip_display_get, _openshot.Clip_display_set, doc=r"""display : FrameDisplayType""")
    mixing = property(_openshot.Clip_mixing_get, _openshot.Clip_mixing_set, doc=r"""mixing : VolumeMixType""")

    def __init__(self, *args):
        r"""
        __init__(Clip self) -> Clip
        __init__(Clip self, std::string path) -> Clip
        __init__(Clip self, ReaderBase new_reader) -> Clip
        """
        _openshot.Clip_swiginit(self, _openshot.new_Clip(*args))
    __swig_destroy__ = _openshot.delete_Clip

    def AddEffect(self, effect):
        r"""AddEffect(Clip self, EffectBase effect)"""
        return _openshot.Clip_AddEffect(self, effect)

    def Close(self):
        r"""Close(Clip self)"""
        return _openshot.Clip_Close(self)

    def Effects(self):
        r"""Effects(Clip self) -> EffectBaseList"""
        return _openshot.Clip_Effects(self)

    def GetFrame(self, requested_frame):
        r"""GetFrame(Clip self, int64_t requested_frame) -> std::shared_ptr< openshot::Frame >"""
        return _openshot.Clip_GetFrame(self, requested_frame)

    def Open(self):
        r"""Open(Clip self)"""
        return _openshot.Clip_Open(self)

    def Reader(self, *args):
        r"""
        Reader(Clip self, ReaderBase new_reader)
        Reader(Clip self) -> ReaderBase
        """
        return _openshot.Clip_Reader(self, *args)

    def End(self, *args):
        r"""
        End(Clip self) -> float
        End(Clip self, float value)
        """
        return _openshot.Clip_End(self, *args)

    def Json(self):
        r"""Json(Clip self) -> std::string"""
        return _openshot.Clip_Json(self)

    def SetJson(self, value):
        r"""SetJson(Clip self, std::string value)"""
        return _openshot.Clip_SetJson(self, value)

    def JsonValue(self):
        r"""JsonValue(Clip self) -> Json::Value"""
        return _openshot.Clip_JsonValue(self)

    def SetJsonValue(self, root):
        r"""SetJsonValue(Clip self, Json::Value root)"""
        return _openshot.Clip_SetJsonValue(self, root)

    def PropertiesJSON(self, requested_frame):
        r"""PropertiesJSON(Clip self, int64_t requested_frame) -> std::string"""
        return _openshot.Clip_PropertiesJSON(self, requested_frame)

    def RemoveEffect(self, effect):
        r"""RemoveEffect(Clip self, EffectBase effect)"""
        return _openshot.Clip_RemoveEffect(self, effect)

    def Waveform(self, *args):
        r"""
        Waveform(Clip self) -> bool
        Waveform(Clip self, bool value)
        """
        return _openshot.Clip_Waveform(self, *args)
    scale_x = property(_openshot.Clip_scale_x_get, _openshot.Clip_scale_x_set, doc=r"""scale_x : Keyframe""")
    scale_y = property(_openshot.Clip_scale_y_get, _openshot.Clip_scale_y_set, doc=r"""scale_y : Keyframe""")
    location_x = property(_openshot.Clip_location_x_get, _openshot.Clip_location_x_set, doc=r"""location_x : Keyframe""")
    location_y = property(_openshot.Clip_location_y_get, _openshot.Clip_location_y_set, doc=r"""location_y : Keyframe""")
    alpha = property(_openshot.Clip_alpha_get, _openshot.Clip_alpha_set, doc=r"""alpha : Keyframe""")
    rotation = property(_openshot.Clip_rotation_get, _openshot.Clip_rotation_set, doc=r"""rotation : Keyframe""")
    time = property(_openshot.Clip_time_get, _openshot.Clip_time_set, doc=r"""time : Keyframe""")
    volume = property(_openshot.Clip_volume_get, _openshot.Clip_volume_set, doc=r"""volume : Keyframe""")
    wave_color = property(_openshot.Clip_wave_color_get, _openshot.Clip_wave_color_set, doc=r"""wave_color : Color""")
    crop_gravity = property(_openshot.Clip_crop_gravity_get, _openshot.Clip_crop_gravity_set, doc=r"""crop_gravity : GravityType""")
    crop_width = property(_openshot.Clip_crop_width_get, _openshot.Clip_crop_width_set, doc=r"""crop_width : Keyframe""")
    crop_height = property(_openshot.Clip_crop_height_get, _openshot.Clip_crop_height_set, doc=r"""crop_height : Keyframe""")
    crop_x = property(_openshot.Clip_crop_x_get, _openshot.Clip_crop_x_set, doc=r"""crop_x : Keyframe""")
    crop_y = property(_openshot.Clip_crop_y_get, _openshot.Clip_crop_y_set, doc=r"""crop_y : Keyframe""")
    shear_x = property(_openshot.Clip_shear_x_get, _openshot.Clip_shear_x_set, doc=r"""shear_x : Keyframe""")
    shear_y = property(_openshot.Clip_shear_y_get, _openshot.Clip_shear_y_set, doc=r"""shear_y : Keyframe""")
    perspective_c1_x = property(_openshot.Clip_perspective_c1_x_get, _openshot.Clip_perspective_c1_x_set, doc=r"""perspective_c1_x : Keyframe""")
    perspective_c1_y = property(_openshot.Clip_perspective_c1_y_get, _openshot.Clip_perspective_c1_y_set, doc=r"""perspective_c1_y : Keyframe""")
    perspective_c2_x = property(_openshot.Clip_perspective_c2_x_get, _openshot.Clip_perspective_c2_x_set, doc=r"""perspective_c2_x : Keyframe""")
    perspective_c2_y = property(_openshot.Clip_perspective_c2_y_get, _openshot.Clip_perspective_c2_y_set, doc=r"""perspective_c2_y : Keyframe""")
    perspective_c3_x = property(_openshot.Clip_perspective_c3_x_get, _openshot.Clip_perspective_c3_x_set, doc=r"""perspective_c3_x : Keyframe""")
    perspective_c3_y = property(_openshot.Clip_perspective_c3_y_get, _openshot.Clip_perspective_c3_y_set, doc=r"""perspective_c3_y : Keyframe""")
    perspective_c4_x = property(_openshot.Clip_perspective_c4_x_get, _openshot.Clip_perspective_c4_x_set, doc=r"""perspective_c4_x : Keyframe""")
    perspective_c4_y = property(_openshot.Clip_perspective_c4_y_get, _openshot.Clip_perspective_c4_y_set, doc=r"""perspective_c4_y : Keyframe""")
    channel_filter = property(_openshot.Clip_channel_filter_get, _openshot.Clip_channel_filter_set, doc=r"""channel_filter : Keyframe""")
    channel_mapping = property(_openshot.Clip_channel_mapping_get, _openshot.Clip_channel_mapping_set, doc=r"""channel_mapping : Keyframe""")
    has_audio = property(_openshot.Clip_has_audio_get, _openshot.Clip_has_audio_set, doc=r"""has_audio : Keyframe""")
    has_video = property(_openshot.Clip_has_video_get, _openshot.Clip_has_video_set, doc=r"""has_video : Keyframe""")

# Register Clip in _openshot:
_openshot.Clip_swigregister(Clip)

class Coordinate(object):
    r"""Proxy of C++ openshot::Coordinate class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    X = property(_openshot.Coordinate_X_get, _openshot.Coordinate_X_set, doc=r"""X : double""")
    Y = property(_openshot.Coordinate_Y_get, _openshot.Coordinate_Y_set, doc=r"""Y : double""")

    def __init__(self, *args):
        r"""
        __init__(Coordinate self) -> Coordinate
        __init__(Coordinate self, double x, double y) -> Coordinate
        """
        _openshot.Coordinate_swiginit(self, _openshot.new_Coordinate(*args))

    def Json(self):
        r"""Json(Coordinate self) -> std::string"""
        return _openshot.Coordinate_Json(self)

    def JsonValue(self):
        r"""JsonValue(Coordinate self) -> Json::Value"""
        return _openshot.Coordinate_JsonValue(self)

    def SetJson(self, value):
        r"""SetJson(Coordinate self, std::string value)"""
        return _openshot.Coordinate_SetJson(self, value)

    def SetJsonValue(self, root):
        r"""SetJsonValue(Coordinate self, Json::Value root)"""
        return _openshot.Coordinate_SetJsonValue(self, root)
    __swig_destroy__ = _openshot.delete_Coordinate

# Register Coordinate in _openshot:
_openshot.Coordinate_swigregister(Coordinate)

class Color(object):
    r"""Proxy of C++ openshot::Color class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    red = property(_openshot.Color_red_get, _openshot.Color_red_set, doc=r"""red : Keyframe""")
    green = property(_openshot.Color_green_get, _openshot.Color_green_set, doc=r"""green : Keyframe""")
    blue = property(_openshot.Color_blue_get, _openshot.Color_blue_set, doc=r"""blue : Keyframe""")
    alpha = property(_openshot.Color_alpha_get, _openshot.Color_alpha_set, doc=r"""alpha : Keyframe""")

    def __init__(self, *args):
        r"""
        __init__(Color self) -> Color
        __init__(Color self, std::string color_hex) -> Color
        __init__(Color self, unsigned char Red, unsigned char Green, unsigned char Blue, unsigned char Alpha) -> Color
        __init__(Color self, Keyframe Red, Keyframe Green, Keyframe Blue, Keyframe Alpha) -> Color
        """
        _openshot.Color_swiginit(self, _openshot.new_Color(*args))

    def GetColorHex(self, frame_number):
        r"""GetColorHex(Color self, int64_t frame_number) -> std::string"""
        return _openshot.Color_GetColorHex(self, frame_number)

    @staticmethod
    def GetDistance(R1, G1, B1, R2, G2, B2):
        r"""GetDistance(long R1, long G1, long B1, long R2, long G2, long B2) -> long"""
        return _openshot.Color_GetDistance(R1, G1, B1, R2, G2, B2)

    def Json(self):
        r"""Json(Color self) -> std::string"""
        return _openshot.Color_Json(self)

    def JsonValue(self):
        r"""JsonValue(Color self) -> Json::Value"""
        return _openshot.Color_JsonValue(self)

    def SetJson(self, value):
        r"""SetJson(Color self, std::string value)"""
        return _openshot.Color_SetJson(self, value)

    def SetJsonValue(self, root):
        r"""SetJsonValue(Color self, Json::Value root)"""
        return _openshot.Color_SetJsonValue(self, root)
    __swig_destroy__ = _openshot.delete_Color

# Register Color in _openshot:
_openshot.Color_swigregister(Color)

def Color_GetDistance(R1, G1, B1, R2, G2, B2):
    r"""Color_GetDistance(long R1, long G1, long B1, long R2, long G2, long B2) -> long"""
    return _openshot.Color_GetDistance(R1, G1, B1, R2, G2, B2)

class DummyReader(ReaderBase):
    r"""Proxy of C++ openshot::DummyReader class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(DummyReader self) -> DummyReader
        __init__(DummyReader self, Fraction fps, int width, int height, int sample_rate, int channels, float duration) -> DummyReader
        """
        _openshot.DummyReader_swiginit(self, _openshot.new_DummyReader(*args))

    def Close(self):
        r"""Close(DummyReader self)"""
        return _openshot.DummyReader_Close(self)

    def GetCache(self):
        r"""GetCache(DummyReader self) -> CacheMemory"""
        return _openshot.DummyReader_GetCache(self)

    def GetFrame(self, requested_frame):
        r"""GetFrame(DummyReader self, int64_t requested_frame) -> std::shared_ptr< openshot::Frame >"""
        return _openshot.DummyReader_GetFrame(self, requested_frame)

    def IsOpen(self):
        r"""IsOpen(DummyReader self) -> bool"""
        return _openshot.DummyReader_IsOpen(self)

    def Name(self):
        r"""Name(DummyReader self) -> std::string"""
        return _openshot.DummyReader_Name(self)

    def Json(self):
        r"""Json(DummyReader self) -> std::string"""
        return _openshot.DummyReader_Json(self)

    def SetJson(self, value):
        r"""SetJson(DummyReader self, std::string value)"""
        return _openshot.DummyReader_SetJson(self, value)

    def JsonValue(self):
        r"""JsonValue(DummyReader self) -> Json::Value"""
        return _openshot.DummyReader_JsonValue(self)

    def SetJsonValue(self, root):
        r"""SetJsonValue(DummyReader self, Json::Value root)"""
        return _openshot.DummyReader_SetJsonValue(self, root)

    def Open(self):
        r"""Open(DummyReader self)"""
        return _openshot.DummyReader_Open(self)
    __swig_destroy__ = _openshot.delete_DummyReader

# Register DummyReader in _openshot:
_openshot.DummyReader_swigregister(DummyReader)

class EffectInfoStruct(object):
    r"""Proxy of C++ openshot::EffectInfoStruct class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    class_name = property(_openshot.EffectInfoStruct_class_name_get, _openshot.EffectInfoStruct_class_name_set, doc=r"""class_name : std::string""")
    short_name = property(_openshot.EffectInfoStruct_short_name_get, _openshot.EffectInfoStruct_short_name_set, doc=r"""short_name : std::string""")
    name = property(_openshot.EffectInfoStruct_name_get, _openshot.EffectInfoStruct_name_set, doc=r"""name : std::string""")
    description = property(_openshot.EffectInfoStruct_description_get, _openshot.EffectInfoStruct_description_set, doc=r"""description : std::string""")
    has_video = property(_openshot.EffectInfoStruct_has_video_get, _openshot.EffectInfoStruct_has_video_set, doc=r"""has_video : bool""")
    has_audio = property(_openshot.EffectInfoStruct_has_audio_get, _openshot.EffectInfoStruct_has_audio_set, doc=r"""has_audio : bool""")

    def __init__(self):
        r"""__init__(EffectInfoStruct self) -> EffectInfoStruct"""
        _openshot.EffectInfoStruct_swiginit(self, _openshot.new_EffectInfoStruct())
    __swig_destroy__ = _openshot.delete_EffectInfoStruct

# Register EffectInfoStruct in _openshot:
_openshot.EffectInfoStruct_swigregister(EffectInfoStruct)

class EffectBase(ClipBase):
    r"""Proxy of C++ openshot::EffectBase class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    info = property(_openshot.EffectBase_info_get, _openshot.EffectBase_info_set, doc=r"""info : openshot::EffectInfoStruct""")

    def DisplayInfo(self):
        r"""DisplayInfo(EffectBase self)"""
        return _openshot.EffectBase_DisplayInfo(self)

    def constrain(self, color_value):
        r"""constrain(EffectBase self, int color_value) -> int"""
        return _openshot.EffectBase_constrain(self, color_value)

    def GetFrame(self, frame, frame_number):
        r"""GetFrame(EffectBase self, std::shared_ptr< openshot::Frame > frame, int64_t frame_number) -> std::shared_ptr< openshot::Frame >"""
        return _openshot.EffectBase_GetFrame(self, frame, frame_number)

    def InitEffectInfo(self):
        r"""InitEffectInfo(EffectBase self)"""
        return _openshot.EffectBase_InitEffectInfo(self)

    def Json(self):
        r"""Json(EffectBase self) -> std::string"""
        return _openshot.EffectBase_Json(self)

    def SetJson(self, value):
        r"""SetJson(EffectBase self, std::string value)"""
        return _openshot.EffectBase_SetJson(self, value)

    def JsonValue(self):
        r"""JsonValue(EffectBase self) -> Json::Value"""
        return _openshot.EffectBase_JsonValue(self)

    def SetJsonValue(self, root):
        r"""SetJsonValue(EffectBase self, Json::Value root)"""
        return _openshot.EffectBase_SetJsonValue(self, root)

    def JsonInfo(self):
        r"""JsonInfo(EffectBase self) -> Json::Value"""
        return _openshot.EffectBase_JsonInfo(self)

    def Order(self, *args):
        r"""
        Order(EffectBase self) -> int
        Order(EffectBase self, int new_order)
        """
        return _openshot.EffectBase_Order(self, *args)
    __swig_destroy__ = _openshot.delete_EffectBase

# Register EffectBase in _openshot:
_openshot.EffectBase_swigregister(EffectBase)

class EffectInfo(object):
    r"""Proxy of C++ openshot::EffectInfo class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def CreateEffect(self, effect_type):
        r"""CreateEffect(EffectInfo self, std::string effect_type) -> EffectBase"""
        return _openshot.EffectInfo_CreateEffect(self, effect_type)

    @staticmethod
    def Json():
        r"""Json() -> std::string"""
        return _openshot.EffectInfo_Json()

    @staticmethod
    def JsonValue():
        r"""JsonValue() -> Json::Value"""
        return _openshot.EffectInfo_JsonValue()

    def __init__(self):
        r"""__init__(EffectInfo self) -> EffectInfo"""
        _openshot.EffectInfo_swiginit(self, _openshot.new_EffectInfo())
    __swig_destroy__ = _openshot.delete_EffectInfo

# Register EffectInfo in _openshot:
_openshot.EffectInfo_swigregister(EffectInfo)

def EffectInfo_Json():
    r"""EffectInfo_Json() -> std::string"""
    return _openshot.EffectInfo_Json()

def EffectInfo_JsonValue():
    r"""EffectInfo_JsonValue() -> Json::Value"""
    return _openshot.EffectInfo_JsonValue()

GRAVITY_TOP_LEFT = _openshot.GRAVITY_TOP_LEFT

GRAVITY_TOP = _openshot.GRAVITY_TOP

GRAVITY_TOP_RIGHT = _openshot.GRAVITY_TOP_RIGHT

GRAVITY_LEFT = _openshot.GRAVITY_LEFT

GRAVITY_CENTER = _openshot.GRAVITY_CENTER

GRAVITY_RIGHT = _openshot.GRAVITY_RIGHT

GRAVITY_BOTTOM_LEFT = _openshot.GRAVITY_BOTTOM_LEFT

GRAVITY_BOTTOM = _openshot.GRAVITY_BOTTOM

GRAVITY_BOTTOM_RIGHT = _openshot.GRAVITY_BOTTOM_RIGHT

SCALE_CROP = _openshot.SCALE_CROP

SCALE_FIT = _openshot.SCALE_FIT

SCALE_STRETCH = _openshot.SCALE_STRETCH

SCALE_NONE = _openshot.SCALE_NONE

ANCHOR_CANVAS = _openshot.ANCHOR_CANVAS

ANCHOR_VIEWPORT = _openshot.ANCHOR_VIEWPORT

FRAME_DISPLAY_NONE = _openshot.FRAME_DISPLAY_NONE

FRAME_DISPLAY_CLIP = _openshot.FRAME_DISPLAY_CLIP

FRAME_DISPLAY_TIMELINE = _openshot.FRAME_DISPLAY_TIMELINE

FRAME_DISPLAY_BOTH = _openshot.FRAME_DISPLAY_BOTH

VOLUME_MIX_NONE = _openshot.VOLUME_MIX_NONE

VOLUME_MIX_AVERAGE = _openshot.VOLUME_MIX_AVERAGE

VOLUME_MIX_REDUCE = _openshot.VOLUME_MIX_REDUCE

class BaseException(object):
    r"""Proxy of C++ openshot::BaseException class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, message):
        r"""__init__(BaseException self, std::string message) -> BaseException"""
        _openshot.BaseException_swiginit(self, _openshot.new_BaseException(message))
    __swig_destroy__ = _openshot.delete_BaseException

    def what(self):
        r"""what(BaseException self) -> char const *"""
        return _openshot.BaseException_what(self)

# Register BaseException in _openshot:
_openshot.BaseException_swigregister(BaseException)

class ChunkNotFound(BaseException):
    r"""Proxy of C++ openshot::ChunkNotFound class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    file_path = property(_openshot.ChunkNotFound_file_path_get, _openshot.ChunkNotFound_file_path_set, doc=r"""file_path : std::string""")
    frame_number = property(_openshot.ChunkNotFound_frame_number_get, _openshot.ChunkNotFound_frame_number_set, doc=r"""frame_number : int64_t""")
    chunk_number = property(_openshot.ChunkNotFound_chunk_number_get, _openshot.ChunkNotFound_chunk_number_set, doc=r"""chunk_number : int64_t""")
    chunk_frame = property(_openshot.ChunkNotFound_chunk_frame_get, _openshot.ChunkNotFound_chunk_frame_set, doc=r"""chunk_frame : int64_t""")

    def __init__(self, message, frame_number, chunk_number, chunk_frame):
        r"""__init__(ChunkNotFound self, std::string message, int64_t frame_number, int64_t chunk_number, int64_t chunk_frame) -> ChunkNotFound"""
        _openshot.ChunkNotFound_swiginit(self, _openshot.new_ChunkNotFound(message, frame_number, chunk_number, chunk_frame))
    __swig_destroy__ = _openshot.delete_ChunkNotFound

# Register ChunkNotFound in _openshot:
_openshot.ChunkNotFound_swigregister(ChunkNotFound)

class DecklinkError(BaseException):
    r"""Proxy of C++ openshot::DecklinkError class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, message):
        r"""__init__(DecklinkError self, std::string message) -> DecklinkError"""
        _openshot.DecklinkError_swiginit(self, _openshot.new_DecklinkError(message))
    __swig_destroy__ = _openshot.delete_DecklinkError

# Register DecklinkError in _openshot:
_openshot.DecklinkError_swigregister(DecklinkError)

class ErrorDecodingAudio(BaseException):
    r"""Proxy of C++ openshot::ErrorDecodingAudio class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    file_path = property(_openshot.ErrorDecodingAudio_file_path_get, _openshot.ErrorDecodingAudio_file_path_set, doc=r"""file_path : std::string""")
    frame_number = property(_openshot.ErrorDecodingAudio_frame_number_get, _openshot.ErrorDecodingAudio_frame_number_set, doc=r"""frame_number : int64_t""")

    def __init__(self, message, frame_number):
        r"""__init__(ErrorDecodingAudio self, std::string message, int64_t frame_number) -> ErrorDecodingAudio"""
        _openshot.ErrorDecodingAudio_swiginit(self, _openshot.new_ErrorDecodingAudio(message, frame_number))
    __swig_destroy__ = _openshot.delete_ErrorDecodingAudio

# Register ErrorDecodingAudio in _openshot:
_openshot.ErrorDecodingAudio_swigregister(ErrorDecodingAudio)

class ErrorEncodingAudio(BaseException):
    r"""Proxy of C++ openshot::ErrorEncodingAudio class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    file_path = property(_openshot.ErrorEncodingAudio_file_path_get, _openshot.ErrorEncodingAudio_file_path_set, doc=r"""file_path : std::string""")
    frame_number = property(_openshot.ErrorEncodingAudio_frame_number_get, _openshot.ErrorEncodingAudio_frame_number_set, doc=r"""frame_number : int64_t""")

    def __init__(self, message, frame_number):
        r"""__init__(ErrorEncodingAudio self, std::string message, int64_t frame_number) -> ErrorEncodingAudio"""
        _openshot.ErrorEncodingAudio_swiginit(self, _openshot.new_ErrorEncodingAudio(message, frame_number))
    __swig_destroy__ = _openshot.delete_ErrorEncodingAudio

# Register ErrorEncodingAudio in _openshot:
_openshot.ErrorEncodingAudio_swigregister(ErrorEncodingAudio)

class ErrorEncodingVideo(BaseException):
    r"""Proxy of C++ openshot::ErrorEncodingVideo class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    file_path = property(_openshot.ErrorEncodingVideo_file_path_get, _openshot.ErrorEncodingVideo_file_path_set, doc=r"""file_path : std::string""")
    frame_number = property(_openshot.ErrorEncodingVideo_frame_number_get, _openshot.ErrorEncodingVideo_frame_number_set, doc=r"""frame_number : int64_t""")

    def __init__(self, message, frame_number):
        r"""__init__(ErrorEncodingVideo self, std::string message, int64_t frame_number) -> ErrorEncodingVideo"""
        _openshot.ErrorEncodingVideo_swiginit(self, _openshot.new_ErrorEncodingVideo(message, frame_number))
    __swig_destroy__ = _openshot.delete_ErrorEncodingVideo

# Register ErrorEncodingVideo in _openshot:
_openshot.ErrorEncodingVideo_swigregister(ErrorEncodingVideo)

class InvalidChannels(BaseException):
    r"""Proxy of C++ openshot::InvalidChannels class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    file_path = property(_openshot.InvalidChannels_file_path_get, _openshot.InvalidChannels_file_path_set, doc=r"""file_path : std::string""")

    def __init__(self, message, file_path):
        r"""__init__(InvalidChannels self, std::string message, std::string file_path) -> InvalidChannels"""
        _openshot.InvalidChannels_swiginit(self, _openshot.new_InvalidChannels(message, file_path))
    __swig_destroy__ = _openshot.delete_InvalidChannels

# Register InvalidChannels in _openshot:
_openshot.InvalidChannels_swigregister(InvalidChannels)

class InvalidCodec(BaseException):
    r"""Proxy of C++ openshot::InvalidCodec class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    file_path = property(_openshot.InvalidCodec_file_path_get, _openshot.InvalidCodec_file_path_set, doc=r"""file_path : std::string""")

    def __init__(self, message, file_path):
        r"""__init__(InvalidCodec self, std::string message, std::string file_path) -> InvalidCodec"""
        _openshot.InvalidCodec_swiginit(self, _openshot.new_InvalidCodec(message, file_path))
    __swig_destroy__ = _openshot.delete_InvalidCodec

# Register InvalidCodec in _openshot:
_openshot.InvalidCodec_swigregister(InvalidCodec)

class InvalidFile(BaseException):
    r"""Proxy of C++ openshot::InvalidFile class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    file_path = property(_openshot.InvalidFile_file_path_get, _openshot.InvalidFile_file_path_set, doc=r"""file_path : std::string""")

    def __init__(self, message, file_path):
        r"""__init__(InvalidFile self, std::string message, std::string file_path) -> InvalidFile"""
        _openshot.InvalidFile_swiginit(self, _openshot.new_InvalidFile(message, file_path))
    __swig_destroy__ = _openshot.delete_InvalidFile

# Register InvalidFile in _openshot:
_openshot.InvalidFile_swigregister(InvalidFile)

class InvalidFormat(BaseException):
    r"""Proxy of C++ openshot::InvalidFormat class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    file_path = property(_openshot.InvalidFormat_file_path_get, _openshot.InvalidFormat_file_path_set, doc=r"""file_path : std::string""")

    def __init__(self, message, file_path):
        r"""__init__(InvalidFormat self, std::string message, std::string file_path) -> InvalidFormat"""
        _openshot.InvalidFormat_swiginit(self, _openshot.new_InvalidFormat(message, file_path))
    __swig_destroy__ = _openshot.delete_InvalidFormat

# Register InvalidFormat in _openshot:
_openshot.InvalidFormat_swigregister(InvalidFormat)

class InvalidJSON(BaseException):
    r"""Proxy of C++ openshot::InvalidJSON class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    file_path = property(_openshot.InvalidJSON_file_path_get, _openshot.InvalidJSON_file_path_set, doc=r"""file_path : std::string""")

    def __init__(self, message, file_path):
        r"""__init__(InvalidJSON self, std::string message, std::string file_path) -> InvalidJSON"""
        _openshot.InvalidJSON_swiginit(self, _openshot.new_InvalidJSON(message, file_path))
    __swig_destroy__ = _openshot.delete_InvalidJSON

# Register InvalidJSON in _openshot:
_openshot.InvalidJSON_swigregister(InvalidJSON)

class InvalidOptions(BaseException):
    r"""Proxy of C++ openshot::InvalidOptions class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    file_path = property(_openshot.InvalidOptions_file_path_get, _openshot.InvalidOptions_file_path_set, doc=r"""file_path : std::string""")

    def __init__(self, message, file_path):
        r"""__init__(InvalidOptions self, std::string message, std::string file_path) -> InvalidOptions"""
        _openshot.InvalidOptions_swiginit(self, _openshot.new_InvalidOptions(message, file_path))
    __swig_destroy__ = _openshot.delete_InvalidOptions

# Register InvalidOptions in _openshot:
_openshot.InvalidOptions_swigregister(InvalidOptions)

class InvalidSampleRate(BaseException):
    r"""Proxy of C++ openshot::InvalidSampleRate class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    file_path = property(_openshot.InvalidSampleRate_file_path_get, _openshot.InvalidSampleRate_file_path_set, doc=r"""file_path : std::string""")

    def __init__(self, message, file_path):
        r"""__init__(InvalidSampleRate self, std::string message, std::string file_path) -> InvalidSampleRate"""
        _openshot.InvalidSampleRate_swiginit(self, _openshot.new_InvalidSampleRate(message, file_path))
    __swig_destroy__ = _openshot.delete_InvalidSampleRate

# Register InvalidSampleRate in _openshot:
_openshot.InvalidSampleRate_swigregister(InvalidSampleRate)

class InvalidJSONKey(BaseException):
    r"""Proxy of C++ openshot::InvalidJSONKey class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    json = property(_openshot.InvalidJSONKey_json_get, _openshot.InvalidJSONKey_json_set, doc=r"""json : std::string""")

    def __init__(self, message, json):
        r"""__init__(InvalidJSONKey self, std::string message, std::string json) -> InvalidJSONKey"""
        _openshot.InvalidJSONKey_swiginit(self, _openshot.new_InvalidJSONKey(message, json))
    __swig_destroy__ = _openshot.delete_InvalidJSONKey

# Register InvalidJSONKey in _openshot:
_openshot.InvalidJSONKey_swigregister(InvalidJSONKey)

class NoStreamsFound(BaseException):
    r"""Proxy of C++ openshot::NoStreamsFound class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    file_path = property(_openshot.NoStreamsFound_file_path_get, _openshot.NoStreamsFound_file_path_set, doc=r"""file_path : std::string""")

    def __init__(self, message, file_path):
        r"""__init__(NoStreamsFound self, std::string message, std::string file_path) -> NoStreamsFound"""
        _openshot.NoStreamsFound_swiginit(self, _openshot.new_NoStreamsFound(message, file_path))
    __swig_destroy__ = _openshot.delete_NoStreamsFound

# Register NoStreamsFound in _openshot:
_openshot.NoStreamsFound_swigregister(NoStreamsFound)

class OutOfBoundsFrame(BaseException):
    r"""Proxy of C++ openshot::OutOfBoundsFrame class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    FrameRequested = property(_openshot.OutOfBoundsFrame_FrameRequested_get, _openshot.OutOfBoundsFrame_FrameRequested_set, doc=r"""FrameRequested : int64_t""")
    MaxFrames = property(_openshot.OutOfBoundsFrame_MaxFrames_get, _openshot.OutOfBoundsFrame_MaxFrames_set, doc=r"""MaxFrames : int64_t""")

    def __init__(self, message, frame_requested, max_frames):
        r"""__init__(OutOfBoundsFrame self, std::string message, int64_t frame_requested, int64_t max_frames) -> OutOfBoundsFrame"""
        _openshot.OutOfBoundsFrame_swiginit(self, _openshot.new_OutOfBoundsFrame(message, frame_requested, max_frames))
    __swig_destroy__ = _openshot.delete_OutOfBoundsFrame

# Register OutOfBoundsFrame in _openshot:
_openshot.OutOfBoundsFrame_swigregister(OutOfBoundsFrame)

class OutOfBoundsPoint(BaseException):
    r"""Proxy of C++ openshot::OutOfBoundsPoint class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    PointRequested = property(_openshot.OutOfBoundsPoint_PointRequested_get, _openshot.OutOfBoundsPoint_PointRequested_set, doc=r"""PointRequested : int""")
    MaxPoints = property(_openshot.OutOfBoundsPoint_MaxPoints_get, _openshot.OutOfBoundsPoint_MaxPoints_set, doc=r"""MaxPoints : int""")

    def __init__(self, message, point_requested, max_points):
        r"""__init__(OutOfBoundsPoint self, std::string message, int point_requested, int max_points) -> OutOfBoundsPoint"""
        _openshot.OutOfBoundsPoint_swiginit(self, _openshot.new_OutOfBoundsPoint(message, point_requested, max_points))
    __swig_destroy__ = _openshot.delete_OutOfBoundsPoint

# Register OutOfBoundsPoint in _openshot:
_openshot.OutOfBoundsPoint_swigregister(OutOfBoundsPoint)

class OutOfMemory(BaseException):
    r"""Proxy of C++ openshot::OutOfMemory class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    file_path = property(_openshot.OutOfMemory_file_path_get, _openshot.OutOfMemory_file_path_set, doc=r"""file_path : std::string""")

    def __init__(self, message, file_path):
        r"""__init__(OutOfMemory self, std::string message, std::string file_path) -> OutOfMemory"""
        _openshot.OutOfMemory_swiginit(self, _openshot.new_OutOfMemory(message, file_path))
    __swig_destroy__ = _openshot.delete_OutOfMemory

# Register OutOfMemory in _openshot:
_openshot.OutOfMemory_swigregister(OutOfMemory)

class ReaderClosed(BaseException):
    r"""Proxy of C++ openshot::ReaderClosed class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    file_path = property(_openshot.ReaderClosed_file_path_get, _openshot.ReaderClosed_file_path_set, doc=r"""file_path : std::string""")

    def __init__(self, message, file_path):
        r"""__init__(ReaderClosed self, std::string message, std::string file_path) -> ReaderClosed"""
        _openshot.ReaderClosed_swiginit(self, _openshot.new_ReaderClosed(message, file_path))
    __swig_destroy__ = _openshot.delete_ReaderClosed

# Register ReaderClosed in _openshot:
_openshot.ReaderClosed_swigregister(ReaderClosed)

class ResampleError(BaseException):
    r"""Proxy of C++ openshot::ResampleError class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    file_path = property(_openshot.ResampleError_file_path_get, _openshot.ResampleError_file_path_set, doc=r"""file_path : std::string""")

    def __init__(self, message, file_path):
        r"""__init__(ResampleError self, std::string message, std::string file_path) -> ResampleError"""
        _openshot.ResampleError_swiginit(self, _openshot.new_ResampleError(message, file_path))
    __swig_destroy__ = _openshot.delete_ResampleError

# Register ResampleError in _openshot:
_openshot.ResampleError_swigregister(ResampleError)

class TooManySeeks(BaseException):
    r"""Proxy of C++ openshot::TooManySeeks class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    file_path = property(_openshot.TooManySeeks_file_path_get, _openshot.TooManySeeks_file_path_set, doc=r"""file_path : std::string""")

    def __init__(self, message, file_path):
        r"""__init__(TooManySeeks self, std::string message, std::string file_path) -> TooManySeeks"""
        _openshot.TooManySeeks_swiginit(self, _openshot.new_TooManySeeks(message, file_path))
    __swig_destroy__ = _openshot.delete_TooManySeeks

# Register TooManySeeks in _openshot:
_openshot.TooManySeeks_swigregister(TooManySeeks)

class WriterClosed(BaseException):
    r"""Proxy of C++ openshot::WriterClosed class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    file_path = property(_openshot.WriterClosed_file_path_get, _openshot.WriterClosed_file_path_set, doc=r"""file_path : std::string""")

    def __init__(self, message, file_path):
        r"""__init__(WriterClosed self, std::string message, std::string file_path) -> WriterClosed"""
        _openshot.WriterClosed_swiginit(self, _openshot.new_WriterClosed(message, file_path))
    __swig_destroy__ = _openshot.delete_WriterClosed

# Register WriterClosed in _openshot:
_openshot.WriterClosed_swigregister(WriterClosed)

class AudioLocation(object):
    r"""Proxy of C++ openshot::AudioLocation class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    frame = property(_openshot.AudioLocation_frame_get, _openshot.AudioLocation_frame_set, doc=r"""frame : int64_t""")
    sample_start = property(_openshot.AudioLocation_sample_start_get, _openshot.AudioLocation_sample_start_set, doc=r"""sample_start : int""")

    def is_near(self, location, samples_per_frame, amount):
        r"""is_near(AudioLocation self, AudioLocation location, int samples_per_frame, int64_t amount) -> bool"""
        return _openshot.AudioLocation_is_near(self, location, samples_per_frame, amount)

    def __init__(self):
        r"""__init__(AudioLocation self) -> AudioLocation"""
        _openshot.AudioLocation_swiginit(self, _openshot.new_AudioLocation())
    __swig_destroy__ = _openshot.delete_AudioLocation

# Register AudioLocation in _openshot:
_openshot.AudioLocation_swigregister(AudioLocation)

class FFmpegReader(ReaderBase):
    r"""Proxy of C++ openshot::FFmpegReader class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    final_cache = property(_openshot.FFmpegReader_final_cache_get, _openshot.FFmpegReader_final_cache_set, doc=r"""final_cache : openshot::CacheMemory""")
    enable_seek = property(_openshot.FFmpegReader_enable_seek_get, _openshot.FFmpegReader_enable_seek_set, doc=r"""enable_seek : bool""")

    def __init__(self, *args):
        r"""
        __init__(FFmpegReader self, std::string path) -> FFmpegReader
        __init__(FFmpegReader self, std::string path, bool inspect_reader) -> FFmpegReader
        """
        _openshot.FFmpegReader_swiginit(self, _openshot.new_FFmpegReader(*args))
    __swig_destroy__ = _openshot.delete_FFmpegReader

    def Close(self):
        r"""Close(FFmpegReader self)"""
        return _openshot.FFmpegReader_Close(self)

    def GetCache(self):
        r"""GetCache(FFmpegReader self) -> CacheMemory"""
        return _openshot.FFmpegReader_GetCache(self)

    def GetFrame(self, requested_frame):
        r"""GetFrame(FFmpegReader self, int64_t requested_frame) -> std::shared_ptr< openshot::Frame >"""
        return _openshot.FFmpegReader_GetFrame(self, requested_frame)

    def IsOpen(self):
        r"""IsOpen(FFmpegReader self) -> bool"""
        return _openshot.FFmpegReader_IsOpen(self)

    def Name(self):
        r"""Name(FFmpegReader self) -> std::string"""
        return _openshot.FFmpegReader_Name(self)

    def Json(self):
        r"""Json(FFmpegReader self) -> std::string"""
        return _openshot.FFmpegReader_Json(self)

    def SetJson(self, value):
        r"""SetJson(FFmpegReader self, std::string value)"""
        return _openshot.FFmpegReader_SetJson(self, value)

    def JsonValue(self):
        r"""JsonValue(FFmpegReader self) -> Json::Value"""
        return _openshot.FFmpegReader_JsonValue(self)

    def SetJsonValue(self, root):
        r"""SetJsonValue(FFmpegReader self, Json::Value root)"""
        return _openshot.FFmpegReader_SetJsonValue(self, root)

    def Open(self):
        r"""Open(FFmpegReader self)"""
        return _openshot.FFmpegReader_Open(self)

# Register FFmpegReader in _openshot:
_openshot.FFmpegReader_swigregister(FFmpegReader)

VIDEO_STREAM = _openshot.VIDEO_STREAM

AUDIO_STREAM = _openshot.AUDIO_STREAM

class FFmpegWriter(WriterBase):
    r"""Proxy of C++ openshot::FFmpegWriter class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, path):
        r"""__init__(FFmpegWriter self, std::string path) -> FFmpegWriter"""
        _openshot.FFmpegWriter_swiginit(self, _openshot.new_FFmpegWriter(path))

    def Close(self):
        r"""Close(FFmpegWriter self)"""
        return _openshot.FFmpegWriter_Close(self)

    def GetCacheSize(self):
        r"""GetCacheSize(FFmpegWriter self) -> int"""
        return _openshot.FFmpegWriter_GetCacheSize(self)

    def IsOpen(self):
        r"""IsOpen(FFmpegWriter self) -> bool"""
        return _openshot.FFmpegWriter_IsOpen(self)

    @staticmethod
    def IsValidCodec(codec_name):
        r"""IsValidCodec(std::string codec_name) -> bool"""
        return _openshot.FFmpegWriter_IsValidCodec(codec_name)

    def Open(self):
        r"""Open(FFmpegWriter self)"""
        return _openshot.FFmpegWriter_Open(self)

    def OutputStreamInfo(self):
        r"""OutputStreamInfo(FFmpegWriter self)"""
        return _openshot.FFmpegWriter_OutputStreamInfo(self)

    def PrepareStreams(self):
        r"""PrepareStreams(FFmpegWriter self)"""
        return _openshot.FFmpegWriter_PrepareStreams(self)

    def RemoveScalers(self):
        r"""RemoveScalers(FFmpegWriter self)"""
        return _openshot.FFmpegWriter_RemoveScalers(self)

    def ResampleAudio(self, sample_rate, channels):
        r"""ResampleAudio(FFmpegWriter self, int sample_rate, int channels)"""
        return _openshot.FFmpegWriter_ResampleAudio(self, sample_rate, channels)

    def SetAudioOptions(self, has_audio, codec, sample_rate, channels, channel_layout, bit_rate):
        r"""SetAudioOptions(FFmpegWriter self, bool has_audio, std::string codec, int sample_rate, int channels, openshot::ChannelLayout channel_layout, int bit_rate)"""
        return _openshot.FFmpegWriter_SetAudioOptions(self, has_audio, codec, sample_rate, channels, channel_layout, bit_rate)

    def SetCacheSize(self, new_size):
        r"""SetCacheSize(FFmpegWriter self, int new_size)"""
        return _openshot.FFmpegWriter_SetCacheSize(self, new_size)

    def SetVideoOptions(self, has_video, codec, fps, width, height, pixel_ratio, interlaced, top_field_first, bit_rate):
        r"""SetVideoOptions(FFmpegWriter self, bool has_video, std::string codec, Fraction fps, int width, int height, Fraction pixel_ratio, bool interlaced, bool top_field_first, int bit_rate)"""
        return _openshot.FFmpegWriter_SetVideoOptions(self, has_video, codec, fps, width, height, pixel_ratio, interlaced, top_field_first, bit_rate)

    def SetOption(self, stream, name, value):
        r"""SetOption(FFmpegWriter self, openshot::StreamType stream, std::string name, std::string value)"""
        return _openshot.FFmpegWriter_SetOption(self, stream, name, value)

    def WriteHeader(self):
        r"""WriteHeader(FFmpegWriter self)"""
        return _openshot.FFmpegWriter_WriteHeader(self)

    def WriteFrame(self, *args):
        r"""
        WriteFrame(FFmpegWriter self, std::shared_ptr< openshot::Frame > frame)
        WriteFrame(FFmpegWriter self, ReaderBase reader, int64_t start, int64_t length)
        """
        return _openshot.FFmpegWriter_WriteFrame(self, *args)

    def WriteTrailer(self):
        r"""WriteTrailer(FFmpegWriter self)"""
        return _openshot.FFmpegWriter_WriteTrailer(self)
    __swig_destroy__ = _openshot.delete_FFmpegWriter

# Register FFmpegWriter in _openshot:
_openshot.FFmpegWriter_swigregister(FFmpegWriter)

def FFmpegWriter_IsValidCodec(codec_name):
    r"""FFmpegWriter_IsValidCodec(std::string codec_name) -> bool"""
    return _openshot.FFmpegWriter_IsValidCodec(codec_name)

class Fraction(object):
    r"""Proxy of C++ openshot::Fraction class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    num = property(_openshot.Fraction_num_get, _openshot.Fraction_num_set, doc=r"""num : int""")
    den = property(_openshot.Fraction_den_get, _openshot.Fraction_den_set, doc=r"""den : int""")

    def __init__(self, *args):
        r"""
        __init__(Fraction self) -> Fraction
        __init__(Fraction self, int num, int den) -> Fraction
        """
        _openshot.Fraction_swiginit(self, _openshot.new_Fraction(*args))

    def GreatestCommonDenominator(self):
        r"""GreatestCommonDenominator(Fraction self) -> int"""
        return _openshot.Fraction_GreatestCommonDenominator(self)

    def Reduce(self):
        r"""Reduce(Fraction self)"""
        return _openshot.Fraction_Reduce(self)

    def ToFloat(self):
        r"""ToFloat(Fraction self) -> float"""
        return _openshot.Fraction_ToFloat(self)

    def ToDouble(self):
        r"""ToDouble(Fraction self) -> double"""
        return _openshot.Fraction_ToDouble(self)

    def ToInt(self):
        r"""ToInt(Fraction self) -> int"""
        return _openshot.Fraction_ToInt(self)

    def Reciprocal(self):
        r"""Reciprocal(Fraction self) -> Fraction"""
        return _openshot.Fraction_Reciprocal(self)
    __swig_destroy__ = _openshot.delete_Fraction

# Register Fraction in _openshot:
_openshot.Fraction_swigregister(Fraction)

class Frame(object):
    r"""Proxy of C++ openshot::Frame class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    number = property(_openshot.Frame_number_get, _openshot.Frame_number_set, doc=r"""number : int64_t""")
    has_audio_data = property(_openshot.Frame_has_audio_data_get, _openshot.Frame_has_audio_data_set, doc=r"""has_audio_data : bool""")
    has_image_data = property(_openshot.Frame_has_image_data_get, _openshot.Frame_has_image_data_set, doc=r"""has_image_data : bool""")

    def __init__(self, *args):
        r"""
        __init__(Frame self) -> Frame
        __init__(Frame self, int64_t number, int width, int height, std::string color) -> Frame
        __init__(Frame self, int64_t number, int samples, int channels) -> Frame
        __init__(Frame self, int64_t number, int width, int height, std::string color, int samples, int channels) -> Frame
        __init__(Frame self, Frame other) -> Frame
        """
        _openshot.Frame_swiginit(self, _openshot.new_Frame(*args))
    __swig_destroy__ = _openshot.delete_Frame

    def AddColor(self, new_width, new_height, new_color):
        r"""AddColor(Frame self, int new_width, int new_height, std::string new_color)"""
        return _openshot.Frame_AddColor(self, new_width, new_height, new_color)

    def AddImage(self, *args):
        r"""
        AddImage(Frame self, int new_width, int new_height, int bytes_per_pixel, QImage::Format type, unsigned char const * pixels_)
        AddImage(Frame self, std::shared_ptr< QImage > new_image)
        AddImage(Frame self, std::shared_ptr< QImage > new_image, bool only_odd_lines)
        """
        return _openshot.Frame_AddImage(self, *args)

    def AddAudio(self, replaceSamples, destChannel, destStartSample, source, numSamples, gainToApplyToSource):
        r"""AddAudio(Frame self, bool replaceSamples, int destChannel, int destStartSample, float const * source, int numSamples, float gainToApplyToSource)"""
        return _openshot.Frame_AddAudio(self, replaceSamples, destChannel, destStartSample, source, numSamples, gainToApplyToSource)

    def AddAudioSilence(self, numSamples):
        r"""AddAudioSilence(Frame self, int numSamples)"""
        return _openshot.Frame_AddAudioSilence(self, numSamples)

    def ApplyGainRamp(self, destChannel, destStartSample, numSamples, initial_gain, final_gain):
        r"""ApplyGainRamp(Frame self, int destChannel, int destStartSample, int numSamples, float initial_gain, float final_gain)"""
        return _openshot.Frame_ApplyGainRamp(self, destChannel, destStartSample, numSamples, initial_gain, final_gain)

    def ChannelsLayout(self, *args):
        r"""
        ChannelsLayout(Frame self) -> openshot::ChannelLayout
        ChannelsLayout(Frame self, openshot::ChannelLayout new_channel_layout)
        """
        return _openshot.Frame_ChannelsLayout(self, *args)

    @staticmethod
    def cleanUpBuffer(info):
        r"""cleanUpBuffer(void * info)"""
        return _openshot.Frame_cleanUpBuffer(info)

    def ClearWaveform(self):
        r"""ClearWaveform(Frame self)"""
        return _openshot.Frame_ClearWaveform(self)

    def DeepCopy(self, other):
        r"""DeepCopy(Frame self, Frame other)"""
        return _openshot.Frame_DeepCopy(self, other)

    def Display(self):
        r"""Display(Frame self)"""
        return _openshot.Frame_Display(self)

    def DisplayWaveform(self):
        r"""DisplayWaveform(Frame self)"""
        return _openshot.Frame_DisplayWaveform(self)

    def GetAudioSample(self, channel, sample, magnitude_range):
        r"""GetAudioSample(Frame self, int channel, int sample, int magnitude_range) -> float"""
        return _openshot.Frame_GetAudioSample(self, channel, sample, magnitude_range)

    def GetAudioSamples(self, channel):
        r"""GetAudioSamples(Frame self, int channel) -> float *"""
        return _openshot.Frame_GetAudioSamples(self, channel)

    def GetInterleavedAudioSamples(self, new_sample_rate, resampler, sample_count):
        r"""GetInterleavedAudioSamples(Frame self, int new_sample_rate, AudioResampler * resampler, int * sample_count) -> float *"""
        return _openshot.Frame_GetInterleavedAudioSamples(self, new_sample_rate, resampler, sample_count)

    def GetPlanarAudioSamples(self, new_sample_rate, resampler, sample_count):
        r"""GetPlanarAudioSamples(Frame self, int new_sample_rate, AudioResampler * resampler, int * sample_count) -> float *"""
        return _openshot.Frame_GetPlanarAudioSamples(self, new_sample_rate, resampler, sample_count)

    def GetAudioChannelsCount(self):
        r"""GetAudioChannelsCount(Frame self) -> int"""
        return _openshot.Frame_GetAudioChannelsCount(self)

    def GetAudioSamplesCount(self):
        r"""GetAudioSamplesCount(Frame self) -> int"""
        return _openshot.Frame_GetAudioSamplesCount(self)

    def GetAudioSampleBuffer(self):
        r"""GetAudioSampleBuffer(Frame self) -> juce::AudioSampleBuffer *"""
        return _openshot.Frame_GetAudioSampleBuffer(self)

    def GetBytes(self):
        r"""GetBytes(Frame self) -> int64_t"""
        return _openshot.Frame_GetBytes(self)

    def GetImage(self):
        r"""GetImage(Frame self) -> std::shared_ptr< QImage >"""
        return _openshot.Frame_GetImage(self)

    def GetPixelRatio(self):
        r"""GetPixelRatio(Frame self) -> Fraction"""
        return _openshot.Frame_GetPixelRatio(self)

    def GetPixels(self, *args):
        r"""
        GetPixels(Frame self) -> unsigned char const
        GetPixels(Frame self, int row) -> unsigned char const *
        """
        return _openshot.Frame_GetPixels(self, *args)

    def GetHeight(self):
        r"""GetHeight(Frame self) -> int"""
        return _openshot.Frame_GetHeight(self)

    @staticmethod
    def GetSamplesPerFrame(*args):
        r"""
        GetSamplesPerFrame(Fraction fps, int sample_rate, int channels) -> int
        GetSamplesPerFrame(int64_t frame_number, Fraction fps, int sample_rate, int channels) -> int
        """
        return _openshot.Frame_GetSamplesPerFrame(*args)

    def GetWaveform(self, width, height, Red, Green, Blue, Alpha):
        r"""GetWaveform(Frame self, int width, int height, int Red, int Green, int Blue, int Alpha) -> std::shared_ptr< QImage >"""
        return _openshot.Frame_GetWaveform(self, width, height, Red, Green, Blue, Alpha)

    def GetWaveformPixels(self, width, height, Red, Green, Blue, Alpha):
        r"""GetWaveformPixels(Frame self, int width, int height, int Red, int Green, int Blue, int Alpha) -> unsigned char const *"""
        return _openshot.Frame_GetWaveformPixels(self, width, height, Red, Green, Blue, Alpha)

    def GetWidth(self):
        r"""GetWidth(Frame self) -> int"""
        return _openshot.Frame_GetWidth(self)

    def ResizeAudio(self, channels, length, sample_rate, channel_layout):
        r"""ResizeAudio(Frame self, int channels, int length, int sample_rate, openshot::ChannelLayout channel_layout)"""
        return _openshot.Frame_ResizeAudio(self, channels, length, sample_rate, channel_layout)

    def SampleRate(self, *args):
        r"""
        SampleRate(Frame self) -> int
        SampleRate(Frame self, int orig_sample_rate)
        """
        return _openshot.Frame_SampleRate(self, *args)

    def Save(self, *args):
        r"""Save(Frame self, std::string path, float scale, std::string format="PNG", int quality=100)"""
        return _openshot.Frame_Save(self, *args)

    def SetFrameNumber(self, number):
        r"""SetFrameNumber(Frame self, int64_t number)"""
        return _openshot.Frame_SetFrameNumber(self, number)

    def SetPixelRatio(self, num, den):
        r"""SetPixelRatio(Frame self, int num, int den)"""
        return _openshot.Frame_SetPixelRatio(self, num, den)

    def Thumbnail(self, *args):
        r"""Thumbnail(Frame self, std::string path, int new_width, int new_height, std::string mask_path, std::string overlay_path, std::string background_color, bool ignore_aspect, std::string format="png", int quality=100, float rotate=0.0)"""
        return _openshot.Frame_Thumbnail(self, *args)

    def Play(self):
        r"""Play(Frame self)"""
        return _openshot.Frame_Play(self)

# Register Frame in _openshot:
_openshot.Frame_swigregister(Frame)

def Frame_cleanUpBuffer(info):
    r"""Frame_cleanUpBuffer(void * info)"""
    return _openshot.Frame_cleanUpBuffer(info)

def Frame_GetSamplesPerFrame(*args):
    r"""
    Frame_GetSamplesPerFrame(Fraction fps, int sample_rate, int channels) -> int
    Frame_GetSamplesPerFrame(int64_t frame_number, Fraction fps, int sample_rate, int channels) -> int
    """
    return _openshot.Frame_GetSamplesPerFrame(*args)

PULLDOWN_CLASSIC = _openshot.PULLDOWN_CLASSIC

PULLDOWN_ADVANCED = _openshot.PULLDOWN_ADVANCED

PULLDOWN_NONE = _openshot.PULLDOWN_NONE

class Field(object):
    r"""Proxy of C++ openshot::Field class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    Frame = property(_openshot.Field_Frame_get, _openshot.Field_Frame_set, doc=r"""Frame : int64_t""")
    isOdd = property(_openshot.Field_isOdd_get, _openshot.Field_isOdd_set, doc=r"""isOdd : bool""")

    def __init__(self, *args):
        r"""
        __init__(Field self) -> Field
        __init__(Field self, int64_t frame, bool isodd) -> Field
        """
        _openshot.Field_swiginit(self, _openshot.new_Field(*args))
    __swig_destroy__ = _openshot.delete_Field

# Register Field in _openshot:
_openshot.Field_swigregister(Field)

class SampleRange(object):
    r"""Proxy of C++ openshot::SampleRange class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    frame_start = property(_openshot.SampleRange_frame_start_get, _openshot.SampleRange_frame_start_set, doc=r"""frame_start : int64_t""")
    sample_start = property(_openshot.SampleRange_sample_start_get, _openshot.SampleRange_sample_start_set, doc=r"""sample_start : int""")
    frame_end = property(_openshot.SampleRange_frame_end_get, _openshot.SampleRange_frame_end_set, doc=r"""frame_end : int64_t""")
    sample_end = property(_openshot.SampleRange_sample_end_get, _openshot.SampleRange_sample_end_set, doc=r"""sample_end : int""")
    total = property(_openshot.SampleRange_total_get, _openshot.SampleRange_total_set, doc=r"""total : int""")

    def __init__(self):
        r"""__init__(SampleRange self) -> SampleRange"""
        _openshot.SampleRange_swiginit(self, _openshot.new_SampleRange())
    __swig_destroy__ = _openshot.delete_SampleRange

# Register SampleRange in _openshot:
_openshot.SampleRange_swigregister(SampleRange)

class MappedFrame(object):
    r"""Proxy of C++ openshot::MappedFrame class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    Odd = property(_openshot.MappedFrame_Odd_get, _openshot.MappedFrame_Odd_set, doc=r"""Odd : openshot::Field""")
    Even = property(_openshot.MappedFrame_Even_get, _openshot.MappedFrame_Even_set, doc=r"""Even : openshot::Field""")
    Samples = property(_openshot.MappedFrame_Samples_get, _openshot.MappedFrame_Samples_set, doc=r"""Samples : openshot::SampleRange""")

    def __init__(self):
        r"""__init__(MappedFrame self) -> MappedFrame"""
        _openshot.MappedFrame_swiginit(self, _openshot.new_MappedFrame())
    __swig_destroy__ = _openshot.delete_MappedFrame

# Register MappedFrame in _openshot:
_openshot.MappedFrame_swigregister(MappedFrame)

class FrameMapper(ReaderBase):
    r"""Proxy of C++ openshot::FrameMapper class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    fields = property(_openshot.FrameMapper_fields_get, _openshot.FrameMapper_fields_set, doc=r"""fields : std::vector<(openshot::Field)>""")
    frames = property(_openshot.FrameMapper_frames_get, _openshot.FrameMapper_frames_set, doc=r"""frames : std::vector<(openshot::MappedFrame)>""")

    def __init__(self, reader, target_fps, target_pulldown, target_sample_rate, target_channels, target_channel_layout):
        r"""__init__(FrameMapper self, ReaderBase reader, Fraction target_fps, openshot::PulldownType target_pulldown, int target_sample_rate, int target_channels, openshot::ChannelLayout target_channel_layout) -> FrameMapper"""
        _openshot.FrameMapper_swiginit(self, _openshot.new_FrameMapper(reader, target_fps, target_pulldown, target_sample_rate, target_channels, target_channel_layout))
    __swig_destroy__ = _openshot.delete_FrameMapper

    def ChangeMapping(self, target_fps, pulldown, target_sample_rate, target_channels, target_channel_layout):
        r"""ChangeMapping(FrameMapper self, Fraction target_fps, openshot::PulldownType pulldown, int target_sample_rate, int target_channels, openshot::ChannelLayout target_channel_layout)"""
        return _openshot.FrameMapper_ChangeMapping(self, target_fps, pulldown, target_sample_rate, target_channels, target_channel_layout)

    def Close(self):
        r"""Close(FrameMapper self)"""
        return _openshot.FrameMapper_Close(self)

    def GetMappedFrame(self, TargetFrameNumber):
        r"""GetMappedFrame(FrameMapper self, int64_t TargetFrameNumber) -> MappedFrame"""
        return _openshot.FrameMapper_GetMappedFrame(self, TargetFrameNumber)

    def GetCache(self):
        r"""GetCache(FrameMapper self) -> CacheMemory"""
        return _openshot.FrameMapper_GetCache(self)

    def GetFrame(self, requested_frame):
        r"""GetFrame(FrameMapper self, int64_t requested_frame) -> std::shared_ptr< openshot::Frame >"""
        return _openshot.FrameMapper_GetFrame(self, requested_frame)

    def IsOpen(self):
        r"""IsOpen(FrameMapper self) -> bool"""
        return _openshot.FrameMapper_IsOpen(self)

    def Name(self):
        r"""Name(FrameMapper self) -> std::string"""
        return _openshot.FrameMapper_Name(self)

    def Json(self):
        r"""Json(FrameMapper self) -> std::string"""
        return _openshot.FrameMapper_Json(self)

    def SetJson(self, value):
        r"""SetJson(FrameMapper self, std::string value)"""
        return _openshot.FrameMapper_SetJson(self, value)

    def JsonValue(self):
        r"""JsonValue(FrameMapper self) -> Json::Value"""
        return _openshot.FrameMapper_JsonValue(self)

    def SetJsonValue(self, root):
        r"""SetJsonValue(FrameMapper self, Json::Value root)"""
        return _openshot.FrameMapper_SetJsonValue(self, root)

    def Open(self):
        r"""Open(FrameMapper self)"""
        return _openshot.FrameMapper_Open(self)

    def PrintMapping(self):
        r"""PrintMapping(FrameMapper self)"""
        return _openshot.FrameMapper_PrintMapping(self)

    def Reader(self):
        r"""Reader(FrameMapper self) -> ReaderBase"""
        return _openshot.FrameMapper_Reader(self)

    def ResampleMappedAudio(self, frame, original_frame_number):
        r"""ResampleMappedAudio(FrameMapper self, std::shared_ptr< openshot::Frame > frame, int64_t original_frame_number)"""
        return _openshot.FrameMapper_ResampleMappedAudio(self, frame, original_frame_number)

# Register FrameMapper in _openshot:
_openshot.FrameMapper_swigregister(FrameMapper)

PLAYBACK_PLAY = _openshot.PLAYBACK_PLAY

PLAYBACK_PAUSED = _openshot.PLAYBACK_PAUSED

PLAYBACK_LOADING = _openshot.PLAYBACK_LOADING

PLAYBACK_STOPPED = _openshot.PLAYBACK_STOPPED

class PlayerBase(object):
    r"""Proxy of C++ openshot::PlayerBase class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    def Loading(self):
        r"""Loading(PlayerBase self)"""
        return _openshot.PlayerBase_Loading(self)

    def Mode(self):
        r"""Mode(PlayerBase self) -> openshot::PlaybackMode"""
        return _openshot.PlayerBase_Mode(self)

    def Play(self):
        r"""Play(PlayerBase self)"""
        return _openshot.PlayerBase_Play(self)

    def Pause(self):
        r"""Pause(PlayerBase self)"""
        return _openshot.PlayerBase_Pause(self)

    def Position(self):
        r"""Position(PlayerBase self) -> int"""
        return _openshot.PlayerBase_Position(self)

    def Seek(self, new_frame):
        r"""Seek(PlayerBase self, int64_t new_frame)"""
        return _openshot.PlayerBase_Seek(self, new_frame)

    def Speed(self, *args):
        r"""
        Speed(PlayerBase self) -> float
        Speed(PlayerBase self, float new_speed)
        """
        return _openshot.PlayerBase_Speed(self, *args)

    def Stop(self):
        r"""Stop(PlayerBase self)"""
        return _openshot.PlayerBase_Stop(self)

    def Reader(self, *args):
        r"""
        Reader(PlayerBase self) -> ReaderBase
        Reader(PlayerBase self, ReaderBase new_reader)
        """
        return _openshot.PlayerBase_Reader(self, *args)

    def Volume(self, *args):
        r"""
        Volume(PlayerBase self) -> float
        Volume(PlayerBase self, float new_volume)
        """
        return _openshot.PlayerBase_Volume(self, *args)
    __swig_destroy__ = _openshot.delete_PlayerBase

# Register PlayerBase in _openshot:
_openshot.PlayerBase_swigregister(PlayerBase)

BEZIER = _openshot.BEZIER

LINEAR = _openshot.LINEAR

CONSTANT = _openshot.CONSTANT

AUTO = _openshot.AUTO

MANUAL = _openshot.MANUAL

class Point(object):
    r"""Proxy of C++ openshot::Point class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    co = property(_openshot.Point_co_get, _openshot.Point_co_set, doc=r"""co : openshot::Coordinate""")
    handle_left = property(_openshot.Point_handle_left_get, _openshot.Point_handle_left_set, doc=r"""handle_left : openshot::Coordinate""")
    handle_right = property(_openshot.Point_handle_right_get, _openshot.Point_handle_right_set, doc=r"""handle_right : openshot::Coordinate""")
    interpolation = property(_openshot.Point_interpolation_get, _openshot.Point_interpolation_set, doc=r"""interpolation : openshot::InterpolationType""")
    handle_type = property(_openshot.Point_handle_type_get, _openshot.Point_handle_type_set, doc=r"""handle_type : openshot::HandleType""")

    def __init__(self, *args):
        r"""
        __init__(Point self) -> Point
        __init__(Point self, float y) -> Point
        __init__(Point self, float x, float y) -> Point
        __init__(Point self, float x, float y, openshot::InterpolationType interpolation) -> Point
        __init__(Point self, Coordinate co) -> Point
        __init__(Point self, Coordinate co, openshot::InterpolationType interpolation) -> Point
        __init__(Point self, Coordinate co, openshot::InterpolationType interpolation, openshot::HandleType handle_type) -> Point
        """
        _openshot.Point_swiginit(self, _openshot.new_Point(*args))

    def Initialize_Handles(self):
        r"""Initialize_Handles(Point self)"""
        return _openshot.Point_Initialize_Handles(self)

    def Initialize_LeftHandle(self, x, y):
        r"""Initialize_LeftHandle(Point self, float x, float y)"""
        return _openshot.Point_Initialize_LeftHandle(self, x, y)

    def Initialize_RightHandle(self, x, y):
        r"""Initialize_RightHandle(Point self, float x, float y)"""
        return _openshot.Point_Initialize_RightHandle(self, x, y)

    def Json(self):
        r"""Json(Point self) -> std::string"""
        return _openshot.Point_Json(self)

    def JsonValue(self):
        r"""JsonValue(Point self) -> Json::Value"""
        return _openshot.Point_JsonValue(self)

    def SetJson(self, value):
        r"""SetJson(Point self, std::string value)"""
        return _openshot.Point_SetJson(self, value)

    def SetJsonValue(self, root):
        r"""SetJsonValue(Point self, Json::Value root)"""
        return _openshot.Point_SetJsonValue(self, root)
    __swig_destroy__ = _openshot.delete_Point

# Register Point in _openshot:
_openshot.Point_swigregister(Point)

class ProfileInfo(object):
    r"""Proxy of C++ openshot::ProfileInfo class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    description = property(_openshot.ProfileInfo_description_get, _openshot.ProfileInfo_description_set, doc=r"""description : std::string""")
    height = property(_openshot.ProfileInfo_height_get, _openshot.ProfileInfo_height_set, doc=r"""height : int""")
    width = property(_openshot.ProfileInfo_width_get, _openshot.ProfileInfo_width_set, doc=r"""width : int""")
    pixel_format = property(_openshot.ProfileInfo_pixel_format_get, _openshot.ProfileInfo_pixel_format_set, doc=r"""pixel_format : int""")
    fps = property(_openshot.ProfileInfo_fps_get, _openshot.ProfileInfo_fps_set, doc=r"""fps : openshot::Fraction""")
    pixel_ratio = property(_openshot.ProfileInfo_pixel_ratio_get, _openshot.ProfileInfo_pixel_ratio_set, doc=r"""pixel_ratio : openshot::Fraction""")
    display_ratio = property(_openshot.ProfileInfo_display_ratio_get, _openshot.ProfileInfo_display_ratio_set, doc=r"""display_ratio : openshot::Fraction""")
    interlaced_frame = property(_openshot.ProfileInfo_interlaced_frame_get, _openshot.ProfileInfo_interlaced_frame_set, doc=r"""interlaced_frame : bool""")

    def __init__(self):
        r"""__init__(ProfileInfo self) -> ProfileInfo"""
        _openshot.ProfileInfo_swiginit(self, _openshot.new_ProfileInfo())
    __swig_destroy__ = _openshot.delete_ProfileInfo

# Register ProfileInfo in _openshot:
_openshot.ProfileInfo_swigregister(ProfileInfo)

class Profile(object):
    r"""Proxy of C++ openshot::Profile class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    info = property(_openshot.Profile_info_get, _openshot.Profile_info_set, doc=r"""info : openshot::ProfileInfo""")

    def __init__(self, path):
        r"""__init__(Profile self, std::string path) -> Profile"""
        _openshot.Profile_swiginit(self, _openshot.new_Profile(path))

    def Json(self):
        r"""Json(Profile self) -> std::string"""
        return _openshot.Profile_Json(self)

    def JsonValue(self):
        r"""JsonValue(Profile self) -> Json::Value"""
        return _openshot.Profile_JsonValue(self)

    def SetJson(self, value):
        r"""SetJson(Profile self, std::string value)"""
        return _openshot.Profile_SetJson(self, value)

    def SetJsonValue(self, root):
        r"""SetJsonValue(Profile self, Json::Value root)"""
        return _openshot.Profile_SetJsonValue(self, root)
    __swig_destroy__ = _openshot.delete_Profile

# Register Profile in _openshot:
_openshot.Profile_swigregister(Profile)

class QtImageReader(ReaderBase):
    r"""Proxy of C++ openshot::QtImageReader class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(QtImageReader self, std::string path) -> QtImageReader
        __init__(QtImageReader self, std::string path, bool inspect_reader) -> QtImageReader
        """
        _openshot.QtImageReader_swiginit(self, _openshot.new_QtImageReader(*args))

    def Close(self):
        r"""Close(QtImageReader self)"""
        return _openshot.QtImageReader_Close(self)

    def GetCache(self):
        r"""GetCache(QtImageReader self) -> CacheMemory"""
        return _openshot.QtImageReader_GetCache(self)

    def GetFrame(self, requested_frame):
        r"""GetFrame(QtImageReader self, int64_t requested_frame) -> std::shared_ptr< openshot::Frame >"""
        return _openshot.QtImageReader_GetFrame(self, requested_frame)

    def IsOpen(self):
        r"""IsOpen(QtImageReader self) -> bool"""
        return _openshot.QtImageReader_IsOpen(self)

    def Name(self):
        r"""Name(QtImageReader self) -> std::string"""
        return _openshot.QtImageReader_Name(self)

    def Json(self):
        r"""Json(QtImageReader self) -> std::string"""
        return _openshot.QtImageReader_Json(self)

    def SetJson(self, value):
        r"""SetJson(QtImageReader self, std::string value)"""
        return _openshot.QtImageReader_SetJson(self, value)

    def JsonValue(self):
        r"""JsonValue(QtImageReader self) -> Json::Value"""
        return _openshot.QtImageReader_JsonValue(self)

    def SetJsonValue(self, root):
        r"""SetJsonValue(QtImageReader self, Json::Value root)"""
        return _openshot.QtImageReader_SetJsonValue(self, root)

    def Open(self):
        r"""Open(QtImageReader self)"""
        return _openshot.QtImageReader_Open(self)
    __swig_destroy__ = _openshot.delete_QtImageReader

# Register QtImageReader in _openshot:
_openshot.QtImageReader_swigregister(QtImageReader)

class QtPlayer(PlayerBase):
    r"""Proxy of C++ openshot::QtPlayer class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(QtPlayer self) -> QtPlayer
        __init__(QtPlayer self, RendererBase rb) -> QtPlayer
        """
        _openshot.QtPlayer_swiginit(self, _openshot.new_QtPlayer(*args))
    __swig_destroy__ = _openshot.delete_QtPlayer

    def CloseAudioDevice(self):
        r"""CloseAudioDevice(QtPlayer self)"""
        return _openshot.QtPlayer_CloseAudioDevice(self)

    def GetError(self):
        r"""GetError(QtPlayer self) -> std::string"""
        return _openshot.QtPlayer_GetError(self)

    def Play(self):
        r"""Play(QtPlayer self)"""
        return _openshot.QtPlayer_Play(self)

    def Loading(self):
        r"""Loading(QtPlayer self)"""
        return _openshot.QtPlayer_Loading(self)

    def Mode(self):
        r"""Mode(QtPlayer self) -> openshot::PlaybackMode"""
        return _openshot.QtPlayer_Mode(self)

    def Pause(self):
        r"""Pause(QtPlayer self)"""
        return _openshot.QtPlayer_Pause(self)

    def Position(self):
        r"""Position(QtPlayer self) -> int"""
        return _openshot.QtPlayer_Position(self)

    def Seek(self, new_frame):
        r"""Seek(QtPlayer self, int64_t new_frame)"""
        return _openshot.QtPlayer_Seek(self, new_frame)

    def SetSource(self, source):
        r"""SetSource(QtPlayer self, std::string const & source)"""
        return _openshot.QtPlayer_SetSource(self, source)

    def SetQWidget(self, qwidget_address):
        r"""SetQWidget(QtPlayer self, int64_t qwidget_address)"""
        return _openshot.QtPlayer_SetQWidget(self, qwidget_address)

    def GetRendererQObject(self):
        r"""GetRendererQObject(QtPlayer self) -> int64_t"""
        return _openshot.QtPlayer_GetRendererQObject(self)

    def Speed(self, *args):
        r"""
        Speed(QtPlayer self) -> float
        Speed(QtPlayer self, float new_speed)
        """
        return _openshot.QtPlayer_Speed(self, *args)

    def Stop(self):
        r"""Stop(QtPlayer self)"""
        return _openshot.QtPlayer_Stop(self)

    def Reader(self, *args):
        r"""
        Reader(QtPlayer self, ReaderBase new_reader)
        Reader(QtPlayer self) -> ReaderBase
        """
        return _openshot.QtPlayer_Reader(self, *args)

    def Volume(self, *args):
        r"""
        Volume(QtPlayer self) -> float
        Volume(QtPlayer self, float new_volume)
        """
        return _openshot.QtPlayer_Volume(self, *args)

# Register QtPlayer in _openshot:
_openshot.QtPlayer_swigregister(QtPlayer)

class Keyframe(object):
    r"""Proxy of C++ openshot::Keyframe class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    Points = property(_openshot.Keyframe_Points_get, _openshot.Keyframe_Points_set, doc=r"""Points : std::vector<(openshot::Point)>""")
    Values = property(_openshot.Keyframe_Values_get, _openshot.Keyframe_Values_set, doc=r"""Values : std::vector<(openshot::Coordinate)>""")

    def __init__(self, *args):
        r"""
        __init__(Keyframe self) -> Keyframe
        __init__(Keyframe self, double value) -> Keyframe
        """
        _openshot.Keyframe_swiginit(self, _openshot.new_Keyframe(*args))

    def AddPoint(self, *args):
        r"""
        AddPoint(Keyframe self, Point p)
        AddPoint(Keyframe self, double x, double y)
        AddPoint(Keyframe self, double x, double y, openshot::InterpolationType interpolate)
        """
        return _openshot.Keyframe_AddPoint(self, *args)

    def Contains(self, p):
        r"""Contains(Keyframe self, Point p) -> bool"""
        return _openshot.Keyframe_Contains(self, p)

    def FlipPoints(self):
        r"""FlipPoints(Keyframe self)"""
        return _openshot.Keyframe_FlipPoints(self)

    def FindIndex(self, p):
        r"""FindIndex(Keyframe self, Point p) -> int64_t"""
        return _openshot.Keyframe_FindIndex(self, p)

    def GetValue(self, index):
        r"""GetValue(Keyframe self, int64_t index) -> double"""
        return _openshot.Keyframe_GetValue(self, index)

    def GetInt(self, index):
        r"""GetInt(Keyframe self, int64_t index) -> int"""
        return _openshot.Keyframe_GetInt(self, index)

    def GetLong(self, index):
        r"""GetLong(Keyframe self, int64_t index) -> int64_t"""
        return _openshot.Keyframe_GetLong(self, index)

    def GetRepeatFraction(self, index):
        r"""GetRepeatFraction(Keyframe self, int64_t index) -> Fraction"""
        return _openshot.Keyframe_GetRepeatFraction(self, index)

    def GetDelta(self, index):
        r"""GetDelta(Keyframe self, int64_t index) -> double"""
        return _openshot.Keyframe_GetDelta(self, index)

    def GetPoint(self, index):
        r"""GetPoint(Keyframe self, int64_t index) -> Point"""
        return _openshot.Keyframe_GetPoint(self, index)

    def GetClosestPoint(self, *args):
        r"""
        GetClosestPoint(Keyframe self, Point p) -> Point
        GetClosestPoint(Keyframe self, Point p, bool useLeft) -> Point
        """
        return _openshot.Keyframe_GetClosestPoint(self, *args)

    def GetPreviousPoint(self, p):
        r"""GetPreviousPoint(Keyframe self, Point p) -> Point"""
        return _openshot.Keyframe_GetPreviousPoint(self, p)

    def GetMaxPoint(self):
        r"""GetMaxPoint(Keyframe self) -> Point"""
        return _openshot.Keyframe_GetMaxPoint(self)

    def GetLength(self):
        r"""GetLength(Keyframe self) -> int64_t"""
        return _openshot.Keyframe_GetLength(self)

    def GetCount(self):
        r"""GetCount(Keyframe self) -> int64_t"""
        return _openshot.Keyframe_GetCount(self)

    def IsIncreasing(self, index):
        r"""IsIncreasing(Keyframe self, int index) -> bool"""
        return _openshot.Keyframe_IsIncreasing(self, index)

    def Json(self):
        r"""Json(Keyframe self) -> std::string"""
        return _openshot.Keyframe_Json(self)

    def JsonValue(self):
        r"""JsonValue(Keyframe self) -> Json::Value"""
        return _openshot.Keyframe_JsonValue(self)

    def SetJson(self, value):
        r"""SetJson(Keyframe self, std::string value)"""
        return _openshot.Keyframe_SetJson(self, value)

    def SetJsonValue(self, root):
        r"""SetJsonValue(Keyframe self, Json::Value root)"""
        return _openshot.Keyframe_SetJsonValue(self, root)

    def Process(self):
        r"""Process(Keyframe self)"""
        return _openshot.Keyframe_Process(self)

    def RemovePoint(self, *args):
        r"""
        RemovePoint(Keyframe self, Point p)
        RemovePoint(Keyframe self, int64_t index)
        """
        return _openshot.Keyframe_RemovePoint(self, *args)

    def ScalePoints(self, scale):
        r"""ScalePoints(Keyframe self, double scale)"""
        return _openshot.Keyframe_ScalePoints(self, scale)

    def UpdatePoint(self, index, p):
        r"""UpdatePoint(Keyframe self, int64_t index, Point p)"""
        return _openshot.Keyframe_UpdatePoint(self, index, p)

    def PrintPoints(self):
        r"""PrintPoints(Keyframe self)"""
        return _openshot.Keyframe_PrintPoints(self)

    def PrintValues(self):
        r"""PrintValues(Keyframe self)"""
        return _openshot.Keyframe_PrintValues(self)
    __swig_destroy__ = _openshot.delete_Keyframe

# Register Keyframe in _openshot:
_openshot.Keyframe_swigregister(Keyframe)

class RendererBase(object):
    r"""Proxy of C++ openshot::RendererBase class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    def paint(self, frame):
        r"""paint(RendererBase self, std::shared_ptr< openshot::Frame > const & frame)"""
        return _openshot.RendererBase_paint(self, frame)

    def OverrideWidget(self, qwidget_address):
        r"""OverrideWidget(RendererBase self, int64_t qwidget_address)"""
        return _openshot.RendererBase_OverrideWidget(self, qwidget_address)

# Register RendererBase in _openshot:
_openshot.RendererBase_swigregister(RendererBase)

class Settings(object):
    r"""Proxy of C++ openshot::Settings class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    HARDWARE_DECODE = property(_openshot.Settings_HARDWARE_DECODE_get, _openshot.Settings_HARDWARE_DECODE_set, doc=r"""HARDWARE_DECODE : bool""")
    HARDWARE_ENCODE = property(_openshot.Settings_HARDWARE_ENCODE_get, _openshot.Settings_HARDWARE_ENCODE_set, doc=r"""HARDWARE_ENCODE : bool""")
    HIGH_QUALITY_SCALING = property(_openshot.Settings_HIGH_QUALITY_SCALING_get, _openshot.Settings_HIGH_QUALITY_SCALING_set, doc=r"""HIGH_QUALITY_SCALING : bool""")
    MAX_WIDTH = property(_openshot.Settings_MAX_WIDTH_get, _openshot.Settings_MAX_WIDTH_set, doc=r"""MAX_WIDTH : int""")
    MAX_HEIGHT = property(_openshot.Settings_MAX_HEIGHT_get, _openshot.Settings_MAX_HEIGHT_set, doc=r"""MAX_HEIGHT : int""")
    WAIT_FOR_VIDEO_PROCESSING_TASK = property(_openshot.Settings_WAIT_FOR_VIDEO_PROCESSING_TASK_get, _openshot.Settings_WAIT_FOR_VIDEO_PROCESSING_TASK_set, doc=r"""WAIT_FOR_VIDEO_PROCESSING_TASK : bool""")

    @staticmethod
    def Instance():
        r"""Instance() -> Settings"""
        return _openshot.Settings_Instance()
    __swig_destroy__ = _openshot.delete_Settings

# Register Settings in _openshot:
_openshot.Settings_swigregister(Settings)

def Settings_Instance():
    r"""Settings_Instance() -> Settings"""
    return _openshot.Settings_Instance()

class CompareClips(object):
    r"""Proxy of C++ openshot::CompareClips class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __call__(self, lhs, rhs):
        r"""__call__(CompareClips self, Clip lhs, Clip rhs) -> bool"""
        return _openshot.CompareClips___call__(self, lhs, rhs)

    def __init__(self):
        r"""__init__(CompareClips self) -> CompareClips"""
        _openshot.CompareClips_swiginit(self, _openshot.new_CompareClips())
    __swig_destroy__ = _openshot.delete_CompareClips

# Register CompareClips in _openshot:
_openshot.CompareClips_swigregister(CompareClips)

class CompareEffects(object):
    r"""Proxy of C++ openshot::CompareEffects class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __call__(self, lhs, rhs):
        r"""__call__(CompareEffects self, EffectBase lhs, EffectBase rhs) -> bool"""
        return _openshot.CompareEffects___call__(self, lhs, rhs)

    def __init__(self):
        r"""__init__(CompareEffects self) -> CompareEffects"""
        _openshot.CompareEffects_swiginit(self, _openshot.new_CompareEffects())
    __swig_destroy__ = _openshot.delete_CompareEffects

# Register CompareEffects in _openshot:
_openshot.CompareEffects_swigregister(CompareEffects)

class Timeline(ReaderBase):
    r"""Proxy of C++ openshot::Timeline class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, width, height, fps, sample_rate, channels, channel_layout):
        r"""__init__(Timeline self, int width, int height, Fraction fps, int sample_rate, int channels, openshot::ChannelLayout channel_layout) -> Timeline"""
        _openshot.Timeline_swiginit(self, _openshot.new_Timeline(width, height, fps, sample_rate, channels, channel_layout))

    def AddClip(self, clip):
        r"""AddClip(Timeline self, Clip clip)"""
        return _openshot.Timeline_AddClip(self, clip)

    def AddEffect(self, effect):
        r"""AddEffect(Timeline self, EffectBase effect)"""
        return _openshot.Timeline_AddEffect(self, effect)

    def ApplyMapperToClips(self):
        r"""ApplyMapperToClips(Timeline self)"""
        return _openshot.Timeline_ApplyMapperToClips(self)

    def AutoMapClips(self, *args):
        r"""
        AutoMapClips(Timeline self) -> bool
        AutoMapClips(Timeline self, bool auto_map)
        """
        return _openshot.Timeline_AutoMapClips(self, *args)

    def ClearAllCache(self):
        r"""ClearAllCache(Timeline self)"""
        return _openshot.Timeline_ClearAllCache(self)

    def Clips(self):
        r"""Clips(Timeline self) -> ClipList"""
        return _openshot.Timeline_Clips(self)

    def Close(self):
        r"""Close(Timeline self)"""
        return _openshot.Timeline_Close(self)

    def Effects(self):
        r"""Effects(Timeline self) -> EffectBaseList"""
        return _openshot.Timeline_Effects(self)

    def GetCache(self):
        r"""GetCache(Timeline self) -> CacheBase"""
        return _openshot.Timeline_GetCache(self)

    def SetCache(self, new_cache):
        r"""SetCache(Timeline self, CacheBase new_cache)"""
        return _openshot.Timeline_SetCache(self, new_cache)

    def GetFrame(self, requested_frame):
        r"""GetFrame(Timeline self, int64_t requested_frame) -> std::shared_ptr< openshot::Frame >"""
        return _openshot.Timeline_GetFrame(self, requested_frame)
    viewport_scale = property(_openshot.Timeline_viewport_scale_get, _openshot.Timeline_viewport_scale_set, doc=r"""viewport_scale : openshot::Keyframe""")
    viewport_x = property(_openshot.Timeline_viewport_x_get, _openshot.Timeline_viewport_x_set, doc=r"""viewport_x : openshot::Keyframe""")
    viewport_y = property(_openshot.Timeline_viewport_y_get, _openshot.Timeline_viewport_y_set, doc=r"""viewport_y : openshot::Keyframe""")
    color = property(_openshot.Timeline_color_get, _openshot.Timeline_color_set, doc=r"""color : openshot::Color""")

    def IsOpen(self):
        r"""IsOpen(Timeline self) -> bool"""
        return _openshot.Timeline_IsOpen(self)

    def Name(self):
        r"""Name(Timeline self) -> std::string"""
        return _openshot.Timeline_Name(self)

    def Json(self):
        r"""Json(Timeline self) -> std::string"""
        return _openshot.Timeline_Json(self)

    def SetJson(self, value):
        r"""SetJson(Timeline self, std::string value)"""
        return _openshot.Timeline_SetJson(self, value)

    def JsonValue(self):
        r"""JsonValue(Timeline self) -> Json::Value"""
        return _openshot.Timeline_JsonValue(self)

    def SetJsonValue(self, root):
        r"""SetJsonValue(Timeline self, Json::Value root)"""
        return _openshot.Timeline_SetJsonValue(self, root)

    def SetMaxSize(self, width, height):
        r"""SetMaxSize(Timeline self, int width, int height)"""
        return _openshot.Timeline_SetMaxSize(self, width, height)

    def ApplyJsonDiff(self, value):
        r"""ApplyJsonDiff(Timeline self, std::string value)"""
        return _openshot.Timeline_ApplyJsonDiff(self, value)

    def Open(self):
        r"""Open(Timeline self)"""
        return _openshot.Timeline_Open(self)

    def RemoveClip(self, clip):
        r"""RemoveClip(Timeline self, Clip clip)"""
        return _openshot.Timeline_RemoveClip(self, clip)

    def RemoveEffect(self, effect):
        r"""RemoveEffect(Timeline self, EffectBase effect)"""
        return _openshot.Timeline_RemoveEffect(self, effect)
    __swig_destroy__ = _openshot.delete_Timeline

# Register Timeline in _openshot:
_openshot.Timeline_swigregister(Timeline)

class ZmqLogger(object):
    r"""Proxy of C++ openshot::ZmqLogger class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    @staticmethod
    def Instance():
        r"""Instance() -> ZmqLogger"""
        return _openshot.ZmqLogger_Instance()

    def AppendDebugMethod(self, method_name, arg1_name, arg1_value, arg2_name, arg2_value, arg3_name, arg3_value, arg4_name, arg4_value, arg5_name, arg5_value, arg6_name, arg6_value):
        r"""AppendDebugMethod(ZmqLogger self, std::string method_name, std::string arg1_name, float arg1_value, std::string arg2_name, float arg2_value, std::string arg3_name, float arg3_value, std::string arg4_name, float arg4_value, std::string arg5_name, float arg5_value, std::string arg6_name, float arg6_value)"""
        return _openshot.ZmqLogger_AppendDebugMethod(self, method_name, arg1_name, arg1_value, arg2_name, arg2_value, arg3_name, arg3_value, arg4_name, arg4_value, arg5_name, arg5_value, arg6_name, arg6_value)

    def Close(self):
        r"""Close(ZmqLogger self)"""
        return _openshot.ZmqLogger_Close(self)

    def Connection(self, new_connection):
        r"""Connection(ZmqLogger self, std::string new_connection)"""
        return _openshot.ZmqLogger_Connection(self, new_connection)

    def Enable(self, is_enabled):
        r"""Enable(ZmqLogger self, bool is_enabled)"""
        return _openshot.ZmqLogger_Enable(self, is_enabled)

    def Path(self, new_path):
        r"""Path(ZmqLogger self, std::string new_path)"""
        return _openshot.ZmqLogger_Path(self, new_path)

    def Log(self, message):
        r"""Log(ZmqLogger self, std::string message)"""
        return _openshot.ZmqLogger_Log(self, message)

    def LogToFile(self, message):
        r"""LogToFile(ZmqLogger self, std::string message)"""
        return _openshot.ZmqLogger_LogToFile(self, message)
    __swig_destroy__ = _openshot.delete_ZmqLogger

# Register ZmqLogger in _openshot:
_openshot.ZmqLogger_swigregister(ZmqLogger)

def ZmqLogger_Instance():
    r"""ZmqLogger_Instance() -> ZmqLogger"""
    return _openshot.ZmqLogger_Instance()

class Bars(EffectBase):
    r"""Proxy of C++ openshot::Bars class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    color = property(_openshot.Bars_color_get, _openshot.Bars_color_set, doc=r"""color : openshot::Color""")
    left = property(_openshot.Bars_left_get, _openshot.Bars_left_set, doc=r"""left : openshot::Keyframe""")
    top = property(_openshot.Bars_top_get, _openshot.Bars_top_set, doc=r"""top : openshot::Keyframe""")
    right = property(_openshot.Bars_right_get, _openshot.Bars_right_set, doc=r"""right : openshot::Keyframe""")
    bottom = property(_openshot.Bars_bottom_get, _openshot.Bars_bottom_set, doc=r"""bottom : openshot::Keyframe""")

    def __init__(self, *args):
        r"""
        __init__(Bars self) -> Bars
        __init__(Bars self, Color color, Keyframe left, Keyframe top, Keyframe right, Keyframe bottom) -> Bars
        """
        _openshot.Bars_swiginit(self, _openshot.new_Bars(*args))

    def GetFrame(self, frame, frame_number):
        r"""GetFrame(Bars self, std::shared_ptr< openshot::Frame > frame, int64_t frame_number) -> std::shared_ptr< openshot::Frame >"""
        return _openshot.Bars_GetFrame(self, frame, frame_number)

    def Json(self):
        r"""Json(Bars self) -> std::string"""
        return _openshot.Bars_Json(self)

    def SetJson(self, value):
        r"""SetJson(Bars self, std::string value)"""
        return _openshot.Bars_SetJson(self, value)

    def JsonValue(self):
        r"""JsonValue(Bars self) -> Json::Value"""
        return _openshot.Bars_JsonValue(self)

    def SetJsonValue(self, root):
        r"""SetJsonValue(Bars self, Json::Value root)"""
        return _openshot.Bars_SetJsonValue(self, root)

    def PropertiesJSON(self, requested_frame):
        r"""PropertiesJSON(Bars self, int64_t requested_frame) -> std::string"""
        return _openshot.Bars_PropertiesJSON(self, requested_frame)
    __swig_destroy__ = _openshot.delete_Bars

# Register Bars in _openshot:
_openshot.Bars_swigregister(Bars)

class Blur(EffectBase):
    r"""Proxy of C++ openshot::Blur class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    horizontal_radius = property(_openshot.Blur_horizontal_radius_get, _openshot.Blur_horizontal_radius_set, doc=r"""horizontal_radius : openshot::Keyframe""")
    vertical_radius = property(_openshot.Blur_vertical_radius_get, _openshot.Blur_vertical_radius_set, doc=r"""vertical_radius : openshot::Keyframe""")
    sigma = property(_openshot.Blur_sigma_get, _openshot.Blur_sigma_set, doc=r"""sigma : openshot::Keyframe""")
    iterations = property(_openshot.Blur_iterations_get, _openshot.Blur_iterations_set, doc=r"""iterations : openshot::Keyframe""")

    def __init__(self, *args):
        r"""
        __init__(Blur self) -> Blur
        __init__(Blur self, Keyframe new_horizontal_radius, Keyframe new_vertical_radius, Keyframe new_sigma, Keyframe new_iterations) -> Blur
        """
        _openshot.Blur_swiginit(self, _openshot.new_Blur(*args))

    def GetFrame(self, frame, frame_number):
        r"""GetFrame(Blur self, std::shared_ptr< openshot::Frame > frame, int64_t frame_number) -> std::shared_ptr< openshot::Frame >"""
        return _openshot.Blur_GetFrame(self, frame, frame_number)

    def Json(self):
        r"""Json(Blur self) -> std::string"""
        return _openshot.Blur_Json(self)

    def SetJson(self, value):
        r"""SetJson(Blur self, std::string value)"""
        return _openshot.Blur_SetJson(self, value)

    def JsonValue(self):
        r"""JsonValue(Blur self) -> Json::Value"""
        return _openshot.Blur_JsonValue(self)

    def SetJsonValue(self, root):
        r"""SetJsonValue(Blur self, Json::Value root)"""
        return _openshot.Blur_SetJsonValue(self, root)

    def PropertiesJSON(self, requested_frame):
        r"""PropertiesJSON(Blur self, int64_t requested_frame) -> std::string"""
        return _openshot.Blur_PropertiesJSON(self, requested_frame)
    __swig_destroy__ = _openshot.delete_Blur

# Register Blur in _openshot:
_openshot.Blur_swigregister(Blur)

class Brightness(EffectBase):
    r"""Proxy of C++ openshot::Brightness class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    brightness = property(_openshot.Brightness_brightness_get, _openshot.Brightness_brightness_set, doc=r"""brightness : openshot::Keyframe""")
    contrast = property(_openshot.Brightness_contrast_get, _openshot.Brightness_contrast_set, doc=r"""contrast : openshot::Keyframe""")

    def __init__(self, *args):
        r"""
        __init__(Brightness self) -> Brightness
        __init__(Brightness self, Keyframe new_brightness, Keyframe new_contrast) -> Brightness
        """
        _openshot.Brightness_swiginit(self, _openshot.new_Brightness(*args))

    def GetFrame(self, frame, frame_number):
        r"""GetFrame(Brightness self, std::shared_ptr< openshot::Frame > frame, int64_t frame_number) -> std::shared_ptr< openshot::Frame >"""
        return _openshot.Brightness_GetFrame(self, frame, frame_number)

    def Json(self):
        r"""Json(Brightness self) -> std::string"""
        return _openshot.Brightness_Json(self)

    def SetJson(self, value):
        r"""SetJson(Brightness self, std::string value)"""
        return _openshot.Brightness_SetJson(self, value)

    def JsonValue(self):
        r"""JsonValue(Brightness self) -> Json::Value"""
        return _openshot.Brightness_JsonValue(self)

    def SetJsonValue(self, root):
        r"""SetJsonValue(Brightness self, Json::Value root)"""
        return _openshot.Brightness_SetJsonValue(self, root)

    def PropertiesJSON(self, requested_frame):
        r"""PropertiesJSON(Brightness self, int64_t requested_frame) -> std::string"""
        return _openshot.Brightness_PropertiesJSON(self, requested_frame)
    __swig_destroy__ = _openshot.delete_Brightness

# Register Brightness in _openshot:
_openshot.Brightness_swigregister(Brightness)

class ChromaKey(EffectBase):
    r"""Proxy of C++ openshot::ChromaKey class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(ChromaKey self) -> ChromaKey
        __init__(ChromaKey self, Color color, Keyframe fuzz) -> ChromaKey
        """
        _openshot.ChromaKey_swiginit(self, _openshot.new_ChromaKey(*args))

    def GetFrame(self, frame, frame_number):
        r"""GetFrame(ChromaKey self, std::shared_ptr< openshot::Frame > frame, int64_t frame_number) -> std::shared_ptr< openshot::Frame >"""
        return _openshot.ChromaKey_GetFrame(self, frame, frame_number)

    def Json(self):
        r"""Json(ChromaKey self) -> std::string"""
        return _openshot.ChromaKey_Json(self)

    def SetJson(self, value):
        r"""SetJson(ChromaKey self, std::string value)"""
        return _openshot.ChromaKey_SetJson(self, value)

    def JsonValue(self):
        r"""JsonValue(ChromaKey self) -> Json::Value"""
        return _openshot.ChromaKey_JsonValue(self)

    def SetJsonValue(self, root):
        r"""SetJsonValue(ChromaKey self, Json::Value root)"""
        return _openshot.ChromaKey_SetJsonValue(self, root)

    def PropertiesJSON(self, requested_frame):
        r"""PropertiesJSON(ChromaKey self, int64_t requested_frame) -> std::string"""
        return _openshot.ChromaKey_PropertiesJSON(self, requested_frame)
    __swig_destroy__ = _openshot.delete_ChromaKey

# Register ChromaKey in _openshot:
_openshot.ChromaKey_swigregister(ChromaKey)

class ColorShift(EffectBase):
    r"""Proxy of C++ openshot::ColorShift class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    red_x = property(_openshot.ColorShift_red_x_get, _openshot.ColorShift_red_x_set, doc=r"""red_x : openshot::Keyframe""")
    red_y = property(_openshot.ColorShift_red_y_get, _openshot.ColorShift_red_y_set, doc=r"""red_y : openshot::Keyframe""")
    green_x = property(_openshot.ColorShift_green_x_get, _openshot.ColorShift_green_x_set, doc=r"""green_x : openshot::Keyframe""")
    green_y = property(_openshot.ColorShift_green_y_get, _openshot.ColorShift_green_y_set, doc=r"""green_y : openshot::Keyframe""")
    blue_x = property(_openshot.ColorShift_blue_x_get, _openshot.ColorShift_blue_x_set, doc=r"""blue_x : openshot::Keyframe""")
    blue_y = property(_openshot.ColorShift_blue_y_get, _openshot.ColorShift_blue_y_set, doc=r"""blue_y : openshot::Keyframe""")
    alpha_x = property(_openshot.ColorShift_alpha_x_get, _openshot.ColorShift_alpha_x_set, doc=r"""alpha_x : openshot::Keyframe""")
    alpha_y = property(_openshot.ColorShift_alpha_y_get, _openshot.ColorShift_alpha_y_set, doc=r"""alpha_y : openshot::Keyframe""")

    def __init__(self, *args):
        r"""
        __init__(ColorShift self) -> ColorShift
        __init__(ColorShift self, Keyframe red_x, Keyframe red_y, Keyframe green_x, Keyframe green_y, Keyframe blue_x, Keyframe blue_y, Keyframe alpha_x, Keyframe alpha_y) -> ColorShift
        """
        _openshot.ColorShift_swiginit(self, _openshot.new_ColorShift(*args))

    def GetFrame(self, frame, frame_number):
        r"""GetFrame(ColorShift self, std::shared_ptr< openshot::Frame > frame, int64_t frame_number) -> std::shared_ptr< openshot::Frame >"""
        return _openshot.ColorShift_GetFrame(self, frame, frame_number)

    def Json(self):
        r"""Json(ColorShift self) -> std::string"""
        return _openshot.ColorShift_Json(self)

    def SetJson(self, value):
        r"""SetJson(ColorShift self, std::string value)"""
        return _openshot.ColorShift_SetJson(self, value)

    def JsonValue(self):
        r"""JsonValue(ColorShift self) -> Json::Value"""
        return _openshot.ColorShift_JsonValue(self)

    def SetJsonValue(self, root):
        r"""SetJsonValue(ColorShift self, Json::Value root)"""
        return _openshot.ColorShift_SetJsonValue(self, root)

    def PropertiesJSON(self, requested_frame):
        r"""PropertiesJSON(ColorShift self, int64_t requested_frame) -> std::string"""
        return _openshot.ColorShift_PropertiesJSON(self, requested_frame)
    __swig_destroy__ = _openshot.delete_ColorShift

# Register ColorShift in _openshot:
_openshot.ColorShift_swigregister(ColorShift)

class Crop(EffectBase):
    r"""Proxy of C++ openshot::Crop class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    color = property(_openshot.Crop_color_get, _openshot.Crop_color_set, doc=r"""color : openshot::Color""")
    left = property(_openshot.Crop_left_get, _openshot.Crop_left_set, doc=r"""left : openshot::Keyframe""")
    top = property(_openshot.Crop_top_get, _openshot.Crop_top_set, doc=r"""top : openshot::Keyframe""")
    right = property(_openshot.Crop_right_get, _openshot.Crop_right_set, doc=r"""right : openshot::Keyframe""")
    bottom = property(_openshot.Crop_bottom_get, _openshot.Crop_bottom_set, doc=r"""bottom : openshot::Keyframe""")

    def __init__(self, *args):
        r"""
        __init__(Crop self) -> Crop
        __init__(Crop self, Keyframe left, Keyframe top, Keyframe right, Keyframe bottom) -> Crop
        """
        _openshot.Crop_swiginit(self, _openshot.new_Crop(*args))

    def GetFrame(self, frame, frame_number):
        r"""GetFrame(Crop self, std::shared_ptr< openshot::Frame > frame, int64_t frame_number) -> std::shared_ptr< openshot::Frame >"""
        return _openshot.Crop_GetFrame(self, frame, frame_number)

    def Json(self):
        r"""Json(Crop self) -> std::string"""
        return _openshot.Crop_Json(self)

    def SetJson(self, value):
        r"""SetJson(Crop self, std::string value)"""
        return _openshot.Crop_SetJson(self, value)

    def JsonValue(self):
        r"""JsonValue(Crop self) -> Json::Value"""
        return _openshot.Crop_JsonValue(self)

    def SetJsonValue(self, root):
        r"""SetJsonValue(Crop self, Json::Value root)"""
        return _openshot.Crop_SetJsonValue(self, root)

    def PropertiesJSON(self, requested_frame):
        r"""PropertiesJSON(Crop self, int64_t requested_frame) -> std::string"""
        return _openshot.Crop_PropertiesJSON(self, requested_frame)
    __swig_destroy__ = _openshot.delete_Crop

# Register Crop in _openshot:
_openshot.Crop_swigregister(Crop)

class Deinterlace(EffectBase):
    r"""Proxy of C++ openshot::Deinterlace class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(Deinterlace self) -> Deinterlace
        __init__(Deinterlace self, bool isOdd) -> Deinterlace
        """
        _openshot.Deinterlace_swiginit(self, _openshot.new_Deinterlace(*args))

    def GetFrame(self, frame, frame_number):
        r"""GetFrame(Deinterlace self, std::shared_ptr< openshot::Frame > frame, int64_t frame_number) -> std::shared_ptr< openshot::Frame >"""
        return _openshot.Deinterlace_GetFrame(self, frame, frame_number)

    def Json(self):
        r"""Json(Deinterlace self) -> std::string"""
        return _openshot.Deinterlace_Json(self)

    def SetJson(self, value):
        r"""SetJson(Deinterlace self, std::string value)"""
        return _openshot.Deinterlace_SetJson(self, value)

    def JsonValue(self):
        r"""JsonValue(Deinterlace self) -> Json::Value"""
        return _openshot.Deinterlace_JsonValue(self)

    def SetJsonValue(self, root):
        r"""SetJsonValue(Deinterlace self, Json::Value root)"""
        return _openshot.Deinterlace_SetJsonValue(self, root)

    def PropertiesJSON(self, requested_frame):
        r"""PropertiesJSON(Deinterlace self, int64_t requested_frame) -> std::string"""
        return _openshot.Deinterlace_PropertiesJSON(self, requested_frame)
    __swig_destroy__ = _openshot.delete_Deinterlace

# Register Deinterlace in _openshot:
_openshot.Deinterlace_swigregister(Deinterlace)

class Hue(EffectBase):
    r"""Proxy of C++ openshot::Hue class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    hue = property(_openshot.Hue_hue_get, _openshot.Hue_hue_set, doc=r"""hue : openshot::Keyframe""")

    def __init__(self, *args):
        r"""
        __init__(Hue self) -> Hue
        __init__(Hue self, Keyframe hue) -> Hue
        """
        _openshot.Hue_swiginit(self, _openshot.new_Hue(*args))

    def GetFrame(self, frame, frame_number):
        r"""GetFrame(Hue self, std::shared_ptr< openshot::Frame > frame, int64_t frame_number) -> std::shared_ptr< openshot::Frame >"""
        return _openshot.Hue_GetFrame(self, frame, frame_number)

    def Json(self):
        r"""Json(Hue self) -> std::string"""
        return _openshot.Hue_Json(self)

    def SetJson(self, value):
        r"""SetJson(Hue self, std::string value)"""
        return _openshot.Hue_SetJson(self, value)

    def JsonValue(self):
        r"""JsonValue(Hue self) -> Json::Value"""
        return _openshot.Hue_JsonValue(self)

    def SetJsonValue(self, root):
        r"""SetJsonValue(Hue self, Json::Value root)"""
        return _openshot.Hue_SetJsonValue(self, root)

    def PropertiesJSON(self, requested_frame):
        r"""PropertiesJSON(Hue self, int64_t requested_frame) -> std::string"""
        return _openshot.Hue_PropertiesJSON(self, requested_frame)
    __swig_destroy__ = _openshot.delete_Hue

# Register Hue in _openshot:
_openshot.Hue_swigregister(Hue)

class Mask(EffectBase):
    r"""Proxy of C++ openshot::Mask class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    replace_image = property(_openshot.Mask_replace_image_get, _openshot.Mask_replace_image_set, doc=r"""replace_image : bool""")
    brightness = property(_openshot.Mask_brightness_get, _openshot.Mask_brightness_set, doc=r"""brightness : openshot::Keyframe""")
    contrast = property(_openshot.Mask_contrast_get, _openshot.Mask_contrast_set, doc=r"""contrast : openshot::Keyframe""")

    def __init__(self, *args):
        r"""
        __init__(Mask self) -> Mask
        __init__(Mask self, ReaderBase mask_reader, Keyframe mask_brightness, Keyframe mask_contrast) -> Mask
        """
        _openshot.Mask_swiginit(self, _openshot.new_Mask(*args))

    def GetFrame(self, frame, frame_number):
        r"""GetFrame(Mask self, std::shared_ptr< openshot::Frame > frame, int64_t frame_number) -> std::shared_ptr< openshot::Frame >"""
        return _openshot.Mask_GetFrame(self, frame, frame_number)

    def Json(self):
        r"""Json(Mask self) -> std::string"""
        return _openshot.Mask_Json(self)

    def SetJson(self, value):
        r"""SetJson(Mask self, std::string value)"""
        return _openshot.Mask_SetJson(self, value)

    def JsonValue(self):
        r"""JsonValue(Mask self) -> Json::Value"""
        return _openshot.Mask_JsonValue(self)

    def SetJsonValue(self, root):
        r"""SetJsonValue(Mask self, Json::Value root)"""
        return _openshot.Mask_SetJsonValue(self, root)

    def PropertiesJSON(self, requested_frame):
        r"""PropertiesJSON(Mask self, int64_t requested_frame) -> std::string"""
        return _openshot.Mask_PropertiesJSON(self, requested_frame)

    def Reader(self, *args):
        r"""
        Reader(Mask self) -> ReaderBase
        Reader(Mask self, ReaderBase new_reader)
        """
        return _openshot.Mask_Reader(self, *args)
    __swig_destroy__ = _openshot.delete_Mask

# Register Mask in _openshot:
_openshot.Mask_swigregister(Mask)

class Negate(EffectBase):
    r"""Proxy of C++ openshot::Negate class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""__init__(Negate self) -> Negate"""
        _openshot.Negate_swiginit(self, _openshot.new_Negate())

    def GetFrame(self, frame, frame_number):
        r"""GetFrame(Negate self, std::shared_ptr< openshot::Frame > frame, int64_t frame_number) -> std::shared_ptr< openshot::Frame >"""
        return _openshot.Negate_GetFrame(self, frame, frame_number)

    def Json(self):
        r"""Json(Negate self) -> std::string"""
        return _openshot.Negate_Json(self)

    def SetJson(self, value):
        r"""SetJson(Negate self, std::string value)"""
        return _openshot.Negate_SetJson(self, value)

    def JsonValue(self):
        r"""JsonValue(Negate self) -> Json::Value"""
        return _openshot.Negate_JsonValue(self)

    def SetJsonValue(self, root):
        r"""SetJsonValue(Negate self, Json::Value root)"""
        return _openshot.Negate_SetJsonValue(self, root)

    def PropertiesJSON(self, requested_frame):
        r"""PropertiesJSON(Negate self, int64_t requested_frame) -> std::string"""
        return _openshot.Negate_PropertiesJSON(self, requested_frame)
    __swig_destroy__ = _openshot.delete_Negate

# Register Negate in _openshot:
_openshot.Negate_swigregister(Negate)

class Pixelate(EffectBase):
    r"""Proxy of C++ openshot::Pixelate class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    pixelization = property(_openshot.Pixelate_pixelization_get, _openshot.Pixelate_pixelization_set, doc=r"""pixelization : openshot::Keyframe""")
    left = property(_openshot.Pixelate_left_get, _openshot.Pixelate_left_set, doc=r"""left : openshot::Keyframe""")
    top = property(_openshot.Pixelate_top_get, _openshot.Pixelate_top_set, doc=r"""top : openshot::Keyframe""")
    right = property(_openshot.Pixelate_right_get, _openshot.Pixelate_right_set, doc=r"""right : openshot::Keyframe""")
    bottom = property(_openshot.Pixelate_bottom_get, _openshot.Pixelate_bottom_set, doc=r"""bottom : openshot::Keyframe""")

    def __init__(self, *args):
        r"""
        __init__(Pixelate self) -> Pixelate
        __init__(Pixelate self, Keyframe pixelization, Keyframe left, Keyframe top, Keyframe right, Keyframe bottom) -> Pixelate
        """
        _openshot.Pixelate_swiginit(self, _openshot.new_Pixelate(*args))

    def GetFrame(self, frame, frame_number):
        r"""GetFrame(Pixelate self, std::shared_ptr< openshot::Frame > frame, int64_t frame_number) -> std::shared_ptr< openshot::Frame >"""
        return _openshot.Pixelate_GetFrame(self, frame, frame_number)

    def Json(self):
        r"""Json(Pixelate self) -> std::string"""
        return _openshot.Pixelate_Json(self)

    def SetJson(self, value):
        r"""SetJson(Pixelate self, std::string value)"""
        return _openshot.Pixelate_SetJson(self, value)

    def JsonValue(self):
        r"""JsonValue(Pixelate self) -> Json::Value"""
        return _openshot.Pixelate_JsonValue(self)

    def SetJsonValue(self, root):
        r"""SetJsonValue(Pixelate self, Json::Value root)"""
        return _openshot.Pixelate_SetJsonValue(self, root)

    def PropertiesJSON(self, requested_frame):
        r"""PropertiesJSON(Pixelate self, int64_t requested_frame) -> std::string"""
        return _openshot.Pixelate_PropertiesJSON(self, requested_frame)
    __swig_destroy__ = _openshot.delete_Pixelate

# Register Pixelate in _openshot:
_openshot.Pixelate_swigregister(Pixelate)

class Saturation(EffectBase):
    r"""Proxy of C++ openshot::Saturation class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    saturation = property(_openshot.Saturation_saturation_get, _openshot.Saturation_saturation_set, doc=r"""saturation : openshot::Keyframe""")

    def __init__(self, *args):
        r"""
        __init__(Saturation self) -> Saturation
        __init__(Saturation self, Keyframe new_saturation) -> Saturation
        """
        _openshot.Saturation_swiginit(self, _openshot.new_Saturation(*args))

    def GetFrame(self, frame, frame_number):
        r"""GetFrame(Saturation self, std::shared_ptr< openshot::Frame > frame, int64_t frame_number) -> std::shared_ptr< openshot::Frame >"""
        return _openshot.Saturation_GetFrame(self, frame, frame_number)

    def Json(self):
        r"""Json(Saturation self) -> std::string"""
        return _openshot.Saturation_Json(self)

    def SetJson(self, value):
        r"""SetJson(Saturation self, std::string value)"""
        return _openshot.Saturation_SetJson(self, value)

    def JsonValue(self):
        r"""JsonValue(Saturation self) -> Json::Value"""
        return _openshot.Saturation_JsonValue(self)

    def SetJsonValue(self, root):
        r"""SetJsonValue(Saturation self, Json::Value root)"""
        return _openshot.Saturation_SetJsonValue(self, root)

    def PropertiesJSON(self, requested_frame):
        r"""PropertiesJSON(Saturation self, int64_t requested_frame) -> std::string"""
        return _openshot.Saturation_PropertiesJSON(self, requested_frame)
    __swig_destroy__ = _openshot.delete_Saturation

# Register Saturation in _openshot:
_openshot.Saturation_swigregister(Saturation)

class Shift(EffectBase):
    r"""Proxy of C++ openshot::Shift class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    x = property(_openshot.Shift_x_get, _openshot.Shift_x_set, doc=r"""x : openshot::Keyframe""")
    y = property(_openshot.Shift_y_get, _openshot.Shift_y_set, doc=r"""y : openshot::Keyframe""")

    def __init__(self, *args):
        r"""
        __init__(Shift self) -> Shift
        __init__(Shift self, Keyframe x, Keyframe y) -> Shift
        """
        _openshot.Shift_swiginit(self, _openshot.new_Shift(*args))

    def GetFrame(self, frame, frame_number):
        r"""GetFrame(Shift self, std::shared_ptr< openshot::Frame > frame, int64_t frame_number) -> std::shared_ptr< openshot::Frame >"""
        return _openshot.Shift_GetFrame(self, frame, frame_number)

    def Json(self):
        r"""Json(Shift self) -> std::string"""
        return _openshot.Shift_Json(self)

    def SetJson(self, value):
        r"""SetJson(Shift self, std::string value)"""
        return _openshot.Shift_SetJson(self, value)

    def JsonValue(self):
        r"""JsonValue(Shift self) -> Json::Value"""
        return _openshot.Shift_JsonValue(self)

    def SetJsonValue(self, root):
        r"""SetJsonValue(Shift self, Json::Value root)"""
        return _openshot.Shift_SetJsonValue(self, root)

    def PropertiesJSON(self, requested_frame):
        r"""PropertiesJSON(Shift self, int64_t requested_frame) -> std::string"""
        return _openshot.Shift_PropertiesJSON(self, requested_frame)
    __swig_destroy__ = _openshot.delete_Shift

# Register Shift in _openshot:
_openshot.Shift_swigregister(Shift)

class Wave(EffectBase):
    r"""Proxy of C++ openshot::Wave class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    wavelength = property(_openshot.Wave_wavelength_get, _openshot.Wave_wavelength_set, doc=r"""wavelength : openshot::Keyframe""")
    amplitude = property(_openshot.Wave_amplitude_get, _openshot.Wave_amplitude_set, doc=r"""amplitude : openshot::Keyframe""")
    multiplier = property(_openshot.Wave_multiplier_get, _openshot.Wave_multiplier_set, doc=r"""multiplier : openshot::Keyframe""")
    shift_x = property(_openshot.Wave_shift_x_get, _openshot.Wave_shift_x_set, doc=r"""shift_x : openshot::Keyframe""")
    speed_y = property(_openshot.Wave_speed_y_get, _openshot.Wave_speed_y_set, doc=r"""speed_y : openshot::Keyframe""")

    def __init__(self, *args):
        r"""
        __init__(Wave self) -> Wave
        __init__(Wave self, Keyframe wavelength, Keyframe amplitude, Keyframe multiplier, Keyframe shift_x, Keyframe speed_y) -> Wave
        """
        _openshot.Wave_swiginit(self, _openshot.new_Wave(*args))

    def GetFrame(self, frame, frame_number):
        r"""GetFrame(Wave self, std::shared_ptr< openshot::Frame > frame, int64_t frame_number) -> std::shared_ptr< openshot::Frame >"""
        return _openshot.Wave_GetFrame(self, frame, frame_number)

    def Json(self):
        r"""Json(Wave self) -> std::string"""
        return _openshot.Wave_Json(self)

    def SetJson(self, value):
        r"""SetJson(Wave self, std::string value)"""
        return _openshot.Wave_SetJson(self, value)

    def JsonValue(self):
        r"""JsonValue(Wave self) -> Json::Value"""
        return _openshot.Wave_JsonValue(self)

    def SetJsonValue(self, root):
        r"""SetJsonValue(Wave self, Json::Value root)"""
        return _openshot.Wave_SetJsonValue(self, root)

    def PropertiesJSON(self, requested_frame):
        r"""PropertiesJSON(Wave self, int64_t requested_frame) -> std::string"""
        return _openshot.Wave_PropertiesJSON(self, requested_frame)
    __swig_destroy__ = _openshot.delete_Wave

# Register Wave in _openshot:
_openshot.Wave_swigregister(Wave)

class ClipList(object):
    r"""Proxy of C++ std::list< openshot::Clip * > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        r"""iterator(ClipList self) -> SwigPyIterator"""
        return _openshot.ClipList_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        r"""__nonzero__(ClipList self) -> bool"""
        return _openshot.ClipList___nonzero__(self)

    def __bool__(self):
        r"""__bool__(ClipList self) -> bool"""
        return _openshot.ClipList___bool__(self)

    def __len__(self):
        r"""__len__(ClipList self) -> std::list< openshot::Clip * >::size_type"""
        return _openshot.ClipList___len__(self)

    def __getslice__(self, i, j):
        r"""__getslice__(ClipList self, std::list< openshot::Clip * >::difference_type i, std::list< openshot::Clip * >::difference_type j) -> ClipList"""
        return _openshot.ClipList___getslice__(self, i, j)

    def __setslice__(self, *args):
        r"""
        __setslice__(ClipList self, std::list< openshot::Clip * >::difference_type i, std::list< openshot::Clip * >::difference_type j)
        __setslice__(ClipList self, std::list< openshot::Clip * >::difference_type i, std::list< openshot::Clip * >::difference_type j, ClipList v)
        """
        return _openshot.ClipList___setslice__(self, *args)

    def __delslice__(self, i, j):
        r"""__delslice__(ClipList self, std::list< openshot::Clip * >::difference_type i, std::list< openshot::Clip * >::difference_type j)"""
        return _openshot.ClipList___delslice__(self, i, j)

    def __delitem__(self, *args):
        r"""
        __delitem__(ClipList self, std::list< openshot::Clip * >::difference_type i)
        __delitem__(ClipList self, PySliceObject * slice)
        """
        return _openshot.ClipList___delitem__(self, *args)

    def __getitem__(self, *args):
        r"""
        __getitem__(ClipList self, PySliceObject * slice) -> ClipList
        __getitem__(ClipList self, std::list< openshot::Clip * >::difference_type i) -> Clip
        """
        return _openshot.ClipList___getitem__(self, *args)

    def __setitem__(self, *args):
        r"""
        __setitem__(ClipList self, PySliceObject * slice, ClipList v)
        __setitem__(ClipList self, PySliceObject * slice)
        __setitem__(ClipList self, std::list< openshot::Clip * >::difference_type i, Clip x)
        """
        return _openshot.ClipList___setitem__(self, *args)

    def pop(self):
        r"""pop(ClipList self) -> Clip"""
        return _openshot.ClipList_pop(self)

    def append(self, x):
        r"""append(ClipList self, Clip x)"""
        return _openshot.ClipList_append(self, x)

    def empty(self):
        r"""empty(ClipList self) -> bool"""
        return _openshot.ClipList_empty(self)

    def size(self):
        r"""size(ClipList self) -> std::list< openshot::Clip * >::size_type"""
        return _openshot.ClipList_size(self)

    def swap(self, v):
        r"""swap(ClipList self, ClipList v)"""
        return _openshot.ClipList_swap(self, v)

    def begin(self):
        r"""begin(ClipList self) -> std::list< openshot::Clip * >::iterator"""
        return _openshot.ClipList_begin(self)

    def end(self):
        r"""end(ClipList self) -> std::list< openshot::Clip * >::iterator"""
        return _openshot.ClipList_end(self)

    def rbegin(self):
        r"""rbegin(ClipList self) -> std::list< openshot::Clip * >::reverse_iterator"""
        return _openshot.ClipList_rbegin(self)

    def rend(self):
        r"""rend(ClipList self) -> std::list< openshot::Clip * >::reverse_iterator"""
        return _openshot.ClipList_rend(self)

    def clear(self):
        r"""clear(ClipList self)"""
        return _openshot.ClipList_clear(self)

    def get_allocator(self):
        r"""get_allocator(ClipList self) -> std::list< openshot::Clip * >::allocator_type"""
        return _openshot.ClipList_get_allocator(self)

    def pop_back(self):
        r"""pop_back(ClipList self)"""
        return _openshot.ClipList_pop_back(self)

    def erase(self, *args):
        r"""
        erase(ClipList self, std::list< openshot::Clip * >::iterator pos) -> std::list< openshot::Clip * >::iterator
        erase(ClipList self, std::list< openshot::Clip * >::iterator first, std::list< openshot::Clip * >::iterator last) -> std::list< openshot::Clip * >::iterator
        """
        return _openshot.ClipList_erase(self, *args)

    def __init__(self, *args):
        r"""
        __init__(ClipList self) -> ClipList
        __init__(ClipList self, ClipList other) -> ClipList
        __init__(ClipList self, std::list< openshot::Clip * >::size_type size) -> ClipList
        __init__(ClipList self, std::list< openshot::Clip * >::size_type size, Clip value) -> ClipList
        """
        _openshot.ClipList_swiginit(self, _openshot.new_ClipList(*args))

    def push_back(self, x):
        r"""push_back(ClipList self, Clip x)"""
        return _openshot.ClipList_push_back(self, x)

    def front(self):
        r"""front(ClipList self) -> Clip"""
        return _openshot.ClipList_front(self)

    def back(self):
        r"""back(ClipList self) -> Clip"""
        return _openshot.ClipList_back(self)

    def assign(self, n, x):
        r"""assign(ClipList self, std::list< openshot::Clip * >::size_type n, Clip x)"""
        return _openshot.ClipList_assign(self, n, x)

    def resize(self, *args):
        r"""
        resize(ClipList self, std::list< openshot::Clip * >::size_type new_size)
        resize(ClipList self, std::list< openshot::Clip * >::size_type new_size, Clip x)
        """
        return _openshot.ClipList_resize(self, *args)

    def insert(self, *args):
        r"""
        insert(ClipList self, std::list< openshot::Clip * >::iterator pos, Clip x) -> std::list< openshot::Clip * >::iterator
        insert(ClipList self, std::list< openshot::Clip * >::iterator pos, std::list< openshot::Clip * >::size_type n, Clip x)
        """
        return _openshot.ClipList_insert(self, *args)

    def pop_front(self):
        r"""pop_front(ClipList self)"""
        return _openshot.ClipList_pop_front(self)

    def push_front(self, x):
        r"""push_front(ClipList self, Clip x)"""
        return _openshot.ClipList_push_front(self, x)

    def remove(self, x):
        r"""remove(ClipList self, Clip x)"""
        return _openshot.ClipList_remove(self, x)

    def unique(self):
        r"""unique(ClipList self)"""
        return _openshot.ClipList_unique(self)

    def reverse(self):
        r"""reverse(ClipList self)"""
        return _openshot.ClipList_reverse(self)

    def sort(self):
        r"""sort(ClipList self)"""
        return _openshot.ClipList_sort(self)

    def merge(self, x):
        r"""merge(ClipList self, ClipList x)"""
        return _openshot.ClipList_merge(self, x)
    __swig_destroy__ = _openshot.delete_ClipList

# Register ClipList in _openshot:
_openshot.ClipList_swigregister(ClipList)

class EffectBaseList(object):
    r"""Proxy of C++ std::list< openshot::EffectBase * > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        r"""iterator(EffectBaseList self) -> SwigPyIterator"""
        return _openshot.EffectBaseList_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        r"""__nonzero__(EffectBaseList self) -> bool"""
        return _openshot.EffectBaseList___nonzero__(self)

    def __bool__(self):
        r"""__bool__(EffectBaseList self) -> bool"""
        return _openshot.EffectBaseList___bool__(self)

    def __len__(self):
        r"""__len__(EffectBaseList self) -> std::list< openshot::EffectBase * >::size_type"""
        return _openshot.EffectBaseList___len__(self)

    def __getslice__(self, i, j):
        r"""__getslice__(EffectBaseList self, std::list< openshot::EffectBase * >::difference_type i, std::list< openshot::EffectBase * >::difference_type j) -> EffectBaseList"""
        return _openshot.EffectBaseList___getslice__(self, i, j)

    def __setslice__(self, *args):
        r"""
        __setslice__(EffectBaseList self, std::list< openshot::EffectBase * >::difference_type i, std::list< openshot::EffectBase * >::difference_type j)
        __setslice__(EffectBaseList self, std::list< openshot::EffectBase * >::difference_type i, std::list< openshot::EffectBase * >::difference_type j, EffectBaseList v)
        """
        return _openshot.EffectBaseList___setslice__(self, *args)

    def __delslice__(self, i, j):
        r"""__delslice__(EffectBaseList self, std::list< openshot::EffectBase * >::difference_type i, std::list< openshot::EffectBase * >::difference_type j)"""
        return _openshot.EffectBaseList___delslice__(self, i, j)

    def __delitem__(self, *args):
        r"""
        __delitem__(EffectBaseList self, std::list< openshot::EffectBase * >::difference_type i)
        __delitem__(EffectBaseList self, PySliceObject * slice)
        """
        return _openshot.EffectBaseList___delitem__(self, *args)

    def __getitem__(self, *args):
        r"""
        __getitem__(EffectBaseList self, PySliceObject * slice) -> EffectBaseList
        __getitem__(EffectBaseList self, std::list< openshot::EffectBase * >::difference_type i) -> EffectBase
        """
        return _openshot.EffectBaseList___getitem__(self, *args)

    def __setitem__(self, *args):
        r"""
        __setitem__(EffectBaseList self, PySliceObject * slice, EffectBaseList v)
        __setitem__(EffectBaseList self, PySliceObject * slice)
        __setitem__(EffectBaseList self, std::list< openshot::EffectBase * >::difference_type i, EffectBase x)
        """
        return _openshot.EffectBaseList___setitem__(self, *args)

    def pop(self):
        r"""pop(EffectBaseList self) -> EffectBase"""
        return _openshot.EffectBaseList_pop(self)

    def append(self, x):
        r"""append(EffectBaseList self, EffectBase x)"""
        return _openshot.EffectBaseList_append(self, x)

    def empty(self):
        r"""empty(EffectBaseList self) -> bool"""
        return _openshot.EffectBaseList_empty(self)

    def size(self):
        r"""size(EffectBaseList self) -> std::list< openshot::EffectBase * >::size_type"""
        return _openshot.EffectBaseList_size(self)

    def swap(self, v):
        r"""swap(EffectBaseList self, EffectBaseList v)"""
        return _openshot.EffectBaseList_swap(self, v)

    def begin(self):
        r"""begin(EffectBaseList self) -> std::list< openshot::EffectBase * >::iterator"""
        return _openshot.EffectBaseList_begin(self)

    def end(self):
        r"""end(EffectBaseList self) -> std::list< openshot::EffectBase * >::iterator"""
        return _openshot.EffectBaseList_end(self)

    def rbegin(self):
        r"""rbegin(EffectBaseList self) -> std::list< openshot::EffectBase * >::reverse_iterator"""
        return _openshot.EffectBaseList_rbegin(self)

    def rend(self):
        r"""rend(EffectBaseList self) -> std::list< openshot::EffectBase * >::reverse_iterator"""
        return _openshot.EffectBaseList_rend(self)

    def clear(self):
        r"""clear(EffectBaseList self)"""
        return _openshot.EffectBaseList_clear(self)

    def get_allocator(self):
        r"""get_allocator(EffectBaseList self) -> std::list< openshot::EffectBase * >::allocator_type"""
        return _openshot.EffectBaseList_get_allocator(self)

    def pop_back(self):
        r"""pop_back(EffectBaseList self)"""
        return _openshot.EffectBaseList_pop_back(self)

    def erase(self, *args):
        r"""
        erase(EffectBaseList self, std::list< openshot::EffectBase * >::iterator pos) -> std::list< openshot::EffectBase * >::iterator
        erase(EffectBaseList self, std::list< openshot::EffectBase * >::iterator first, std::list< openshot::EffectBase * >::iterator last) -> std::list< openshot::EffectBase * >::iterator
        """
        return _openshot.EffectBaseList_erase(self, *args)

    def __init__(self, *args):
        r"""
        __init__(EffectBaseList self) -> EffectBaseList
        __init__(EffectBaseList self, EffectBaseList other) -> EffectBaseList
        __init__(EffectBaseList self, std::list< openshot::EffectBase * >::size_type size) -> EffectBaseList
        __init__(EffectBaseList self, std::list< openshot::EffectBase * >::size_type size, EffectBase value) -> EffectBaseList
        """
        _openshot.EffectBaseList_swiginit(self, _openshot.new_EffectBaseList(*args))

    def push_back(self, x):
        r"""push_back(EffectBaseList self, EffectBase x)"""
        return _openshot.EffectBaseList_push_back(self, x)

    def front(self):
        r"""front(EffectBaseList self) -> EffectBase"""
        return _openshot.EffectBaseList_front(self)

    def back(self):
        r"""back(EffectBaseList self) -> EffectBase"""
        return _openshot.EffectBaseList_back(self)

    def assign(self, n, x):
        r"""assign(EffectBaseList self, std::list< openshot::EffectBase * >::size_type n, EffectBase x)"""
        return _openshot.EffectBaseList_assign(self, n, x)

    def resize(self, *args):
        r"""
        resize(EffectBaseList self, std::list< openshot::EffectBase * >::size_type new_size)
        resize(EffectBaseList self, std::list< openshot::EffectBase * >::size_type new_size, EffectBase x)
        """
        return _openshot.EffectBaseList_resize(self, *args)

    def insert(self, *args):
        r"""
        insert(EffectBaseList self, std::list< openshot::EffectBase * >::iterator pos, EffectBase x) -> std::list< openshot::EffectBase * >::iterator
        insert(EffectBaseList self, std::list< openshot::EffectBase * >::iterator pos, std::list< openshot::EffectBase * >::size_type n, EffectBase x)
        """
        return _openshot.EffectBaseList_insert(self, *args)

    def pop_front(self):
        r"""pop_front(EffectBaseList self)"""
        return _openshot.EffectBaseList_pop_front(self)

    def push_front(self, x):
        r"""push_front(EffectBaseList self, EffectBase x)"""
        return _openshot.EffectBaseList_push_front(self, x)

    def remove(self, x):
        r"""remove(EffectBaseList self, EffectBase x)"""
        return _openshot.EffectBaseList_remove(self, x)

    def unique(self):
        r"""unique(EffectBaseList self)"""
        return _openshot.EffectBaseList_unique(self)

    def reverse(self):
        r"""reverse(EffectBaseList self)"""
        return _openshot.EffectBaseList_reverse(self)

    def sort(self):
        r"""sort(EffectBaseList self)"""
        return _openshot.EffectBaseList_sort(self)

    def merge(self, x):
        r"""merge(EffectBaseList self, EffectBaseList x)"""
        return _openshot.EffectBaseList_merge(self, x)
    __swig_destroy__ = _openshot.delete_EffectBaseList

# Register EffectBaseList in _openshot:
_openshot.EffectBaseList_swigregister(EffectBaseList)

class CoordinateVector(object):
    r"""Proxy of C++ std::vector< openshot::Coordinate > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        r"""iterator(CoordinateVector self) -> SwigPyIterator"""
        return _openshot.CoordinateVector_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        r"""__nonzero__(CoordinateVector self) -> bool"""
        return _openshot.CoordinateVector___nonzero__(self)

    def __bool__(self):
        r"""__bool__(CoordinateVector self) -> bool"""
        return _openshot.CoordinateVector___bool__(self)

    def __len__(self):
        r"""__len__(CoordinateVector self) -> std::vector< openshot::Coordinate >::size_type"""
        return _openshot.CoordinateVector___len__(self)

    def __getslice__(self, i, j):
        r"""__getslice__(CoordinateVector self, std::vector< openshot::Coordinate >::difference_type i, std::vector< openshot::Coordinate >::difference_type j) -> CoordinateVector"""
        return _openshot.CoordinateVector___getslice__(self, i, j)

    def __setslice__(self, *args):
        r"""
        __setslice__(CoordinateVector self, std::vector< openshot::Coordinate >::difference_type i, std::vector< openshot::Coordinate >::difference_type j)
        __setslice__(CoordinateVector self, std::vector< openshot::Coordinate >::difference_type i, std::vector< openshot::Coordinate >::difference_type j, CoordinateVector v)
        """
        return _openshot.CoordinateVector___setslice__(self, *args)

    def __delslice__(self, i, j):
        r"""__delslice__(CoordinateVector self, std::vector< openshot::Coordinate >::difference_type i, std::vector< openshot::Coordinate >::difference_type j)"""
        return _openshot.CoordinateVector___delslice__(self, i, j)

    def __delitem__(self, *args):
        r"""
        __delitem__(CoordinateVector self, std::vector< openshot::Coordinate >::difference_type i)
        __delitem__(CoordinateVector self, PySliceObject * slice)
        """
        return _openshot.CoordinateVector___delitem__(self, *args)

    def __getitem__(self, *args):
        r"""
        __getitem__(CoordinateVector self, PySliceObject * slice) -> CoordinateVector
        __getitem__(CoordinateVector self, std::vector< openshot::Coordinate >::difference_type i) -> Coordinate
        """
        return _openshot.CoordinateVector___getitem__(self, *args)

    def __setitem__(self, *args):
        r"""
        __setitem__(CoordinateVector self, PySliceObject * slice, CoordinateVector v)
        __setitem__(CoordinateVector self, PySliceObject * slice)
        __setitem__(CoordinateVector self, std::vector< openshot::Coordinate >::difference_type i, Coordinate x)
        """
        return _openshot.CoordinateVector___setitem__(self, *args)

    def pop(self):
        r"""pop(CoordinateVector self) -> Coordinate"""
        return _openshot.CoordinateVector_pop(self)

    def append(self, x):
        r"""append(CoordinateVector self, Coordinate x)"""
        return _openshot.CoordinateVector_append(self, x)

    def empty(self):
        r"""empty(CoordinateVector self) -> bool"""
        return _openshot.CoordinateVector_empty(self)

    def size(self):
        r"""size(CoordinateVector self) -> std::vector< openshot::Coordinate >::size_type"""
        return _openshot.CoordinateVector_size(self)

    def swap(self, v):
        r"""swap(CoordinateVector self, CoordinateVector v)"""
        return _openshot.CoordinateVector_swap(self, v)

    def begin(self):
        r"""begin(CoordinateVector self) -> std::vector< openshot::Coordinate >::iterator"""
        return _openshot.CoordinateVector_begin(self)

    def end(self):
        r"""end(CoordinateVector self) -> std::vector< openshot::Coordinate >::iterator"""
        return _openshot.CoordinateVector_end(self)

    def rbegin(self):
        r"""rbegin(CoordinateVector self) -> std::vector< openshot::Coordinate >::reverse_iterator"""
        return _openshot.CoordinateVector_rbegin(self)

    def rend(self):
        r"""rend(CoordinateVector self) -> std::vector< openshot::Coordinate >::reverse_iterator"""
        return _openshot.CoordinateVector_rend(self)

    def clear(self):
        r"""clear(CoordinateVector self)"""
        return _openshot.CoordinateVector_clear(self)

    def get_allocator(self):
        r"""get_allocator(CoordinateVector self) -> std::vector< openshot::Coordinate >::allocator_type"""
        return _openshot.CoordinateVector_get_allocator(self)

    def pop_back(self):
        r"""pop_back(CoordinateVector self)"""
        return _openshot.CoordinateVector_pop_back(self)

    def erase(self, *args):
        r"""
        erase(CoordinateVector self, std::vector< openshot::Coordinate >::iterator pos) -> std::vector< openshot::Coordinate >::iterator
        erase(CoordinateVector self, std::vector< openshot::Coordinate >::iterator first, std::vector< openshot::Coordinate >::iterator last) -> std::vector< openshot::Coordinate >::iterator
        """
        return _openshot.CoordinateVector_erase(self, *args)

    def __init__(self, *args):
        r"""
        __init__(CoordinateVector self) -> CoordinateVector
        __init__(CoordinateVector self, CoordinateVector other) -> CoordinateVector
        __init__(CoordinateVector self, std::vector< openshot::Coordinate >::size_type size) -> CoordinateVector
        __init__(CoordinateVector self, std::vector< openshot::Coordinate >::size_type size, Coordinate value) -> CoordinateVector
        """
        _openshot.CoordinateVector_swiginit(self, _openshot.new_CoordinateVector(*args))

    def push_back(self, x):
        r"""push_back(CoordinateVector self, Coordinate x)"""
        return _openshot.CoordinateVector_push_back(self, x)

    def front(self):
        r"""front(CoordinateVector self) -> Coordinate"""
        return _openshot.CoordinateVector_front(self)

    def back(self):
        r"""back(CoordinateVector self) -> Coordinate"""
        return _openshot.CoordinateVector_back(self)

    def assign(self, n, x):
        r"""assign(CoordinateVector self, std::vector< openshot::Coordinate >::size_type n, Coordinate x)"""
        return _openshot.CoordinateVector_assign(self, n, x)

    def resize(self, *args):
        r"""
        resize(CoordinateVector self, std::vector< openshot::Coordinate >::size_type new_size)
        resize(CoordinateVector self, std::vector< openshot::Coordinate >::size_type new_size, Coordinate x)
        """
        return _openshot.CoordinateVector_resize(self, *args)

    def insert(self, *args):
        r"""
        insert(CoordinateVector self, std::vector< openshot::Coordinate >::iterator pos, Coordinate x) -> std::vector< openshot::Coordinate >::iterator
        insert(CoordinateVector self, std::vector< openshot::Coordinate >::iterator pos, std::vector< openshot::Coordinate >::size_type n, Coordinate x)
        """
        return _openshot.CoordinateVector_insert(self, *args)

    def reserve(self, n):
        r"""reserve(CoordinateVector self, std::vector< openshot::Coordinate >::size_type n)"""
        return _openshot.CoordinateVector_reserve(self, n)

    def capacity(self):
        r"""capacity(CoordinateVector self) -> std::vector< openshot::Coordinate >::size_type"""
        return _openshot.CoordinateVector_capacity(self)
    __swig_destroy__ = _openshot.delete_CoordinateVector

# Register CoordinateVector in _openshot:
_openshot.CoordinateVector_swigregister(CoordinateVector)

class PointsVector(object):
    r"""Proxy of C++ std::vector< openshot::Point > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        r"""iterator(PointsVector self) -> SwigPyIterator"""
        return _openshot.PointsVector_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        r"""__nonzero__(PointsVector self) -> bool"""
        return _openshot.PointsVector___nonzero__(self)

    def __bool__(self):
        r"""__bool__(PointsVector self) -> bool"""
        return _openshot.PointsVector___bool__(self)

    def __len__(self):
        r"""__len__(PointsVector self) -> std::vector< openshot::Point >::size_type"""
        return _openshot.PointsVector___len__(self)

    def __getslice__(self, i, j):
        r"""__getslice__(PointsVector self, std::vector< openshot::Point >::difference_type i, std::vector< openshot::Point >::difference_type j) -> PointsVector"""
        return _openshot.PointsVector___getslice__(self, i, j)

    def __setslice__(self, *args):
        r"""
        __setslice__(PointsVector self, std::vector< openshot::Point >::difference_type i, std::vector< openshot::Point >::difference_type j)
        __setslice__(PointsVector self, std::vector< openshot::Point >::difference_type i, std::vector< openshot::Point >::difference_type j, PointsVector v)
        """
        return _openshot.PointsVector___setslice__(self, *args)

    def __delslice__(self, i, j):
        r"""__delslice__(PointsVector self, std::vector< openshot::Point >::difference_type i, std::vector< openshot::Point >::difference_type j)"""
        return _openshot.PointsVector___delslice__(self, i, j)

    def __delitem__(self, *args):
        r"""
        __delitem__(PointsVector self, std::vector< openshot::Point >::difference_type i)
        __delitem__(PointsVector self, PySliceObject * slice)
        """
        return _openshot.PointsVector___delitem__(self, *args)

    def __getitem__(self, *args):
        r"""
        __getitem__(PointsVector self, PySliceObject * slice) -> PointsVector
        __getitem__(PointsVector self, std::vector< openshot::Point >::difference_type i) -> Point
        """
        return _openshot.PointsVector___getitem__(self, *args)

    def __setitem__(self, *args):
        r"""
        __setitem__(PointsVector self, PySliceObject * slice, PointsVector v)
        __setitem__(PointsVector self, PySliceObject * slice)
        __setitem__(PointsVector self, std::vector< openshot::Point >::difference_type i, Point x)
        """
        return _openshot.PointsVector___setitem__(self, *args)

    def pop(self):
        r"""pop(PointsVector self) -> Point"""
        return _openshot.PointsVector_pop(self)

    def append(self, x):
        r"""append(PointsVector self, Point x)"""
        return _openshot.PointsVector_append(self, x)

    def empty(self):
        r"""empty(PointsVector self) -> bool"""
        return _openshot.PointsVector_empty(self)

    def size(self):
        r"""size(PointsVector self) -> std::vector< openshot::Point >::size_type"""
        return _openshot.PointsVector_size(self)

    def swap(self, v):
        r"""swap(PointsVector self, PointsVector v)"""
        return _openshot.PointsVector_swap(self, v)

    def begin(self):
        r"""begin(PointsVector self) -> std::vector< openshot::Point >::iterator"""
        return _openshot.PointsVector_begin(self)

    def end(self):
        r"""end(PointsVector self) -> std::vector< openshot::Point >::iterator"""
        return _openshot.PointsVector_end(self)

    def rbegin(self):
        r"""rbegin(PointsVector self) -> std::vector< openshot::Point >::reverse_iterator"""
        return _openshot.PointsVector_rbegin(self)

    def rend(self):
        r"""rend(PointsVector self) -> std::vector< openshot::Point >::reverse_iterator"""
        return _openshot.PointsVector_rend(self)

    def clear(self):
        r"""clear(PointsVector self)"""
        return _openshot.PointsVector_clear(self)

    def get_allocator(self):
        r"""get_allocator(PointsVector self) -> std::vector< openshot::Point >::allocator_type"""
        return _openshot.PointsVector_get_allocator(self)

    def pop_back(self):
        r"""pop_back(PointsVector self)"""
        return _openshot.PointsVector_pop_back(self)

    def erase(self, *args):
        r"""
        erase(PointsVector self, std::vector< openshot::Point >::iterator pos) -> std::vector< openshot::Point >::iterator
        erase(PointsVector self, std::vector< openshot::Point >::iterator first, std::vector< openshot::Point >::iterator last) -> std::vector< openshot::Point >::iterator
        """
        return _openshot.PointsVector_erase(self, *args)

    def __init__(self, *args):
        r"""
        __init__(PointsVector self) -> PointsVector
        __init__(PointsVector self, PointsVector other) -> PointsVector
        __init__(PointsVector self, std::vector< openshot::Point >::size_type size) -> PointsVector
        __init__(PointsVector self, std::vector< openshot::Point >::size_type size, Point value) -> PointsVector
        """
        _openshot.PointsVector_swiginit(self, _openshot.new_PointsVector(*args))

    def push_back(self, x):
        r"""push_back(PointsVector self, Point x)"""
        return _openshot.PointsVector_push_back(self, x)

    def front(self):
        r"""front(PointsVector self) -> Point"""
        return _openshot.PointsVector_front(self)

    def back(self):
        r"""back(PointsVector self) -> Point"""
        return _openshot.PointsVector_back(self)

    def assign(self, n, x):
        r"""assign(PointsVector self, std::vector< openshot::Point >::size_type n, Point x)"""
        return _openshot.PointsVector_assign(self, n, x)

    def resize(self, *args):
        r"""
        resize(PointsVector self, std::vector< openshot::Point >::size_type new_size)
        resize(PointsVector self, std::vector< openshot::Point >::size_type new_size, Point x)
        """
        return _openshot.PointsVector_resize(self, *args)

    def insert(self, *args):
        r"""
        insert(PointsVector self, std::vector< openshot::Point >::iterator pos, Point x) -> std::vector< openshot::Point >::iterator
        insert(PointsVector self, std::vector< openshot::Point >::iterator pos, std::vector< openshot::Point >::size_type n, Point x)
        """
        return _openshot.PointsVector_insert(self, *args)

    def reserve(self, n):
        r"""reserve(PointsVector self, std::vector< openshot::Point >::size_type n)"""
        return _openshot.PointsVector_reserve(self, n)

    def capacity(self):
        r"""capacity(PointsVector self) -> std::vector< openshot::Point >::size_type"""
        return _openshot.PointsVector_capacity(self)
    __swig_destroy__ = _openshot.delete_PointsVector

# Register PointsVector in _openshot:
_openshot.PointsVector_swigregister(PointsVector)

class FieldVector(object):
    r"""Proxy of C++ std::vector< openshot::Field > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        r"""iterator(FieldVector self) -> SwigPyIterator"""
        return _openshot.FieldVector_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        r"""__nonzero__(FieldVector self) -> bool"""
        return _openshot.FieldVector___nonzero__(self)

    def __bool__(self):
        r"""__bool__(FieldVector self) -> bool"""
        return _openshot.FieldVector___bool__(self)

    def __len__(self):
        r"""__len__(FieldVector self) -> std::vector< openshot::Field >::size_type"""
        return _openshot.FieldVector___len__(self)

    def __getslice__(self, i, j):
        r"""__getslice__(FieldVector self, std::vector< openshot::Field >::difference_type i, std::vector< openshot::Field >::difference_type j) -> FieldVector"""
        return _openshot.FieldVector___getslice__(self, i, j)

    def __setslice__(self, *args):
        r"""
        __setslice__(FieldVector self, std::vector< openshot::Field >::difference_type i, std::vector< openshot::Field >::difference_type j)
        __setslice__(FieldVector self, std::vector< openshot::Field >::difference_type i, std::vector< openshot::Field >::difference_type j, FieldVector v)
        """
        return _openshot.FieldVector___setslice__(self, *args)

    def __delslice__(self, i, j):
        r"""__delslice__(FieldVector self, std::vector< openshot::Field >::difference_type i, std::vector< openshot::Field >::difference_type j)"""
        return _openshot.FieldVector___delslice__(self, i, j)

    def __delitem__(self, *args):
        r"""
        __delitem__(FieldVector self, std::vector< openshot::Field >::difference_type i)
        __delitem__(FieldVector self, PySliceObject * slice)
        """
        return _openshot.FieldVector___delitem__(self, *args)

    def __getitem__(self, *args):
        r"""
        __getitem__(FieldVector self, PySliceObject * slice) -> FieldVector
        __getitem__(FieldVector self, std::vector< openshot::Field >::difference_type i) -> Field
        """
        return _openshot.FieldVector___getitem__(self, *args)

    def __setitem__(self, *args):
        r"""
        __setitem__(FieldVector self, PySliceObject * slice, FieldVector v)
        __setitem__(FieldVector self, PySliceObject * slice)
        __setitem__(FieldVector self, std::vector< openshot::Field >::difference_type i, Field x)
        """
        return _openshot.FieldVector___setitem__(self, *args)

    def pop(self):
        r"""pop(FieldVector self) -> Field"""
        return _openshot.FieldVector_pop(self)

    def append(self, x):
        r"""append(FieldVector self, Field x)"""
        return _openshot.FieldVector_append(self, x)

    def empty(self):
        r"""empty(FieldVector self) -> bool"""
        return _openshot.FieldVector_empty(self)

    def size(self):
        r"""size(FieldVector self) -> std::vector< openshot::Field >::size_type"""
        return _openshot.FieldVector_size(self)

    def swap(self, v):
        r"""swap(FieldVector self, FieldVector v)"""
        return _openshot.FieldVector_swap(self, v)

    def begin(self):
        r"""begin(FieldVector self) -> std::vector< openshot::Field >::iterator"""
        return _openshot.FieldVector_begin(self)

    def end(self):
        r"""end(FieldVector self) -> std::vector< openshot::Field >::iterator"""
        return _openshot.FieldVector_end(self)

    def rbegin(self):
        r"""rbegin(FieldVector self) -> std::vector< openshot::Field >::reverse_iterator"""
        return _openshot.FieldVector_rbegin(self)

    def rend(self):
        r"""rend(FieldVector self) -> std::vector< openshot::Field >::reverse_iterator"""
        return _openshot.FieldVector_rend(self)

    def clear(self):
        r"""clear(FieldVector self)"""
        return _openshot.FieldVector_clear(self)

    def get_allocator(self):
        r"""get_allocator(FieldVector self) -> std::vector< openshot::Field >::allocator_type"""
        return _openshot.FieldVector_get_allocator(self)

    def pop_back(self):
        r"""pop_back(FieldVector self)"""
        return _openshot.FieldVector_pop_back(self)

    def erase(self, *args):
        r"""
        erase(FieldVector self, std::vector< openshot::Field >::iterator pos) -> std::vector< openshot::Field >::iterator
        erase(FieldVector self, std::vector< openshot::Field >::iterator first, std::vector< openshot::Field >::iterator last) -> std::vector< openshot::Field >::iterator
        """
        return _openshot.FieldVector_erase(self, *args)

    def __init__(self, *args):
        r"""
        __init__(FieldVector self) -> FieldVector
        __init__(FieldVector self, FieldVector other) -> FieldVector
        __init__(FieldVector self, std::vector< openshot::Field >::size_type size) -> FieldVector
        __init__(FieldVector self, std::vector< openshot::Field >::size_type size, Field value) -> FieldVector
        """
        _openshot.FieldVector_swiginit(self, _openshot.new_FieldVector(*args))

    def push_back(self, x):
        r"""push_back(FieldVector self, Field x)"""
        return _openshot.FieldVector_push_back(self, x)

    def front(self):
        r"""front(FieldVector self) -> Field"""
        return _openshot.FieldVector_front(self)

    def back(self):
        r"""back(FieldVector self) -> Field"""
        return _openshot.FieldVector_back(self)

    def assign(self, n, x):
        r"""assign(FieldVector self, std::vector< openshot::Field >::size_type n, Field x)"""
        return _openshot.FieldVector_assign(self, n, x)

    def resize(self, *args):
        r"""
        resize(FieldVector self, std::vector< openshot::Field >::size_type new_size)
        resize(FieldVector self, std::vector< openshot::Field >::size_type new_size, Field x)
        """
        return _openshot.FieldVector_resize(self, *args)

    def insert(self, *args):
        r"""
        insert(FieldVector self, std::vector< openshot::Field >::iterator pos, Field x) -> std::vector< openshot::Field >::iterator
        insert(FieldVector self, std::vector< openshot::Field >::iterator pos, std::vector< openshot::Field >::size_type n, Field x)
        """
        return _openshot.FieldVector_insert(self, *args)

    def reserve(self, n):
        r"""reserve(FieldVector self, std::vector< openshot::Field >::size_type n)"""
        return _openshot.FieldVector_reserve(self, n)

    def capacity(self):
        r"""capacity(FieldVector self) -> std::vector< openshot::Field >::size_type"""
        return _openshot.FieldVector_capacity(self)
    __swig_destroy__ = _openshot.delete_FieldVector

# Register FieldVector in _openshot:
_openshot.FieldVector_swigregister(FieldVector)

class MappedFrameVector(object):
    r"""Proxy of C++ std::vector< openshot::MappedFrame > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        r"""iterator(MappedFrameVector self) -> SwigPyIterator"""
        return _openshot.MappedFrameVector_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        r"""__nonzero__(MappedFrameVector self) -> bool"""
        return _openshot.MappedFrameVector___nonzero__(self)

    def __bool__(self):
        r"""__bool__(MappedFrameVector self) -> bool"""
        return _openshot.MappedFrameVector___bool__(self)

    def __len__(self):
        r"""__len__(MappedFrameVector self) -> std::vector< openshot::MappedFrame >::size_type"""
        return _openshot.MappedFrameVector___len__(self)

    def __getslice__(self, i, j):
        r"""__getslice__(MappedFrameVector self, std::vector< openshot::MappedFrame >::difference_type i, std::vector< openshot::MappedFrame >::difference_type j) -> MappedFrameVector"""
        return _openshot.MappedFrameVector___getslice__(self, i, j)

    def __setslice__(self, *args):
        r"""
        __setslice__(MappedFrameVector self, std::vector< openshot::MappedFrame >::difference_type i, std::vector< openshot::MappedFrame >::difference_type j)
        __setslice__(MappedFrameVector self, std::vector< openshot::MappedFrame >::difference_type i, std::vector< openshot::MappedFrame >::difference_type j, MappedFrameVector v)
        """
        return _openshot.MappedFrameVector___setslice__(self, *args)

    def __delslice__(self, i, j):
        r"""__delslice__(MappedFrameVector self, std::vector< openshot::MappedFrame >::difference_type i, std::vector< openshot::MappedFrame >::difference_type j)"""
        return _openshot.MappedFrameVector___delslice__(self, i, j)

    def __delitem__(self, *args):
        r"""
        __delitem__(MappedFrameVector self, std::vector< openshot::MappedFrame >::difference_type i)
        __delitem__(MappedFrameVector self, PySliceObject * slice)
        """
        return _openshot.MappedFrameVector___delitem__(self, *args)

    def __getitem__(self, *args):
        r"""
        __getitem__(MappedFrameVector self, PySliceObject * slice) -> MappedFrameVector
        __getitem__(MappedFrameVector self, std::vector< openshot::MappedFrame >::difference_type i) -> MappedFrame
        """
        return _openshot.MappedFrameVector___getitem__(self, *args)

    def __setitem__(self, *args):
        r"""
        __setitem__(MappedFrameVector self, PySliceObject * slice, MappedFrameVector v)
        __setitem__(MappedFrameVector self, PySliceObject * slice)
        __setitem__(MappedFrameVector self, std::vector< openshot::MappedFrame >::difference_type i, MappedFrame x)
        """
        return _openshot.MappedFrameVector___setitem__(self, *args)

    def pop(self):
        r"""pop(MappedFrameVector self) -> MappedFrame"""
        return _openshot.MappedFrameVector_pop(self)

    def append(self, x):
        r"""append(MappedFrameVector self, MappedFrame x)"""
        return _openshot.MappedFrameVector_append(self, x)

    def empty(self):
        r"""empty(MappedFrameVector self) -> bool"""
        return _openshot.MappedFrameVector_empty(self)

    def size(self):
        r"""size(MappedFrameVector self) -> std::vector< openshot::MappedFrame >::size_type"""
        return _openshot.MappedFrameVector_size(self)

    def swap(self, v):
        r"""swap(MappedFrameVector self, MappedFrameVector v)"""
        return _openshot.MappedFrameVector_swap(self, v)

    def begin(self):
        r"""begin(MappedFrameVector self) -> std::vector< openshot::MappedFrame >::iterator"""
        return _openshot.MappedFrameVector_begin(self)

    def end(self):
        r"""end(MappedFrameVector self) -> std::vector< openshot::MappedFrame >::iterator"""
        return _openshot.MappedFrameVector_end(self)

    def rbegin(self):
        r"""rbegin(MappedFrameVector self) -> std::vector< openshot::MappedFrame >::reverse_iterator"""
        return _openshot.MappedFrameVector_rbegin(self)

    def rend(self):
        r"""rend(MappedFrameVector self) -> std::vector< openshot::MappedFrame >::reverse_iterator"""
        return _openshot.MappedFrameVector_rend(self)

    def clear(self):
        r"""clear(MappedFrameVector self)"""
        return _openshot.MappedFrameVector_clear(self)

    def get_allocator(self):
        r"""get_allocator(MappedFrameVector self) -> std::vector< openshot::MappedFrame >::allocator_type"""
        return _openshot.MappedFrameVector_get_allocator(self)

    def pop_back(self):
        r"""pop_back(MappedFrameVector self)"""
        return _openshot.MappedFrameVector_pop_back(self)

    def erase(self, *args):
        r"""
        erase(MappedFrameVector self, std::vector< openshot::MappedFrame >::iterator pos) -> std::vector< openshot::MappedFrame >::iterator
        erase(MappedFrameVector self, std::vector< openshot::MappedFrame >::iterator first, std::vector< openshot::MappedFrame >::iterator last) -> std::vector< openshot::MappedFrame >::iterator
        """
        return _openshot.MappedFrameVector_erase(self, *args)

    def __init__(self, *args):
        r"""
        __init__(MappedFrameVector self) -> MappedFrameVector
        __init__(MappedFrameVector self, MappedFrameVector other) -> MappedFrameVector
        __init__(MappedFrameVector self, std::vector< openshot::MappedFrame >::size_type size) -> MappedFrameVector
        __init__(MappedFrameVector self, std::vector< openshot::MappedFrame >::size_type size, MappedFrame value) -> MappedFrameVector
        """
        _openshot.MappedFrameVector_swiginit(self, _openshot.new_MappedFrameVector(*args))

    def push_back(self, x):
        r"""push_back(MappedFrameVector self, MappedFrame x)"""
        return _openshot.MappedFrameVector_push_back(self, x)

    def front(self):
        r"""front(MappedFrameVector self) -> MappedFrame"""
        return _openshot.MappedFrameVector_front(self)

    def back(self):
        r"""back(MappedFrameVector self) -> MappedFrame"""
        return _openshot.MappedFrameVector_back(self)

    def assign(self, n, x):
        r"""assign(MappedFrameVector self, std::vector< openshot::MappedFrame >::size_type n, MappedFrame x)"""
        return _openshot.MappedFrameVector_assign(self, n, x)

    def resize(self, *args):
        r"""
        resize(MappedFrameVector self, std::vector< openshot::MappedFrame >::size_type new_size)
        resize(MappedFrameVector self, std::vector< openshot::MappedFrame >::size_type new_size, MappedFrame x)
        """
        return _openshot.MappedFrameVector_resize(self, *args)

    def insert(self, *args):
        r"""
        insert(MappedFrameVector self, std::vector< openshot::MappedFrame >::iterator pos, MappedFrame x) -> std::vector< openshot::MappedFrame >::iterator
        insert(MappedFrameVector self, std::vector< openshot::MappedFrame >::iterator pos, std::vector< openshot::MappedFrame >::size_type n, MappedFrame x)
        """
        return _openshot.MappedFrameVector_insert(self, *args)

    def reserve(self, n):
        r"""reserve(MappedFrameVector self, std::vector< openshot::MappedFrame >::size_type n)"""
        return _openshot.MappedFrameVector_reserve(self, n)

    def capacity(self):
        r"""capacity(MappedFrameVector self) -> std::vector< openshot::MappedFrame >::size_type"""
        return _openshot.MappedFrameVector_capacity(self)
    __swig_destroy__ = _openshot.delete_MappedFrameVector

# Register MappedFrameVector in _openshot:
_openshot.MappedFrameVector_swigregister(MappedFrameVector)

class MappedMetadata(object):
    r"""Proxy of C++ std::map< std::string,std::string > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        r"""iterator(MappedMetadata self) -> SwigPyIterator"""
        return _openshot.MappedMetadata_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        r"""__nonzero__(MappedMetadata self) -> bool"""
        return _openshot.MappedMetadata___nonzero__(self)

    def __bool__(self):
        r"""__bool__(MappedMetadata self) -> bool"""
        return _openshot.MappedMetadata___bool__(self)

    def __len__(self):
        r"""__len__(MappedMetadata self) -> std::map< std::string,std::string >::size_type"""
        return _openshot.MappedMetadata___len__(self)
    def __iter__(self):
        return self.key_iterator()
    def iterkeys(self):
        return self.key_iterator()
    def itervalues(self):
        return self.value_iterator()
    def iteritems(self):
        return self.iterator()

    def __getitem__(self, key):
        r"""__getitem__(MappedMetadata self, std::map< std::string,std::string >::key_type const & key) -> std::map< std::string,std::string >::mapped_type const &"""
        return _openshot.MappedMetadata___getitem__(self, key)

    def __delitem__(self, key):
        r"""__delitem__(MappedMetadata self, std::map< std::string,std::string >::key_type const & key)"""
        return _openshot.MappedMetadata___delitem__(self, key)

    def has_key(self, key):
        r"""has_key(MappedMetadata self, std::map< std::string,std::string >::key_type const & key) -> bool"""
        return _openshot.MappedMetadata_has_key(self, key)

    def keys(self):
        r"""keys(MappedMetadata self) -> PyObject *"""
        return _openshot.MappedMetadata_keys(self)

    def values(self):
        r"""values(MappedMetadata self) -> PyObject *"""
        return _openshot.MappedMetadata_values(self)

    def items(self):
        r"""items(MappedMetadata self) -> PyObject *"""
        return _openshot.MappedMetadata_items(self)

    def __contains__(self, key):
        r"""__contains__(MappedMetadata self, std::map< std::string,std::string >::key_type const & key) -> bool"""
        return _openshot.MappedMetadata___contains__(self, key)

    def key_iterator(self):
        r"""key_iterator(MappedMetadata self) -> SwigPyIterator"""
        return _openshot.MappedMetadata_key_iterator(self)

    def value_iterator(self):
        r"""value_iterator(MappedMetadata self) -> SwigPyIterator"""
        return _openshot.MappedMetadata_value_iterator(self)

    def __setitem__(self, *args):
        r"""
        __setitem__(MappedMetadata self, std::map< std::string,std::string >::key_type const & key)
        __setitem__(MappedMetadata self, std::map< std::string,std::string >::key_type const & key, std::map< std::string,std::string >::mapped_type const & x)
        """
        return _openshot.MappedMetadata___setitem__(self, *args)

    def asdict(self):
        r"""asdict(MappedMetadata self) -> PyObject *"""
        return _openshot.MappedMetadata_asdict(self)

    def __init__(self, *args):
        r"""
        __init__(MappedMetadata self, std::less< std::string > const & other) -> MappedMetadata
        __init__(MappedMetadata self) -> MappedMetadata
        __init__(MappedMetadata self, MappedMetadata other) -> MappedMetadata
        """
        _openshot.MappedMetadata_swiginit(self, _openshot.new_MappedMetadata(*args))

    def empty(self):
        r"""empty(MappedMetadata self) -> bool"""
        return _openshot.MappedMetadata_empty(self)

    def size(self):
        r"""size(MappedMetadata self) -> std::map< std::string,std::string >::size_type"""
        return _openshot.MappedMetadata_size(self)

    def swap(self, v):
        r"""swap(MappedMetadata self, MappedMetadata v)"""
        return _openshot.MappedMetadata_swap(self, v)

    def begin(self):
        r"""begin(MappedMetadata self) -> std::map< std::string,std::string >::iterator"""
        return _openshot.MappedMetadata_begin(self)

    def end(self):
        r"""end(MappedMetadata self) -> std::map< std::string,std::string >::iterator"""
        return _openshot.MappedMetadata_end(self)

    def rbegin(self):
        r"""rbegin(MappedMetadata self) -> std::map< std::string,std::string >::reverse_iterator"""
        return _openshot.MappedMetadata_rbegin(self)

    def rend(self):
        r"""rend(MappedMetadata self) -> std::map< std::string,std::string >::reverse_iterator"""
        return _openshot.MappedMetadata_rend(self)

    def clear(self):
        r"""clear(MappedMetadata self)"""
        return _openshot.MappedMetadata_clear(self)

    def get_allocator(self):
        r"""get_allocator(MappedMetadata self) -> std::map< std::string,std::string >::allocator_type"""
        return _openshot.MappedMetadata_get_allocator(self)

    def count(self, x):
        r"""count(MappedMetadata self, std::map< std::string,std::string >::key_type const & x) -> std::map< std::string,std::string >::size_type"""
        return _openshot.MappedMetadata_count(self, x)

    def erase(self, *args):
        r"""
        erase(MappedMetadata self, std::map< std::string,std::string >::key_type const & x) -> std::map< std::string,std::string >::size_type
        erase(MappedMetadata self, std::map< std::string,std::string >::iterator position)
        erase(MappedMetadata self, std::map< std::string,std::string >::iterator first, std::map< std::string,std::string >::iterator last)
        """
        return _openshot.MappedMetadata_erase(self, *args)

    def find(self, x):
        r"""find(MappedMetadata self, std::map< std::string,std::string >::key_type const & x) -> std::map< std::string,std::string >::iterator"""
        return _openshot.MappedMetadata_find(self, x)

    def lower_bound(self, x):
        r"""lower_bound(MappedMetadata self, std::map< std::string,std::string >::key_type const & x) -> std::map< std::string,std::string >::iterator"""
        return _openshot.MappedMetadata_lower_bound(self, x)

    def upper_bound(self, x):
        r"""upper_bound(MappedMetadata self, std::map< std::string,std::string >::key_type const & x) -> std::map< std::string,std::string >::iterator"""
        return _openshot.MappedMetadata_upper_bound(self, x)
    __swig_destroy__ = _openshot.delete_MappedMetadata

# Register MappedMetadata in _openshot:
_openshot.MappedMetadata_swigregister(MappedMetadata)



