/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.io.File;

public class BaseFile {
    private final String basename;
    private final File basedir;

    public BaseFile() {
        this.basedir = null;
        this.basename = null;
    }

    public BaseFile(File file) {
        this.basedir = file.getParentFile();
        this.basename = BaseFile.extractBasename(file.getName());
    }

    private static String extractBasename(String name) {
        int idx = name.lastIndexOf(46);
        if (idx == -1) {
            return name;
        }
        return name.substring(0, idx);
    }

    public String toString() {
        if (this.basedir == null || this.basename == null) {
            return "(DEFAULT)";
        }
        return this.basedir + " " + this.basename;
    }

    public String getBasename() {
        return this.basename;
    }

    public File getBasedir() {
        return this.basedir;
    }

    public File getTraceFile(String tail) {
        if (this.basedir == null || this.basename == null) {
            return new File(tail);
        }
        return new File(this.basedir, this.basename + "_" + tail);
    }
}

