/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.classdiagram.command;

import net.sourceforge.plantuml.Direction;
import net.sourceforge.plantuml.LineLocation;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.UrlBuilder;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.Matcher2;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.command.regex.Pattern2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOptional;
import net.sourceforge.plantuml.command.regex.RegexOr;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.IGroup;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.LinkArrow;
import net.sourceforge.plantuml.cucadiagram.LinkDecor;
import net.sourceforge.plantuml.cucadiagram.LinkType;
import net.sourceforge.plantuml.graphic.color.ColorParser;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.objectdiagram.AbstractClassOrObjectDiagram;

public final class CommandLinkClass
extends SingleLineCommand2<AbstractClassOrObjectDiagram> {
    private static final String SINGLE = "[.\\\\]{0,2}[\\p{L}0-9_]+(?:[.\\\\]{1,2}[\\p{L}0-9_]+)*";
    private static final String COUPLE = "\\([%s]*([.\\\\]{0,2}[\\p{L}0-9_]+(?:[.\\\\]{1,2}[\\p{L}0-9_]+)*)[%s]*,[%s]*([.\\\\]{0,2}[\\p{L}0-9_]+(?:[.\\\\]{1,2}[\\p{L}0-9_]+)*)[%s]*\\)";

    public CommandLinkClass(UmlDiagramType umlDiagramType) {
        super(CommandLinkClass.getRegexConcat(umlDiagramType));
    }

    private static RegexConcat getRegexConcat(UmlDiagramType umlDiagramType) {
        return RegexConcat.build(CommandLinkClass.class.getName() + (Object)((Object)umlDiagramType), RegexLeaf.start(), new RegexOptional((IRegex)new RegexConcat(new RegexLeaf("HEADER", "@([\\d.]+)"), RegexLeaf.spaceOneOrMore())), new RegexOr(new RegexLeaf("ENT1", CommandLinkClass.getClassIdentifier()), new RegexLeaf("COUPLE1", COUPLE)), RegexLeaf.spaceZeroOrMore(), new RegexOptional((IRegex)new RegexLeaf("FIRST_LABEL", "[%g]([^%g]+)[%g]")), RegexLeaf.spaceZeroOrMore(), new RegexConcat(new RegexLeaf("ARROW_HEAD1", "([%s]+[ox]|[)#\\[<*+^}]|[<\\[]\\||\\}o|\\}\\||\\|o|\\|\\|)?"), new RegexLeaf("ARROW_BODY1", "([-=.]+)"), new RegexLeaf("ARROW_STYLE1", "(?:\\[((?:#\\w+|dotted|dashed|plain|bold|hidden|norank|single|thickness=\\d+)(?:,#\\w+|,dotted|,dashed|,plain|,bold|,hidden|,norank|,single|,thickness=\\d+)*)\\])?"), new RegexLeaf("ARROW_DIRECTION", "(left|right|up|down|le?|ri?|up?|do?)?"), new RegexOptional((IRegex)new RegexLeaf("INSIDE", "(0|\\(0\\)|\\(0|0\\))(?=[-=.~])")), new RegexLeaf("ARROW_STYLE2", "(?:\\[((?:#\\w+|dotted|dashed|plain|bold|hidden|norank|single|thickness=\\d+)(?:,#\\w+|,dotted|,dashed|,plain|,bold|,hidden|,norank|,single|,thickness=\\d+)*)\\])?"), new RegexLeaf("ARROW_BODY2", "([-=.]*)"), new RegexLeaf("ARROW_HEAD2", "([ox][%s]+|[(#\\]>*+^\\{]|\\|[>\\]]|o\\{|\\|\\{|o\\||\\|\\|)?")), RegexLeaf.spaceZeroOrMore(), new RegexOptional((IRegex)new RegexLeaf("SECOND_LABEL", "[%g]([^%g]+)[%g]")), RegexLeaf.spaceZeroOrMore(), new RegexOr(new RegexLeaf("ENT2", CommandLinkClass.getClassIdentifier()), new RegexLeaf("COUPLE2", COUPLE)), RegexLeaf.spaceZeroOrMore(), CommandLinkClass.color().getRegex(), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("URL", "(" + UrlBuilder.getRegexp() + ")?"), RegexLeaf.spaceZeroOrMore(), new RegexOptional((IRegex)new RegexConcat(new RegexLeaf(":"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("LABEL_LINK", "(.+)"))), RegexLeaf.end());
    }

    private static ColorParser color() {
        return ColorParser.simpleColor(ColorType.LINE);
    }

    private static String getClassIdentifier() {
        return "(" + CommandLinkClass.getSeparator() + "?[\\p{L}0-9_$]+(?:" + CommandLinkClass.getSeparator() + "[\\p{L}0-9_$]+)*|[%g][^%g]+[%g])";
    }

    public static String getSeparator() {
        return "(?:\\.|::|\\\\|\\\\\\\\)";
    }

    @Override
    protected CommandExecutionResult executeArg(AbstractClassOrObjectDiagram diagram, LineLocation location, RegexResult arg) {
        Code ent1 = Code.of(arg.get("ENT1", 0));
        Code ent2 = Code.of(arg.get("ENT2", 0));
        if (ent1 == null && ent2 == null) {
            return this.executeArgSpecial3(diagram, arg);
        }
        if (ent1 == null) {
            return this.executeArgSpecial1(diagram, arg);
        }
        if (ent2 == null) {
            return this.executeArgSpecial2(diagram, arg);
        }
        ent1 = ent1.eventuallyRemoveStartingAndEndingDoubleQuote("\"");
        ent2 = ent2.eventuallyRemoveStartingAndEndingDoubleQuote("\"");
        if (this.isGroupButNotTheCurrentGroup(diagram, ent1) && this.isGroupButNotTheCurrentGroup(diagram, ent2)) {
            return this.executePackageLink(diagram, arg);
        }
        String port1 = null;
        String port2 = null;
        if (this.removeMemberPart(diagram, ent1) != null) {
            port1 = ent1.getPortMember();
            ent1 = this.removeMemberPart(diagram, ent1);
        }
        if (this.removeMemberPart(diagram, ent2) != null) {
            port2 = ent2.getPortMember();
            ent2 = this.removeMemberPart(diagram, ent2);
        }
        IEntity cl1 = this.isGroupButNotTheCurrentGroup(diagram, ent1) ? diagram.getGroup(Code.of(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(arg.get("ENT1", 0), "\""))) : diagram.getOrCreateLeaf(ent1, null, null);
        IEntity cl2 = this.isGroupButNotTheCurrentGroup(diagram, ent2) ? diagram.getGroup(Code.of(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(arg.get("ENT2", 0), "\""))) : diagram.getOrCreateLeaf(ent2, null, null);
        LinkType linkType = this.getLinkType(arg);
        Direction dir = this.getDirection(arg);
        int queue = dir == Direction.LEFT || dir == Direction.RIGHT ? 1 : this.getQueueLength(arg);
        String firstLabel = arg.get("FIRST_LABEL", 0);
        String secondLabel = arg.get("SECOND_LABEL", 0);
        String labelLink = null;
        if (arg.get("LABEL_LINK", 0) != null) {
            labelLink = arg.get("LABEL_LINK", 0);
            if (firstLabel == null && secondLabel == null) {
                Pattern2 p1 = MyPattern.cmpile("^[%g]([^%g]+)[%g]([^%g]+)[%g]([^%g]+)[%g]$");
                Matcher2 m1 = p1.matcher(labelLink);
                if (m1.matches()) {
                    firstLabel = m1.group(1);
                    labelLink = StringUtils.trin(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(StringUtils.trin(m1.group(2)), "\""));
                    secondLabel = m1.group(3);
                } else {
                    Pattern2 p2 = MyPattern.cmpile("^[%g]([^%g]+)[%g]([^%g]+)$");
                    Matcher2 m2 = p2.matcher(labelLink);
                    if (m2.matches()) {
                        firstLabel = m2.group(1);
                        labelLink = StringUtils.trin(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(StringUtils.trin(m2.group(2)), "\""));
                        secondLabel = null;
                    } else {
                        Pattern2 p3 = MyPattern.cmpile("^([^%g]+)[%g]([^%g]+)[%g]$");
                        Matcher2 m3 = p3.matcher(labelLink);
                        if (m3.matches()) {
                            firstLabel = null;
                            labelLink = StringUtils.trin(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(StringUtils.trin(m3.group(1)), "\""));
                            secondLabel = m3.group(2);
                        }
                    }
                }
            }
            labelLink = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(labelLink, "\"");
        }
        LinkArrow linkArrow = LinkArrow.NONE;
        if ("<".equals(labelLink)) {
            linkArrow = LinkArrow.BACKWARD;
            labelLink = null;
        } else if (">".equals(labelLink)) {
            linkArrow = LinkArrow.DIRECT_NORMAL;
            labelLink = null;
        } else if (labelLink != null && labelLink.startsWith("< ")) {
            linkArrow = LinkArrow.BACKWARD;
            labelLink = StringUtils.trin(labelLink.substring(2));
        } else if (labelLink != null && labelLink.startsWith("> ")) {
            linkArrow = LinkArrow.DIRECT_NORMAL;
            labelLink = StringUtils.trin(labelLink.substring(2));
        } else if (labelLink != null && labelLink.endsWith(" >")) {
            linkArrow = LinkArrow.DIRECT_NORMAL;
            labelLink = StringUtils.trin(labelLink.substring(0, labelLink.length() - 2));
        } else if (labelLink != null && labelLink.endsWith(" <")) {
            linkArrow = LinkArrow.BACKWARD;
            labelLink = StringUtils.trin(labelLink.substring(0, labelLink.length() - 2));
        }
        Link link = new Link(cl1, cl2, linkType, Display.getWithNewlines(labelLink), queue, firstLabel, secondLabel, diagram.getLabeldistance(), diagram.getLabelangle(), diagram.getSkinParam().getCurrentStyleBuilder());
        if (arg.get("URL", 0) != null) {
            UrlBuilder urlBuilder = new UrlBuilder(diagram.getSkinParam().getValue("topurl"), UrlBuilder.ModeUrl.STRICT);
            Url url = urlBuilder.getUrl(arg.get("URL", 0));
            link.setUrl(url);
        }
        link.setPortMembers(port1, port2);
        if (dir == Direction.LEFT || dir == Direction.UP) {
            link = link.getInv();
        }
        link.setLinkArrow(linkArrow);
        link.setColors(CommandLinkClass.color().getColor(arg, diagram.getSkinParam().getIHtmlColorSet()));
        link.applyStyle(arg.getLazzy("ARROW_STYLE", 0));
        this.addLink(diagram, link, arg.get("HEADER", 0));
        return CommandExecutionResult.ok();
    }

    private boolean isGroupButNotTheCurrentGroup(AbstractClassOrObjectDiagram diagram, Code code) {
        if (diagram.getCurrentGroup().getCode().equals(code)) {
            return false;
        }
        return diagram.isGroup(code);
    }

    private Code removeMemberPart(AbstractClassOrObjectDiagram diagram, Code code) {
        if (diagram.leafExist(code)) {
            return null;
        }
        Code before = code.removeMemberPart();
        if (before == null) {
            return null;
        }
        if (!diagram.leafExist(before)) {
            return null;
        }
        return before;
    }

    private void addLink(AbstractClassOrObjectDiagram diagram, Link link, String weight) {
        diagram.addLink(link);
        if (weight != null) {
            link.setWeight(Double.parseDouble(weight));
        }
    }

    private CommandExecutionResult executePackageLink(AbstractClassOrObjectDiagram diagram, RegexResult arg) {
        IGroup cl1 = diagram.getGroup(Code.of(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(arg.get("ENT1", 0), "\"")));
        IGroup cl2 = diagram.getGroup(Code.of(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(arg.get("ENT2", 0), "\"")));
        LinkType linkType = this.getLinkType(arg);
        Direction dir = this.getDirection(arg);
        int queue = dir == Direction.LEFT || dir == Direction.RIGHT ? 1 : this.getQueueLength(arg);
        Display labelLink = Display.getWithNewlines(arg.get("LABEL_LINK", 0));
        String firstLabel = arg.get("FIRST_LABEL", 0);
        String secondLabel = arg.get("SECOND_LABEL", 0);
        Link link = new Link(cl1, cl2, linkType, labelLink, queue, firstLabel, secondLabel, diagram.getLabeldistance(), diagram.getLabelangle(), diagram.getSkinParam().getCurrentStyleBuilder());
        link.setColors(CommandLinkClass.color().getColor(arg, diagram.getSkinParam().getIHtmlColorSet()));
        diagram.resetPragmaLabel();
        link.applyStyle(arg.getLazzy("ARROW_STYLE", 0));
        this.addLink(diagram, link, arg.get("HEADER", 0));
        return CommandExecutionResult.ok();
    }

    private CommandExecutionResult executeArgSpecial1(AbstractClassOrObjectDiagram diagram, RegexResult arg) {
        Display label;
        LinkType linkType;
        Code clName1A = Code.of(arg.get("COUPLE1", 0));
        Code clName1B = Code.of(arg.get("COUPLE1", 1));
        if (!diagram.leafExist(clName1A)) {
            return CommandExecutionResult.error("No class " + clName1A);
        }
        if (!diagram.leafExist(clName1B)) {
            return CommandExecutionResult.error("No class " + clName1B);
        }
        Code ent2 = Code.of(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(arg.get("ENT2", 0), "\""));
        IEntity cl2 = diagram.getOrCreateLeaf(ent2, null, null);
        boolean result = diagram.associationClass(1, clName1A, clName1B, cl2, linkType = this.getLinkType(arg), label = Display.getWithNewlines(arg.get("LABEL_LINK", 0)));
        if (!result) {
            return CommandExecutionResult.error("Cannot have more than 2 assocications");
        }
        return CommandExecutionResult.ok();
    }

    private CommandExecutionResult executeArgSpecial3(AbstractClassOrObjectDiagram diagram, RegexResult arg) {
        Code clName1A = Code.of(arg.get("COUPLE1", 0));
        Code clName1B = Code.of(arg.get("COUPLE1", 1));
        Code clName2A = Code.of(arg.get("COUPLE2", 0));
        Code clName2B = Code.of(arg.get("COUPLE2", 1));
        if (!diagram.leafExist(clName1A)) {
            return CommandExecutionResult.error("No class " + clName1A);
        }
        if (!diagram.leafExist(clName1B)) {
            return CommandExecutionResult.error("No class " + clName1B);
        }
        if (!diagram.leafExist(clName2A)) {
            return CommandExecutionResult.error("No class " + clName2A);
        }
        if (!diagram.leafExist(clName2B)) {
            return CommandExecutionResult.error("No class " + clName2B);
        }
        LinkType linkType = this.getLinkType(arg);
        Display label = Display.getWithNewlines(arg.get("LABEL_LINK", 0));
        return diagram.associationClass(clName1A, clName1B, clName2A, clName2B, linkType, label);
    }

    private CommandExecutionResult executeArgSpecial2(AbstractClassOrObjectDiagram diagram, RegexResult arg) {
        Display label;
        LinkType linkType;
        Code clName2A = Code.of(arg.get("COUPLE2", 0));
        Code clName2B = Code.of(arg.get("COUPLE2", 1));
        if (!diagram.leafExist(clName2A)) {
            return CommandExecutionResult.error("No class " + clName2A);
        }
        if (!diagram.leafExist(clName2B)) {
            return CommandExecutionResult.error("No class " + clName2B);
        }
        Code ent1 = Code.of(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(arg.get("ENT1", 0), "\""));
        IEntity cl1 = diagram.getOrCreateLeaf(ent1, null, null);
        boolean result = diagram.associationClass(2, clName2A, clName2B, cl1, linkType = this.getLinkType(arg), label = Display.getWithNewlines(arg.get("LABEL_LINK", 0)));
        if (!result) {
            return CommandExecutionResult.error("Cannot have more than 2 assocications");
        }
        return CommandExecutionResult.ok();
    }

    private LinkDecor getDecors1(String s) {
        if (s == null) {
            return LinkDecor.NONE;
        }
        if ("<|".equals(s = StringUtils.trin(s))) {
            return LinkDecor.EXTENDS;
        }
        if ("}".equals(s)) {
            return LinkDecor.CROWFOOT;
        }
        if ("}o".equals(s)) {
            return LinkDecor.CIRCLE_CROWFOOT;
        }
        if ("}|".equals(s)) {
            return LinkDecor.LINE_CROWFOOT;
        }
        if ("|o".equals(s)) {
            return LinkDecor.CIRCLE_LINE;
        }
        if ("||".equals(s)) {
            return LinkDecor.DOUBLE_LINE;
        }
        if ("<".equals(s)) {
            return LinkDecor.ARROW;
        }
        if ("^".equals(s)) {
            return LinkDecor.EXTENDS;
        }
        if ("+".equals(s)) {
            return LinkDecor.PLUS;
        }
        if ("o".equals(s)) {
            return LinkDecor.AGREGATION;
        }
        if ("x".equals(s)) {
            return LinkDecor.NOT_NAVIGABLE;
        }
        if ("*".equals(s)) {
            return LinkDecor.COMPOSITION;
        }
        if ("#".equals(s)) {
            return LinkDecor.SQUARE;
        }
        if (")".equals(s)) {
            return LinkDecor.PARENTHESIS;
        }
        return LinkDecor.NONE;
    }

    private LinkDecor getDecors2(String s) {
        if (s == null) {
            return LinkDecor.NONE;
        }
        if ("|>".equals(s = StringUtils.trin(s))) {
            return LinkDecor.EXTENDS;
        }
        if (">".equals(s)) {
            return LinkDecor.ARROW;
        }
        if ("{".equals(s)) {
            return LinkDecor.CROWFOOT;
        }
        if ("o{".equals(s)) {
            return LinkDecor.CIRCLE_CROWFOOT;
        }
        if ("|{".equals(s)) {
            return LinkDecor.LINE_CROWFOOT;
        }
        if ("o|".equals(s)) {
            return LinkDecor.CIRCLE_LINE;
        }
        if ("||".equals(s)) {
            return LinkDecor.DOUBLE_LINE;
        }
        if ("^".equals(s)) {
            return LinkDecor.EXTENDS;
        }
        if ("+".equals(s)) {
            return LinkDecor.PLUS;
        }
        if ("o".equals(s)) {
            return LinkDecor.AGREGATION;
        }
        if ("x".equals(s)) {
            return LinkDecor.NOT_NAVIGABLE;
        }
        if ("*".equals(s)) {
            return LinkDecor.COMPOSITION;
        }
        if ("#".equals(s)) {
            return LinkDecor.SQUARE;
        }
        if ("(".equals(s)) {
            return LinkDecor.PARENTHESIS;
        }
        return LinkDecor.NONE;
    }

    private LinkType getLinkType(RegexResult arg) {
        String middle;
        LinkDecor decors1 = this.getDecors1(arg.get("ARROW_HEAD1", 0));
        LinkDecor decors2 = this.getDecors2(arg.get("ARROW_HEAD2", 0));
        LinkType result = new LinkType(decors2, decors1);
        if (arg.get("ARROW_BODY1", 0).contains(".") || arg.get("ARROW_BODY2", 0).contains(".")) {
            result = result.goDashed();
        }
        if ("0".equals(middle = arg.get("INSIDE", 0))) {
            result = result.withMiddleCircle();
        } else if ("0)".equals(middle)) {
            result = result.withMiddleCircleCircled1();
        } else if ("(0".equals(middle)) {
            result = result.withMiddleCircleCircled2();
        } else if ("(0)".equals(middle)) {
            result = result.withMiddleCircleCircled();
        }
        return result;
    }

    private int getQueueLength(RegexResult arg) {
        String s = this.getFullArrow(arg);
        s = s.replaceAll("[^-.=]", "");
        return s.length();
    }

    private Direction getDirection(RegexResult arg) {
        LinkDecor decors1 = this.getDecors1(arg.get("ARROW_HEAD1", 0));
        LinkDecor decors2 = this.getDecors2(arg.get("ARROW_HEAD2", 0));
        String s = this.getFullArrow(arg);
        if ((s = s.replaceAll("[^-.=\\w]", "")).startsWith("o")) {
            s = s.substring(1);
        }
        if (s.endsWith("o")) {
            s = s.substring(0, s.length() - 1);
        }
        Direction result = StringUtils.getQueueDirection(s);
        if (this.isInversed(decors1, decors2) && s.matches(".*\\w.*")) {
            result = result.getInv();
        }
        return result;
    }

    private String getFullArrow(RegexResult arg) {
        return CommandLinkClass.notNull(arg.get("ARROW_HEAD1", 0)) + CommandLinkClass.notNull(arg.get("ARROW_BODY1", 0)) + CommandLinkClass.notNull(arg.get("ARROW_DIRECTION", 0)) + CommandLinkClass.notNull(arg.get("ARROW_BODY2", 0)) + CommandLinkClass.notNull(arg.get("ARROW_HEAD2", 0));
    }

    public static String notNull(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }

    private boolean isInversed(LinkDecor decors1, LinkDecor decors2) {
        if (decors1 == LinkDecor.ARROW && decors2 != LinkDecor.ARROW) {
            return true;
        }
        if (decors2 == LinkDecor.AGREGATION) {
            return true;
        }
        if (decors2 == LinkDecor.COMPOSITION) {
            return true;
        }
        return decors2 == LinkDecor.PLUS;
    }
}

