/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graph2;

import java.awt.geom.CubicCurve2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.sourceforge.plantuml.graph2.MagicPointsFactory;
import net.sourceforge.plantuml.graph2.MyCurve;
import net.sourceforge.plantuml.graph2.RectanglesCollection;

public class CubicCurveFactory {
    private final Point2D.Double start;
    private final Point2D.Double end;
    private final RectanglesCollection forbiddenRect = new RectanglesCollection();
    private final List<MyCurve> forbiddenCurves = new ArrayList<MyCurve>();

    public CubicCurveFactory(Point2D start, Point2D end) {
        this.start = new Point2D.Double(start.getX(), start.getY());
        this.end = new Point2D.Double(end.getX(), end.getY());
    }

    public void addForbidden(Rectangle2D.Double rect) {
        this.forbiddenRect.add(rect);
    }

    public void addForbidden(MyCurve curve) {
        this.forbiddenCurves.add(curve);
    }

    public MyCurve getCubicCurve2D() {
        MyCurve result = new MyCurve(new CubicCurve2D.Double(this.start.getX(), this.start.getY(), this.start.getX(), this.start.getY(), this.end.getX(), this.end.getY(), this.end.getX(), this.end.getY()));
        if (result.intersects(this.forbiddenRect) || result.intersects(this.forbiddenCurves)) {
            HashSet<Point2D.Double> all = new HashSet<Point2D.Double>();
            all.addAll(MagicPointsFactory.get(this.start, this.end));
            for (Rectangle2D.Double rect : this.forbiddenRect) {
                all.addAll(MagicPointsFactory.get(rect));
            }
            double min = Double.MAX_VALUE;
            for (Point2D.Double p1 : all) {
                for (Point2D.Double p2 : all) {
                    MyCurve me = new MyCurve(new CubicCurve2D.Double(this.start.getX(), this.start.getY(), p1.getX(), p1.getY(), p2.getX(), p2.getY(), this.end.getX(), this.end.getY()));
                    if (!(me.getLenght() < min) || me.intersects(this.forbiddenRect) || me.intersects(this.forbiddenCurves)) continue;
                    result = me;
                    min = me.getLenght();
                }
            }
        }
        return result;
    }
}

