/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.preproc2;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import net.sourceforge.plantuml.DefinitionsContainer;
import net.sourceforge.plantuml.FileSystem;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.StringLocated;
import net.sourceforge.plantuml.command.regex.Matcher2;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.command.regex.Pattern2;
import net.sourceforge.plantuml.preproc.FileWithSuffix;
import net.sourceforge.plantuml.preproc.ReadLine;
import net.sourceforge.plantuml.preproc.ReadLineReader;
import net.sourceforge.plantuml.preproc.ReadLineSimple;
import net.sourceforge.plantuml.preproc.Sub;
import net.sourceforge.plantuml.preproc2.PreprocessorInclude;
import net.sourceforge.plantuml.preproc2.ReadFilter;
import net.sourceforge.plantuml.preproc2.ReadLineQuoteComment;

public class SubPreprocessor
implements ReadFilter {
    private static final String ID = "[A-Za-z_][A-Za-z_0-9]*";
    private static final Pattern2 includeSubPattern = MyPattern.cmpile("^[%s]*!includesub[%s]+[%g]?([^%g]+)[%g]?$");
    private static final Pattern2 startsub = MyPattern.cmpile("^[%s]*!startsub[%s]+([A-Za-z_][A-Za-z_0-9]*)");
    private static final Pattern2 endsub = MyPattern.cmpile("^[%s]*!endsub[%s]*");
    private final DefinitionsContainer definitionsContainer;
    private final String charset;
    private final Map<String, Sub> subs = new HashMap<String, Sub>();
    private Sub learningSub;
    private ReadLine includedSub;

    public SubPreprocessor(String charset, DefinitionsContainer definitionsContainer) {
        this.charset = charset;
        this.definitionsContainer = definitionsContainer;
    }

    @Override
    public ReadLine applyFilter(ReadLine source) {
        return new InnerReadLine(source);
    }

    private ReadLine getReaderIncludeWithoutComment(StringLocated s, File f) {
        return new ReadLineQuoteComment(false).applyFilter(this.getReaderIncludeRaw(s, f));
    }

    private ReadLine getReaderIncludeRaw(StringLocated s, File f) {
        try {
            if (this.charset == null) {
                Log.info("Using default charset");
                return ReadLineReader.create(new FileReader(f), FileWithSuffix.getFileName(f), s.getLocation());
            }
            Log.info("Using charset " + this.charset);
            return ReadLineReader.create(new InputStreamReader((InputStream)new FileInputStream(f), this.charset), FileWithSuffix.getFileName(f), s.getLocation());
        }
        catch (IOException e) {
            return new ReadLineSimple(s, e.toString());
        }
    }

    class InnerReadLine
    implements ReadLine {
        final ReadLine source;

        public InnerReadLine(ReadLine source) {
            this.source = source;
        }

        private StringLocated manageStartsub(Matcher2 m) throws IOException {
            String name = m.group(1);
            SubPreprocessor.this.learningSub = this.getSub(name);
            return this.readLine();
        }

        private StringLocated manageEndsub(Matcher2 m) throws IOException {
            SubPreprocessor.this.learningSub = null;
            return this.readLine();
        }

        @Override
        public void close() throws IOException {
            this.source.close();
        }

        private StringLocated manageIncludeSub(StringLocated s, Matcher2 m) throws IOException {
            String name = m.group(1);
            int idx = name.indexOf(33);
            if (idx != -1) {
                String filename = name.substring(0, idx);
                String blocname = name.substring(idx + 1);
                File f = FileSystem.getInstance().getFile(PreprocessorInclude.withEnvironmentVariable(filename));
                if (!f.exists() || f.isDirectory()) {
                    Log.error("Cannot include " + FileWithSuffix.getAbsolutePath(f));
                    return s.withErrorPreprocessor("Cannot include " + FileWithSuffix.getFileName(f));
                }
                SubPreprocessor data = new SubPreprocessor(SubPreprocessor.this.charset, SubPreprocessor.this.definitionsContainer);
                InnerReadLine tmp = (InnerReadLine)data.applyFilter(SubPreprocessor.this.getReaderIncludeWithoutComment(s, f));
                while (tmp.readLine() != null) {
                }
                tmp.close();
                SubPreprocessor.this.includedSub = tmp.getSub(blocname).getReadLine(s.getLocation());
            } else {
                SubPreprocessor.this.includedSub = this.getSub(name).getReadLine(s.getLocation());
            }
            return this.readLine();
        }

        @Override
        public StringLocated readLine() throws IOException {
            StringLocated s;
            if (SubPreprocessor.this.includedSub != null) {
                s = SubPreprocessor.this.includedSub.readLine();
                if (s != null) {
                    this.eventuallyLearn(s);
                    return s;
                }
                SubPreprocessor.this.includedSub = null;
            }
            if ((s = this.source.readLine()) == null) {
                return null;
            }
            Matcher2 m1 = includeSubPattern.matcher(s.getString());
            if (m1.find()) {
                return this.manageIncludeSub(s, m1);
            }
            Matcher2 m = startsub.matcher(s.getString());
            if (m.find()) {
                return this.manageStartsub(m);
            }
            m = endsub.matcher(s.getString());
            if (m.find()) {
                return this.manageEndsub(m);
            }
            this.eventuallyLearn(s);
            return s;
        }

        private void eventuallyLearn(StringLocated s) {
            if (SubPreprocessor.this.learningSub != null) {
                SubPreprocessor.this.learningSub.add(s);
            }
        }

        Sub getSub(String name) {
            Sub result = (Sub)SubPreprocessor.this.subs.get(name);
            if (result == null) {
                result = new Sub(name);
                SubPreprocessor.this.subs.put(name, result);
            }
            return result;
        }
    }
}

