/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.timingdiagram;

import java.math.BigDecimal;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import net.sourceforge.plantuml.timingdiagram.TimeTick;

public enum TimingFormat {
    DECIMAL,
    HOUR,
    DATE;

    private static final TimeZone GMT;
    private static final GregorianCalendar gc;

    public String formatTime(BigDecimal time) {
        if (this == HOUR || this == DATE) {
            return this.formatTime(time.longValueExact());
        }
        return time.toPlainString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String formatTime(long time) {
        if (this == HOUR) {
            int s = (int)time % 60;
            int m = (int)(time / 60L) % 60;
            int h = (int)(time / 3600L);
            return String.format("%d:%02d:%02d", h, m, s);
        }
        if (this == DATE) {
            int dd;
            int mm;
            GregorianCalendar gregorianCalendar = gc;
            synchronized (gregorianCalendar) {
                gc.setTimeInMillis(time * 1000L);
                int yyyy = gc.get(1);
                mm = gc.get(2) + 1;
                dd = gc.get(5);
            }
            return String.format("%02d/%02d", mm, dd);
        }
        return "" + time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TimeTick createDate(int yyyy, int mm, int dd) {
        long timeInMillis;
        GregorianCalendar gregorianCalendar = gc;
        synchronized (gregorianCalendar) {
            gc.setTimeInMillis(0L);
            gc.set(yyyy, mm - 1, dd);
            timeInMillis = gc.getTimeInMillis() / 1000L;
        }
        return new TimeTick(new BigDecimal(timeInMillis), DATE);
    }

    static {
        GMT = TimeZone.getTimeZone("GMT");
        gc = new GregorianCalendar(GMT);
    }
}

