/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.creole.Stencil;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UShape;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class UHorizontalLine
implements UShape {
    private final double skipAtStart;
    private final double skipAtEnd;
    private final TextBlock title;
    private final boolean blankTitle;
    private final char style;

    private UHorizontalLine(double skipAtStart, double skipAtEnd, TextBlock title, boolean blankTitle, char style) {
        this.skipAtEnd = skipAtEnd;
        this.skipAtStart = skipAtStart;
        this.title = title;
        this.blankTitle = blankTitle;
        this.style = style;
    }

    public static UHorizontalLine infinite(double skipAtStart, double skipAtEnd, char style) {
        return new UHorizontalLine(skipAtStart, skipAtEnd, null, false, style);
    }

    public static UHorizontalLine infinite(double skipAtStart, double skipAtEnd, TextBlock title, char style) {
        return new UHorizontalLine(skipAtStart, skipAtEnd, title, false, style);
    }

    public boolean isDouble() {
        return this.style == '=';
    }

    public void drawLineInternal(UGraphic ug, Stencil stencil, double y, UStroke defaultStroke) {
        stencil = this.addSkip(stencil);
        UStroke strokeToUse = this.style == '\u0000' ? defaultStroke : this.getStroke();
        UGraphic ugStroke = ug.apply(strokeToUse);
        if (this.title == null) {
            this.drawHLine(stencil, y, ugStroke);
            return;
        }
        Dimension2D dimTitle = this.title.calculateDimension(ug.getStringBounder());
        this.drawHLine(UHorizontalLine.firstHalf(stencil, dimTitle.getWidth()), y, ugStroke);
        double startingX = stencil.getStartingX(ug.getStringBounder(), y);
        double endingX = stencil.getEndingX(ug.getStringBounder(), y);
        this.drawTitleInternal(ug, startingX, endingX, y, false);
        this.drawHLine(UHorizontalLine.secondHalf(stencil, dimTitle.getWidth()), y, ugStroke);
    }

    private Stencil addSkip(final Stencil stencil) {
        return new Stencil(){

            @Override
            public double getStartingX(StringBounder stringBounder, double y) {
                return stencil.getStartingX(stringBounder, y) + UHorizontalLine.this.skipAtStart;
            }

            @Override
            public double getEndingX(StringBounder stringBounder, double y) {
                return stencil.getEndingX(stringBounder, y) - UHorizontalLine.this.skipAtEnd;
            }
        };
    }

    private static Stencil firstHalf(final Stencil stencil, final double widthTitle) {
        return new Stencil(){

            @Override
            public double getStartingX(StringBounder stringBounder, double y) {
                return stencil.getStartingX(stringBounder, y);
            }

            @Override
            public double getEndingX(StringBounder stringBounder, double y) {
                double start = stencil.getStartingX(stringBounder, y);
                double end = stencil.getEndingX(stringBounder, y);
                double len = (end - start - widthTitle) / 2.0;
                return start + len;
            }
        };
    }

    private static Stencil secondHalf(final Stencil stencil, final double widthTitle) {
        return new Stencil(){

            @Override
            public double getStartingX(StringBounder stringBounder, double y) {
                double start = stencil.getStartingX(stringBounder, y);
                double end = stencil.getEndingX(stringBounder, y);
                double len = (end - start - widthTitle) / 2.0;
                return end - len;
            }

            @Override
            public double getEndingX(StringBounder stringBounder, double y) {
                return stencil.getEndingX(stringBounder, y);
            }
        };
    }

    private void drawHLine(Stencil stencil, double y, UGraphic ug) {
        UHorizontalLine.drawSimpleHline(ug, stencil, y);
        if (this.style == '=') {
            UHorizontalLine.drawSimpleHline(ug, stencil, y + 2.0);
        }
    }

    private static void drawSimpleHline(UGraphic ug, Stencil stencil, double y) {
        double startingX = stencil.getStartingX(ug.getStringBounder(), y);
        double endingX = stencil.getEndingX(ug.getStringBounder(), y);
        ug.apply(new UTranslate(startingX, y)).draw(new ULine(endingX - startingX, 0.0));
    }

    public void drawTitleInternal(UGraphic ug, double startingX, double endingX, double y, boolean clearArea) {
        if (this.title == null || this.blankTitle) {
            return;
        }
        double widthToUse = endingX - startingX;
        Dimension2D dimTitle = this.title.calculateDimension(ug.getStringBounder());
        double space = (widthToUse - dimTitle.getWidth()) / 2.0;
        double x1 = startingX + space;
        double y1 = y - dimTitle.getHeight() / 2.0 - 0.5;
        ug = ug.apply(new UTranslate(x1, y1));
        if (clearArea) {
            ug.apply(this.getStroke()).draw(new URectangle(dimTitle));
        }
        this.title.drawU(ug);
    }

    public void drawMe(UGraphic ug) {
        ug.draw(this);
    }

    public UStroke getStroke() {
        if (this.style == '\u0000') {
            throw new IllegalStateException();
        }
        if (this.style == '=') {
            return new UStroke();
        }
        if (this.style == '.') {
            return new UStroke(1.0, 2.0, 1.0);
        }
        if (this.style == '-') {
            return new UStroke();
        }
        return new UStroke(1.5);
    }
}

