/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.pdf;

import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.freehep.graphicsio.font.FontEmbedderType1;
import org.freehep.graphicsio.pdf.PDFCharTableWriter;
import org.freehep.graphicsio.pdf.PDFDictionary;
import org.freehep.graphicsio.pdf.PDFRedundanceTracker;
import org.freehep.graphicsio.pdf.PDFStream;
import org.freehep.graphicsio.pdf.PDFWriter;

public class PDFFontEmbedderType1
extends FontEmbedderType1 {
    private ByteArrayOutputStream byteBuffer;
    private String reference;
    private PDFWriter pdf;
    private PDFStream fontFile;
    private PDFRedundanceTracker redundanceTracker;

    public static PDFFontEmbedderType1 create(FontRenderContext context, PDFWriter pdf, String reference, PDFRedundanceTracker tracker) {
        return new PDFFontEmbedderType1(context, pdf, reference, new ByteArrayOutputStream(), tracker);
    }

    private PDFFontEmbedderType1(FontRenderContext context, PDFWriter pdf, String reference, ByteArrayOutputStream byteOut, PDFRedundanceTracker tracker) {
        super(context, byteOut, false);
        this.byteBuffer = byteOut;
        this.pdf = pdf;
        this.reference = reference;
        this.redundanceTracker = tracker;
    }

    private String getReference() {
        return this.reference;
    }

    @Override
    protected void openIncludeFont() throws IOException {
        super.openIncludeFont();
        PDFDictionary fontDict = this.pdf.openDictionary(this.reference);
        fontDict.entry("Type", this.pdf.name("Font"));
        fontDict.entry("Subtype", this.pdf.name("Type1"));
        fontDict.entry("Name", this.pdf.name(this.getFontName()));
        fontDict.entry("FirstChar", 0);
        fontDict.entry("LastChar", 255);
        fontDict.entry("Encoding", this.redundanceTracker.getReference(this.getEncodingTable(), PDFCharTableWriter.getInstance()));
        fontDict.entry("Widths", this.pdf.ref(this.reference + "Widths"));
        fontDict.entry("BaseFont", this.pdf.name(this.getFontName()));
        fontDict.entry("FontDescriptor", this.pdf.ref(this.getReference() + "FontDescriptor"));
        this.pdf.close(fontDict);
        PDFDictionary fontDescriptor = this.pdf.openDictionary(this.getReference() + "FontDescriptor");
        fontDescriptor.entry("Type", this.pdf.name("FontDescriptor"));
        LineMetrics metrics = this.getFont().getLineMetrics("mM", this.getContext());
        fontDescriptor.entry("Ascent", metrics.getAscent());
        fontDescriptor.entry("Descent", metrics.getDescent());
        fontDescriptor.entry("FontName", this.pdf.name(this.getFontName()));
        fontDescriptor.entry("Flags", 32);
        fontDescriptor.entry("CapHeight", metrics.getAscent());
        fontDescriptor.entry("ItalicAngle", this.getFont().getItalicAngle());
        Rectangle2D boundingBox = this.getFontBBox();
        double llx = boundingBox.getX();
        double lly = boundingBox.getY();
        double urx = boundingBox.getX() + boundingBox.getWidth();
        double ury = boundingBox.getY() + boundingBox.getHeight();
        fontDescriptor.entry("FontBBox", new double[]{llx, lly, urx, ury});
        fontDescriptor.entry("FontFile", this.pdf.ref(this.getReference() + "FontFile"));
        this.pdf.close(fontDescriptor);
    }

    @Override
    protected void writeWidths(double[] widths) throws IOException {
        super.writeWidths(widths);
        Object[] widthsObj = new Object[256];
        for (int i = 0; i < widthsObj.length; ++i) {
            widthsObj[i] = new Integer((int)Math.round(widths[i]));
        }
        this.pdf.object(this.reference + "Widths", widthsObj);
    }

    @Override
    protected void openGlyphs() throws IOException {
        super.openGlyphs();
    }

    @Override
    protected void closeEmbedFont() throws IOException {
        super.closeEmbedFont();
        this.fontFile = this.pdf.openStream(this.getReference() + "FontFile", new String[]{"Flate", "ASCII85"});
        this.fontFile.entry("Length1", this.getAsciiLength());
        this.fontFile.entry("Length2", this.getEncryptedLength());
        this.fontFile.entry("Length3", 0);
        String file = this.byteBuffer.toString("US-ASCII");
        this.fontFile.print(file);
        this.pdf.close(this.fontFile);
    }
}

