/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.params;

import java.awt.EventQueue;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.core.scanner.NameValuePair;
import org.parosproxy.paros.core.scanner.VariantMultipartFormParameters;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.db.RecordParam;
import org.parosproxy.paros.extension.ExtensionAdaptor;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.extension.ExtensionHookView;
import org.parosproxy.paros.extension.ExtensionLoader;
import org.parosproxy.paros.extension.SessionChangedListener;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.network.HtmlParameter;
import org.parosproxy.paros.network.HttpHeaderField;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.extension.anticsrf.ExtensionAntiCSRF;
import org.zaproxy.zap.extension.help.ExtensionHelp;
import org.zaproxy.zap.extension.httpsessions.ExtensionHttpSessions;
import org.zaproxy.zap.extension.params.HtmlParameterStats;
import org.zaproxy.zap.extension.params.ParamScanner;
import org.zaproxy.zap.extension.params.ParamsAPI;
import org.zaproxy.zap.extension.params.ParamsPanel;
import org.zaproxy.zap.extension.params.PopupMenuAddAntiCSRF;
import org.zaproxy.zap.extension.params.PopupMenuAddSession;
import org.zaproxy.zap.extension.params.PopupMenuParamSearch;
import org.zaproxy.zap.extension.params.PopupMenuRemoveAntiCSRF;
import org.zaproxy.zap.extension.params.PopupMenuRemoveSession;
import org.zaproxy.zap.extension.params.SiteParameters;
import org.zaproxy.zap.extension.pscan.ExtensionPassiveScan;
import org.zaproxy.zap.extension.search.ExtensionSearch;
import org.zaproxy.zap.view.SiteMapListener;
import org.zaproxy.zap.view.SiteMapTreeCellRenderer;

public class ExtensionParams
extends ExtensionAdaptor
implements SessionChangedListener,
SiteMapListener {
    public static final String NAME = "ExtensionParams";
    private ParamsPanel paramsPanel = null;
    private PopupMenuParamSearch popupMenuSearch = null;
    private PopupMenuAddAntiCSRF popupMenuAddAntiCsrf = null;
    private PopupMenuRemoveAntiCSRF popupMenuRemoveAntiCsrf = null;
    private PopupMenuAddSession popupMenuAddSession = null;
    private PopupMenuRemoveSession popupMenuRemoveSession = null;
    private Map<String, SiteParameters> siteParamsMap = new HashMap<String, SiteParameters>();
    private Logger logger = Logger.getLogger(ExtensionParams.class);
    private ExtensionHttpSessions extensionHttpSessions;
    private ParamScanner paramScanner;

    public ExtensionParams() {
        super(NAME);
        this.setOrder(58);
    }

    @Override
    public boolean supportsDb(String type) {
        return true;
    }

    @Override
    public String getUIName() {
        return Constant.messages.getString("params.name");
    }

    @Override
    public void hook(ExtensionHook extensionHook) {
        ExtensionPassiveScan extensionPassiveScan;
        super.hook(extensionHook);
        extensionHook.addApiImplementor(new ParamsAPI(this));
        extensionHook.addSessionListener(this);
        extensionHook.addSiteMapListener(this);
        if (this.getView() != null) {
            ExtensionHookView pv = extensionHook.getHookView();
            extensionHook.getHookView().addStatusPanel(this.getParamsPanel());
            ExtensionLoader extLoader = Control.getSingleton().getExtensionLoader();
            if (extLoader.isExtensionEnabled("ExtensionSearch2")) {
                extensionHook.getHookMenu().addPopupMenuItem(this.getPopupMenuParamSearch());
            }
            if (extLoader.isExtensionEnabled("ExtensionAntiCSRF")) {
                extensionHook.getHookMenu().addPopupMenuItem(this.getPopupMenuAddAntiCSRF());
                extensionHook.getHookMenu().addPopupMenuItem(this.getPopupMenuRemoveAntiCSRF());
            }
            if (extLoader.isExtensionEnabled("ExtensionHttpSessions")) {
                extensionHook.getHookMenu().addPopupMenuItem(this.getPopupMenuAddSession());
                extensionHook.getHookMenu().addPopupMenuItem(this.getPopupMenuRemoveSession());
            }
            ExtensionHelp.enableHelpKey(this.getParamsPanel(), "ui.tabs.params");
        }
        if ((extensionPassiveScan = Control.getSingleton().getExtensionLoader().getExtension(ExtensionPassiveScan.class)) != null) {
            this.paramScanner = new ParamScanner(this);
            extensionPassiveScan.addPassiveScanner(new ParamScanner(this));
        }
    }

    @Override
    public void unload() {
        ExtensionPassiveScan extensionPassiveScan = Control.getSingleton().getExtensionLoader().getExtension(ExtensionPassiveScan.class);
        if (extensionPassiveScan != null) {
            extensionPassiveScan.removePassiveScanner(this.paramScanner);
        }
        super.unload();
    }

    private PopupMenuParamSearch getPopupMenuParamSearch() {
        if (this.popupMenuSearch == null) {
            this.popupMenuSearch = new PopupMenuParamSearch();
            this.popupMenuSearch.setExtension(this);
        }
        return this.popupMenuSearch;
    }

    private PopupMenuAddAntiCSRF getPopupMenuAddAntiCSRF() {
        if (this.popupMenuAddAntiCsrf == null) {
            this.popupMenuAddAntiCsrf = new PopupMenuAddAntiCSRF();
            this.popupMenuAddAntiCsrf.setExtension(this);
        }
        return this.popupMenuAddAntiCsrf;
    }

    private PopupMenuRemoveAntiCSRF getPopupMenuRemoveAntiCSRF() {
        if (this.popupMenuRemoveAntiCsrf == null) {
            this.popupMenuRemoveAntiCsrf = new PopupMenuRemoveAntiCSRF();
            this.popupMenuRemoveAntiCsrf.setExtension(this);
        }
        return this.popupMenuRemoveAntiCsrf;
    }

    private PopupMenuAddSession getPopupMenuAddSession() {
        if (this.popupMenuAddSession == null) {
            this.popupMenuAddSession = new PopupMenuAddSession();
            this.popupMenuAddSession.setExtension(this);
        }
        return this.popupMenuAddSession;
    }

    private PopupMenuRemoveSession getPopupMenuRemoveSession() {
        if (this.popupMenuRemoveSession == null) {
            this.popupMenuRemoveSession = new PopupMenuRemoveSession();
            this.popupMenuRemoveSession.setExtension(this);
        }
        return this.popupMenuRemoveSession;
    }

    protected ParamsPanel getParamsPanel() {
        if (this.paramsPanel == null) {
            this.paramsPanel = new ParamsPanel(this);
        }
        return this.paramsPanel;
    }

    @Override
    public void sessionChanged(final Session session) {
        if (EventQueue.isDispatchThread()) {
            this.sessionChangedEventHandler(session);
        } else {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        ExtensionParams.this.sessionChangedEventHandler(session);
                    }
                });
            }
            catch (Exception e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    protected ExtensionHttpSessions getExtensionHttpSessions() {
        if (this.extensionHttpSessions == null) {
            this.extensionHttpSessions = Control.getSingleton().getExtensionLoader().getExtension(ExtensionHttpSessions.class);
        }
        return this.extensionHttpSessions;
    }

    private void sessionChangedEventHandler(Session session) {
        this.siteParamsMap = new HashMap<String, SiteParameters>();
        if (this.getView() != null) {
            this.getParamsPanel().reset();
        }
        if (session == null) {
            return;
        }
        SiteNode root = session.getSiteTree().getRoot();
        Enumeration<TreeNode> en = root.children();
        while (en.hasMoreElements()) {
            String site = ((SiteNode)en.nextElement()).getNodeName();
            if (this.getView() == null) continue;
            this.getParamsPanel().addSite(site);
        }
        try {
            List<RecordParam> params = Model.getSingleton().getDb().getTableParam().getAll();
            for (RecordParam param : params) {
                SiteParameters sps = this.getSiteParameters(param.getSite());
                sps.addParam(param.getSite(), param);
            }
        }
        catch (DatabaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public boolean onHttpRequestSend(HttpMessage msg) {
        Iterator<HtmlParameter> iter;
        TreeSet<HtmlParameter> params;
        SiteParameters sps;
        String site = msg.getRequestHeader().getHostName() + ":" + msg.getRequestHeader().getHostPort();
        if (this.getView() != null) {
            this.getParamsPanel().addSite(site);
        }
        if ((sps = this.siteParamsMap.get(site)) == null) {
            sps = new SiteParameters(this, site);
            this.siteParamsMap.put(site, sps);
        }
        try {
            params = msg.getRequestHeader().getCookieParams();
            iter = params.iterator();
            while (iter.hasNext()) {
                this.persist(sps.addParam(site, iter.next(), msg));
            }
        }
        catch (IllegalArgumentException e) {
            this.logger.warn((Object)("Failed to obtain the cookies: " + e.getMessage()), (Throwable)e);
        }
        params = msg.getUrlParams();
        iter = params.iterator();
        while (iter.hasNext()) {
            this.persist(sps.addParam(site, iter.next(), msg));
        }
        ExtensionAntiCSRF extAntiCSRF = Control.getSingleton().getExtensionLoader().getExtension(ExtensionAntiCSRF.class);
        params = msg.getFormParams();
        for (HtmlParameter param : params) {
            if (extAntiCSRF != null && extAntiCSRF.isAntiCsrfToken(param.getName())) {
                param.addFlag(HtmlParameter.Flags.anticsrf.name());
            }
            this.persist(sps.addParam(site, param, msg));
        }
        VariantMultipartFormParameters params2 = new VariantMultipartFormParameters();
        params2.setMessage(msg);
        for (NameValuePair nvp : params2.getParamList()) {
            if (nvp.getType() != 33 && nvp.getType() != 35) continue;
            this.persist(sps.addParam(site, new HtmlParameter(HtmlParameter.Type.multipart, nvp.getName(), nvp.getValue()), msg));
        }
        return true;
    }

    private String setToString(Set<String> set) {
        StringBuilder sb = new StringBuilder();
        if (set == null) {
            return "";
        }
        for (String str : set) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(str.replace(",", "%2C"));
        }
        return sb.toString();
    }

    private void persist(HtmlParameterStats param) {
        try {
            if (param.getId() < 0L) {
                RecordParam rp = Model.getSingleton().getDb().getTableParam().insert(param.getSite(), param.getType().name(), param.getName(), param.getTimesUsed(), this.setToString(param.getFlags()), this.setToString(param.getValues()));
                param.setId(rp.getParamId());
            } else {
                Model.getSingleton().getDb().getTableParam().update(param.getId(), param.getTimesUsed(), this.setToString(param.getFlags()), this.setToString(param.getValues()));
            }
        }
        catch (DatabaseException e) {
            if (e.getCause().getMessage().contains("truncation")) {
                this.logger.warn((Object)("Could not add or update param: " + param.getName()));
                this.logger.warn((Object)"It is likely that the length of one of the data elements exceeded the column size.");
                this.logger.warn((Object)e.getMessage());
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)e.getMessage(), (Throwable)e);
                }
            }
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public boolean onHttpResponseReceive(HttpMessage msg) {
        String site = msg.getRequestHeader().getHostName() + ":" + msg.getRequestHeader().getHostPort();
        if (this.getView() != null) {
            this.getParamsPanel().addSite(site);
        }
        SiteParameters sps = this.getSiteParameters(site);
        try {
            TreeSet<HtmlParameter> params = msg.getResponseHeader().getCookieParams();
            Iterator<HtmlParameter> iter = params.iterator();
            while (iter.hasNext()) {
                this.persist(sps.addParam(site, iter.next(), msg));
            }
        }
        catch (IllegalArgumentException e) {
            this.logger.warn((Object)("Failed to obtain the cookies: " + e.getMessage()), (Throwable)e);
        }
        List<HttpHeaderField> headersList = msg.getResponseHeader().getHeaders();
        List<String> setCookieHeaders = Arrays.asList("Set-Cookie".toLowerCase(), "Set-Cookie2".toLowerCase());
        for (HttpHeaderField hdrField : headersList) {
            if (setCookieHeaders.contains(hdrField.getName().toLowerCase())) continue;
            HtmlParameter headerParam = new HtmlParameter(HtmlParameter.Type.header, hdrField.getName(), hdrField.getValue());
            this.persist(sps.addParam(site, headerParam, msg));
        }
        return true;
    }

    @Override
    public void nodeSelected(SiteNode node) {
        this.getParamsPanel().nodeSelected(node);
    }

    @Override
    public void onReturnNodeRendererComponent(SiteMapTreeCellRenderer component, boolean leaf, SiteNode value) {
    }

    protected void searchForSelectedParam() {
        ExtensionSearch extSearch;
        HtmlParameterStats item = this.getParamsPanel().getSelectedParam();
        if (item != null && (extSearch = Control.getSingleton().getExtensionLoader().getExtension(ExtensionSearch.class)) != null) {
            if (HtmlParameter.Type.url.equals((Object)item.getType())) {
                extSearch.search("[?&]" + Pattern.quote(item.getName()) + "=.*", ExtensionSearch.Type.URL, true, false);
            } else if (HtmlParameter.Type.cookie.equals((Object)item.getType())) {
                extSearch.search(Pattern.quote(item.getName()) + "=.*", ExtensionSearch.Type.Header, true, false);
            } else if (HtmlParameter.Type.header.equals((Object)item.getType())) {
                extSearch.search(Pattern.quote(item.getName()) + ":.*", ExtensionSearch.Type.Header, true, false);
            } else if (HtmlParameter.Type.multipart.equals((Object)item.getType())) {
                extSearch.search("(?i)\\s*content-disposition\\s*:.*\\s+name\\s*\\=?\\s*\\\"?" + Pattern.quote(item.getName()), ExtensionSearch.Type.Request, true, false);
            } else {
                extSearch.search(Pattern.quote(item.getName()) + "=.*", ExtensionSearch.Type.Request, true, false);
            }
        }
    }

    public void addAntiCsrfToken() {
        HtmlParameterStats item = this.getParamsPanel().getSelectedParam();
        ExtensionAntiCSRF extAntiCSRF = Control.getSingleton().getExtensionLoader().getExtension(ExtensionAntiCSRF.class);
        if (extAntiCSRF != null && item != null) {
            extAntiCSRF.addAntiCsrfTokenName(item.getName());
            item.addFlag(HtmlParameter.Flags.anticsrf.name());
            this.getParamsPanel().getParamsTable().repaint();
        }
    }

    public void removeAntiCsrfToken() {
        HtmlParameterStats item = this.getParamsPanel().getSelectedParam();
        ExtensionAntiCSRF extAntiCSRF = Control.getSingleton().getExtensionLoader().getExtension(ExtensionAntiCSRF.class);
        if (extAntiCSRF != null && item != null) {
            extAntiCSRF.removeAntiCsrfTokenName(item.getName());
            item.removeFlag(HtmlParameter.Flags.anticsrf.name());
            this.getParamsPanel().getParamsTable().repaint();
        }
    }

    public boolean hasSite(String site) {
        return this.siteParamsMap.containsKey(site);
    }

    public boolean hasParameters(String site) {
        SiteParameters siteParameters = this.siteParamsMap.get(site);
        if (siteParameters == null) {
            return false;
        }
        return siteParameters.hasParams();
    }

    public SiteParameters getSiteParameters(String site) {
        SiteParameters sps = this.siteParamsMap.get(site);
        if (sps == null) {
            sps = new SiteParameters(this, site);
            this.siteParamsMap.put(site, sps);
        }
        return sps;
    }

    public Collection<SiteParameters> getAllSiteParameters() {
        return this.siteParamsMap.values();
    }

    public void addSessionToken() {
        HtmlParameterStats item = this.getParamsPanel().getSelectedParam();
        if (item != null) {
            ExtensionHttpSessions extSession = this.getExtensionHttpSessions();
            if (extSession != null) {
                extSession.addHttpSessionToken(this.getParamsPanel().getCurrentSite(), item.getName());
            }
            item.addFlag(HtmlParameter.Flags.session.name());
            this.getParamsPanel().getParamsTable().repaint();
        }
    }

    public void removeSessionToken() {
        HtmlParameterStats item = this.getParamsPanel().getSelectedParam();
        if (item != null) {
            ExtensionHttpSessions extSession = this.getExtensionHttpSessions();
            if (extSession != null) {
                extSession.removeHttpSessionToken(this.getParamsPanel().getCurrentSite(), item.getName());
            }
            item.removeFlag(HtmlParameter.Flags.session.name());
            this.getParamsPanel().getParamsTable().repaint();
        }
    }

    public HtmlParameterStats getSelectedParam() {
        return this.getParamsPanel().getSelectedParam();
    }

    @Override
    public void sessionAboutToChange(Session session) {
    }

    @Override
    public void sessionScopeChanged(Session session) {
    }

    @Override
    public String getAuthor() {
        return "ZAP Dev Team";
    }

    @Override
    public String getDescription() {
        return Constant.messages.getString("params.desc");
    }

    @Override
    public URL getURL() {
        try {
            return new URL("http://www.owasp.org/index.php/ZAP");
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    @Override
    public void sessionModeChanged(Control.Mode mode) {
    }
}

