/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.gui.colour;

import java.awt.Color;
import java.util.ArrayList;
import tim.prune.data.DataPoint;
import tim.prune.data.FileInfo;
import tim.prune.data.SourceInfo;
import tim.prune.data.TrackInfo;
import tim.prune.gui.colour.DiscretePointColourer;

public class FileColourer
extends DiscretePointColourer {
    public FileColourer(Color color, Color color2, int n) {
        super(color, color2, n);
    }

    public void calculateColours(TrackInfo trackInfo) {
        int n = trackInfo == null ? 0 : trackInfo.getTrack().getNumPoints();
        this.init(n);
        FileInfo fileInfo = trackInfo.getFileInfo();
        ArrayList<SourceInfo> arrayList = new ArrayList<SourceInfo>();
        int n2 = 0;
        while (n2 < n) {
            DataPoint dataPoint = trackInfo.getTrack().getPoint(n2);
            if (dataPoint != null && !dataPoint.isWaypoint()) {
                SourceInfo sourceInfo = fileInfo.getSourceForPoint(dataPoint);
                int n3 = -1;
                int n4 = 0;
                for (SourceInfo sourceInfo2 : arrayList) {
                    if (sourceInfo2 == sourceInfo) {
                        n3 = n4;
                        break;
                    }
                    ++n4;
                }
                if (n3 < 0) {
                    arrayList.add(sourceInfo);
                    n3 = arrayList.size() - 1;
                }
                this.setColour(n2, n3);
            }
            ++n2;
        }
        this.generateDiscreteColours(arrayList.size());
    }
}

