/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.latest;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.plugins.latest.ArtifactInfo;
import org.apache.ivy.plugins.latest.ComparatorLatestStrategy;
import org.apache.ivy.plugins.version.VersionMatcher;

public class LatestRevisionStrategy
extends ComparatorLatestStrategy {
    private static final Map DEFAULT_SPECIAL_MEANINGS = new HashMap();
    private final Comparator mridComparator = new MridComparator();
    private final Comparator artifactInfoComparator = new ArtifactInfoComparator();
    private Map specialMeanings = null;
    private boolean usedefaultspecialmeanings = true;

    public LatestRevisionStrategy() {
        this.setComparator(this.artifactInfoComparator);
        this.setName("latest-revision");
    }

    public void addConfiguredSpecialMeaning(SpecialMeaning specialMeaning) {
        specialMeaning.validate();
        this.getSpecialMeanings().put(specialMeaning.getName().toLowerCase(Locale.US), specialMeaning.getValue());
    }

    public synchronized Map getSpecialMeanings() {
        if (this.specialMeanings == null) {
            this.specialMeanings = new HashMap();
            if (this.isUsedefaultspecialmeanings()) {
                this.specialMeanings.putAll(DEFAULT_SPECIAL_MEANINGS);
            }
        }
        return this.specialMeanings;
    }

    public boolean isUsedefaultspecialmeanings() {
        return this.usedefaultspecialmeanings;
    }

    public void setUsedefaultspecialmeanings(boolean bl) {
        this.usedefaultspecialmeanings = bl;
    }

    static {
        DEFAULT_SPECIAL_MEANINGS.put("dev", new Integer(-1));
        DEFAULT_SPECIAL_MEANINGS.put("rc", new Integer(1));
        DEFAULT_SPECIAL_MEANINGS.put("final", new Integer(2));
    }

    public static class SpecialMeaning {
        private String name;
        private Integer value;

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public Integer getValue() {
            return this.value;
        }

        public void setValue(Integer n) {
            this.value = n;
        }

        public void validate() {
            if (this.name == null) {
                throw new IllegalStateException("a special meaning should have a name");
            }
            if (this.value == null) {
                throw new IllegalStateException("a special meaning should have a value");
            }
        }
    }

    final class ArtifactInfoComparator
    implements Comparator {
        ArtifactInfoComparator() {
        }

        public int compare(Object object, Object object2) {
            String string = ((ArtifactInfo)object).getRevision();
            String string2 = ((ArtifactInfo)object2).getRevision();
            VersionMatcher versionMatcher = IvyContext.getContext().getSettings().getVersionMatcher();
            ModuleRevisionId moduleRevisionId = ModuleRevisionId.newInstance("", "", string);
            ModuleRevisionId moduleRevisionId2 = ModuleRevisionId.newInstance("", "", string2);
            if (versionMatcher.isDynamic(moduleRevisionId)) {
                int n = versionMatcher.compare(moduleRevisionId, moduleRevisionId2, LatestRevisionStrategy.this.mridComparator);
                return n >= 0 ? 1 : -1;
            }
            if (versionMatcher.isDynamic(moduleRevisionId2)) {
                int n = versionMatcher.compare(moduleRevisionId2, moduleRevisionId, LatestRevisionStrategy.this.mridComparator);
                return n >= 0 ? -1 : 1;
            }
            return LatestRevisionStrategy.this.mridComparator.compare(moduleRevisionId, moduleRevisionId2);
        }
    }

    final class MridComparator
    implements Comparator {
        MridComparator() {
        }

        public int compare(Object object, Object object2) {
            int n;
            String string = ((ModuleRevisionId)object).getRevision();
            String string2 = ((ModuleRevisionId)object2).getRevision();
            string = string.replaceAll("([a-zA-Z])(\\d)", "$1.$2");
            string = string.replaceAll("(\\d)([a-zA-Z])", "$1.$2");
            string2 = string2.replaceAll("([a-zA-Z])(\\d)", "$1.$2");
            string2 = string2.replaceAll("(\\d)([a-zA-Z])", "$1.$2");
            String[] stringArray = string.split("[\\._\\-\\+]");
            String[] stringArray2 = string2.split("[\\._\\-\\+]");
            for (n = 0; n < stringArray.length && n < stringArray2.length; ++n) {
                if (stringArray[n].equals(stringArray2[n])) continue;
                boolean bl = this.isNumber(stringArray[n]);
                boolean bl2 = this.isNumber(stringArray2[n]);
                if (bl && !bl2) {
                    return 1;
                }
                if (bl2 && !bl) {
                    return -1;
                }
                if (bl && bl2) {
                    return Long.valueOf(stringArray[n]).compareTo(Long.valueOf(stringArray2[n]));
                }
                Map map = LatestRevisionStrategy.this.getSpecialMeanings();
                Integer n2 = (Integer)map.get(stringArray[n].toLowerCase(Locale.US));
                Integer n3 = (Integer)map.get(stringArray2[n].toLowerCase(Locale.US));
                if (n2 != null) {
                    n3 = n3 == null ? new Integer(0) : n3;
                    return n2.compareTo(n3);
                }
                if (n3 != null) {
                    return new Integer(0).compareTo(n3);
                }
                return stringArray[n].compareTo(stringArray2[n]);
            }
            if (n < stringArray.length) {
                return this.isNumber(stringArray[n]) ? 1 : -1;
            }
            if (n < stringArray2.length) {
                return this.isNumber(stringArray2[n]) ? -1 : 1;
            }
            return 0;
        }

        private boolean isNumber(String string) {
            return string.matches("\\d+");
        }
    }
}

