/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import javax.media.j3d.CachedTargets;
import javax.media.j3d.NnuId;
import javax.media.j3d.NnuIdManager;

class Targets {
    static final int MAX_NODELIST = 7;
    static final int GEO_TARGETS = 0;
    static final int ENV_TARGETS = 1;
    static final int BEH_TARGETS = 2;
    static final int SND_TARGETS = 3;
    static final int VPF_TARGETS = 4;
    static final int BLN_TARGETS = 5;
    static final int GRP_TARGETS = 6;
    ArrayList<NnuId>[] targetList = new ArrayList[7];

    Targets() {
    }

    void addNode(NnuId nnuId, int n) {
        if (this.targetList[n] == null) {
            this.targetList[n] = new ArrayList(1);
        }
        this.targetList[n].add(nnuId);
    }

    void removeNode(int n, int n2) {
        if (this.targetList[n2] != null) {
            this.targetList[n2].remove(n);
        }
    }

    void addNodes(ArrayList<NnuId> arrayList, int n) {
        if (this.targetList[n] == null) {
            this.targetList[n] = new ArrayList(1);
        }
        this.targetList[n].addAll(arrayList);
    }

    void clearNodes() {
        for (int i = 0; i < 7; ++i) {
            if (this.targetList[i] == null) continue;
            this.targetList[i].clear();
        }
    }

    CachedTargets snapShotInit() {
        CachedTargets cachedTargets = new CachedTargets();
        for (int i = 0; i < 7; ++i) {
            if (this.targetList[i] != null) {
                int n = this.targetList[i].size();
                NnuId[] nnuIdArray = new NnuId[n];
                this.targetList[i].toArray(nnuIdArray);
                cachedTargets.targetArr[i] = nnuIdArray;
                NnuIdManager.sort(cachedTargets.targetArr[i]);
                continue;
            }
            cachedTargets.targetArr[i] = null;
        }
        this.clearNodes();
        return cachedTargets;
    }

    CachedTargets snapShotAdd(CachedTargets cachedTargets) {
        CachedTargets cachedTargets2 = new CachedTargets();
        for (int i = 0; i < 7; ++i) {
            NnuId[] nnuIdArray;
            int n;
            if (this.targetList[i] != null && cachedTargets.targetArr[i] == null) {
                n = this.targetList[i].size();
                nnuIdArray = new NnuId[n];
                this.targetList[i].toArray(nnuIdArray);
                cachedTargets2.targetArr[i] = nnuIdArray;
                NnuIdManager.sort(cachedTargets2.targetArr[i]);
                continue;
            }
            if (this.targetList[i] != null && cachedTargets.targetArr[i] != null) {
                n = this.targetList[i].size();
                nnuIdArray = new NnuId[n];
                this.targetList[i].toArray(nnuIdArray);
                NnuIdManager.sort(nnuIdArray);
                cachedTargets2.targetArr[i] = NnuIdManager.merge(cachedTargets.targetArr[i], nnuIdArray);
                continue;
            }
            if (this.targetList[i] != null || cachedTargets.targetArr[i] == null) continue;
            cachedTargets2.targetArr[i] = cachedTargets.targetArr[i];
        }
        this.clearNodes();
        return cachedTargets2;
    }

    CachedTargets snapShotRemove(CachedTargets cachedTargets) {
        CachedTargets cachedTargets2 = new CachedTargets();
        for (int i = 0; i < 7; ++i) {
            if (this.targetList[i] != null && cachedTargets.targetArr[i] != null) {
                int n = this.targetList[i].size();
                NnuId[] nnuIdArray = new NnuId[n];
                this.targetList[i].toArray(nnuIdArray);
                NnuIdManager.sort(nnuIdArray);
                cachedTargets2.targetArr[i] = NnuIdManager.delete(cachedTargets.targetArr[i], nnuIdArray);
                continue;
            }
            if (this.targetList[i] == null && cachedTargets.targetArr[i] != null) {
                cachedTargets2.targetArr[i] = cachedTargets.targetArr[i];
                continue;
            }
            if (this.targetList[i] == null || cachedTargets.targetArr[i] != null) continue;
            System.err.println("You can't remove something that isn't there");
        }
        this.clearNodes();
        return cachedTargets2;
    }

    boolean isEmpty() {
        boolean bl = true;
        for (int i = 0; i < 7; ++i) {
            if (this.targetList[i] == null) continue;
            bl = false;
            break;
        }
        return bl;
    }

    void dump() {
        for (int i = 0; i < 7; ++i) {
            if (this.targetList[i] == null) continue;
            System.err.println("  " + CachedTargets.typeString[i]);
            for (int j = 0; j < this.targetList[i].size(); ++j) {
                System.err.println("  " + this.targetList[i].get(j));
            }
        }
    }
}

