/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.server;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.lib.profiler.global.CommonConstants;
import org.netbeans.lib.profiler.global.ProfilingSessionStatus;
import org.netbeans.lib.profiler.server.Monitors;
import org.netbeans.lib.profiler.server.ProfilerRuntimeCPU;
import org.netbeans.lib.profiler.server.ProfilerRuntimeCPUCodeRegion;
import org.netbeans.lib.profiler.server.ProfilerRuntimeMemory;
import org.netbeans.lib.profiler.server.ProfilerRuntimeSampler;
import org.netbeans.lib.profiler.server.ProfilerServer;
import org.netbeans.lib.profiler.server.ProfilingPointServerHandler;
import org.netbeans.lib.profiler.server.ThreadInfo;
import org.netbeans.lib.profiler.server.system.Classes;
import org.netbeans.lib.profiler.server.system.Histogram;
import org.netbeans.lib.profiler.server.system.Timers;

public class ProfilerRuntime
implements CommonConstants {
    private static final boolean DEBUG = false;
    protected static ExternalActionsHandler externalActionsHandler;
    protected static boolean lockContentionMonitoringEnabled;
    protected static byte[] eventBuffer;
    protected static int globalEvBufPos;
    protected static int globalEvBufPosThreshold;
    protected static volatile boolean sendingBuffer;
    private static boolean printEvents;
    private static volatile Set knownMonitors;

    public static void createEventBuffer(int n) {
        eventBuffer = new byte[n];
        globalEvBufPosThreshold = n - 51 - 1;
        globalEvBufPos = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpEventBuffer() {
        if (eventBuffer == null) {
            return;
        }
        if (sendingBuffer) {
            return;
        }
        byte[] byArray = eventBuffer;
        synchronized (eventBuffer) {
            sendingBuffer = true;
            ThreadInfo[] threadInfoArray = ThreadInfo.getThreadInfos();
            for (int i = 0; i < threadInfoArray.length; ++i) {
                ThreadInfo threadInfo = threadInfoArray[i];
                if (threadInfo == null || threadInfo.evBuf == null || !threadInfo.isInitialized()) continue;
                int n = threadInfo.evBufPos;
                if (globalEvBufPos + n - threadInfo.evBufDumpLastPos > globalEvBufPosThreshold) break;
                int n2 = n - threadInfo.evBufDumpLastPos;
                if (n2 <= 0) continue;
                ProfilerRuntime.eventBuffer[ProfilerRuntime.globalEvBufPos++] = 13;
                ProfilerRuntime.eventBuffer[ProfilerRuntime.globalEvBufPos++] = (byte)(threadInfo.threadId >> 8 & 0xFF);
                ProfilerRuntime.eventBuffer[ProfilerRuntime.globalEvBufPos++] = (byte)(threadInfo.threadId & 0xFF);
                System.arraycopy(threadInfo.evBuf, threadInfo.evBufDumpLastPos, eventBuffer, globalEvBufPos, n2);
                globalEvBufPos += n2;
                threadInfo.evBufDumpLastPos = n;
            }
            externalActionsHandler.handleEventBufferDump(eventBuffer, 0, globalEvBufPos);
            globalEvBufPos = 0;
            sendingBuffer = false;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected static void copyLocalBuffer(ThreadInfo threadInfo) {
        byte[] byArray;
        long l = 0L;
        long l2 = 0L;
        if (eventBuffer == null) {
            return;
        }
        boolean bl = false;
        if (sendingBuffer) {
            l = Timers.getCurrentTimeInCounts();
            if (ProfilerRuntimeCPU.threadCPUTimerOn) {
                l2 = Timers.getThreadCPUTimeInNanos();
            }
            byArray = eventBuffer;
            // MONITORENTER : eventBuffer
            if (sendingBuffer) {
                System.err.println("*** Sanity check failed - sendingBuffer where should have been already sent");
            }
            bl = true;
            // MONITOREXIT : byArray
        }
        byArray = eventBuffer;
        // MONITORENTER : eventBuffer
        if (!threadInfo.isInitialized()) {
            // MONITOREXIT : byArray
            return;
        }
        int n = threadInfo.evBufPos;
        int n2 = threadInfo.evBufDumpLastPos;
        if (globalEvBufPos + n - n2 > globalEvBufPosThreshold) {
            sendingBuffer = true;
            if (!bl) {
                l = Timers.getCurrentTimeInCounts();
                if (ProfilerRuntimeCPU.threadCPUTimerOn) {
                    l2 = Timers.getThreadCPUTimeInNanos();
                }
                bl = true;
            }
            externalActionsHandler.handleEventBufferDump(eventBuffer, 0, globalEvBufPos);
            globalEvBufPos = 0;
            sendingBuffer = false;
        }
        if (eventBuffer != null) {
            ProfilerRuntime.eventBuffer[ProfilerRuntime.globalEvBufPos++] = 13;
            ProfilerRuntime.eventBuffer[ProfilerRuntime.globalEvBufPos++] = (byte)(threadInfo.threadId >> 8 & 0xFF);
            ProfilerRuntime.eventBuffer[ProfilerRuntime.globalEvBufPos++] = (byte)(threadInfo.threadId & 0xFF);
            System.arraycopy(threadInfo.evBuf, n2, eventBuffer, globalEvBufPos, n - n2);
            globalEvBufPos += n - n2;
            threadInfo.evBufPos = 0;
            threadInfo.evBufDumpLastPos = 0;
            if (bl) {
                ProfilerRuntime.writeAdjustTimeEvent(threadInfo, l, l2);
            }
        }
        // MONITOREXIT : byArray
    }

    public static void init(ExternalActionsHandler externalActionsHandler) {
        ProfilerRuntime.externalActionsHandler = externalActionsHandler;
    }

    public static void setLockContentionMonitoringEnabled(boolean bl) {
        lockContentionMonitoringEnabled = bl;
        knownMonitors = bl ? new HashSet() : null;
        Classes.setLockContentionMonitoringEnabled((boolean)bl);
    }

    public static void monitorEntry(Thread thread, Object object, Thread thread2) {
        ThreadInfo threadInfo;
        if (ThreadInfo.profilingSuspended() || ThreadInfo.isProfilerServerThread(thread) || ThreadInfo.isProfilerServerMonitor(object)) {
            return;
        }
        long l = -1L;
        ThreadInfo threadInfo2 = ThreadInfo.getThreadInfo(thread);
        if (threadInfo2.inProfilingRuntimeMethod > 0) {
            return;
        }
        ++threadInfo2.inProfilingRuntimeMethod;
        ProfilingSessionStatus profilingSessionStatus = ProfilerServer.getProfilingSessionStatus();
        ThreadInfo threadInfo3 = threadInfo = thread2 != null ? ThreadInfo.getThreadInfo(thread2) : null;
        if (profilingSessionStatus != null) {
            switch (profilingSessionStatus.currentInstrType) {
                case 3: 
                case 4: {
                    l = ProfilerRuntimeCPU.monitorEntryCPU(threadInfo2, object, threadInfo);
                    break;
                }
                case 1: {
                    l = ProfilerRuntimeCPUCodeRegion.monitorEntryRegion(thread, object, threadInfo);
                }
            }
        }
        if (lockContentionMonitoringEnabled && l == -1L) {
            ProfilerRuntime.writeWaitTimeEvent((byte)22, threadInfo2, object, threadInfo);
        }
        Monitors.recordThreadStateChange(threadInfo2.thread, (byte)3, l, object);
        --threadInfo2.inProfilingRuntimeMethod;
    }

    public static void monitorExit(Thread thread, Object object) {
        if (ThreadInfo.profilingSuspended() || ThreadInfo.isProfilerServerThread(thread) || ThreadInfo.isProfilerServerMonitor(object)) {
            return;
        }
        long l = -1L;
        ThreadInfo threadInfo = ThreadInfo.getThreadInfo(thread);
        if (threadInfo.inProfilingRuntimeMethod > 0) {
            return;
        }
        ++threadInfo.inProfilingRuntimeMethod;
        ProfilingSessionStatus profilingSessionStatus = ProfilerServer.getProfilingSessionStatus();
        if (profilingSessionStatus != null) {
            switch (profilingSessionStatus.currentInstrType) {
                case 3: 
                case 4: {
                    l = ProfilerRuntimeCPU.monitorExitCPU(threadInfo, object);
                    break;
                }
                case 1: {
                    l = ProfilerRuntimeCPUCodeRegion.monitorExitRegion(thread, object);
                }
            }
        }
        if (lockContentionMonitoringEnabled && l == -1L) {
            ProfilerRuntime.writeWaitTimeEvent((byte)23, threadInfo, object);
        }
        Monitors.recordThreadStateChange(threadInfo.thread, (byte)1, l, null);
        --threadInfo.inProfilingRuntimeMethod;
    }

    public static void sleepEntry() {
        if (ThreadInfo.profilingSuspended() || ThreadInfo.isCurrentThreadProfilerServerThread()) {
            return;
        }
        long l = -1L;
        ThreadInfo threadInfo = ThreadInfo.getThreadInfo();
        if (threadInfo.inProfilingRuntimeMethod > 0) {
            return;
        }
        ++threadInfo.inProfilingRuntimeMethod;
        ProfilingSessionStatus profilingSessionStatus = ProfilerServer.getProfilingSessionStatus();
        if (profilingSessionStatus != null) {
            switch (profilingSessionStatus.currentInstrType) {
                case 3: 
                case 4: {
                    l = ProfilerRuntimeCPU.sleepEntryCPU(threadInfo);
                    break;
                }
                case 1: {
                    ProfilerRuntimeCPUCodeRegion.sleepEntryRegion();
                }
            }
        }
        Monitors.recordThreadStateChange(threadInfo.thread, (byte)2, l, null);
        --threadInfo.inProfilingRuntimeMethod;
    }

    public static void sleepExit() {
        if (ThreadInfo.profilingSuspended() || ThreadInfo.isCurrentThreadProfilerServerThread()) {
            return;
        }
        long l = -1L;
        ThreadInfo threadInfo = ThreadInfo.getThreadInfo();
        if (threadInfo.inProfilingRuntimeMethod > 0) {
            return;
        }
        ++threadInfo.inProfilingRuntimeMethod;
        ProfilingSessionStatus profilingSessionStatus = ProfilerServer.getProfilingSessionStatus();
        if (profilingSessionStatus != null) {
            switch (profilingSessionStatus.currentInstrType) {
                case 3: 
                case 4: {
                    l = ProfilerRuntimeCPU.sleepExitCPU(threadInfo);
                    break;
                }
                case 1: {
                    ProfilerRuntimeCPUCodeRegion.sleepExitRegion();
                }
            }
        }
        Monitors.recordThreadStateChange(threadInfo.thread, (byte)1, l, null);
        --threadInfo.inProfilingRuntimeMethod;
    }

    public static void waitEntry() {
        if (ThreadInfo.profilingSuspended() || ThreadInfo.isCurrentThreadProfilerServerThread()) {
            return;
        }
        long l = -1L;
        ThreadInfo threadInfo = ThreadInfo.getThreadInfo();
        if (threadInfo.inProfilingRuntimeMethod > 0) {
            return;
        }
        ++threadInfo.inProfilingRuntimeMethod;
        ProfilingSessionStatus profilingSessionStatus = ProfilerServer.getProfilingSessionStatus();
        if (profilingSessionStatus != null) {
            switch (profilingSessionStatus.currentInstrType) {
                case 3: 
                case 4: {
                    l = ProfilerRuntimeCPU.waitEntryCPU(threadInfo);
                    break;
                }
                case 1: {
                    ProfilerRuntimeCPUCodeRegion.waitEntryRegion();
                }
            }
        }
        Monitors.recordThreadStateChange(threadInfo.thread, (byte)4, l, null);
        --threadInfo.inProfilingRuntimeMethod;
    }

    public static void waitExit() {
        if (ThreadInfo.profilingSuspended() || ThreadInfo.isCurrentThreadProfilerServerThread()) {
            return;
        }
        long l = -1L;
        ThreadInfo threadInfo = ThreadInfo.getThreadInfo();
        if (threadInfo.inProfilingRuntimeMethod > 0) {
            return;
        }
        ++threadInfo.inProfilingRuntimeMethod;
        ProfilingSessionStatus profilingSessionStatus = ProfilerServer.getProfilingSessionStatus();
        if (profilingSessionStatus != null) {
            switch (profilingSessionStatus.currentInstrType) {
                case 3: 
                case 4: {
                    l = ProfilerRuntimeCPU.waitExitCPU(threadInfo);
                    break;
                }
                case 1: {
                    ProfilerRuntimeCPUCodeRegion.waitExitRegion();
                }
            }
        }
        Monitors.recordThreadStateChange(threadInfo.thread, (byte)1, l, null);
        --threadInfo.inProfilingRuntimeMethod;
    }

    public static void parkEntry() {
        if (ThreadInfo.profilingSuspended() || ThreadInfo.isCurrentThreadProfilerServerThread()) {
            return;
        }
        long l = -1L;
        ThreadInfo threadInfo = ThreadInfo.getThreadInfo();
        if (threadInfo.inProfilingRuntimeMethod > 0) {
            return;
        }
        ++threadInfo.inProfilingRuntimeMethod;
        ProfilingSessionStatus profilingSessionStatus = ProfilerServer.getProfilingSessionStatus();
        if (profilingSessionStatus != null) {
            switch (profilingSessionStatus.currentInstrType) {
                case 3: 
                case 4: {
                    l = ProfilerRuntimeCPU.parkEntryCPU(threadInfo);
                    break;
                }
                case 1: {
                    ProfilerRuntimeCPUCodeRegion.parkEntryRegion();
                }
            }
        }
        Monitors.recordThreadStateChange(threadInfo.thread, (byte)5, l, null);
        --threadInfo.inProfilingRuntimeMethod;
    }

    public static void parkExit() {
        if (ThreadInfo.profilingSuspended() || ThreadInfo.isCurrentThreadProfilerServerThread()) {
            return;
        }
        long l = -1L;
        ThreadInfo threadInfo = ThreadInfo.getThreadInfo();
        if (threadInfo.inProfilingRuntimeMethod > 0) {
            return;
        }
        ++threadInfo.inProfilingRuntimeMethod;
        ProfilingSessionStatus profilingSessionStatus = ProfilerServer.getProfilingSessionStatus();
        if (profilingSessionStatus != null) {
            switch (profilingSessionStatus.currentInstrType) {
                case 3: 
                case 4: {
                    l = ProfilerRuntimeCPU.parkExitCPU(threadInfo);
                    break;
                }
                case 1: {
                    ProfilerRuntimeCPUCodeRegion.parkExitRegion();
                }
            }
        }
        Monitors.recordThreadStateChange(threadInfo.thread, (byte)1, l, null);
        --threadInfo.inProfilingRuntimeMethod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetProfilerCollectors(int n) {
        if (n != 1 && eventBuffer != null) {
            byte[] byArray = eventBuffer;
            synchronized (eventBuffer) {
                ProfilerRuntime.doResetProfilerCollectors(n);
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
        } else {
            ProfilerRuntime.doResetProfilerCollectors(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeProfilingPointHitEvent(int n, long l) {
        ThreadInfo threadInfo = ThreadInfo.getThreadInfo();
        int n2 = threadInfo.threadId;
        if (threadInfo.evBuf == null || !threadInfo.isInitialized()) {
            byte[] byArray = eventBuffer;
            synchronized (eventBuffer) {
                int n3 = globalEvBufPos;
                if (n3 > globalEvBufPosThreshold) {
                    ProfilerRuntime.dumpEventBuffer();
                    n3 = 0;
                }
                globalEvBufPos = n3 = ProfilerRuntime.writePPointHitToBuffer(eventBuffer, l, n3, n, n2);
                // ** MonitorExit[var5_4] (shouldn't be in output)
            }
        } else {
            int n4 = threadInfo.evBufPos;
            if (n4 > ThreadInfo.evBufPosThreshold) {
                ProfilerRuntimeCPU.copyLocalBuffer(threadInfo);
                n4 = threadInfo.evBufPos;
            }
            byte[] byArray = threadInfo.evBuf;
            threadInfo.evBufPos = ProfilerRuntime.writePPointHitToBuffer(byArray, l, n4, n, n2);
        }
    }

    public static void profilePointHit(char c) {
        if (ThreadInfo.profilingSuspended() || ThreadInfo.isCurrentThreadProfilerServerThread()) {
            return;
        }
        if (eventBuffer == null) {
            return;
        }
        ThreadInfo threadInfo = ThreadInfo.getThreadInfo();
        if (threadInfo.inProfilingRuntimeMethod > 0) {
            return;
        }
        ++threadInfo.inProfilingRuntimeMethod;
        ProfilingPointServerHandler profilingPointServerHandler = ProfilingPointServerHandler.getHandler(c);
        if (profilingPointServerHandler != null) {
            try {
                profilingPointServerHandler.profilingPointHit(c);
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
        }
        --threadInfo.inProfilingRuntimeMethod;
    }

    static void writeThreadCreationEvent(ThreadInfo threadInfo) {
        ProfilerRuntime.writeThreadCreationEvent(threadInfo.thread, threadInfo.getThreadId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void writeThreadCreationEvent(Thread thread, int n) {
        String string;
        String string2 = thread.getClass().getName();
        try {
            string = thread.getName();
        }
        catch (NullPointerException nullPointerException) {
            string = "*Unknown thread (" + n + ")*";
        }
        int n2 = (string.length() + string2.length()) * 2 + 7;
        byte[] byArray = eventBuffer;
        synchronized (eventBuffer) {
            if (globalEvBufPos + n2 > globalEvBufPosThreshold) {
                sendingBuffer = true;
                externalActionsHandler.handleEventBufferDump(eventBuffer, 0, globalEvBufPos);
                globalEvBufPos = 0;
                sendingBuffer = false;
            }
            ProfilerRuntime.eventBuffer[ProfilerRuntime.globalEvBufPos++] = 11;
            ProfilerRuntime.eventBuffer[ProfilerRuntime.globalEvBufPos++] = (byte)(n >> 8 & 0xFF);
            ProfilerRuntime.eventBuffer[ProfilerRuntime.globalEvBufPos++] = (byte)(n & 0xFF);
            byte[] byArray2 = string.getBytes();
            int n3 = byArray2.length;
            ProfilerRuntime.eventBuffer[ProfilerRuntime.globalEvBufPos++] = (byte)(n3 >> 8 & 0xFF);
            ProfilerRuntime.eventBuffer[ProfilerRuntime.globalEvBufPos++] = (byte)(n3 & 0xFF);
            System.arraycopy(byArray2, 0, eventBuffer, globalEvBufPos, n3);
            globalEvBufPos += n3;
            byArray2 = string2.getBytes();
            n3 = byArray2.length;
            ProfilerRuntime.eventBuffer[ProfilerRuntime.globalEvBufPos++] = (byte)(n3 >> 8 & 0xFF);
            ProfilerRuntime.eventBuffer[ProfilerRuntime.globalEvBufPos++] = (byte)(n3 & 0xFF);
            System.arraycopy(byArray2, 0, eventBuffer, globalEvBufPos, n3);
            globalEvBufPos += n3;
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    static void writeAdjustTimeEvent(ThreadInfo threadInfo, long l, long l2) {
        byte[] byArray = threadInfo.evBuf;
        int n = threadInfo.evBufPos;
        if (n > ThreadInfo.evBufPosThreshold) {
            if (eventBuffer == null) {
                return;
            }
            byte[] byArray2 = eventBuffer;
            // MONITORENTER : eventBuffer
            n = threadInfo.evBufPos;
            boolean bl = false;
            int n2 = threadInfo.evBufDumpLastPos;
            if (globalEvBufPos + n - n2 > globalEvBufPosThreshold) {
                bl = true;
                sendingBuffer = true;
                externalActionsHandler.handleEventBufferDump(eventBuffer, 0, globalEvBufPos);
                globalEvBufPos = 0;
                sendingBuffer = false;
            }
            ProfilerRuntime.eventBuffer[ProfilerRuntime.globalEvBufPos++] = 13;
            ProfilerRuntime.eventBuffer[ProfilerRuntime.globalEvBufPos++] = (byte)(threadInfo.threadId >> 8 & 0xFF);
            ProfilerRuntime.eventBuffer[ProfilerRuntime.globalEvBufPos++] = (byte)(threadInfo.threadId & 0xFF);
            System.arraycopy(byArray, n2, eventBuffer, globalEvBufPos, n - n2);
            globalEvBufPos += n - n2;
            threadInfo.evBufPos = 0;
            threadInfo.evBufDumpLastPos = 0;
            // MONITOREXIT : byArray2
        }
        n = threadInfo.evBufPos;
        byArray[n++] = 5;
        long l3 = Timers.getCurrentTimeInCounts() - l;
        byArray[n++] = (byte)(l3 >> 48 & 0xFFL);
        byArray[n++] = (byte)(l3 >> 40 & 0xFFL);
        byArray[n++] = (byte)(l3 >> 32 & 0xFFL);
        byArray[n++] = (byte)(l3 >> 24 & 0xFFL);
        byArray[n++] = (byte)(l3 >> 16 & 0xFFL);
        byArray[n++] = (byte)(l3 >> 8 & 0xFFL);
        byArray[n++] = (byte)(l3 & 0xFFL);
        if (ProfilerRuntimeCPU.threadCPUTimerOn) {
            long l4 = Timers.getThreadCPUTimeInNanos() - l2;
            byArray[n++] = (byte)(l4 >> 48 & 0xFFL);
            byArray[n++] = (byte)(l4 >> 40 & 0xFFL);
            byArray[n++] = (byte)(l4 >> 32 & 0xFFL);
            byArray[n++] = (byte)(l4 >> 24 & 0xFFL);
            byArray[n++] = (byte)(l4 >> 16 & 0xFFL);
            byArray[n++] = (byte)(l4 >> 8 & 0xFFL);
            byArray[n++] = (byte)(l4 & 0xFFL);
        }
        threadInfo.evBufPos = n;
    }

    static long writeWaitTimeEvent(byte by, ThreadInfo threadInfo, Object object) {
        return ProfilerRuntime.writeWaitTimeEvent(by, threadInfo, object, null);
    }

    static long writeWaitTimeEvent(byte by, ThreadInfo threadInfo, Object object, ThreadInfo threadInfo2) {
        int n;
        if (eventBuffer == null) {
            return -1L;
        }
        int n2 = ProfilerRuntime.writeNewMonitorEvent(threadInfo, object);
        if (threadInfo2 != null) {
            ProfilerRuntime.initThreadInfo(threadInfo2);
        }
        if ((n = threadInfo.evBufPos) > ThreadInfo.evBufPosThreshold) {
            ProfilerRuntime.copyLocalBuffer(threadInfo);
            n = threadInfo.evBufPos;
        }
        byte[] byArray = threadInfo.evBuf;
        byArray[n++] = by;
        long l = Timers.getCurrentTimeInCounts();
        byArray[n++] = (byte)(l >> 48 & 0xFFL);
        byArray[n++] = (byte)(l >> 40 & 0xFFL);
        byArray[n++] = (byte)(l >> 32 & 0xFFL);
        byArray[n++] = (byte)(l >> 24 & 0xFFL);
        byArray[n++] = (byte)(l >> 16 & 0xFFL);
        byArray[n++] = (byte)(l >> 8 & 0xFFL);
        byArray[n++] = (byte)(l & 0xFFL);
        if (n2 != -1) {
            byArray[n++] = (byte)(n2 >> 24 & 0xFF);
            byArray[n++] = (byte)(n2 >> 16 & 0xFF);
            byArray[n++] = (byte)(n2 >> 8 & 0xFF);
            byArray[n++] = (byte)(n2 & 0xFF);
            if (by == 22) {
                int n3 = -1;
                if (threadInfo2 != null) {
                    n3 = threadInfo2.getThreadId();
                }
                byArray[n++] = (byte)(n3 >> 24 & 0xFF);
                byArray[n++] = (byte)(n3 >> 16 & 0xFF);
                byArray[n++] = (byte)(n3 >> 8 & 0xFF);
                byArray[n++] = (byte)(n3 & 0xFF);
            }
        }
        threadInfo.evBufPos = n;
        return l;
    }

    private static int writeNewMonitorEvent(ThreadInfo threadInfo, Object object) {
        if (object == null || !lockContentionMonitoringEnabled) {
            return -1;
        }
        ProfilerRuntime.initThreadInfo(threadInfo);
        int n = System.identityHashCode(object);
        Integer n2 = new Integer(n);
        if (knownMonitors.add(n2)) {
            int n3 = threadInfo.evBufPos;
            if (n3 > ThreadInfo.evBufPosThreshold) {
                ProfilerRuntime.copyLocalBuffer(threadInfo);
                n3 = threadInfo.evBufPos;
            }
            byte[] byArray = threadInfo.evBuf;
            byArray[n3++] = 28;
            byArray[n3++] = (byte)(n >> 24 & 0xFF);
            byArray[n3++] = (byte)(n >> 16 & 0xFF);
            byArray[n3++] = (byte)(n >> 8 & 0xFF);
            byArray[n3++] = (byte)(n & 0xFF);
            byte[] byArray2 = object.getClass().getName().getBytes();
            int n4 = byArray2.length;
            byArray[n3++] = (byte)(n4 >> 8 & 0xFF);
            byArray[n3++] = (byte)(n4 & 0xFF);
            System.arraycopy(byArray2, 0, byArray, n3, n4);
            threadInfo.evBufPos = n3 += n4;
        }
        return n;
    }

    private static void initThreadInfo(ThreadInfo threadInfo) {
        if (!threadInfo.isInitialized()) {
            threadInfo.initialize();
            threadInfo.useEventBuffer();
            ProfilerRuntime.writeThreadCreationEvent(threadInfo);
        } else if (threadInfo.evBuf == null) {
            threadInfo.useEventBuffer();
        }
    }

    public static boolean profiledTargetAppThreadsExist() {
        return ThreadInfo.getNProfiledAppThreads() > 0;
    }

    protected static void changeAllThreadsInProfRuntimeMethodStatus(int n) {
        ThreadInfo.changeAllThreadsInProfRuntimeMethodStatus(n);
    }

    protected static void clearDataStructures() {
        eventBuffer = null;
        globalEvBufPos = 0;
        ThreadInfo.resetThreadInfoTable();
        knownMonitors = new HashSet();
    }

    protected static void createNewDataStructures() {
        ThreadInfo.resetThreadInfoTable();
    }

    private static void doResetProfilerCollectors(int n) {
        ThreadInfo.resetThreadInfoTable();
        globalEvBufPos = 0;
        knownMonitors = new HashSet();
        if (eventBuffer != null) {
            ProfilerRuntime.eventBuffer[ProfilerRuntime.globalEvBufPos++] = 10;
        }
        switch (n) {
            case 3: 
            case 4: {
                ProfilerRuntimeCPU.resetProfilerCollectors();
                break;
            }
            case 2: {
                ProfilerRuntimeSampler.resetProfilerCollectors();
                break;
            }
            case 1: {
                ProfilerRuntimeCPUCodeRegion.resetProfilerCollectors();
                break;
            }
            case 5: 
            case 6: {
                ProfilerRuntimeMemory.resetProfilerCollectors(n);
                break;
            }
            case 7: {
                if (!Histogram.isAvailable()) break;
                ProfilerServer.notifyClientOnResultsAvailability();
            }
        }
    }

    private static int writePPointHitToBuffer(byte[] byArray, long l, int n, int n2, int n3) {
        byArray[n++] = 29;
        byArray[n++] = (byte)(n2 >> 8 & 0xFF);
        byArray[n++] = (byte)(n2 & 0xFF);
        byArray[n++] = (byte)(l >> 48 & 0xFFL);
        byArray[n++] = (byte)(l >> 40 & 0xFFL);
        byArray[n++] = (byte)(l >> 32 & 0xFFL);
        byArray[n++] = (byte)(l >> 24 & 0xFFL);
        byArray[n++] = (byte)(l >> 16 & 0xFFL);
        byArray[n++] = (byte)(l >> 8 & 0xFFL);
        byArray[n++] = (byte)(l & 0xFFL);
        byArray[n++] = (byte)(n3 >> 8 & 0xFF);
        byArray[n++] = (byte)(n3 & 0xFF);
        return n;
    }

    public static interface ExternalActionsHandler {
        public void handleEventBufferDump(byte[] var1, int var2, int var3);

        public void handleFirstTimeMethodInvoke(char var1);

        public int handleFirstTimeVMObjectAlloc(String var1, int var2);

        public void handleReflectiveInvoke(Method var1);
    }
}

