/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.NonCollectingAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.IncludeExclude;
import org.elasticsearch.search.aggregations.bucket.terms.LongRareTermsAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.StringRareTermsAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.UnmappedRareTerms;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.internal.SearchContext;

public class RareTermsAggregatorFactory
extends ValuesSourceAggregatorFactory<ValuesSource> {
    private final IncludeExclude includeExclude;
    private final int maxDocCount;
    private final double precision;

    RareTermsAggregatorFactory(String name, ValuesSourceConfig<ValuesSource> config, IncludeExclude includeExclude, QueryShardContext queryShardContext, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metaData, int maxDocCount, double precision) throws IOException {
        super(name, config, queryShardContext, parent, subFactoriesBuilder, metaData);
        this.includeExclude = includeExclude;
        this.maxDocCount = maxDocCount;
        this.precision = precision;
    }

    @Override
    protected Aggregator createUnmapped(SearchContext searchContext, Aggregator parent, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        final UnmappedRareTerms aggregation = new UnmappedRareTerms(this.name, pipelineAggregators, metaData);
        return new NonCollectingAggregator(this.name, searchContext, parent, this.factories, pipelineAggregators, metaData){

            @Override
            public InternalAggregation buildEmptyAggregation() {
                return aggregation;
            }
        };
    }

    @Override
    protected Aggregator doCreateInternal(ValuesSource valuesSource, SearchContext searchContext, Aggregator parent, boolean collectsFromSingleBucket, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        if (!collectsFromSingleBucket) {
            return RareTermsAggregatorFactory.asMultiBucketAggregator(this, searchContext, parent);
        }
        if (valuesSource instanceof ValuesSource.Bytes) {
            ExecutionMode execution = ExecutionMode.MAP;
            DocValueFormat format = this.config.format();
            if (this.includeExclude != null && this.includeExclude.isRegexBased() && format != DocValueFormat.RAW) {
                throw new AggregationExecutionException("Aggregation [" + this.name + "] cannot support regular expression style include/exclude settings as they can only be applied to string fields. Use an array of values for include/exclude clauses");
            }
            return execution.create(this.name, this.factories, valuesSource, format, this.includeExclude, searchContext, parent, pipelineAggregators, metaData, this.maxDocCount, this.precision);
        }
        if (this.includeExclude != null && this.includeExclude.isRegexBased()) {
            throw new AggregationExecutionException("Aggregation [" + this.name + "] cannot support regular expression style include/exclude settings as they can only be applied to string fields. Use an array of numeric values for include/exclude clauses used to filter numeric fields");
        }
        if (valuesSource instanceof ValuesSource.Numeric) {
            IncludeExclude.LongFilter longFilter = null;
            if (((ValuesSource.Numeric)valuesSource).isFloatingPoint()) {
                throw new AggregationExecutionException("RareTerms aggregation does not support floating point fields.");
            }
            if (this.includeExclude != null) {
                longFilter = this.includeExclude.convertToLongFilter(this.config.format());
            }
            return new LongRareTermsAggregator(this.name, this.factories, (ValuesSource.Numeric)valuesSource, this.config.format(), searchContext, parent, longFilter, this.maxDocCount, this.precision, pipelineAggregators, metaData);
        }
        throw new AggregationExecutionException("RareTerms aggregation cannot be applied to field [" + this.config.fieldContext().field() + "]. It can only be applied to numeric or string fields.");
    }

    public static enum ExecutionMode {
        MAP(new ParseField("map", new String[0])){

            @Override
            Aggregator create(String name, AggregatorFactories factories, ValuesSource valuesSource, DocValueFormat format, IncludeExclude includeExclude, SearchContext context, Aggregator parent, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData, long maxDocCount, double precision) throws IOException {
                IncludeExclude.StringFilter filter = includeExclude == null ? null : includeExclude.convertToStringFilter(format);
                return new StringRareTermsAggregator(name, factories, (ValuesSource.Bytes)valuesSource, format, filter, context, parent, pipelineAggregators, metaData, maxDocCount, precision);
            }

            @Override
            boolean needsGlobalOrdinals() {
                return false;
            }
        };

        private final ParseField parseField;

        public static ExecutionMode fromString(String value, DeprecationLogger deprecationLogger) {
            switch (value) {
                case "map": {
                    return MAP;
                }
            }
            throw new IllegalArgumentException("Unknown `execution_hint`: [" + value + "], expected any of [map]");
        }

        private ExecutionMode(ParseField parseField) {
            this.parseField = parseField;
        }

        abstract Aggregator create(String var1, AggregatorFactories var2, ValuesSource var3, DocValueFormat var4, IncludeExclude var5, SearchContext var6, Aggregator var7, List<PipelineAggregator> var8, Map<String, Object> var9, long var10, double var12) throws IOException;

        abstract boolean needsGlobalOrdinals();

        public String toString() {
            return this.parseField.getPreferredName();
        }
    }
}

