/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.components;

import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptorWithTypeParameters;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilder;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilderKt;
import org.jetbrains.kotlin.resolve.calls.inference.components.NewTypeSubstitutor;
import org.jetbrains.kotlin.resolve.calls.inference.model.ArgumentConstraintPosition;
import org.jetbrains.kotlin.resolve.calls.inference.model.ConstraintPosition;
import org.jetbrains.kotlin.resolve.calls.inference.model.ReceiverConstraintPosition;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentTypeMismatchDiagnostic;
import org.jetbrains.kotlin.resolve.calls.model.ExpressionKotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallDiagnostic;
import org.jetbrains.kotlin.resolve.calls.model.KotlinDiagnosticsHolder;
import org.jetbrains.kotlin.resolve.calls.model.PartialCallResolutionResult;
import org.jetbrains.kotlin.resolve.calls.model.ResolutionCandidateKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedAtom;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedExpressionAtom;
import org.jetbrains.kotlin.resolve.calls.model.SimpleKotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.SubKotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.UnsafeCallError;
import org.jetbrains.kotlin.resolve.calls.model.UnstableSmartCast;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.NotNullTypeVariable;
import org.jetbrains.kotlin.types.SpecialTypesKt;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.checker.NewCapturedTypeKt;
import org.jetbrains.kotlin.types.checker.NewKotlinTypeCheckerKt;
import org.jetbrains.kotlin.types.model.TypeSubstitutorMarker;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0001H\u0002\u001a2\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\u0003\u001a\u0004\u0018\u00010\u00012\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u001a0\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0003\u001a\u0004\u0018\u00010\u00012\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u001a2\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0003\u001a\u0004\u0018\u00010\u00012\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u0014"}, d2={"captureFromTypeParameterUpperBoundIfNeeded", "Lorg/jetbrains/kotlin/types/UnwrappedType;", "argumentType", "expectedType", "checkExpressionArgument", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedAtom;", "csBuilder", "Lorg/jetbrains/kotlin/resolve/calls/inference/ConstraintSystemBuilder;", "expressionArgument", "Lorg/jetbrains/kotlin/resolve/calls/model/ExpressionKotlinCallArgument;", "diagnosticsHolder", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinDiagnosticsHolder;", "isReceiver", "", "checkSimpleArgument", "argument", "Lorg/jetbrains/kotlin/resolve/calls/model/SimpleKotlinCallArgument;", "checkSubCallArgument", "subCallArgument", "Lorg/jetbrains/kotlin/resolve/calls/model/SubKotlinCallArgument;", "resolution"})
public final class SimpleArgumentsChecksKt {
    @NotNull
    public static final ResolvedAtom checkSimpleArgument(@NotNull ConstraintSystemBuilder csBuilder, @NotNull SimpleKotlinCallArgument argument, @Nullable UnwrappedType expectedType, @NotNull KotlinDiagnosticsHolder diagnosticsHolder, boolean isReceiver) {
        ResolvedAtom resolvedAtom;
        Intrinsics.checkParameterIsNotNull(csBuilder, "csBuilder");
        Intrinsics.checkParameterIsNotNull(argument, "argument");
        Intrinsics.checkParameterIsNotNull(diagnosticsHolder, "diagnosticsHolder");
        SimpleKotlinCallArgument simpleKotlinCallArgument = argument;
        if (simpleKotlinCallArgument instanceof ExpressionKotlinCallArgument) {
            resolvedAtom = SimpleArgumentsChecksKt.checkExpressionArgument(csBuilder, (ExpressionKotlinCallArgument)argument, expectedType, diagnosticsHolder, isReceiver);
        } else if (simpleKotlinCallArgument instanceof SubKotlinCallArgument) {
            resolvedAtom = SimpleArgumentsChecksKt.checkSubCallArgument(csBuilder, (SubKotlinCallArgument)argument, expectedType, diagnosticsHolder, isReceiver);
        } else {
            Void void_ = ArgumentsUtilsKt.unexpectedArgument(argument);
            throw null;
        }
        return resolvedAtom;
    }

    private static final ResolvedAtom checkExpressionArgument(ConstraintSystemBuilder csBuilder, ExpressionKotlinCallArgument expressionArgument, UnwrappedType expectedType, KotlinDiagnosticsHolder diagnosticsHolder, boolean isReceiver) {
        ConstraintPosition position;
        ResolvedExpressionAtom resolvedExpression = new ResolvedExpressionAtom(expressionArgument);
        if (expectedType == null) {
            return resolvedExpression;
        }
        UnwrappedType argumentType = SimpleArgumentsChecksKt.captureFromTypeParameterUpperBoundIfNeeded(ArgumentsUtilsKt.getStableType(expressionArgument.getReceiver()), expectedType);
        Function3<UnwrappedType, UnwrappedType, ConstraintPosition, KotlinCallDiagnostic> $fun$unstableSmartCastOrSubtypeError$1 = new Function3<UnwrappedType, UnwrappedType, ConstraintPosition, KotlinCallDiagnostic>(csBuilder, expressionArgument, argumentType){
            final /* synthetic */ ConstraintSystemBuilder $csBuilder;
            final /* synthetic */ ExpressionKotlinCallArgument $expressionArgument;
            final /* synthetic */ UnwrappedType $argumentType;

            @Nullable
            public final KotlinCallDiagnostic invoke(@Nullable UnwrappedType unstableType, @NotNull UnwrappedType actualExpectedType, @NotNull ConstraintPosition position) {
                Intrinsics.checkParameterIsNotNull(actualExpectedType, "actualExpectedType");
                Intrinsics.checkParameterIsNotNull(position, "position");
                if (unstableType != null && ConstraintSystemBuilderKt.addSubtypeConstraintIfCompatible(this.$csBuilder, unstableType, actualExpectedType, position)) {
                    return new UnstableSmartCast(this.$expressionArgument, unstableType);
                }
                if (this.$argumentType.isMarkedNullable()) {
                    if (ConstraintSystemBuilderKt.addSubtypeConstraintIfCompatible(this.$csBuilder, this.$argumentType, actualExpectedType, position)) {
                        return null;
                    }
                    if (ConstraintSystemBuilderKt.addSubtypeConstraintIfCompatible(this.$csBuilder, TypeUtilsKt.makeNotNullable(this.$argumentType), actualExpectedType, position)) {
                        return new ArgumentTypeMismatchDiagnostic(actualExpectedType, this.$argumentType, this.$expressionArgument);
                    }
                }
                this.$csBuilder.addSubtypeConstraint(this.$argumentType, actualExpectedType, position);
                return null;
            }
            {
                this.$csBuilder = constraintSystemBuilder;
                this.$expressionArgument = expressionKotlinCallArgument;
                this.$argumentType = unwrappedType;
                super(3);
            }
        };
        ConstraintPosition constraintPosition = position = isReceiver ? (ConstraintPosition)new ReceiverConstraintPosition(expressionArgument) : (ConstraintPosition)new ArgumentConstraintPosition(expressionArgument);
        if (expectedType instanceof NotNullTypeVariable && argumentType.isMarkedNullable()) {
            diagnosticsHolder.addDiagnostic(new ArgumentTypeMismatchDiagnostic(expectedType, argumentType, expressionArgument));
        }
        if (expressionArgument.isSafeCall()) {
            UnwrappedType expectedNullableType = expectedType.makeNullableAsSpecified(true);
            if (!ConstraintSystemBuilderKt.addSubtypeConstraintIfCompatible(csBuilder, argumentType, expectedNullableType, position)) {
                ResolutionCandidateKt.addDiagnosticIfNotNull(diagnosticsHolder, $fun$unstableSmartCastOrSubtypeError$1.invoke(ArgumentsUtilsKt.getUnstableType(expressionArgument.getReceiver()), expectedNullableType, position));
            }
            return resolvedExpression;
        }
        if (!ConstraintSystemBuilderKt.addSubtypeConstraintIfCompatible(csBuilder, argumentType, expectedType, position)) {
            if (!isReceiver) {
                ResolutionCandidateKt.addDiagnosticIfNotNull(diagnosticsHolder, $fun$unstableSmartCastOrSubtypeError$1.invoke(ArgumentsUtilsKt.getUnstableType(expressionArgument.getReceiver()), expectedType, position));
                return resolvedExpression;
            }
            UnwrappedType unstableType = ArgumentsUtilsKt.getUnstableType(expressionArgument.getReceiver());
            UnwrappedType expectedNullableType = expectedType.makeNullableAsSpecified(true);
            if (unstableType != null && ConstraintSystemBuilderKt.addSubtypeConstraintIfCompatible(csBuilder, unstableType, expectedType, position)) {
                diagnosticsHolder.addDiagnostic(new UnstableSmartCast(expressionArgument, unstableType));
            } else if (ConstraintSystemBuilderKt.addSubtypeConstraintIfCompatible(csBuilder, argumentType, expectedNullableType, position)) {
                diagnosticsHolder.addDiagnostic(new UnsafeCallError(expressionArgument));
            } else {
                csBuilder.addSubtypeConstraint(argumentType, expectedType, position);
            }
        }
        return resolvedExpression;
    }

    private static final UnwrappedType captureFromTypeParameterUpperBoundIfNeeded(UnwrappedType argumentType, UnwrappedType expectedType) {
        TypeConstructor expectedTypeConstructor = FlexibleTypesKt.upperIfFlexible(expectedType).getConstructor();
        if (FlexibleTypesKt.lowerIfFlexible(argumentType).getConstructor().getDeclarationDescriptor() instanceof TypeParameterDescriptor) {
            Object v0;
            block7: {
                Iterable $this$singleOrNull$iv = TypeUtilsKt.supertypes(FlexibleTypesKt.lowerIfFlexible(argumentType));
                boolean $i$f$singleOrNull = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $this$singleOrNull$iv) {
                    KotlinType it = (KotlinType)element$iv;
                    boolean bl = false;
                    if (!(it.getConstructor().getDeclarationDescriptor() instanceof ClassifierDescriptorWithTypeParameters && NewKotlinTypeCheckerKt.hasSupertypeWithGivenTypeConstructor(it.unwrap(), expectedTypeConstructor))) continue;
                    if (found$iv) {
                        v0 = null;
                        break block7;
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                v0 = !found$iv ? null : single$iv;
            }
            KotlinType chosenSupertype = v0;
            if (chosenSupertype != null) {
                UnwrappedType unwrappedType;
                UnwrappedType capturedType = NewCapturedTypeKt.captureFromExpression(chosenSupertype.unwrap());
                if (capturedType != null && SpecialTypesKt.isDefinitelyNotNullType(argumentType)) {
                    unwrappedType = SpecialTypesKt.makeDefinitelyNotNullOrNotNull(capturedType);
                } else {
                    unwrappedType = capturedType;
                    if (unwrappedType == null) {
                        unwrappedType = argumentType;
                    }
                }
                return unwrappedType;
            }
        }
        return argumentType;
    }

    private static final ResolvedAtom checkSubCallArgument(ConstraintSystemBuilder csBuilder, SubKotlinCallArgument subCallArgument, UnwrappedType expectedType, KotlinDiagnosticsHolder diagnosticsHolder, boolean isReceiver) {
        PartialCallResolutionResult subCallResult = subCallArgument.getCallResult();
        if (expectedType == null) {
            return subCallResult;
        }
        UnwrappedType expectedNullableType = expectedType.makeNullableAsSpecified(true);
        ConstraintPosition position = isReceiver ? (ConstraintPosition)new ReceiverConstraintPosition(subCallArgument) : (ConstraintPosition)new ArgumentConstraintPosition(subCallArgument);
        TypeSubstitutorMarker typeSubstitutorMarker = csBuilder.buildCurrentSubstitutor();
        if (typeSubstitutorMarker == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.resolve.calls.inference.components.NewTypeSubstitutor");
        }
        UnwrappedType currentReturnType = ((NewTypeSubstitutor)typeSubstitutorMarker).safeSubstitute(subCallArgument.getReceiver().getReceiverValue().getType().unwrap());
        if (subCallArgument.isSafeCall()) {
            csBuilder.addSubtypeConstraint(currentReturnType, expectedNullableType, position);
            return subCallResult;
        }
        if (isReceiver && !ConstraintSystemBuilderKt.addSubtypeConstraintIfCompatible(csBuilder, currentReturnType, expectedType, position) && ConstraintSystemBuilderKt.addSubtypeConstraintIfCompatible(csBuilder, currentReturnType, expectedNullableType, position)) {
            diagnosticsHolder.addDiagnostic(new UnsafeCallError(subCallArgument));
            return subCallResult;
        }
        csBuilder.addSubtypeConstraint(currentReturnType, expectedType, position);
        return subCallResult;
    }
}

