/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.hsqldb.DatabaseManager;
import org.hsqldb.HsqlDateTime;
import org.hsqldb.HsqlException;
import org.hsqldb.error.Error;
import org.hsqldb.lib.FileUtil;
import org.hsqldb.lib.HsqlTimer;
import org.hsqldb.lib.StringConverter;

public class LockFile {
    public static final long HEARTBEAT_INTERVAL = 10000L;
    public static final long HEARTBEAT_INTERVAL_PADDED = 10100L;
    protected static final byte[] MAGIC = new byte[]{72, 83, 81, 76, 76, 79, 67, 75};
    public static final int USED_REGION = 16;
    public static final int POLL_RETRIES_DEFAULT = 10;
    public static final String POLL_RETRIES_PROPERTY = "hsqldb.lockfile.poll.retries";
    public static final String POLL_INTERVAL_PROPERTY = "hsqldb.lockfile.poll.interval";
    public static final boolean USE_NIO_FILELOCK_DEFAULT = false;
    public static final String USE_NIO_FILELOCK_PROPERTY = "hsqldb.lockfile.nio.filelock";
    public static final boolean NIO_FILELOCK_AVAILABLE;
    public static final Class NIO_LOCKFILE_CLASS;
    protected static final HsqlTimer timer;
    protected File file;
    private String cpath;
    protected volatile RandomAccessFile raf;
    protected volatile boolean locked;
    private volatile Object timerTask;

    private static LockFile newNIOLockFile() {
        if (NIO_FILELOCK_AVAILABLE && NIO_LOCKFILE_CLASS != null) {
            try {
                return (LockFile)NIO_LOCKFILE_CLASS.newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    protected LockFile() {
    }

    public static LockFile newLockFile(String string) throws FileCanonicalizationException, FileSecurityException {
        LockFile lockFile = LockFile.newNIOLockFile();
        if (lockFile == null) {
            lockFile = new LockFile();
        }
        lockFile.setPath(string);
        return lockFile;
    }

    public static LockFile newLockFileLock(String string) throws HsqlException {
        LockFile lockFile = null;
        try {
            lockFile = LockFile.newLockFile(string + ".lck");
        }
        catch (BaseException baseException) {
            throw Error.error(451, baseException.getMessage());
        }
        boolean bl = false;
        try {
            bl = lockFile.tryLock();
        }
        catch (BaseException baseException) {
            throw Error.error(451, baseException.getMessage());
        }
        if (!bl) {
            throw Error.error(451, lockFile.toString());
        }
        return lockFile;
    }

    private final void checkHeartbeat(boolean bl) throws FileSecurityException, LockHeldExternallyException, UnexpectedEndOfFileException, UnexpectedFileIOException, UnexpectedFileNotFoundException, WrongLengthException, WrongMagicException {
        long l;
        long l2 = 0L;
        try {
            if (bl) {
                try {
                    if (this.file.createNewFile()) {
                        return;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (!this.file.exists()) {
                return;
            }
            l2 = this.file.length();
        }
        catch (SecurityException securityException) {
            throw new FileSecurityException(this, "checkHeartbeat", securityException);
        }
        if (l2 != 16L) {
            if (l2 == 0L) {
                this.file.delete();
                return;
            }
            throw new WrongLengthException(this, "checkHeartbeat", l2);
        }
        long l3 = System.currentTimeMillis();
        if (Math.abs(l3 - (l = this.readHeartbeat())) <= 10100L) {
            throw new LockHeldExternallyException(this, "checkHeartbeat", l3, l);
        }
    }

    private final void closeRAF() throws UnexpectedFileIOException {
        if (this.raf != null) {
            try {
                this.raf.close();
            }
            catch (IOException iOException) {
                throw new UnexpectedFileIOException(this, "closeRAF", iOException);
            }
            finally {
                this.raf = null;
            }
        }
    }

    protected boolean doOptionalLockActions() {
        return false;
    }

    protected boolean doOptionalReleaseActions() {
        return false;
    }

    private final void setPath(String string) throws FileCanonicalizationException, FileSecurityException {
        string = FileUtil.getFileUtil().canonicalOrAbsolutePath(string);
        this.file = new File(string);
        try {
            FileUtil.getFileUtil().makeParentDirectories(this.file);
        }
        catch (SecurityException securityException) {
            throw new FileSecurityException(this, "setPath", securityException);
        }
        try {
            this.file = FileUtil.getFileUtil().canonicalFile(string);
        }
        catch (SecurityException securityException) {
            throw new FileSecurityException(this, "setPath", securityException);
        }
        catch (IOException iOException) {
            throw new FileCanonicalizationException(this, "setPath", iOException);
        }
        this.cpath = this.file.getPath();
    }

    private final void openRAF() throws UnexpectedFileNotFoundException, FileSecurityException, UnexpectedFileIOException {
        try {
            this.raf = new RandomAccessFile(this.file, "rw");
        }
        catch (SecurityException securityException) {
            throw new FileSecurityException(this, "openRAF", securityException);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new UnexpectedFileNotFoundException(this, "openRAF", fileNotFoundException);
        }
    }

    private final void checkMagic(DataInputStream dataInputStream) throws FileSecurityException, UnexpectedEndOfFileException, UnexpectedFileIOException, WrongMagicException {
        boolean bl = true;
        byte[] byArray = new byte[MAGIC.length];
        try {
            for (int i = 0; i < MAGIC.length; ++i) {
                byArray[i] = dataInputStream.readByte();
                if (MAGIC[i] == byArray[i]) continue;
                bl = false;
            }
        }
        catch (SecurityException securityException) {
            throw new FileSecurityException(this, "checkMagic", securityException);
        }
        catch (EOFException eOFException) {
            throw new UnexpectedEndOfFileException(this, "checkMagic", eOFException);
        }
        catch (IOException iOException) {
            throw new UnexpectedFileIOException(this, "checkMagic", iOException);
        }
        if (!bl) {
            throw new WrongMagicException(this, "checkMagic", byArray);
        }
    }

    private final long readHeartbeat() throws FileSecurityException, UnexpectedFileNotFoundException, UnexpectedEndOfFileException, UnexpectedFileIOException, WrongMagicException {
        long l;
        FileInputStream fileInputStream = null;
        DataInputStream dataInputStream = null;
        try {
            if (!this.file.exists()) {
                long l2 = Long.MIN_VALUE;
                return l2;
            }
            fileInputStream = new FileInputStream(this.file);
            dataInputStream = new DataInputStream(fileInputStream);
            this.checkMagic(dataInputStream);
            l = dataInputStream.readLong();
        }
        catch (SecurityException securityException) {
            throw new FileSecurityException(this, "readHeartbeat", securityException);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new UnexpectedFileNotFoundException(this, "readHeartbeat", fileNotFoundException);
        }
        catch (EOFException eOFException) {
            throw new UnexpectedEndOfFileException(this, "readHeartbeat", eOFException);
        }
        catch (IOException iOException) {
            throw new UnexpectedFileIOException(this, "readHeartbeat", iOException);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return l;
    }

    private final void startHeartbeat() {
        if (this.timerTask == null || HsqlTimer.isCancelled(this.timerTask)) {
            HeartbeatRunner heartbeatRunner = new HeartbeatRunner();
            this.timerTask = timer.schedulePeriodicallyAfter(0L, 10000L, heartbeatRunner, true);
        }
    }

    private final void stopHeartbeat() {
        if (this.timerTask != null && !HsqlTimer.isCancelled(this.timerTask)) {
            HsqlTimer.cancel(this.timerTask);
            this.timerTask = null;
        }
    }

    private final void writeMagic() throws FileSecurityException, UnexpectedEndOfFileException, UnexpectedFileIOException {
        try {
            this.raf.seek(0L);
            this.raf.write(MAGIC);
        }
        catch (SecurityException securityException) {
            throw new FileSecurityException(this, "writeMagic", securityException);
        }
        catch (EOFException eOFException) {
            throw new UnexpectedEndOfFileException(this, "writeMagic", eOFException);
        }
        catch (IOException iOException) {
            throw new UnexpectedFileIOException(this, "writeMagic", iOException);
        }
    }

    private final void writeHeartbeat() throws FileSecurityException, UnexpectedEndOfFileException, UnexpectedFileIOException {
        try {
            this.raf.seek(MAGIC.length);
            this.raf.writeLong(System.currentTimeMillis());
        }
        catch (SecurityException securityException) {
            throw new FileSecurityException(this, "writeHeartbeat", securityException);
        }
        catch (EOFException eOFException) {
            throw new UnexpectedEndOfFileException(this, "writeHeartbeat", eOFException);
        }
        catch (IOException iOException) {
            throw new UnexpectedFileIOException(this, "writeHeartbeat", iOException);
        }
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof LockFile) {
            LockFile lockFile = (LockFile)object;
            return this.file == null ? lockFile.file == null : this.file.equals(lockFile.file);
        }
        return false;
    }

    public final String getCanonicalPath() {
        return this.cpath;
    }

    public final int hashCode() {
        return this.file == null ? 0 : this.file.hashCode();
    }

    public final boolean isLocked() {
        return this.locked;
    }

    public static boolean isLocked(String string) {
        boolean bl = true;
        try {
            LockFile lockFile = LockFile.newLockFile(string);
            lockFile.checkHeartbeat(false);
            bl = false;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public boolean isValid() {
        return this.isLocked() && this.file != null && this.file.exists() && this.raf != null;
    }

    public String toString() {
        return new StringBuffer(super.toString()).append("[file =").append(this.cpath).append(", exists=").append(this.file.exists()).append(", locked=").append(this.isLocked()).append(", valid=").append(this.isValid()).append(", ").append(this.toStringImpl()).append("]").toString();
    }

    protected String toStringImpl() {
        return "";
    }

    public int getPollHeartbeatRetries() {
        int n = 10;
        try {
            n = Integer.getInteger("hsqldb.lockfile_poll_retries", n);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n < 1) {
            n = 1;
        }
        return n;
    }

    public long getPollHeartbeatInterval() {
        int n = this.getPollHeartbeatRetries();
        long l = 10L + 10100L / (long)n;
        try {
            l = Long.getLong(POLL_INTERVAL_PROPERTY, l);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (l <= 0L) {
            l = 10L + 10100L / (long)n;
        }
        return l;
    }

    private final void pollHeartbeat() throws FileSecurityException, LockHeldExternallyException, UnexpectedFileNotFoundException, UnexpectedEndOfFileException, UnexpectedFileIOException, WrongLengthException, WrongMagicException {
        boolean bl = false;
        int n = this.getPollHeartbeatRetries();
        long l = this.getPollHeartbeatInterval();
        BaseException baseException = null;
        for (int i = n; i > 0; --i) {
            try {
                this.checkHeartbeat(true);
                bl = true;
                break;
            }
            catch (BaseException baseException2) {
                baseException = baseException2;
                try {
                    Thread.sleep(l);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
            }
        }
        if (!bl) {
            if (baseException instanceof FileSecurityException) {
                throw (FileSecurityException)baseException;
            }
            if (baseException instanceof LockHeldExternallyException) {
                throw (LockHeldExternallyException)baseException;
            }
            if (baseException instanceof UnexpectedFileNotFoundException) {
                throw (UnexpectedFileNotFoundException)baseException;
            }
            if (baseException instanceof UnexpectedEndOfFileException) {
                throw (UnexpectedEndOfFileException)baseException;
            }
            if (baseException instanceof UnexpectedFileIOException) {
                throw (UnexpectedFileIOException)baseException;
            }
            if (baseException instanceof WrongLengthException) {
                throw (WrongLengthException)baseException;
            }
            if (baseException instanceof WrongMagicException) {
                throw (WrongMagicException)baseException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean tryLock() throws FileSecurityException, LockHeldExternallyException, UnexpectedFileNotFoundException, UnexpectedEndOfFileException, UnexpectedFileIOException, WrongLengthException, WrongMagicException {
        if (this.locked) {
            return true;
        }
        try {
            this.pollHeartbeat();
            this.openRAF();
            this.doOptionalLockActions();
            this.writeMagic();
            this.writeHeartbeat();
            FileUtil.getFileUtil().deleteOnExit(this.file);
            this.locked = true;
            this.startHeartbeat();
        }
        finally {
            if (!this.locked) {
                this.doOptionalReleaseActions();
                try {
                    this.closeRAF();
                }
                catch (Exception exception) {}
            }
        }
        return this.locked;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean tryRelease() throws FileSecurityException, UnexpectedFileIOException {
        boolean bl;
        boolean bl2 = bl = !this.locked;
        if (bl) {
            return true;
        }
        this.stopHeartbeat();
        this.doOptionalReleaseActions();
        UnexpectedFileIOException unexpectedFileIOException = null;
        FileSecurityException fileSecurityException = null;
        try {
            try {
                this.closeRAF();
            }
            catch (UnexpectedFileIOException unexpectedFileIOException2) {
                unexpectedFileIOException = unexpectedFileIOException2;
            }
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                bl = this.file.delete();
            }
            catch (SecurityException securityException) {
                fileSecurityException = new FileSecurityException(this, "tryRelease", securityException);
            }
        }
        finally {
            this.locked = false;
        }
        if (unexpectedFileIOException != null) {
            throw unexpectedFileIOException;
        }
        if (fileSecurityException != null) {
            throw fileSecurityException;
        }
        return bl;
    }

    protected final void finalize() throws Throwable {
        this.tryRelease();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        timer = DatabaseManager.getTimer();
        Class<LockFile> clazz = LockFile.class;
        synchronized (LockFile.class) {
            boolean bl = false;
            try {
                bl = "true".equalsIgnoreCase(System.getProperty(USE_NIO_FILELOCK_PROPERTY, bl ? "true" : "false"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            boolean bl2 = false;
            Class<?> clazz2 = null;
            if (bl) {
                try {
                    Class.forName("java.nio.channels.FileLock");
                    clazz2 = Class.forName("org.hsqldb.persist.NIOLockFile");
                    bl2 = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            NIO_FILELOCK_AVAILABLE = bl2;
            NIO_LOCKFILE_CLASS = clazz2;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static final class WrongMagicException
    extends BaseException {
        private final byte[] magic;

        public WrongMagicException(LockFile lockFile, String string, byte[] byArray) {
            super(lockFile, string);
            this.magic = byArray;
        }

        @Override
        public String getMessage() {
            String string = super.getMessage() + " magic: ";
            string = string + (this.magic == null ? "null" : "'" + StringConverter.byteArrayToHexString(this.magic) + "'");
            return string;
        }

        public byte[] getMagic() {
            return this.magic == null ? null : (byte[])this.magic.clone();
        }
    }

    public static final class WrongLengthException
    extends BaseException {
        private final long length;

        public WrongLengthException(LockFile lockFile, String string, long l) {
            super(lockFile, string);
            this.length = l;
        }

        public long getLength() {
            return this.length;
        }

        @Override
        public String getMessage() {
            return super.getMessage() + " length: " + this.length;
        }
    }

    public static final class UnexpectedFileNotFoundException
    extends BaseException {
        private final FileNotFoundException reason;

        public UnexpectedFileNotFoundException(LockFile lockFile, String string, FileNotFoundException fileNotFoundException) {
            super(lockFile, string);
            this.reason = fileNotFoundException;
        }

        public FileNotFoundException getReason() {
            return this.reason;
        }

        @Override
        public String getMessage() {
            return super.getMessage() + " reason: " + this.reason;
        }
    }

    public static final class UnexpectedFileIOException
    extends BaseException {
        private final IOException reason;

        public UnexpectedFileIOException(LockFile lockFile, String string, IOException iOException) {
            super(lockFile, string);
            this.reason = iOException;
        }

        public IOException getReason() {
            return this.reason;
        }

        @Override
        public String getMessage() {
            return super.getMessage() + " reason: " + this.reason;
        }
    }

    public static final class UnexpectedEndOfFileException
    extends BaseException {
        private final EOFException reason;

        public UnexpectedEndOfFileException(LockFile lockFile, String string, EOFException eOFException) {
            super(lockFile, string);
            this.reason = eOFException;
        }

        public EOFException getReason() {
            return this.reason;
        }

        @Override
        public String getMessage() {
            return super.getMessage() + " reason: " + this.reason;
        }
    }

    public static final class LockHeldExternallyException
    extends BaseException {
        private final long read;
        private final long heartbeat;

        public LockHeldExternallyException(LockFile lockFile, String string, long l, long l2) {
            super(lockFile, string);
            this.read = l;
            this.heartbeat = l2;
        }

        public long getHeartbeat() {
            return this.heartbeat;
        }

        public long getRead() {
            return this.read;
        }

        @Override
        public String getMessage() {
            return super.getMessage() + " read: " + HsqlDateTime.getTimestampString(this.read) + " heartbeat - read: " + (this.heartbeat - this.read) + " ms.";
        }
    }

    public static final class FileSecurityException
    extends BaseException {
        private final SecurityException reason;

        public FileSecurityException(LockFile lockFile, String string, SecurityException securityException) {
            super(lockFile, string);
            this.reason = securityException;
        }

        public SecurityException getReason() {
            return this.reason;
        }

        @Override
        public String getMessage() {
            return super.getMessage() + " reason: " + this.reason;
        }
    }

    public static final class FileCanonicalizationException
    extends BaseException {
        private final IOException reason;

        public FileCanonicalizationException(LockFile lockFile, String string, IOException iOException) {
            super(lockFile, string);
            this.reason = iOException;
        }

        public IOException getReason() {
            return this.reason;
        }

        @Override
        public String getMessage() {
            return super.getMessage() + " reason: " + this.reason;
        }
    }

    public static abstract class BaseException
    extends Exception {
        private final LockFile lockFile;
        private final String inMethod;

        public BaseException(LockFile lockFile, String string) {
            if (lockFile == null) {
                throw new NullPointerException("lockFile");
            }
            if (string == null) {
                throw new NullPointerException("inMethod");
            }
            this.lockFile = lockFile;
            this.inMethod = string;
        }

        @Override
        public String getMessage() {
            return "lockFile: " + this.lockFile + " method: " + this.inMethod;
        }

        public String getInMethod() {
            return this.inMethod;
        }

        public LockFile getLockFile() {
            return this.lockFile;
        }
    }

    private final class HeartbeatRunner
    implements Runnable {
        private HeartbeatRunner() {
        }

        @Override
        public void run() {
            try {
                LockFile.this.writeHeartbeat();
            }
            catch (Throwable throwable) {
                Error.printSystemOut(throwable.toString());
            }
        }
    }
}

