/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.drawable;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Stroke;
import net.sf.sdedit.diagram.Lifeline;
import net.sf.sdedit.diagram.MessageData;
import net.sf.sdedit.diagram.SequenceDiagram;
import net.sf.sdedit.drawable.ArrowHeadType;
import net.sf.sdedit.drawable.ArrowStroke;
import net.sf.sdedit.drawable.SequenceElement;
import net.sf.sdedit.drawable.Strokes;
import net.sf.sdedit.message.Answer;
import net.sf.sdedit.message.BroadcastMessage;
import net.sf.sdedit.message.Message;
import net.sf.sdedit.util.Direction;
import net.sf.sdedit.util.Utilities;

public class Arrow
extends SequenceElement {
    private final ArrowStroke stroke;
    private final ArrowHeadType headType;
    private Message message;
    private int space;
    protected Point[] pts;
    protected Point textPoint;
    protected final boolean isAnswer;
    private int fontStyle;

    private static String[] splitMessage(String text, int length) {
        if (length > 0) {
            text = Utilities.wrap(text, length, "\\n", false);
        }
        return text.split("\\\\n");
    }

    protected Arrow(Message message, Lifeline boundary0, Lifeline boundary1, ArrowStroke stroke, Direction align, int y) {
        super(message.getDiagram(), boundary0, boundary1, Arrow.splitMessage(message.getText(), message.getDiagram().messageLineLength), align, y);
        int headSize;
        this.message = message;
        this.isAnswer = message instanceof Answer;
        this.stroke = stroke;
        if (stroke != ArrowStroke.NONE) {
            headSize = this.diagram().arrowSize;
            this.headType = message instanceof BroadcastMessage ? ArrowHeadType.ROUNDED : (message.isSynchronous() ? ArrowHeadType.CLOSED : ArrowHeadType.OPEN);
        } else {
            this.headType = ArrowHeadType.CLOSED;
            headSize = 0;
        }
        int totalTextHeight = this.textHeight();
        this.setHeight(totalTextHeight + this.configuration().getMessageLabelSpace() + this.diagram().arrowSize / 2);
        this.setWidth(headSize + this.leftPadding() + this.rightPadding() + this.diagram().messagePadding + this.textWidth());
        this.fontStyle = (message.getData().isStatic() && !this.isAnswer ? 2 : 0) | (message.getData().isBold() && !this.isAnswer ? 1 : 0);
    }

    @Override
    protected int textWidth() {
        boolean bold = (this.fontStyle & 1) > 0;
        return this.textWidth(bold);
    }

    protected Font getFont(Font originalFont) {
        if (this.fontStyle == 0) {
            return originalFont;
        }
        return originalFont.deriveFont(this.fontStyle);
    }

    public Arrow(Message message, ArrowStroke stroke, Direction align, int y) {
        this(message, message.getCaller(), message.getCallee(), stroke, align, y);
    }

    public final Point[] getPoints() {
        return this.pts;
    }

    public Point getTextPosition() {
        return this.textPoint;
    }

    public int getInnerHeight() {
        return this.textHeight() + this.diagram().messageLabelSpace;
    }

    public static int getInnerHeight(Message message) {
        int l = Arrow.splitMessage(message.getText(), message.getDiagram().messageLineLength).length;
        return message.getDiagram().getPaintDevice().getTextHeight() * l + message.getDiagram().getConfiguration().getMessageLabelSpace();
    }

    @Override
    public final int getSpace() {
        return this.space;
    }

    public final void setSpace(int space) {
        this.space = space;
    }

    @Override
    protected void drawObject(Graphics2D g2d) {
        int sgn;
        Font font = g2d.getFont();
        g2d.setFont(this.getFont(font));
        g2d.setColor(this.getFontColor());
        this.drawText(g2d);
        g2d.setFont(font);
        g2d.setColor(this.getColor());
        int n = sgn = this.getAlign() == Direction.LEFT ? 1 : -1;
        if (this.stroke != ArrowStroke.NONE) {
            g2d.setStroke(this.stroke == ArrowStroke.DASHED ? this.dashed() : this.solid());
            g2d.drawLine(this.pts[0].x, this.pts[0].y, this.pts[1].x, this.pts[1].y);
            g2d.setStroke(this.solid());
            this.drawArrowHead(g2d, this.pts[1].x, this.pts[1].y, sgn);
            if (this.message.getCaller().isExternal()) {
                int as = this.diagram().arrowSize;
                int offset = sgn == -1 ? as : 0;
                g2d.fillOval(this.pts[0].x - offset, this.pts[0].y - as / 2, as, as);
            }
        }
    }

    private Color getUserColor(String key) {
        MessageData data = this.getMessage().getData();
        Color color = null;
        if (data.getMessage().length() > 0) {
            color = Utilities.decodeColor(data.getUserData(key));
        }
        return color;
    }

    protected Color getBackgroundColor() {
        MessageData data = this.getMessage().getData();
        Color backgroundColor = null;
        if (data.getMessage().length() > 0 && (backgroundColor = this.getUserColor("background-color")) == null) {
            SequenceDiagram diag = this.diagram();
            int t = data.getThread();
            if (t >= 0 && diag.opaqueText) {
                backgroundColor = diag.threadColors[t];
            }
        }
        return backgroundColor;
    }

    protected Color getColor() {
        Color color = this.getUserColor("color");
        if (color == null) {
            color = this.diagram().arrowColor;
        }
        return color;
    }

    protected Color getFontColor() {
        Color color = this.getUserColor("color");
        if (color == null) {
            color = Color.BLACK;
        }
        return color;
    }

    protected void drawText(Graphics2D g2d) {
        this.drawMultilineString(g2d, this.getFontColor(), this.textPoint.x, this.textPoint.y, this.getBackgroundColor());
    }

    public Point getAnchor() {
        return new Point(this.pts[0].x + (this.pts[1].x - this.pts[0].x) / 2, this.pts[0].y);
    }

    @Override
    public void computeLayoutInformation() {
        int left = this.getLeftEndpoint().getLeft() + this.getLeftEndpoint().getWidth();
        int right = this.getRightEndpoint().getLeft();
        Direction align = this.getAlign();
        if (align == Direction.LEFT) {
            left += this.space;
        } else {
            right -= this.space;
        }
        this.setLeft(left);
        this.setWidth(Math.max(this.getWidth(), right - left));
        int x_from = align == Direction.LEFT ? this.getLeft() + this.getWidth() : this.getLeft();
        int x_to = align == Direction.LEFT ? this.getLeft() : this.getLeft() + this.getWidth();
        int sgn = align == Direction.LEFT ? 1 : -1;
        int text_x = sgn == 1 ? x_from - this.diagram().messagePadding - this.textWidth() - this.rightPadding() : x_from + this.diagram().messagePadding + this.leftPadding();
        int v = this.getTop() + this.textHeight() + this.diagram().messageLabelSpace;
        this.pts = new Point[2];
        this.pts[0] = new Point(x_from, v);
        this.pts[1] = new Point(x_to, v);
        this.textPoint = new Point(text_x, v - this.diagram().messageLabelSpace);
    }

    protected final void drawArrowHead(Graphics2D g, int x, int y, int sgn) {
        g.setStroke(Strokes.getStroke(Strokes.StrokeType.SOLID, 1));
        int size = this.diagram().arrowSize;
        switch (this.headType) {
            case CLOSED: {
                Polygon p = new Polygon(new int[]{x, x + sgn * size, x + sgn * size, x}, new int[]{y, y - size, y + size, y}, 4);
                g.fillPolygon(p);
                break;
            }
            case OPEN: {
                g.drawLine(x, y, x + sgn * size, y - size);
                g.drawLine(x, y, x + sgn * size, y + size);
                break;
            }
            case ROUNDED: {
                int left = sgn == -1 ? x - 2 * size : x;
                int top = y - size;
                g.fillArc(left, top, size * 2, size * 2, 90, sgn * 180);
            }
        }
    }

    public final Message getMessage() {
        return this.message;
    }

    protected final ArrowStroke getStroke() {
        return this.stroke;
    }

    protected final Stroke dashed() {
        return Strokes.getStroke(Strokes.StrokeType.DASHED, this.diagram().arrowThickness);
    }

    protected final Stroke solid() {
        return Strokes.getStroke(Strokes.StrokeType.SOLID, this.diagram().arrowThickness);
    }

    @Override
    public Rectangle getRectangle() {
        Rectangle r;
        if (this.textPoint != null) {
            r = new Rectangle();
            r.x = this.textPoint.x;
            r.y = this.textPoint.y;
            r.height = this.textHeight();
            r.width = this.textWidth();
        } else {
            r = super.getRectangle();
        }
        return r;
    }
}

