#
# Find the KDevelop Parser Generator and set various variables accordingly
#
# KDEVPGQT_DIR and can be set to adjust the directory where the kdevelop-pg-qt
# headers and executable are searched. This should point to the installation
# directory of kdevelop-pg-qt
#
# KDEVPGQT_FOUND - set to TRUE if KDevelop-PG was found FALSE otherwise
#
# KDEVPGQT_INCLUDE_DIR         - include dir of kdevelop-pg, for example /usr/include/kdevelop-pg
#                              can be set by the user to select different include dirs
# KDEVPGQT_EXECUTABLE          - the absolute path to the kdevelop-pg executable
#
# KDEVPGQT_GENERATE(SRC_FILE_VAR OUTPUT language
#                     [NAMESPACE ns] [DEBUG_VISITOR] [TOKEN_TEXT] [DUMP_INFO]
#                     GRAMMARFILE ADDITIONALDEPS)
#     macro to add a custom target for the generation of the parser
#     OUTPUT will be given to kdev-pg as the --output parameter and thus sets the filename prefix
#     NAMESPACE can be given to choose a namespace different from the OUTPUT value
#     DEBUG_VISITOR will run kdevelop-pg with the --debug-visitor argument to generate a simple
#                   visitor that will print debug messages
#     TOKEN_TEXT will run kdevelop-pg with the --token-text argument to generate a simple
#                function that returns a readable name of a token
#     DUMP_INFO will tell kdevelop-pg to dump extra information about symbols, terminals and rules
#               into files in the binary dir
#     Note: The macro only exists when KDEVPG was found
#
# Copyright (c) 2007 Andreas Pakulat <apaku@gmx.de>
# Redistribution and use is allowed according to the terms of the BSD license.
# For details see the accompanying COPYING-CMAKE-SCRIPTS file.


####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was KDevelop-PG-QtConfig.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

# Use original install prefix when loaded through a "/usr move"
# cross-prefix symbolic link such as /lib -> /usr/lib.
get_filename_component(_realCurr "${CMAKE_CURRENT_LIST_DIR}" REALPATH)
get_filename_component(_realOrig "/usr/lib/cmake/KDevelop-PG-Qt" REALPATH)
if(_realCurr STREQUAL _realOrig)
  set(PACKAGE_PREFIX_DIR "/usr")
endif()
unset(_realOrig)
unset(_realCurr)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

if( KDEVPGQT_INCLUDE_DIR AND KDEVPGQT_EXECUTABLE )
    set(KDevelop-PG-Qt_FIND_QUIETLY TRUE)
endif()

if(WIN32)
    file(TO_CMAKE_PATH "$ENV{PROGRAMFILES}" _progFiles)
    set(_KDEVPGQT_DIR ${_progFiles}/kdevelop-pg-qt)
endif()

if( NOT KDEVPGQT_DIR )
    find_path( _kdevpgqtIncDir kdevelop-pg-qt/kdev-pg-token-stream.h
        PATHS
        ${CMAKE_INSTALL_PREFIX}/include
        ${_KDEVPGQT_DIR}/include
    )
    if( _kdevpgqtIncDir )
        set(KDEVPGQT_INCLUDE_DIR ${_kdevpgqtIncDir}/kdevelop-pg-qt)
    endif()
    find_program( KDEVPGQT_EXECUTABLE NAMES kdev-pg-qt
        PATHS
        ${CMAKE_INSTALL_PREFIX}/bin
        ${_KDEVPGQT_DIR}/bin
    )

    set(KDEVPGQT_INCLUDE_DIR ${KDEVPGQT_INCLUDE_DIR} CACHE PATH "kdevelop-pg-qt include directory containing the headers")
    set( KDEVPGQT_EXECUTABLE ${KDEVPGQT_EXECUTABLE} CACHE PATH "executable for kdevelop-pg-qt" )
else()
    find_path( _kdevpgqtIncDir kdevelop-pg-qt/kdev-pg-token-stream.h
        PATHS
        ${CMAKE_INSTALL_PREFIX}/include
        ${_KDEVPGQT_DIR}/include
        ${KDEVPGQT_DIR}/include
    )
    set(KDEVPGQT_INCLUDE_DIR ${_kdevpgIncDir}/kdevelop-pg-qt)
    find_program( KDEVPGQT_EXECUTABLE NAMES kdev-pg-qt
        PATHS
        ${CMAKE_INSTALL_PREFIX}/bin
        ${_KDEVPGQT_DIR}/bin
        ${KDEVPGQT_DIR}/bin
    )
    set(KDEVPGQT_INCLUDE_DIR ${KDEVPGQT_INCLUDE_DIR} CACHE PATH "kdevelop-pg-qt include directory containing the headers")
    set( KDEVPGQT_EXECUTABLE ${KDEVPGQT_EXECUTABLE} CACHE PATH "executable for kdevelop-pg-qt" )
endif()
if( KDEVPGQT_INCLUDE_DIR
 AND KDEVPGQT_EXECUTABLE)

    if( NOT KDevelop-PG-Qt_FIND_QUIETLY )
        message(STATUS "Found KDevelop-PG-Qt")
        message(STATUS "  Using kdevelop-pg-qt include dir: ${KDEVPGQT_INCLUDE_DIR}")
        message(STATUS "  Using kdevelop-pg-qt executable: ${KDEVPGQT_EXECUTABLE}")
    endif()

# if all modules found
    set(KDEVPGQT_FOUND TRUE)

    macro(KDEVPGQT_GENERATE _srcVar _language )
        set(_outputList
            "${CMAKE_CURRENT_BINARY_DIR}/${_language}tokentype.h")
        set(_depList ${ARGN})
        set(_astList
            "${CMAKE_CURRENT_BINARY_DIR}/${_language}ast.h")
        set(_parserList
            "${CMAKE_CURRENT_BINARY_DIR}/${_language}parser.h"
            "${CMAKE_CURRENT_BINARY_DIR}/${_language}parser.cpp"
            "${CMAKE_CURRENT_BINARY_DIR}/${_language}visitor.h"
            "${CMAKE_CURRENT_BINARY_DIR}/${_language}visitor.cpp"
            "${CMAKE_CURRENT_BINARY_DIR}/${_language}defaultvisitor.h"
            "${CMAKE_CURRENT_BINARY_DIR}/${_language}defaultvisitor.cpp")
        set(_lexerList)
        set(_dbgVisit)
        set(_namespace)
        set(_tokenText)
        set(_dumpInfo)
        if(CMAKE_COMPILER_IS_GNUCC)
          set(_beautifulCode)
        else()
          set(_beautifulCode --compatible-error-aware-code)
        endif()
        set(_conflicts)
        while(1)
        list(GET _depList 0 _arg)
        if( ${_arg} STREQUAL "NAMESPACE" )
            list(GET _depList 1 _namespace)
            list(REMOVE_AT _depList 0 1)
            set(_namespace --namespace=${_namespace})
        elseif( ${_arg} STREQUAL "DEBUG_VISITOR" )
            list(REMOVE_AT _depList 0)
            set(_dbgVisit "--debug-visitor")
            set(_outputList ${_outputList}
                "${CMAKE_CURRENT_BINARY_DIR}/${_language}debugvisitor.h"
            )
        elseif( ${_arg} STREQUAL "TOKEN_TEXT" )
            list(REMOVE_AT _depList 0)
            set(_tokenText "--token-text")
            set(_outputList ${_outputList}
                "${CMAKE_CURRENT_BINARY_DIR}/${_language}tokentext.h"
            )
        elseif( ${_arg} STREQUAL "DUMP_INFO" )
            list(REMOVE_AT _depList 0)
            set(_dumpInfo --terminals --symbols --rules)
            set(_outputList ${_outputList}
                "${CMAKE_CURRENT_BINARY_DIR}/kdev-pg-terminals"
                "${CMAKE_CURRENT_BINARY_DIR}/kdev-pg-symbols"
                "${CMAKE_CURRENT_BINARY_DIR}/kdev-pg-rules"
            )
        elseif( ${_arg} STREQUAL "BEAUTIFUL_CODE" )
            list(REMOVE_AT _depList 0)
            set(_beautifulCode --beautiful-code)
        elseif( ${_arg} STREQUAL "STRICT_CONFLICTS" )
            list(REMOVE_AT _depList 0)
            set(_conflicts --strict-conflicts)
        elseif( ${_arg} STREQUAL "IGNORE_CONFLICTS" )
            list(REMOVE_AT _depList 0)
            set(_conflicts --ignore-conflicts)
        elseif( ${_arg} STREQUAL "GENERATE_LEXER" )
          list(REMOVE_AT _depList 0)
          set(_lexerList
              "${CMAKE_CURRENT_BINARY_DIR}/${_language}lexer.h"
              "${CMAKE_CURRENT_BINARY_DIR}/${_language}lexer.cpp")
        else()
            break()
        endif()
        endwhile(1)
        
        set(_outputList ${_outputList} ${_lexerList} ${_astList} ${_parserList})
        
        list(GET _depList 0 _grammarFile)
        list(REMOVE_AT _depList 0)
        if(NOT _grammarFile)
            message(ERROR "No grammar file given to KDEVPGQT_GENERATE macro")
        endif()
        add_custom_command(
            OUTPUT
                    ${_outputList}
            MAIN_DEPENDENCY "${_grammarFile}"
            DEPENDS ${_depList} ${KDEVPGQT_EXECUTABLE}
            COMMAND ${KDEVPGQT_EXECUTABLE}
            ARGS    --output=${_language} ${_namespace}
                    ${_dbgVisit} ${_dumpInfo} ${_beautifulCode} ${_conflicts} "${_grammarFile}"
            WORKING_DIRECTORY "${CMAKE_CURRENT_BINARY_DIR}"
        )
        set_source_files_properties(${_outputList} PROPERTIES
            GENERATED TRUE
            SKIP_AUTOMOC ON
        )
        set( ${_srcVar}
              "${_outputList}"
           )
    endmacro(KDEVPGQT_GENERATE)


else( KDEVPGQT_INCLUDE_DIR
 AND KDEVPGQT_EXECUTABLE)

    if( KDevelop-PG-Qt_FIND_REQUIRED)
        message(FATAL_ERROR "Couldn't find KDevelop-PG-Qt.")
    else()
        message(STATUS "Couldn't find KDevelop-PG-Qt.")
    endif()
    message(STATUS "You can set KDEVPGQT_DIR to help cmake find KDevelop-PG-Qt")
    set(KDEVPGQT_FOUND FALSE)

endif( KDEVPGQT_INCLUDE_DIR
 AND KDEVPGQT_EXECUTABLE)
