/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.exporter.plugin;

import javax.swing.JPanel;
import org.gephi.io.exporter.plugin.ExporterGEXF;
import org.gephi.io.exporter.spi.Exporter;
import org.gephi.io.exporter.spi.ExporterUI;
import org.gephi.ui.exporter.plugin.UIExporterGEXFPanel;
import org.openide.util.NbBundle;

public class UIExporterGEXF
implements ExporterUI {
    private UIExporterGEXFPanel panel;
    private ExporterGEXF exporterGEXF;
    private final ExporterGEXFSettings settings = new ExporterGEXFSettings();

    public void setup(Exporter exporter) {
        this.exporterGEXF = (ExporterGEXF)exporter;
        this.settings.load(this.exporterGEXF);
        this.panel.setup(this.exporterGEXF);
    }

    public void unsetup(boolean update) {
        if (update) {
            this.panel.unsetup(this.exporterGEXF);
            this.settings.save(this.exporterGEXF);
        }
        this.panel = null;
        this.exporterGEXF = null;
    }

    public JPanel getPanel() {
        this.panel = new UIExporterGEXFPanel();
        return this.panel;
    }

    public boolean isUIForExporter(Exporter exporter) {
        return exporter instanceof ExporterGEXF;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(UIExporterGEXF.class, (String)"UIExporterGEXF.name");
    }

    private static class ExporterGEXFSettings {
        private boolean normalize = false;
        private boolean exportColors = true;
        private boolean exportPosition = true;
        private boolean exportSize = true;
        private boolean exportAttributes = true;
        private boolean exportDynamics = true;

        private ExporterGEXFSettings() {
        }

        private void save(ExporterGEXF exporterGEXF) {
            this.normalize = exporterGEXF.isNormalize();
            this.exportColors = exporterGEXF.isExportColors();
            this.exportPosition = exporterGEXF.isExportPosition();
            this.exportSize = exporterGEXF.isExportSize();
            this.exportAttributes = exporterGEXF.isExportAttributes();
            this.exportDynamics = exporterGEXF.isExportDynamic();
        }

        private void load(ExporterGEXF exporterGEXF) {
            exporterGEXF.setNormalize(this.normalize);
            exporterGEXF.setExportColors(this.exportColors);
            exporterGEXF.setExportAttributes(this.exportAttributes);
            exporterGEXF.setExportPosition(this.exportPosition);
            exporterGEXF.setExportSize(this.exportSize);
            exporterGEXF.setExportDynamic(this.exportDynamics);
        }
    }
}

