"""
....  ......        ....  .. .                  ....         .
.... .......          .   ....                           ....       .        ..
............ . .....   .   ...                                      .       .
............   . ...      .....  .  . . . .. .  .     ..  .. ....      ..    . .
 ............. . ...   .............................  ... ......................
................ ..    . ,?.ZD++I:  ............................................
... ............ ...    , I7,,,,I7?,............................................
  ......................,O?7,..+Z+$=~...........................................
  .....................:D$::~,,=..N~I~. ........................................
. .....................=O~.I~:?....I~?:.........................................
   ...................:7D.7~:~+,,,~.O+?.........................................
. ....................=ZZ~8:::~=:,:I~7I:........................................
     .................~O7=$:::::.,.~7?=7,.......................................
  ...................,=8=?+.:~::.,.,?,7?=.......................................
. ...................~7D=$?.:~:,.,,:,,.I?.......................................
.....................=+Z=I=.:~,,.,:,,?.Z?=.... .  .   .     .   ..... .    . . .
....................~,7O+7?,:=,.,,::.I.I?:...  . .    ...          ....
.....................,?8?=?:~==?$+~~:$I8DOZ$?=:::,. .... .     .      .        .
.................. :..+87?7?$$$8NNNO=~:,=?::=I7Z8DZ:.:,.......... . . ..   .
....................=.+8?NO$8$?7Z$I~............. . ?+$=.  ........ . ..  ..
..................:.788NDNNO=...................... .+$8.~.. ........ .
............ ...,,ZIMDO~,.............................O=... .     . . .    .
...............$$ODZ~,.... ..... ....... ....  .....: 78Z....       . .
...........,.887M8=.............. ..................:.=~M.:........ ..... ....
............Z7ZO+............ ...................... ~.?NI:,..... . . .    .  ..
...........I,?:::.,......   ....  .    .... ... .......?7M =.... ........  .
...........,$:+:::~ .....   ..... .... . .. ..........:,,D=+.......... .....
............7?+,:+~.......        .         ....... ....,OD~~. ....   .  ..... .
............77=,:++,......  .   . . .  .  . . .........,NIZ.?.....  . .  ... ..
............$$+~:~~=....... ..   .......  . . ..........O=87+..........      ...
............D$==,~:~.... .....  . ...... .... ...... ...~$NO:.. .........   ...
............D?+::~~~.......  .    . . ..    .  .... ....,88Z7,. ............ . .
............Z7+~=+~~:...... ...   .. ...  . .  ...  ....~$I8$=..... . .... ... .
............777?=+~++...  ....  . . .     . . ..... .   .?~OZ?.... .. ........
......... ..?ID7~===? .................................. ~ZZ$$= .....  .........
............:I8?::~~?...      ..........    .  ..........:ND$N::...........  . .
.............ID+=~=:~............................  ..... .?ZO$:+. . ..........
.............I8~I+,=:,........    . .. .    .   ......,I7=?$8?$I............ . .
.............IZ=$+,=,:........    . ....    .   .....ODDMI+O8IN?.. ......  . .
............ $Z?Z=:~:=.~I....... ........ ......... ~MI..8?DZ7D=:. .. ........
.............Z$=Z+,:,OD.?M....   .... ........  .....D,,$N+$D7D+=....      . .
.............7+=Z=~=ID...N$  ........  . . .. . .... ,NMN=,=DIOI~,...  ..  . . .
.............~=?Z===ZM=.?Z7.........   .......  .....,:,,..,$D78~~.... ..  . .
.............,=OI~~==MNMM,. ....... . . . .................::MZD=.... ..........
.............,ZM~?~=~77= .. ....  . .       .. ........... :.NZ8+...... .... . .
............ :DM~I:+~Z...... ..   ..      . ...... ........:.MZDI :... ... . . .
.............~?8?7,==$......... . .        .. ..... .   . .,:DDO$.,. ....... . .
.............~,I$$:=:I,,.. ............ .............  ....,~ZN7$..~........ . .
.............~ 7Z$:~,?..          . ....   ........ .   ...,:+MIZ=.,. ...... . .
.............,.~$$:~~+.. . ........................ .... ....IM?8:.......... . .
.............: +Z+~=~=:........ . . .  .  ......... .  ......?MIN:  ........ . .
.... .........,78+:+=~,........  ....     ... ..... . .......7NI8,..~..........
......... ..  :7$I?===:....................  ..    .... .....ZD$N...:...........
............. =ZZ7??+,, ... ..    .    ..............   .....7Z8D............. .
..............=$Z8$I?~:.......... ...........................=IN8. . :..........
...............?Z87??=~... .... . .    ...........  .  ......,$M8....,..........
...............?OO??+~=......... .......... .. ..   .  ......:ZNO,..............
...............?$7I=I,=................     .. ..............:ZN8........ .....
........... ...+$~I??:?.................  . .  .... . .......:7M8.....,.... ....
...............,?:7??:I... .........        . ..... .  ......,$MD............. .
...............,+~Z$=,I......... ........................ .. .$MD...............
...............,7+8$=+?...... ... .    .... .  .... .    .....ZMD,,... ........
................$~OO~?I................. .......... ..........OMO...............
................?=78=+7.......  .....  ....... .... . .......~ZMZ,..............
............... =~IZ+I?.... ... . ...  ..........      ......~OM7............. .
 ...............:++D7?7,....... ...... ..........      ......~NMI......... . ...
................,==N7+?:... ....... .. ............ . . .....+NM+..............
.... ............=~N$:?~. ..  ...... ..... ..... ............+MM=............. .
.................++M7?+~......... .. ...    .. ...... .......=MM:. .............
.................I+M7=I~............ ............ ...   .... +MM:...............
.................7IN$+7=,....... .......  ............ ......$MM,........... . .
................ 7=NI++=,....... .....    ............ ......INN,...........
.................7=D7~~=,... ....... ...    . . ............ +DO,............. .
.................==D7~~+......  . .  .. ... . ....... ......,?MO.. ...... ......
.............. ..:+8?+=~,. ......     .  ......... ..   .....OM7,,.,.....   ....
.............. ...?8?+~~=. ........  ......,~?$OO8OOOOZ$I77IIMMDD$?O$=:.. ......
..................?87+:~~...........~$$??$ZDNN8ZDND8NDODZ7Z$7ZZI$$ZZZ~...... . .
..................?O?+,:~.. .. ~OO+7$888877?~,..... .. .... .:....=+7:...... . .
..................?O++,~=...78+~$8D$=,,............... .......... I$$,. ....
..................=8+=:~~O$I$ZZ,................. .... ..........~O7:....... ..
..................,$:=Z$O=~7,.................................. ,:87+... .......
...................8II:?+?... ...................................+8+. ... .. . .
...................Z7~+=,?:..........  ................  .......:Z$,..... .. .
................. ..$=Z?:~+~,... .......... ....................Z8.~..... .. .
.....................~:$7,?~,~ ,...................... .. .....$O=~...  .  .
.................... ..?N+~=:+.+, . .. .... .........  .......?$~=... ... .. .
...................... .=MZI=:=:~==, .....  ........ ......~+Z?=,. ...... .. .
.........................:?78I===~.,,,==...............=:~7+D$..................
...........................??Z8+I7?~...::=.,++~~+==::,~+7IN,......  . ... ..
............................:,?OOO$ZZI:=:,,,~,,::.:=I8N8=...... .....   .  . .
............................. ,,D$DIIZZ77Z8OO$DO8N?NMN,.......... ... ... .. .
...............................~:ON?M7~++II7=I=~=?8O?............ .   . . .. . .
.................................,$MNM8~:.....:INO=...................... .. .
...................................~MM8MDZ7ZZODD?,................... ..........
........................  ............DO$?Z$DMN~,........................ .. .
......................................7N$~7~ZMN,................... .....    .
........................    ..........IMN=...7D...................... ..  .. . .
........................    ..........?M= ...7N.................... .   .
........................    ..........?M,....$$....... .. ....  ......... .. .
........................  ............IN~IZZ~8I..... .. ................. .. .
.............. ......... ... .........IN,... O=...........  ....................
.......................... ...........$N.....O:....... .... ......... .
........................    ........ .OO.....7:........ ....... . . . ... .. .
........................ .  ..........8Z..~=~$: ...............   . . ... .. .
........................ ............:NZ7,..:I..................  ... ... .. .
........................  ...........=N7....:I ............. ...  . . ... .. .
........................ ..... ..... =D~... ~I..................................
........................     .  .....?N:. ..?$.........  .....  . . . ... .. .
........................ .. ........ $N:$,..+I..................  . . ... .. .
........................ ..  ........OM.....?7..................  ... ... .. . .
........................    .........DN ....7Z........   ........ . . ... .. .
........................ . ..........MO.....?7................... ..............
........................  ...........M+...::7I..................  ... ... .. . .
........................ ..  ....... M$:....$?... ..............  ..  . . .. . .
................................ ..Z+N   .,:$. ....... ..........   .....      .
........................  ... . =?:=~8. ...,7,I:........... ........... . .. . .
...............................?I:~~:$.....I:..,I,....................... .. . .
......................... ..=:.,?=:?.:DNDN7:.....,~...................... .. .
..................... ...~=7.,..=+:...............=::,........  ............ .
......................+$=.......,+.............. ~,..~~~.=......................
................. .?$+................. .......:::..... :~~== . ..... ..  .. .
................+87:............. .,.. .....:,~~...... .... ==+~ ......., .. .
.............~$Z+............... ...,:,~~.~=:..,=..............+=I. ..... .... .
...........+7I,. . ................,:~::~~~~,.....................,~?. .. .. .
...   ..,+Z$..........................................................?..... .
......~~$:............................................ .................,:.. .
 ..=,,$,................. ...................... ..... ...................,~. .
$I:.:+I=................ .......... ........................................=:
 :8=+.,?$:.......................................  .... .............    ..,,= .
"""
__version__ = '2.4.2'
version = __version__

# Add NullHandler to prevent logging warnings
import logging
try:
    # not available in python 2.6
    from logging import NullHandler
except ImportError:
    class NullHandler(logging.Handler):
        def emit(self, record):
            pass

logging.getLogger().addHandler(NullHandler())

# Import the Controller for extending
from helper.controller import Controller

# Conditionally import the OS platform support
import sys
if sys.platform == 'win32':
    from helper import windows as platform
else:
    from helper import unix as platform


# Import config and parser for start
from helper import config
from helper import parser


def start(ctrl):
    """Start the Helper controller either in the foreground or as a daemon
    process.

    :param ctrl helper.Controller: The controller class handle to create and run

    """
    args = parser.parse()
    obj = ctrl(args, platform.operating_system())
    if args.foreground:
        try:
            obj.start()
        except KeyboardInterrupt:
            obj.stop()
    else:
        try:
            with platform.Daemon(obj) as daemon:
                daemon.start()
        except (OSError, ValueError) as error:
            sys.stderr.write('\nError starting %s: %s\n\n' %
                             (sys.argv[0], error))
            sys.exit(1)

if __name__ == '__main__':
    start(Controller)
