/*
 * Decompiled with CFR 0.152.
 */
package com.swoval.files;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

class PeriodicTask
implements AutoCloseable {
    private static final AtomicInteger threadID = new AtomicInteger(0);
    private final CountDownLatch latch = new CountDownLatch(1);
    private final CountDownLatch shutdownLatch = new CountDownLatch(1);
    private final Runnable runnable;
    private final PeriodicThread thread;
    private final long pollIntervalMS;
    private final AtomicBoolean isClosed = new AtomicBoolean(false);

    PeriodicTask(Runnable runnable, long l) throws InterruptedException {
        this.runnable = runnable;
        this.pollIntervalMS = l;
        this.thread = new PeriodicThread();
    }

    @Override
    public void close() throws InterruptedException {
        if (this.isClosed.compareAndSet(false, true)) {
            this.thread.interrupt();
            this.shutdownLatch.await(5L, TimeUnit.SECONDS);
            this.thread.join(5000L);
        }
    }

    private class PeriodicThread
    extends Thread {
        PeriodicThread() throws InterruptedException {
            super("com.swoval.files.PeriodicThread-" + threadID.getAndIncrement());
            this.setDaemon(true);
            this.start();
            PeriodicTask.this.latch.await(5L, TimeUnit.SECONDS);
        }

        @Override
        public void run() {
            PeriodicTask.this.latch.countDown();
            while (!PeriodicTask.this.isClosed.get() && !Thread.currentThread().isInterrupted()) {
                try {
                    PeriodicTask.this.runnable.run();
                    Thread.sleep(PeriodicTask.this.pollIntervalMS);
                }
                catch (InterruptedException interruptedException) {
                    PeriodicTask.this.isClosed.set(true);
                }
            }
            PeriodicTask.this.shutdownLatch.countDown();
        }
    }
}

