/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.controlpanel.desktopintegrationeditor;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.Timer;
import net.sourceforge.swing.SwingUtils;

public class Blinker {
    private boolean blinking;
    private final JComponent compToBlink;

    public Blinker(JComponent compToBlink) {
        this.compToBlink = compToBlink;
    }

    public void blink() {
        if (this.blinking) {
            return;
        }
        this.blinking = true;
        Timer t = new Timer(100, new BlinkBody());
        t.setInitialDelay(0);
        t.start();
    }

    class BlinkBody
    implements ActionListener {
        int counter = 0;
        Color base;
        Color invert;

        BlinkBody() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ++this.counter;
            if (this.counter == 1) {
                this.base = Blinker.this.compToBlink.getBackground();
                this.invert = new Color(Math.min(255, this.base.getRed() * 2), Math.max(0, this.base.getGreen() / 2), 255 - this.base.getBlue());
            }
            if (this.counter == 5) {
                ((Timer)e.getSource()).stop();
                SwingUtils.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Blinker.this.compToBlink.setBackground(BlinkBody.this.base);
                        Blinker.this.blinking = false;
                    }
                });
                return;
            }
            SwingUtils.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (Blinker.this.compToBlink.getBackground().equals(BlinkBody.this.base)) {
                        Blinker.this.compToBlink.setBackground(BlinkBody.this.invert);
                    } else {
                        Blinker.this.compToBlink.setBackground(BlinkBody.this.base);
                    }
                }
            });
        }
    }
}

