<?php
// THIS FILE IS GENERATED
// WARNING! All changes made in this file will be lost!

/**
 * The number of arguments passed to script
 **/
$argc = array();

/**
 * Array of arguments passed to script
 **/
$argv = array();

/**
 * References all variables available in global scope
 *
 * @superglobal
 **/
$GLOBALS = array();

/**
 * HTTP Cookies
 *
 * @deprecated
 **/
$HTTP_COOKIE_VARS = array();

/**
 * Environment variables
 *
 * @deprecated
 **/
$HTTP_ENV_VARS = array();

/**
 * HTTP GET variables
 *
 * @deprecated
 **/
$HTTP_GET_VARS = array();

/**
 * HTTP File Upload variables
 *
 * @deprecated
 **/
$HTTP_POST_FILES = array();

/**
 * HTTP POST variables
 *
 * @deprecated
 **/
$HTTP_POST_VARS = array();

/**
 * Raw POST data
 **/
$HTTP_RAW_POST_DATA = array();

/**
 * HTTP response headers
 **/
$http_response_header = array();

/**
 * Session variables
 *
 * @deprecated
 **/
$HTTP_SESSION_VARS = array();

/**
 * The previous error message
 **/
$php_errormsg = array();

/**
 * HTTP Cookies
 *
 * @superglobal
 **/
$_COOKIE = array();

/**
 * Environment variables
 *
 * @superglobal
 **/
$_ENV = array();

/**
 * HTTP File Upload variables
 *
 * @superglobal
 **/
$_FILES = array();

/**
 * HTTP GET variables
 *
 * @superglobal
 **/
$_GET = array();

/**
 * HTTP POST variables
 *
 * @superglobal
 **/
$_POST = array();

/**
 * HTTP Request variables
 *
 * @superglobal
 **/
$_REQUEST = array();

/**
 * Server and execution environment information
 *
 * @superglobal
 **/
$_SERVER = array();

/**
 * Session variables
 *
 * @superglobal
 **/
$_SESSION = array();

/**
 * Interface to detect if a class is traversable using . Abstract base
 * interface that cannot be implemented alone. Instead it must be
 * implemented by either IteratorAggregate or Iterator. This interface
 * has no methods, its only purpose is to be the base interface for all
 * traversable classes.
 **/
interface Traversable {
}
/**
 * Interface for external iterators or objects that can be iterated
 * themselves internally. PHP already provides a number of iterators for
 * many day to day tasks. See SPL iterators for a list.
 **/
interface Iterator extends Traversable {
    /**
     * Return the current element
     *
     * Returns the current element.
     *
     * @return mixed Can return any type.
     * @since PHP 5, PHP 7
     **/
    public function current();

    /**
     * Return the key of the current element
     *
     * Returns the key of the current element.
     *
     * @return scalar Returns scalar on success, or NULL on failure.
     * @since PHP 5, PHP 7
     **/
    public function key();

    /**
     * Move forward to next element
     *
     * Moves the current position to the next element.
     *
     * @return void Any returned value is ignored.
     * @since PHP 5, PHP 7
     **/
    public function next();

    /**
     * Rewind the Iterator to the first element
     *
     * Rewinds back to the first element of the Iterator.
     *
     * @return void Any returned value is ignored.
     * @since PHP 5, PHP 7
     **/
    public function rewind();

    /**
     * Checks if current position is valid
     *
     * This method is called after Iterator::rewind and Iterator::next to
     * check if the current position is valid.
     *
     * @return bool The return value will be casted to boolean and then
     *   evaluated.
     * @since PHP 5, PHP 7
     **/
    public function valid();

}
/**
 * Throwable is the base interface for any object that can be thrown via
 * a statement in PHP 7, including Error and Exception.
 **/
interface Throwable {
    /**
     * Gets the exception code
     *
     * Returns the error code associated with the thrown object.
     *
     * @return int Returns the exception code as integer in Exception but
     *   possibly as other type in Exception descendants (for example as
     *   string in PDOException).
     * @since PHP 7
     **/
    public function getCode();

    /**
     * Gets the file in which the object was created
     *
     * Get the name of the file in which the thrown object was created.
     *
     * @return string Returns the filename in which the thrown object was
     *   created.
     * @since PHP 7
     **/
    public function getFile();

    /**
     * Gets the line on which the object was instantiated
     *
     * Returns the line number where the thrown object was instantiated.
     *
     * @return int Returns the line number where the thrown object was
     *   instantiated.
     * @since PHP 7
     **/
    public function getLine();

    /**
     * Gets the message
     *
     * Returns the message associated with the thrown object.
     *
     * @return string Returns the message associated with the thrown
     *   object.
     * @since PHP 7
     **/
    public function getMessage();

    /**
     * Returns the previous Throwable
     *
     * Returns any previous Throwable (for example, one provided as the third
     * parameter to Exception::__construct).
     *
     * @return Throwable Returns the previous Throwable if available, or
     *   NULL otherwise.
     * @since PHP 7
     **/
    public function getPrevious();

    /**
     * Gets the stack trace
     *
     * Returns the stack trace as an array.
     *
     * @return array Returns the stack trace as an array in the same format
     *   as {@link debug_backtrace}.
     * @since PHP 7
     **/
    public function getTrace();

    /**
     * Gets the stack trace as a string
     *
     * @return string Returns the stack trace as a string.
     * @since PHP 7
     **/
    public function getTraceAsString();

    /**
     * Gets a string representation of the thrown object
     *
     * @return string Returns the string representation of the thrown
     *   object.
     * @since PHP 7
     **/
    public function __toString();

}
/**
 * Error is the base class for all internal PHP errors.
 **/
class Error implements Throwable {
    /**
     * The error code
     *
     * @var int
     **/
    protected $code;

    /**
     * The filename where the error happened
     *
     * @var string
     **/
    protected $file;

    /**
     * The line where the error happened
     *
     * @var int
     **/
    protected $line;

    /**
     * The error message
     *
     * @var string
     **/
    protected $message;

    /**
     * Gets the error code
     *
     * Returns the error code.
     *
     * @return mixed Returns the error code as integer
     **/
    final public function getCode(){}

    /**
     * Gets the file in which the error occurred
     *
     * Get the name of the file the error occurred.
     *
     * @return string Returns the filename in which the error occurred.
     **/
    final public function getFile(){}

    /**
     * Gets the line in which the error occurred
     *
     * Get line number where the error occurred.
     *
     * @return int Returns the line number where the error occurred.
     **/
    final public function getLine(){}

    /**
     * Gets the error message
     *
     * Returns the error message.
     *
     * @return string Returns the error message as a string.
     **/
    final public function getMessage(){}

    /**
     * Returns previous Throwable
     *
     * Returns previous Throwable (the third parameter of
     * Error::__construct).
     *
     * @return Throwable Returns the previous Throwable if available or
     *   NULL otherwise.
     **/
    final public function getPrevious(){}

    /**
     * Gets the stack trace
     *
     * Returns the stack trace.
     *
     * @return array Returns the stack trace as an array.
     **/
    final public function getTrace(){}

    /**
     * Gets the stack trace as a string
     *
     * Returns the stack trace as a string.
     *
     * @return string Returns the stack trace as a string.
     **/
    final public function getTraceAsString(){}

    /**
     * Clone the error
     *
     * Error can not be cloned, so this method results in fatal error.
     *
     * @return void
     **/
    final private function __clone(){}

    /**
     * String representation of the error
     *
     * Returns the string representation of the error.
     *
     * @return string Returns the string representation of the error.
     **/
    public function __toString(){}

}
/**
 * Exception is the base class for all Exceptions in PHP 5, and the base
 * class for all user exceptions in PHP 7. Before PHP 7, Exception did
 * not implement the Throwable interface.
 **/
class Exception implements Throwable {
    /**
     * The exception code
     *
     * @var int
     **/
    protected $code;

    /**
     * The filename where the exception was created
     *
     * @var string
     **/
    protected $file;

    /**
     * The line where the exception was created
     *
     * @var int
     **/
    protected $line;

    /**
     * The exception message
     *
     * @var string
     **/
    protected $message;

    /**
     * Gets the Exception code
     *
     * Returns the Exception code.
     *
     * @return mixed Returns the exception code as integer in Exception but
     *   possibly as other type in Exception descendants (for example as
     *   string in PDOException).
     * @since PHP 5, PHP 7
     **/
    final public function getCode(){}

    /**
     * Gets the file in which the exception was created
     *
     * Get the name of the file in which the exception was created.
     *
     * @return string Returns the filename in which the exception was
     *   created.
     * @since PHP 5, PHP 7
     **/
    final public function getFile(){}

    /**
     * Gets the line in which the exception was created
     *
     * Get line number where the exception was created.
     *
     * @return int Returns the line number where the exception was created.
     * @since PHP 5, PHP 7
     **/
    final public function getLine(){}

    /**
     * Gets the Exception message
     *
     * Returns the Exception message.
     *
     * @return string Returns the Exception message as a string.
     * @since PHP 5, PHP 7
     **/
    final public function getMessage(){}

    /**
     * Returns previous Exception
     *
     * Returns previous exception (the third parameter of
     * Exception::__construct).
     *
     * @return Throwable Returns the previous Throwable if available or
     *   NULL otherwise.
     * @since PHP 5 >= 5.3.0, PHP 7
     **/
    final public function getPrevious(){}

    /**
     * Gets the stack trace
     *
     * Returns the Exception stack trace.
     *
     * @return array Returns the Exception stack trace as an array.
     * @since PHP 5, PHP 7
     **/
    final public function getTrace(){}

    /**
     * Gets the stack trace as a string
     *
     * Returns the Exception stack trace as a string.
     *
     * @return string Returns the Exception stack trace as a string.
     * @since PHP 5, PHP 7
     **/
    final public function getTraceAsString(){}

    /**
     * Clone the exception
     *
     * Tries to clone the Exception, which results in Fatal error.
     *
     * @return void
     * @since PHP 5, PHP 7
     **/
    final private function __clone(){}

    /**
     * String representation of the exception
     *
     * Returns the string representation of the exception.
     *
     * @return string Returns the string representation of the exception.
     * @since PHP 5, PHP 7
     **/
    public function __toString(){}

}
/**
 * The APCIterator class makes it easier to iterate over large APC
 * caches. This is helpful as it allows iterating over large caches in
 * steps, while grabbing a defined number of entries per lock instance,
 * so it frees the cache locks for other activities rather than hold up
 * the entire cache to grab 100 (the default) entries. Also, using
 * regular expression matching is more efficient as it's been moved to
 * the C level.
 **/
class APCIterator implements Iterator {
    /**
     * Get current item
     *
     * Gets the current item from the APCIterator stack.
     *
     * @return mixed Returns the current item on success, or FALSE if no
     *   more items or exist, or on failure.
     * @since PECL apc >= 3.1.1
     **/
    public function current(){}

    /**
     * Get total count
     *
     * Get the total count.
     *
     * @return int The total count.
     * @since PECL apc >= 3.1.1
     **/
    public function getTotalCount(){}

    /**
     * Get total cache hits
     *
     * Gets the total number of cache hits.
     *
     * @return int The number of hits on success, or FALSE on failure.
     * @since PECL apc >= 3.1.1
     **/
    public function getTotalHits(){}

    /**
     * Get total cache size
     *
     * Gets the total cache size.
     *
     * @return int The total cache size.
     * @since PECL apc >= 3.1.1
     **/
    public function getTotalSize(){}

    /**
     * Get iterator key
     *
     * Gets the current iterator key.
     *
     * @return string Returns the key on success, or FALSE upon failure.
     * @since PECL apc >= 3.1.1
     **/
    public function key(){}

    /**
     * Move pointer to next item
     *
     * Moves the iterator pointer to the next element.
     *
     * @return bool
     * @since PECL apc >= 3.1.1
     **/
    public function next(){}

    /**
     * Rewinds iterator
     *
     * Rewinds back the iterator to the first element.
     *
     * @return void
     * @since PECL apc >= 3.1.1
     **/
    public function rewind(){}

    /**
     * Checks if current position is valid
     *
     * Checks if the current iterator position is valid.
     *
     * @return bool Returns TRUE if the current iterator position is valid,
     *   otherwise FALSE.
     * @since PECL apc >= 3.1.1
     **/
    public function valid(){}

    /**
     * Constructs an APCIterator iterator object
     *
     * Constructs an APCIterator object.
     *
     * @param string $cache The cache type, which will be user or file.
     * @param mixed $search A PCRE regular expression that matches against
     *   APC key names, either as a string for a single regular expression,
     *   or as an array of regular expressions. Or, optionally pass in NULL
     *   to skip the search.
     * @param int $format The desired format, as configured with one or
     *   more of the APC_ITER_* constants.
     * @param int $chunk_size The chunk size. Must be a value greater than
     *   0. The default value is 100.
     * @param int $list The type to list. Either pass in APC_LIST_ACTIVE or
     *   APC_LIST_DELETED.
     * @since PECL apc >= 3.1.1
     **/
    public function __construct($cache, $search, $format, $chunk_size, $list){}

}
/**
 * The APCUIterator class makes it easier to iterate over large APCu
 * caches. This is helpful as it allows iterating over large caches in
 * steps, while grabbing a defined number of entries per lock instance,
 * so it frees the cache locks for other activities rather than hold up
 * the entire cache to grab 100 (the default) entries. Also, using
 * regular expression matching is more efficient as it's been moved to
 * the C level.
 **/
class APCUIterator implements Iterator {
    /**
     * Get current item
     *
     * Gets the current item from the APCUIterator stack.
     *
     * @return mixed Returns the current item on success, or FALSE if no
     *   more items or exist, or on failure.
     * @since PECL apcu >= 5.0.0
     **/
    public function current(){}

    /**
     * Get total count
     *
     * Get the total count.
     *
     * @return int The total count.
     * @since PECL apcu >= 5.0.0
     **/
    public function getTotalCount(){}

    /**
     * Get total cache hits
     *
     * Gets the total number of cache hits.
     *
     * @return int The number of hits on success, or FALSE on failure.
     * @since PECL apcu >= 5.0.0
     **/
    public function getTotalHits(){}

    /**
     * Get total cache size
     *
     * Gets the total cache size.
     *
     * @return int The total cache size.
     * @since PECL apcu >= 5.0.0
     **/
    public function getTotalSize(){}

    /**
     * Get iterator key
     *
     * Gets the current iterator key.
     *
     * @return string Returns the key on success, or FALSE upon failure.
     * @since PECL apcu >= 5.0.0
     **/
    public function key(){}

    /**
     * Move pointer to next item
     *
     * Moves the iterator pointer to the next element.
     *
     * @return bool
     * @since PECL apcu >= 5.0.0
     **/
    public function next(){}

    /**
     * Rewinds iterator
     *
     * Rewinds back the iterator to the first element.
     *
     * @return void
     * @since PECL apcu >= 5.0.0
     **/
    public function rewind(){}

    /**
     * Checks if current position is valid
     *
     * Checks if the current iterator position is valid.
     *
     * @return bool Returns TRUE if the current iterator position is valid,
     *   otherwise FALSE.
     * @since PECL apcu >= 5.0.0
     **/
    public function valid(){}

    /**
     * Constructs an APCUIterator iterator object
     *
     * Constructs an APCUIterator object.
     *
     * @param mixed $search A PCRE regular expression that matches against
     *   APCu key names, either as a string for a single regular expression,
     *   or as an array of regular expressions. Or, optionally pass in NULL
     *   to skip the search.
     * @param int $format The desired format, as configured with one or
     *   more of the APC_ITER_* constants.
     * @param int $chunk_size The chunk size. Must be a value greater than
     *   0. The default value is 100.
     * @param int $list The type to list. Either pass in APC_LIST_ACTIVE or
     *   APC_LIST_DELETED.
     * @since PECL apcu >= 5.0.0
     **/
    public function __construct($search, $format, $chunk_size, $list){}

}
/**
 * An Iterator that iterates over several iterators one after the other.
 **/
class AppendIterator extends IteratorIterator implements OuterIterator {
    /**
     * Appends an iterator
     *
     * @param Iterator $iterator The iterator to append.
     * @return void
     * @since PHP 5 >= 5.1.0, PHP 7
     **/
    public function append($iterator){}

    /**
     * Gets the current value
     *
     * @return mixed The current value if it is valid or NULL otherwise.
     * @since PHP 5 >= 5.1.0, PHP 7
     **/
    public function current(){}

    /**
     * Gets the ArrayIterator
     *
     * This method gets the ArrayIterator that is used to store the iterators
     * added with AppendIterator::append.
     *
     * @return ArrayIterator Returns an ArrayIterator containing the
     *   appended iterators.
     * @since PHP 5 >= 5.2.0, PHP 7
     **/
    public function getArrayIterator(){}

    /**
     * Gets the inner iterator
     *
     * This method returns the current inner iterator.
     *
     * @return Iterator The current inner iterator, or NULL if there is not
     *   one.
     * @since PHP 5 >= 5.1.0, PHP 7
     **/
    public function getInnerIterator(){}

    /**
     * Gets an index of iterators
     *
     * Gets the index of the current inner iterator.
     *
     * @return int Returns an integer, which is the zero-based index of the
     *   current inner iterator.
     * @since PHP 5 >= 5.2.0, PHP 7
     **/
    public function getIteratorIndex(){}

    /**
     * Gets the current key
     *
     * Get the current key.
     *
     * @return scalar The current key if it is valid or NULL otherwise.
     * @since PHP 5 >= 5.1.0, PHP 7
     **/
    public function key(){}

    /**
     * Moves to the next element
     *
     * Moves to the next element. If this means to another Iterator then it
     * rewinds that Iterator.
     *
     * @return void
     * @since PHP 5 >= 5.1.0, PHP 7
     **/
    public function next(){}

    /**
     * Rewinds the Iterator
     *
     * Rewind to the first element of the first inner Iterator.
     *
     * @return void
     * @since PHP 5 >= 5.1.0, PHP 7
     **/
    public function rewind(){}

    /**
     * Checks validity of the current element
     *
     * @return bool Returns TRUE if the current iteration is valid, FALSE
     *   otherwise.
     * @since PHP 5 >= 5.1.0, PHP 7
     **/
    public function valid(){}

}
/**
 * ArgumentCountError is thrown when too few arguments are passed to a
 * user-defined function or method.
 **/
class ArgumentCountError extends TypeError {
}
/**
 * ArithmeticError is thrown when an error occurs while performing
 * mathematical operations. In PHP 7.0, these errors include attempting
 * to perform a bitshift by a negative amount, and any call to {@link
 * intdiv} that would result in a value outside the possible bounds of an
 * integer.
 **/
class ArithmeticError extends Error {
}
/**
 * Interface to provide accessing objects as arrays.
 **/
interface ArrayAccess {
    /**
     * Whether an offset exists
     *
     * Whether or not an offset exists.
     *
     * This method is executed when using {@link isset} or {@link empty} on
     * objects implementing ArrayAccess.
     *
     * @param mixed $offset An offset to check for.
     * @return bool
     * @since PHP 5, PHP 7
     **/
    public function offsetExists($offset);

    /**
     * Offset to retrieve
     *
     * Returns the value at specified offset.
     *
     * This method is executed when checking if offset is {@link empty}.
     *
     * @param mixed $offset The offset to retrieve.
     * @return mixed Can return all value types.
     * @since PHP 5, PHP 7
     **/
    public function offsetGet($offset);

    /**
     * Assign a value to the specified offset
     *
     * Assigns a value to the specified offset.
     *
     * @param mixed $offset The offset to assign the value to.
     * @param mixed $value The value to set.
     * @return void
     * @since PHP 5, PHP 7
     **/
    public function offsetSet($offset, $value);

    /**
     * Unset an offset
     *
     * Unsets an offset.
     *
     * @param mixed $offset The offset to unset.
     * @return void
     * @since PHP 5, PHP 7
     **/
    public function offsetUnset($offset);

}
/**
 * This iterator allows to unset and modify values and keys while
 * iterating over Arrays and Objects. When you want to iterate over the
 * same array multiple times you need to instantiate ArrayObject and let
 * it create ArrayIterator instances that refer to it either by using or
 * by calling its getIterator() method manually.
 **/
class ArrayIterator implements ArrayAccess, SeekableIterator, Countable, Serializable {
    /**
     * Entries can be accessed as properties (read and write).
     *
     * @var mixed
     **/
    const ARRAY_AS_PROPS = 0;

    /**
     * Properties of the object have their normal functionality when accessed
     * as list (var_dump, foreach, etc.).
     *
     * @var mixed
     **/
    const STD_PROP_LIST = 0;

    /**
     * Append an element
     *
     * Appends value as the last element.
     *
     * @param mixed $value The value to append.
     * @return void
     * @since PHP 5, PHP 7
     **/
    public function append($value){}

    /**
     * Sort array by values
     *
     * Sorts an array by values.
     *
     * @return void
     * @since PHP 5 >= 5.2.0, PHP 7
     **/
    public function asort(){}

    /**
     * Count elements
     *
     * Gets the number of elements in the array, or the number of public
     * properties in the object.
     *
     * @return int The number of elements or public properties in the
     *   associated array or object, respectively.
     * @since PHP 5, PHP 7
     **/
    public function count(){}

    /**
     * Return current array entry
     *
     * Get the current array entry.
     *
     * @return mixed The current array entry.
     * @since PHP 5, PHP 7
     **/
    public function current(){}

    /**
     * Get array copy
     *
     * Get a copy of an array.
     *
     * @return array A copy of the array, or array of public properties if
     *   ArrayIterator refers to an object.
     * @since PHP 5, PHP 7
     **/
    public function getArrayCopy(){}

    /**
     * Get behavior flags
     *
     * Gets the behavior flags of the ArrayIterator. See the
     * ArrayIterator::setFlags method for a list of the available flags.
     *
     * @return int Returns the behavior flags of the ArrayIterator.
     * @since PHP 5 >= 5.1.0, PHP 7
     **/
    public function getFlags(){}

    /**
     * Return current array key
     *
     * This function returns the current array key
     *
     * @return mixed The current array key.
     * @since PHP 5, PHP 7
     **/
    public function key(){}

    /**
     * Sort array by keys
     *
     * Sorts an array by the keys.
     *
     * @return void
     * @since PHP 5 >= 5.2.0, PHP 7
     **/
    public function ksort(){}

    /**
     * Sort an array naturally, case insensitive
     *
     * Sort the entries by values using a case insensitive "natural order"
     * algorithm.
     *
     * @return void
     * @since PHP 5 >= 5.2.0, PHP 7
     **/
    public function natcasesort(){}

    /**
     * Sort an array naturally
     *
     * Sort the entries by values using "natural order" algorithm.
     *
     * @return void
     * @since PHP 5 >= 5.2.0, PHP 7
     **/
    public function natsort(){}

    /**
     * Move to next entry
     *
     * The iterator to the next entry.
     *
     * @return void
     * @since PHP 5, PHP 7
     **/
    public function next(){}

    /**
     * Check if offset exists
     *
     * Checks if the offset exists.
     *
     * @param mixed $index The offset being checked.
     * @return bool TRUE if the offset exists, otherwise FALSE
     * @since PHP 5, PHP 7
     **/
    public function offsetExists($index){}

    /**
     * Get value for an offset
     *
     * Gets the value from the provided offset.
     *
     * @param mixed $index The offset to get the value from.
     * @return mixed The value at offset {@link index}.
     * @since PHP 5, PHP 7
     **/
    public function offsetGet($index){}

    /**
     * Set value for an offset
     *
     * Sets a value for a given offset.
     *
     * @param mixed $index The index to set for.
     * @param mixed $newval The new value to store at the index.
     * @return void
     * @since PHP 5, PHP 7
     **/
    public function offsetSet($index, $newval){}

    /**
     * Unset value for an offset
     *
     * Unsets a value for an offset.
     *
     * @param mixed $index The offset to unset.
     * @return void
     * @since PHP 5, PHP 7
     **/
    public function offsetUnset($index){}

    /**
     * Rewind array back to the start
     *
     * This rewinds the iterator to the beginning.
     *
     * @return void
     * @since PHP 5, PHP 7
     **/
    public function rewind(){}

    /**
     * Seek to position
     *
     * @param int $position The position to seek to.
     * @return void
     * @since PHP 5, PHP 7
     **/
    public function seek($position){}

    /**
     * Serialize
     *
     * @return string The serialized ArrayIterator.
     * @since PHP 5 >= 5.3.0, PHP 7
     **/
    public function serialize(){}

    /**
     * Set behaviour flags
     *
     * Set the flags that change the behavior of the ArrayIterator.
     *
     * @param string $flags The new ArrayIterator behavior. It takes on
     *   either a bitmask, or named constants. Using named constants is
     *   strongly encouraged to ensure compatibility for future versions. The
     *   available behavior flags are listed below. The actual meanings of
     *   these flags are described in the predefined constants. ArrayIterator
     *   behavior flags value constant 1 ArrayIterator::STD_PROP_LIST 2
     *   ArrayIterator::ARRAY_AS_PROPS
     * @return void
     * @since PHP 5 >= 5.1.0, PHP 7
     **/
    public function setFlags($flags){}

    /**
     * Sort with a user-defined comparison function and maintain index
     * association
     *
     * This method sorts the elements such that indices maintain their
     * correlation with the values they are associated with, using a
     * user-defined comparison function.
     *
     * @param callable $cmp_function
     * @return void
     * @since PHP 5 >= 5.2.0, PHP 7
     **/
    public function uasort($cmp_function){}

    /**
     * Sort by keys using a user-defined comparison function
     *
     * This method sorts the elements by keys using a user-supplied
     * comparison function.
     *
     * @param callable $cmp_function
     * @return void
     * @since PHP 5 >= 5.2.0, PHP 7
     **/
    public function uksort($cmp_function){}

    /**
     * Unserialize
     *
     * @param string $serialized The serialized ArrayIterator object to be
     *   unserialized.
     * @return void
     * @since PHP 5 >= 5.3.0, PHP 7
     **/
    public function unserialize($serialized){}

    /**
     * Check whether array contains more entries
     *
     * Checks if the array contains any more entries.
     *
     * @return bool Returns TRUE if the iterator is valid, otherwise FALSE
     * @since PHP 5, PHP 7
     **/
    public function valid(){}

    /**
     * Construct an ArrayIterator
     *
     * Constructs an ArrayIterator object.
     *
     * @param mixed $array The array or object to be iterated on.
     * @param int $flags Flags to control the behaviour of the
     *   ArrayIterator object. See ArrayIterator::setFlags.
     * @since PHP 5, PHP 7
     **/
    public function __construct($array, $flags){}

}
/**
 * This class allows objects to work as arrays.
 **/
class ArrayObject implements IteratorAggregate, ArrayAccess, Serializable, Countable {
    /**
     * Entries can be accessed as properties (read and write).
     *
     * @var mixed
     **/
    const ARRAY_AS_PROPS = 0;

    /**
     * Properties of the object have their normal functionality when accessed
     * as list (var_dump, foreach, etc.).
     *
     * @var mixed
     **/
    const STD_PROP_LIST = 0;

    /**
     * Appends the value
     *
     * Appends a new value as the last element.
     *
     * @param mixed $value The value being appended.
     * @return void
     * @since PHP 5, PHP 7
     **/
    public function append($value){}

    /**
     * Sort the entries by value
     *
     * Sorts the entries such that the keys maintain their correlation with
     * the entries they are associated with. This is used mainly when sorting
     * associative arrays where the actual element order is significant.
     *
     * @return void
     * @since PHP 5 >= 5.2.0, PHP 7
     **/
    public function asort(){}

    /**
     * Get the number of public properties in the ArrayObject
     *
     * Get the number of public properties in the ArrayObject.
     *
     * @return int The number of public properties in the ArrayObject.
     * @since PHP 5, PHP 7
     **/
    public function count(){}

    /**
     * Exchange the array for another one
     *
     * Exchange the current array with another array or object.
     *
     * @param mixed $input The new array or object to exchange with the
     *   current array.
     * @return array Returns the old array.
     * @since PHP 5 >= 5.1.0, PHP 7
     **/
    public function exchangeArray($input){}

    /**
     * Creates a copy of the ArrayObject
     *
     * Exports the ArrayObject to an array.
     *
     * @return array Returns a copy of the array. When the ArrayObject
     *   refers to an object, an array of the public properties of that
     *   object will be returned.
     * @since PHP 5, PHP 7
     **/
    public function getArrayCopy(){}

    /**
     * Gets the behavior flags
     *
     * Gets the behavior flags of the ArrayObject. See the
     * ArrayObject::setFlags method for a list of the available flags.
     *
     * @return int Returns the behavior flags of the ArrayObject.
     * @since PHP 5 >= 5.1.0, PHP 7
     **/
    public function getFlags(){}

    /**
     * Create a new iterator from an ArrayObject instance
     *
     * Create a new iterator from an ArrayObject instance.
     *
     * @return ArrayIterator An iterator from an ArrayObject.
     * @since PHP 5, PHP 7
     **/
    public function getIterator(){}

    /**
     * Gets the iterator classname for the ArrayObject
     *
     * Gets the class name of the array iterator that is used by
     * ArrayObject::getIterator().
     *
     * @return string Returns the iterator class name that is used to
     *   iterate over this object.
     * @since PHP 5 >= 5.1.0, PHP 7
     **/
    public function getIteratorClass(){}

    /**
     * Sort the entries by key
     *
     * Sorts the entries by key, maintaining key to entry correlations. This
     * is useful mainly for associative arrays.
     *
     * @return void
     * @since PHP 5 >= 5.2.0, PHP 7
     **/
    public function ksort(){}

    /**
     * Sort an array using a case insensitive "natural order" algorithm
     *
     * This method is a case insensitive version of ArrayObject::natsort.
     *
     * This method implements a sort algorithm that orders alphanumeric
     * strings in the way a human being would while maintaining key/value
     * associations. This is described as a "natural ordering".
     *
     * @return void
     * @since PHP 5 >= 5.2.0, PHP 7
     **/
    public function natcasesort(){}

    /**
     * Sort entries using a "natural order" algorithm
     *
     * This method implements a sort algorithm that orders alphanumeric
     * strings in the way a human being would while maintaining key/value
     * associations. This is described as a "natural ordering". An example of
     * the difference between this algorithm and the regular computer string
     * sorting algorithms (used in ArrayObject::asort) method can be seen in
     * the example below.
     *
     * @return void
     * @since PHP 5 >= 5.2.0, PHP 7
     **/
    public function natsort(){}

    /**
     * Returns whether the requested index exists
     *
     * @param mixed $index The index being checked.
     * @return bool TRUE if the requested index exists, otherwise FALSE
     * @since PHP 5, PHP 7
     **/
    public function offsetExists($index){}

    /**
     * Returns the value at the specified index
     *
     * @param mixed $index The index with the value.
     * @return mixed The value at the specified index or NULL.
     * @since PHP 5, PHP 7
     **/
    public function offsetGet($index){}

    /**
     * Sets the value at the specified index to newval
     *
     * @param mixed $index The index being set.
     * @param mixed $newval The new value for the {@link index}.
     * @return void
     * @since PHP 5, PHP 7
     **/
    public function offsetSet($index, $newval){}

    /**
     * Unsets the value at the specified index
     *
     * @param mixed $index The index being unset.
     * @return void
     * @since PHP 5, PHP 7
     **/
    public function offsetUnset($index){}

    /**
     * Serialize an ArrayObject
     *
     * Serializes an ArrayObject.
     *
     * @return string The serialized representation of the ArrayObject.
     * @since PHP 5 >= 5.3.0, PHP 7
     **/
    public function serialize(){}

    /**
     * Sets the behavior flags
     *
     * Set the flags that change the behavior of the ArrayObject.
     *
     * @param int $flags The new ArrayObject behavior. It takes on either a
     *   bitmask, or named constants. Using named constants is strongly
     *   encouraged to ensure compatibility for future versions. The
     *   available behavior flags are listed below. The actual meanings of
     *   these flags are described in the predefined constants. ArrayObject
     *   behavior flags value constant 1 ArrayObject::STD_PROP_LIST 2
     *   ArrayObject::ARRAY_AS_PROPS
     * @return void
     * @since PHP 5 >= 5.1.0, PHP 7
     **/
    public function setFlags($flags){}

    /**
     * Sets the iterator classname for the ArrayObject
     *
     * Sets the classname of the array iterator that is used by
     * ArrayObject::getIterator().
     *
     * @param string $iterator_class The classname of the array iterator to
     *   use when iterating over this object.
     * @return void
     * @since PHP 5 >= 5.1.0, PHP 7
     **/
    public function setIteratorClass($iterator_class){}

    /**
     * Sort the entries with a user-defined comparison function and maintain
     * key association
     *
     * This function sorts the entries such that keys maintain their
     * correlation with the entry that they are associated with, using a
     * user-defined comparison function.
     *
     * This is used mainly when sorting associative arrays where the actual
     * element order is significant.
     *
     * @param callable $cmp_function Function {@link cmp_function} should
     *   accept two parameters which will be filled by pairs of entries. The
     *   comparison function must return an integer less than, equal to, or
     *   greater than zero if the first argument is considered to be
     *   respectively less than, equal to, or greater than the second.
     * @return void
     * @since PHP 5 >= 5.2.0, PHP 7
     **/
    public function uasort($cmp_function){}

    /**
     * Sort the entries by keys using a user-defined comparison function
     *
     * This function sorts the keys of the entries using a user-supplied
     * comparison function. The key to entry correlations will be maintained.
     *
     * @param callable $cmp_function The callback comparison function.
     *   Function {@link cmp_function} should accept two parameters which
     *   will be filled by pairs of entry keys. The comparison function must
     *   return an integer less than, equal to, or greater than zero if the
     *   first argument is considered to be respectively less than, equal to,
     *   or greater than the second.
     * @return void
     * @since PHP 5 >= 5.2.0, PHP 7
     **/
    public function uksort($cmp_function){}

    /**
     * Unserialize an ArrayObject
     *
     * Unserializes a serialized ArrayObject.
     *
     * @param string $serialized The serialized ArrayObject.
     * @return void The unserialized ArrayObject.
     * @since PHP 5 >= 5.3.0, PHP 7
     **/
    public function unserialize($serialized){}

}
/**
 * AssertionError is thrown when an assertion made via {@link assert}
 * fails.
 **/
class AssertionError extends Error {
}
/**
 * Exception thrown if a callback refers to an undefined function or if
 * some arguments are missing.
 **/
class BadFunctionCallException extends LogicException {
}
/**
 * Exception thrown if a callback refers to an undefined method or if
 * some arguments are missing.
 **/
class BadMethodCallException extends BadFunctionCallException {
}
/**
 * This object supports cached iteration over another iterator.
 **/
class CachingIterator extends IteratorIterator implements OuterIterator, ArrayAccess, Countable {
    /**
     * @var integer
     **/
    const CALL_TOSTRING = 0;

    /**
     * @var integer
     **/
    const CATCH_GET_CHILD = 0;

    /**
     * @var integer
     **/
    const FULL_CACHE = 0;

    /**
     * @var integer
     **/
    const TOSTRING_USE_CURRENT = 0;

    /**
     * @var integer
     **/
    const TOSTRING_USE_INNER = 0;

    /**
     * @var integer
     **/
    const TOSTRING_USE_KEY = 0;

    /**
     * The number of elements in the iterator
     *
     * May return the number of elements in the iterator.
     *
     * @return int The count of the elements iterated over.
     * @since PHP 5 >= 5.2.2, PHP 7
     **/
    public function count(){}

    /**
     * Return the current element
     *
     * May return the current element in the iteration.
     *
     * @return mixed Mixed
     * @since PHP 5, PHP 7
     **/
    public function current(){}

    /**
     * Retrieve the contents of the cache
     *
     * @return array An array containing the cache items.
     * @since PHP 5 >= 5.2.0, PHP 7
     **/
    public function getCache(){}

    /**
     * Get flags used
     *
     * Get the bitmask of the flags used for this CachingIterator instance.
     *
     * @return int Description...
     * @since PHP 5 >= 5.2.0, PHP 7
     **/
    public function getFlags(){}

    /**
     * Returns the inner iterator
     *
     * Returns the iterator sent to the constructor.
     *
     * @return Iterator Returns an object implementing the Iterator
     *   interface.
     * @since PHP 5, PHP 7
     **/
    public function getInnerIterator(){}

    /**
     * Check whether the inner iterator has a valid next element
     *
     * @return void
     * @since PHP 5, PHP 7
     **/
    public function hasNext(){}

    /**
     * Return the key for the current element
     *
     * This method may return a key for the current element.
     *
     * @return scalar
     * @since PHP 5, PHP 7
     **/
    public function key(){}

    /**
     * Move the iterator forward
     *
     * @return void
     * @since PHP 5, PHP 7
     **/
    public function next(){}

    /**
     * The offsetExists purpose
     *
     * @param mixed $index The index being checked.
     * @return void Returns TRUE if an entry referenced by the offset
     *   exists, FALSE otherwise.
     * @since PHP 5 >= 5.2.0, PHP 7
     **/
    public function offsetExists($index){}

    /**
     * The offsetGet purpose
     *
     * @param string $index Description...
     * @return void Description...
     * @since PHP 5 >= 5.2.0, PHP 7
     **/
    public function offsetGet($index){}

    /**
     * The offsetSet purpose
     *
     * @param mixed $index The index of the element to be set.
     * @param mixed $newval The new value for the {@link index}.
     * @return void
     * @since PHP 5 >= 5.2.0, PHP 7
     **/
    public function offsetSet($index, $newval){}

    /**
     * The offsetUnset purpose
     *
     * @param string $index The index of the element to be unset.
     * @return void
     * @since PHP 5 >= 5.2.0, PHP 7
     **/
    public function offsetUnset($index){}

    /**
     * Rewind the iterator
     *
     * @return void
     * @since PHP 5, PHP 7
     **/
    public function rewind(){}

    /**
     * The setFlags purpose
     *
     * Set the flags for the CachingIterator object.
     *
     * @param int $flags Bitmask of the flags to set.
     * @return void
     * @since PHP 5 >= 5.2.0, PHP 7
     **/
    public function setFlags($flags){}

    /**
     * Check whether the current element is valid
     *
     * @return void
     * @since PHP 5, PHP 7
     **/
    public function valid(){}

    /**
     * Construct a new CachingIterator object for the iterator
     *
     * @param Iterator $iterator Iterator to cache
     * @param int $flags Bitmask of flags.
     * @since PHP 5, PHP 7
     **/
    public function __construct($iterator, $flags){}

    /**
     * Return the string representation of the current element
     *
     * Get the string representation of the current element.
     *
     * @return void The string representation of the current element.
     * @since PHP 5, PHP 7
     **/
    public function __toString(){}

}
/**
 * Simple class with some static helper methods.
 **/
class Cairo {
    /**
     * Retrieves the availables font types
     *
     * Returns an array with the available font backends
     *
     * @return array A list-type array with all available font backends.
     * @since PECL cairo >= 0.1.0
     **/
    public static function availableFonts(){}

    /**
     * Retrieves all available surfaces
     *
     * Returns an array with the available surface backends
     *
     * @return array A list-type array with all available surface backends.
     * @since PECL cairo >= 0.1.0
     **/
    public static function availableSurfaces(){}

    /**
     * Retrieves the current status as string
     *
     * Retrieves the current status as a readable string
     *
     * @param int $status A valid status code given by {@link cairo_status}
     *   or CairoContext::status
     * @return string A string containing the current status of a
     *   CairoContext object
     * @since PECL cairo >= 0.1.0
     **/
    public static function statusToString($status){}

    /**
     * Retrieves cairo's library version
     *
     * Retrieves the current version of the cairo library as an integer value
     *
     * @return int Current Cairo library version integer
     * @since PECL cairo >= 0.1.0
     **/
    public static function version(){}

    /**
     * Retrieves cairo version as string
     *
     * Retrieves the current cairo library version as a string.
     *
     * @return string Current Cairo library version string
     * @since PECL cairo >= 0.1.0
     **/
    public static function versionString(){}

}
/**
 * Enum class that specifies the type of antialiasing to do when
 * rendering text or shapes.
 **/
class CairoAntialias {
    /**
     * @var integer
     **/
    const MODE_DEFAULT = 0;

    /**
     * @var integer
     **/
    const MODE_GRAY = 0;

    /**
     * @var integer
     **/
    const MODE_NONE = 0;

    /**
     * @var integer
     **/
    const MODE_SUBPIXEL = 0;

}
/**
 * CairoContent is used to describe the content that a surface will
 * contain, whether color information, alpha information (translucence
 * vs. opacity), or both. Note: The large values here are designed to
 * keep CairoContent values distinct from CairoContent values so that the
 * implementation can detect the error if users confuse the two types.
 **/
class CairoContent {
    /**
     * The surface will hold alpha content only.
     *
     * @var integer
     **/
    const ALPHA = 0;

    /**
     * The surface will hold color content only.
     *
     * @var integer
     **/
    const COLOR = 0;

    /**
     * @var integer
     **/
    const COLOR_ALPHA = 0;

}
/**
 * Context is the main object used when drawing with cairo. To draw with
 * cairo, you create a CairoContext, set the target CairoSurface, and
 * drawing options for the CairoContext, create shapes with functions .
 * like CairoContext::moveTo and CairoContext::lineTo, and then draw
 * shapes with CairoContext::stroke or CairoContext::fill.
 *
 * Contexts can be pushed to a stack via CairoContext::save. They may
 * then safely be changed, without losing the current state. Use
 * CairoContext::restore to restore to the saved state.
 **/
class CairoContext {
    /**
     * Appends a path to current path
     *
     * Appends the {@link path} onto the current path. The {@link path} may
     * be either the return value from one of CairoContext::copyPath or
     * CairoContext::copyPathFlat;
     *
     * if {@link path} is not a valid CairoPath instance a CairoException
     * will be thrown
     *
     * @param CairoPath $path CairoContext object
     * @return void
     * @since PECL cairo >= 0.1.0
     **/
    public function appendPath($path){}

    /**
     * Adds a circular arc
     *
     * Adds a circular arc of the given radius to the current path. The arc
     * is centered at ({@link x}, {@link y}), begins at {@link angle1} and
     * proceeds in the direction of increasing angles to end at {@link
     * angle2}. If {@link angle2} is less than {@link angle1} it will be
     * progressively increased by 2*M_PI until it is greater than {@link
     * angle1}. If there is a current point, an initial line segment will be
     * added to the path to connect the current point to the beginning of the
     * arc. If this initial line is undesired, it can be avoided by calling
     * CairoContext::newSubPath or procedural {@link cairo_new_sub_path}
     * before calling CairoContext::arc or {@link cairo_arc}.
     *
     * Angles are measured in radians. An angle of 0.0 is in the direction of
     * the positive X axis (in user space). An angle of M_PI/2.0 radians (90
     * degrees) is in the direction of the positive Y axis (in user space).
     * Angles increase in the direction from the positive X axis toward the
     * positive Y axis. So with the default transformation matrix, angles
     * increase in a clockwise direction.
     *
     * (To convert from degrees to radians, use degrees * (M_PI / 180.).)
     * This function gives the arc in the direction of increasing angles; see
     * CairoContext::arcNegative or {@link cairo_arc_negative} to get the arc
     * in the direction of decreasing angles.
     *
     * @param float $x A valid CairoContext object
     * @param float $y x position
     * @param float $radius y position
     * @param float $angle1 Radius of the arc
     * @param float $angle2 start angle
     * @return void
     * @since PECL cairo >= 0.1.0
     **/
    public function arc($x, $y, $radius, $angle1, $angle2){}

    /**
     * Adds a negative arc
     *
     * Adds a circular arc of the given {@link radius} to the current path.
     * The arc is centered at ({@link x}, {@link y}), begins at {@link
     * angle1} and proceeds in the direction of decreasing angles to end at
     * {@link angle2}. If {@link angle2} is greater than {@link angle1} it
     * will be progressively decreased by 2*M_PI until it is less than {@link
     * angle1}.
     *
     * See CairoContext::arc or {@link cairo_arc} for more details. This
     * function differs only in the direction of the arc between the two
     * angles.
     *
     * @param float $x A valid CairoContext object
     * @param float $y double x position
     * @param float $radius double y position
     * @param float $angle1 The radius of the desired negative arc
     * @param float $angle2 Start angle of the arc
     * @return void
     * @since PECL cairo >= 0.1.0
     **/
    public function arcNegative($x, $y, $radius, $angle1, $angle2){}

    /**
     * Establishes a new clip region
     *
     * Establishes a new clip region by intersecting the current clip region
     * with the current path as it would be filled by CairoContext::fill or
     * {@link cairo_fill} and according to the current fill rule (see
     * CairoContext::setFillRule or {@link cairo_set_fill_rule}).
     *
     * After CairoContext::clip or {@link cairo_clip}, the current path will
     * be cleared from the cairo context.
     *
     * The current clip region affects all drawing operations by effectively
     * masking out any changes to the surface that are outside the current
     * clip region.
     *
     * Calling CairoContext::clip or {@link cairo_clip} can only make the
     * clip region smaller, never larger. But the current clip is part of the
     * graphics state, so a temporary restriction of the clip region can be
     * achieved by calling CairoContext::clip or {@link cairo_clip} within a
     * CairoContext::save/CairoContext::restore or {@link cairo_save}/{@link
     * cairo_restore} pair. The only other means of increasing the size of
     * the clip region is CairoContext::resetClip or procedural {@link
     * cairo_reset_clip}.
     *
     * @return void
     * @since PECL cairo >= 0.1.0
     **/
    public function clip(){}

    /**
     * Computes the area inside the current clip
     *
     * Computes a bounding box in user coordinates covering the area inside
     * the current clip.
     *
     * @return array An array containing the (float)x1, (float)y1,
     *   (float)x2, (float)y2, coordinates covering the area inside the
     *   current clip
     * @since PECL cairo >= 0.1.0
     **/
    public function clipExtents(){}

    /**
     * Establishes a new clip region from the current clip
     *
     * Establishes a new clip region by intersecting the current clip region
     * with the current path as it would be filled by Context.fill and
     * according to the current FILL RULE (see CairoContext::setFillRule or
     * {@link cairo_set_fill_rule}).
     *
     * Unlike CairoContext::clip, CairoContext::clipPreserve preserves the
     * path within the Context. The current clip region affects all drawing
     * operations by effectively masking out any changes to the surface that
     * are outside the current clip region.
     *
     * Calling CairoContext::clipPreserve can only make the clip region
     * smaller, never larger. But the current clip is part of the graphics
     * state, so a temporary restriction of the clip region can be achieved
     * by calling CairoContext::clipPreserve within a
     * CairoContext::save/CairoContext::restore pair. The only other means of
     * increasing the size of the clip region is CairoContext::resetClip.
     *
     * @return void
     * @since PECL cairo >= 0.1.0
     **/
    public function clipPreserve(){}

    /**
     * Retrieves the current clip as a list of rectangles
     *
     * Returns a list-type array with the current clip region as a list of
     * rectangles in user coordinates
     *
     * @return array An array of user-space represented rectangles for the
     *   current clip
     * @since PECL cairo >= 0.1.0
     **/
    public function clipRectangleList(){}

    /**
     * Closes the current path
     *
     * Adds a line segment to the path from the current point to the
     * beginning of the current sub-path, (the most recent point passed to
     * CairoContext::moveTo), and closes this sub-path. After this call the
     * current point will be at the joined endpoint of the sub-path.
     *
     * The behavior of close_path() is distinct from simply calling
     * CairoContext::lineTo with the equivalent coordinate in the case of
     * stroking. When a closed sub-path is stroked, there are no caps on the
     * ends of the sub-path. Instead, there is a line join connecting the
     * final and initial segments of the sub-path.
     *
     * If there is no current point before the call to
     * CairoContext::closePath, this function will have no effect.
     *
     * @return void
     * @since PECL cairo >= 0.1.0
     **/
    public function closePath(){}

    /**
     * Emits the current page
     *
     * Emits the current page for backends that support multiple pages, but
     * doesn’t clear it, so, the contents of the current page will be
     * retained for the next page too. Use CairoContext::showPage if you want
     * to get an empty page after the emission.
     *
     * This is a convenience function that simply calls
     * CairoSurface::copyPage on CairoContext’s target.
     *
     * @return void
     * @since PECL cairo >= 0.1.0
     **/
    public function copyPage(){}

    /**
     * Creates a copy of the current path
     *
     * Creates a copy of the current path and returns it to the user as a
     * CairoPath. See CairoPath for hints on how to iterate over the returned
     * data structure.
     *
     * This function will always return a valid CairoPath object, but the
     * result will have no data, if either of the following conditions hold:
     * 1. If there is insufficient memory to copy the path. In this case
     * CairoPath->status will be set to CAIRO_STATUS_NO_MEMORY. 2. If {@link
     * context} is already in an error state. In this case CairoPath->status
     * will contain the same status that would be returned by {@link
     * cairo_status}.
     *
     * In either case, CairoPath->status will be set to
     * CAIRO_STATUS_NO_MEMORY (regardless of what the error status in cr
     * might have been).
     *
     * @return CairoPath A copy of the current CairoPath in the context
     * @since PECL cairo >= 0.1.0
     **/
    public function copyPath(){}

    /**
     * Gets a flattened copy of the current path
     *
     * Gets a flattened copy of the current path and returns it to the user
     * as a CairoPath.
     *
     * This function is like CairoContext::copyPath except that any curves in
     * the path will be approximated with piecewise-linear approximations,
     * (accurate to within the current tolerance value). That is, the result
     * is guaranteed to not have any elements of type CAIRO_PATH_CURVE_TO
     * which will instead be replaced by a series of CAIRO_PATH_LINE_TO
     * elements.
     *
     * @return CairoPath A copy of the current path
     * @since PECL cairo >= 0.1.0
     **/
    public function copyPathFlat(){}

    /**
     * Adds a curve
     *
     * Adds a cubic Bezier spline to the path from the current point to
     * position {@link x3} ,{@link y3} in user-space coordinates, using
     * {@link x1}, {@link y1} and {@link x2}, {@link y2} as the control
     * points. After this call the current point will be {@link x3}, {@link
     * y3}.
     *
     * If there is no current point before the call to CairoContext::curveTo
     * this function will behave as if preceded by a call to
     * CairoContext::moveTo ({@link x1}, {@link y1}).
     *
     * @param float $x1 A valid CairoContext object created with
     *   CairoContext::__construct or {@link cairo_create}
     * @param float $y1 First control point in the x axis for the curve
     * @param float $x2 First control point in the y axis for the curve
     * @param float $y2 Second control point in x axis for the curve
     * @param float $x3 Second control point in y axis for the curve
     * @param float $y3 Final point in the x axis for the curve
     * @return void
     * @since PECL cairo >= 0.1.0
     **/
    public function curveTo($x1, $y1, $x2, $y2, $x3, $y3){}

    /**
     * Transform a coordinate
     *
     * Transform a coordinate from device space to user space by multiplying
     * the given point by the inverse of the current transformation matrix
     * (CTM).
     *
     * @param float $x A valid CairoContext object created with
     *   CairoContext::__construct or {@link cairo_create}
     * @param float $y x value of the coordinate
     * @return array An array containing the x and y coordinates in the
     *   user-space
     * @since PECL cairo >= 0.1.0
     **/
    public function deviceToUser($x, $y){}

    /**
     * Transform a distance
     *
     * Transform a distance vector from device space to user space. This
     * function is similar to CairoContext::deviceToUser or {@link
     * cairo_device_to_user} except that the translation components of the
     * inverse Cairo Transformation Matrix will be ignored when transforming
     * ({@link x},{@link y}).
     *
     * @param float $x A valid CairoContext object created with
     *   CairoContext::__construct or {@link cairo_create}
     * @param float $y X component of a distance vector
     * @return array Returns an array with the x and y values of a distance
     *   vector in the user-space
     * @since PECL cairo >= 0.1.0
     **/
    public function deviceToUserDistance($x, $y){}

    /**
     * Fills the current path
     *
     * A drawing operator that fills the current path according to the
     * current CairoFillRule, (each sub-path is implicitly closed before
     * being filled). After CairoContext::fill or {@link cairo_fill}, the
     * current path will be cleared from the CairoContext.
     *
     * @return void
     * @since PECL cairo >= 0.1.0
     **/
    public function fill(){}

    /**
     * Computes the filled area
     *
     * Computes a bounding box in user coordinates covering the area that
     * would be affected, (the “inked” area), by a CairoContext::fill
     * operation given the current path and fill parameters. If the current
     * path is empty, returns an empty rectangle (0,0,0,0). Surface
     * dimensions and clipping are not taken into account.
     *
     * Contrast with CairoContext::pathExtents, which is similar, but returns
     * non-zero extents for some paths with no inked area, (such as a simple
     * line segment).
     *
     * Note that CairoContext::fillExtents must necessarily do more work to
     * compute the precise inked areas in light of the fill rule, so
     * CairoContext::pathExtents may be more desirable for sake of
     * performance if the non-inked path extents are desired.
     *
     * @return array An array with the coordinates of the afected area
     * @since PECL cairo >= 0.1.0
     **/
    public function fillExtents(){}

    /**
     * Fills and preserve the current path
     *
     * A drawing operator that fills the current path according to the
     * current CairoFillRule, (each sub-path is implicitly closed before
     * being filled). Unlike CairoContext::fill, CairoContext::fillPreserve
     * (Procedural {@link cairo_fill}, {@link cairo_fill_preserve},
     * respectively) preserves the path within the Context.
     *
     * @return void
     * @since PECL cairo >= 0.1.0
     **/
    public function fillPreserve(){}

    /**
     * Get the font extents
     *
     * Gets the font extents for the currently selected font.
     *
     * @return array An array containing the font extents for the current
     *   font.
     * @since PECL cairo >= 0.1.0
     **/
    public function fontExtents(){}

    /**
     * Retrieves the current antialias mode
     *
     * Returns the current CairoAntialias mode, as set by
     * CairoContext::setAntialias.
     *
     * @return int The current CairoAntialias mode.
     * @since PECL cairo >= 0.1.0
     **/
    public function getAntialias(){}

    /**
     * The getCurrentPoint purpose
     *
     * Gets the current point of the current path, which is conceptually the
     * final point reached by the path so far.
     *
     * The current point is returned in the user-space coordinate system. If
     * there is no defined current point or if cr is in an error status, x
     * and y will both be set to 0.0. It is possible to check this in advance
     * with CairoContext::hasCurrentPoint.
     *
     * Most path construction functions alter the current point. See the
     * following for details on how they affect the current point:
     * CairoContext::newPath, CairoContext::newSubPath,
     * CairoContext::appendPath, CairoContext::closePath,
     * CairoContext::moveTo, CairoContext::lineTo, CairoContext::curveTo,
     * CairoContext::relMoveTo, CairoContext::relLineTo,
     * CairoContext::relCurveTo, CairoContext::arc,
     * CairoContext::arcNegative, CairoContext::rectangle,
     * CairoContext::textPath, CairoContext::glyphPath.
     *
     * Some functions use and alter the current point but do not otherwise
     * change current path: CairoContext::showText.
     *
     * Some functions unset the current path and as a result, current point:
     * CairoContext::fill, CairoContext::stroke.
     *
     * @return array An array containing the x (index 0) and y (index 1)
     *   coordinates of the current point.
     * @since PECL cairo >= 0.1.0
     **/
    public function getCurrentPoint(){}

    /**
     * The getDash purpose
     *
     * @return array Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function getDash(){}

    /**
     * The getDashCount purpose
     *
     * @return int Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function getDashCount(){}

    /**
     * The getFillRule purpose
     *
     * @return int Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function getFillRule(){}

    /**
     * The getFontFace purpose
     *
     * @return void Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function getFontFace(){}

    /**
     * The getFontMatrix purpose
     *
     * @return void Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function getFontMatrix(){}

    /**
     * The getFontOptions purpose
     *
     * @return void Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function getFontOptions(){}

    /**
     * The getGroupTarget purpose
     *
     * @return void Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function getGroupTarget(){}

    /**
     * The getLineCap purpose
     *
     * @return int Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function getLineCap(){}

    /**
     * The getLineJoin purpose
     *
     * @return int Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function getLineJoin(){}

    /**
     * The getLineWidth purpose
     *
     * @return float Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function getLineWidth(){}

    /**
     * The getMatrix purpose
     *
     * @return void Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function getMatrix(){}

    /**
     * The getMiterLimit purpose
     *
     * @return float Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function getMiterLimit(){}

    /**
     * The getOperator purpose
     *
     * @return int Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function getOperator(){}

    /**
     * The getScaledFont purpose
     *
     * @return void Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function getScaledFont(){}

    /**
     * The getSource purpose
     *
     * @return void Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function getSource(){}

    /**
     * The getTarget purpose
     *
     * @return void Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function getTarget(){}

    /**
     * The getTolerance purpose
     *
     * @return float Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function getTolerance(){}

    /**
     * The glyphPath purpose
     *
     * Adds closed paths for the glyphs to the current path. The generated
     * path if filled, achieves an effect similar to that of
     * CairoContext::showGlyphs.
     *
     * @param array $glyphs A CairoContext object
     * @return void
     * @since PECL cairo >= 0.1.0
     **/
    public function glyphPath($glyphs){}

    /**
     * The hasCurrentPoint purpose
     *
     * Returns whether a current point is defined on the current path. See
     * CairoContext::getCurrentPoint for details on the current point.
     *
     * @return bool Whether a current point is defined
     * @since PECL cairo >= 0.1.0
     **/
    public function hasCurrentPoint(){}

    /**
     * The identityMatrix purpose
     *
     * @return void Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function identityMatrix(){}

    /**
     * The inFill purpose
     *
     * @param float $x Description...
     * @param float $y Description...
     * @return bool Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function inFill($x, $y){}

    /**
     * The inStroke purpose
     *
     * @param float $x Description...
     * @param float $y Description...
     * @return bool Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function inStroke($x, $y){}

    /**
     * The lineTo purpose
     *
     * @param float $x Description...
     * @param float $y Description...
     * @return void Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function lineTo($x, $y){}

    /**
     * The mask purpose
     *
     * @param CairoPattern $pattern Description...
     * @return void Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function mask($pattern){}

    /**
     * The maskSurface purpose
     *
     * @param CairoSurface $surface Description...
     * @param float $x Description...
     * @param float $y Description...
     * @return void Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function maskSurface($surface, $x, $y){}

    /**
     * The moveTo purpose
     *
     * Begin a new sub-path. After this call the current point will be (x,
     * y).
     *
     * @param float $x A valid CairoContext object.
     * @param float $y The x coordinate of the new position.
     * @return void
     * @since PECL cairo >= 0.1.0
     **/
    public function moveTo($x, $y){}

    /**
     * The newPath purpose
     *
     * Clears the current path. After this call there will be no path and no
     * current point.
     *
     * @return void
     * @since PECL cairo >= 0.1.0
     **/
    public function newPath(){}

    /**
     * The newSubPath purpose
     *
     * @return void Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function newSubPath(){}

    /**
     * The paint purpose
     *
     * @return void Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function paint(){}

    /**
     * The paintWithAlpha purpose
     *
     * @param float $alpha Description...
     * @return void Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function paintWithAlpha($alpha){}

    /**
     * The pathExtents purpose
     *
     * @return array Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function pathExtents(){}

    /**
     * The popGroup purpose
     *
     * @return void Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function popGroup(){}

    /**
     * The popGroupToSource purpose
     *
     * @return void Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function popGroupToSource(){}

    /**
     * The pushGroup purpose
     *
     * @return void Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function pushGroup(){}

    /**
     * The pushGroupWithContent purpose
     *
     * @param int $content Description...
     * @return void Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function pushGroupWithContent($content){}

    /**
     * The rectangle purpose
     *
     * @param float $x Description...
     * @param float $y Description...
     * @param float $width Description...
     * @param float $height Description...
     * @return void Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function rectangle($x, $y, $width, $height){}

    /**
     * The relCurveTo purpose
     *
     * @param float $x1 Description...
     * @param float $y1 Description...
     * @param float $x2 Description...
     * @param float $y2 Description...
     * @param float $x3 Description...
     * @param float $y3 Description...
     * @return void Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function relCurveTo($x1, $y1, $x2, $y2, $x3, $y3){}

    /**
     * The relLineTo purpose
     *
     * @param float $x Description...
     * @param float $y Description...
     * @return void Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function relLineTo($x, $y){}

    /**
     * The relMoveTo purpose
     *
     * @param float $x Description...
     * @param float $y Description...
     * @return void Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function relMoveTo($x, $y){}

    /**
     * The resetClip purpose
     *
     * @return void Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function resetClip(){}

    /**
     * The restore purpose
     *
     * @return void Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function restore(){}

    /**
     * The rotate purpose
     *
     * @param float $angle Description...
     * @return void Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function rotate($angle){}

    /**
     * The save purpose
     *
     * @return void Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function save(){}

    /**
     * The scale purpose
     *
     * @param float $x Description...
     * @param float $y Description...
     * @return void Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function scale($x, $y){}

    /**
     * The selectFontFace purpose
     *
     * @param string $family Description...
     * @param int $slant Description...
     * @param int $weight Description...
     * @return void Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function selectFontFace($family, $slant, $weight){}

    /**
     * The setAntialias purpose
     *
     * @param int $antialias Description...
     * @return void Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function setAntialias($antialias){}

    /**
     * The setDash purpose
     *
     * @param array $dashes Description...
     * @param float $offset Description...
     * @return void Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function setDash($dashes, $offset){}

    /**
     * The setFillRule purpose
     *
     * @param int $setting Description...
     * @return void Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function setFillRule($setting){}

    /**
     * The setFontFace purpose
     *
     * Sets the font-face for a given context.
     *
     * @param CairoFontFace $fontface A CairoContext object to change the
     *   font-face for.
     * @return void No value is returned
     * @since PECL cairo >= 0.1.0
     **/
    public function setFontFace($fontface){}

    /**
     * The setFontMatrix purpose
     *
     * @param CairoMatrix $matrix Description...
     * @return void Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function setFontMatrix($matrix){}

    /**
     * The setFontOptions purpose
     *
     * @param CairoFontOptions $fontoptions Description...
     * @return void Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function setFontOptions($fontoptions){}

    /**
     * The setFontSize purpose
     *
     * @param float $size Description...
     * @return void Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function setFontSize($size){}

    /**
     * The setLineCap purpose
     *
     * @param int $setting Description...
     * @return void Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function setLineCap($setting){}

    /**
     * The setLineJoin purpose
     *
     * @param int $setting Description...
     * @return void Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function setLineJoin($setting){}

    /**
     * The setLineWidth purpose
     *
     * @param float $width Description...
     * @return void Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function setLineWidth($width){}

    /**
     * The setMatrix purpose
     *
     * @param CairoMatrix $matrix Description...
     * @return void Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function setMatrix($matrix){}

    /**
     * The setMiterLimit purpose
     *
     * @param float $limit Description...
     * @return void Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function setMiterLimit($limit){}

    /**
     * The setOperator purpose
     *
     * @param int $setting Description...
     * @return void Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function setOperator($setting){}

    /**
     * The setScaledFont purpose
     *
     * @param CairoScaledFont $scaledfont Description...
     * @return void Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function setScaledFont($scaledfont){}

    /**
     * The setSource purpose
     *
     * @param CairoPattern $pattern Description...
     * @return void Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function setSource($pattern){}

    /**
     * The setSourceRGB purpose
     *
     * @param float $red Description...
     * @param float $green Description...
     * @param float $blue Description...
     * @return void Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function setSourceRGB($red, $green, $blue){}

    /**
     * The setSourceRGBA purpose
     *
     * @param float $red Description...
     * @param float $green Description...
     * @param float $blue Description...
     * @param float $alpha Description...
     * @return void Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function setSourceRGBA($red, $green, $blue, $alpha){}

    /**
     * The setSourceSurface purpose
     *
     * @param CairoSurface $surface Description...
     * @param float $x Description...
     * @param float $y Description...
     * @return void Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function setSourceSurface($surface, $x, $y){}

    /**
     * The setTolerance purpose
     *
     * @param float $tolerance Description...
     * @return void Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function setTolerance($tolerance){}

    /**
     * The showPage purpose
     *
     * @return void Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function showPage(){}

    /**
     * The showText purpose
     *
     * @param string $text Description...
     * @return void Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function showText($text){}

    /**
     * The status purpose
     *
     * @return int Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function status(){}

    /**
     * The stroke purpose
     *
     * @return void Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function stroke(){}

    /**
     * The strokeExtents purpose
     *
     * @return array Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function strokeExtents(){}

    /**
     * The strokePreserve purpose
     *
     * @return void Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function strokePreserve(){}

    /**
     * The textExtents purpose
     *
     * @param string $text Description...
     * @return array Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function textExtents($text){}

    /**
     * The textPath purpose
     *
     * Adds closed paths for text to the current path. The generated path, if
     * filled, achieves an effect similar to that of CairoContext::showText.
     *
     * Text conversion and positioning is done similar to
     * CairoContext::showText.
     *
     * Like CairoContext::showText, after this call the current point is
     * moved to the origin of where the next glyph would be placed in this
     * same progression. That is, the current point will be at the origin of
     * the final glyph offset by its advance values. This allows for chaining
     * multiple calls to CairoContext::showText without having to set current
     * point in between.
     *
     * Note: The CairoContext::textPath function call is part of what the
     * cairo designers call the "toy" text API. It is convenient for short
     * demos and simple programs, but it is not expected to be adequate for
     * serious text-using applications. See CairoContext::glyphPath for the
     * "real" text path API in cairo.
     *
     * @param string $string A CairoContext object
     * @return void Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function textPath($string){}

    /**
     * The transform purpose
     *
     * @param CairoMatrix $matrix Description...
     * @return void Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function transform($matrix){}

    /**
     * The translate purpose
     *
     * @param float $x Description...
     * @param float $y Description...
     * @return void Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function translate($x, $y){}

    /**
     * The userToDevice purpose
     *
     * @param float $x Description...
     * @param float $y Description...
     * @return array Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function userToDevice($x, $y){}

    /**
     * The userToDeviceDistance purpose
     *
     * @param float $x Description...
     * @param float $y Description...
     * @return array Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function userToDeviceDistance($x, $y){}

    /**
     * Creates a new CairoContext
     *
     * Creates a new CairoContext object to draw
     *
     * @param CairoSurface $surface A valid CairoSurface like
     *   CairoImageSurface or CairoPdfSurface
     * @since PECL cairo >= 0.1.0
     **/
    public function __construct($surface){}

}
/**
 * Exception class thrown by Cairo functions and methods
 **/
class CairoException extends Exception {
}
class CairoExtend {
    /**
     * @var integer
     **/
    const NONE = 0;

    /**
     * @var integer
     **/
    const PAD = 0;

    /**
     * @var integer
     **/
    const REFLECT = 0;

    /**
     * @var integer
     **/
    const REPEAT = 0;

}
/**
 * A CairoFillRule is used to select how paths are filled. For both fill
 * rules, whether or not a point is included in the fill is determined by
 * taking a ray from that point to infinity and looking at intersections
 * with the path. The ray can be in any direction, as long as it doesn't
 * pass through the end point of a segment or have a tricky intersection
 * such as intersecting tangent to the path. (Note that filling is not
 * actually implemented in this way. This is just a description of the
 * rule that is applied.) The default fill rule is
 * CairoFillRule::WINDING.
 **/
class CairoFillRule {
    /**
     * @var integer
     **/
    const EVEN_ODD = 0;

    /**
     * If the path crosses the ray from left-to-right, counts +1. If the path
     * crosses the ray from right to left, counts -1. (Left and right are
     * determined from the perspective of looking along the ray from the
     * starting point.) If the total count is non-zero, the point will be
     * filled.
     *
     * @var integer
     **/
    const WINDING = 0;

}
/**
 * A CairoFilter is used to indicate what filtering should be applied
 * when reading pixel values from patterns. See CairoPattern::setSource
 * or {@link cairo_pattern_set_source} for indicating the desired filter
 * to be used with a particular pattern.
 **/
class CairoFilter {
    /**
     * The highest-quality available, performance may not be suitable for
     * interactive use.
     *
     * @var integer
     **/
    const BEST = 0;

    /**
     * Linear interpolation in two dimensions
     *
     * @var integer
     **/
    const BILINEAR = 0;

    /**
     * A high-performance filter, with quality similar to
     * CairoFilter::NEAREST
     *
     * @var integer
     **/
    const FAST = 0;

    /**
     * This filter value is currently unimplemented, and should not be used
     * in current code.
     *
     * @var integer
     **/
    const GAUSSIAN = 0;

    /**
     * A reasonable-performance filter, with quality similar to
     * CairoFilter::BILINEAR
     *
     * @var integer
     **/
    const GOOD = 0;

    /**
     * Nearest-neighbor filtering
     *
     * @var integer
     **/
    const NEAREST = 0;

}
/**
 * CairoFontFace abstract class represents a particular font at a
 * particular weight, slant, and other characteristic but no
 * transformation or size. Note: This class can not be instantiated
 * directly, it is created by CairoContext::getFontFace or {@link
 * cairo_scaled_font_get_font_face}.
 **/
class CairoFontFace {
    /**
     * Retrieves the font face type
     *
     * This function returns the type of the backend used to create a font
     * face. See CairoFontType class constants for available types.
     *
     * @return int A font type that can be any one defined in CairoFontType
     * @since PECL cairo >= 0.1.0
     **/
    public function getType(){}

    /**
     * Check for CairoFontFace errors
     *
     * Checks whether an error has previously occurred for this font face
     *
     * @return int CAIRO_STATUS_SUCCESS or another error such as
     *   CAIRO_STATUS_NO_MEMORY.
     * @since PECL cairo >= 0.1.0
     **/
    public function status(){}

    /**
     * Creates a new CairoFontFace object
     *
     * CairoFontFace class represents a particular font at a particular
     * weight, slant, and other characteristic but no transformation or size.
     *
     * Note: This class can't be instantiated directly it is created by
     * CairoContext::getFontFace or {@link cairo_scaled_font_get_font_face}
     *
     * @since PECL cairo >= 0.1.0
     **/
    public function __construct(){}

}
/**
 * An opaque structure holding all options that are used when rendering
 * fonts. Individual features of a cairo_font_options_t can be set or
 * accessed using functions named cairo_font_options_set_feature_name and
 * cairo_font_options_get_feature_name, like
 * cairo_font_options_set_antialias() and
 * cairo_font_options_get_antialias(). New features may be added to
 * CairoFontOptions in the future. For this reason
 * CairoFontOptions::copy, CairoFontOptions::equal,
 * CairoFontOptions::merge, CairoFontOptions::hash
 * (cairo_font_options_copy(), cairo_font_options_equal(),
 * cairo_font_options_merge(), and cairo_font_options_hash() in
 * procedural way) should be used to copy, check for equality, merge, or
 * compute a hash value of CairoFontOptions objects.
 **/
class CairoFontOptions {
    /**
     * The equal purpose
     *
     * The method description goes here.
     *
     * @param CairoFontOptions $other Description...
     * @return bool Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function equal($other){}

    /**
     * The getAntialias purpose
     *
     * @return int Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function getAntialias(){}

    /**
     * The getHintMetrics purpose
     *
     * The method description goes here.
     *
     * @return int Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function getHintMetrics(){}

    /**
     * The getHintStyle purpose
     *
     * The method description goes here.
     *
     * @return int Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function getHintStyle(){}

    /**
     * The getSubpixelOrder purpose
     *
     * The method description goes here.
     *
     * @return int Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function getSubpixelOrder(){}

    /**
     * The hash purpose
     *
     * The method description goes here.
     *
     * @return int Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function hash(){}

    /**
     * The merge purpose
     *
     * The method description goes here.
     *
     * @param CairoFontOptions $other Description...
     * @return void Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function merge($other){}

    /**
     * The setAntialias purpose
     *
     * @param int $antialias Description...
     * @return void Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function setAntialias($antialias){}

    /**
     * The setHintMetrics purpose
     *
     * The method description goes here.
     *
     * @param int $hint_metrics Description...
     * @return void Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function setHintMetrics($hint_metrics){}

    /**
     * The setHintStyle purpose
     *
     * The method description goes here.
     *
     * @param int $hint_style Description...
     * @return void Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function setHintStyle($hint_style){}

    /**
     * The setSubpixelOrder purpose
     *
     * The method description goes here.
     *
     * @param int $subpixel_order Description...
     * @return void Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function setSubpixelOrder($subpixel_order){}

    /**
     * The status purpose
     *
     * @return int Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function status(){}

    /**
     * The __construct purpose
     *
     * The method description goes here.
     *
     * @since PECL cairo >= 0.1.0
     **/
    public function __construct(){}

}
/**
 * Specifies variants of a font face based on their slant.
 **/
class CairoFontSlant {
    /**
     * Italic font style
     *
     * @var integer
     **/
    const ITALIC = 0;

    /**
     * Upright font style
     *
     * @var integer
     **/
    const NORMAL = 0;

    /**
     * Oblique font style
     *
     * @var integer
     **/
    const OBLIQUE = 0;

}
/**
 * CairoFontType class is an abstract final class that contains constants
 * used to describe the type of a given CairoFontFace or CairoScaledFont.
 * The font types are also known as "font backends" within cairo. The
 * type of a CairoFontFace is determined by the how it is created, an
 * example would be the CairoToyFontFace::__construct. The CairoFontFace
 * type can be queried with CairoFontFace::getType or {@link
 * cairo_font_face_get_type} The various CairoFontFace functions can be
 * used with a font face of any type. The type of a CairoScaledFont is
 * determined by the type of the CairoFontFace passed to
 * CairoScaledFont::__construct or {@link cairo_scaled_font_create}. The
 * scaled font type can be queried with CairoScaledFont::getType or
 * {@link cairo_scaled_font_get_type}.
 **/
class CairoFontType {
    /**
     * The font is of type CairoFreeType
     *
     * @var integer
     **/
    const FT = 0;

    /**
     * The font is of type Quartz
     *
     * @var integer
     **/
    const QUARTZ = 0;

    /**
     * The font was created using CairoToyFont api
     *
     * @var integer
     **/
    const TOY = 0;

    /**
     * The font was create using cairo's user font api
     *
     * @var mixed
     **/
    const USER = 0;

    /**
     * The font is of type Win32
     *
     * @var integer
     **/
    const WIN32 = 0;

}
/**
 * Specifies variants of a font face based on their weight.
 **/
class CairoFontWeight {
    /**
     * Bold font weight
     *
     * @var integer
     **/
    const BOLD = 0;

    /**
     * Normal font weight
     *
     * @var integer
     **/
    const NORMAL = 0;

}
/**
 * CairoFormat enums are used to identify the memory format of the image
 * data.
 **/
class CairoFormat {
    /**
     * Each pixel is a 1-bit quantity holding an alpha value. Pixels are
     * packed together into 32-bit quantities. The ordering of the bits
     * matches the endianness of the platform. On a big-endian machine, the
     * first pixel is in the uppermost bit, on a little-endian machine the
     * first pixel is in the least-significant bit.
     *
     * @var integer
     **/
    const A1 = 0;

    /**
     * Each pixel is a 8-bit quantity holding an alpha value.
     *
     * @var integer
     **/
    const A8 = 0;

    /**
     * Each pixel is a 32-bit quantity, with alpha in the upper 8 bits, then
     * red, then green, then blue. The 32-bit quantities are stored
     * native-endian. Pre-multiplied alpha is used. (That is, 50% transparent
     * red is 0x80800000, not 0x80ff0000.)
     *
     * @var integer
     **/
    const ARGB32 = 0;

    /**
     * Each pixel is a 32-bit quantity, with the upper 8 bits unused. Red,
     * Green, and Blue are stored in the remaining 24 bits in that order.
     *
     * @var integer
     **/
    const RGB24 = 0;

    /**
     * Provides an appropriate stride to use
     *
     * This method provides a stride value that will respect all alignment
     * requirements of the accelerated image-rendering code within cairo.
     *
     * @param int $format The desired CairoFormat to use
     * @param int $width The width of the image
     * @return int The appropriate stride to use given the desired format
     *   and width, or -1 if either the format is invalid or the width too
     *   large.
     * @since PECL cairo >= 0.1.0
     **/
    public static function strideForWidth($format, $width){}

}
/**
 * CairoGradientPattern is an abstract base class from which other
 * Pattern classes derive. It cannot be instantiated directly.
 **/
class CairoGradientPattern extends CairoPattern {
    /**
     * The addColorStopRgb purpose
     *
     * The method description goes here.
     *
     * @param float $offset Description...
     * @param float $red Description...
     * @param float $green Description...
     * @param float $blue Description...
     * @return void Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function addColorStopRgb($offset, $red, $green, $blue){}

    /**
     * The addColorStopRgba purpose
     *
     * The method description goes here.
     *
     * @param float $offset Description...
     * @param float $red Description...
     * @param float $green Description...
     * @param float $blue Description...
     * @param float $alpha Description...
     * @return void Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function addColorStopRgba($offset, $red, $green, $blue, $alpha){}

    /**
     * The getColorStopCount purpose
     *
     * The method description goes here.
     *
     * @return int Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function getColorStopCount(){}

    /**
     * The getColorStopRgba purpose
     *
     * The method description goes here.
     *
     * @param int $index Description...
     * @return array Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function getColorStopRgba($index){}

    /**
     * The getExtend purpose
     *
     * The method description goes here.
     *
     * @return int Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function getExtend(){}

    /**
     * The setExtend purpose
     *
     * The method description goes here.
     *
     * @param int $extend Description...
     * @return void Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function setExtend($extend){}

}
/**
 * Specifies whether to hint font metrics; hinting font metrics means
 * quantizing them so that they are integer values in device space. Doing
 * this improves the consistency of letter and line spacing, however it
 * also means that text will be laid out differently at different zoom
 * factors.
 **/
class CairoHintMetrics {
    /**
     * @var integer
     **/
    const METRICS_DEFAULT = 0;

    /**
     * @var integer
     **/
    const METRICS_OFF = 0;

    /**
     * @var integer
     **/
    const METRICS_ON = 0;

}
/**
 * Specifies the type of hinting to do on font outlines. Hinting is the
 * process of fitting outlines to the pixel grid in order to improve the
 * appearance of the result. Since hinting outlines involves distorting
 * them, it also reduces the faithfulness to the original outline shapes.
 * Not all of the outline hinting styles are supported by all font
 * backends.
 **/
class CairoHintStyle {
    /**
     * @var integer
     **/
    const STYLE_DEFAULT = 0;

    /**
     * @var integer
     **/
    const STYLE_FULL = 0;

    /**
     * @var integer
     **/
    const STYLE_MEDIUM = 0;

    /**
     * @var integer
     **/
    const STYLE_NONE = 0;

    /**
     * @var integer
     **/
    const STYLE_SLIGHT = 0;

}
/**
 * CairoImageSurface provide the ability to render to memory buffers
 * either allocated by cairo or by the calling code. The supported image
 * formats are those defined in CairoFormat.
 **/
class CairoImageSurface extends CairoSurface {
    /**
     * The createForData purpose
     *
     * The method description goes here.
     *
     * @param string $data Description...
     * @param int $format Description...
     * @param int $width Description...
     * @param int $height Description...
     * @return void Description...
     * @since PECL cairo >= 0.1.0
     **/
    public static function createForData($data, $format, $width, $height){}

    /**
     * Creates a new CairoImageSurface form a png image file
     *
     * This method should be called static
     *
     * @param string $file Path to PNG image file
     * @return CairoImageSurface CairoImageSurface object
     * @since PECL cairo >= 0.1.0
     **/
    public static function createFromPng($file){}

    /**
     * Gets the image data as string
     *
     * Returns the image data of this surface or NULL if surface is not an
     * image surface, or if CairoContext::finish, procedural : {@link
     * cairo_surface_finish}, has been called.
     *
     * @return string The image data as string
     * @since PECL cairo >= 0.1.0
     **/
    public function getData(){}

    /**
     * Get the image format
     *
     * Retrieves the image format, as one of the CairoFormat defined
     *
     * @return int One of the CairoFormat enums
     * @since PECL cairo >= 0.1.0
     **/
    public function getFormat(){}

    /**
     * Retrieves the height of the CairoImageSurface
     *
     * This methods returns the CairoImageSurface height.
     *
     * @return int CairoImageSurface object height
     * @since PECL cairo >= 0.1.0
     **/
    public function getHeight(){}

    /**
     * The getStride purpose
     *
     * The method description goes here.
     *
     * @return int Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function getStride(){}

    /**
     * Retrieves the width of the CairoImageSurface
     *
     * Gets the width of the CairoImageSurface
     *
     * @return int Returns the width of the CairoImageSurface object
     * @since PECL cairo >= 0.1.0
     **/
    public function getWidth(){}

    /**
     * Creates a new CairoImageSurface
     *
     * Creates a new CairoImageSuface object of type {@link format}
     *
     * @param int $format Can be any defined in CairoFormat
     * @param int $width The width of the image surface
     * @param int $height The height of the image surface
     * @since PECL cairo >= 0.1.0
     **/
    public function __construct($format, $width, $height){}

}
/**
 * Create a new CairoLinearGradient along the line defined
 **/
class CairoLinearGradient extends CairoGradientPattern {
    /**
     * The getPoints purpose
     *
     * The method description goes here.
     *
     * @return array Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function getPoints(){}

    /**
     * The __construct purpose
     *
     * The method description goes here.
     *
     * @param float $x0 Description...
     * @param float $y0 Description...
     * @param float $x1 Description...
     * @param float $y1 Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function __construct($x0, $y0, $x1, $y1){}

}
/**
 * Specifies how to render the endpoints of the path when stroking. The
 * default line cap style is CairoLineCap::BUTT.
 **/
class CairoLineCap {
    /**
     * Start(stop) the line exactly at the start(end) point
     *
     * @var integer
     **/
    const BUTT = 0;

    /**
     * Use a round ending, the center of the circle is the end point
     *
     * @var integer
     **/
    const ROUND = 0;

    /**
     * Use squared ending, the center of the square is the end point
     *
     * @var integer
     **/
    const SQUARE = 0;

}
class CairoLineJoin {
    /**
     * @var integer
     **/
    const BEVEL = 0;

    /**
     * @var integer
     **/
    const MITER = 0;

    /**
     * @var integer
     **/
    const ROUND = 0;

}
/**
 * Matrices are used throughout cairo to convert between different
 * coordinate spaces.
 **/
class CairoMatrix {
    /**
     * Creates a new identity matrix
     *
     * Creates a new matrix that is an identity transformation. An identity
     * transformation means the source data is copied into the destination
     * data without change
     *
     * @return void Returns a new CairoMatrix object that can be used with
     *   surfaces, contexts, and patterns.
     * @since PECL cairo >= 0.1.0
     **/
    public static function initIdentity(){}

    /**
     * Creates a new rotated matrix
     *
     * Creates a new matrix to a transformation that rotates by radians
     * provided
     *
     * @param float $radians angle of rotation, in radians. The direction
     *   of rotation is defined such that positive angles rotate in the
     *   direction from the positive X axis toward the positive Y axis. With
     *   the default axis orientation of cairo, positive angles rotate in a
     *   clockwise direction.
     * @return void Returns a new CairoMatrix object that can be used with
     *   surfaces, contexts, and patterns.
     * @since PECL cairo >= 0.1.0
     **/
    public static function initRotate($radians){}

    /**
     * Creates a new scaling matrix
     *
     * Creates a new matrix to a transformation that scales by sx and sy in
     * the X and Y dimensions, respectively.
     *
     * @param float $sx scale factor in the X direction
     * @param float $sy scale factor in the Y direction
     * @return void Returns a new CairoMatrix object that can be used with
     *   surfaces, contexts, and patterns.
     * @since PECL cairo >= 0.1.0
     **/
    public static function initScale($sx, $sy){}

    /**
     * Creates a new translation matrix
     *
     * Creates a new matrix to a transformation that translates by tx and ty
     * in the X and Y dimensions, respectively.
     *
     * @param float $tx amount to translate in the X direction
     * @param float $ty amount to translate in the Y direction
     * @return void Returns a new CairoMatrix object that can be used with
     *   surfaces, contexts, and patterns.
     * @since PECL cairo >= 0.1.0
     **/
    public static function initTranslate($tx, $ty){}

    /**
     * The invert purpose
     *
     * The method description goes here.
     *
     * @return void Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function invert(){}

    /**
     * The multiply purpose
     *
     * The method description goes here.
     *
     * @param CairoMatrix $matrix1 Description...
     * @param CairoMatrix $matrix2 Description...
     * @return CairoMatrix Description...
     * @since PECL cairo >= 0.1.0
     **/
    public static function multiply($matrix1, $matrix2){}

    /**
     * The rotate purpose
     *
     * @param float $radians Description...
     * @return void Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function rotate($radians){}

    /**
     * Applies scaling to a matrix
     *
     * Applies scaling by sx, sy to the transformation in the matrix. The
     * effect of the new transformation is to first scale the coordinates by
     * sx and sy, then apply the original transformation to the coordinates.
     *
     * @param float $sx Procedural only - CairoMatrix instance
     * @param float $sy scale factor in the X direction
     * @return void
     * @since PECL cairo >= 0.1.0
     **/
    public function scale($sx, $sy){}

    /**
     * The transformDistance purpose
     *
     * The method description goes here.
     *
     * @param float $dx Description...
     * @param float $dy Description...
     * @return array Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function transformDistance($dx, $dy){}

    /**
     * The transformPoint purpose
     *
     * The method description goes here.
     *
     * @param float $dx Description...
     * @param float $dy Description...
     * @return array Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function transformPoint($dx, $dy){}

    /**
     * The translate purpose
     *
     * @param float $tx Description...
     * @param float $ty Description...
     * @return void Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function translate($tx, $ty){}

    /**
     * Creates a new CairoMatrix object
     *
     * Returns new CairoMatrix object. Matrices are used throughout cairo to
     * convert between different coordinate spaces. Sets matrix to be the
     * affine transformation given by xx, yx, xy, yy, x0, y0. The
     * transformation is given by: x_new = xx * x + xy * y + x0; and y_new =
     * yx * x + yy * y + y0;
     *
     * @param float $xx xx component of the affine transformation
     * @param float $yx yx component of the affine transformation
     * @param float $xy xy component of the affine transformation
     * @param float $yy yy component of the affine transformation
     * @param float $x0 X translation component of the affine
     *   transformation
     * @param float $y0 Y translation component of the affine
     *   transformation
     * @since PECL cairo >= 0.1.0
     **/
    public function __construct($xx, $yx, $xy, $yy, $x0, $y0){}

}
/**
 * This is used to set the compositing operator for all cairo drawing
 * operations. The default operator is CairoOperator::OVER The operators
 * marked as unbounded modify their destination even outside of the mask
 * layer (that is, their effect is not bound by the mask layer). However,
 * their effect can still be limited by way of clipping. To keep things
 * simple, the operator descriptions here document the behavior for when
 * both source and destination are either fully transparent or fully
 * opaque. The actual implementation works for translucent layers too.
 * For a more detailed explanation of the effects of each operator,
 * including the mathematical definitions, see
 * http://cairographics.org/operators/.
 **/
class CairoOperator {
    /**
     * Source and destination layers are accumulated
     *
     * @var integer
     **/
    const ADD = 0;

    /**
     * Draw source on top of destination content and only there
     *
     * @var integer
     **/
    const ATOP = 0;

    /**
     * Clear destination layer (bounded)
     *
     * @var integer
     **/
    const CLEAR = 0;

    /**
     * Ignore the source
     *
     * @var integer
     **/
    const DEST = 0;

    /**
     * @var integer
     **/
    const DEST_ATOP = 0;

    /**
     * @var integer
     **/
    const DEST_IN = 0;

    /**
     * @var integer
     **/
    const DEST_OUT = 0;

    /**
     * @var integer
     **/
    const DEST_OVER = 0;

    /**
     * Draw source where there was destination content (unbounded)
     *
     * @var integer
     **/
    const IN = 0;

    /**
     * Draw source where there was no destination content (unbounded)
     *
     * @var integer
     **/
    const OUT = 0;

    /**
     * Draw source layer on top of destination layer (bounded)
     *
     * @var integer
     **/
    const OVER = 0;

    /**
     * Like CairoOperator::OVER, but assuming source and dest are disjoint
     * geometries
     *
     * @var integer
     **/
    const SATURATE = 0;

    /**
     * Replace destination layer (bounded)
     *
     * @var integer
     **/
    const SOURCE = 0;

    /**
     * Source and destination are shown where there is only one of them
     *
     * @var integer
     **/
    const XOR = 0;

}
/**
 * Note: CairoPath class cannot be instantiated directly, doing so will
 * result in Fatal Error if used or passed
 **/
class CairoPath {
}
/**
 * CairoPattern is the abstract base class from which all the other
 * pattern classes derive. It cannot be instantiated directly
 **/
class CairoPattern {
    /**
     * The getMatrix purpose
     *
     * @return void Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function getMatrix(){}

    /**
     * The getType purpose
     *
     * The method description goes here.
     *
     * @return int Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function getType(){}

    /**
     * The setMatrix purpose
     *
     * @param CairoMatrix $matrix Description...
     * @return void Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function setMatrix($matrix){}

    /**
     * The status purpose
     *
     * @return int Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function status(){}

    /**
     * The __construct purpose
     *
     * The method description goes here.
     *
     * @since PECL cairo >= 0.1.0
     **/
    public function __construct(){}

}
/**
 * CairoPatternType is used to describe the type of a given pattern. The
 * type of a pattern is determined by the function used to create it. The
 * {@link cairo_pattern_create_rgb} and {@link cairo_pattern_create_rgba}
 * functions create CairoPatternType::SOLID patterns. The remaining
 * cairo_pattern_create_* functions map to pattern types in obvious ways.
 **/
class CairoPatternType {
    /**
     * The pattern is a linear gradient.
     *
     * @var integer
     **/
    const LINEAR = 0;

    /**
     * The pattern is a radial gradient.
     *
     * @var integer
     **/
    const RADIAL = 0;

    /**
     * The pattern is a solid (uniform) color. It may be opaque or
     * translucent.
     *
     * @var integer
     **/
    const SOLID = 0;

    /**
     * The pattern is a based on a surface (an image).
     *
     * @var integer
     **/
    const SURFACE = 0;

}
class CairoPdfSurface extends CairoSurface {
    /**
     * The setSize purpose
     *
     * The method description goes here.
     *
     * @param float $width Description...
     * @param float $height Description...
     * @return void Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function setSize($width, $height){}

    /**
     * The __construct purpose
     *
     * The method description goes here.
     *
     * @param string $file Description...
     * @param float $width Description...
     * @param float $height Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function __construct($file, $width, $height){}

}
class CairoPsLevel {
    /**
     * @var integer
     **/
    const LEVEL_2 = 0;

    /**
     * @var integer
     **/
    const LEVEL_3 = 0;

}
class CairoPsSurface extends CairoSurface {
    /**
     * The dscBeginPageSetup purpose
     *
     * The method description goes here.
     *
     * @return void Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function dscBeginPageSetup(){}

    /**
     * The dscBeginSetup purpose
     *
     * The method description goes here.
     *
     * @return void Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function dscBeginSetup(){}

    /**
     * The dscComment purpose
     *
     * The method description goes here.
     *
     * @param string $comment Description...
     * @return void Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function dscComment($comment){}

    /**
     * The getEps purpose
     *
     * The method description goes here.
     *
     * @return bool Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function getEps(){}

    /**
     * The getLevels purpose
     *
     * The method description goes here.
     *
     * @return array Description...
     * @since PECL cairo >= 0.1.0
     **/
    public static function getLevels(){}

    /**
     * The levelToString purpose
     *
     * The method description goes here.
     *
     * @param int $level Description...
     * @return string Description...
     * @since PECL cairo >= 0.1.0
     **/
    public static function levelToString($level){}

    /**
     * The restrictToLevel purpose
     *
     * The method description goes here.
     *
     * @param int $level Description...
     * @return void Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function restrictToLevel($level){}

    /**
     * The setEps purpose
     *
     * The method description goes here.
     *
     * @param bool $level Description...
     * @return void Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function setEps($level){}

    /**
     * The setSize purpose
     *
     * The method description goes here.
     *
     * @param float $width Description...
     * @param float $height Description...
     * @return void Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function setSize($width, $height){}

    /**
     * The __construct purpose
     *
     * The method description goes here.
     *
     * @param string $file Description...
     * @param float $width Description...
     * @param float $height Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function __construct($file, $width, $height){}

}
class CairoRadialGradient extends CairoGradientPattern {
    /**
     * The getCircles purpose
     *
     * The method description goes here.
     *
     * @return array Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function getCircles(){}

    /**
     * The __construct purpose
     *
     * Creates a new radial gradient CairoPattern between the two circles
     * defined by (x0, y0, r0) and (x1, y1, r1). Before using the gradient
     * pattern, a number of color stops should be defined using
     * CairoRadialGradient::addColorStopRgb or
     * CairoRadialGradient::addColorStopRgba.
     *
     * Note: The coordinates here are in pattern space. For a new pattern,
     * pattern space is identical to user space, but the relationship between
     * the spaces can be changed with CairoRadialGradient::setMatrix.
     *
     * @param float $x0 x coordinate for the center of the start circle.
     * @param float $y0 y coordinate for the center of the start circle.
     * @param float $r0 radius of the start circle.
     * @param float $x1 x coordinate for the center of the end circle.
     * @param float $y1 y coordinate for the center of the end circle.
     * @param float $r1 radius of the end circle.
     * @since PECL cairo >= 0.1.0
     **/
    public function __construct($x0, $y0, $r0, $x1, $y1, $r1){}

}
class CairoScaledFont {
    /**
     * The extents purpose
     *
     * The method description goes here.
     *
     * @return array Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function extents(){}

    /**
     * The getCtm purpose
     *
     * The method description goes here.
     *
     * @return CairoMatrix Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function getCtm(){}

    /**
     * The getFontFace purpose
     *
     * @return void Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function getFontFace(){}

    /**
     * The getFontMatrix purpose
     *
     * @return void Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function getFontMatrix(){}

    /**
     * The getFontOptions purpose
     *
     * @return void Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function getFontOptions(){}

    /**
     * The getScaleMatrix purpose
     *
     * The method description goes here.
     *
     * @return void Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function getScaleMatrix(){}

    /**
     * The getType purpose
     *
     * The method description goes here.
     *
     * @return int Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function getType(){}

    /**
     * The glyphExtents purpose
     *
     * The method description goes here.
     *
     * @param array $glyphs Description...
     * @return array Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function glyphExtents($glyphs){}

    /**
     * The status purpose
     *
     * @return int Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function status(){}

    /**
     * The textExtents purpose
     *
     * @param string $text Description...
     * @return array Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function textExtents($text){}

    /**
     * The __construct purpose
     *
     * The method description goes here.
     *
     * @param CairoFontFace $font_face Description...
     * @param CairoMatrix $matrix Description...
     * @param CairoMatrix $ctm Description...
     * @param CairoFontOptions $options Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function __construct($font_face, $matrix, $ctm, $options){}

}
class CairoSolidPattern extends CairoPattern {
    /**
     * The getRgba purpose
     *
     * The method description goes here.
     *
     * @return array Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function getRgba(){}

    /**
     * The __construct purpose
     *
     * The method description goes here.
     *
     * @param float $red Description...
     * @param float $green Description...
     * @param float $blue Description...
     * @param float $alpha Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function __construct($red, $green, $blue, $alpha){}

}
/**
 * CairoStatus is used to indicate errors that can occur when using
 * Cairo. In some cases it is returned directly by functions. but when
 * using CairoContext, the last error, if any, is stored in the object
 * and can be retrieved with CairoContext::status or {@link
 * cairo_status}. New entries may be added in future versions. Use
 * Cairo::statusToString or {@link cairo_status_to_string} to get a
 * human-readable representation of an error message.
 **/
class CairoStatus {
    /**
     * @var integer
     **/
    const CLIP_NOT_REPRESENTABLE = 0;

    /**
     * @var integer
     **/
    const FILE_NOT_FOUND = 0;

    /**
     * @var integer
     **/
    const INVALID_CONTENT = 0;

    /**
     * @var integer
     **/
    const INVALID_DASH = 0;

    /**
     * @var integer
     **/
    const INVALID_DSC_COMMENT = 0;

    /**
     * @var integer
     **/
    const INVALID_FORMAT = 0;

    /**
     * @var integer
     **/
    const INVALID_INDEX = 0;

    /**
     * @var integer
     **/
    const INVALID_MATRIX = 0;

    /**
     * @var integer
     **/
    const INVALID_PATH_DATA = 0;

    /**
     * @var integer
     **/
    const INVALID_POP_GROUP = 0;

    /**
     * @var integer
     **/
    const INVALID_RESTORE = 0;

    /**
     * @var integer
     **/
    const INVALID_STATUS = 0;

    /**
     * @var integer
     **/
    const INVALID_STRIDE = 0;

    /**
     * @var integer
     **/
    const INVALID_STRING = 0;

    /**
     * @var integer
     **/
    const INVALID_VISUAL = 0;

    /**
     * @var integer
     **/
    const NO_CURRENT_POINT = 0;

    /**
     * @var integer
     **/
    const NO_MEMORY = 0;

    /**
     * @var integer
     **/
    const NULL_POINTER = 0;

    /**
     * @var integer
     **/
    const PATTERN_TYPE_MISMATCH = 0;

    /**
     * @var integer
     **/
    const READ_ERROR = 0;

    /**
     * No error has occurred
     *
     * @var integer
     **/
    const SUCCESS = 0;

    /**
     * @var integer
     **/
    const SURFACE_FINISHED = 0;

    /**
     * @var integer
     **/
    const SURFACE_TYPE_MISMATCH = 0;

    /**
     * @var integer
     **/
    const TEMP_FILE_ERROR = 0;

    /**
     * @var integer
     **/
    const WRITE_ERROR = 0;

}
class CairoSubpixelOrder {
    /**
     * @var integer
     **/
    const ORDER_BGR = 0;

    /**
     * @var integer
     **/
    const ORDER_DEFAULT = 0;

    /**
     * @var integer
     **/
    const ORDER_RGB = 0;

    /**
     * @var integer
     **/
    const ORDER_VBGR = 0;

    /**
     * @var integer
     **/
    const ORDER_VRGB = 0;

}
/**
 * This is the base-class for all other Surface types. CairoSurface is
 * the abstract type representing all different drawing targets that
 * cairo can render to. The actual drawings are performed using a
 * CairoContext.
 **/
class CairoSurface {
    /**
     * The copyPage purpose
     *
     * Emits the current page for backends that support multiple pages, but
     * doesn't clear it, so that the contents of the current page will be
     * retained for the next page. Use CairoSurface::showPage() if you want
     * to get an empty page after the emission.
     *
     * @return void Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function copyPage(){}

    /**
     * The createSimilar purpose
     *
     * Create a new surface that is as compatible as possible with an
     * existing surface. For example the new surface will have the same
     * fallback resolution and font options as other. Generally, the new
     * surface will also use the same backend as other, unless that is not
     * possible for some reason. The type of the returned surface may be
     * examined with CairoSurface::getType(). Initially the surface contents
     * are all 0 (transparent if contents have transparency, black
     * otherwise.)
     *
     * @param CairoSurface $other An existing surface used to select the
     *   backend of the new surface
     * @param int $content The content for the new surface. See the
     *   CairoContent class for possible values.
     * @param string $width Width of the new surface, (in device-space
     *   units).
     * @param string $height Height of the new surface, (in device-space
     *   units).
     * @return void A new CairoSurface
     * @since PECL cairo >= 0.1.0
     **/
    public function createSimilar($other, $content, $width, $height){}

    /**
     * The finish purpose
     *
     * The method description goes here.
     *
     * @return void Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function finish(){}

    /**
     * The flush purpose
     *
     * The method description goes here.
     *
     * @return void Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function flush(){}

    /**
     * The getContent purpose
     *
     * The method description goes here.
     *
     * @return int Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function getContent(){}

    /**
     * The getDeviceOffset purpose
     *
     * The method description goes here.
     *
     * @return array Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function getDeviceOffset(){}

    /**
     * The getFontOptions purpose
     *
     * @return void Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function getFontOptions(){}

    /**
     * The getType purpose
     *
     * The method description goes here.
     *
     * @return int Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function getType(){}

    /**
     * The markDirty purpose
     *
     * The method description goes here.
     *
     * @return void Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function markDirty(){}

    /**
     * The markDirtyRectangle purpose
     *
     * The method description goes here.
     *
     * @param float $x Description...
     * @param float $y Description...
     * @param float $width Description...
     * @param float $height Description...
     * @return void Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function markDirtyRectangle($x, $y, $width, $height){}

    /**
     * The setDeviceOffset purpose
     *
     * The method description goes here.
     *
     * @param float $x Description...
     * @param float $y Description...
     * @return void Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function setDeviceOffset($x, $y){}

    /**
     * The setFallbackResolution purpose
     *
     * The method description goes here.
     *
     * @param float $x Description...
     * @param float $y Description...
     * @return void Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function setFallbackResolution($x, $y){}

    /**
     * The showPage purpose
     *
     * @return void Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function showPage(){}

    /**
     * The status purpose
     *
     * @return int Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function status(){}

    /**
     * The writeToPng purpose
     *
     * The method description goes here.
     *
     * @param string $file Description...
     * @return void Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function writeToPng($file){}

    /**
     * The __construct purpose
     *
     * CairoSurface is an abstract type and, as such, should not be
     * instantiated in your PHP scripts.
     *
     * @since PECL cairo >= 0.1.0
     **/
    public function __construct(){}

}
class CairoSurfacePattern extends CairoPattern {
    /**
     * The getExtend purpose
     *
     * The method description goes here.
     *
     * @return int Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function getExtend(){}

    /**
     * The getFilter purpose
     *
     * The method description goes here.
     *
     * @return int Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function getFilter(){}

    /**
     * The getSurface purpose
     *
     * The method description goes here.
     *
     * @return void Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function getSurface(){}

    /**
     * The setExtend purpose
     *
     * The method description goes here.
     *
     * @param int $extend Description...
     * @return void Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function setExtend($extend){}

    /**
     * The setFilter purpose
     *
     * The method description goes here.
     *
     * @param int $filter Description...
     * @return void Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function setFilter($filter){}

    /**
     * The __construct purpose
     *
     * The method description goes here.
     *
     * @param CairoSurface $surface Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function __construct($surface){}

}
class CairoSurfaceType {
    /**
     * @var integer
     **/
    const BEOS = 0;

    /**
     * @var integer
     **/
    const DIRECTFB = 0;

    /**
     * @var integer
     **/
    const GLITZ = 0;

    /**
     * @var integer
     **/
    const IMAGE = 0;

    /**
     * @var integer
     **/
    const OS2 = 0;

    /**
     * @var integer
     **/
    const PDF = 0;

    /**
     * @var integer
     **/
    const PS = 0;

    /**
     * @var integer
     **/
    const QUARTZ = 0;

    /**
     * @var integer
     **/
    const QUARTZ_IMAGE = 0;

    /**
     * @var integer
     **/
    const SVG = 0;

    /**
     * @var integer
     **/
    const WIN32 = 0;

    /**
     * @var integer
     **/
    const WIN32_PRINTING = 0;

    /**
     * @var integer
     **/
    const XCB = 0;

    /**
     * @var integer
     **/
    const XLIB = 0;

}
/**
 * Svg specific surface class, uses the SVG (standard vector graphics)
 * surface backend.
 **/
class CairoSvgSurface extends CairoSurface {
    /**
     * Used to retrieve a list of supported SVG versions
     *
     * Returns a numerically indexed array of currently available
     * CairoSvgVersion constants. In order to retrieve the string values for
     * each item, use CairoSvgSurface::versionToString.
     *
     * @return array Returns a numerically indexed array of integer values.
     * @since PECL cairo >= 0.1.0
     **/
    public static function getVersions(){}

    /**
     * The restrictToVersion purpose
     *
     * The method description goes here.
     *
     * @param int $version Description...
     * @return void Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function restrictToVersion($version){}

    /**
     * The versionToString purpose
     *
     * The method description goes here.
     *
     * @param int $version Description...
     * @return string Description...
     * @since PECL cairo >= 0.1.0
     **/
    public static function versionToString($version){}

    /**
     * The __construct purpose
     *
     * The method description goes here.
     *
     * @param string $file Description...
     * @param float $width Description...
     * @param float $height Description...
     * @since PECL cairo >= 0.1.0
     **/
    public function __construct($file, $width, $height){}

}
class CairoSvgVersion {
    /**
     * @var integer
     **/
    const VERSION_1_1 = 0;

    /**
     * @var integer
     **/
    const VERSION_1_2 = 0;

}
/**
 * The CairoToyFontFace class can be used instead of
 * CairoContext::selectFontFace to create a toy font independently of a
 * context.
 **/
class CairoToyFontFace extends CairoFontFace {
}
/**
 * The callback should accept up to three arguments: the current item,
 * the current key and the iterator, respectively. Any callable may be
 * used; such as a string containing a function name, an array for a
 * method, or an anonymous function.
 **/
class CallbackFilterIterator extends FilterIterator implements OuterIterator {
    /**
     * Calls the callback with the current value, the current key and the
     * inner iterator as arguments
     *
     * This method calls the callback with the current value, current key and
     * the inner iterator.
     *
     * The callback is expected to return TRUE if the current item is to be
     * accepted, or FALSE otherwise.
     *
     * @return bool Returns TRUE to accept the current item, or FALSE
     *   otherwise.
     * @since PHP 5 >= 5.4.0, PHP 7
     **/
    public function accept(){}

}
/**
 * Represents a loaded chdb file.
 **/
class chdb {
    /**
     * Gets the value associated with a key
     *
     * Gets the value associated with a key from a chdb database.
     *
     * @param string $key The key for which to get the value.
     * @return string Returns a string containing the value associated with
     *   the given {@link key}, or NULL if not found.
     * @since PECL chdb >= 0.1.0
     **/
    public function get($key){}

    /**
     * Creates a instance
     *
     * Loads a chdb file, by mapping it into memory. While some validity
     * checks are performed on the specified file, they are mostly there to
     * avoid the possibility of common mistakes (for example, loading a file
     * which is not a chdb database, or that is somehow incompatible with the
     * current system). A maliciously crafted chdb file can thus be dangerous
     * if loaded, so chdb files should be trusted and treated with the same
     * security protections used for PHP shared libraries.
     *
     * @param string $pathname The name of the file to load.
     * @since PECL chdb >= 0.1.0
     **/
    public function __construct($pathname){}

}
/**
 * Class used to represent anonymous functions. Anonymous functions,
 * implemented in PHP 5.3, yield objects of this type. This fact used to
 * be considered an implementation detail, but it can now be relied upon.
 * Starting with PHP 5.4, this class has methods that allow further
 * control of the anonymous function after it has been created. Besides
 * the methods listed here, this class also has an __invoke method. This
 * is for consistency with other classes that implement calling magic, as
 * this method is not used for calling the function.
 **/
class Closure {
    /**
     * Duplicates a closure with a specific bound object and class scope
     *
     * This method is a static version of Closure::bindTo. See the
     * documentation of that method for more information.
     *
     * @param Closure $closure The anonymous functions to bind.
     * @param object $newthis The object to which the given anonymous
     *   function should be bound, or NULL for the closure to be unbound.
     * @param mixed $newscope The class scope to which associate the
     *   closure is to be associated, or 'static' to keep the current one. If
     *   an object is given, the type of the object will be used instead.
     *   This determines the visibility of protected and private methods of
     *   the bound object. It is not allowed to pass (an object of) an
     *   internal class as this parameter.
     * @return Closure Returns a new Closure object
     * @since PHP 5 >= 5.4.0, PHP 7
     **/
    public static function bind($closure, $newthis, $newscope){}

    /**
     * Duplicates the closure with a new bound object and class scope
     *
     * Create and return a new anonymous function with the same body and
     * bound variables as this one, but possibly with a different bound
     * object and a new class scope.
     *
     * The “bound object” determines the value $this will have in the
     * function body and the “class scope” represents a class which
     * determines which private and protected members the anonymous function
     * will be able to access. Namely, the members that will be visible are
     * the same as if the anonymous function were a method of the class given
     * as value of the {@link newscope} parameter.
     *
     * Static closures cannot have any bound object (the value of the
     * parameter {@link newthis} should be NULL), but this function can
     * nevertheless be used to change their class scope.
     *
     * This function will ensure that for a non-static closure, having a
     * bound instance will imply being scoped and vice-versa. To this end,
     * non-static closures that are given a scope but a NULL instance are
     * made static and non-static non-scoped closures that are given a
     * non-null instance are scoped to an unspecified class.
     *
     * @param object $newthis The object to which the given anonymous
     *   function should be bound, or NULL for the closure to be unbound.
     * @param mixed $newscope The class scope to which associate the
     *   closure is to be associated, or 'static' to keep the current one. If
     *   an object is given, the type of the object will be used instead.
     *   This determines the visibility of protected and private methods of
     *   the bound object. It is not allowed to pass (an object of) an
     *   internal class as this parameter.
     * @return Closure Returns the newly created Closure object
     * @since PHP 5 >= 5.4.0, PHP 7
     **/
    public function bindTo($newthis, $newscope){}

    /**
     * Binds and calls the closure
     *
     * Temporarily binds the closure to {@link newthis}, and calls it with
     * any given parameters.
     *
     * @param object $newthis The object to bind the closure to for the
     *   duration of the call.
     * @param mixed ...$vararg Zero or more parameters, which will be given
     *   as parameters to the closure.
     * @return mixed Returns the return value of the closure.
     * @since PHP 7
     **/
    public function call($newthis, ...$vararg){}

    /**
     * Converts a callable into a closure
     *
     * Create and return a new anonymous function from given {@link callable}
     * using the current scope. This method checks if the {@link callable} is
     * callable in the current scope and throws a TypeError if it is not.
     *
     * @param callable $callable The callable to convert.
     * @return Closure Returns the newly created Closure or throws a
     *   TypeError if the {@link callable} is not callable in the current
     *   scope.
     * @since PHP 7 >= 7.1.0
     **/
    public static function fromCallable($callable){}

    /**
     * Constructor that disallows instantiation
     *
     * This method exists only to disallow instantiation of the Closure
     * class. Objects of this class are created in the fashion described on
     * the anonymous functions page.
     *
     * @since PHP 5 >= 5.3.0, PHP 7
     **/
    private function __construct(){}

}
/**
 * Provides string comparison capability with support for appropriate
 * locale-sensitive sort orderings.
 **/
class Collator {
    /**
     * Sort array maintaining index association
     *
     * This function sorts an array such that array indices maintain their
     * correlation with the array elements they are associated with. This is
     * used mainly when sorting associative arrays where the actual element
     * order is significant. Array elements will have sort order according to
     * current locale rules.
     *
     * Equivalent to standard PHP {@link asort}.
     *
     * @param array $arr Collator object.
     * @param int $sort_flag Array of strings to sort.
     * @return bool
     * @since PHP 5 >= 5.3.0, PHP 7, PECL intl >= 1.0.0
     **/
    public function asort(&$arr, $sort_flag){}

    /**
     * Compare two Unicode strings
     *
     * Compare two Unicode strings according to collation rules.
     *
     * @param string $str1 Collator object.
     * @param string $str2 The first string to compare.
     * @return int Return comparison result:
     * @since PHP 5 >= 5.3.0, PHP 7, PECL intl >= 1.0.0
     **/
    public function compare($str1, $str2){}

    /**
     * Create a collator
     *
     * The strings will be compared using the options already specified.
     *
     * @param string $locale The locale containing the required collation
     *   rules. Special values for locales can be passed in - if null is
     *   passed for the locale, the default locale collation rules will be
     *   used. If empty string ("") or "root" are passed, UCA rules will be
     *   used.
     * @return Collator Return new instance of Collator object, or NULL on
     *   error.
     * @since PHP 5 >= 5.3.0, PHP 7, PECL intl >= 1.0.0
     **/
    public static function create($locale){}

    /**
     * Get collation attribute value
     *
     * Get a value of an integer collator attribute.
     *
     * @param int $attr Collator object.
     * @return int Attribute value, or boolean FALSE on error.
     * @since PHP 5 >= 5.3.0, PHP 7, PECL intl >= 1.0.0
     **/
    public function getAttribute($attr){}

    /**
     * Get collator's last error code
     *
     * @return int Error code returned by the last Collator API function
     *   call.
     * @since PHP 5 >= 5.3.0, PHP 7, PECL intl >= 1.0.0
     **/
    public function getErrorCode(){}

    /**
     * Get text for collator's last error code
     *
     * Retrieves the message for the last error.
     *
     * @return string Description of an error occurred in the last Collator
     *   API function call.
     * @since PHP 5 >= 5.3.0, PHP 7, PECL intl >= 1.0.0
     **/
    public function getErrorMessage(){}

    /**
     * Get the locale name of the collator
     *
     * Get collector locale name.
     *
     * @param int $type Collator object.
     * @return string Real locale name from which the collation data comes.
     *   If the collator was instantiated from rules or an error occurred,
     *   returns boolean FALSE.
     * @since PHP 5 >= 5.3.0, PHP 7, PECL intl >= 1.0.0
     **/
    public function getLocale($type){}

    /**
     * Get sorting key for a string
     *
     * Return collation key for a string.
     *
     * @param string $str Collator object.
     * @return string Returns the collation key for the string. Collation
     *   keys can be compared directly instead of strings.
     * @since PHP 5 >= 5.3.11, PHP 7, PECL intl >= 1.0.3
     **/
    public function getSortKey($str){}

    /**
     * Get current collation strength
     *
     * @return int Returns current collation strength, or boolean FALSE on
     *   error.
     * @since PHP 5 >= 5.3.0, PHP 7, PECL intl >= 1.0.0
     **/
    public function getStrength(){}

    /**
     * Set collation attribute
     *
     * @param int $attr Collator object.
     * @param int $val Attribute.
     * @return bool
     * @since PHP 5 >= 5.3.0, PHP 7, PECL intl >= 1.0.0
     **/
    public function setAttribute($attr, $val){}

    /**
     * Set collation strength
     *
     * The ICU Collation Service supports many levels of comparison (named
     * "Levels", but also known as "Strengths"). Having these categories
     * enables ICU to sort strings precisely according to local conventions.
     * However, by allowing the levels to be selectively employed, searching
     * for a string in text can be performed with various matching
     * conditions.
     *
     * Primary Level: Typically, this is used to denote differences between
     * base characters (for example, "a" < "b"). It is the strongest
     * difference. For example, dictionaries are divided into different
     * sections by base character. This is also called the level1 strength.
     * Secondary Level: Accents in the characters are considered secondary
     * differences (for example, "as" < "às" < "at"). Other differences
     * between letters can also be considered secondary differences,
     * depending on the language. A secondary difference is ignored when
     * there is a primary difference anywhere in the strings. This is also
     * called the level2 strength. Note: In some languages (such as Danish),
     * certain accented letters are considered to be separate base
     * characters. In most languages, however, an accented letter only has a
     * secondary difference from the unaccented version of that letter.
     * Tertiary Level: Upper and lower case differences in characters are
     * distinguished at the tertiary level (for example, "ao" < "Ao" <
     * "aò"). In addition, a variant of a letter differs from the base form
     * on the tertiary level (such as "A" and " "). Another example is the
     * difference between large and small Kana. A tertiary difference is
     * ignored when there is a primary or secondary difference anywhere in
     * the strings. This is also called the level3 strength. Quaternary
     * Level: When punctuation is ignored (see Ignoring Punctuations ) at
     * level 13, an additional level can be used to distinguish words with
     * and without punctuation (for example, "ab" < "a-b" < "aB"). This
     * difference is ignored when there is a primary, secondary or tertiary
     * difference. This is also known as the level4 strength. The quaternary
     * level should only be used if ignoring punctuation is required or when
     * processing Japanese text (see Hiragana processing). Identical Level:
     * When all other levels are equal, the identical level is used as a
     * tiebreaker. The Unicode code point values of the NFD form of each
     * string are compared at this level, just in case there is no difference
     * at levels 14. For example, Hebrew cantillation marks are only
     * distinguished at this level. This level should be used sparingly, as
     * only code point values differences between two strings is an extremely
     * rare occurrence. Using this level substantially decreases the
     * performance for both incremental comparison and sort key generation
     * (as well as increasing the sort key length). It is also known as level
     * 5 strength.
     *
     * For example, people may choose to ignore accents or ignore accents and
     * case when searching for text. Almost all characters are distinguished
     * by the first three levels, and in most locales the default value is
     * thus Tertiary. However, if Alternate is set to be Shifted, then the
     * Quaternary strength can be used to break ties among whitespace,
     * punctuation, and symbols that would otherwise be ignored. If very fine
     * distinctions among characters are required, then the Identical
     * strength can be used (for example, Identical Strength distinguishes
     * between the Mathematical Bold Small A and the Mathematical Italic
     * Small A.). However, using levels higher than Tertiary the Identical
     * strength result in significantly longer sort keys, and slower string
     * comparison performance for equal strings.
     *
     * @param int $strength Collator object.
     * @return bool
     * @since PHP 5 >= 5.3.0, PHP 7, PECL intl >= 1.0.0
     **/
    public function setStrength($strength){}

    /**
     * Sort array using specified collator
     *
     * This function sorts an array according to current locale rules.
     *
     * Equivalent to standard PHP {@link sort} .
     *
     * @param array $arr Collator object.
     * @param int $sort_flag Array of strings to sort.
     * @return bool
     * @since PHP 5 >= 5.3.0, PHP 7, PECL intl >= 1.0.0
     **/
    public function sort(&$arr, $sort_flag){}

    /**
     * Sort array using specified collator and sort keys
     *
     * Similar to {@link collator_sort} but uses ICU sorting keys produced by
     * ucol_getSortKey() to gain more speed on large arrays.
     *
     * @param array $arr Collator object.
     * @return bool
     * @since PHP 5 >= 5.3.0, PHP 7, PECL intl >= 1.0.0
     **/
    public function sortWithSortKeys(&$arr){}

}
/**
 * Represents a garbage-collectable object.
 **/
interface Collectable {
    /**
     * Determine whether an object has been marked as garbage
     *
     * Can be called in Pool::collect to determine if this object is garbage.
     *
     * @return bool
     * @since PECL pthreads >= 2.0.8
     **/
    public function isGarbage();

    /**
     * Mark an object as garbage
     *
     * Should be called once per object when the object is finished being
     * executed or referenced.
     *
     * @return void
     * @since PECL pthreads < 3.0.0
     **/
    public function setGarbage();

}
/**
 * The COM class allows you to instantiate an OLE compatible COM object
 * and call its methods and access its properties.
 **/
class COM extends VARIANT {
}
namespace CommonMark {
class CQL {
    /**
     * CQL Execution
     *
     * Shall invoke the current CQL function on the given {@link root},
     * executing the given {@link handler} on entry to a \CommonMark\Node
     *
     * @param \CommonMark\Node $root the root node of a tree
     * @param callable $handler should have the prototype: ?boolhandler
     *   \CommonMark\Node{@link root} \CommonMark\Node{@link entering} Should
     *   {@link handler} fail to return (void), or return null, CQL will
     *   continue executing Should the handler return a truthy value, CQL
     *   will continue executing. Should the handler return a falsy value,
     *   CQL will stop executing
     **/
    public function __invoke($root, $handler){}

}
}
namespace CommonMark\Interfaces {
interface IVisitable {
    /**
     * Visitation
     *
     * @param CommonMark\Interfaces\IVisitor $visitor An object
     *   implementing CommonMark\Interfaces\IVisitor
     * @return void
     **/
    public function accept($visitor);

}
}
namespace CommonMark\Interfaces {
interface IVisitor {
    /**
     * Visitation
     *
     * @param IVisitable $visitable The current
     *   CommonMark\Interfaces\IVisitable being entered
     * @return ?int|IVisitable Returning
     *   CommonMark\Interfaces\IVisitor::Done will cause the backing iterator
     *   to exit.
     **/
    public function enter($visitable);

    /**
     * Visitation
     *
     * @param IVisitable $visitable The current
     *   CommonMark\Interfaces\IVisitable being exited
     * @return ?int|IVisitable Returning
     *   CommonMark\Interfaces\IVisitor::Done will cause the backing iterator
     *   to exit.
     **/
    public function leave($visitable);

}
}
namespace CommonMark {
final class Node implements CommonMark\Interfaces\IVisitable, Traversable {
    /**
     * @var int
     **/
    public $endColumn;

    /**
     * @var int
     **/
    public $endLine;

    /**
     * @var ?Node
     **/
    public $firstChild;

    /**
     * @var ?Node
     **/
    public $lastChild;

    /**
     * @var ?Node
     **/
    public $next;

    /**
     * @var ?Node
     **/
    public $parent;

    /**
     * @var ?Node
     **/
    public $previous;

    /**
     * @var int
     **/
    public $startColumn;

    /**
     * @var int
     **/
    public $startLine;

    /**
     * Visitation
     *
     * @param CommonMark\Interfaces\IVisitor $visitor An object
     *   implementing CommonMark\Interfaces\IVisitor
     * @return void
     **/
    public function accept($visitor){}

    /**
     * AST Manipulation
     *
     * @param CommonMark\Node $child
     * @return CommonMark\Node
     **/
    public function appendChild($child){}

    /**
     * AST Manipulation
     *
     * @param CommonMark\Node $sibling
     * @return CommonMark\Node
     **/
    public function insertAfter($sibling){}

    /**
     * AST Manipulation
     *
     * @param CommonMark\Node $sibling
     * @return CommonMark\Node
     **/
    public function insertBefore($sibling){}

    /**
     * AST Manipulation
     *
     * @param CommonMark\Node $child
     * @return CommonMark\Node
     **/
    public function prependChild($child){}

    /**
     * AST Manipulation
     *
     * @param CommonMark\Node $target
     * @return CommonMark\Node
     **/
    public function replace($target){}

    /**
     * AST Manipulation
     *
     * @return void
     **/
    public function unlink(){}

}
}
namespace CommonMark\Node {
final class BlockQuote extends CommonMark\Node implements CommonMark\Interfaces\IVisitable, Traversable {
}
}
namespace CommonMark\Node {
final class BulletList extends CommonMark\Node implements CommonMark\Interfaces\IVisitable, Traversable {
}
}
namespace CommonMark\Node {
final class Code extends CommonMark\Node\Text implements CommonMark\Interfaces\IVisitable, Traversable {
}
}
namespace CommonMark\Node {
final class CodeBlock extends CommonMark\Node\Text implements CommonMark\Interfaces\IVisitable, Traversable {
}
}
namespace CommonMark\Node {
final class CustomBlock extends CommonMark\Node implements CommonMark\Interfaces\IVisitable, Traversable {
}
}
namespace CommonMark\Node {
final class CustomInline extends CommonMark\Node implements CommonMark\Interfaces\IVisitable, Traversable {
}
}
namespace CommonMark\Node {
final class Document extends CommonMark\Node implements CommonMark\Interfaces\IVisitable, Traversable {
}
}
namespace CommonMark\Node {
final class Heading extends CommonMark\Node implements CommonMark\Interfaces\IVisitable, Traversable {
}
}
namespace CommonMark\Node {
final class HTMLBlock extends CommonMark\Node\Text implements CommonMark\Interfaces\IVisitable, Traversable {
}
}
namespace CommonMark\Node {
final class HTMLInline extends CommonMark\Node\Text implements CommonMark\Interfaces\IVisitable, Traversable {
}
}
namespace CommonMark\Node {
final class Image extends CommonMark\Node implements CommonMark\Interfaces\IVisitable, Traversable {
}
}
namespace CommonMark\Node {
final class Item extends CommonMark\Node implements CommonMark\Interfaces\IVisitable, Traversable {
}
}
namespace CommonMark\Node {
final class LineBreak extends CommonMark\Node implements CommonMark\Interfaces\IVisitable, Traversable {
}
}
namespace CommonMark\Node {
final class Link extends CommonMark\Node implements CommonMark\Interfaces\IVisitable, Traversable {
}
}
namespace CommonMark\Node {
final class OrderedList extends CommonMark\Node implements CommonMark\Interfaces\IVisitable, Traversable {
}
}
namespace CommonMark\Node {
final class Paragraph extends CommonMark\Node implements CommonMark\Interfaces\IVisitable, Traversable {
}
}
namespace CommonMark\Node {
final class SoftBreak extends CommonMark\Node implements CommonMark\Interfaces\IVisitable, Traversable {
}
}
namespace CommonMark\Node {
final class Text extends CommonMark\Node implements CommonMark\Interfaces\IVisitable, Traversable {
}
}
namespace CommonMark\Node\Text {
final class Emphasis extends CommonMark\Node implements CommonMark\Interfaces\IVisitable, Traversable {
}
}
namespace CommonMark\Node\Text {
final class Strong extends CommonMark\Node implements CommonMark\Interfaces\IVisitable, Traversable {
}
}
namespace CommonMark\Node {
final class ThematicBreak extends CommonMark\Node implements CommonMark\Interfaces\IVisitable, Traversable {
}
}
namespace CommonMark {
final class Parser {
    /**
     * Parsing
     *
     * @return CommonMark\Node
     **/
    public function finish(){}

    /**
     * Parsing
     *
     * @param string $buffer
     * @return void
     **/
    public function parse($buffer){}

}
}
/**
 * CompileError is thrown for some compilation errors, which formerly
 * issued a fatal error.
 **/
class CompileError extends Error {
}
namespace Componere {
final class Definition {
    /**
     * Add Constant
     *
     * Shall declare a class constant on the current Definition
     *
     * @param string $name The case sensitive name for the constant
     * @param \Componere\Value $value The Value for the constant, must not
     *   be undefined or static
     * @return Definition The current Definition
     **/
    public function addConstant($name, $value){}

    /**
     * Add Interface
     *
     * Shall implement the given interface on the current definition
     *
     * @param string $interface The case insensitive name of an interface
     * @return Definition The current Definition
     **/
    public function addInterface($interface){}

    /**
     * Add Method
     *
     * Shall create or override a method on the current definition.
     *
     * @param string $name The case insensitive name for method
     * @param \Componere\Method $method \Componere\Method not previously
     *   added to another Definition
     * @return Definition The current Definition
     **/
    public function addMethod($name, $method){}

    /**
     * Add Property
     *
     * Shall declare a class property on the current Definition
     *
     * @param string $name The case sensitive name for the property
     * @param \Componere\Value $value The default Value for the property
     * @return Definition The current Definition
     **/
    public function addProperty($name, $value){}

    /**
     * Add Trait
     *
     * Shall use the given trait for the current definition
     *
     * @param string $trait The case insensitive name of a trait
     * @return Definition The current Definition
     **/
    public function addTrait($trait){}

    /**
     * Get Closure
     *
     * Shall return a Closure for the method specified by name
     *
     * @param string $name The case insensitive name of the method
     * @return \Closure A Closure bound to the correct scope
     **/
    public function getClosure($name){}

    /**
     * Get Closures
     *
     * Shall return an array of Closures
     *
     * @return array Shall return all methods as an array of Closure
     *   objects bound to the correct scope
     **/
    public function getClosures(){}

    /**
     * Reflection
     *
     * Shall create or return a ReflectionClass
     *
     * @return \ReflectionClass A ReflectionClass for the current
     *   definition (cached)
     **/
    public function getReflector(){}

    /**
     * State Detection
     *
     * Shall detect the registration state of this Definition
     *
     * @return bool Shall return true if this Definition is registered
     **/
    public function isRegistered(){}

    /**
     * Registration
     *
     * Shall register the current Definition
     *
     * @return void
     **/
    public function register(){}

}
}
namespace Componere {
final class Method {
    /**
     * Reflection
     *
     * Shall create or return a ReflectionMethod
     *
     * @return \ReflectionMethod A ReflectionMethod for the current method
     *   (cached)
     **/
    public function getReflector(){}

    /**
     * Accessibility Modification
     *
     * @return Method The current Method
     **/
    public function setPrivate(){}

    /**
     * Accessibility Modification
     *
     * @return Method The current Method
     **/
    public function setProtected(){}

    /**
     * Accessibility Modification
     *
     * @return Method The current Method
     **/
    public function setStatic(){}

}
}
namespace Componere {
final class Patch {
    /**
     * Add Interface
     *
     * Shall implement the given interface on the current definition
     *
     * @param string $interface The case insensitive name of an interface
     * @return Definition The current Definition
     **/
    public function addInterface($interface){}

    /**
     * Add Method
     *
     * Shall create or override a method on the current definition.
     *
     * @param string $name The case insensitive name for method
     * @param \Componere\Method $method \Componere\Method not previously
     *   added to another Definition
     * @return Definition The current Definition
     **/
    public function addMethod($name, $method){}

    /**
     * Add Trait
     *
     * Shall use the given trait for the current definition
     *
     * @param string $trait The case insensitive name of a trait
     * @return Definition The current Definition
     **/
    public function addTrait($trait){}

    /**
     * Application
     *
     * Shall apply the current patch
     *
     * @return void
     **/
    public function apply(){}

    /**
     * Patch Derivation
     *
     * Shall derive a Patch for the given {@link instance}
     *
     * @param object $instance The target for the derived Patch
     * @return Patch Patch for {@link instance} derived from the current
     *   Patch
     **/
    public function derive($instance){}

    /**
     * Get Closure
     *
     * Shall return a Closure for the method specified by name
     *
     * @param string $name The case insensitive name of the method
     * @return \Closure A Closure bound to the correct scope and object
     **/
    public function getClosure($name){}

    /**
     * Get Closures
     *
     * Shall return an array of Closures
     *
     * @return array Shall return all methods as an array of Closure
     *   objects bound to the correct scope and object
     **/
    public function getClosures(){}

    /**
     * Reflection
     *
     * Shall create or return a ReflectionClass
     *
     * @return \ReflectionClass A ReflectionClass for the current
     *   definition (cached)
     **/
    public function getReflector(){}

    /**
     * State Detection
     *
     * @return bool
     **/
    public function isApplied(){}

    /**
     * Reversal
     *
     * Shall revert the current patch
     *
     * @return void
     **/
    public function revert(){}

}
}
namespace Componere {
final class Value {
    /**
     * Value Interaction
     *
     * @return bool
     **/
    public function hasDefault(){}

    /**
     * Accessibility Detection
     *
     * @return bool
     **/
    public function isPrivate(){}

    /**
     * Accessibility Detection
     *
     * @return bool
     **/
    public function isProtected(){}

    /**
     * Accessibility Detection
     *
     * @return bool
     **/
    public function isStatic(){}

    /**
     * Accessibility Modification
     *
     * @return Value The current Value
     **/
    public function setPrivate(){}

    /**
     * Accessibility Modification
     *
     * @return Value The current Value
     **/
    public function setProtected(){}

    /**
     * Accessibility Modification
     *
     * @return Value The current Value
     **/
    public function setStatic(){}

}
}
class com_exception extends Exception implements Throwable {
}
/**
 * The static methods contained in the Cond class provide direct access
 * to Posix Condition Variables.
 **/
class Cond {
    /**
     * Broadcast a Condition
     *
     * Broadcast to all Threads blocking on a call to {@link Cond::wait}.
     *
     * @param int $condition A handle to a Condition Variable returned by a
     *   previous call to {@link Cond::create}
     * @return bool A boolean indication of success.
     * @since PECL pthreads < 3.0.0
     **/
    final public static function broadcast($condition){}

    /**
     * Create a Condition
     *
     * Creates a new Condition Variable for the caller.
     *
     * @return int A handle to a Condition Variable
     * @since PECL pthreads < 3.0.0
     **/
    final public static function create(){}

    /**
     * Destroy a Condition
     *
     * Destroying Condition Variable handles must be carried out explicitly
     * by the programmer when they are finished with the Condition Variable.
     * No Threads should be blocking on a call to {@link Cond::wait} when the
     * call to {@link Cond::destroy} takes place.
     *
     * @param int $condition A handle to a Condition Variable returned by a
     *   previous call to {@link Cond::create}
     * @return bool A boolean indication of success.
     * @since PECL pthreads < 3.0.0
     **/
    final public static function destroy($condition){}

    /**
     * Signal a Condition
     *
     * @param int $condition A handle returned by a previous call to {@link
     *   Cond::create}
     * @return bool A boolean indication of success.
     * @since PECL pthreads < 3.0.0
     **/
    final public static function signal($condition){}

    /**
     * Wait for Condition
     *
     * Wait for a signal on a Condition Variable, optionally specifying a
     * timeout to limit waiting time.
     *
     * @param int $condition A handle returned by a previous call to {@link
     *   Cond::create}.
     * @param int $mutex A handle returned by a previous call to {@link
     *   Mutex::create} and owned (locked) by the caller.
     * @param int $timeout An optional timeout, in microseconds (
     *   millionths of a second ).
     * @return bool A boolean indication of success.
     * @since PECL pthreads < 3.0.0
     **/
    final public static function wait($condition, $mutex, $timeout){}

}
/**
 * Classes implementing Countable can be used with the {@link count}
 * function.
 **/
interface Countable {
    /**
     * Count elements of an object
     *
     * This method is executed when using the {@link count} function on an
     * object implementing Countable.
     *
     * @return int The custom count as an integer.
     * @since PHP 5 >= 5.1.0, PHP 7
     **/
    public function count();

}
/**
 * CURLFile should be used to upload a file with CURLOPT_POSTFIELDS.
 * {@link curl_setopt}
 **/
class CURLFile {
    /**
     * MIME type of the file (default is application/octet-stream).
     *
     * @var mixed
     **/
    public $mime;

    /**
     * Name of the file to be uploaded.
     *
     * @var mixed
     **/
    public $name;

    /**
     * The name of the file in the upload data (defaults to the name
     * property).
     *
     * @var mixed
     **/
    public $postname;

    /**
     * Get file name
     *
     * @return string Returns file name.
     * @since PHP 5 >= 5.5.0, PHP 7
     **/
    public function getFilename(){}

    /**
     * Get MIME type
     *
     * @return string Returns MIME type.
     * @since PHP 5 >= 5.5.0, PHP 7
     **/
    public function getMimeType(){}

    /**
     * Get file name for POST
     *
     * @return string Returns file name for POST.
     * @since PHP 5 >= 5.5.0, PHP 7
     **/
    public function getPostFilename(){}

    /**
     * Set MIME type
     *
     * @param string $mime MIME type to be used in POST data.
     * @return void
     * @since PHP 5 >= 5.5.0, PHP 7
     **/
    public function setMimeType($mime){}

    /**
     * Set file name for POST
     *
     * @param string $postname Filename to be used in POST data.
     * @return void
     * @since PHP 5 >= 5.5.0, PHP 7
     **/
    public function setPostFilename($postname){}

    /**
     * Create a CURLFile object
     *
     * Creates a CURLFile object, used to upload a file with
     * CURLOPT_POSTFIELDS.
     *
     * @param string $filename Path to the file which will be uploaded.
     * @param string $mimetype Mimetype of the file.
     * @param string $postname Name of the file to be used in the upload
     *   data.
     * @since PHP 5 >= 5.5.0, PHP 7
     **/
    public function __construct($filename, $mimetype, $postname){}

    /**
     * Unserialization handler
     *
     * @return void
     * @since PHP 5 >= 5.5.0, PHP 7
     **/
    public function __wakeup(){}

}
/**
 * Represents a date interval. A date interval stores either a fixed
 * amount of time (in years, months, days, hours etc) or a relative time
 * string in the format that DateTime's constructor supports. 7.1.0 The f
 * property was added.
 **/
class DateInterval {
    /**
     * Number of days.
     *
     * @var integer
     **/
    public $d;

    /**
     * If the DateInterval object was created by {@link DateTime::diff}, then
     * this is the total number of days between the start and end dates.
     * Otherwise, days will be FALSE.
     *
     * Before PHP 5.4.20/5.5.4 instead of FALSE you will receive -99999 upon
     * accessing the property.
     *
     * @var mixed
     **/
    public $days;

    /**
     * Number of microseconds, as a fraction of a second.
     *
     * @var float
     **/
    public $f;

    /**
     * Number of hours.
     *
     * @var integer
     **/
    public $h;

    /**
     * Number of minutes.
     *
     * @var integer
     **/
    public $i;

    /**
     * Is 1 if the interval represents a negative time period and 0
     * otherwise. See DateInterval::format.
     *
     * @var integer
     **/
    public $invert;

    /**
     * Number of months.
     *
     * @var integer
     **/
    public $m;

    /**
     * Number of seconds.
     *
     * @var integer
     **/
    public $s;

    /**
     * Number of years.
     *
     * @var integer
     **/
    public $y;

    /**
     * Sets up a DateInterval from the relative parts of the string
     *
     * Uses the normal date parsers and sets up a DateInterval from the
     * relative parts of the parsed string.
     *
     * @param string $time A date with relative parts. Specifically, the
     *   relative formats supported by the parser used for {@link strtotime}
     *   and DateTime will be used to construct the DateInterval.
     * @return DateInterval Returns a new DateInterval instance.
     * @since PHP 5 >= 5.3.0, PHP 7
     **/
    public static function createFromDateString($time){}

    /**
     * Formats the interval
     *
     * @param string $format The following characters are recognized in the
     *   {@link format} parameter string. Each format character must be
     *   prefixed by a percent sign (%). {@link format} character Description
     *   Example values % Literal % % Y Years, numeric, at least 2 digits
     *   with leading 0 01, 03 y Years, numeric 1, 3 M Months, numeric, at
     *   least 2 digits with leading 0 01, 03, 12 m Months, numeric 1, 3, 12
     *   D Days, numeric, at least 2 digits with leading 0 01, 03, 31 d Days,
     *   numeric 1, 3, 31 a Total number of days as a result of a
     *   DateTime::diff or (unknown) otherwise 4, 18, 8123 H Hours, numeric,
     *   at least 2 digits with leading 0 01, 03, 23 h Hours, numeric 1, 3,
     *   23 I Minutes, numeric, at least 2 digits with leading 0 01, 03, 59 i
     *   Minutes, numeric 1, 3, 59 S Seconds, numeric, at least 2 digits with
     *   leading 0 01, 03, 57 s Seconds, numeric 1, 3, 57 F Microseconds,
     *   numeric, at least 6 digits with leading 0 007701, 052738, 428291 f
     *   Microseconds, numeric 7701, 52738, 428291 R Sign "-" when negative,
     *   "+" when positive -, + r Sign "-" when negative, empty when positive
     *   -,
     * @return string Returns the formatted interval.
     * @since PHP 5 >= 5.3.0, PHP 7
     **/
    public function format($format){}

}
/**
 * Represents a date period. A date period allows iteration over a set of
 * dates and times, recurring at regular intervals, over a given period.
 * 5.3.27, 5.4.17 The public properties recurrences, include_start_date,
 * start, current, end and interval have been exposed.
 **/
class DatePeriod implements Traversable {
    /**
     * @var integer
     **/
    const EXCLUDE_START_DATE = 0;

    /**
     * During iteration this will contain the current date within the period.
     *
     * @var DateTimeInterface
     **/
    public $current;

    /**
     * The end date of the period.
     *
     * @var DateTimeInterface
     **/
    public $end;

    /**
     * Whether to include the start date in the set of recurring dates or
     * not.
     *
     * @var boolean
     **/
    public $include_start_date;

    /**
     * An ISO 8601 repeating interval specification.
     *
     * @var DateInterval
     **/
    public $interval;

    /**
     * The number of recurrences, if the DatePeriod instance had been created
     * by explicitly passing $recurrences. See also
     * DatePeriod::getRecurrences.
     *
     * @var integer
     **/
    public $recurrences;

    /**
     * The start date of the period.
     *
     * @var DateTimeInterface
     **/
    public $start;

    /**
     * Gets the interval
     *
     * Gets a DateInterval object representing the interval used for the
     * period.
     *
     * @return DateInterval Returns a DateInterval object
     * @since PHP 5 >= 5.6.5, PHP 7
     **/
    public function getDateInterval(){}

    /**
     * Gets the end date
     *
     * Gets the end date of the period.
     *
     * @return DateTimeInterface Returns NULL if the DatePeriod does not
     *   have an end date. For example, when initialized with the {@link
     *   recurrences} parameter, or the {@link isostr} parameter without an
     *   end date.
     * @since PHP 5 >= 5.6.5, PHP 7
     **/
    public function getEndDate(){}

    /**
     * Gets the number of recurrences
     *
     * Get the number of recurrences.
     *
     * @return int Returns the number of recurrences.
     * @since PHP 7 >= 7.2.17/7.3.4
     **/
    function getRecurrences(){}

    /**
     * Gets the start date
     *
     * Gets the start date of the period.
     *
     * @return DateTimeInterface Returns a DateTimeImmutable object when
     *   the DatePeriod is initialized with a DateTimeImmutable object as the
     *   {@link start} parameter.
     * @since PHP 5 >= 5.6.5, PHP 7
     **/
    public function getStartDate(){}

}
/**
 * Representation of date and time. 7.2.0 The class constants of DateTime
 * are now defined on DateTimeInterface. 7.0.0 Added constants:
 * DATE_RFC3339_EXTENDED and DateTime::RFC3339_EXTENDED. 5.5.0 The class
 * now implements DateTimeInterface. 5.4.24 The COOKIE constant was
 * changed to reflect RFC 1036 using a four digit year rather than a two
 * digit year (RFC 850) as prior versions. 5.2.2 DateTime object
 * comparison with the comparison operators changed to work as expected.
 * Previously, all DateTime objects were considered equal (using ==).
 **/
class DateTime implements DateTimeInterface {
    /**
     * Adds an amount of days, months, years, hours, minutes and seconds to a
     * DateTime object
     *
     * Adds the specified DateInterval object to the specified DateTime
     * object.
     *
     * @param DateInterval $interval A DateInterval object
     * @return DateTime
     * @since PHP 5 >= 5.3.0, PHP 7
     **/
    public function add($interval){}

    /**
     * Parses a time string according to a specified format
     *
     * Returns a new DateTime object representing the date and time specified
     * by the {@link time} string, which was formatted in the given {@link
     * format}.
     *
     * @param string $format The format that the passed in string should be
     *   in. See the formatting options below. In most cases, the same
     *   letters as for the {@link date} can be used.
     *   
     *   The following characters are recognized in the {@link format}
     *   parameter string {@link format} character Description Example
     *   parsable values Day --- --- d and j Day of the month, 2 digits with
     *   or without leading zeros 01 to 31 or 1 to 31 D and l A textual
     *   representation of a day Mon through Sun or Sunday through Saturday S
     *   English ordinal suffix for the day of the month, 2 characters. It's
     *   ignored while processing. st, nd, rd or th. z The day of the year
     *   (starting from 0) 0 through 365 Month --- --- F and M A textual
     *   representation of a month, such as January or Sept January through
     *   December or Jan through Dec m and n Numeric representation of a
     *   month, with or without leading zeros 01 through 12 or 1 through 12
     *   Year --- --- Y A full numeric representation of a year, 4 digits
     *   Examples: 1999 or 2003 y A two digit representation of a year (which
     *   is assumed to be in the range 1970-2069, inclusive) Examples: 99 or
     *   03 (which will be interpreted as 1999 and 2003, respectively) Time
     *   --- --- a and A Ante meridiem and Post meridiem am or pm g and h
     *   12-hour format of an hour with or without leading zero 1 through 12
     *   or 01 through 12 G and H 24-hour format of an hour with or without
     *   leading zeros 0 through 23 or 00 through 23 i Minutes with leading
     *   zeros 00 to 59 s Seconds, with leading zeros 00 through 59 u
     *   Microseconds (up to six digits) Example: 45, 654321 Timezone --- ---
     *   e, O, P and T Timezone identifier, or difference to UTC in hours, or
     *   difference to UTC with colon between hours and minutes, or timezone
     *   abbreviation Examples: UTC, GMT, Atlantic/Azores or +0200 or +02:00
     *   or EST, MDT Full Date/Time --- --- U Seconds since the Unix Epoch
     *   (January 1 1970 00:00:00 GMT) Example: 1292177455 Whitespace and
     *   Separators --- --- (space) One space or one tab Example: # One of
     *   the following separation symbol: ;, :, /, ., ,, -, ( or ) Example: /
     *   ;, :, /, ., ,, -, ( or ) The specified character. Example: - ? A
     *   random byte Example: ^ (Be aware that for UTF-8 characters you might
     *   need more than one ?. In this case, using * is probably what you
     *   want instead) * Random bytes until the next separator or digit
     *   Example: * in Y-*-d with the string 2009-aWord-08 will match aWord !
     *   Resets all fields (year, month, day, hour, minute, second, fraction
     *   and timezone information) to the Unix Epoch Without !, all fields
     *   will be set to the current date and time. | Resets all fields (year,
     *   month, day, hour, minute, second, fraction and timezone information)
     *   to the Unix Epoch if they have not been parsed yet Y-m-d| will set
     *   the year, month and day to the information found in the string to
     *   parse, and sets the hour, minute and second to 0. + If this format
     *   specifier is present, trailing data in the string will not cause an
     *   error, but a warning instead Use DateTime::getLastErrors to find out
     *   whether trailing data was present. Unrecognized characters in the
     *   format string will cause the parsing to fail and an error message is
     *   appended to the returned structure. You can query error messages
     *   with DateTime::getLastErrors. To include literal characters in
     *   {@link format}, you have to escape them with a backslash (\). If
     *   {@link format} does not contain the character ! then portions of the
     *   generated time which are not specified in {@link format} will be set
     *   to the current system time. If {@link format} contains the character
     *   !, then portions of the generated time not provided in {@link
     *   format}, as well as values to the left-hand side of the !, will be
     *   set to corresponding values from the Unix epoch. The Unix epoch is
     *   1970-01-01 00:00:00 UTC.
     * @param string $time String representing the time.
     * @param DateTimeZone $timezone A DateTimeZone object representing the
     *   desired time zone. If {@link timezone} is omitted and {@link time}
     *   contains no timezone, the current timezone will be used.
     * @return DateTime Returns a new DateTime instance.
     * @since PHP 5 >= 5.3.0, PHP 7
     **/
    public static function createFromFormat($format, $time, $timezone){}

    /**
     * Returns new DateTime object encapsulating the given DateTimeImmutable
     * object
     *
     * @param DateTimeImmutable $datetime The immutable DateTimeImmutable
     *   object that needs to be converted to a mutable version. This object
     *   is not modified, but instead a new DateTime object is created
     *   containing the same date, time, and timezone information.
     * @return DateTime Returns a new DateTime instance.
     * @since PHP 7 >= 7.3.0
     **/
    public static function createFromImmutable($datetime){}

    /**
     * Returns the difference between two DateTime objects
     *
     * Returns the difference between two DateTimeInterface objects.
     *
     * @param DateTimeInterface $datetime2 The date to compare to.
     * @param bool $absolute Should the interval be forced to be positive?
     * @return DateInterval The DateInterval object representing the
     *   difference between the two dates.
     * @since PHP 5 >= 5.3.0, PHP 7
     **/
    public function diff($datetime2, $absolute){}

    /**
     * Returns date formatted according to given format
     *
     * @param string $format Format accepted by {@link date}.
     * @return string Returns the formatted date string on success.
     * @since PHP 5 >= 5.2.1, PHP 7
     **/
    public function format($format){}

    /**
     * Returns the warnings and errors
     *
     * Returns an array of warnings and errors found while parsing a
     * date/time string.
     *
     * @return array Returns array containing info about warnings and
     *   errors.
     * @since PHP 5 >= 5.3.0, PHP 7
     **/
    public static function getLastErrors(){}

    /**
     * Returns the timezone offset
     *
     * @return int Returns the timezone offset in seconds from UTC on
     *   success .
     * @since PHP 5 >= 5.2.1, PHP 7
     **/
    public function getOffset(){}

    /**
     * Gets the Unix timestamp
     *
     * @return int Returns the Unix timestamp representing the date.
     * @since PHP 5 >= 5.3.0, PHP 7
     **/
    public function getTimestamp(){}

    /**
     * Return time zone relative to given DateTime
     *
     * @return DateTimeZone Returns a DateTimeZone object on success .
     * @since PHP 5 >= 5.2.1, PHP 7
     **/
    public function getTimezone(){}

    /**
     * Alters the timestamp
     *
     * Alter the timestamp of a DateTime object by incrementing or
     * decrementing in a format accepted by {@link strtotime}.
     *
     * @param string $modify
     * @return DateTime
     * @since PHP 5 >= 5.2.0, PHP 7
     **/
    public function modify($modify){}

    /**
     * Sets the date
     *
     * Resets the current date of the DateTime object to a different date.
     *
     * @param int $year Year of the date.
     * @param int $month Month of the date.
     * @param int $day Day of the date.
     * @return DateTime
     * @since PHP 5 >= 5.2.0, PHP 7
     **/
    public function setDate($year, $month, $day){}

    /**
     * Sets the ISO date
     *
     * Set a date according to the ISO 8601 standard - using weeks and day
     * offsets rather than specific dates.
     *
     * @param int $year Year of the date.
     * @param int $week Week of the date.
     * @param int $day Offset from the first day of the week.
     * @return DateTime
     * @since PHP 5 >= 5.2.0, PHP 7
     **/
    public function setISODate($year, $week, $day){}

    /**
     * Sets the time
     *
     * Resets the current time of the DateTime object to a different time.
     *
     * @param int $hour Hour of the time.
     * @param int $minute Minute of the time.
     * @param int $second Second of the time.
     * @param int $microseconds Microsecond of the time.
     * @return DateTime
     * @since PHP 5 >= 5.2.0, PHP 7
     **/
    public function setTime($hour, $minute, $second, $microseconds){}

    /**
     * Sets the date and time based on an Unix timestamp
     *
     * @param int $unixtimestamp Unix timestamp representing the date.
     * @return DateTime
     * @since PHP 5 >= 5.3.0, PHP 7
     **/
    public function setTimestamp($unixtimestamp){}

    /**
     * Sets the time zone for the DateTime object
     *
     * Sets a new timezone for a DateTime object.
     *
     * @param DateTimeZone $timezone A DateTimeZone object representing the
     *   desired time zone.
     * @return DateTime
     * @since PHP 5 >= 5.2.0, PHP 7
     **/
    public function setTimezone($timezone){}

    /**
     * Subtracts an amount of days, months, years, hours, minutes and seconds
     * from a DateTime object
     *
     * Subtracts the specified DateInterval object from the specified
     * DateTime object.
     *
     * @param DateInterval $interval A DateInterval object
     * @return DateTime
     * @since PHP 5 >= 5.3.0, PHP 7
     **/
    public function sub($interval){}

    /**
     * The __set_state handler
     *
     * The __set_state() handler.
     *
     * @param array $array Initialization array.
     * @return DateTime Returns a new instance of a DateTime object.
     * @since PHP 5 >= 5.3.0, PHP 7
     **/
    public static function __set_state($array){}

    /**
     * The __wakeup handler
     *
     * The __wakeup() handler.
     *
     * @since PHP 5 >= 5.3.0, PHP 7
     **/
    public function __wakeup(){}

}
/**
 * This class behaves the same as DateTime except it never modifies
 * itself but returns a new object instead.
 **/
class DateTimeImmutable implements DateTimeInterface {
    /**
     * Adds an amount of days, months, years, hours, minutes and seconds
     *
     * Like DateTime::add but works with DateTimeImmutable.
     *
     * @param DateInterval $interval
     * @return DateTimeImmutable
     * @since PHP 5 >= 5.5.0, PHP 7
     **/
    public function add($interval){}

    /**
     * Parses a time string according to a specified format
     *
     * Like DateTime::createFromFormat but works with DateTimeImmutable.
     *
     * @param string $format
     * @param string $time
     * @param DateTimeZone $timezone
     * @return DateTimeImmutable
     * @since PHP 5 >= 5.5.0, PHP 7
     **/
    public static function createFromFormat($format, $time, $timezone){}

    /**
     * Returns new DateTimeImmutable object encapsulating the given DateTime
     * object
     *
     * @param DateTime $datetime The mutable DateTime object that you want
     *   to convert to an immutable version. This object is not modified, but
     *   instead a new DateTimeImmutable object is created containing the
     *   same date time and timezone information.
     * @return DateTimeImmutable Returns a new DateTimeImmutable instance.
     * @since PHP 5 >= 5.6.0, PHP 7
     **/
    public static function createFromMutable($datetime){}

    /**
     * Returns the difference between two DateTime objects
     *
     * Returns the difference between two DateTimeInterface objects.
     *
     * @param DateTimeInterface $datetime2 The date to compare to.
     * @param bool $absolute Should the interval be forced to be positive?
     * @return DateInterval The DateInterval object representing the
     *   difference between the two dates.
     * @since PHP 5 >= 5.5.0, PHP 7
     **/
    public function diff($datetime2, $absolute){}

    /**
     * Returns date formatted according to given format
     *
     * @param string $format Format accepted by {@link date}.
     * @return string Returns the formatted date string on success.
     * @since PHP 5 >= 5.5.0, PHP 7
     **/
    public function format($format){}

    /**
     * Returns the warnings and errors
     *
     * Like DateTime::getLastErrors but works with DateTimeImmutable.
     *
     * @return array
     * @since PHP 5 >= 5.5.0, PHP 7
     **/
    public static function getLastErrors(){}

    /**
     * Returns the timezone offset
     *
     * @return int Returns the timezone offset in seconds from UTC on
     *   success .
     * @since PHP 5 >= 5.5.0, PHP 7
     **/
    public function getOffset(){}

    /**
     * Gets the Unix timestamp
     *
     * @return int Returns the Unix timestamp representing the date.
     * @since PHP 5 >= 5.5.0, PHP 7
     **/
    public function getTimestamp(){}

    /**
     * Return time zone relative to given DateTime
     *
     * @return DateTimeZone Returns a DateTimeZone object on success .
     * @since PHP 5 >= 5.5.0, PHP 7
     **/
    public function getTimezone(){}

    /**
     * Creates a new object with modified timestamp
     *
     * Creates a new DateTimeImmutable object with modified timestamp. The
     * original object is not modified.
     *
     * @param string $modify
     * @return DateTimeImmutable Returns the newly created object.
     * @since PHP 5 >= 5.5.0, PHP 7
     **/
    public function modify($modify){}

    /**
     * Sets the date
     *
     * Like DateTime::setDate but works with DateTimeImmutable.
     *
     * @param int $year
     * @param int $month
     * @param int $day
     * @return DateTimeImmutable
     * @since PHP 5 >= 5.5.0, PHP 7
     **/
    public function setDate($year, $month, $day){}

    /**
     * Sets the ISO date
     *
     * Like DateTime::setISODate but works with DateTimeImmutable.
     *
     * @param int $year
     * @param int $week
     * @param int $day
     * @return DateTimeImmutable
     * @since PHP 5 >= 5.5.0, PHP 7
     **/
    public function setISODate($year, $week, $day){}

    /**
     * Sets the time
     *
     * Like DateTime::setTime but works with DateTimeImmutable.
     *
     * @param int $hour
     * @param int $minute
     * @param int $second
     * @param int $microseconds
     * @return DateTimeImmutable
     * @since PHP 5 >= 5.5.0, PHP 7
     **/
    public function setTime($hour, $minute, $second, $microseconds){}

    /**
     * Sets the date and time based on a Unix timestamp
     *
     * Like DateTime::setTimestamp but works with DateTimeImmutable.
     *
     * @param int $unixtimestamp
     * @return DateTimeImmutable
     * @since PHP 5 >= 5.5.0, PHP 7
     **/
    public function setTimestamp($unixtimestamp){}

    /**
     * Sets the time zone
     *
     * Like DateTime::setTimezone but works with DateTimeImmutable.
     *
     * @param DateTimeZone $timezone
     * @return DateTimeImmutable
     * @since PHP 5 >= 5.5.0, PHP 7
     **/
    public function setTimezone($timezone){}

    /**
     * Subtracts an amount of days, months, years, hours, minutes and seconds
     *
     * Like DateTime::sub but works with DateTimeImmutable.
     *
     * @param DateInterval $interval
     * @return DateTimeImmutable
     * @since PHP 5 >= 5.5.0, PHP 7
     **/
    public function sub($interval){}

    /**
     * The __set_state handler
     *
     * Like DateTime::__set_state but works with DateTimeImmutable.
     *
     * @param array $array
     * @return DateTimeImmutable
     * @since PHP 5 >= 5.5.0, PHP 7
     **/
    public static function __set_state($array){}

    /**
     * The __wakeup handler
     *
     * The __wakeup() handler.
     *
     * @since PHP 5 >= 5.5.0, PHP 7
     **/
    public function __wakeup(){}

}
/**
 * DateTimeInterface is meant so that both DateTime and DateTimeImmutable
 * can be type hinted for. It is not possible to implement this interface
 * with userland classes. 7.2.0 The class constants of DateTime are now
 * defined on DateTimeInterface. 5.5.8 Trying to implement
 * DateTimeInterface raises a fatal error now. Formerly implementing the
 * interface didn't raise an error, but the behavior was erroneous.
 **/
interface DateTimeInterface {
    /**
     * @var string
     **/
    const ATOM = '';

    /**
     * @var string
     **/
    const COOKIE = '';

    /**
     * @var string
     **/
    const ISO8601 = '';

    /**
     * @var string
     **/
    const RFC822 = '';

    /**
     * @var string
     **/
    const RFC850 = '';

    /**
     * @var string
     **/
    const RFC1036 = '';

    /**
     * @var string
     **/
    const RFC1123 = '';

    /**
     * @var string
     **/
    const RFC2822 = '';

    /**
     * @var string
     **/
    const RFC3339 = '';

    /**
     * @var string
     **/
    const RFC3339_EXTENDED = '';

    /**
     * @var string
     **/
    const RSS = '';

    /**
     * @var string
     **/
    const W3C = '';

    /**
     * Returns the difference between two DateTime objects
     *
     * Returns the difference between two DateTimeInterface objects.
     *
     * @param DateTimeInterface $datetime2 The date to compare to.
     * @param bool $absolute Should the interval be forced to be positive?
     * @return DateInterval The DateInterval object representing the
     *   difference between the two dates.
     * @since PHP 5 >= 5.3.0, PHP 7
     **/
    public function diff($datetime2, $absolute);

    /**
     * Returns date formatted according to given format
     *
     * @param string $format Format accepted by {@link date}.
     * @return string Returns the formatted date string on success.
     * @since PHP 5 >= 5.2.0, PHP 7
     **/
    public function format($format);

    /**
     * Returns the timezone offset
     *
     * @return int Returns the timezone offset in seconds from UTC on
     *   success .
     * @since PHP 5 >= 5.2.0, PHP 7
     **/
    public function getOffset();

    /**
     * Gets the Unix timestamp
     *
     * @return int Returns the Unix timestamp representing the date.
     * @since PHP 5 >= 5.3.0, PHP 7
     **/
    public function getTimestamp();

    /**
     * Return time zone relative to given DateTime
     *
     * @return DateTimeZone Returns a DateTimeZone object on success .
     * @since PHP 5 >= 5.2.0, PHP 7
     **/
    public function getTimezone();

    /**
     * The __wakeup handler
     *
     * The __wakeup() handler.
     *
     * @since PHP 5 >= 5.2.0, PHP 7
     **/
    public function __wakeup();

}
/**
 * Representation of time zone.
 **/
class DateTimeZone {
    /**
     * Africa time zones.
     *
     * @var integer
     **/
    const AFRICA = 0;

    /**
     * All time zones.
     *
     * @var integer
     **/
    const ALL = 0;

    /**
     * @var integer
     **/
    const ALL_WITH_BC = 0;

    /**
     * America time zones.
     *
     * @var integer
     **/
    const AMERICA = 0;

    /**
     * Antarctica time zones.
     *
     * @var integer
     **/
    const ANTARCTICA = 0;

    /**
     * Arctic time zones.
     *
     * @var integer
     **/
    const ARCTIC = 0;

    /**
     * Asia time zones.
     *
     * @var integer
     **/
    const ASIA = 0;

    /**
     * Atlantic time zones.
     *
     * @var integer
     **/
    const ATLANTIC = 0;

    /**
     * Australia time zones.
     *
     * @var integer
     **/
    const AUSTRALIA = 0;

    /**
     * Europe time zones.
     *
     * @var integer
     **/
    const EUROPE = 0;

    /**
     * Indian time zones.
     *
     * @var integer
     **/
    const INDIAN = 0;

    /**
     * Pacific time zones.
     *
     * @var integer
     **/
    const PACIFIC = 0;

    /**
     * @var integer
     **/
    const PER_COUNTRY = 0;

    /**
     * UTC time zones.
     *
     * @var integer
     **/
    const UTC = 0;

    /**
     * Returns location information for a timezone
     *
     * Returns location information for a timezone, including country code,
     * latitude/longitude and comments.
     *
     * @return array Array containing location information about timezone.
     * @since PHP 5 >= 5.3.0, PHP 7
     **/
    public function getLocation(){}

    /**
     * Returns the name of the timezone
     *
     * @return string One of the timezone names in the list of timezones.
     * @since PHP 5 >= 5.2.0, PHP 7
     **/
    public function getName(){}

    /**
     * Returns the timezone offset from GMT
     *
     * This function returns the offset to GMT for the date/time specified in
     * the {@link datetime} parameter. The GMT offset is calculated with the
     * timezone information contained in the DateTimeZone object being used.
     *
     * @param DateTimeInterface $datetime DateTime that contains the
     *   date/time to compute the offset from.
     * @return int Returns time zone offset in seconds on success.
     * @since PHP 5 >= 5.2.0, PHP 7
     **/
    public function getOffset($datetime){}

    /**
     * Returns all transitions for the timezone
     *
     * @param int $timestamp_begin Begin timestamp.
     * @param int $timestamp_end End timestamp.
     * @return array Returns numerically indexed array containing
     *   associative array with all transitions on success.
     * @since PHP 5 >= 5.2.0, PHP 7
     **/
    public function getTransitions($timestamp_begin, $timestamp_end){}

    /**
     * Returns associative array containing dst, offset and the timezone name
     *
     * @return array Returns array on success.
     * @since PHP 5 >= 5.2.0, PHP 7
     **/
    public static function listAbbreviations(){}

    /**
     * Returns a numerically indexed array containing all defined timezone
     * identifiers
     *
     * @param int $what One of the DateTimeZone class constants (or a
     *   combination).
     * @param string $country A two-letter ISO 3166-1 compatible country
     *   code.
     * @return array Returns array on success.
     * @since PHP 5 >= 5.2.0, PHP 7
     **/
    public static function listIdentifiers($what, $country){}

}
/**
 * Created by {@link dir}.
 **/
class Directory {
    /**
     * Can be used with other directory functions such as {@link readdir},
     * {@link rewinddir} and {@link closedir}.
     *
     * @var resource
     **/
    public $handle;

    /**
     * The directory that was opened.
     *
     * @var string
     **/
    public $path;

    /**
     * Close directory handle
     *
     * Same as {@link closedir}, only dir_handle defaults to $this->handle.
     *
     * @param resource $dir_handle
     * @return void
     * @since PHP 4, PHP 5, PHP 7
     **/
    public function close($dir_handle){}

    /**
     * Read entry from directory handle
     *
     * Same as {@link readdir}, only dir_handle defaults to $this->handle.
     *
     * @param resource $dir_handle
     * @return string
     * @since PHP 4, PHP 5, PHP 7
     **/
    public function read($dir_handle){}

    /**
     * Rewind directory handle
     *
     * Same as {@link rewinddir}, only dir_handle defaults to $this->handle.
     *
     * @param resource $dir_handle
     * @return void
     * @since PHP 4, PHP 5, PHP 7
     **/
    public function rewind($dir_handle){}

}
/**
 * The DirectoryIterator class provides a simple interface for viewing
 * the contents of filesystem directories. 5.1.2 DirectoryIterator
 * extends SplFileInfo.
 **/
class DirectoryIterator extends SplFileInfo implements SeekableIterator {
    /**
     * Return the current DirectoryIterator item
     *
     * Get the current DirectoryIterator item.
     *
     * @return DirectoryIterator The current DirectoryIterator item.
     * @since PHP 5, PHP 7
     **/
    public function current(){}

    /**
     * Get last access time of the current DirectoryIterator item
     *
     * Get the last access time of the current DirectoryIterator item.
     *
     * @return int Returns the time the file was last accessed, as a Unix
     *   timestamp.
     * @since PHP 5, PHP 7
     **/
    public function getATime(){}

    /**
     * Get base name of current DirectoryIterator item
     *
     * Get the base name of the current DirectoryIterator item.
     *
     * @param string $suffix If the base name ends in {@link suffix}, this
     *   will be cut.
     * @return string The base name of the current DirectoryIterator item.
     * @since PHP 5 >= 5.2.2, PHP 7
     **/
    public function getBasename($suffix){}

    /**
     * Get inode change time of the current DirectoryIterator item
     *
     * Get the inode change time for the current DirectoryIterator item.
     *
     * @return int Returns the last change time of the file, as a Unix
     *   timestamp.
     * @since PHP 5, PHP 7
     **/
    public function getCTime(){}

    /**
     * Gets the file extension
     *
     * Retrieves the file extension.
     *
     * @return string Returns a string containing the file extension, or an
     *   empty string if the file has no extension.
     * @since PHP 5 >= 5.3.6, PHP 7
     **/
    public function getExtension(){}

    /**
     * Return file name of current DirectoryIterator item
     *
     * Get the file name of the current DirectoryIterator item.
     *
     * @return string Returns the file name of the current
     *   DirectoryIterator item.
     * @since PHP 5, PHP 7
     **/
    public function getFilename(){}

    /**
     * Get group for the current DirectoryIterator item
     *
     * Get the group id of the file.
     *
     * @return int Returns the group id of the current DirectoryIterator
     *   item in numerical format.
     * @since PHP 5, PHP 7
     **/
    public function getGroup(){}

    /**
     * Get inode for the current DirectoryIterator item
     *
     * Get the inode number for the current DirectoryIterator item.
     *
     * @return int Returns the inode number for the file.
     * @since PHP 5, PHP 7
     **/
    public function getInode(){}

    /**
     * Get last modification time of current DirectoryIterator item
     *
     * Get the last modification time of the current DirectoryIterator item,
     * as a Unix timestamp.
     *
     * @return int The last modification time of the file, as a Unix
     *   timestamp.
     * @since PHP 5, PHP 7
     **/
    public function getMTime(){}

    /**
     * Get owner of current DirectoryIterator item
     *
     * Get the owner of the current DirectoryIterator item, in numerical
     * format.
     *
     * @return int The file owner of the file, in numerical format.
     * @since PHP 5, PHP 7
     **/
    public function getOwner(){}

    /**
     * Get path of current Iterator item without filename
     *
     * Get the path to the current DirectoryIterator item.
     *
     * @return string Returns the path to the file, omitting the file name
     *   and any trailing slash.
     * @since PHP 5, PHP 7
     **/
    public function getPath(){}

    /**
     * Return path and file name of current DirectoryIterator item
     *
     * Get the path and file name of the current file.
     *
     * @return string Returns the path and file name of current file.
     *   Directories do not have a trailing slash.
     * @since PHP 5, PHP 7
     **/
    public function getPathname(){}

    /**
     * Get the permissions of current DirectoryIterator item
     *
     * Get the permissions of the current DirectoryIterator item.
     *
     * @return int Returns the permissions of the file, as a decimal
     *   integer.
     * @since PHP 5, PHP 7
     **/
    public function getPerms(){}

    /**
     * Get size of current DirectoryIterator item
     *
     * Get the file size for the current DirectoryIterator item.
     *
     * @return int Returns the size of the file, in bytes.
     * @since PHP 5, PHP 7
     **/
    public function getSize(){}

    /**
     * Determine the type of the current DirectoryIterator item
     *
     * Determines which file type the current DirectoryIterator item belongs
     * to. One of file, link, or dir.
     *
     * @return string Returns a string representing the type of the file.
     *   May be one of file, link, or dir.
     * @since PHP 5, PHP 7
     **/
    public function getType(){}

    /**
     * Determine if current DirectoryIterator item is a directory
     *
     * Determines if the current DirectoryIterator item is a directory.
     *
     * @return bool Returns TRUE if it is a directory, otherwise FALSE
     * @since PHP 5, PHP 7
     **/
    public function isDir(){}

    /**
     * Determine if current DirectoryIterator item is '.' or '..'
     *
     * Determines if the current DirectoryIterator item is a directory and
     * either . or ..
     *
     * @return bool TRUE if the entry is . or .., otherwise FALSE
     * @since PHP 5, PHP 7
     **/
    public function isDot(){}

    /**
     * Determine if current DirectoryIterator item is executable
     *
     * Determines if the current DirectoryIterator item is executable.
     *
     * @return bool Returns TRUE if the entry is executable, otherwise
     *   FALSE
     * @since PHP 5, PHP 7
     **/
    public function isExecutable(){}

    /**
     * Determine if current DirectoryIterator item is a regular file
     *
     * Determines if the current DirectoryIterator item is a regular file.
     *
     * @return bool Returns TRUE if the file exists and is a regular file
     *   (not a link or dir), otherwise FALSE
     * @since PHP 5, PHP 7
     **/
    public function isFile(){}

    /**
     * Determine if current DirectoryIterator item is a symbolic link
     *
     * Determines if the current DirectoryIterator item is a symbolic link.
     *
     * @return bool Returns TRUE if the item is a symbolic link, otherwise
     *   FALSE
     * @since PHP 5, PHP 7
     **/
    public function isLink(){}

    /**
     * Determine if current DirectoryIterator item can be read
     *
     * Determines if the current DirectoryIterator item is readable.
     *
     * @return bool Returns TRUE if the file is readable, otherwise FALSE
     * @since PHP 5, PHP 7
     **/
    public function isReadable(){}

    /**
     * Determine if current DirectoryIterator item can be written to
     *
     * Determines if the current DirectoryIterator item is writable.
     *
     * @return bool Returns TRUE if the file/directory is writable,
     *   otherwise FALSE
     * @since PHP 5, PHP 7
     **/
    public function isWritable(){}

    /**
     * Return the key for the current DirectoryIterator item
     *
     * Get the key for the current DirectoryIterator item.
     *
     * @return string The key for the current DirectoryIterator item.
     * @since PHP 5, PHP 7
     **/
    public function key(){}

    /**
     * Move forward to next DirectoryIterator item
     *
     * Move forward to the next DirectoryIterator item.
     *
     * @return void
     * @since PHP 5, PHP 7
     **/
    public function next(){}

    /**
     * Rewind the DirectoryIterator back to the start
     *
     * Rewind the DirectoryIterator back to the start.
     *
     * @return void
     * @since PHP 5, PHP 7
     **/
    public function rewind(){}

    /**
     * Seek to a DirectoryIterator item
     *
     * Seek to a given position in the DirectoryIterator.
     *
     * @param int $position The zero-based numeric position to seek to.
     * @return void
     * @since PHP 5 >= 5.3.0, PHP 7
     **/
    public function seek($position){}

    /**
     * Check whether current DirectoryIterator position is a valid file
     *
     * Check whether current DirectoryIterator position is a valid file.
     *
     * @return bool Returns TRUE if the position is valid, otherwise FALSE
     * @since PHP 5, PHP 7
     **/
    public function valid(){}

    /**
     * Get file name as a string
     *
     * Get the file name of the current DirectoryIterator item.
     *
     * @return string Returns the file name of the current
     *   DirectoryIterator item.
     * @since PHP 5, PHP 7
     **/
    public function __toString(){}

}
/**
 * DivisionByZeroError is thrown when an attempt is made to divide a
 * number by zero.
 **/
class DivisionByZeroError extends ArithmeticError {
}
/**
 * Exception thrown if a value does not adhere to a defined valid data
 * domain.
 **/
class DomainException extends LogicException {
}
/**
 * DOMAttr represents an attribute in the DOMElement object.
 **/
class DomAttr extends DOMNode {
    /**
     * The name of the attribute
     *
     * @var string
     **/
    public $name;

    /**
     * @var DOMElement
     **/
    public $ownerElement;

    /**
     * @var bool
     **/
    public $schemaTypeInfo;

    /**
     * Not implemented yet, always is NULL
     *
     * @var bool
     **/
    public $specified;

    /**
     * The value of the attribute
     *
     * @var string
     **/
    public $value;

    /**
     * Checks if attribute is a defined ID
     *
     * This function checks if the attribute is a defined ID.
     *
     * According to the DOM standard this requires a DTD which defines the
     * attribute ID to be of type ID. You need to validate your document with
     * or DOMDocument::validateOnParse before using this function.
     *
     * @return bool
     * @since PHP 5, PHP 7
     **/
    public function isId(){}

    /**
     * Creates a new object
     *
     * Creates a new DOMAttr object. This object is read only. It may be
     * appended to a document, but additional nodes may not be appended to
     * this node until the node is associated with a document. To create a
     * writable node, use .
     *
     * @param string $name The tag name of the attribute.
     * @param string $value The value of the attribute.
     * @since PHP 5, PHP 7
     **/
    public function __construct($name, $value){}

}
/**
 * The DOMCdataSection inherits from DOMText for textural representation
 * of CData constructs.
 **/
class DOMCdataSection extends DOMText {
}
/**
 * Represents nodes with character data. No nodes directly correspond to
 * this class, but other nodes do inherit from it.
 **/
class DomCharacterData extends DOMNode {
    /**
     * The contents of the node.
     *
     * @var string
     **/
    public $data;

    /**
     * The length of the contents.
     *
     * @var int
     **/
    public $length;

    /**
     * Append the string to the end of the character data of the node
     *
     * Append the string {@link data} to the end of the character data of the
     * node.
     *
     * @param string $data The string to append.
     * @return void
     * @since PHP 5, PHP 7
     **/
    public function appendData($data){}

    /**
     * Remove a range of characters from the node
     *
     * Deletes {@link count} characters starting from position {@link
     * offset}.
     *
     * @param int $offset The offset from which to start removing.
     * @param int $count The number of characters to delete. If the sum of
     *   {@link offset} and {@link count} exceeds the length, then all
     *   characters to the end of the data are deleted.
     * @return void
     * @since PHP 5, PHP 7
     **/
    public function deleteData($offset, $count){}

    /**
     * Insert a string at the specified 16-bit unit offset
     *
     * Inserts string {@link data} at position {@link offset}.
     *
     * @param int $offset The character offset at which to insert.
     * @param string $data The string to insert.
     * @return void
     * @since PHP 5, PHP 7
     **/
    public function insertData($offset, $data){}

    /**
     * Replace a substring within the DOMCharacterData node
     *
     * Replace {@link count} characters starting from position {@link offset}
     * with {@link data}.
     *
     * @param int $offset The offset from which to start replacing.
     * @param int $count The number of characters to replace. If the sum of
     *   {@link offset} and {@link count} exceeds the length, then all
     *   characters to the end of the data are replaced.
     * @param string $data The string with which the range must be
     *   replaced.
     * @return void
     * @since PHP 5, PHP 7
     **/
    public function replaceData($offset, $count, $data){}

    /**
     * Extracts a range of data from the node
     *
     * Returns the specified substring.
     *
     * @param int $offset Start offset of substring to extract.
     * @param int $count The number of characters to extract.
     * @return string The specified substring. If the sum of {@link offset}
     *   and {@link count} exceeds the length, then all 16-bit units to the
     *   end of the data are returned.
     * @since PHP 5, PHP 7
     **/
    public function substringData($offset, $count){}

}
/**
 * Represents comment nodes, characters delimited by .
 **/
class DomComment extends DOMCharacterData {
    /**
     * Creates a new DOMComment object
     *
     * Creates a new DOMComment object. This object is read only. It may be
     * appended to a document, but additional nodes may not be appended to
     * this node until the node is associated with a document. To create a
     * writeable node, use .
     *
     * @param string $value The value of the comment.
     * @since PHP 5, PHP 7
     **/
    public function __construct($value){}

}
/**
 * Represents an entire HTML or XML document; serves as the root of the
 * document tree.
 **/
class DomDocument extends DOMNode {
    /**
     * @var string
     **/
    public $actualEncoding;

    /**
     * Deprecated. Configuration used when {@link
     * DOMDocument::normalizeDocument} is invoked.
     *
     * @var DOMConfiguration
     **/
    public $config;

    /**
     * The Document Type Declaration associated with this document.
     *
     * @var DOMDocumentType
     **/
    public $doctype;

    /**
     * @var DOMElement
     **/
    public $documentElement;

    /**
     * @var string
     **/
    public $documentURI;

    /**
     * Encoding of the document, as specified by the XML declaration. This
     * attribute is not present in the final DOM Level 3 specification, but
     * is the only way of manipulating XML document encoding in this
     * implementation.
     *
     * @var string
     **/
    public $encoding;

    /**
     * @var bool
     **/
    public $formatOutput;

    /**
     * The DOMImplementation object that handles this document.
     *
     * @var DOMImplementation
     **/
    public $implementation;

    /**
     * @var bool
     **/
    public $preserveWhiteSpace;

    /**
     * Proprietary. Enables recovery mode, i.e. trying to parse non-well
     * formed documents. This attribute is not part of the DOM specification
     * and is specific to libxml.
     *
     * @var bool
     **/
    public $recover;

    /**
     * @var bool
     **/
    public $resolveExternals;

    /**
     * Deprecated. Whether or not the document is standalone, as specified by
     * the XML declaration, corresponds to xmlStandalone.
     *
     * @var bool
     **/
    public $standalone;

    /**
     * @var bool
     **/
    public $strictErrorChecking;

    /**
     * @var bool
     **/
    public $substituteEntities;

    /**
     * @var bool
     **/
    public $validateOnParse;

    /**
     * Deprecated. Version of XML, corresponds to xmlVersion.
     *
     * @var string
     **/
    public $version;

    /**
     * @var string
     **/
    public $xmlEncoding;

    /**
     * @var bool
     **/
    public $xmlStandalone;

    /**
     * @var string
     **/
    public $xmlVersion;

    /**
     * Create new attribute
     *
     * This function creates a new instance of class DOMAttr.
     *
     * @param string $name The name of the attribute.
     * @return DOMAttr The new DOMAttr or FALSE if an error occurred.
     * @since PHP 5, PHP 7
     **/
    public function createAttribute($name){}

    /**
     * Create new attribute node with an associated namespace
     *
     * This function creates a new instance of class DOMAttr.
     *
     * @param string $namespaceURI The URI of the namespace.
     * @param string $qualifiedName The tag name and prefix of the
     *   attribute, as prefix:tagname.
     * @return DOMAttr The new DOMAttr or FALSE if an error occurred.
     * @since PHP 5, PHP 7
     **/
    public function createAttributeNS($namespaceURI, $qualifiedName){}

    /**
     * Create new cdata node
     *
     * This function creates a new instance of class DOMCDATASection.
     *
     * @param string $data The content of the cdata.
     * @return DOMCDATASection The new DOMCDATASection or FALSE if an error
     *   occurred.
     * @since PHP 5, PHP 7
     **/
    public function createCDATASection($data){}

    /**
     * Create new comment node
     *
     * This function creates a new instance of class DOMComment.
     *
     * @param string $data The content of the comment.
     * @return DOMComment The new DOMComment or FALSE if an error occurred.
     * @since PHP 5, PHP 7
     **/
    public function createComment($data){}

    /**
     * Create new document fragment
     *
     * This function creates a new instance of class DOMDocumentFragment.
     *
     * @return DOMDocumentFragment The new DOMDocumentFragment or FALSE if
     *   an error occurred.
     * @since PHP 5, PHP 7
     **/
    public function createDocumentFragment(){}

    /**
     * Create new element node
     *
     * This function creates a new instance of class DOMElement.
     *
     * @param string $name The tag name of the element.
     * @param string $value The value of the element. By default, an empty
     *   element will be created. The value can also be set later with
     *   DOMElement::$nodeValue. The value is used verbatim except that the <
     *   and > entity references will escaped. Note that & has to be manually
     *   escaped; otherwise it is regarded as starting an entity reference.
     *   Also " won't be escaped.
     * @return DOMElement Returns a new instance of class DOMElement or
     *   FALSE if an error occurred.
     * @since PHP 5, PHP 7
     **/
    public function createElement($name, $value){}

    /**
     * Create new element node with an associated namespace
     *
     * This function creates a new element node with an associated namespace.
     *
     * @param string $namespaceURI The URI of the namespace.
     * @param string $qualifiedName The qualified name of the element, as
     *   prefix:tagname.
     * @param string $value The value of the element. By default, an empty
     *   element will be created. You can also set the value later with
     *   DOMElement::$nodeValue.
     * @return DOMElement The new DOMElement or FALSE if an error occurred.
     * @since PHP 5, PHP 7
     **/
    public function createElementNS($namespaceURI, $qualifiedName, $value){}

    /**
     * Create new entity reference node
     *
     * This function creates a new instance of class DOMEntityReference.
     *
     * @param string $name The content of the entity reference, e.g. the
     *   entity reference minus the leading & and the trailing ; characters.
     * @return DOMEntityReference The new DOMEntityReference or FALSE if an
     *   error occurred.
     * @since PHP 5, PHP 7
     **/
    public function createEntityReference($name){}

    /**
     * Creates new PI node
     *
     * This function creates a new instance of class
     * DOMProcessingInstruction.
     *
     * @param string $target The target of the processing instruction.
     * @param string $data The content of the processing instruction.
     * @return DOMProcessingInstruction The new DOMProcessingInstruction or
     *   FALSE if an error occurred.
     * @since PHP 5, PHP 7
     **/
    public function createProcessingInstruction($target, $data){}

    /**
     * Create new text node
     *
     * This function creates a new instance of class DOMText.
     *
     * @param string $content The content of the text.
     * @return DOMText The new DOMText or FALSE if an error occurred.
     * @since PHP 5, PHP 7
     **/
    public function createTextNode($content){}

    /**
     * Searches for an element with a certain id
     *
     * This function is similar to but searches for an element with a given
     * id.
     *
     * For this function to work, you will need either to set some ID
     * attributes with or a DTD which defines an attribute to be of type ID.
     * In the later case, you will need to validate your document with or
     * DOMDocument::$validateOnParse before using this function.
     *
     * @param string $elementId The unique id value for an element.
     * @return DOMElement Returns the DOMElement or NULL if the element is
     *   not found.
     * @since PHP 5, PHP 7
     **/
    public function getElementById($elementId){}

    /**
     * Searches for all elements with given local tag name
     *
     * This function returns a new instance of class DOMNodeList containing
     * all the elements with a given local tag name.
     *
     * @param string $name The local name (without namespace) of the tag to
     *   match on. The special value * matches all tags.
     * @return DOMNodeList A new DOMNodeList object containing all the
     *   matched elements.
     * @since PHP 5, PHP 7
     **/
    public function getElementsByTagName($name){}

    /**
     * Searches for all elements with given tag name in specified namespace
     *
     * Returns a DOMNodeList of all elements with a given local name and a
     * namespace URI.
     *
     * @param string $namespaceURI The namespace URI of the elements to
     *   match on. The special value * matches all namespaces.
     * @param string $localName The local name of the elements to match on.
     *   The special value * matches all local names.
     * @return DOMNodeList A new DOMNodeList object containing all the
     *   matched elements.
     * @since PHP 5, PHP 7
     **/
    public function getElementsByTagNameNS($namespaceURI, $localName){}

    /**
     * Import node into current document
     *
     * This function returns a copy of the node to import and associates it
     * with the current document.
     *
     * @param DOMNode $importedNode The node to import.
     * @param bool $deep If set to TRUE, this method will recursively
     *   import the subtree under the {@link importedNode}.
     * @return DOMNode The copied node or FALSE, if it cannot be copied.
     * @since PHP 5, PHP 7
     **/
    public function importNode($importedNode, $deep){}

    /**
     * Load XML from a file
     *
     * Loads an XML document from a file.
     *
     * @param string $filename The path to the XML document.
     * @param int $options Bitwise OR of the libxml option constants.
     * @return mixed If called statically, returns a DOMDocument.
     * @since PHP 5, PHP 7
     **/
    public function load($filename, $options){}

    /**
     * Load HTML from a string
     *
     * The function parses the HTML contained in the string {@link source}.
     * Unlike loading XML, HTML does not have to be well-formed to load. This
     * function may also be called statically to load and create a
     * DOMDocument object. The static invocation may be used when no
     * DOMDocument properties need to be set prior to loading.
     *
     * @param string $source The HTML string.
     * @param int $options Since PHP 5.4.0 and Libxml 2.6.0, you may also
     *   use the {@link options} parameter to specify additional Libxml
     *   parameters.
     * @return bool If called statically, returns a DOMDocument.
     * @since PHP 5, PHP 7
     **/
    public function loadHTML($source, $options){}

    /**
     * Load HTML from a file
     *
     * The function parses the HTML document in the file named {@link
     * filename}. Unlike loading XML, HTML does not have to be well-formed to
     * load.
     *
     * @param string $filename The path to the HTML file.
     * @param int $options Since PHP 5.4.0 and Libxml 2.6.0, you may also
     *   use the {@link options} parameter to specify additional Libxml
     *   parameters.
     * @return bool If called statically, returns a DOMDocument.
     * @since PHP 5, PHP 7
     **/
    public function loadHTMLFile($filename, $options){}

    /**
     * Load XML from a string
     *
     * Loads an XML document from a string.
     *
     * @param string $source The string containing the XML.
     * @param int $options Bitwise OR of the libxml option constants.
     * @return mixed If called statically, returns a DOMDocument.
     * @since PHP 5, PHP 7
     **/
    public function loadXML($source, $options){}

    /**
     * Normalizes the document
     *
     * This method acts as if you saved and then loaded the document, putting
     * the document in a "normal" form.
     *
     * @return void
     * @since PHP 5, PHP 7
     **/
    public function normalizeDocument(){}

    /**
     * Register extended class used to create base node type
     *
     * This method allows you to register your own extended DOM class to be
     * used afterward by the PHP DOM extension.
     *
     * This method is not part of the DOM standard.
     *
     * @param string $baseclass The DOM class that you want to extend. You
     *   can find a list of these classes in the chapter introduction.
     * @param string $extendedclass Your extended class name. If NULL is
     *   provided, any previously registered class extending {@link
     *   baseclass} will be removed.
     * @return bool
     * @since PHP 5 >= 5.2.0, PHP 7
     **/
    public function registerNodeClass($baseclass, $extendedclass){}

    /**
     * Performs relaxNG validation on the document
     *
     * Performs relaxNG validation on the document based on the given RNG
     * schema.
     *
     * @param string $filename The RNG file.
     * @return bool
     * @since PHP 5, PHP 7
     **/
    public function relaxNGValidate($filename){}

    /**
     * Performs relaxNG validation on the document
     *
     * Performs relaxNG validation on the document based on the given RNG
     * source.
     *
     * @param string $source A string containing the RNG schema.
     * @return bool
     * @since PHP 5, PHP 7
     **/
    public function relaxNGValidateSource($source){}

    /**
     * Dumps the internal XML tree back into a file
     *
     * Creates an XML document from the DOM representation. This function is
     * usually called after building a new dom document from scratch as in
     * the example below.
     *
     * @param string $filename The path to the saved XML document.
     * @param int $options Additional Options. Currently only
     *   LIBXML_NOEMPTYTAG is supported.
     * @return int Returns the number of bytes written or FALSE if an error
     *   occurred.
     * @since PHP 5, PHP 7
     **/
    public function save($filename, $options){}

    /**
     * Dumps the internal document into a string using HTML formatting
     *
     * Creates an HTML document from the DOM representation. This function is
     * usually called after building a new dom document from scratch as in
     * the example below.
     *
     * @param DOMNode $node Optional parameter to output a subset of the
     *   document.
     * @return string Returns the HTML, or FALSE if an error occurred.
     * @since PHP 5, PHP 7
     **/
    public function saveHTML($node){}

    /**
     * Dumps the internal document into a file using HTML formatting
     *
     * Creates an HTML document from the DOM representation. This function is
     * usually called after building a new dom document from scratch as in
     * the example below.
     *
     * @param string $filename The path to the saved HTML document.
     * @return int Returns the number of bytes written or FALSE if an error
     *   occurred.
     * @since PHP 5, PHP 7
     **/
    public function saveHTMLFile($filename){}

    /**
     * Dumps the internal XML tree back into a string
     *
     * Creates an XML document from the DOM representation. This function is
     * usually called after building a new dom document from scratch as in
     * the example below.
     *
     * @param DOMNode $node Use this parameter to output only a specific
     *   node without XML declaration rather than the entire document.
     * @param int $options Additional Options. Currently only
     *   LIBXML_NOEMPTYTAG is supported.
     * @return string Returns the XML, or FALSE if an error occurred.
     * @since PHP 5, PHP 7
     **/
    public function saveXML($node, $options){}

    /**
     * Validates a document based on a schema
     *
     * Validates a document based on the given schema file.
     *
     * @param string $filename The path to the schema.
     * @param int $flags A bitmask of Libxml schema validation flags.
     *   Currently the only supported value is LIBXML_SCHEMA_CREATE.
     *   Available since PHP 5.5.2 and Libxml 2.6.14.
     * @return bool
     * @since PHP 5, PHP 7
     **/
    public function schemaValidate($filename, $flags){}

    /**
     * Validates a document based on a schema
     *
     * Validates a document based on a schema defined in the given string.
     *
     * @param string $source A string containing the schema.
     * @param int $flags A bitmask of Libxml schema validation flags.
     *   Currently the only supported value is LIBXML_SCHEMA_CREATE.
     *   Available since PHP 5.5.2 and Libxml 2.6.14.
     * @return bool
     * @since PHP 5, PHP 7
     **/
    public function schemaValidateSource($source, $flags){}

    /**
     * Validates the document based on its DTD
     *
     * Validates the document based on its DTD.
     *
     * You can also use the validateOnParse property of DOMDocument to make a
     * DTD validation.
     *
     * @return bool If the document has no DTD attached, this method will
     *   return FALSE.
     * @since PHP 5, PHP 7
     **/
    public function validate(){}

    /**
     * Substitutes XIncludes in a DOMDocument Object
     *
     * This method substitutes XIncludes in a DOMDocument object.
     *
     * @param int $options libxml parameters. Available since PHP 5.1.0 and
     *   Libxml 2.6.7.
     * @return int Returns the number of XIncludes in the document, -1 if
     *   some processing failed, or FALSE if there were no substitutions.
     * @since PHP 5, PHP 7
     **/
    public function xinclude($options){}

    /**
     * Creates a new DOMDocument object
     *
     * Creates a new DOMDocument object.
     *
     * @param string $version The version number of the document as part of
     *   the XML declaration.
     * @param string $encoding The encoding of the document as part of the
     *   XML declaration.
     * @since PHP 5, PHP 7
     **/
    public function __construct($version, $encoding){}

}
class DOMDocumentFragment extends DOMNode {
    /**
     * Append raw XML data
     *
     * Appends raw XML data to a DOMDocumentFragment.
     *
     * This method is not part of the DOM standard. It was created as a
     * simpler approach for appending an XML DocumentFragment in a
     * DOMDocument.
     *
     * If you want to stick to the standards, you will have to create a
     * temporary DOMDocument with a dummy root and then loop through the
     * child nodes of the root of your XML data to append them.
     *
     * @param string $data XML to append.
     * @return bool
     * @since PHP 5 >= 5.1.0, PHP 7
     **/
    public function appendXML($data){}

}
/**
 * Each DOMDocument has a doctype attribute whose value is either NULL or
 * a DOMDocumentType object.
 **/
class DOMDocumentType extends DOMNode {
    /**
     * A DOMNamedNodeMap containing the general entities, both external and
     * internal, declared in the DTD.
     *
     * @var DOMNamedNodeMap
     **/
    public $entities;

    /**
     * @var string
     **/
    public $internalSubset;

    /**
     * The name of DTD; i.e., the name immediately following the DOCTYPE
     * keyword.
     *
     * @var string
     **/
    public $name;

    /**
     * A DOMNamedNodeMap containing the notations declared in the DTD.
     *
     * @var DOMNamedNodeMap
     **/
    public $notations;

    /**
     * @var string
     **/
    public $publicId;

    /**
     * @var string
     **/
    public $systemId;

}
class DomElement extends DOMNode {
    /**
     * Returns value of attribute
     *
     * Gets the value of the attribute with name {@link name} for the current
     * node.
     *
     * @param string $name The name of the attribute.
     * @return string The value of the attribute, or an empty string if no
     *   attribute with the given {@link name} is found.
     * @since PHP 5, PHP 7
     **/
    public function getAttribute($name){}

    /**
     * Returns attribute node
     *
     * Returns the attribute node with name {@link name} for the current
     * element.
     *
     * @param string $name The name of the attribute.
     * @return DOMAttr The attribute node. Note that for XML namespace
     *   declarations (xmlns and xmlns:* attributes) an instance of
     *   DOMNameSpaceNode is returned instead of a DOMAttr.
     * @since PHP 5, PHP 7
     **/
    public function getAttributeNode($name){}

    /**
     * Returns attribute node
     *
     * Returns the attribute node in namespace {@link namespaceURI} with
     * local name {@link localName} for the current node.
     *
     * @param string $namespaceURI The namespace URI.
     * @param string $localName The local name.
     * @return DOMAttr The attribute node. Note that for XML namespace
     *   declarations (xmlns and xmlns:* attributes) an instance of
     *   DOMNameSpaceNode is returned instead of a DOMAttr object.
     * @since PHP 5, PHP 7
     **/
    public function getAttributeNodeNS($namespaceURI, $localName){}

    /**
     * Returns value of attribute
     *
     * Gets the value of the attribute in namespace {@link namespaceURI} with
     * local name {@link localName} for the current node.
     *
     * @param string $namespaceURI The namespace URI.
     * @param string $localName The local name.
     * @return string The value of the attribute, or an empty string if no
     *   attribute with the given {@link localName} and {@link namespaceURI}
     *   is found.
     * @since PHP 5, PHP 7
     **/
    public function getAttributeNS($namespaceURI, $localName){}

    /**
     * Gets elements by tagname
     *
     * This function returns a new instance of the class DOMNodeList of all
     * descendant elements with a given tag {@link name}, in the order in
     * which they are encountered in a preorder traversal of this element
     * tree.
     *
     * @param string $name The tag name. Use * to return all elements
     *   within the element tree.
     * @return DOMNodeList This function returns a new instance of the
     *   class DOMNodeList of all matched elements.
     * @since PHP 5, PHP 7
     **/
    public function getElementsByTagName($name){}

    /**
     * Get elements by namespaceURI and localName
     *
     * This function fetch all the descendant elements with a given {@link
     * localName} and {@link namespaceURI}.
     *
     * @param string $namespaceURI The namespace URI.
     * @param string $localName The local name. Use * to return all
     *   elements within the element tree.
     * @return DOMNodeList This function returns a new instance of the
     *   class DOMNodeList of all matched elements in the order in which they
     *   are encountered in a preorder traversal of this element tree.
     * @since PHP 5, PHP 7
     **/
    public function getElementsByTagNameNS($namespaceURI, $localName){}

    /**
     * Checks to see if attribute exists
     *
     * Indicates whether attribute named {@link name} exists as a member of
     * the element.
     *
     * @param string $name The attribute name.
     * @return bool
     * @since PHP 5, PHP 7
     **/
    public function hasAttribute($name){}

    /**
     * Checks to see if attribute exists
     *
     * Indicates whether attribute in namespace {@link namespaceURI} named
     * {@link localName} exists as a member of the element.
     *
     * @param string $namespaceURI The namespace URI.
     * @param string $localName The local name.
     * @return bool
     * @since PHP 5, PHP 7
     **/
    public function hasAttributeNS($namespaceURI, $localName){}

    /**
     * Removes attribute
     *
     * Removes attribute named {@link name} from the element.
     *
     * @param string $name The name of the attribute.
     * @return bool
     * @since PHP 5, PHP 7
     **/
    public function removeAttribute($name){}

    /**
     * Removes attribute
     *
     * Removes attribute {@link oldnode} from the element.
     *
     * @param DOMAttr $oldnode The attribute node.
     * @return bool
     * @since PHP 5, PHP 7
     **/
    public function removeAttributeNode($oldnode){}

    /**
     * Removes attribute
     *
     * Removes attribute {@link localName} in namespace {@link namespaceURI}
     * from the element.
     *
     * @param string $namespaceURI The namespace URI.
     * @param string $localName The local name.
     * @return bool
     * @since PHP 5, PHP 7
     **/
    public function removeAttributeNS($namespaceURI, $localName){}

    /**
     * Adds new attribute
     *
     * Sets an attribute with name {@link name} to the given value. If the
     * attribute does not exist, it will be created.
     *
     * @param string $name The name of the attribute.
     * @param string $value The value of the attribute.
     * @return DOMAttr The new DOMAttr or FALSE if an error occurred.
     * @since PHP 5, PHP 7
     **/
    public function setAttribute($name, $value){}

    /**
     * Adds new attribute node to element
     *
     * Adds new attribute node {@link attr} to element.
     *
     * @param DOMAttr $attr The attribute node.
     * @return DOMAttr Returns old node if the attribute has been replaced
     *   or NULL.
     * @since PHP 5, PHP 7
     **/
    public function setAttributeNode($attr){}

    /**
     * Adds new attribute node to element
     *
     * Adds new attribute node {@link attr} to element.
     *
     * @param DOMAttr $attr The attribute node.
     * @return DOMAttr Returns the old node if the attribute has been
     *   replaced.
     * @since PHP 5, PHP 7
     **/
    public function setAttributeNodeNS($attr){}

    /**
     * Adds new attribute
     *
     * Sets an attribute with namespace {@link namespaceURI} and name {@link
     * name} to the given value. If the attribute does not exist, it will be
     * created.
     *
     * @param string $namespaceURI The namespace URI.
     * @param string $qualifiedName The qualified name of the attribute, as
     *   prefix:tagname.
     * @param string $value The value of the attribute.
     * @return void
     * @since PHP 5, PHP 7
     **/
    public function setAttributeNS($namespaceURI, $qualifiedName, $value){}

    /**
     * Declares the attribute specified by name to be of type ID
     *
     * Declares the attribute {@link name} to be of type ID.
     *
     * @param string $name The name of the attribute.
     * @param bool $isId Set it to TRUE if you want {@link name} to be of
     *   type ID, FALSE otherwise.
     * @return void
     * @since PHP 5, PHP 7
     **/
    public function setIdAttribute($name, $isId){}

    /**
     * Declares the attribute specified by node to be of type ID
     *
     * Declares the attribute specified by {@link attr} to be of type ID.
     *
     * @param DOMAttr $attr The attribute node.
     * @param bool $isId Set it to TRUE if you want {@link name} to be of
     *   type ID, FALSE otherwise.
     * @return void
     * @since PHP 5, PHP 7
     **/
    public function setIdAttributeNode($attr, $isId){}

    /**
     * Declares the attribute specified by local name and namespace URI to be
     * of type ID
     *
     * Declares the attribute specified by {@link localName} and {@link
     * namespaceURI} to be of type ID.
     *
     * @param string $namespaceURI The namespace URI of the attribute.
     * @param string $localName The local name of the attribute, as
     *   prefix:tagname.
     * @param bool $isId Set it to TRUE if you want {@link name} to be of
     *   type ID, FALSE otherwise.
     * @return void
     * @since PHP 5, PHP 7
     **/
    public function setIdAttributeNS($namespaceURI, $localName, $isId){}

    /**
     * Creates a new DOMElement object
     *
     * Creates a new DOMElement object. This object is read only. It may be
     * appended to a document, but additional nodes may not be appended to
     * this node until the node is associated with a document. To create a
     * writeable node, use or .
     *
     * @param string $name The tag name of the element. When also passing
     *   in namespaceURI, the element name may take a prefix to be associated
     *   with the URI.
     * @param string $value The value of the element.
     * @param string $namespaceURI A namespace URI to create the element
     *   within a specific namespace.
     * @since PHP 5, PHP 7
     **/
    public function __construct($name, $value, $namespaceURI){}

}
/**
 * This interface represents a known entity, either parsed or unparsed,
 * in an XML document.
 **/
class DOMEntity extends DOMNode {
    /**
     * @var string
     **/
    public $actualEncoding;

    /**
     * An attribute specifying, as part of the text declaration, the encoding
     * of this entity, when it is an external parsed entity. This is NULL
     * otherwise.
     *
     * @var string
     **/
    public $encoding;

    /**
     * @var string
     **/
    public $notationName;

    /**
     * @var string
     **/
    public $publicId;

    /**
     * @var string
     **/
    public $systemId;

    /**
     * An attribute specifying, as part of the text declaration, the version
     * number of this entity, when it is an external parsed entity. This is
     * NULL otherwise.
     *
     * @var string
     **/
    public $version;

}
class DomEntityReference extends DOMNode {
    /**
     * Creates a new DOMEntityReference object
     *
     * Creates a new DOMEntityReference object.
     *
     * @param string $name The name of the entity reference.
     * @since PHP 5, PHP 7
     **/
    public function __construct($name){}

}
/**
 * DOM operations raise exceptions under particular circumstances, i.e.,
 * when an operation is impossible to perform for logical reasons. See
 * also .
 **/
class DOMException extends Exception {
    /**
     * An integer indicating the type of error generated
     *
     * @var int
     **/
    public $code;

}
/**
 * The DOMImplementation interface provides a number of methods for
 * performing operations that are independent of any particular instance
 * of the document object model.
 **/
class DOMImplementation {
    /**
     * Creates a DOMDocument object of the specified type with its document
     * element
     *
     * Creates a DOMDocument object of the specified type with its document
     * element.
     *
     * @param string $namespaceURI The namespace URI of the document
     *   element to create.
     * @param string $qualifiedName The qualified name of the document
     *   element to create.
     * @param DOMDocumentType $doctype The type of document to create or
     *   NULL.
     * @return DOMDocument A new DOMDocument object. If {@link
     *   namespaceURI}, {@link qualifiedName}, and {@link doctype} are null,
     *   the returned DOMDocument is empty with no document element
     * @since PHP 5, PHP 7
     **/
    public function createDocument($namespaceURI, $qualifiedName, $doctype){}

    /**
     * Creates an empty DOMDocumentType object
     *
     * Creates an empty DOMDocumentType object. Entity declarations and
     * notations are not made available. Entity reference expansions and
     * default attribute additions do not occur.
     *
     * @param string $qualifiedName The qualified name of the document type
     *   to create.
     * @param string $publicId The external subset public identifier.
     * @param string $systemId The external subset system identifier.
     * @return DOMDocumentType A new DOMDocumentType node with its
     *   ownerDocument set to NULL.
     * @since PHP 5, PHP 7
     **/
    public function createDocumentType($qualifiedName, $publicId, $systemId){}

    /**
     * Test if the DOM implementation implements a specific feature
     *
     * Test if the DOM implementation implements a specific {@link feature}.
     *
     * You can find a list of all features in the Conformance section of the
     * DOM specification.
     *
     * @param string $feature The feature to test.
     * @param string $version The version number of the {@link feature} to
     *   test. In level 2, this can be either 2.0 or 1.0.
     * @return bool
     * @since PHP 5, PHP 7
     **/
    public function hasFeature($feature, $version){}

    /**
     * Creates a new DOMImplementation object
     *
     * Creates a new DOMImplementation object.
     *
     * @since PHP 5, PHP 7
     **/
    function __construct(){}

}
class DomNamedNodeMap implements Traversable, Countable {
    /**
     * Get number of nodes in the map
     *
     * Gets the number of nodes in the map.
     *
     * @return int Returns the number of nodes in the map, which is
     *   identical to the length property.
     * @since PHP 7 >= 7.2.0
     **/
    public function count(){}

    /**
     * Retrieves a node specified by name
     *
     * Retrieves a node specified by its nodeName.
     *
     * @param string $name The nodeName of the node to retrieve.
     * @return DOMNode A node (of any type) with the specified nodeName, or
     *   NULL if no node is found.
     * @since PHP 5, PHP 7
     **/
    function getNamedItem($name){}

    /**
     * Retrieves a node specified by local name and namespace URI
     *
     * Retrieves a node specified by {@link localName} and {@link
     * namespaceURI}.
     *
     * @param string $namespaceURI The namespace URI of the node to
     *   retrieve.
     * @param string $localName The local name of the node to retrieve.
     * @return DOMNode A node (of any type) with the specified local name
     *   and namespace URI, or NULL if no node is found.
     * @since PHP 5, PHP 7
     **/
    function getNamedItemNS($namespaceURI, $localName){}

    /**
     * Retrieves a node specified by index
     *
     * Retrieves a node specified by {@link index} within the DOMNamedNodeMap
     * object.
     *
     * @param int $index Index into this map.
     * @return DOMNode The node at the {@link index}th position in the map,
     *   or NULL if that is not a valid index (greater than or equal to the
     *   number of nodes in this map).
     * @since PHP 5, PHP 7
     **/
    function item($index){}

}
class DOMNode {
    /**
     * Adds new child at the end of the children
     *
     * This function appends a child to an existing list of children or
     * creates a new list of children. The child can be created with e.g.
     * DOMDocument::createElement, DOMDocument::createTextNode etc. or simply
     * by using any other node.
     *
     * @param DOMNode $newnode The appended child.
     * @return DOMNode The node added.
     * @since PHP 5, PHP 7
     **/
    public function appendChild($newnode){}

    /**
     * Canonicalize nodes to a string
     *
     * @param bool $exclusive Enable exclusive parsing of only the nodes
     *   matched by the provided xpath or namespace prefixes.
     * @param bool $with_comments Retain comments in output.
     * @param array $xpath An array of xpaths to filter the nodes by.
     * @param array $ns_prefixes An array of namespace prefixes to filter
     *   the nodes by.
     * @return string Returns canonicalized nodes as a string
     * @since PHP 5 >= 5.2.0, PHP 7
     **/
    public function C14N($exclusive, $with_comments, $xpath, $ns_prefixes){}

    /**
     * Canonicalize nodes to a file
     *
     * @param string $uri Path to write the output to.
     * @param bool $exclusive Enable exclusive parsing of only the nodes
     *   matched by the provided xpath or namespace prefixes.
     * @param bool $with_comments Retain comments in output.
     * @param array $xpath An array of xpaths to filter the nodes by.
     * @param array $ns_prefixes An array of namespace prefixes to filter
     *   the nodes by.
     * @return int Number of bytes written
     * @since PHP 5 >= 5.2.0, PHP 7
     **/
    public function C14NFile($uri, $exclusive, $with_comments, $xpath, $ns_prefixes){}

    /**
     * Clones a node
     *
     * Creates a copy of the node.
     *
     * @param bool $deep Indicates whether to copy all descendant nodes.
     *   This parameter is defaulted to FALSE.
     * @return DOMNode The cloned node.
     * @since PHP 5, PHP 7
     **/
    public function cloneNode($deep){}

    /**
     * Get line number for a node
     *
     * Gets line number for where the node is defined.
     *
     * @return int Always returns the line number where the node was
     *   defined in.
     * @since PHP 5 >= 5.3.0, PHP 7
     **/
    public function getLineNo(){}

    /**
     * Get an XPath for a node
     *
     * Gets an XPath location path for the node.
     *
     * @return string Returns a string containing the XPath, or NULL in
     *   case of an error.
     * @since PHP 5 >= 5.2.0, PHP 7
     **/
    public function getNodePath(){}

    /**
     * Checks if node has attributes
     *
     * This method checks if the node has attributes. The tested node has to
     * be an XML_ELEMENT_NODE.
     *
     * @return bool
     * @since PHP 5, PHP 7
     **/
    public function hasAttributes(){}

    /**
     * Checks if node has children
     *
     * This function checks if the node has children.
     *
     * @return bool
     * @since PHP 5, PHP 7
     **/
    public function hasChildNodes(){}

    /**
     * Adds a new child before a reference node
     *
     * This function inserts a new node right before the reference node. If
     * you plan to do further modifications on the appended child you must
     * use the returned node.
     *
     * @param DOMNode $newnode The new node.
     * @param DOMNode $refnode The reference node. If not supplied, {@link
     *   newnode} is appended to the children.
     * @return DOMNode The inserted node.
     * @since PHP 5, PHP 7
     **/
    public function insertBefore($newnode, $refnode){}

    /**
     * Checks if the specified namespaceURI is the default namespace or not
     *
     * Tells whether {@link namespaceURI} is the default namespace.
     *
     * @param string $namespaceURI The namespace URI to look for.
     * @return bool Return TRUE if {@link namespaceURI} is the default
     *   namespace, FALSE otherwise.
     * @since PHP 5, PHP 7
     **/
    public function isDefaultNamespace($namespaceURI){}

    /**
     * Indicates if two nodes are the same node
     *
     * This function indicates if two nodes are the same node. The comparison
     * is not based on content
     *
     * @param DOMNode $node The compared node.
     * @return bool
     * @since PHP 5, PHP 7
     **/
    public function isSameNode($node){}

    /**
     * Checks if feature is supported for specified version
     *
     * Checks if the asked {@link feature} is supported for the specified
     * {@link version}.
     *
     * @param string $feature The feature to test. See the example of
     *   DOMImplementation::hasFeature for a list of features.
     * @param string $version The version number of the {@link feature} to
     *   test.
     * @return bool
     * @since PHP 5, PHP 7
     **/
    public function isSupported($feature, $version){}

    /**
     * Gets the namespace URI of the node based on the prefix
     *
     * Gets the namespace URI of the node based on the {@link prefix}.
     *
     * @param string $prefix The prefix of the namespace.
     * @return string The namespace URI of the node.
     * @since PHP 5, PHP 7
     **/
    public function lookupNamespaceUri($prefix){}

    /**
     * Gets the namespace prefix of the node based on the namespace URI
     *
     * Gets the namespace prefix of the node based on the namespace URI.
     *
     * @param string $namespaceURI The namespace URI.
     * @return string The prefix of the namespace.
     * @since PHP 5, PHP 7
     **/
    public function lookupPrefix($namespaceURI){}

    /**
     * Normalizes the node
     *
     * Remove empty text nodes and merge adjacent text nodes in this node and
     * all its children.
     *
     * @return void
     * @since PHP 5, PHP 7
     **/
    public function normalize(){}

    /**
     * Removes child from list of children
     *
     * This functions removes a child from a list of children.
     *
     * @param DOMNode $oldnode The removed child.
     * @return DOMNode If the child could be removed the function returns
     *   the old child.
     * @since PHP 5, PHP 7
     **/
    public function removeChild($oldnode){}

    /**
     * Replaces a child
     *
     * This function replaces the child {@link oldnode} with the passed new
     * node. If the {@link newnode} is already a child it will not be added a
     * second time. If the replacement succeeds the old node is returned.
     *
     * @param DOMNode $newnode The new node. It must be a member of the
     *   target document, i.e. created by one of the DOMDocument->createXXX()
     *   methods or imported in the document by .
     * @param DOMNode $oldnode The old node.
     * @return DOMNode The old node or FALSE if an error occur.
     * @since PHP 5, PHP 7
     **/
    public function replaceChild($newnode, $oldnode){}

}
/**
 * 7.2.0 The Countable interface is implemented and returns the value of
 * the length property.
 **/
class DomNodeList implements Traversable, Countable {
    /**
     * Get number of nodes in the list
     *
     * Gets the number of nodes in the list.
     *
     * @return int Returns the number of nodes in the list, which is
     *   identical to the length property.
     * @since PHP 7 >= 7.2.0
     **/
    public function count(){}

    /**
     * Retrieves a node specified by index
     *
     * Retrieves a node specified by {@link index} within the DOMNodeList
     * object.
     *
     * @param int $index Index of the node into the collection.
     * @return DOMNode The node at the {@link index}th position in the
     *   DOMNodeList, or NULL if that is not a valid index.
     * @since PHP 5, PHP 7
     **/
    function item($index){}

}
class DOMNotation extends DOMNode {
}
class DomProcessingInstruction extends DOMNode {
    /**
     * Creates a new object
     *
     * Creates a new DOMProcessingInstruction object. This object is read
     * only. It may be appended to a document, but additional nodes may not
     * be appended to this node until the node is associated with a document.
     * To create a writeable node, use .
     *
     * @param string $name The tag name of the processing instruction.
     * @param string $value The value of the processing instruction.
     * @since PHP 5, PHP 7
     **/
    public function __construct($name, $value){}

}
/**
 * The DOMText class inherits from DOMCharacterData and represents the
 * textual content of a DOMElement or DOMAttr.
 **/
class DOMText extends DOMCharacterData {
    /**
     * @var string
     **/
    public $wholeText;

    /**
     * Returns whether this text node contains whitespace in element content
     *
     * @return bool
     **/
    public function isElementContentWhitespace(){}

    /**
     * Indicates whether this text node contains whitespace
     *
     * Indicates whether this text node contains only whitespace or it is
     * empty. The text node is determined to contain whitespace in element
     * content during the load of the document.
     *
     * @return bool Returns TRUE if node contains zero or more whitespace
     *   characters and nothing else. Returns FALSE otherwise.
     * @since PHP 5, PHP 7
     **/
    public function isWhitespaceInElementContent(){}

    /**
     * Breaks this node into two nodes at the specified offset
     *
     * Breaks this node into two nodes at the specified {@link offset},
     * keeping both in the tree as siblings.
     *
     * After being split, this node will contain all the content up to the
     * {@link offset}. If the original node had a parent node, the new node
     * is inserted as the next sibling of the original node. When the {@link
     * offset} is equal to the length of this node, the new node has no data.
     *
     * @param int $offset The offset at which to split, starting from 0.
     * @return DOMText The new node of the same type, which contains all
     *   the content at and after the {@link offset}.
     * @since PHP 5, PHP 7
     **/
    public function splitText($offset){}

}
/**
 * Supports XPath 1.0
 **/
class DomXPath {
    /**
     * @var DOMDocument
     **/
    public $document;

    /**
     * Evaluates the given XPath expression and returns a typed result if
     * possible
     *
     * Executes the given XPath {@link expression} and returns a typed result
     * if possible.
     *
     * @param string $expression The XPath expression to execute.
     * @param DOMNode $contextnode The optional {@link contextnode} can be
     *   specified for doing relative XPath queries. By default, the queries
     *   are relative to the root element.
     * @param bool $registerNodeNS The optional {@link registerNodeNS} can
     *   be specified to disable automatic registration of the context node.
     * @return mixed Returns a typed result if possible or a DOMNodeList
     *   containing all nodes matching the given XPath {@link expression}.
     * @since PHP 5 >= 5.1.0, PHP 7
     **/
    public function evaluate($expression, $contextnode, $registerNodeNS){}

    /**
     * Evaluates the given XPath expression
     *
     * Executes the given XPath {@link expression}.
     *
     * @param string $expression The XPath expression to execute.
     * @param DOMNode $contextnode The optional {@link contextnode} can be
     *   specified for doing relative XPath queries. By default, the queries
     *   are relative to the root element.
     * @param bool $registerNodeNS The optional {@link registerNodeNS} can
     *   be specified to disable automatic registration of the context node.
     * @return DOMNodeList Returns a DOMNodeList containing all nodes
     *   matching the given XPath {@link expression}. Any expression which
     *   does not return nodes will return an empty DOMNodeList.
     * @since PHP 5, PHP 7
     **/
    public function query($expression, $contextnode, $registerNodeNS){}

    /**
     * Registers the namespace with the object
     *
     * Registers the {@link namespaceURI} and {@link prefix} with the
     * DOMXPath object.
     *
     * @param string $prefix The prefix.
     * @param string $namespaceURI The URI of the namespace.
     * @return bool
     * @since PHP 5, PHP 7
     **/
    public function registerNamespace($prefix, $namespaceURI){}

    /**
     * Register PHP functions as XPath functions
     *
     * This method enables the ability to use PHP functions within XPath
     * expressions.
     *
     * @param mixed $restrict Use this parameter to only allow certain
     *   functions to be called from XPath. This parameter can be either a
     *   string (a function name) or an array of function names.
     * @return void
     * @since PHP 5 >= 5.3.0, PHP 7
     **/
    public function registerPhpFunctions($restrict){}

    /**
     * Creates a new object
     *
     * Creates a new DOMXPath object.
     *
     * @param DOMDocument $doc The DOMDocument associated with the
     *   DOMXPath.
     * @since PHP 5, PHP 7
     **/
    public function __construct($doc){}

}
/**
 * The DOTNET class allows you to instantiate a class from a .Net
 * assembly and call its methods and access its properties, if the class
 * and the methods and properties are visible to COM.
 **/
class DOTNET extends VARIANT {
}
namespace Ds {
interface Collection extends Traversable, Countable, JsonSerializable {
    /**
     * Removes all values
     *
     * Removes all values from the collection.
     *
     * @return void
     **/
    public function clear();

    /**
     * Returns a shallow copy of the collection
     *
     * @return Ds\Collection Returns a shallow copy of the collection.
     **/
    public function copy();

    /**
     * Returns whether the collection is empty
     *
     * @return bool Returns TRUE if the collection is empty, FALSE
     *   otherwise.
     **/
    public function isEmpty();

    /**
     * Converts the collection to an
     *
     * Converts the collection to an .
     *
     * @return array An containing all the values in the same order as the
     *   collection.
     **/
    public function toArray();

}
}
namespace Ds {
class Deque implements Ds\Sequence {
    /**
     * Allocates enough memory for a required capacity
     *
     * Ensures that enough memory is allocated for a required capacity. This
     * removes the need to reallocate the internal as values are added.
     *
     * @param int $capacity The number of values for which capacity should
     *   be allocated.
     * @return void
     **/
    public function allocate($capacity){}

    /**
     * Updates all values by applying a callback function to each value
     *
     * Updates all values by applying a {@link callback} function to each
     * value in the deque.
     *
     * @param callable $callback mixed callback mixed{@link value} A
     *   callable to apply to each value in the deque. The callback should
     *   return what the value should be replaced by.
     * @return void
     **/
    public function apply($callback){}

    /**
     * Returns the current capacity
     *
     * @return int The current capacity.
     **/
    public function capacity(){}

    /**
     * Removes all values from the deque
     *
     * @return void
     **/
    public function clear(){}

    /**
     * Determines if the deque contains given values
     *
     * Determines if the deque contains all values.
     *
     * @param mixed ...$values Values to check.
     * @return bool FALSE if any of the provided {@link values} are not in
     *   the deque, TRUE otherwise.
     **/
    public function contains(...$values){}

    /**
     * Returns a shallow copy of the deque
     *
     * @return Ds\Deque A shallow copy of the deque.
     **/
    public function copy(){}

    /**
     * Creates a new deque using a to determine which values to include
     *
     * Creates a new deque using a callable to determine which values to
     * include.
     *
     * @param callable $callback bool callback mixed{@link value} Optional
     *   callable which returns TRUE if the value should be included, FALSE
     *   otherwise. If a callback is not provided, only values which are TRUE
     *   (see converting to boolean) will be included.
     * @return Ds\Deque A new deque containing all the values for which
     *   either the {@link callback} returned TRUE, or all values that
     *   convert to TRUE if a {@link callback} was not provided.
     **/
    public function filter($callback){}

    /**
     * Attempts to find a value's index
     *
     * Returns the index of the {@link value}, or FALSE if not found.
     *
     * @param mixed $value The value to find.
     * @return mixed The index of the value, or FALSE if not found.
     **/
    public function find($value){}

    /**
     * Returns the first value in the deque
     *
     * @return mixed The first value in the deque.
     **/
    public function first(){}

    /**
     * Returns the value at a given index
     *
     * @param int $index The index to access, starting at 0.
     * @return mixed The value at the requested index.
     **/
    public function get($index){}

    /**
     * Inserts values at a given index
     *
     * Inserts values into the deque at a given index.
     *
     * @param int $index The index at which to insert. 0 <= index <= count
     * @param mixed ...$values The value or values to insert.
     * @return void
     **/
    public function insert($index, ...$values){}

    /**
     * Returns whether the deque is empty
     *
     * @return bool Returns TRUE if the deque is empty, FALSE otherwise.
     **/
    public function isEmpty(){}

    /**
     * Joins all values together as a string
     *
     * Joins all values together as a string using an optional separator
     * between each value.
     *
     * @param string $glue An optional string to separate each value.
     * @return string All values of the deque joined together as a string.
     **/
    public function join($glue){}

    /**
     * Returns the last value
     *
     * Returns the last value in the deque.
     *
     * @return mixed The last value in the deque.
     **/
    public function last(){}

    /**
     * Returns the result of applying a callback to each value
     *
     * Returns the result of applying a {@link callback} function to each
     * value in the deque.
     *
     * @param callable $callback mixed callback mixed{@link value} A
     *   callable to apply to each value in the deque. The callable should
     *   return what the new value will be in the new deque.
     * @return Ds\Deque The result of applying a {@link callback} to each
     *   value in the deque.
     **/
    public function map($callback){}

    /**
     * Returns the result of adding all given values to the deque
     *
     * @param mixed $values A traversable object or an .
     * @return Ds\Deque The result of adding all given values to the deque,
     *   effectively the same as adding the values to a copy, then returning
     *   that copy.
     **/
    public function merge($values){}

    /**
     * Removes and returns the last value
     *
     * @return mixed The removed last value.
     **/
    public function pop(){}

    /**
     * Adds values to the end of the deque
     *
     * @param mixed ...$values The values to add.
     * @return void
     **/
    public function push(...$values){}

    /**
     * Reduces the deque to a single value using a callback function
     *
     * @param callable $callback
     * @param mixed $initial The return value of the previous callback, or
     *   {@link initial} if it's the first iteration.
     * @return mixed The return value of the final callback.
     **/
    public function reduce($callback, $initial){}

    /**
     * Removes and returns a value by index
     *
     * @param int $index The index of the value to remove.
     * @return mixed The value that was removed.
     **/
    public function remove($index){}

    /**
     * Reverses the deque in-place
     *
     * Reverses the deque in-place.
     *
     * @return void
     **/
    public function reverse(){}

    /**
     * Returns a reversed copy
     *
     * Returns a reversed copy of the deque.
     *
     * @return Ds\Deque A reversed copy of the deque.
     *   
     *   The current instance is not affected.
     **/
    public function reversed(){}

    /**
     * Rotates the deque by a given number of rotations
     *
     * Rotates the deque by a given number of rotations, which is equivalent
     * to successively calling $deque->push($deque->shift()) if the number of
     * rotations is positive, or $deque->unshift($deque->pop()) if negative.
     *
     * @param int $rotations The number of times the deque should be
     *   rotated.
     * @return void . The deque of the current instance will be rotated.
     **/
    public function rotate($rotations){}

    /**
     * Updates a value at a given index
     *
     * @param int $index The index of the value to update.
     * @param mixed $value The new value.
     * @return void
     **/
    public function set($index, $value){}

    /**
     * Removes and returns the first value
     *
     * @return mixed The first value, which was removed.
     **/
    public function shift(){}

    /**
     * Returns a sub-deque of a given range
     *
     * Creates a sub-deque of a given range.
     *
     * @param int $index The index at which the sub-deque starts. If
     *   positive, the deque will start at that index in the deque. If
     *   negative, the deque will start that far from the end.
     * @param int $length If a length is given and is positive, the
     *   resulting deque will have up to that many values in it.
     *   
     *   If the length results in an overflow, only values up to the end of
     *   the deque will be included.
     *   
     *   If a length is given and is negative, the deque will stop that many
     *   values from the end.
     *   
     *   If a length is not provided, the resulting deque will contain all
     *   values between the index and the end of the deque.
     * @return Ds\Deque A sub-deque of the given range.
     **/
    public function slice($index, $length){}

    /**
     * Sorts the deque in-place
     *
     * Sorts the deque in-place, using an optional {@link comparator}
     * function.
     *
     * @param callable $comparator
     * @return void
     **/
    public function sort($comparator){}

    /**
     * Returns a sorted copy
     *
     * Returns a sorted copy, using an optional {@link comparator} function.
     *
     * @param callable $comparator
     * @return Ds\Deque Returns a sorted copy of the deque.
     **/
    public function sorted($comparator){}

    /**
     * Returns the sum of all values in the deque
     *
     * @return number The sum of all the values in the deque as either a
     *   float or int depending on the values in the deque.
     **/
    public function sum(){}

    /**
     * Converts the deque to an
     *
     * Converts the deque to an .
     *
     * @return array An containing all the values in the same order as the
     *   deque.
     **/
    public function toArray(){}

    /**
     * Adds values to the front of the deque
     *
     * Adds values to the front of the deque, moving all the current values
     * forward to make room for the new values.
     *
     * @param mixed $values The values to add to the front of the deque.
     *   Multiple values will be added in the same order that they are
     *   passed.
     * @return void
     **/
    public function unshift($values){}

}
}
namespace Ds {
interface Hashable {
    /**
     * Determines whether an object is equal to the current instance
     *
     * Determines whether another object is equal to the current instance.
     *
     * This method allows objects to be used as keys in structures such as
     * Ds\Map and Ds\Set, or any other lookup structure that honors this
     * interface.
     *
     * @param object $obj The object to compare the current instance to,
     *   which is always an instance of the same class.
     * @return bool TRUE if equal, FALSE otherwise.
     **/
    public function equals($obj);

    /**
     * Returns a scalar value to be used as a hash value
     *
     * Returns a scalar value to be used as the hash value of the objects.
     *
     * While the hash value does not define equality, all objects that are
     * equal according to {@link Ds\Hashable::equals} must have the same hash
     * value. Hash values of equal objects don't have to be unique, for
     * example you could just return TRUE for all objects and nothing would
     * break - the only implication would be that hash tables then turn into
     * linked lists because all your objects will be hashed to the same
     * bucket. It's therefore very important that you pick a good hash value,
     * such as an ID or email address.
     *
     * This method allows objects to be used as keys in structures such as
     * Ds\Map and Ds\Set, or any other lookup structure that honors this
     * interface.
     *
     * @return mixed A scalar value to be used as this object's hash value.
     **/
    public function hash();

}
}
namespace Ds {
class Map implements Ds\Collection {
    /**
     * Allocates enough memory for a required capacity
     *
     * @param int $capacity The number of values for which capacity should
     *   be allocated.
     * @return void
     **/
    public function allocate($capacity){}

    /**
     * Updates all values by applying a callback function to each value
     *
     * Updates all values by applying a {@link callback} function to each
     * value in the map.
     *
     * @param callable $callback mixed callback mixed{@link key}
     *   mixed{@link value} A callable to apply to each value in the map. The
     *   callback should return what the value should be replaced by.
     * @return void
     **/
    public function apply($callback){}

    /**
     * Returns the current capacity
     *
     * @return int The current capacity.
     **/
    public function capacity(){}

    /**
     * Removes all values
     *
     * Removes all values from the map.
     *
     * @return void
     **/
    public function clear(){}

    /**
     * Returns a shallow copy of the map
     *
     * @return Ds\Map Returns a shallow copy of the map.
     **/
    public function copy(){}

    /**
     * Creates a new map using keys that aren't in another map
     *
     * Returns the result of removing all keys from the current instance that
     * are present in a given {@link map}.
     *
     * A \ B = {x ∈ A | x ∉ B}
     *
     * @param Ds\Map $map The map containing the keys to exclude in the
     *   resulting map.
     * @return Ds\Map The result of removing all keys from the current
     *   instance that are present in a given {@link map}.
     **/
    public function diff($map){}

    /**
     * Creates a new map using a to determine which pairs to include
     *
     * Creates a new map using a callable to determine which pairs to
     * include.
     *
     * @param callable $callback bool callback mixed{@link key} mixed{@link
     *   value} Optional callable which returns TRUE if the pair should be
     *   included, FALSE otherwise. If a callback is not provided, only
     *   values which are TRUE (see converting to boolean) will be included.
     * @return Ds\Map A new map containing all the pairs for which either
     *   the {@link callback} returned TRUE, or all values that convert to
     *   TRUE if a {@link callback} was not provided.
     **/
    public function filter($callback){}

    /**
     * Returns the first pair in the map
     *
     * @return Ds\Pair The first pair in the map.
     **/
    public function first(){}

    /**
     * Returns the value for a given key
     *
     * Returns the value for a given key, or an optional default value if the
     * key could not be found.
     *
     * @param mixed $key The key to look up.
     * @param mixed $default The optional default value, returned if the
     *   key could not be found.
     * @return mixed The value mapped to the given {@link key}, or the
     *   {@link default} value if provided and the key could not be found in
     *   the map.
     **/
    public function get($key, $default){}

    /**
     * Determines whether the map contains a given key
     *
     * @param mixed $key The key to look for.
     * @return bool Returns TRUE if the key could found, FALSE otherwise.
     **/
    public function hasKey($key){}

    /**
     * Determines whether the map contains a given value
     *
     * @param mixed $value The value to look for.
     * @return bool Returns TRUE if the value could found, FALSE otherwise.
     **/
    public function hasValue($value){}

    /**
     * Creates a new map by intersecting keys with another map
     *
     * Creates a new map containing the pairs of the current instance whose
     * keys are also present in the given {@link map}.
     *
     * In other words, returns a copy of the current instance with all keys
     * removed that are not also in the other {@link map}.
     *
     * A ∩ B = {x : x ∈ A ∧ x ∈ B}
     *
     * @param Ds\Map $map The other map, containing the keys to intersect
     *   with.
     * @return Ds\Map The key intersection of the current instance and
     *   another {@link map}.
     **/
    public function intersect($map){}

    /**
     * Returns whether the map is empty
     *
     * @return bool Returns TRUE if the map is empty, FALSE otherwise.
     **/
    public function isEmpty(){}

    /**
     * Returns a set of the map's keys
     *
     * Returns a set containing all the keys of the map, in the same order.
     *
     * @return Ds\Set A Ds\Set containing all the keys of the map.
     **/
    public function keys(){}

    /**
     * Sorts the map in-place by key
     *
     * Sorts the map in-place by key, using an optional {@link comparator}
     * function.
     *
     * @param callable $comparator
     * @return void
     **/
    public function ksort($comparator){}

    /**
     * Returns a copy, sorted by key
     *
     * Returns a copy sorted by key, using an optional {@link comparator}
     * function.
     *
     * @param callable $comparator
     * @return Ds\Map Returns a copy of the map, sorted by key.
     **/
    public function ksorted($comparator){}

    /**
     * Returns the last pair of the map
     *
     * @return Ds\Pair The last pair of the map.
     **/
    public function last(){}

    /**
     * Returns the result of applying a callback to each value
     *
     * Returns the result of applying a {@link callback} function to each
     * value of the map.
     *
     * @param callable $callback mixed callback mixed{@link key}
     *   mixed{@link value} A callable to apply to each value in the map. The
     *   callable should return what the key will be mapped to in the
     *   resulting map.
     * @return Ds\Map The result of applying a {@link callback} to each
     *   value in the map.
     **/
    public function map($callback){}

    /**
     * Returns the result of adding all given associations
     *
     * Returns the result of associating all keys of a given traversable
     * object or with their corresponding values, combined with the current
     * instance.
     *
     * @param mixed $values A traversable object or an .
     * @return Ds\Map The result of associating all keys of a given
     *   traversable object or with their corresponding values, combined with
     *   the current instance.
     **/
    public function merge($values){}

    /**
     * Returns a sequence containing all the pairs of the map
     *
     * Returns a Ds\Sequence containing all the pairs of the map.
     *
     * @return Ds\Sequence Ds\Sequence containing all the pairs of the map.
     **/
    public function pairs(){}

    /**
     * Associates a key with a value
     *
     * Associates a {@link key} with a {@link value}, overwriting a previous
     * association if one exists.
     *
     * @param mixed $key The key to associate the value with.
     * @param mixed $value The value to be associated with the key.
     * @return void
     **/
    public function put($key, $value){}

    /**
     * Associates all key-value pairs of a traversable object or array
     *
     * Associates all key-value {@link pairs} of a traversable object or .
     *
     * @param mixed $pairs traversable object or .
     * @return void
     **/
    public function putAll($pairs){}

    /**
     * Reduces the map to a single value using a callback function
     *
     * @param callable $callback
     * @param mixed $initial The return value of the previous callback, or
     *   {@link initial} if it's the first iteration.
     * @return mixed The return value of the final callback.
     **/
    public function reduce($callback, $initial){}

    /**
     * Removes and returns a value by key
     *
     * Removes and returns a value by key, or return an optional default
     * value if the key could not be found.
     *
     * @param mixed $key The key to remove.
     * @param mixed $default The optional default value, returned if the
     *   key could not be found.
     * @return mixed The value that was removed, or the {@link default}
     *   value if provided and the {@link key} could not be found in the map.
     **/
    public function remove($key, $default){}

    /**
     * Reverses the map in-place
     *
     * Reverses the map in-place.
     *
     * @return void
     **/
    public function reverse(){}

    /**
     * Returns a reversed copy
     *
     * Returns a reversed copy of the map.
     *
     * @return Ds\Map A reversed copy of the map.
     *   
     *   The current instance is not affected.
     **/
    public function reversed(){}

    /**
     * Returns the pair at a given positional index
     *
     * Returns the pair at a given zero-based {@link position}.
     *
     * @param int $position The zero-based positional index to return.
     * @return Ds\Pair Returns the Ds\Pair at the given {@link position}.
     **/
    public function skip($position){}

    /**
     * Returns a subset of the map defined by a starting index and length
     *
     * Returns a subset of the map defined by a starting {@link index} and
     * {@link length}.
     *
     * @param int $index The index at which the range starts. If positive,
     *   the range will start at that index in the map. If negative, the
     *   range will start that far from the end.
     * @param int $length If a length is given and is positive, the
     *   resulting map will have up to that many pairs in it.
     *   
     *   If a length is given and is negative, the range will stop that many
     *   pairs from the end.
     *   
     *   If the length results in an overflow, only pairs up to the end of
     *   the map will be included.
     *   
     *   If a length is not provided, the resulting map will contain all
     *   pairs between the index and the end of the map.
     * @return Ds\Map A subset of the map defined by a starting index and
     *   length.
     **/
    public function slice($index, $length){}

    /**
     * Sorts the map in-place by value
     *
     * Sorts the map in-place by value, using an optional {@link comparator}
     * function.
     *
     * @param callable $comparator
     * @return void
     **/
    public function sort($comparator){}

    /**
     * Returns a copy, sorted by value
     *
     * Returns a copy, sorted by value using an optional {@link comparator}
     * function.
     *
     * @param callable $comparator
     * @return Ds\Map Returns a copy of the map, sorted by value.
     **/
    public function sorted($comparator){}

    /**
     * Returns the sum of all values in the map
     *
     * @return number The sum of all the values in the map as either a
     *   float or int depending on the values in the map.
     **/
    public function sum(){}

    /**
     * Converts the map to an
     *
     * Converts the map to an .
     *
     * @return array An containing all the values in the same order as the
     *   map.
     **/
    public function toArray(){}

    /**
     * Creates a new map using values from the current instance and another
     * map
     *
     * Creates a new map that contains the pairs of the current instance as
     * well as the pairs of another {@link map}.
     *
     * A ∪ B = {x: x ∈ A ∨ x ∈ B}
     *
     * @param Ds\Map $map The other map, to combine with the current
     *   instance.
     * @return Ds\Map A new map containing all the pairs of the current
     *   instance as well as another {@link map}.
     **/
    public function union($map){}

    /**
     * Returns a sequence of the map's values
     *
     * Returns a sequence containing all the values of the map, in the same
     * order.
     *
     * @return Ds\Sequence A Ds\Sequence containing all the values of the
     *   map.
     **/
    public function values(){}

    /**
     * Creates a new map using keys of either the current instance or of
     * another map, but not of both
     *
     * Creates a new map containing keys of the current instance as well as
     * another {@link map}, but not of both.
     *
     * A ⊖ B = {x : x ∈ (A \ B) ∪ (B \ A)}
     *
     * @param Ds\Map $map The other map.
     * @return Ds\Map A new map containing keys in the current instance as
     *   well as another {@link map}, but not in both.
     **/
    public function xor($map){}

}
}
namespace Ds {
class Pair implements JsonSerializable {
    /**
     * Removes all values
     *
     * Removes all values from the pair.
     *
     * @return void
     **/
    public function clear(){}

    /**
     * Returns a shallow copy of the pair
     *
     * @return Ds\Pair Returns a shallow copy of the pair.
     **/
    public function copy(){}

    /**
     * Returns whether the pair is empty
     *
     * @return bool Returns TRUE if the pair is empty, FALSE otherwise.
     **/
    public function isEmpty(){}

    /**
     * Converts the pair to an
     *
     * Converts the pair to an .
     *
     * @return array An containing all the values in the same order as the
     *   pair.
     **/
    public function toArray(){}

}
}
namespace Ds {
class PriorityQueue implements Ds\Collection {
    /**
     * Allocates enough memory for a required capacity
     *
     * Ensures that enough memory is allocated for a required capacity. This
     * removes the need to reallocate the internal as values are added.
     *
     * @param int $capacity The number of values for which capacity should
     *   be allocated.
     * @return void
     **/
    public function allocate($capacity){}

    /**
     * Returns the current capacity
     *
     * @return int The current capacity.
     **/
    public function capacity(){}

    /**
     * Removes all values
     *
     * Removes all values from the queue.
     *
     * @return void
     **/
    public function clear(){}

    /**
     * Returns a shallow copy of the queue
     *
     * @return Ds\PriorityQueue Returns a shallow copy of the queue.
     **/
    public function copy(){}

    /**
     * Returns whether the queue is empty
     *
     * @return bool Returns TRUE if the queue is empty, FALSE otherwise.
     **/
    public function isEmpty(){}

    /**
     * Returns the value at the front of the queue
     *
     * Returns the value at the front of the queue, but does not remove it.
     *
     * @return mixed The value at the front of the queue.
     **/
    public function peek(){}

    /**
     * Removes and returns the value with the highest priority
     *
     * Removes and returns the value at the front of the queue, ie. the value
     * with the highest priority.
     *
     * @return mixed The removed value which was at the front of the queue.
     **/
    public function pop(){}

    /**
     * Pushes values into the queue
     *
     * Pushes a {@link value} with a given {@link priority} into the queue.
     *
     * @param mixed $value The value to push into the queue.
     * @param int $priority The priority associated with the value.
     * @return void
     **/
    public function push($value, $priority){}

    /**
     * Converts the queue to an
     *
     * Converts the queue to an .
     *
     * @return array An containing all the values in the same order as the
     *   queue.
     **/
    public function toArray(){}

}
}
namespace Ds {
class Queue implements Ds\Collection {
    /**
     * Allocates enough memory for a required capacity
     *
     * Ensures that enough memory is allocated for a required capacity. This
     * removes the need to reallocate the internal as values are added.
     *
     * @param int $capacity The number of values for which capacity should
     *   be allocated.
     * @return void
     **/
    public function allocate($capacity){}

    /**
     * Returns the current capacity
     *
     * @return int The current capacity.
     **/
    public function capacity(){}

    /**
     * Removes all values
     *
     * Removes all values from the queue.
     *
     * @return void
     **/
    public function clear(){}

    /**
     * Returns a shallow copy of the queue
     *
     * @return Ds\Queue Returns a shallow copy of the queue.
     **/
    public function copy(){}

    /**
     * Returns whether the queue is empty
     *
     * @return bool Returns TRUE if the queue is empty, FALSE otherwise.
     **/
    public function isEmpty(){}

    /**
     * Returns the value at the front of the queue
     *
     * Returns the value at the front of the queue, but does not remove it.
     *
     * @return mixed The value at the front of the queue.
     **/
    public function peek(){}

    /**
     * Removes and returns the value at the front of the queue
     *
     * @return mixed The removed value which was at the front of the queue.
     **/
    public function pop(){}

    /**
     * Pushes values into the queue
     *
     * Pushes {@link values} into the queue.
     *
     * @param mixed ...$values The values to push into the queue.
     * @return void
     **/
    public function push(...$values){}

    /**
     * Converts the queue to an
     *
     * Converts the queue to an .
     *
     * @return array An containing all the values in the same order as the
     *   queue.
     **/
    public function toArray(){}

}
}
namespace Ds {
interface Sequence extends Ds\Collection {
    /**
     * Allocates enough memory for a required capacity
     *
     * Ensures that enough memory is allocated for a required capacity. This
     * removes the need to reallocate the internal as values are added.
     *
     * @param int $capacity The number of values for which capacity should
     *   be allocated.
     * @return void
     **/
    public function allocate($capacity);

    /**
     * Updates all values by applying a callback function to each value
     *
     * Updates all values by applying a {@link callback} function to each
     * value in the sequence.
     *
     * @param callable $callback mixed callback mixed{@link value} A
     *   callable to apply to each value in the sequence. The callback should
     *   return what the value should be replaced by.
     * @return void
     **/
    public function apply($callback);

    /**
     * Returns the current capacity
     *
     * @return int The current capacity.
     **/
    public function capacity();

    /**
     * Determines if the sequence contains given values
     *
     * Determines if the sequence contains all values.
     *
     * @param mixed ...$values Values to check.
     * @return bool FALSE if any of the provided {@link values} are not in
     *   the sequence, TRUE otherwise.
     **/
    public function contains(...$values);

    /**
     * Creates a new sequence using a to determine which values to include
     *
     * Creates a new sequence using a callable to determine which values to
     * include.
     *
     * @param callable $callback bool callback mixed{@link value} Optional
     *   callable which returns TRUE if the value should be included, FALSE
     *   otherwise. If a callback is not provided, only values which are TRUE
     *   (see converting to boolean) will be included.
     * @return Ds\Sequence A new sequence containing all the values for
     *   which either the {@link callback} returned TRUE, or all values that
     *   convert to TRUE if a {@link callback} was not provided.
     **/
    public function filter($callback);

    /**
     * Attempts to find a value's index
     *
     * Returns the index of the {@link value}, or FALSE if not found.
     *
     * @param mixed $value The value to find.
     * @return mixed The index of the value, or FALSE if not found.
     **/
    public function find($value);

    /**
     * Returns the first value in the sequence
     *
     * @return mixed The first value in the sequence.
     **/
    public function first();

    /**
     * Returns the value at a given index
     *
     * @param int $index The index to access, starting at 0.
     * @return mixed The value at the requested index.
     **/
    public function get($index);

    /**
     * Inserts values at a given index
     *
     * Inserts values into the sequence at a given index.
     *
     * @param int $index The index at which to insert. 0 <= index <= count
     * @param mixed ...$values The value or values to insert.
     * @return void
     **/
    public function insert($index, ...$values);

    /**
     * Joins all values together as a string
     *
     * Joins all values together as a string using an optional separator
     * between each value.
     *
     * @param string $glue An optional string to separate each value.
     * @return string All values of the sequence joined together as a
     *   string.
     **/
    public function join($glue);

    /**
     * Returns the last value
     *
     * Returns the last value in the sequence.
     *
     * @return mixed The last value in the sequence.
     **/
    public function last();

    /**
     * Returns the result of applying a callback to each value
     *
     * Returns the result of applying a {@link callback} function to each
     * value in the sequence.
     *
     * @param callable $callback mixed callback mixed{@link value} A
     *   callable to apply to each value in the sequence. The callable should
     *   return what the new value will be in the new sequence.
     * @return Ds\Sequence The result of applying a {@link callback} to
     *   each value in the sequence.
     **/
    public function map($callback);

    /**
     * Returns the result of adding all given values to the sequence
     *
     * @param mixed $values A traversable object or an .
     * @return Ds\Sequence The result of adding all given values to the
     *   sequence, effectively the same as adding the values to a copy, then
     *   returning that copy.
     **/
    public function merge($values);

    /**
     * Removes and returns the last value
     *
     * @return mixed The removed last value.
     **/
    public function pop();

    /**
     * Adds values to the end of the sequence
     *
     * @param mixed ...$values The values to add.
     * @return void
     **/
    public function push(...$values);

    /**
     * Reduces the sequence to a single value using a callback function
     *
     * @param callable $callback
     * @param mixed $initial The return value of the previous callback, or
     *   {@link initial} if it's the first iteration.
     * @return mixed The return value of the final callback.
     **/
    public function reduce($callback, $initial);

    /**
     * Removes and returns a value by index
     *
     * @param int $index The index of the value to remove.
     * @return mixed The value that was removed.
     **/
    public function remove($index);

    /**
     * Reverses the sequence in-place
     *
     * Reverses the sequence in-place.
     *
     * @return void
     **/
    public function reverse();

    /**
     * Returns a reversed copy
     *
     * Returns a reversed copy of the sequence.
     *
     * @return Ds\Sequence A reversed copy of the sequence.
     *   
     *   The current instance is not affected.
     **/
    public function reversed();

    /**
     * Rotates the sequence by a given number of rotations
     *
     * Rotates the sequence by a given number of rotations, which is
     * equivalent to successively calling $sequence->push($sequence->shift())
     * if the number of rotations is positive, or
     * $sequence->unshift($sequence->pop()) if negative.
     *
     * @param int $rotations The number of times the sequence should be
     *   rotated.
     * @return void . The sequence of the current instance will be rotated.
     **/
    public function rotate($rotations);

    /**
     * Updates a value at a given index
     *
     * @param int $index The index of the value to update.
     * @param mixed $value The new value.
     * @return void
     **/
    public function set($index, $value);

    /**
     * Removes and returns the first value
     *
     * @return mixed The first value, which was removed.
     **/
    public function shift();

    /**
     * Returns a sub-sequence of a given range
     *
     * Creates a sub-sequence of a given range.
     *
     * @param int $index The index at which the sub-sequence starts. If
     *   positive, the sequence will start at that index in the sequence. If
     *   negative, the sequence will start that far from the end.
     * @param int $length If a length is given and is positive, the
     *   resulting sequence will have up to that many values in it.
     *   
     *   If the length results in an overflow, only values up to the end of
     *   the sequence will be included.
     *   
     *   If a length is given and is negative, the sequence will stop that
     *   many values from the end.
     *   
     *   If a length is not provided, the resulting sequence will contain all
     *   values between the index and the end of the sequence.
     * @return Ds\Sequence A sub-sequence of the given range.
     **/
    public function slice($index, $length);

    /**
     * Sorts the sequence in-place
     *
     * Sorts the sequence in-place, using an optional {@link comparator}
     * function.
     *
     * @param callable $comparator
     * @return void
     **/
    public function sort($comparator);

    /**
     * Returns a sorted copy
     *
     * Returns a sorted copy, using an optional {@link comparator} function.
     *
     * @param callable $comparator
     * @return Ds\Sequence Returns a sorted copy of the sequence.
     **/
    public function sorted($comparator);

    /**
     * Returns the sum of all values in the sequence
     *
     * @return number The sum of all the values in the sequence as either a
     *   float or int depending on the values in the sequence.
     **/
    public function sum();

    /**
     * Adds values to the front of the sequence
     *
     * Adds values to the front of the sequence, moving all the current
     * values forward to make room for the new values.
     *
     * @param mixed $values The values to add to the front of the sequence.
     *   Multiple values will be added in the same order that they are
     *   passed.
     * @return void
     **/
    public function unshift($values);

}
}
namespace Ds {
class Set implements Ds\Collection {
    /**
     * Adds values to the set
     *
     * Adds all given values to the set that haven't already been added.
     *
     * @param mixed ...$values Values to add to the set.
     * @return void
     **/
    public function add(...$values){}

    /**
     * Allocates enough memory for a required capacity
     *
     * @param int $capacity The number of values for which capacity should
     *   be allocated.
     * @return void
     **/
    public function allocate($capacity){}

    /**
     * Returns the current capacity
     *
     * @return int The current capacity.
     **/
    public function capacity(){}

    /**
     * Removes all values
     *
     * Removes all values from the set.
     *
     * @return void
     **/
    public function clear(){}

    /**
     * Determines if the set contains all values
     *
     * @param mixed ...$values Values to check.
     * @return bool FALSE if any of the provided {@link values} are not in
     *   the set, TRUE otherwise.
     **/
    public function contains(...$values){}

    /**
     * Returns a shallow copy of the set
     *
     * @return Ds\Set Returns a shallow copy of the set.
     **/
    public function copy(){}

    /**
     * Creates a new set using values that aren't in another set
     *
     * A \ B = {x ∈ A | x ∉ B}
     *
     * @param Ds\Set $set Set containing the values to exclude.
     * @return Ds\Set A new set containing all values that were not in the
     *   other {@link set}.
     **/
    public function diff($set){}

    /**
     * Creates a new set using a to determine which values to include
     *
     * Creates a new set using a callable to determine which values to
     * include.
     *
     * @param callable $callback bool callback mixed{@link value} Optional
     *   callable which returns TRUE if the value should be included, FALSE
     *   otherwise. If a callback is not provided, only values which are TRUE
     *   (see converting to boolean) will be included.
     * @return Ds\Set A new set containing all the values for which either
     *   the {@link callback} returned TRUE, or all values that convert to
     *   TRUE if a {@link callback} was not provided.
     **/
    public function filter($callback){}

    /**
     * Returns the first value in the set
     *
     * @return mixed The first value in the set.
     **/
    public function first(){}

    /**
     * Returns the value at a given index
     *
     * @param int $index The index to access, starting at 0.
     * @return mixed The value at the requested index.
     **/
    public function get($index){}

    /**
     * Creates a new set by intersecting values with another set
     *
     * Creates a new set using values common to both the current instance and
     * another {@link set}.
     *
     * In other words, returns a copy of the current instance with all values
     * removed that are not in the other {@link set}.
     *
     * A ∩ B = {x : x ∈ A ∧ x ∈ B}
     *
     * @param Ds\Set $set The other set.
     * @return Ds\Set The intersection of the current instance and another
     *   {@link set}.
     **/
    public function intersect($set){}

    /**
     * Returns whether the set is empty
     *
     * @return bool Returns TRUE if the set is empty, FALSE otherwise.
     **/
    public function isEmpty(){}

    /**
     * Joins all values together as a string
     *
     * Joins all values together as a string using an optional separator
     * between each value.
     *
     * @param string $glue An optional string to separate each value.
     * @return string All values of the set joined together as a string.
     **/
    public function join($glue){}

    /**
     * Returns the last value in the set
     *
     * @return void The last value in the set.
     **/
    public function last(){}

    /**
     * Returns the result of adding all given values to the set
     *
     * @param mixed $values A traversable object or an .
     * @return Ds\Set The result of adding all given values to the set,
     *   effectively the same as adding the values to a copy, then returning
     *   that copy.
     **/
    public function merge($values){}

    /**
     * Reduces the set to a single value using a callback function
     *
     * @param callable $callback
     * @param mixed $initial The return value of the previous callback, or
     *   {@link initial} if it's the first iteration.
     * @return mixed The return value of the final callback.
     **/
    public function reduce($callback, $initial){}

    /**
     * Removes all given values from the set
     *
     * Removes all given {@link values} from the set, ignoring any that are
     * not in the set.
     *
     * @param mixed ...$values The values to remove.
     * @return void
     **/
    public function remove(...$values){}

    /**
     * Reverses the set in-place
     *
     * Reverses the set in-place.
     *
     * @return void
     **/
    public function reverse(){}

    /**
     * Returns a reversed copy
     *
     * Returns a reversed copy of the set.
     *
     * @return Ds\Set A reversed copy of the set.
     *   
     *   The current instance is not affected.
     **/
    public function reversed(){}

    /**
     * Returns a sub-set of a given range
     *
     * Creates a sub-set of a given range.
     *
     * @param int $index The index at which the sub-set starts. If
     *   positive, the set will start at that index in the set. If negative,
     *   the set will start that far from the end.
     * @param int $length If a length is given and is positive, the
     *   resulting set will have up to that many values in it.
     *   
     *   If the length results in an overflow, only values up to the end of
     *   the set will be included.
     *   
     *   If a length is given and is negative, the set will stop that many
     *   values from the end.
     *   
     *   If a length is not provided, the resulting set will contain all
     *   values between the index and the end of the set.
     * @return Ds\Set A sub-set of the given range.
     **/
    public function slice($index, $length){}

    /**
     * Sorts the set in-place
     *
     * Sorts the set in-place, using an optional {@link comparator} function.
     *
     * @param callable $comparator
     * @return void
     **/
    public function sort($comparator){}

    /**
     * Returns a sorted copy
     *
     * Returns a sorted copy, using an optional {@link comparator} function.
     *
     * @param callable $comparator
     * @return Ds\Set Returns a sorted copy of the set.
     **/
    public function sorted($comparator){}

    /**
     * Returns the sum of all values in the set
     *
     * @return number The sum of all the values in the set as either a
     *   float or int depending on the values in the set.
     **/
    public function sum(){}

    /**
     * Converts the set to an
     *
     * Converts the set to an .
     *
     * @return array An containing all the values in the same order as the
     *   set.
     **/
    public function toArray(){}

    /**
     * Creates a new set using values from the current instance and another
     * set
     *
     * Creates a new set that contains the values of the current instance as
     * well as the values of another {@link set}.
     *
     * A ∪ B = {x: x ∈ A ∨ x ∈ B}
     *
     * @param Ds\Set $set The other set, to combine with the current
     *   instance.
     * @return Ds\Set A new set containing all the values of the current
     *   instance as well as another {@link set}.
     **/
    public function union($set){}

    /**
     * Creates a new set using values in either the current instance or in
     * another set, but not in both
     *
     * Creates a new set containing values in the current instance as well as
     * another {@link set}, but not in both.
     *
     * A ⊖ B = {x : x ∈ (A \ B) ∪ (B \ A)}
     *
     * @param Ds\Set $set The other set.
     * @return Ds\Set A new set containing values in the current instance
     *   as well as another {@link set}, but not in both.
     **/
    public function xor($set){}

}
}
namespace Ds {
class Stack implements Ds\Collection {
    /**
     * Allocates enough memory for a required capacity
     *
     * Ensures that enough memory is allocated for a required capacity. This
     * removes the need to reallocate the internal as values are added.
     *
     * @param int $capacity The number of values for which capacity should
     *   be allocated.
     * @return void
     **/
    public function allocate($capacity){}

    /**
     * Returns the current capacity
     *
     * @return int The current capacity.
     **/
    public function capacity(){}

    /**
     * Removes all values
     *
     * Removes all values from the stack.
     *
     * @return void
     **/
    public function clear(){}

    /**
     * Returns a shallow copy of the stack
     *
     * @return Ds\Stack Returns a shallow copy of the stack.
     **/
    public function copy(){}

    /**
     * Returns whether the stack is empty
     *
     * @return bool Returns TRUE if the stack is empty, FALSE otherwise.
     **/
    public function isEmpty(){}

    /**
     * Returns the value at the top of the stack
     *
     * Returns the value at the top of the stack, but does not remove it.
     *
     * @return mixed The value at the top of the stack.
     **/
    public function peek(){}

    /**
     * Removes and returns the value at the top of the stack
     *
     * @return mixed The removed value which was at the top of the stack.
     **/
    public function pop(){}

    /**
     * Pushes values onto the stack
     *
     * Pushes {@link values} onto the stack.
     *
     * @param mixed ...$values The values to push onto the stack.
     * @return void
     **/
    public function push(...$values){}

    /**
     * Converts the stack to an
     *
     * Converts the stack to an .
     *
     * @return array An containing all the values in the same order as the
     *   stack.
     **/
    public function toArray(){}

}
}
namespace Ds {
class Vector implements Ds\Sequence {
    /**
     * Allocates enough memory for a required capacity
     *
     * Ensures that enough memory is allocated for a required capacity. This
     * removes the need to reallocate the internal as values are added.
     *
     * @param int $capacity The number of values for which capacity should
     *   be allocated.
     * @return void
     **/
    public function allocate($capacity){}

    /**
     * Updates all values by applying a callback function to each value
     *
     * Updates all values by applying a {@link callback} function to each
     * value in the vector.
     *
     * @param callable $callback mixed callback mixed{@link value} A
     *   callable to apply to each value in the vector. The callback should
     *   return what the value should be replaced by.
     * @return void
     **/
    public function apply($callback){}

    /**
     * Returns the current capacity
     *
     * @return int The current capacity.
     **/
    public function capacity(){}

    /**
     * Removes all values
     *
     * Removes all values from the vector.
     *
     * @return void
     **/
    public function clear(){}

    /**
     * Determines if the vector contains given values
     *
     * Determines if the vector contains all values.
     *
     * @param mixed ...$values Values to check.
     * @return bool FALSE if any of the provided {@link values} are not in
     *   the vector, TRUE otherwise.
     **/
    public function contains(...$values){}

    /**
     * Returns a shallow copy of the vector
     *
     * @return Ds\Vector Returns a shallow copy of the vector.
     **/
    public function copy(){}

    /**
     * Creates a new vector using a to determine which values to include
     *
     * Creates a new vector using a callable to determine which values to
     * include.
     *
     * @param callable $callback bool callback mixed{@link value} Optional
     *   callable which returns TRUE if the value should be included, FALSE
     *   otherwise. If a callback is not provided, only values which are TRUE
     *   (see converting to boolean) will be included.
     * @return Ds\Vector A new vector containing all the values for which
     *   either the {@link callback} returned TRUE, or all values that
     *   convert to TRUE if a {@link callback} was not provided.
     **/
    public function filter($callback){}

    /**
     * Attempts to find a value's index
     *
     * Returns the index of the {@link value}, or FALSE if not found.
     *
     * @param mixed $value The value to find.
     * @return mixed The index of the value, or FALSE if not found.
     **/
    public function find($value){}

    /**
     * Returns the first value in the vector
     *
     * @return mixed The first value in the vector.
     **/
    public function first(){}

    /**
     * Returns the value at a given index
     *
     * @param int $index The index to access, starting at 0.
     * @return mixed The value at the requested index.
     **/
    public function get($index){}

    /**
     * Inserts values at a given index
     *
     * Inserts values into the vector at a given index.
     *
     * @param int $index The index at which to insert. 0 <= index <= count
     * @param mixed ...$values The value or values to insert.
     * @return void
     **/
    public function insert($index, ...$values){}

    /**
     * Returns whether the vector is empty
     *
     * @return bool Returns TRUE if the vector is empty, FALSE otherwise.
     **/
    public function isEmpty(){}

    /**
     * Joins all values together as a string
     *
     * Joins all values together as a string using an optional separator
     * between each value.
     *
     * @param string $glue An optional string to separate each value.
     * @return string All values of the vector joined together as a string.
     **/
    public function join($glue){}

    /**
     * Returns the last value
     *
     * Returns the last value in the vector.
     *
     * @return mixed The last value in the vector.
     **/
    public function last(){}

    /**
     * Returns the result of applying a callback to each value
     *
     * Returns the result of applying a {@link callback} function to each
     * value in the vector.
     *
     * @param callable $callback mixed callback mixed{@link value} A
     *   callable to apply to each value in the vector. The callable should
     *   return what the new value will be in the new vector.
     * @return Ds\Vector The result of applying a {@link callback} to each
     *   value in the vector.
     **/
    public function map($callback){}

    /**
     * Returns the result of adding all given values to the vector
     *
     * @param mixed $values A traversable object or an .
     * @return Ds\Vector The result of adding all given values to the
     *   vector, effectively the same as adding the values to a copy, then
     *   returning that copy.
     **/
    public function merge($values){}

    /**
     * Removes and returns the last value
     *
     * @return mixed The removed last value.
     **/
    public function pop(){}

    /**
     * Adds values to the end of the vector
     *
     * @param mixed ...$values The values to add.
     * @return void
     **/
    public function push(...$values){}

    /**
     * Reduces the vector to a single value using a callback function
     *
     * @param callable $callback
     * @param mixed $initial The return value of the previous callback, or
     *   {@link initial} if it's the first iteration.
     * @return mixed The return value of the final callback.
     **/
    public function reduce($callback, $initial){}

    /**
     * Removes and returns a value by index
     *
     * @param int $index The index of the value to remove.
     * @return mixed The value that was removed.
     **/
    public function remove($index){}

    /**
     * Reverses the vector in-place
     *
     * Reverses the vector in-place.
     *
     * @return void
     **/
    public function reverse(){}

    /**
     * Returns a reversed copy
     *
     * Returns a reversed copy of the vector.
     *
     * @return Ds\Vector A reversed copy of the vector.
     *   
     *   The current instance is not affected.
     **/
    public function reversed(){}

    /**
     * Rotates the vector by a given number of rotations
     *
     * Rotates the vector by a given number of rotations, which is equivalent
     * to successively calling $vector->push($vector->shift()) if the number
     * of rotations is positive, or $vector->unshift($vector->pop()) if
     * negative.
     *
     * @param int $rotations The number of times the vector should be
     *   rotated.
     * @return void . The vector of the current instance will be rotated.
     **/
    public function rotate($rotations){}

    /**
     * Updates a value at a given index
     *
     * @param int $index The index of the value to update.
     * @param mixed $value The new value.
     * @return void
     **/
    public function set($index, $value){}

    /**
     * Removes and returns the first value
     *
     * @return mixed The first value, which was removed.
     **/
    public function shift(){}

    /**
     * Returns a sub-vector of a given range
     *
     * Creates a sub-vector of a given range.
     *
     * @param int $index The index at which the sub-vector starts. If
     *   positive, the vector will start at that index in the vector. If
     *   negative, the vector will start that far from the end.
     * @param int $length If a length is given and is positive, the
     *   resulting vector will have up to that many values in it.
     *   
     *   If the length results in an overflow, only values up to the end of
     *   the vector will be included.
     *   
     *   If a length is given and is negative, the vector will stop that many
     *   values from the end.
     *   
     *   If a length is not provided, the resulting vector will contain all
     *   values between the index and the end of the vector.
     * @return Ds\Vector A sub-vector of the given range.
     **/
    public function slice($index, $length){}

    /**
     * Sorts the vector in-place
     *
     * Sorts the vector in-place, using an optional {@link comparator}
     * function.
     *
     * @param callable $comparator
     * @return void
     **/
    public function sort($comparator){}

    /**
     * Returns a sorted copy
     *
     * Returns a sorted copy, using an optional {@link comparator} function.
     *
     * @param callable $comparator
     * @return Ds\Vector Returns a sorted copy of the vector.
     **/
    public function sorted($comparator){}

    /**
     * Returns the sum of all values in the vector
     *
     * @return number The sum of all the values in the vector as either a
     *   float or int depending on the values in the vector.
     **/
    public function sum(){}

    /**
     * Converts the vector to an
     *
     * Converts the vector to an .
     *
     * @return array An containing all the values in the same order as the
     *   vector.
     **/
    public function toArray(){}

    /**
     * Adds values to the front of the vector
     *
     * Adds values to the front of the vector, moving all the current values
     * forward to make room for the new values.
     *
     * @param mixed $values The values to add to the front of the vector.
     *   Multiple values will be added in the same order that they are
     *   passed.
     * @return void
     **/
    public function unshift($values){}

}
}
/**
 * The EmptyIterator class for an empty iterator.
 **/
class EmptyIterator implements Iterator {
    /**
     * The current() method
     *
     * This function must not be called. It throws an exception upon access.
     *
     * @return mixed
     * @since PHP 5 >= 5.1.0, PHP 7
     **/
    public function current(){}

    /**
     * The key() method
     *
     * This function must not be called. It throws an exception upon access.
     *
     * @return scalar
     * @since PHP 5 >= 5.1.0, PHP 7
     **/
    public function key(){}

    /**
     * The next() method
     *
     * No operation, nothing to do.
     *
     * @return void
     * @since PHP 5 >= 5.1.0, PHP 7
     **/
    public function next(){}

    /**
     * The rewind() method
     *
     * No operation, nothing to do.
     *
     * @return void
     * @since PHP 5 >= 5.1.0, PHP 7
     **/
    public function rewind(){}

    /**
     * The valid() method
     *
     * The EmptyIterator valid() method.
     *
     * @return bool FALSE
     * @since PHP 5 >= 5.1.0, PHP 7
     **/
    public function valid(){}

}
/**
 * Available since PHP 5.1.0. An Error Exception. Use {@link
 * set_error_handler} to change error messages into ErrorException.
 *
 * Fatal error: Uncaught exception 'ErrorException' with message
 * 'strpos() expects at least 2 parameters, 0 given' in
 * /home/bjori/tmp/ex.php:12 Stack trace: #0 [internal function]:
 * exception_error_handler(2, 'strpos() expect...', '/home/bjori/php...',
 * 12, Array) #1 /home/bjori/php/cleandocs/test.php(12): strpos() #2
 * {main} thrown in /home/bjori/tmp/ex.php on line 12
 **/
class ErrorException extends Exception {
    /**
     * The severity of the exception
     *
     * @var int
     **/
    protected $severity;

    /**
     * Gets the exception severity
     *
     * Returns the severity of the exception.
     *
     * @return int Returns the severity level of the exception.
     * @since PHP 5 >= 5.1.0, PHP 7
     **/
    final public function getSeverity(){}

}
/**
 * Ev is a static class providing access to the default loop and to some
 * common operations. Flags passed to create a loop:
 *
 * Ev::FLAG_AUTO The default flags value Ev::FLAG_NOENV If this flag
 * used(or the program runs setuid or setgid), libev won't look at the
 * environment variable LIBEV_FLAGS . Otherwise(by default), LIBEV_FLAGS
 * will override the flags completely if it is found. Useful for
 * performance tests and searching for bugs. Ev::FLAG_FORKCHECK Makes
 * libev check for a fork in each iteration, instead of calling
 * EvLoop::fork manually. This works by calling getpid() on every
 * iteration of the loop, and thus this might slow down the event loop
 * with lots of loop iterations, but usually is not noticeable. This flag
 * setting cannot be overridden or specified in the LIBEV_FLAGS
 * environment variable. Ev::FLAG_NOINOTIFY When this flag is specified,
 * libev won't attempt to use the inotify API for its ev_stat watchers.
 * The flag can be useful to conserve inotify file descriptors, as
 * otherwise each loop using ev_stat watchers consumes one inotify
 * handle. Ev::FLAG_SIGNALFD When this flag is specified, libev will
 * attempt to use the signalfd API for its ev_signal (and ev_child )
 * watchers. This API delivers signals synchronously, which makes it both
 * faster and might make it possible to get the queued signal data. It
 * can also simplify signal handling with threads, as long as signals are
 * properly blocked in threads. Signalfd will not be used by default.
 * Ev::FLAG_NOSIGMASK When this flag is specified, libev will avoid to
 * modify the signal mask. Specifically, this means having to make sure
 * signals are unblocked before receiving them. This behaviour is useful
 * for custom signal handling, or handling signals only in specific
 * threads. Flags passed to Ev::run , or EvLoop::run
 *
 * Ev::RUN_NOWAIT Means that event loop will look for new events, will
 * handle those events and any already outstanding ones, but will not
 * wait and block the process in case there are no events and will return
 * after one iteration of the loop. This is sometimes useful to poll and
 * handle new events while doing lengthy calculations, to keep the
 * program responsive. Ev::RUN_ONCE Means that event loop will look for
 * new events (waiting if necessary) and will handle those and any
 * already outstanding ones. It will block the process until at least one
 * new event arrives (which could be an event internal to libev itself,
 * so there is no guarantee that a user-registered callback will be
 * called), and will return after one iteration of the loop. Flags passed
 * to Ev::stop , or EvLoop::stop
 *
 * Ev::BREAK_CANCEL Cancel the break operation. Ev::BREAK_ONE Makes the
 * innermost Ev::run (or EvLoop::run ) call return. Ev::BREAK_ALL Makes
 * all nested Ev::run (or EvLoop::run ) calls return. Watcher priorities:
 *
 * Ev::MINPRI Minimum allowed watcher priority. Ev::MAXPRI Maximum
 * allowed watcher priority. Bit masks of (received) events:
 *
 * Ev::READ The file descriptor in the EvIo watcher has become readable.
 * Ev::WRITE The file descriptor in the EvIo watcher has become writable.
 * Ev::TIMER EvTimer watcher has been timed out. Ev::PERIODIC EvPeriodic
 * watcher has been timed out. Ev::SIGNAL A signal specified in
 * EvSignal::__construct has been received. Ev::CHILD The {@link pid}
 * specified in EvChild::__construct has received a status change.
 * Ev::STAT The path specified in EvStat watcher changed its attributes.
 * Ev::IDLE EvIdle watcher works when there is nothing to do with other
 * watchers. Ev::PREPARE All EvPrepare watchers are invoked just before
 * Ev::run starts. Thus, EvPrepare watchers are the last watchers invoked
 * before the event loop sleeps or polls for new events. Ev::CHECK All
 * EvCheck watchers are queued just after Ev::run has gathered the new
 * events, but before it queues any callbacks for any received events.
 * Thus, EvCheck watchers will be invoked before any other watchers of
 * the same or lower priority within an event loop iteration. Ev::EMBED
 * The embedded event loop specified in the EvEmbed watcher needs
 * attention. Ev::CUSTOM Not ever sent(or otherwise used) by libev
 * itself, but can be freely used by libev users to signal watchers (e.g.
 * via EvWatcher::feed ). Ev::ERROR An unspecified error has occurred,
 * the watcher has been stopped. This might happen because the watcher
 * could not be properly started because libev ran out of memory, a file
 * descriptor was found to be closed or any other problem. Libev
 * considers these application bugs. See also ANATOMY OF A WATCHER
 * Backend flags:
 *
 * Ev::BACKEND_SELECT select(2) backend Ev::BACKEND_POLL poll(2) backend
 * Ev::BACKEND_EPOLL Linux-specific epoll(7) backend for both pre- and
 * post-2.6.9 kernels Ev::BACKEND_KQUEUE kqueue backend used on most BSD
 * systems. EvEmbed watcher could be used to embed one loop(with kqueue
 * backend) into another. For instance, one can try to create an event
 * loop with kqueue backend and use it for sockets only.
 * Ev::BACKEND_DEVPOLL Solaris 8 backend. This is not implemented yet.
 * Ev::BACKEND_PORT Solaris 10 event port mechanism with a good scaling.
 * Ev::BACKEND_ALL Try all backends(even currupted ones). It's not
 * recommended to use it explicitly. Bitwise operators should be applied
 * here(e.g. Ev::BACKEND_ALL & ~ Ev::BACKEND_KQUEUE ) Use
 * Ev::recommendedBackends , or don't specify any backends at all.
 * Ev::BACKEND_MASK Not a backend, but a mask to select all backend bits
 * from {@link flags} value to mask out any backends(e.g. when modifying
 * the LIBEV_FLAGS environment variable).
 **/
final class Ev {
    /**
     * @var integer
     **/
    const BACKEND_ALL = 0;

    /**
     * @var integer
     **/
    const BACKEND_DEVPOLL = 0;

    /**
     * @var integer
     **/
    const BACKEND_EPOLL = 0;

    /**
     * @var integer
     **/
    const BACKEND_KQUEUE = 0;

    /**
     * @var integer
     **/
    const BACKEND_MASK = 0;

    /**
     * @var integer
     **/
    const BACKEND_POLL = 0;

    /**
     * @var integer
     **/
    const BACKEND_PORT = 0;

    /**
     * @var integer
     **/
    const BACKEND_SELECT = 0;

    /**
     * @var integer
     **/
    const BREAK_ALL = 0;

    /**
     * @var integer
     **/
    const BREAK_CANCEL = 0;

    /**
     * @var integer
     **/
    const BREAK_ONE = 0;

    /**
     * All EvCheck watchers are queued just after Ev::run has gathered the
     * new events, but before it queues any callbacks for any received
     * events. Thus, EvCheck watchers will be invoked before any other
     * watchers of the same or lower priority within an event loop iteration.
     *
     * @var integer
     **/
    const CHECK = 0;

    /**
     * The {@link pid} specified in EvChild::__construct has received a
     * status change.
     *
     * @var integer
     **/
    const CHILD = 0;

    /**
     * Not ever sent(or otherwise used) by libev itself, but can be freely
     * used by libev users to signal watchers (e.g. via EvWatcher::feed ).
     *
     * @var integer
     **/
    const CUSTOM = 0;

    /**
     * The embedded event loop specified in the EvEmbed watcher needs
     * attention.
     *
     * @var integer
     **/
    const EMBED = 0;

    /**
     * An unspecified error has occurred, the watcher has been stopped. This
     * might happen because the watcher could not be properly started because
     * libev ran out of memory, a file descriptor was found to be closed or
     * any other problem. Libev considers these application bugs. See also
     * ANATOMY OF A WATCHER
     *
     * @var integer
     **/
    const ERROR = 0;

    /**
     * @var integer
     **/
    const FLAG_AUTO = 0;

    /**
     * @var integer
     **/
    const FLAG_FORKCHECK = 0;

    /**
     * @var integer
     **/
    const FLAG_NOENV = 0;

    /**
     * @var integer
     **/
    const FLAG_NOINOTIFY = 0;

    /**
     * @var integer
     **/
    const FLAG_NOSIGMASK = 0;

    /**
     * @var integer
     **/
    const FLAG_SIGNALFD = 0;

    /**
     * EvIdle watcher works when there is nothing to do with other watchers.
     *
     * @var integer
     **/
    const IDLE = 0;

    /**
     * Maximum allowed watcher priority.
     *
     * @var integer
     **/
    const MAXPRI = 0;

    /**
     * Minimum allowed watcher priority.
     *
     * @var integer
     **/
    const MINPRI = 0;

    /**
     * EvPeriodic watcher has been timed out.
     *
     * @var integer
     **/
    const PERIODIC = 0;

    /**
     * All EvPrepare watchers are invoked just before Ev::run starts. Thus,
     * EvPrepare watchers are the last watchers invoked before the event loop
     * sleeps or polls for new events.
     *
     * @var integer
     **/
    const PREPARE = 0;

    /**
     * The file descriptor in the EvIo watcher has become readable.
     *
     * @var integer
     **/
    const READ = 0;

    /**
     * @var integer
     **/
    const RUN_NOWAIT = 0;

    /**
     * @var integer
     **/
    const RUN_ONCE = 0;

    /**
     * A signal specified in EvSignal::__construct has been received.
     *
     * @var integer
     **/
    const SIGNAL = 0;

    /**
     * The path specified in EvStat watcher changed its attributes.
     *
     * @var integer
     **/
    const STAT = 0;

    /**
     * EvTimer watcher has been timed out.
     *
     * @var integer
     **/
    const TIMER = 0;

    /**
     * The file descriptor in the EvIo watcher has become writable.
     *
     * @var integer
     **/
    const WRITE = 0;

    /**
     * Returns an integer describing the backend used by libev
     *
     * Returns an integer describing the backend used by libev . See Backend
     * flags
     *
     * @return int Returns an integer(bit mask) describing the backend used
     *   by libev .
     * @since PECL ev >= 0.2.0
     **/
    final public static function backend(){}

    /**
     * Returns recursion depth
     *
     * The number of times Ev::run was entered minus the number of times
     * Ev::run was exited normally, in other words, the recursion depth.
     * Outside Ev::run , this number is 0 . In a callback, this number is 1 ,
     * unless Ev::run was invoked recursively (or from another thread), in
     * which case it is higher.
     *
     * @return int {@link ev_depth} returns recursion depth of the default
     *   loop.
     * @since PECL ev >= 0.2.0
     **/
    final public static function depth(){}

    /**
     * Returns the set of backends that are embeddable in other event loops
     *
     * @return int Returns a bit mask which can containing backend flags
     *   combined using bitwise OR operator.
     * @since PECL ev >= 0.2.0
     **/
    final public static function embeddableBackends(){}

    /**
     * Feed a signal event info Ev
     *
     * Simulates a signal receive. It is safe to call this function at any
     * time, from any context, including signal handlers or random threads.
     * Its main use is to customise signal handling in the process.
     *
     * Unlike Ev::feedSignalEvent , this works regardless of which loop has
     * registered the signal.
     *
     * @param int $signum Signal number. See signal(7) man page for detals.
     *   You can use constants exported by pcntl extension.
     * @return void
     * @since PECL ev >= 0.2.0
     **/
    final public static function feedSignal($signum){}

    /**
     * Feed signal event into the default loop
     *
     * Feed signal event into the default loop. Ev will react to this call as
     * if the signal specified by {@link signal} had occurred.
     *
     * @param int $signum Signal number. See signal(7) man page for detals.
     *   See also constants exported by pcntl extension.
     * @return void
     **/
    final public static function feedSignalEvent($signum){}

    /**
     * Return the number of times the default event loop has polled for new
     * events
     *
     * Return the number of times the event loop has polled for new events.
     * Sometimes useful as a generation counter.
     *
     * @return int Returns number of polls of the default event loop.
     * @since PECL ev >= 0.2.0
     **/
    final public static function iteration(){}

    /**
     * Returns the time when the last iteration of the default event loop has
     * started
     *
     * Returns the time when the last iteration of the default event loop has
     * started. This is the time that timers( EvTimer and EvPeriodic ) are
     * based on, and referring to it is usually faster then calling Ev::time
     * .
     *
     * @return float Returns number of seconds(fractional) representing the
     *   time when the last iteration of the default event loop has started.
     * @since PECL ev >= 0.2.0
     **/
    final public static function now(){}

    /**
     * Establishes the current time by querying the kernel, updating the time
     * returned by Ev::now in the progress
     *
     * Establishes the current time by querying the kernel, updating the time
     * returned by Ev::now in the progress. This is a costly operation and is
     * usually done automatically within Ev::run .
     *
     * This method is rarely useful, but when some event callback runs for a
     * very long time without entering the event loop, updating libev 's
     * consideration of the current time is a good idea.
     *
     * @return void
     * @since PECL ev >= 0.2.0
     **/
    final public static function nowUpdate(){}

    /**
     * Returns a bit mask of recommended backends for current platform
     *
     * Returns the set of all backends compiled into this binary of libev and
     * also recommended for this platform, meaning it will work for most file
     * descriptor types. This set is often smaller than the one returned by
     * {@link ev_supported_backends} , as for example kqueue is broken on
     * most BSD systems and will not be auto-detected unless it is requested
     * explicitly. This is the set of backends that libev will probe no
     * backends specified explicitly.
     *
     * @return int Returns a bit mask which can containing backend flags
     *   combined using bitwise OR operator.
     * @since PECL ev >= 0.2.0
     **/
    final public static function recommendedBackends(){}

    /**
     * Resume previously suspended default event loop
     *
     * Ev::suspend and Ev::resume methods suspend and resume a loop
     * correspondingly.
     *
     * All timer watchers will be delayed by the time spend between suspend
     * and resume , and all periodic watchers will be rescheduled(that is,
     * they will lose any events that would have occurred while suspended).
     *
     * After calling Ev::suspend it is not allowed to call any function on
     * the given loop other than Ev::resume . Also it is not allowed to call
     * Ev::resume without a previous call to Ev::suspend .
     *
     * Calling suspend / resume has the side effect of updating the event
     * loop time(see Ev::nowUpdate ).
     *
     * @return void
     * @since PECL ev >= 0.2.0
     **/
    final public static function resume(){}

    /**
     * Begin checking for events and calling callbacks for the default loop
     *
     * Begin checking for events and calling callbacks for the default loop .
     * Returns when a callback calls Ev::stop method, or the flags are
     * nonzero(in which case the return value is true) or when there are no
     * active watchers which reference the loop( EvWatcher::keepalive is
     * TRUE), in which case the return value will be FALSE. The return value
     * can generally be interpreted as if TRUE, there is more work left to do
     * .
     *
     * @param int $flags Optional parameter {@link flags} can be one of the
     *   following: List for possible values of {@link flags} {@link flags}
     *   Description 0 The default behavior described above Ev::RUN_ONCE
     *   Block at most one(wait, but don't loop) Ev::RUN_NOWAIT Don't block
     *   at all(fetch/handle events, but don't wait) See the run flag
     *   constants .
     * @return void
     * @since PECL ev >= 0.2.0
     **/
    final public static function run($flags){}

    /**
     * Block the process for the given number of seconds
     *
     * @param float $seconds Fractional number of seconds
     * @return void
     * @since PECL ev >= 0.2.0
     **/
    final public static function sleep($seconds){}

    /**
     * Stops the default event loop
     *
     * @param int $how One of Ev::BREAK_* constants .
     * @return void
     * @since PECL ev >= 0.2.0
     **/
    final public static function stop($how){}

    /**
     * Returns the set of backends supported by current libev configuration
     *
     * Returns the set of backends supported by current libev configuration.
     *
     * @return int Returns a bit mask which can containing backend flags
     *   combined using bitwise OR operator.
     * @since PECL ev >= 0.2.0
     **/
    final public static function supportedBackends(){}

    /**
     * Suspend the default event loop
     *
     * Ev::suspend and Ev::resume methods suspend and resume the default loop
     * correspondingly.
     *
     * All timer watchers will be delayed by the time spend between suspend
     * and resume , and all periodic watchers will be rescheduled(that is,
     * they will lose any events that would have occurred while suspended).
     *
     * After calling Ev::suspend it is not allowed to call any function on
     * the given loop other than Ev::resume . Also it is not allowed to call
     * Ev::resume without a previous call to Ev::suspend .
     *
     * @return void
     * @since PECL ev >= 0.2.0
     **/
    final public static function suspend(){}

    /**
     * Returns the current time in fractional seconds since the epoch
     *
     * Returns the current time in fractional seconds since the epoch.
     * Consider using Ev::now
     *
     * @return float Returns the current time in fractional seconds since
     *   the epoch.
     * @since PECL ev >= 0.2.0
     **/
    final public static function time(){}

    /**
     * Performs internal consistency checks(for debugging)
     *
     * Performs internal consistency checks(for debugging libev ) and abort
     * the program if any data structures were found to be corrupted.
     *
     * @return void
     * @since PECL ev >= 0.2.0
     **/
    final public static function verify(){}

}
/**
 * EvPrepare and EvCheck watchers are usually used in pairs. EvPrepare
 * watchers get invoked before the process blocks, EvCheck afterwards. It
 * is not allowed to call EvLoop::run or similar methods or functions
 * that enter the current event loop from either EvPrepare or EvCheck
 * watchers. Other loops than the current one are fine, however. The
 * rationale behind this is that one dont need to check for recursion in
 * those watchers, i.e. the sequence will always be: EvPrepare ->
 * blocking -> EvCheck , so having a watcher of each kind they will
 * always be called in pairs bracketing the blocking call. The main
 * purpose is to integrate other event mechanisms into libev and their
 * use is somewhat advanced. They could be used, for example, to track
 * variable changes, implement custom watchers, integrate net-snmp or a
 * coroutine library and lots more. They are also occasionally useful to
 * cache some data and want to flush it before blocking. It is
 * recommended to give EvCheck watchers highest( Ev::MAXPRI ) priority,
 * to ensure that they are being run before any other watchers after the
 * poll (this doesn’t matter for EvPrepare watchers). Also, EvCheck
 * watchers should not activate/feed events. While libev fully supports
 * this, they might get executed before other EvCheck watchers did their
 * job.
 **/
class EvCheck extends EvWatcher {
    /**
     * Create instance of a stopped EvCheck watcher
     *
     * @param string $callback See Watcher callbacks .
     * @param string $data Custom data associated with the watcher.
     * @param string $priority Watcher priority
     * @return object Returns EvCheck object on success.
     * @since PECL ev >= 0.2.0
     **/
    final public static function createStopped($callback, $data, $priority){}

    /**
     * Constructs the EvCheck watcher object
     *
     * Constructs the EvCheck watcher object.
     *
     * @param callable $callback See Watcher callbacks .
     * @param mixed $data Custom data associated with the watcher.
     * @param int $priority Watcher priority
     * @since PECL ev >= 0.2.0
     **/
    public function __construct($callback, $data, $priority){}

}
/**
 * EvChild watchers trigger when the process receives a SIGCHLD in
 * response to some child status changes (most typically when a child
 * dies or exits). It is permissible to install an EvChild watcher after
 * the child has been forked(which implies it might have already exited),
 * as long as the event loop isn't entered(or is continued from a
 * watcher), i.e. forking and then immediately registering a watcher for
 * the child is fine, but forking and registering a watcher a few event
 * loop iterations later or in the next callback invocation is not. It is
 * allowed to register EvChild watchers in the default loop only.
 **/
class EvChild extends EvWatcher {
    /**
     * Readonly . The process ID this watcher watches out for, or 0 , meaning
     * any process ID.
     *
     * @var mixed
     **/
    public $pid;

    /**
     * Readonly .The process ID that detected a status change.
     *
     * @var mixed
     **/
    public $rpid;

    /**
     * Readonly . The process exit status caused by rpid .
     *
     * @var mixed
     **/
    public $rstatus;

    /**
     * Create instance of a stopped EvCheck watcher
     *
     * The same as EvChild::__construct , but doesn't start the watcher
     * automatically.
     *
     * @param int $pid The same as for EvChild::__construct
     * @param bool $trace The same as for EvChild::__construct
     * @param callable $callback See Watcher callbacks .
     * @param mixed $data Custom data associated with the watcher.
     * @param int $priority Watcher priority
     * @return object
     * @since PECL ev >= 0.2.0
     **/
    final public static function createStopped($pid, $trace, $callback, $data, $priority){}

    /**
     * Configures the watcher
     *
     * @param int $pid The same as for EvChild::__construct
     * @param bool $trace The same as for EvChild::__construct
     * @return void
     * @since PECL ev >= 0.2.0
     **/
    public function set($pid, $trace){}

    /**
     * Constructs the EvChild watcher object
     *
     * Constructs the EvChild watcher object.
     *
     * Call the callback when a status change for process ID {@link pid} (or
     * any PID if {@link pid} is 0 ) has been received(a status change
     * happens when the process terminates or is killed, or, when {@link
     * trace} is TRUE, additionally when it is stopped or continued). In
     * other words, when the process receives a SIGCHLD , Ev will fetch the
     * outstanding exit/wait status for all changed/zombie children and call
     * the callback.
     *
     * It is valid to install a child watcher after an EvChild has exited but
     * before the event loop has started its next iteration. For example,
     * first one calls fork , then the new child process might exit, and only
     * then an EvChild watcher is installed in the parent for the new PID .
     *
     * You can access both exit/tracing status and {@link pid} by using the
     * rstatus and rpid properties of the watcher object.
     *
     * The number of PID watchers per PID is unlimited. All of them will be
     * called.
     *
     * The EvChild::createStopped method doesnt start(activate) the newly
     * created watcher.
     *
     * @param int $pid Wait for status changes of process PID(or any
     *   process if PID is specified as 0 ).
     * @param bool $trace If FALSE, only activate the watcher when the
     *   process terminates. Otherwise(TRUE) additionally activate the
     *   watcher when the process is stopped or continued.
     * @param callable $callback See Watcher callbacks .
     * @param mixed $data Custom data associated with the watcher.
     * @param int $priority Watcher priority
     * @since PECL ev >= 0.2.0
     **/
    public function __construct($pid, $trace, $callback, $data, $priority){}

}
/**
 * Used to embed one event loop into another.
 **/
class EvEmbed extends EvWatcher {
    /**
     * @var mixed
     **/
    public $embed;

    /**
     * Create stopped EvEmbed watcher object
     *
     * The same as EvEmbed::__construct , but doesn't start the watcher
     * automatically.
     *
     * @param object $other The same as for EvEmbed::__construct
     * @param callable $callback See Watcher callbacks .
     * @param mixed $data Custom data associated with the watcher.
     * @param int $priority Watcher priority
     * @return void Returns stopped EvEmbed object on success.
     * @since PECL ev >= 0.2.0
     **/
    final public static function createStopped($other, $callback, $data, $priority){}

    /**
     * Configures the watcher
     *
     * Configures the watcher to use {@link other} event loop object.
     *
     * @param object $other The same as for EvEmbed::__construct
     * @return void
     * @since PECL ev >= 0.2.0
     **/
    public function set($other){}

    /**
     * Make a single, non-blocking sweep over the embedded loop
     *
     * Make a single, non-blocking sweep over the embedded loop. Works
     * similarly to the following, but in the most appropriate way for
     * embedded loops:
     *
     * <?php $other->start(Ev::RUN_NOWAIT); ?>
     *
     * @return void
     * @since PECL ev >= 0.2.0
     **/
    public function sweep(){}

    /**
     * Constructs the EvEmbed object
     *
     * This is a rather advanced watcher type that lets to embed one event
     * loop into another(currently only IO events are supported in the
     * embedded loop, other types of watchers might be handled in a delayed
     * or incorrect fashion and must not be used).
     *
     * See the libev documentation for details.
     *
     * This watcher is most useful on BSD systems without working kqueue to
     * still be able to handle a large number of sockets. See example below.
     *
     * @param object $other Instance of EvLoop . The loop to embed, this
     *   loop must be embeddable(see Ev::embeddableBackends ).
     * @param callable $callback See Watcher callbacks .
     * @param mixed $data Custom data associated with the watcher.
     * @param int $priority Watcher priority
     * @since PECL ev >= 0.2.0
     **/
    public function __construct($other, $callback, $data, $priority){}

}
/**
 * Event class represents and event firing on a file descriptor being
 * ready to read from or write to; a file descriptor becoming ready to
 * read from or write to(edge-triggered I/O only); a timeout expiring; a
 * signal occuring; a user-triggered event. Every event is associated
 * with EventBase . However, event will never fire until it is added (via
 * Event::add ). An added event remains in pending state until the
 * registered event occurs, thus turning it to active state. To handle
 * events user may register a callback which is called when event becomes
 * active. If event is configured persistent , it remains pending. If it
 * is not persistent, it stops being pending when it's callback runs.
 * Event::del method deletes event, thus making it non-pending. By means
 * of Event::add method it could be added again.
 **/
final class Event {
    /**
     * Indicates that the event should be edge-triggered, if the underlying
     * event base backend supports edge-triggered events. This affects the
     * semantics of Event::READ and Event::WRITE .
     *
     * @var integer
     **/
    const ET = 0;

    /**
     * Indicates that the event is persistent. See About event persistence .
     *
     * @var integer
     **/
    const PERSIST = 0;

    /**
     * This flag indicates an event that becomes active when the provided
     * file descriptor(usually a stream resource, or socket) is ready for
     * reading.
     *
     * @var integer
     **/
    const READ = 0;

    /**
     * Used to implement signal detection. See "Constructing signal events"
     * below.
     *
     * @var integer
     **/
    const SIGNAL = 0;

    /**
     * This flag indicates an event that becomes active after a timeout
     * elapses.
     *
     * The Event::TIMEOUT flag is ignored when constructing an event: one can
     * either set a timeout when event is added , or not. It is set in the
     * $what argument to the callback function when a timeout has occurred.
     *
     * @var integer
     **/
    const TIMEOUT = 0;

    /**
     * This flag indicates an event that becomes active when the provided
     * file descriptor(usually a stream resource, or socket) is ready for
     * reading.
     *
     * @var integer
     **/
    const WRITE = 0;

    /**
     * Whether event is pending. See About event persistence .
     *
     * @var bool
     **/
    public $pending;

    /**
     * Makes event pending
     *
     * Marks event pending. Non-pending event will never occur, and the event
     * callback will never be called. In conjuction with Event::del an event
     * could be re-scheduled by user at any time.
     *
     * If Event::add is called on an already pending event, libevent will
     * leave it pending and re-schedule it with the given timeout(if
     * specified). If in this case timeout is not specified, Event::add has
     * no effect.
     *
     * @param float $timeout Timeout in seconds.
     * @return bool Returns TRUE on success. Otherwise FALSE
     * @since PECL event >= 1.2.6-beta
     **/
    public function add($timeout){}

    /**
     * Makes signal event pending
     *
     * Event::addSignal is an alias of Event::add
     *
     * @param float $timeout
     * @return bool
     * @since PECL event >= 1.2.6-beta
     **/
    public function addSignal($timeout){}

    /**
     * Makes timer event pending
     *
     * Event::addTimer is an alias of Event::add
     *
     * @param float $timeout
     * @return bool
     * @since PECL event >= 1.2.6-beta
     **/
    public function addTimer($timeout){}

    /**
     * Makes event non-pending
     *
     * Removes an event from the set of monitored events, i.e. makes it
     * non-pending.
     *
     * @return bool Returns TRUE on success. Otherwise FALSE
     * @since PECL event >= 1.2.6-beta
     **/
    public function del(){}

    /**
     * Makes signal event non-pending
     *
     * Event::delSignal is an alias of Event::del
     *
     * @return bool
     * @since PECL event >= 1.2.6-beta
     **/
    public function delSignal(){}

    /**
     * Makes timer event non-pending
     *
     * Event::delTimer is an alias of Event::del .
     *
     * @return bool
     * @since PECL event >= 1.2.6-beta
     **/
    public function delTimer(){}

    /**
     * Make event non-pending and free resources allocated for this event
     *
     * Removes event from the list of events monitored by libevent, and free
     * resources allocated for the event.
     *
     * @return void
     * @since PECL event >= 1.2.6-beta
     **/
    public function free(){}

    /**
     * Returns array with of the names of the methods supported in this
     * version of Libevent
     *
     * Returns array with of the names of the methods(backends) supported in
     * this version of Libevent.
     *
     * @return array Returns array.
     * @since PECL event >= 1.2.6-beta
     **/
    public static function getSupportedMethods(){}

    /**
     * Detects whether event is pending or scheduled
     *
     * @param int $flags One of, or a composition of the following
     *   constants: Event::READ , Event::WRITE , Event::TIMEOUT ,
     *   Event::SIGNAL .
     * @return bool Returns TRUE if event is pending or scheduled.
     *   Otherwise FALSE.
     * @since PECL event >= 1.2.6-beta
     **/
    public function pending($flags){}

    /**
     * Re-configures event
     *
     * Re-configures event. Note, this function doesn't invoke obsolete
     * libevent's event_set. It calls event_assign instead.
     *
     * @param EventBase $base The event base to associate the event with.
     * @param mixed $fd Stream resource, socket resource, or numeric file
     *   descriptor. For timer events pass -1 . For signal events pass the
     *   signal number, e.g. SIGHUP .
     * @param int $what See Event flags .
     * @param callable $cb The event callback. See Event callbacks .
     * @param mixed $arg Custom data associated with the event. It will be
     *   passed to the callback when the event becomes active.
     * @return bool Returns TRUE on success. Otherwise FALSE.
     * @since PECL event >= 1.2.6-beta
     **/
    public function set($base, $fd, $what, $cb, $arg){}

    /**
     * Set event priority
     *
     * @param int $priority The event priority.
     * @return bool Returns TRUE on success. Otherwise FALSE.
     * @since PECL event >= 1.2.6-beta
     **/
    public function setPriority($priority){}

    /**
     * Re-configures timer event
     *
     * Re-configures timer event. Note, this function doesn't invoke obsolete
     * libevent's event_set . It calls event_assign instead.
     *
     * @param EventBase $base The event base to associate with.
     * @param callable $cb The timer event callback. See Event callbacks .
     * @param mixed $arg Custom data. If specified, it will be passed to
     *   the callback when event triggers.
     * @return bool Returns TRUE on success. Otherwise FALSE.
     * @since PECL event >= 1.2.6-beta
     **/
    public function setTimer($base, $cb, $arg){}

    /**
     * Constructs signal event object
     *
     * Constructs signal event object. This is a straightforward method to
     * create a signal event. Note, the generic Event::__construct method can
     * contruct signal event objects too.
     *
     * @param EventBase $base The associated event base object.
     * @param int $signum The signal number.
     * @param callable $cb The signal event callback. See Event callbacks .
     * @param mixed $arg Custom data. If specified, it will be passed to
     *   the callback when event triggers.
     * @return Event Returns Event object on success. Otherwise FALSE.
     * @since PECL event >= 1.2.6-beta
     **/
    public static function signal($base, $signum, $cb, $arg){}

    /**
     * Constructs timer event object
     *
     * Constructs timer event object. This is a straightforward method to
     * create a timer event. Note, the generic Event::__construct method can
     * contruct signal event objects too.
     *
     * @param EventBase $base The associated event base object.
     * @param callable $cb The signal event callback. See Event callbacks .
     * @param mixed $arg Custom data. If specified, it will be passed to
     *   the callback when event triggers.
     * @return Event Returns Event object on success. Otherwise FALSE.
     * @since PECL event >= 1.2.6-beta
     **/
    public static function timer($base, $cb, $arg){}

    /**
     * Constructs Event object
     *
     * @param EventBase $base The event base to associate with.
     * @param mixed $fd stream resource, socket resource, or numeric file
     *   descriptor. For timer events pass -1 . For signal events pass the
     *   signal number, e.g. SIGHUP .
     * @param int $what Event flags. See Event flags .
     * @param callable $cb The event callback. See Event callbacks .
     * @param mixed $arg Custom data. If specified, it will be passed to
     *   the callback when event triggers.
     * @since PECL event >= 1.2.6-beta
     **/
    public function __construct($base, $fd, $what, $cb, $arg){}

}
/**
 * EventBase class represents libevent's event base structure. It holds a
 * set of events and can poll to determine which events are active. Each
 * event base has a method , or a backend that it uses to determine which
 * events are ready. The recognized methods are: select , poll , epoll ,
 * kqueue , devpoll , evport and win32 . To configure event base to use,
 * or avoid specific backend EventConfig class can be used.
 **/
final class EventBase {
    /**
     * @var integer
     **/
    const EPOLL_USE_CHANGELIST = 0;

    /**
     * @var integer
     **/
    const LOOP_NONBLOCK = 0;

    /**
     * @var integer
     **/
    const LOOP_ONCE = 0;

    /**
     * Configuration flag. Do not allocate a lock for the event base, even if
     * we have locking set up".
     *
     * @var integer
     **/
    const NOLOCK = 0;

    /**
     * @var integer
     **/
    const NO_CACHE_TIME = 0;

    /**
     * @var integer
     **/
    const STARTUP_IOCP = 0;

    /**
     * Dispatch pending events
     *
     * Wait for events to become active, and run their callbacks. The same as
     * EventBase::loop with no flags set.
     *
     * @return void Returns TRUE on success. Otherwise FALSE.
     * @since PECL event >= 1.2.6-beta
     **/
    public function dispatch(){}

    /**
     * Stop dispatching events
     *
     * Tells event base to stop optionally after given number of seconds.
     *
     * @param float $timeout Optional number of seconds after which the
     *   event base should stop dispatching events.
     * @return bool Returns TRUE on success. Otherwise FALSE.
     * @since PECL event >= 1.2.6-beta
     **/
    public function exit($timeout){}

    /**
     * Free resources allocated for this event base
     *
     * Deallocates resources allocated by libevent for the EventBase object.
     *
     * @return void
     * @since PECL event >= 1.10.0
     **/
    public function free(){}

    /**
     * Returns bitmask of features supported
     *
     * @return int Returns integer representing a bitmask of supported
     *   features. See EventConfig::FEATURE_* constants .
     * @since PECL event >= 1.2.6-beta
     **/
    public function getFeatures(){}

    /**
     * Returns event method in use
     *
     * @return string String representing used event method(backend).
     * @since PECL event >= 1.2.6-beta
     **/
    public function getMethod(){}

    /**
     * Returns the current event base time
     *
     * On success returns the current time(as returned by gettimeofday() ),
     * looking at the cached value in base if possible, and calling
     * gettimeofday() or clock_gettime() as appropriate if there is no cached
     * time.
     *
     * @return float Returns the current event base time. On failure
     *   returns NULL.
     * @since PECL event >= 1.2.6-beta
     **/
    public function getTimeOfDayCached(){}

    /**
     * Checks if the event loop was told to exit
     *
     * Checks if the event loop was told to exit by EventBase::exit .
     *
     * @return bool Returns TRUE, event loop was told to exit by
     *   EventBase::exit . Otherwise FALSE.
     * @since PECL event >= 1.2.6-beta
     **/
    public function gotExit(){}

    /**
     * Checks if the event loop was told to exit
     *
     * Checks if the event loop was told to exit by EventBase::stop .
     *
     * @return bool Returns TRUE, event loop was told to stop by
     *   EventBase::stop . Otherwise FALSE.
     * @since PECL event >= 1.2.6-beta
     **/
    public function gotStop(){}

    /**
     * Dispatch pending events
     *
     * Wait for events to become active, and run their callbacks.
     *
     * @param int $flags Optional flags. One of EventBase::LOOP_*
     *   constants. See EventBase constants .
     * @return bool Returns TRUE on success. Otherwise FALSE.
     * @since PECL event >= 1.2.6-beta
     **/
    public function loop($flags){}

    /**
     * Sets number of priorities per event base
     *
     * @param int $n_priorities The number of priorities per event base.
     * @return bool Returns TRUE on success, otherwise FALSE.
     * @since PECL event >= 1.2.6-beta
     **/
    public function priorityInit($n_priorities){}

    /**
     * Re-initialize event base(after a fork)
     *
     * Re-initialize event base. Should be called after a fork.
     *
     * @return bool Returns TRUE on success. Otherwise FALSE.
     * @since PECL event >= 1.2.6-beta
     **/
    public function reInit(){}

    /**
     * Tells event_base to stop dispatching events
     *
     * @return bool Returns TRUE on success. Otherwise FALSE.
     * @since PECL event >= 1.2.6-beta
     **/
    public function stop(){}

    /**
     * Constructs EventBase object
     *
     * @param EventConfig $cfg Optional EventConfig object.
     * @since PECL event >= 1.2.6-beta
     **/
    public function __construct($cfg){}

}
/**
 * EventBuffer represents Libevent's "evbuffer", an utility functionality
 * for buffered I/O. Event buffers are meant to be generally useful for
 * doing the "buffer" part of buffered network I/O.
 **/
class EventBuffer {
    /**
     * @var integer
     **/
    const EOL_ANY = 0;

    /**
     * @var integer
     **/
    const EOL_CRLF = 0;

    /**
     * @var integer
     **/
    const EOL_CRLF_STRICT = 0;

    /**
     * @var integer
     **/
    const EOL_LF = 0;

    /**
     * @var integer
     **/
    const PTR_ADD = 0;

    /**
     * @var integer
     **/
    const PTR_SET = 0;

    /**
     * @var int
     **/
    public $contiguous_space;

    /**
     * The number of bytes stored in an event buffer.
     *
     * @var int
     **/
    public $length;

    /**
     * Append data to the end of an event buffer
     *
     * @param string $data String to be appended to the end of the buffer.
     * @return bool Returns TRUE on success. Otherwise FALSE.
     * @since PECL event >= 1.2.6-beta
     **/
    public function add($data){}

    /**
     * Move all data from a buffer provided to the current instance of
     * EventBuffer
     *
     * Move all data from the buffer provided in {@link buf} parameter to the
     * end of current EventBuffer . This is a destructive add. The data from
     * one buffer moves into the other buffer. However, no unnecessary memory
     * copies occur.
     *
     * @param EventBuffer $buf The source EventBuffer object.
     * @return bool Returns TRUE on success. Otherwise FALSE.
     * @since PECL event >= 1.2.6-beta
     **/
    public function addBuffer($buf){}

    /**
     * Moves the specified number of bytes from a source buffer to the end of
     * the current buffer
     *
     * Moves the specified number of bytes from a source buffer to the end of
     * the current buffer. If there are fewer number of bytes, it moves all
     * the bytes available from the source buffer.
     *
     * @param EventBuffer $buf Source buffer.
     * @param int $len
     * @return int Returns the number of bytes read.
     * @since PECL event >= 1.6.0
     **/
    public function appendFrom($buf, $len){}

    /**
     * Copies out specified number of bytes from the front of the buffer
     *
     * Behaves just like EventBuffer::read , but does not drain any data from
     * the buffer. I.e. it copies the first {@link max_bytes} bytes from the
     * front of the buffer into {@link data} . If there are fewer than {@link
     * max_bytes} bytes available, the function copies all the bytes there
     * are.
     *
     * @param string $data Output string.
     * @param int $max_bytes The number of bytes to copy.
     * @return int Returns the number of bytes copied, or -1 on failure.
     * @since PECL event >= 1.2.6-beta
     **/
    public function copyout(&$data, $max_bytes){}

    /**
     * Removes specified number of bytes from the front of the buffer without
     * copying it anywhere
     *
     * Behaves as EventBuffer::read , except that it does not copy the data:
     * it just removes it from the front of the buffer.
     *
     * @param int $len The number of bytes to remove from the buffer.
     * @return bool Returns TRUE on success. Otherwise FALSE.
     * @since PECL event >= 1.2.6-beta
     **/
    public function drain($len){}

    /**
     * Enable locking on an EventBuffer so that it can safely be used by
     * multiple threads at the same time. When locking is enabled, the lock
     * will be held when callbacks are invoked. This could result in deadlock
     * if you aren't careful. Plan accordingly!
     *
     * @return void
     * @since PECL event >= 1.2.6-beta
     **/
    public function enableLocking(){}

    /**
     * Reserves space in buffer
     *
     * Alters the last chunk of memory in the buffer, or adds a new chunk,
     * such that the buffer is now large enough to contain {@link len} bytes
     * without any further allocations.
     *
     * @param int $len The number of bytes to reserve for the buffer
     * @return bool Returns TRUE on success. Otherwise FALSE.
     * @since PECL event >= 1.2.6-beta
     **/
    public function expand($len){}

    /**
     * Prevent calls that modify an event buffer from succeeding
     *
     * @param bool $at_front Whether to disable changes to the front or end
     *   of the buffer.
     * @return bool Returns TRUE on success. Otherwise FALSE.
     * @since PECL event >= 1.2.6-beta
     **/
    public function freeze($at_front){}

    /**
     * Acquires a lock on buffer
     *
     * Acquires a lock on buffer. Can be used in pair with
     * EventBuffer::unlock to make a set of operations atomic, i.e.
     * thread-safe. Note, it is not needed to lock buffers for individual
     * operations. When locking is enabled(see EventBuffer::enableLocking ),
     * individual operations on event buffers are already atomic.
     *
     * @return void
     * @since PECL event >= 1.2.6-beta
     **/
    public function lock(){}

    /**
     * Prepend data to the front of the buffer
     *
     * @param string $data String to be prepended to the front of the
     *   buffer.
     * @return bool Returns TRUE on success. Otherwise FALSE.
     * @since PECL event >= 1.2.6-beta
     **/
    public function prepend($data){}

    /**
     * Moves all data from source buffer to the front of current buffer
     *
     * Behaves as EventBuffer::addBuffer , except that it moves data to the
     * front of the buffer.
     *
     * @param EventBuffer $buf Source buffer.
     * @return bool Returns TRUE on success. Otherwise FALSE.
     * @since PECL event >= 1.2.6-beta
     **/
    public function prependBuffer($buf){}

    /**
     * Linearizes data within buffer and returns it's contents as a string
     *
     * "Linearizes" the first {@link size} bytes of the buffer, copying or
     * moving them as needed to ensure that they are all contiguous and
     * occupying the same chunk of memory. If size is negative, the function
     * linearizes the entire buffer.
     *
     * @param int $size The number of bytes required to be contiguous
     *   within the buffer.
     * @return string If {@link size} is greater than the number of bytes
     *   in the buffer, the function returns NULL. Otherwise,
     *   EventBuffer::pullup returns string.
     * @since PECL event >= 1.2.6-beta
     **/
    public function pullup($size){}

    /**
     * Read data from a file onto the end of the buffer
     *
     * Read data from the file specified by {@link fd} onto the end of the
     * buffer.
     *
     * @param mixed $fd Socket resource, stream, or numeric file
     *   descriptor.
     * @param int $howmuch Maxmimum number of bytes to read.
     * @return int Returns the number of bytes read, or FALSE on failure.
     * @since PECL event >= 1.6.0
     **/
    public function read($fd, $howmuch){}

    /**
     * Extracts a line from the front of the buffer
     *
     * Extracts a line from the front of the buffer and returns it in a newly
     * allocated string. If there is not a whole line to read, the function
     * returns NULL. The line terminator is not included in the copied
     * string.
     *
     * @param int $eol_style One of EventBuffer:EOL_* constants .
     * @return string On success returns the line read from the buffer,
     *   otherwise NULL.
     * @since PECL event >= 1.2.6-beta
     **/
    public function readLine($eol_style){}

    /**
     * Scans the buffer for an occurrence of a string
     *
     * Scans the buffer for an occurrence of the string {@link what} . It
     * returns numeric position of the string, or FALSE if the string was not
     * found.
     *
     * If the {@link start} argument is provided, it points to the position
     * at which the search should begin; otherwise, the search is performed
     * from the start of the string. If {@link end} argument provided, the
     * search is performed between start and end buffer positions.
     *
     * @param string $what String to search.
     * @param int $start Start search position.
     * @param int $end End search position.
     * @return mixed Returns numeric position of the first occurance of the
     *   string in the buffer, or FALSE if string is not found.
     * @since PECL event >= 1.2.6-beta
     **/
    public function search($what, $start, $end){}

    /**
     * Scans the buffer for an occurrence of an end of line
     *
     * Scans the buffer for an occurrence of an end of line specified by
     * {@link eol_style} parameter . It returns numeric position of the
     * string, or FALSE if the string was not found.
     *
     * If the {@link start} argument is provided, it represents the position
     * at which the search should begin; otherwise, the search is performed
     * from the start of the string. If {@link end} argument provided, the
     * search is performed between start and end buffer positions.
     *
     * @param int $start Start search position.
     * @param int $eol_style One of EventBuffer:EOL_* constants .
     * @return mixed Returns numeric position of the first occurance of
     *   end-of-line symbol in the buffer, or FALSE if not found.
     * @since PECL event >= 1.5.0
     **/
    public function searchEol($start, $eol_style){}

    /**
     * Substracts a portion of the buffer data
     *
     * Substracts up to {@link length} bytes of the buffer data beginning at
     * {@link start} position.
     *
     * @param int $start The start position of data to be substracted.
     * @param int $length Maximum number of bytes to substract.
     * @return string Returns the data substracted as a string on success,
     *   or FALSE on failure.
     * @since PECL event >= 1.6.0
     **/
    public function substr($start, $length){}

    /**
     * Re-enable calls that modify an event buffer
     *
     * @param bool $at_front Whether to enable events at the front or at
     *   the end of the buffer.
     * @return bool Returns TRUE on success. Otherwise FALSE.
     * @since PECL event >= 1.2.6-beta
     **/
    public function unfreeze($at_front){}

    /**
     * Releases lock acquired by EventBuffer::lock
     *
     * Releases lock acquired by EventBuffer::lock .
     *
     * @return bool Returns TRUE on success. Otherwise FALSE.
     * @since PECL event >= 1.2.6-beta
     **/
    public function unlock(){}

    /**
     * Write contents of the buffer to a file or socket
     *
     * Write contents of the buffer to a file descriptor. The buffer will be
     * drained after the bytes have been successfully written.
     *
     * @param mixed $fd Socket resource, stream or numeric file descriptor
     *   associated normally associated with a socket.
     * @param int $howmuch The maximum number of bytes to write.
     * @return int Returns the number of bytes written, or FALSE on error.
     * @since PECL event >= 1.6.0
     **/
    public function write($fd, $howmuch){}

    /**
     * Constructs EventBuffer object
     *
     * @since PECL event >= 1.2.6-beta
     **/
    public function __construct(){}

}
/**
 * Represents Libevents buffer event. Usually an application wants to
 * perform some amount of data buffering in addition to just responding
 * to events. When we want to write data, for example, the usual pattern
 * looks like: This buffered I/O pattern is common enough that Libevent
 * provides a generic mechanism for it. A "buffer event" consists of an
 * underlying transport (like a socket), a read buffer, and a write
 * buffer. Instead of regular events, which give callbacks when the
 * underlying transport is ready to be read or written, a buffer event
 * invokes its user-supplied callbacks when it has read or written enough
 * data.
 **/
final class EventBufferEvent {
    /**
     * Finished a requested connection on the bufferevent.
     *
     * @var integer
     **/
    const CONNECTED = 0;

    /**
     * Got an end-of-file indication on the buffer event.
     *
     * @var integer
     **/
    const EOF = 0;

    /**
     * An error occurred during a bufferevent operation. For more information
     * on what the error was, call EventUtil::getLastSocketErrno and/or
     * EventUtil::getLastSocketError .
     *
     * @var integer
     **/
    const ERROR = 0;

    /**
     * @var integer
     **/
    const OPT_CLOSE_ON_FREE = 0;

    /**
     * @var integer
     **/
    const OPT_DEFER_CALLBACKS = 0;

    /**
     * @var integer
     **/
    const OPT_THREADSAFE = 0;

    /**
     * @var integer
     **/
    const OPT_UNLOCK_CALLBACKS = 0;

    /**
     * An event occurred during a read operation on the bufferevent. See the
     * other flags for which event it was.
     *
     * @var integer
     **/
    const READING = 0;

    /**
     * @var integer
     **/
    const SSL_ACCEPTING = 0;

    /**
     * @var integer
     **/
    const SSL_CONNECTING = 0;

    /**
     * @var integer
     **/
    const SSL_OPEN = 0;

    /**
     * @var integer
     **/
    const TIMEOUT = 0;

    /**
     * An event occurred during a write operation on the bufferevent. See the
     * other flags for which event it was.
     *
     * @var integer
     **/
    const WRITING = 0;

    /**
     * Numeric file descriptor associated with the buffer event. Normally
     * represents a bound socket. Equals to NULL, if there is no file
     * descriptor(socket) associated with the buffer event.
     *
     * @var integer
     **/
    public $fd;

    /**
     * Underlying input buffer object( EventBuffer )
     *
     * @var EventBuffer
     **/
    public $input;

    /**
     * Underlying output buffer object( EventBuffer )
     *
     * @var EventBuffer
     **/
    public $output;

    /**
     * The priority of the events used to implement the buffer event.
     *
     * @var integer
     **/
    public $priority;

    /**
     * Closes file descriptor associated with the current buffer event
     *
     * This method may be used in cases when the
     * EventBufferEvent::OPT_CLOSE_ON_FREE option is not appropriate.
     *
     * @return void
     * @since PECL event >= 1.10.0
     **/
    public function close(){}

    /**
     * Connect buffer events file descriptor to given address or UNIX socket
     *
     * Connect buffer events file descriptor to given address(optionally with
     * port), or a UNIX domain socket.
     *
     * If socket is not assigned to the buffer event, this function allocates
     * a new socket and makes it non-blocking internally.
     *
     * To resolve DNS names(asyncronously), use EventBufferEvent::connectHost
     * method.
     *
     * @param string $addr Should contain an IP address with optional port
     *   number, or a path to UNIX domain socket. Recognized formats are:
     *   
     *   [IPv6Address]:port [IPv6Address] IPv6Address IPv4Address:port
     *   IPv4Address unix:path
     *   
     *   Note, 'unix:' prefix is currently not case sensitive.
     * @return bool Returns TRUE on success. Otherwise FALSE.
     * @since PECL event >= 1.2.6-beta
     **/
    public function connect($addr){}

    /**
     * Connects to a hostname with optionally asyncronous DNS resolving
     *
     * Resolves the DNS name hostname, looking for addresses of type {@link
     * family} ( EventUtil::AF_* constants). If the name resolution fails, it
     * invokes the event callback with an error event. If it succeeds, it
     * launches a connection attempt just as EventBufferEvent::connect would.
     *
     * {@link dns_base} is optional. May be NULL, or an object created with
     * EventDnsBase::__construct . For asyncronous hostname resolving pass a
     * valid event dns base resource. Otherwise the hostname resolving will
     * block.
     *
     * @param EventDnsBase $dns_base Object of EventDnsBase in case if DNS
     *   is to be resolved asyncronously. Otherwise NULL.
     * @param string $hostname Hostname to connect to. Recognized formats
     *   are:
     *   
     *   www.example.com (hostname) 1.2.3.4 (ipv4address) ::1 (ipv6address)
     *   [::1] ([ipv6address])
     * @param int $port Port number
     * @param int $family Address family. EventUtil::AF_UNSPEC ,
     *   EventUtil::AF_INET , or EventUtil::AF_INET6 . See EventUtil
     *   constants .
     * @return bool Returns TRUE on success. Otherwise FALSE.
     * @since PECL event >= 1.2.6-beta
     **/
    public function connectHost($dns_base, $hostname, $port, $family){}

    /**
     * Creates two buffer events connected to each other
     *
     * Returns array of two EventBufferEvent objects connected to each other.
     * All the usual options are supported, except for
     * EventBufferEvent::OPT_CLOSE_ON_FREE , which has no effect, and
     * EventBufferEvent::OPT_DEFER_CALLBACKS , which is always on.
     *
     * @param EventBase $base Associated event base
     * @param int $options EventBufferEvent::OPT_* constants combined with
     *   bitwise OR operator.
     * @return array Returns array of two EventBufferEvent objects
     *   connected to each other.
     * @since PECL event >= 1.2.6-beta
     **/
    public static function createPair($base, $options){}

    /**
     * Disable events read, write, or both on a buffer event
     *
     * Disable events Event::READ , Event::WRITE , or Event::READ |
     * Event::WRITE on a buffer event.
     *
     * @param int $events
     * @return bool Returns TRUE on success. Otherwise FALSE.
     * @since PECL event >= 1.2.6-beta
     **/
    public function disable($events){}

    /**
     * Enable events read, write, or both on a buffer event
     *
     * Enable events Event::READ , Event::WRITE , or Event::READ |
     * Event::WRITE on a buffer event.
     *
     * @param int $events Event::READ , Event::WRITE , or Event::READ |
     *   Event::WRITE on a buffer event.
     * @return bool Returns TRUE on success. Otherwise FALSE.
     * @since PECL event >= 1.2.6-beta
     **/
    public function enable($events){}

    /**
     * Free a buffer event
     *
     * Free resources allocated by buffer event.
     *
     * Usually there is no need to call this method, since normally it is
     * done within internal object destructors. However, sometimes we have a
     * long-time script allocating lots of instances, or a script with a
     * heavy memory usage, where we need to free resources as soon as
     * possible. In such cases EventBufferEvent::free may be used to protect
     * the script against running up to the memory_limit .
     *
     * @return void
     * @since PECL event >= 1.2.6-beta
     **/
    public function free(){}

    /**
     * Returns string describing the last failed DNS lookup attempt
     *
     * Returns string describing the last failed DNS lookup attempt made by
     * EventBufferEvent::connectHost , or an empty string, if there is no DNS
     * error detected.
     *
     * @return string Returns a string describing DNS lookup error, or an
     *   empty string for no error.
     * @since PECL event >= 1.2.6-beta
     **/
    public function getDnsErrorString(){}

    /**
     * Returns bitmask of events currently enabled on the buffer event
     *
     * @return int Returns integer representing a bitmask of events
     *   currently enabled on the buffer event
     * @since PECL event >= 1.2.6-beta
     **/
    public function getEnabled(){}

    /**
     * Returns underlying input buffer associated with current buffer event
     *
     * Returns underlying input buffer associated with current buffer event.
     * An input buffer is a storage for data to read.
     *
     * Note, there is also input property of EventBufferEvent class.
     *
     * @return EventBuffer Returns instance of EventBuffer input buffer
     *   associated with current buffer event.
     * @since PECL event >= 1.2.6-beta
     **/
    public function getInput(){}

    /**
     * Returns underlying output buffer associated with current buffer event
     *
     * Returns underlying output buffer associated with current buffer event.
     * An output buffer is a storage for data to be written.
     *
     * Note, there is also output property of EventBufferEvent class.
     *
     * @return EventBuffer Returns instance of EventBuffer output buffer
     *   associated with current buffer event.
     * @since PECL event >= 1.2.6-beta
     **/
    public function getOutput(){}

    /**
     * Read buffers data
     *
     * Removes up to {@link size} bytes from the input buffer. Returns a
     * string of data read from the input buffer.
     *
     * @param int $size Maximum number of bytes to read
     * @return string Returns string of data read from the input buffer.
     * @since PECL event >= 1.2.6-beta
     **/
    public function read($size){}

    /**
     * Drains the entire contents of the input buffer and places them into
     * buf
     *
     * Drains the entire contents of the input buffer and places them into
     * {@link buf} .
     *
     * @param EventBuffer $buf Target buffer
     * @return bool Returns TRUE on success; Otherwise FALSE.
     * @since PECL event >= 1.2.6-beta
     **/
    public function readBuffer($buf){}

    /**
     * Assigns read, write and event(status) callbacks
     *
     * @param callable $readcb Read event callback. See About buffer event
     *   callbacks .
     * @param callable $writecb Write event callback. See About buffer
     *   event callbacks .
     * @param callable $eventcb Status-change event callback. See About
     *   buffer event callbacks .
     * @param string $arg A variable that will be passed to all the
     *   callbacks.
     * @return void
     * @since PECL event >= 1.2.6-beta
     **/
    public function setCallbacks($readcb, $writecb, $eventcb, $arg){}

    /**
     * Assign a priority to a bufferevent
     *
     * @param int $priority Priority value.
     * @return bool Returns TRUE on success. Otherwise FALSE.
     * @since PECL event >= 1.2.6-beta
     **/
    public function setPriority($priority){}

    /**
     * Set the read and write timeout for a buffer event
     *
     * @param float $timeout_read Read timeout
     * @param float $timeout_write Write timeout
     * @return bool Returns TRUE on success. Otherwise FALSE.
     * @since PECL event >= 1.2.6-beta
     **/
    public function setTimeouts($timeout_read, $timeout_write){}

    /**
     * Adjusts read and/or write watermarks
     *
     * Adjusts the read watermarks, the write watermarks , or both, of a
     * single buffer event.
     *
     * A buffer event watermark is an edge, a value specifying number of
     * bytes to be read or written before callback is invoked. By default
     * every read/write event triggers a callback invokation. See Fast
     * portable non-blocking network programming with Libevent: Callbacks and
     * watermarks
     *
     * @param int $events Bitmask of Event::READ , Event::WRITE , or both.
     * @param int $lowmark Minimum watermark value.
     * @param int $highmark Maximum watermark value. 0 means "unlimited".
     * @return void
     * @since PECL event >= 1.2.6-beta
     **/
    public function setWatermark($events, $lowmark, $highmark){}

    /**
     * Returns most recent OpenSSL error reported on the buffer event
     *
     * @return string Returns OpenSSL error string reported on the buffer
     *   event, or FALSE, if there is no more error to return.
     * @since PECL event >= 1.2.6-beta
     **/
    public function sslError(){}

    /**
     * Create a new SSL buffer event to send its data over another buffer
     * event
     *
     * @param EventBase $base Associated event base.
     * @param EventBufferEvent $underlying A socket buffer event to use for
     *   this SSL.
     * @param EventSslContext $ctx Object of EventSslContext class.
     * @param int $state The current state of SSL connection:
     *   EventBufferEvent::SSL_OPEN , EventBufferEvent::SSL_ACCEPTING or
     *   EventBufferEvent::SSL_CONNECTING .
     * @param int $options One or more buffer event options.
     * @return EventBufferEvent Returns a new SSL EventBufferEvent object.
     * @since PECL event >= 1.2.6-beta
     **/
    public static function sslFilter($base, $underlying, $ctx, $state, $options){}

    /**
     * Returns a textual description of the cipher
     *
     * Retrieves description of the current cipher by means of the
     * SSL_CIPHER_description SSL API function (see SSL_CIPHER_get_name(3)
     * man page).
     *
     * @return string Returns a textual description of the cipher on
     *   success, or FALSE on error.
     * @since PECL event >= 1.10.0
     **/
    public function sslGetCipherInfo(){}

    /**
     * Returns the current cipher name of the SSL connection
     *
     * Retrieves name of cipher used by current SSL connection.
     *
     * @return string Returns the current cipher name of the SSL
     *   connection, or FALSE on error.
     * @since PECL event >= 1.10.0
     **/
    public function sslGetCipherName(){}

    /**
     * Returns version of cipher used by current SSL connection
     *
     * Retrieves version of cipher used by current SSL connection.
     *
     * @return string Returns the current cipher version of the SSL
     *   connection, or FALSE on error.
     * @since PECL event >= 1.10.0
     **/
    public function sslGetCipherVersion(){}

    /**
     * Returns the name of the protocol used for current SSL connection
     *
     * @return string Returns the name of the protocol used for current SSL
     *   connection.
     * @since PECL event >= 1.10.0
     **/
    public function sslGetProtocol(){}

    /**
     * Tells a bufferevent to begin SSL renegotiation
     *
     * @return void
     * @since PECL event >= 1.2.6-beta
     **/
    public function sslRenegotiate(){}

    /**
     * Creates a new SSL buffer event to send its data over an SSL on a
     * socket
     *
     * @param EventBase $base Associated event base.
     * @param mixed $socket Socket to use for this SSL. Can be stream or
     *   socket resource, numeric file descriptor, or NULL. If {@link socket}
     *   is NULL, it is assumed that the file descriptor for the socket will
     *   be assigned later, for instance, by means of
     *   EventBufferEvent::connectHost method.
     * @param EventSslContext $ctx Object of EventSslContext class.
     * @param int $state The current state of SSL connection:
     *   EventBufferEvent::SSL_OPEN , EventBufferEvent::SSL_ACCEPTING or
     *   EventBufferEvent::SSL_CONNECTING .
     * @param int $options The buffer event options.
     * @return EventBufferEvent Returns EventBufferEvent object.
     * @since PECL event >= 1.2.6-beta
     **/
    public static function sslSocket($base, $socket, $ctx, $state, $options){}

    /**
     * Adds data to a buffer events output buffer
     *
     * Adds {@link data} to a buffer events output buffer
     *
     * @param string $data Data to be added to the underlying buffer.
     * @return bool Returns TRUE on success. Otherwise FALSE.
     * @since PECL event >= 1.2.6-beta
     **/
    public function write($data){}

    /**
     * Adds contents of the entire buffer to a buffer events output buffer
     *
     * Adds contents of the entire buffer to a buffer events output buffer
     *
     * @param EventBuffer $buf Source EventBuffer object.
     * @return bool Returns TRUE on success. Otherwise FALSE.
     * @since PECL event >= 1.2.6-beta
     **/
    public function writeBuffer($buf){}

    /**
     * Constructs EventBufferEvent object
     *
     * Create a buffer event on a socket, stream or a file descriptor.
     * Passing NULL to {@link socket} means that the socket should be created
     * later, e.g. by means of EventBufferEvent::connect .
     *
     * @param EventBase $base Event base that should be associated with the
     *   new buffer event.
     * @param mixed $socket May be created as a stream(not necessarily by
     *   means of sockets extension)
     * @param int $options One of EventBufferEvent::OPT_* constants , or 0
     *   .
     * @param callable $readcb Read event callback. See About buffer event
     *   callbacks .
     * @param callable $writecb Write event callback. See About buffer
     *   event callbacks .
     * @param callable $eventcb Status-change event callback. See About
     *   buffer event callbacks .
     * @since PECL event >= 1.2.6-beta
     **/
    public function __construct($base, $socket, $options, $readcb, $writecb, $eventcb){}

}
/**
 * Represents configuration structure which could be used in construction
 * of the EventBase .
 **/
final class EventConfig {
    /**
     * @var integer
     **/
    const FEATURE_ET = 0;

    /**
     * @var integer
     **/
    const FEATURE_FDS = 0;

    /**
     * @var integer
     **/
    const FEATURE_O1 = 0;

    /**
     * Tells libevent to avoid specific event method
     *
     * Tells libevent to avoid specific event method(backend). See Creating
     * an event base .
     *
     * @param string $method The backend method to avoid. See EventConfig
     *   constants .
     * @return bool Returns TRUE on success, otherwise FALSE.
     * @since PECL event >= 1.2.6-beta
     **/
    public function avoidMethod($method){}

    /**
     * Enters a required event method feature that the application demands
     *
     * @param int $feature Bitmask of required features. See
     *   EventConfig::FEATURE_* constants
     * @return bool
     * @since PECL event >= 1.2.6-beta
     **/
    public function requireFeatures($feature){}

    /**
     * Prevents priority inversion
     *
     * Prevents priority inversion by limiting how many low-priority event
     * callbacks can be invoked before checking for more high-priority
     * events.
     *
     * @param int $max_interval An interval after which Libevent should
     *   stop running callbacks and check for more events, or 0 , if there
     *   should be no such interval.
     * @param int $max_callbacks A number of callbacks after which Libevent
     *   should stop running callbacks and check for more events, or -1 , if
     *   there should be no such limit.
     * @param int $min_priority A priority below which {@link max_interval}
     *   and {@link max_callbacks} should not be enforced. If this is set to
     *   0 , they are enforced for events of every priority; if its set to 1
     *   , theyre enforced for events of priority 1 and above, and so on.
     * @return void Returns TRUE on success, otherwise FALSE.
     **/
    public function setMaxDispatchInterval($max_interval, $max_callbacks, $min_priority){}

    /**
     * Constructs EventConfig object
     *
     * Constructs EventConfig object which could be passed to
     * EventBase::__construct constructor.
     *
     * @since PECL event >= 1.2.6-beta
     **/
    public function __construct(){}

}
/**
 * Represents Libevents DNS base structure. Used to resolve DNS
 * asyncronously, parse configuration files like resolv.conf etc.
 **/
final class EventDnsBase {
    /**
     * @var integer
     **/
    const OPTIONS_ALL = 0;

    /**
     * @var integer
     **/
    const OPTION_HOSTSFILE = 0;

    /**
     * @var integer
     **/
    const OPTION_MISC = 0;

    /**
     * @var integer
     **/
    const OPTION_NAMESERVERS = 0;

    /**
     * @var integer
     **/
    const OPTION_SEARCH = 0;

    /**
     * Adds a nameserver to the DNS base
     *
     * Adds a nameserver to the evdns_base.
     *
     * @param string $ip The nameserver string, either as an IPv4 address,
     *   an IPv6 address, an IPv4 address with a port ( IPv4:Port ), or an
     *   IPv6 address with a port ( [IPv6]:Port ).
     * @return bool Returns TRUE on success. Otherwise FALSE.
     * @since PECL event >= 1.2.6-beta
     **/
    public function addNameserverIp($ip){}

    /**
     * Adds a domain to the list of search domains
     *
     * @param string $domain Search domain.
     * @return void
     * @since PECL event >= 1.2.6-beta
     **/
    public function addSearch($domain){}

    /**
     * Removes all current search suffixes
     *
     * Removes all current search suffixes from the DNS base; the
     * EventDnsBase::addSearch function adds a suffix.
     *
     * @return void
     * @since PECL event >= 1.2.6-beta
     **/
    public function clearSearch(){}

    /**
     * Gets the number of configured nameservers
     *
     * @return int Returns the number of configured nameservers(not
     *   necessarily the number of running nameservers). This is useful for
     *   double-checking whether our calls to the various nameserver
     *   configuration functions have been successful.
     * @since PECL event >= 1.2.6-beta
     **/
    public function countNameservers(){}

    /**
     * Loads a hosts file (in the same format as /etc/hosts) from hosts file
     *
     * Loads a hosts file (in the same format as /etc/hosts ) from hosts
     * file.
     *
     * @param string $hosts Path to the hosts' file.
     * @return bool Returns TRUE on success. Otherwise FALSE.
     * @since PECL event >= 1.2.6-beta
     **/
    public function loadHosts($hosts){}

    /**
     * Scans the resolv.conf-formatted file
     *
     * Scans the resolv.conf-formatted file stored in filename, and read in
     * all the options from it that are listed in flags
     *
     * @param int $flags Determines what information is parsed from the
     *   resolv.conf file. See the man page for resolv.conf for the format of
     *   this file. The following directives are not parsed from the file:
     *   sortlist, rotate, no-check-names, inet6, debug . If this function
     *   encounters an error, the possible return values are: 1 = failed to
     *   open file 2 = failed to stat file 3 = file too large 4 = out of
     *   memory 5 = short read from file 6 = no nameservers listed in the
     *   file
     * @param string $filename Path to resolv.conf file.
     * @return bool Returns TRUE on success. Otherwise FALSE.
     * @since PECL event >= 1.2.6-beta
     **/
    public function parseResolvConf($flags, $filename){}

    /**
     * Set the value of a configuration option
     *
     * @param string $option The currently available configuration options
     *   are: "ndots" , "timeout" , "max-timeouts" , "max-inflight" , and
     *   "attempts" .
     * @param string $value Option value.
     * @return bool Returns TRUE on success. Otherwise FALSE.
     * @since PECL event >= 1.2.6-beta
     **/
    public function setOption($option, $value){}

    /**
     * Set the 'ndots' parameter for searches
     *
     * Set the 'ndots' parameter for searches. Sets the number of dots which,
     * when found in a name, causes the first query to be without any search
     * domain.
     *
     * @param int $ndots The number of dots.
     * @return bool Returns TRUE on success. Otherwise FALSE.
     * @since PECL event >= 1.2.6-beta
     **/
    public function setSearchNdots($ndots){}

    /**
     * Constructs EventDnsBase object
     *
     * @param EventBase $base Event base.
     * @param bool $initialize If the {@link initialize} argument is TRUE,
     *   it tries to configure the DNS base sensibly given your operating
     *   system’s default. Otherwise, it leaves the event DNS base empty,
     *   with no nameservers or options configured. In the latter case DNS
     *   base should be configured manually, e.g. with
     *   EventDnsBase::parseResolvConf .
     * @since PECL event >= 1.2.6-beta
     **/
    public function __construct($base, $initialize){}

}
/**
 * Represents HTTP server.
 **/
final class EventHttp {
    /**
     * Makes an HTTP server accept connections on the specified socket stream
     * or resource
     *
     * Makes an HTTP server accept connections on the specified socket stream
     * or resource. The socket should be ready to accept connections.
     *
     * Can be called multiple times to accept connections on different
     * sockets.
     *
     * @param mixed $socket Socket resource, stream or numeric file
     *   descriptor representing a socket ready to accept connections.
     * @return bool Returns TRUE on success. Otherwise FALSE.
     * @since PECL event >= 1.2.6-beta
     **/
    public function accept($socket){}

    /**
     * Adds a server alias to the HTTP server object
     *
     * @param string $alias The alias to add.
     * @return bool Returns TRUE on success. Otherwise FALSE.
     * @since PECL event >= 1.4.0-beta
     **/
    public function addServerAlias($alias){}

    /**
     * Binds an HTTP server on the specified address and port
     *
     * Can be called multiple times to bind the same HTTP server to multiple
     * different ports.
     *
     * @param string $address A string containing the IP address to
     *   listen(2) on.
     * @param int $port The port number to listen on.
     * @return void Returns TRUE on success. Otherwise FALSE.
     * @since PECL event >= 1.2.6-beta
     **/
    public function bind($address, $port){}

    /**
     * Removes server alias
     *
     * Removes server alias added with EventHttp::addServerAlias
     *
     * @param string $alias The alias to remove.
     * @return bool Returns TRUE on success. Otherwise FALSE.
     * @since PECL event >= 1.4.0-beta
     **/
    public function removeServerAlias($alias){}

    /**
     * Sets the what HTTP methods are supported in requests accepted by this
     * server, and passed to user callbacks
     *
     * Sets the what HTTP methods are supported in requests accepted by this
     * server, and passed to user callbacks
     *
     * If not supported they will generate a "405 Method not allowed"
     * response.
     *
     * By default this includes the following methods: GET , POST , HEAD ,
     * PUT , DELETE . See EventHttpRequest::CMD_* constants.
     *
     * @param int $methods A bit mask of EventHttpRequest::CMD_* constants
     *   .
     * @return void
     * @since PECL event >= 1.4.0-beta
     **/
    public function setAllowedMethods($methods){}

    /**
     * Sets a callback for specified URI
     *
     * @param string $path The path for which to invoke the callback.
     * @param string $cb The callback callable that gets invoked on
     *   requested {@link path} . It should match the following prototype:
     *   
     *   {@link req} EventHttpRequest object. {@link arg} Custom data.
     * @param string $arg EventHttpRequest object.
     * @return void Returns TRUE on success. Otherwise FALSE.
     * @since PECL event >= 1.4.0-beta
     **/
    public function setCallback($path, $cb, $arg){}

    /**
     * Sets default callback to handle requests that are not caught by
     * specific callbacks
     *
     * Sets default callback to handle requests that are not caught by
     * specific callbacks
     *
     * @param string $cb The callback callable . It should match the
     *   following prototype:
     *   
     *   {@link req} EventHttpRequest object. {@link arg} Custom data.
     * @param string $arg EventHttpRequest object.
     * @return void Returns TRUE on success. Otherwise FALSE.
     * @since PECL event >= 1.4.0-beta
     **/
    public function setDefaultCallback($cb, $arg){}

    /**
     * Sets maximum request body size
     *
     * @param int $value The body size in bytes.
     * @return void
     * @since PECL event >= 1.4.0-beta
     **/
    public function setMaxBodySize($value){}

    /**
     * Sets maximum HTTP header size
     *
     * @param int $value The header size in bytes.
     * @return void
     * @since PECL event >= 1.4.0-beta
     **/
    public function setMaxHeadersSize($value){}

    /**
     * Sets the timeout for an HTTP request
     *
     * @param int $value The timeout in seconds.
     * @return void
     * @since PECL event >= 1.4.0-beta
     **/
    public function setTimeout($value){}

    /**
     * Constructs EventHttp object(the HTTP server)
     *
     * Constructs the HTTP server object.
     *
     * @param EventBase $base Associated event base.
     * @param EventSslContext $ctx EventSslContext class object. Turns
     *   plain HTTP server into HTTPS server. It means that if {@link ctx} is
     *   configured correctly, then the underlying buffer events will be
     *   based on OpenSSL sockets. Thus, all traffic will pass through the
     *   SSL or TLS.
     * @since PECL event >= 1.2.6-beta
     **/
    public function __construct($base, $ctx){}

}
/**
 * Represents an HTTP connection.
 **/
class EventHttpConnection {
    /**
     * Returns event base associated with the connection
     *
     * @return EventBase On success returns EventBase object associated
     *   with the connection. Otherwise FALSE.
     * @since PECL event >= 1.2.6-beta
     **/
    public function getBase(){}

    /**
     * Gets the remote address and port associated with the connection
     *
     * @param string $address Address of the peer.
     * @param int $port Port of the peer.
     * @return void
     * @since PECL event >= 1.2.6-beta
     **/
    public function getPeer(&$address, &$port){}

    /**
     * Makes an HTTP request over the specified connection
     *
     * Makes an HTTP request over the specified connection. {@link type} is
     * one of EventHttpRequest::CMD_* constants.
     *
     * @param EventHttpRequest $req The connection object over which to
     *   send the request.
     * @param int $type One of EventHttpRequest::CMD_* constants .
     * @param string $uri The URI associated with the request.
     * @return bool Returns TRUE on success. Otherwise FALSE.
     * @since PECL event >= 1.4.0-beta
     **/
    public function makeRequest($req, $type, $uri){}

    /**
     * Set callback for connection close
     *
     * Sets callback for connection close.
     *
     * @param callable $callback Callback which is called when connection
     *   is closed. Should match the following prototype:
     * @param mixed $data
     * @return void
     * @since PECL event >= 1.8.0
     **/
    public function setCloseCallback($callback, $data){}

    /**
     * Sets the IP address from which HTTP connections are made
     *
     * Sets the IP address from which http connections are made.
     *
     * @param string $address The IP address from which HTTP connections
     *   are made.
     * @return void
     * @since PECL event >= 1.2.6-beta
     **/
    public function setLocalAddress($address){}

    /**
     * Sets the local port from which connections are made
     *
     * @param int $port The port number.
     * @return void
     * @since PECL event >= 1.2.6-beta
     **/
    public function setLocalPort($port){}

    /**
     * Sets maximum body size for the connection
     *
     * @param string $max_size The maximum body size in bytes.
     * @return void
     * @since PECL event >= 1.2.6-beta
     **/
    public function setMaxBodySize($max_size){}

    /**
     * Sets maximum header size
     *
     * Sets maximum header size for the connection.
     *
     * @param string $max_size The maximum header size in bytes.
     * @return void
     * @since PECL event >= 1.2.6-beta
     **/
    public function setMaxHeadersSize($max_size){}

    /**
     * Sets the retry limit for the connection
     *
     * @param int $retries The retry limit. -1 means infinity.
     * @return void
     * @since PECL event >= 1.2.6-beta
     **/
    public function setRetries($retries){}

    /**
     * Sets the timeout for the connection
     *
     * @param int $timeout Timeout in seconds.
     * @return void
     * @since PECL event >= 1.2.6-beta
     **/
    public function setTimeout($timeout){}

    /**
     * Constructs EventHttpConnection object
     *
     * @param EventBase $base Associated event base.
     * @param EventDnsBase $dns_base If {@link dns_base} is NULL, hostname
     *   resolution will block.
     * @param string $address The address to connect to.
     * @param int $port The port to connect to.
     * @param EventSslContext $ctx EventSslContext class object. Enables
     *   OpenSSL.
     * @since PECL event >= 1.2.6-beta
     **/
    public function __construct($base, $dns_base, $address, $port, $ctx){}

}
/**
 * Represents an HTTP request.
 **/
class EventHttpRequest {
    /**
     * @var integer
     **/
    const CMD_CONNECT = 0;

    /**
     * @var integer
     **/
    const CMD_DELETE = 0;

    /**
     * @var integer
     **/
    const CMD_GET = 0;

    /**
     * @var integer
     **/
    const CMD_HEAD = 0;

    /**
     * @var integer
     **/
    const CMD_OPTIONS = 0;

    /**
     * @var integer
     **/
    const CMD_PATCH = 0;

    /**
     * @var integer
     **/
    const CMD_POST = 0;

    /**
     * @var integer
     **/
    const CMD_PUT = 0;

    /**
     * @var integer
     **/
    const CMD_TRACE = 0;

    /**
     * @var integer
     **/
    const INPUT_HEADER = 0;

    /**
     * @var integer
     **/
    const OUTPUT_HEADER = 0;

    /**
     * Adds an HTTP header to the headers of the request
     *
     * @param string $key Header name.
     * @param string $value Header value.
     * @param int $type One of EventHttpRequest::*_HEADER constants .
     * @return bool Returns TRUE on success. Otherwise FALSE.
     * @since PECL event >= 1.4.0-beta
     **/
    public function addHeader($key, $value, $type){}

    /**
     * Cancels a pending HTTP request
     *
     * Cancels an ongoing HTTP request. The callback associated with this
     * request is not executed and the request object is freed. If the
     * request is currently being processed, e.g. it is ongoing, the
     * corresponding EventHttpConnection object is going to get reset.
     *
     * A request cannot be canceled if its callback has executed already. A
     * request may be canceled reentrantly from its chunked callback.
     *
     * @return void
     * @since PECL event >= 1.4.0-beta
     **/
    public function cancel(){}

    /**
     * Removes all output headers from the header list of the request
     *
     * @return void
     * @since PECL event >= 1.4.0-beta
     **/
    public function clearHeaders(){}

    /**
     * Closes associated HTTP connection
     *
     * Closes HTTP connection associated with the request.
     *
     * @return void
     * @since PECL event >= 1.8.0
     **/
    public function closeConnection(){}

    /**
     * Finds the value belonging a header
     *
     * @param string $key The header name.
     * @param string $type One of EventHttpRequest::*_HEADER constants .
     * @return void Returns NULL if header not found.
     * @since PECL event >= 1.4.0-beta
     **/
    public function findHeader($key, $type){}

    /**
     * Frees the object and removes associated events
     *
     * @return void
     * @since PECL event >= 1.4.0-beta
     **/
    public function free(){}

    /**
     * Returns the request command(method)
     *
     * Returns the request command, one of EventHttpRequest::CMD_* constants.
     *
     * @return void Returns the request command, one of
     *   EventHttpRequest::CMD_* constants.
     * @since PECL event >= 1.4.0-beta
     **/
    public function getCommand(){}

    /**
     * Returns the request host
     *
     * @return string Returns the request host.
     * @since PECL event >= 1.4.0-beta
     **/
    public function getHost(){}

    /**
     * Returns the input buffer
     *
     * @return EventBuffer Returns the input buffer.
     * @since PECL event >= 1.4.0-beta
     **/
    public function getInputBuffer(){}

    /**
     * Returns associative array of the input headers
     *
     * @return array Returns associative array of the input headers.
     * @since PECL event >= 1.4.0-beta
     **/
    public function getInputHeaders(){}

    /**
     * Returns the output buffer of the request
     *
     * @return EventBuffer Returns the output buffer of the request.
     * @since PECL event >= 1.4.0-beta
     **/
    public function getOutputBuffer(){}

    /**
     * Returns associative array of the output headers
     *
     * @return void
     * @since PECL event >= 1.4.0-beta
     **/
    public function getOutputHeaders(){}

    /**
     * Returns the response code
     *
     * @return int Returns the response code of the request.
     * @since PECL event >= 1.4.0-beta
     **/
    public function getResponseCode(){}

    /**
     * Returns the request URI
     *
     * @return string Returns the request URI
     * @since PECL event >= 1.4.0-beta
     **/
    public function getUri(){}

    /**
     * Removes an HTTP header from the headers of the request
     *
     * @param string $key The header name.
     * @param string $type {@link type} is one of
     *   EventHttpRequest::*_HEADER constants.
     * @return void Removes an HTTP header from the headers of the request.
     * @since PECL event >= 1.4.0-beta
     **/
    public function removeHeader($key, $type){}

    /**
     * Send an HTML error message to the client
     *
     * @param int $error The HTTP error code.
     * @param string $reason A brief explanation ofthe error. If NULL, the
     *   standard meaning of the error code will be used.
     * @return void
     * @since PECL event >= 1.4.0-beta
     **/
    public function sendError($error, $reason){}

    /**
     * Send an HTML reply to the client
     *
     * Send an HTML reply to the client. The body of the reply consists of
     * data in optional {@link buf} parameter.
     *
     * @param int $code The HTTP response code to send.
     * @param string $reason A brief message to send with the response
     *   code.
     * @param EventBuffer $buf The body of the response.
     * @return void
     * @since PECL event >= 1.4.0-beta
     **/
    public function sendReply($code, $reason, $buf){}

    /**
     * Send another data chunk as part of an ongoing chunked reply
     *
     * Send another data chunk as part of an ongoing chunked reply. After
     * calling this method {@link buf} will be empty.
     *
     * @param EventBuffer $buf The data chunk to send as part of the reply.
     * @return void
     * @since PECL event >= 1.4.0-beta
     **/
    public function sendReplyChunk($buf){}

    /**
     * Complete a chunked reply, freeing the request as appropriate
     *
     * @return void
     * @since PECL event >= 1.4.0-beta
     **/
    public function sendReplyEnd(){}

    /**
     * Initiate a chunked reply
     *
     * Initiate a reply that uses Transfer-Encoding chunked .
     *
     * This allows the caller to stream the reply back to the client and is
     * useful when either not all of the reply data is immediately available
     * or when sending very large replies.
     *
     * The caller needs to supply data chunks with
     * EventHttpRequest::sendReplyChunk and complete the reply by calling
     * EventHttpRequest::sendReplyEnd .
     *
     * @param int $code The HTTP response code to send.
     * @param string $reason A brief message to send with the response
     *   code.
     * @return void
     * @since PECL event >= 1.4.0-beta
     **/
    public function sendReplyStart($code, $reason){}

    /**
     * Constructs EventHttpRequest object
     *
     * @param callable $callback Gets invoked on requesting path. Should
     *   match the following prototype:
     * @param mixed $data User custom data passed to the callback.
     * @since PECL event >= 1.4.0-beta
     **/
    public function __construct($callback, $data){}

}
/**
 * Represents a connection listener.
 **/
final class EventListener {
    /**
     * @var integer
     **/
    const OPT_CLOSE_ON_EXEC = 0;

    /**
     * @var integer
     **/
    const OPT_CLOSE_ON_FREE = 0;

    /**
     * @var integer
     **/
    const OPT_LEAVE_SOCKETS_BLOCKING = 0;

    /**
     * @var integer
     **/
    const OPT_REUSEABLE = 0;

    /**
     * @var integer
     **/
    const OPT_THREADSAFE = 0;

    /**
     * Numeric file descriptor of the underlying socket. (Added in
     * event-1.6.0 .)
     *
     * @var int
     **/
    public $fd;

    /**
     * Disables an event connect listener object
     *
     * @return bool Returns TRUE on success. Otherwise FALSE.
     * @since PECL event >= 1.2.6-beta
     **/
    public function disable(){}

    /**
     * Enables an event connect listener object
     *
     * @return bool Returns TRUE on success. Otherwise FALSE.
     * @since PECL event >= 1.2.6-beta
     **/
    public function enable(){}

    /**
     * Returns event base associated with the event listener
     *
     * @return void Returns event base associated with the event listener.
     * @since PECL event >= 1.2.6-beta
     **/
    public function getBase(){}

    /**
     * Retreives the current address to which the listeners socket is bound
     *
     * Retreives the current address to which the listeners socket is bound.
     *
     * @param string $address Output parameter. IP-address depending on the
     *   socket address family.
     * @param mixed $port Output parameter. The port the socket is bound
     *   to.
     * @return bool Returns TRUE on success. Otherwise FALSE.
     * @since PECL event >= 1.5.0
     **/
    public static function getSocketName(&$address, &$port){}

    /**
     * The setCallback purpose
     *
     * Adjust event connect listeners callback and optionally the callback
     * argument.
     *
     * @param callable $cb The new callback for new connections. Ignored if
     *   NULL. Should match the following prototype:
     *   
     *   {@link listener} The EventListener object. {@link fd} The file
     *   descriptor or a resource associated with the listener. {@link
     *   address} Array of two elements: IP address and the server port.
     *   {@link arg} User custom data attached to the callback.
     * @param mixed $arg The EventListener object.
     * @return void
     * @since PECL event >= 1.2.6-beta
     **/
    public function setCallback($cb, $arg){}

    /**
     * Set event listener's error callback
     *
     * @param string $cb The error callback. Should match the following
     *   prototype:
     *   
     *   {@link listener} The EventListener object. {@link data} User custom
     *   data attached to the callback.
     * @return void
     * @since PECL event >= 1.2.6-beta
     **/
    public function setErrorCallback($cb){}

    /**
     * Creates new connection listener associated with an event base
     *
     * @param EventBase $base Associated event base.
     * @param callable $cb A callable that will be invoked when new
     *   connection received.
     * @param mixed $data Custom user data attached to {@link cb} .
     * @param int $flags Bit mask of EventListener::OPT_* constants. See
     *   EventListener constants .
     * @param int $backlog Controls the maximum number of pending
     *   connections that the network stack should allow to wait in a
     *   not-yet-accepted state at any time; see documentation for your
     *   system’s listen function for more details. If {@link backlog} is
     *   negative, Libevent tries to pick a good value for the {@link
     *   backlog} ; if it is zero, Event assumes that listen is already
     *   called on the socket( {@link target} )
     * @param mixed $target May be string, socket resource, or a stream
     *   associated with a socket. In case if {@link target} is a string, the
     *   string will be parsed as network address. It will be interpreted as
     *   a UNIX domain socket path, if prefixed with 'unix:' , e.g.
     *   'unix:/tmp/my.sock' .
     * @since PECL event >= 1.2.6-beta
     **/
    public function __construct($base, $cb, $data, $flags, $backlog, $target){}

}
/**
 * Represents SSL_CTX structure. Provides methods and properties to
 * configure the SSL context.
 **/
final class EventSslContext {
    /**
     * @var integer
     **/
    const OPT_ALLOW_SELF_SIGNED = 0;

    /**
     * @var integer
     **/
    const OPT_CA_FILE = 0;

    /**
     * @var integer
     **/
    const OPT_CA_PATH = 0;

    /**
     * @var integer
     **/
    const OPT_CIPHERS = 0;

    /**
     * @var integer
     **/
    const OPT_LOCAL_CERT = 0;

    /**
     * @var integer
     **/
    const OPT_LOCAL_PK = 0;

    /**
     * @var integer
     **/
    const OPT_PASSPHRASE = 0;

    /**
     * @var integer
     **/
    const OPT_VERIFY_DEPTH = 0;

    /**
     * @var integer
     **/
    const OPT_VERIFY_PEER = 0;

    /**
     * @var integer
     **/
    const SSLv2_CLIENT_METHOD = 0;

    /**
     * @var integer
     **/
    const SSLv2_SERVER_METHOD = 0;

    /**
     * @var integer
     **/
    const SSLv3_CLIENT_METHOD = 0;

    /**
     * @var integer
     **/
    const SSLv3_SERVER_METHOD = 0;

    /**
     * @var integer
     **/
    const SSLv23_CLIENT_METHOD = 0;

    /**
     * @var integer
     **/
    const SSLv23_SERVER_METHOD = 0;

    /**
     * @var integer
     **/
    const TLS_CLIENT_METHOD = 0;

    /**
     * @var integer
     **/
    const TLS_SERVER_METHOD = 0;

    /**
     * @var string
     **/
    public $local_cert;

    /**
     * @var string
     **/
    public $local_pk;

    /**
     * Constructs an OpenSSL context for use with Event classes
     *
     * Creates SSL context holding pointer to SSL_CTX (see the system
     * manual).
     *
     * @param string $method One of EventSslContext::*_METHOD constants .
     * @param string $options Associative array of SSL context options One
     *   of EventSslContext::OPT_* constants .
     * @since PECL event >= 1.2.6-beta
     **/
    public function __construct($method, $options){}

}
/**
 * EventUtil is a singleton with supplimentary methods and constants.
 **/
final class EventUtil {
    /**
     * @var integer
     **/
    const AF_INET = 0;

    /**
     * @var integer
     **/
    const AF_INET6 = 0;

    /**
     * @var integer
     **/
    const AF_UNSPEC = 0;

    /**
     * @var integer
     **/
    const IPPROTO_IP = 0;

    /**
     * @var integer
     **/
    const IPPROTO_IPV6 = 0;

    /**
     * @var integer
     **/
    const LIBEVENT_VERSION_NUMBER = 0;

    /**
     * @var integer
     **/
    const SOL_SOCKET = 0;

    /**
     * @var integer
     **/
    const SOL_TCP = 0;

    /**
     * @var integer
     **/
    const SOL_UDP = 0;

    /**
     * @var integer
     **/
    const SO_BROADCAST = 0;

    /**
     * @var integer
     **/
    const SO_DEBUG = 0;

    /**
     * @var integer
     **/
    const SO_DONTROUTE = 0;

    /**
     * @var integer
     **/
    const SO_ERROR = 0;

    /**
     * @var integer
     **/
    const SO_KEEPALIVE = 0;

    /**
     * @var integer
     **/
    const SO_LINGER = 0;

    /**
     * @var integer
     **/
    const SO_OOBINLINE = 0;

    /**
     * @var integer
     **/
    const SO_RCVBUF = 0;

    /**
     * @var integer
     **/
    const SO_RCVLOWAT = 0;

    /**
     * @var integer
     **/
    const SO_RCVTIMEO = 0;

    /**
     * @var integer
     **/
    const SO_REUSEADDR = 0;

    /**
     * @var integer
     **/
    const SO_SNDBUF = 0;

    /**
     * @var integer
     **/
    const SO_SNDLOWAT = 0;

    /**
     * @var integer
     **/
    const SO_SNDTIMEO = 0;

    /**
     * @var integer
     **/
    const SO_TYPE = 0;

    /**
     * Returns the most recent socket error number
     *
     * Returns the most recent socket error number( errno ).
     *
     * @param mixed $socket Socket resource, stream or a file descriptor of
     *   a socket.
     * @return int Returns the most recent socket error number( errno ).
     * @since PECL event >= 1.2.6-beta
     **/
    public static function getLastSocketErrno($socket){}

    /**
     * Returns the most recent socket error
     *
     * @param mixed $socket Socket resource, stream or a file descriptor of
     *   a socket.
     * @return string Returns the most recent socket error.
     * @since PECL event >= 1.2.6-beta
     **/
    public static function getLastSocketError($socket){}

    /**
     * Returns numeric file descriptor of a socket, or stream
     *
     * Returns numeric file descriptor of a socket or stream specified by
     * {@link socket} argument just like the Event extension does it
     * internally for all methods accepting socket resource or stream.
     *
     * @param mixed $socket Socket resource or stream.
     * @return int Returns numeric file descriptor of a socket, or stream.
     *   EventUtil::getSocketFd returns FALSE in case if it is whether failed
     *   to recognize the type of the underlying file, or detected that the
     *   file descriptor associated with {@link socket} is not valid.
     * @since PECL event >= 1.7.0
     **/
    public static function getSocketFd($socket){}

    /**
     * Retreives the current address to which the socket is bound
     *
     * Retreives the current address to which the {@link socket} is bound.
     *
     * @param mixed $socket Socket resource, stream or a file descriptor of
     *   a socket.
     * @param string $address Output parameter. IP-address, or the UNIX
     *   domain socket path depending on the socket address family.
     * @param mixed $port Output parameter. The port the socket is bound
     *   to. Has no meaning for UNIX domain sockets.
     * @return bool Returns TRUE on success. Otherwise FALSE.
     * @since PECL event >= 1.5.0
     **/
    public static function getSocketName($socket, &$address, &$port){}

    /**
     * Sets socket options
     *
     * @param mixed $socket Socket resource, stream, or numeric file
     *   descriptor associated with the socket.
     * @param int $level One of EventUtil::SOL_* constants. Specifies the
     *   protocol level at which the option resides. For example, to retrieve
     *   options at the socket level, a {@link level} parameter of
     *   EventUtil::SOL_SOCKET would be used. Other levels, such as TCP, can
     *   be used by specifying the protocol number of that level. Protocol
     *   numbers can be found by using the {@link getprotobyname} function.
     *   See EventUtil constants .
     * @param int $optname Option name(type). Has the same meaning as
     *   corresponding parameter of {@link socket_get_option} function. See
     *   EventUtil constants .
     * @param mixed $optval Accepts the same values as {@link optval}
     *   parameter of the {@link socket_get_option} function.
     * @return bool Returns TRUE on success. Otherwise FALSE.
     * @since PECL event >= 1.6.0
     **/
    public static function setSocketOption($socket, $level, $optname, $optval){}

    /**
     * Generates entropy by means of OpenSSL's RAND_poll()
     *
     * Generates entropy by means of OpenSSL's RAND_poll() (see the system
     * manual).
     *
     * @return void
     * @since PECL event >= 1.2.6-beta
     **/
    public static function sslRandPoll(){}

    /**
     * The abstract constructor
     *
     * EventUtil is a singleton. Therefore the constructor is abstract, and
     * it is impossible to create objects based on this class.
     *
     * @since PECL event >= 1.2.6-beta
     **/
    private function __construct(){}

}
/**
 * Fork watchers are called when a fork() was detected (usually because
 * whoever signalled libev about it by calling EvLoop::fork ). The
 * invocation is done before the event loop blocks next and before
 * EvCheck watchers are being called, and only in the child after the
 * fork. Note, that if whoever calling EvLoop::fork calls it in the wrong
 * process, the fork handlers will be invoked, too.
 **/
class EvFork extends EvWatcher {
    /**
     * Creates a stopped instance of EvFork watcher class
     *
     * The same as EvFork::__construct , but doesn't start the watcher
     * automatically.
     *
     * @param string $callback See Watcher callbacks .
     * @param string $data Custom data associated with the watcher.
     * @param string $priority Watcher priority
     * @return object Returns EvFork(stopped) object on success.
     * @since PECL ev >= 0.2.0
     **/
    final public static function createStopped($callback, $data, $priority){}

    /**
     * Constructs the EvFork watcher object
     *
     * Constructs the EvFork watcher object and starts the watcher
     * automatically.
     *
     * @param callable $callback See Watcher callbacks .
     * @param mixed $data Custom data associated with the watcher.
     * @param int $priority Watcher priority
     * @since PECL ev >= 0.2.0
     **/
    public function __construct($callback, $data, $priority){}

}
/**
 * EvIdle watchers trigger events when no other events of the same or
 * higher priority are pending ( EvPrepare , EvCheck and other EvIdle
 * watchers do not count as receiving events ). Thus, as long as the
 * process is busy handling sockets or timeouts(or even signals) of the
 * same or higher priority it will not be triggered. But when the process
 * is in idle(or only lower-priority watchers are pending), the EvIdle
 * watchers are being called once per event loop iteration - until
 * stopped, that is, or the process receives more events and becomes busy
 * again with higher priority stuff. Apart from keeping the process
 * non-blocking(which is a useful on its own sometimes), EvIdle watchers
 * are a good place to do "pseudo-background processing" , or delay
 * processing stuff to after the event loop has handled all outstanding
 * events. The most noticeable effect is that as long as any idle
 * watchers are active, the process will not block when waiting for new
 * events.
 **/
class EvIdle extends EvWatcher {
    /**
     * Creates instance of a stopped EvIdle watcher object
     *
     * The same as EvIdle::__construct , but doesn't start the watcher
     * automatically.
     *
     * @param string $callback See Watcher callbacks .
     * @param mixed $data Custom data associated with the watcher.
     * @param int $priority Watcher priority
     * @return object Returns EvIdle object on success.
     * @since PECL ev >= 0.2.0
     **/
    final public static function createStopped($callback, $data, $priority){}

    /**
     * Constructs the EvIdle watcher object
     *
     * Constructs the EvIdle watcher object and starts the watcher
     * automatically.
     *
     * @param callable $callback See Watcher callbacks .
     * @param mixed $data Custom data associated with the watcher.
     * @param int $priority Watcher priority
     * @since PECL ev >= 0.2.0
     **/
    public function __construct($callback, $data, $priority){}

}
/**
 * EvIo watchers check whether a file descriptor(or socket, or a stream
 * castable to numeric file descriptor) is readable or writable in each
 * iteration of the event loop, or, more precisely, when reading would
 * not block the process and writing would at least be able to write some
 * data. This behaviour is called level-triggering because events are
 * kept receiving as long as the condition persists. To stop receiving
 * events just stop the watcher. The number of read and/or write event
 * watchers per {@link fd} is unlimited. Setting all file descriptors to
 * non-blocking mode is also usually a good idea(but not required).
 * Another thing to watch out for is that it is quite easy to receive
 * false readiness notifications, i.e. the callback might be called with
 * Ev::READ but a subsequent read() will actually block because there is
 * no data. It is very easy to get into this situation. Thus it is best
 * to always use non-blocking I/O: An extra read() returning EAGAIN (or
 * similar) is far preferable to a program hanging until some data
 * arrives. If for some reason it is impossible to run the {@link fd} in
 * non-blocking mode, then separately re-test whether a file descriptor
 * is really ready. Some people additionally use SIGALRM and an interval
 * timer, just to be sure thry won't block infinitely. Always consider
 * using non-blocking mode.
 **/
class EvIo extends EvWatcher {
    /**
     * @var mixed
     **/
    public $events;

    /**
     * @var mixed
     **/
    public $fd;

    /**
     * Create stopped EvIo watcher object
     *
     * The same as EvIo::__construct , but doesn't start the watcher
     * automatically.
     *
     * @param mixed $fd The same as for EvIo::__construct
     * @param int $events The same as for EvIo::__construct
     * @param callable $callback See Watcher callbacks .
     * @param mixed $data Custom data associated with the watcher.
     * @param int $priority Watcher priority
     * @return EvIo Returns EvIo object on success.
     * @since PECL ev >= 0.2.0
     **/
    final public static function createStopped($fd, $events, $callback, $data, $priority){}

    /**
     * Configures the watcher
     *
     * Configures the EvIo watcher
     *
     * @param mixed $fd The same as for EvIo::__construct
     * @param int $events The same as for EvIo::__construct
     * @return void
     * @since PECL ev >= 0.2.0
     **/
    public function set($fd, $events){}

    /**
     * Constructs EvIo watcher object
     *
     * Constructs EvIo watcher object and starts the watcher automatically.
     *
     * @param mixed $fd Can be a stream opened with {@link fopen} or
     *   similar functions, numeric file descriptor, or socket.
     * @param int $events Ev::READ and/or Ev::WRITE . See the bit masks .
     * @param callable $callback See Watcher callbacks .
     * @param mixed $data Custom data associated with the watcher.
     * @param int $priority Watcher priority
     * @since PECL ev >= 0.2.0
     **/
    public function __construct($fd, $events, $callback, $data, $priority){}

}
/**
 * Represents an event loop that is always distinct from the default loop
 * . Unlike the default loop , it cannot handle EvChild watchers. Having
 * threads we have to create a loop per thread, and use the default loop
 * in the parent thread. The default event loop is initialized
 * automatically by Ev . It is accessible via methods of the Ev class, or
 * via EvLoop::defaultLoop method.
 **/
final class EvLoop {
    /**
     * Readonly . The backend flags indicating the event backend in use.
     *
     * @var mixed
     **/
    public $backend;

    /**
     * Custom data attached to loop
     *
     * @var mixed
     **/
    public $data;

    /**
     * The recursion depth. See Ev::depth .
     *
     * @var mixed
     **/
    public $depth;

    /**
     * @var mixed
     **/
    public $io_interval;

    /**
     * @var mixed
     **/
    public $is_default_loop;

    /**
     * The current iteration count of the loop. See Ev::iteration
     *
     * @var mixed
     **/
    public $iteration;

    /**
     * The number of pending watchers. 0 indicates that there are no watchers
     * pending.
     *
     * @var mixed
     **/
    public $pending;

    /**
     * @var mixed
     **/
    public $timeout_interval;

    /**
     * Returns an integer describing the backend used by libev
     *
     * The same as Ev::backend , but for the loop instance.
     *
     * @return int Returns an integer describing the backend used by libev.
     *   See Ev::backend .
     * @since PECL ev >= 0.2.0
     **/
    public function backend(){}

    /**
     * Creates EvCheck object associated with the current event loop instance
     *
     * Creates EvCheck object associated with the current event loop
     * instance.
     *
     * @param string $callback
     * @param string $data
     * @param string $priority
     * @return EvCheck Returns EvCheck object on success.
     * @since PECL ev >= 0.2.0
     **/
    final public function check($callback, $data, $priority){}

    /**
     * Creates EvChild object associated with the current event loop
     *
     * @param string $pid
     * @param string $trace
     * @param string $callback
     * @param string $data
     * @param string $priority
     * @return EvChild Returns EvChild object on success.
     * @since PECL ev >= 0.2.0
     **/
    final public function child($pid, $trace, $callback, $data, $priority){}

    /**
     * Returns or creates the default event loop
     *
     * If the default event loop is not created, EvLoop::defaultLoop creates
     * it with the specified parameters. Otherwise, it just returns the
     * object representing previously created instance ignoring all the
     * parameters.
     *
     * @param int $flags One of the event loop flags
     * @param mixed $data Custom data to associate with the loop.
     * @param float $io_interval See io_interval
     * @param float $timeout_interval See timeout_interval
     * @return EvLoop Returns EvLoop object on success.
     * @since PECL ev >= 0.2.0
     **/
    public static function defaultLoop($flags, $data, $io_interval, $timeout_interval){}

    /**
     * Creates an instance of EvEmbed watcher associated with the current
     * EvLoop object
     *
     * Creates an instance of EvEmbed watcher associated with the current
     * EvLoop object.
     *
     * @param string $other
     * @param string $callback
     * @param string $data
     * @param string $priority
     * @return EvEmbed Returns EvEmbed object on success.
     * @since PECL ev >= 0.2.0
     **/
    final public function embed($other, $callback, $data, $priority){}

    /**
     * Creates EvFork watcher object associated with the current event loop
     * instance
     *
     * Creates EvFork watcher object associated with the current event loop
     * instance
     *
     * @param callable $callback
     * @param mixed $data
     * @param int $priority
     * @return EvFork Returns EvFork object on success.
     * @since PECL ev >= 0.2.0
     **/
    final public function fork($callback, $data, $priority){}

    /**
     * Creates EvIdle watcher object associated with the current event loop
     * instance
     *
     * Creates EvIdle watcher object associated with the current event loop
     * instance
     *
     * @param callable $callback
     * @param mixed $data
     * @param int $priority
     * @return EvIdle Returns EvIdle object on success.
     * @since PECL ev >= 0.2.0
     **/
    final public function idle($callback, $data, $priority){}

    /**
     * Invoke all pending watchers while resetting their pending state
     *
     * @return void
     * @since PECL ev >= 0.2.0
     **/
    public function invokePending(){}

    /**
     * Create EvIo watcher object associated with the current event loop
     * instance
     *
     * Create EvIo watcher object associated with the current event loop
     * instance.
     *
     * @param mixed $fd
     * @param int $events
     * @param callable $callback
     * @param mixed $data
     * @param int $priority
     * @return EvIo Returns EvIo object on success.
     * @since PECL ev >= 0.2.0
     **/
    final public function io($fd, $events, $callback, $data, $priority){}

    /**
     * Must be called after a fork
     *
     * Must be called after a fork in the child, before entering or
     * continuing the event loop. An alternative is to use Ev::FLAG_FORKCHECK
     * which calls this function automatically, at some performance loss
     * (refer to the libev documentation ).
     *
     * @return void
     * @since PECL ev >= 0.2.0
     **/
    public function loopFork(){}

    /**
     * Returns the current "event loop time"
     *
     * Returns the current "event loop time", which is the time the event
     * loop received events and started processing them. This timestamp does
     * not change as long as callbacks are being processed, and this is also
     * the base time used for relative timers. You can treat it as the
     * timestamp of the event occurring(or more correctly, libev finding out
     * about it).
     *
     * @return float Returns time of the event loop in (fractional)
     *   seconds.
     * @since PECL ev >= 0.2.0
     **/
    public function now(){}

    /**
     * Establishes the current time by querying the kernel, updating the time
     * returned by EvLoop::now in the progress
     *
     * Establishes the current time by querying the kernel, updating the time
     * returned by EvLoop::now in the progress. This is a costly operation
     * and is usually done automatically within EvLoop::run .
     *
     * @return void
     * @since PECL ev >= 0.2.0
     **/
    public function nowUpdate(){}

    /**
     * Creates EvPeriodic watcher object associated with the current event
     * loop instance
     *
     * Creates EvPeriodic watcher object associated with the current event
     * loop instance
     *
     * @param float $offset
     * @param float $interval
     * @param callable $callback
     * @param mixed $data
     * @param int $priority
     * @return EvPeriodic Returns EvPeriodic object on success.
     * @since PECL ev >= 0.2.0
     **/
    final public function periodic($offset, $interval, $callback, $data, $priority){}

    /**
     * Creates EvPrepare watcher object associated with the current event
     * loop instance
     *
     * Creates EvPrepare watcher object associated with the current event
     * loop instance
     *
     * @param callable $callback
     * @param mixed $data
     * @param int $priority
     * @return EvPrepare Returns EvPrepare object on success
     * @since PECL ev >= 0.2.0
     **/
    final public function prepare($callback, $data, $priority){}

    /**
     * Resume previously suspended default event loop
     *
     * EvLoop::suspend and EvLoop::resume methods suspend and resume a loop
     * correspondingly.
     *
     * @return void
     * @since PECL ev >= 0.2.0
     **/
    public function resume(){}

    /**
     * Begin checking for events and calling callbacks for the loop
     *
     * Begin checking for events and calling callbacks for the current event
     * loop. Returns when a callback calls Ev::stop method, or the flags are
     * nonzero(in which case the return value is true) or when there are no
     * active watchers which reference the loop( EvWatcher::keepalive is
     * TRUE), in which case the return value will be FALSE. The return value
     * can generally be interpreted as if TRUE, there is more work left to do
     * .
     *
     * @param int $flags Optional parameter {@link flags} can be one of the
     *   following: List for possible values of {@link flags} {@link flags}
     *   Description 0 The default behavior described above Ev::RUN_ONCE
     *   Block at most one(wait, but don't loop) Ev::RUN_NOWAIT Don't block
     *   at all(fetch/handle events, but don't wait) See the run flag
     *   constants .
     * @return void
     * @since PECL ev >= 0.2.0
     **/
    public function run($flags){}

    /**
     * Creates EvSignal watcher object associated with the current event loop
     * instance
     *
     * Creates EvSignal watcher object associated with the current event loop
     * instance
     *
     * @param int $signum
     * @param callable $callback
     * @param mixed $data
     * @param int $priority
     * @return EvSignal Returns EvSignal object on success
     * @since PECL ev >= 0.2.0
     **/
    final public function signal($signum, $callback, $data, $priority){}

    /**
     * Creates EvStat watcher object associated with the current event loop
     * instance
     *
     * Creates EvStat watcher object associated with the current event loop
     * instance
     *
     * @param string $path
     * @param float $interval
     * @param callable $callback
     * @param mixed $data
     * @param int $priority
     * @return EvStat Returns EvStat object on success
     * @since PECL ev >= 0.2.0
     **/
    final public function stat($path, $interval, $callback, $data, $priority){}

    /**
     * Stops the event loop
     *
     * @param int $how One of Ev::BREAK_* constants .
     * @return void
     * @since PECL ev >= 0.2.0
     **/
    public function stop($how){}

    /**
     * Suspend the loop
     *
     * EvLoop::suspend and EvLoop::resume methods suspend and resume a loop
     * correspondingly.
     *
     * @return void
     * @since PECL ev >= 0.2.0
     **/
    public function suspend(){}

    /**
     * Creates EvTimer watcher object associated with the current event loop
     * instance
     *
     * Creates EvTimer watcher object associated with the current event loop
     * instance
     *
     * @param float $after
     * @param float $repeat
     * @param callable $callback
     * @param mixed $data
     * @param int $priority
     * @return EvTimer Returns EvTimer object on success
     * @since PECL ev >= 0.2.0
     **/
    final public function timer($after, $repeat, $callback, $data, $priority){}

    /**
     * Performs internal consistency checks(for debugging)
     *
     * Performs internal consistency checks(for debugging libev ) and abort
     * the program if any data structures were found to be corrupted.
     *
     * @return void
     * @since PECL ev >= 0.2.0
     **/
    public function verify(){}

    /**
     * Constructs the event loop object
     *
     * @param int $flags One of the event loop flags
     * @param mixed $data Custom data associated with the loop.
     * @param float $io_interval See io_interval
     * @param float $timeout_interval See timeout_interval
     * @since PECL ev >= 0.2.0
     **/
    public function __construct($flags, $data, $io_interval, $timeout_interval){}

}
/**
 * Periodic watchers are also timers of a kind, but they are very
 * versatile. Unlike EvTimer , EvPeriodic watchers are not based on real
 * time(or relative time, the physical time that passes) but on wall
 * clock time(absolute time, calendar or clock). The difference is that
 * wall clock time can run faster or slower than real time, and time
 * jumps are not uncommon(e.g. when adjusting it). EvPeriodic watcher can
 * be configured to trigger after some specific point in time. For
 * example, if an EvPeriodic watcher is configured to trigger "in 10
 * seconds" (e.g. EvLoop::now + 10.0 , i.e. an absolute time, not a
 * delay), and the system clock is reset to January of the previous year
 * , then it will take a year or more to trigger the event (unlike an
 * EvTimer , which would still trigger roughly 10 seconds after starting
 * it as it uses a relative timeout). As with timers, the callback is
 * guaranteed to be invoked only when the point in time where it is
 * supposed to trigger has passed. If multiple timers become ready during
 * the same loop iteration then the ones with earlier time-out values are
 * invoked before ones with later time-out values (but this is no longer
 * true when a callback calls EvLoop::run recursively).
 **/
class EvPeriodic extends EvWatcher {
    /**
     * The current interval value. Can be modified any time, but changes only
     * take effect when the periodic timer fires or EvPeriodic::again is
     * being called.
     *
     * @var mixed
     **/
    public $interval;

    /**
     * When repeating, this contains the offset value, otherwise this is the
     * absolute point in time(the offset value passed to EvPeriodic::set ,
     * although libev might modify this value for better numerical
     * stability).
     *
     * @var mixed
     **/
    public $offset;

    /**
     * Simply stops and restarts the periodic watcher again
     *
     * Simply stops and restarts the periodic watcher again. This is only
     * useful when attributes are changed.
     *
     * @return void
     * @since PECL ev >= 0.2.0
     **/
    public function again(){}

    /**
     * Returns the absolute time that this watcher is supposed to trigger
     * next
     *
     * When the watcher is active, returns the absolute time that this
     * watcher is supposed to trigger next. This is not the same as the
     * offset argument to EvPeriodic::set or EvPeriodic::__construct , but
     * indeed works even in interval mode.
     *
     * @return float Returns the absolute time this watcher is supposed to
     *   trigger next in seconds.
     * @since PECL ev >= 0.2.0
     **/
    public function at(){}

    /**
     * Create a stopped EvPeriodic watcher
     *
     * Create EvPeriodic object. Unlike EvPeriodic::__construct this method
     * doesnt start the watcher automatically.
     *
     * @param float $offset See Periodic watcher operation modes
     * @param float $interval See Periodic watcher operation modes
     * @param callable $reschedule_cb Reschedule callback. You can pass
     *   NULL. See Periodic watcher operation modes
     * @param callable $callback See Watcher callbacks .
     * @param mixed $data Custom data associated with the watcher.
     * @param int $priority Watcher priority
     * @return EvPeriodic Returns EvPeriodic watcher object on success.
     * @since PECL ev >= 0.2.0
     **/
    final public static function createStopped($offset, $interval, $reschedule_cb, $callback, $data, $priority){}

    /**
     * Configures the watcher
     *
     * (Re-)Configures EvPeriodic watcher
     *
     * @param float $offset The same meaning as for EvPeriodic::__construct
     *   . See Periodic watcher operation modes
     * @param float $interval The same meaning as for
     *   EvPeriodic::__construct . See Periodic watcher operation modes
     * @return void
     * @since PECL ev >= 0.2.0
     **/
    public function set($offset, $interval){}

    /**
     * Constructs EvPeriodic watcher object
     *
     * Constructs EvPeriodic watcher object and starts it automatically.
     * EvPeriodic::createStopped method creates stopped periodic watcher.
     *
     * @param float $offset See Periodic watcher operation modes
     * @param string $interval See Periodic watcher operation modes
     * @param callable $reschedule_cb Reschedule callback. You can pass
     *   NULL. See Periodic watcher operation modes
     * @param callable $callback See Watcher callbacks .
     * @param mixed $data Custom data associated with the watcher.
     * @param int $priority Watcher priority
     * @since PECL ev >= 0.2.0
     **/
    public function __construct($offset, $interval, $reschedule_cb, $callback, $data, $priority){}

}
class EvPrepare extends EvWatcher {
    /**
     * Creates a stopped instance of EvPrepare watcher
     *
     * Creates a stopped instance of EvPrepare watcher. Unlike
     * EvPrepare::__construct , this method doesn start the watcher
     * automatically.
     *
     * @param callable $callback See Watcher callbacks .
     * @param mixed $data Custom data associated with the watcher.
     * @param int $priority Watcher priority
     * @return EvPrepare Return EvPrepare object on success.
     * @since PECL ev >= 0.2.0
     **/
    final public static function createStopped($callback, $data, $priority){}

    /**
     * Constructs EvPrepare watcher object
     *
     * Constructs EvPrepare watcher object. And starts the watcher
     * automatically. If need a stopped watcher consider using
     * EvPrepare::createStopped
     *
     * @param string $callback See Watcher callbacks .
     * @param string $data Custom data associated with the watcher.
     * @param string $priority Watcher priority
     * @since PECL ev >= 0.2.0
     **/
    public function __construct($callback, $data, $priority){}

}
/**
 * EvSignal watchers will trigger an event when the process receives a
 * specific signal one or more times. Even though signals are very
 * asynchronous, libev will try its best to deliver signals
 * synchronously, i.e. as part of the normal event processing, like any
 * other event. There is no limit for the number of watchers for the same
 * signal, but only within the same loop, i.e. one can watch for SIGINT
 * in the default loop and for SIGIO in another loop, but it is not
 * allowed to watch for SIGINT in both the default loop and another loop
 * at the same time. At the moment, SIGCHLD is permanently tied to the
 * default loop. If possible and supported, libev will install its
 * handlers with SA_RESTART (or equivalent) behaviour enabled, so system
 * calls should not be unduly interrupted. In case of a problem with
 * system calls getting interrupted by signals, all the signals can be
 * blocked in an EvCheck watcher and unblocked in a EvPrepare watcher.
 **/
class EvSignal extends EvWatcher {
    /**
     * Signal number. See the constants exported by pcntl extension. See also
     * signal(7) man page.
     *
     * @var mixed
     **/
    public $signum;

    /**
     * Create stopped EvSignal watcher object
     *
     * Create stopped EvSignal watcher object. Unlike EvSignal::__construct ,
     * this method doest start the watcher automatically.
     *
     * @param int $signum Signal number. See constants exported by pcntl
     *   extension. See also signal(7) man page.
     * @param callable $callback See Watcher callbacks .
     * @param mixed $data Custom data associated with the watcher.
     * @param int $priority Watcher priority
     * @return EvSignal Returns EvSignal object on success.
     * @since PECL ev >= 0.2.0
     **/
    final public static function createStopped($signum, $callback, $data, $priority){}

    /**
     * Configures the watcher
     *
     * @param int $signum Signal number. The same as for
     *   EvSignal::__construct
     * @return void
     * @since PECL ev >= 0.2.0
     **/
    public function set($signum){}

    /**
     * Constructs EvSignal watcher object
     *
     * Constructs EvSignal watcher object and starts it automatically. For a
     * stopped periodic watcher consider using EvSignal::createStopped
     * method.
     *
     * @param int $signum Signal number. See constants exported by pcntl
     *   extension. See also signal(7) man page.
     * @param callable $callback See Watcher callbacks .
     * @param mixed $data Custom data associated with the watcher.
     * @param int $priority Watcher priority
     * @since PECL ev >= 0.2.0
     **/
    public function __construct($signum, $callback, $data, $priority){}

}
/**
 * EvStat monitors a file system path for attribute changes. It calls
 * stat() on that path in regular intervals(or when the OS signals it
 * changed) and sees if it changed compared to the last time, invoking
 * the callback if it did. The path does not need to exist: changing from
 * "path exists" to "path does not exist" is a status change like any
 * other. The condition "path does not exist" is signified by the 'nlink'
 * item being 0(returned by EvStat::attr method). The path must not end
 * in a slash or contain special components such as '.' or .. . The path
 * should be absolute: if it is relative and the working directory
 * changes, then the behaviour is undefined. Since there is no portable
 * change notification interface available, the portable implementation
 * simply calls stat() regularly on the path to see if it changed
 * somehow. For this case a recommended polling interval can be
 * specified. If one specifies a polling interval of 0.0 (highly
 * recommended) then a suitable, unspecified default value will be
 * used(which could be expected to be around 5 seconds, although this
 * might change dynamically). libev will also impose a minimum interval
 * which is currently around 0.1 , but that’s usually overkill. This
 * watcher type is not meant for massive numbers of EvStat watchers, as
 * even with OS-supported change notifications, this can be
 * resource-intensive.
 **/
class EvStat extends EvWatcher {
    /**
     * Readonly . Hint on how quickly a change is expected to be detected and
     * should normally be specified as 0.0 to let libev choose a suitable
     * value.
     *
     * @var mixed
     **/
    public $interval;

    /**
     * Readonly . The path to wait for status changes on.
     *
     * @var mixed
     **/
    public $path;

    /**
     * Returns the values most recently detected by Ev
     *
     * Returns array of the values most recently detected by Ev
     *
     * @return array Returns array with the values most recently detect by
     *   Ev(without actual stat ing): List for item keys of the array
     *   returned by EvStat::attr Key Description 'dev' ID of device
     *   containing file 'ino' inode number 'mode' protection 'nlink' number
     *   of hard links 'uid' user ID of owner 'size' total size, in bytes
     *   'gid' group ID of owner 'rdev' device ID (if special file) 'blksize'
     *   blocksize for file system I/O 'blocks' number of 512B blocks
     *   allocated 'atime' time of last access 'ctime' time of last status
     *   change 'mtime' time of last modification
     * @since PECL ev >= 0.2.0
     **/
    public function attr(){}

    /**
     * Create a stopped EvStat watcher object
     *
     * Creates EvStat watcher object, but doesnt start it
     * automatically(unlike EvStat::__construct ).
     *
     * @param string $path The path to wait for status changes on.
     * @param float $interval Hint on how quickly a change is expected to
     *   be detected and should normally be specified as 0.0 to let libev
     *   choose a suitable value.
     * @param callable $callback See Watcher callbacks .
     * @param mixed $data Custom data associated with the watcher.
     * @param int $priority Watcher priority
     * @return void Returns a stopped EvStat watcher object on success.
     * @since PECL ev >= 0.2.0
     **/
    final public static function createStopped($path, $interval, $callback, $data, $priority){}

    /**
     * Returns the previous set of values returned by EvStat::attr
     *
     * Just like EvStat::attr , but returns the previous set of values.
     *
     * @return void Returns an array with the same structure as the array
     *   returned by EvStat::attr . The array contains previously detected
     *   values.
     * @since PECL ev >= 0.2.0
     **/
    public function prev(){}

    /**
     * Configures the watcher
     *
     * @param string $path The path to wait for status changes on.
     * @param float $interval Hint on how quickly a change is expected to
     *   be detected and should normally be specified as 0.0 to let libev
     *   choose a suitable value.
     * @return void
     * @since PECL ev >= 0.2.0
     **/
    public function set($path, $interval){}

    /**
     * Initiates the stat call
     *
     * Initiates the stat call(updates internal cache). It stats(using lstat
     * ) the path specified in the watcher and sets to the values found.
     *
     * @return bool Returns TRUE if path exists. Otherwise FALSE.
     * @since PECL ev >= 0.2.0
     **/
    public function stat(){}

    /**
     * Constructs EvStat watcher object
     *
     * Constructs EvStat watcher object and starts the watcher automatically.
     *
     * @param string $path The path to wait for status changes on.
     * @param float $interval Hint on how quickly a change is expected to
     *   be detected and should normally be specified as 0.0 to let libev
     *   choose a suitable value.
     * @param callable $callback See Watcher callbacks .
     * @param mixed $data Custom data associated with the watcher.
     * @param int $priority Watcher priority
     * @since PECL ev >= 0.2.0
     **/
    public function __construct($path, $interval, $callback, $data, $priority){}

}
/**
 * EvTimer watchers are simple relative timers that generate an event
 * after a given time, and optionally repeating in regular intervals
 * after that. The timers are based on real time, that is, if one
 * registers an event that times out after an hour and resets the system
 * clock to January last year , it will still time out after(roughly) one
 * hour. "Roughly" because detecting time jumps is hard, and some
 * inaccuracies are unavoidable. The callback is guaranteed to be invoked
 * only after its timeout has passed (not at, so on systems with very
 * low-resolution clocks this might introduce a small delay). If multiple
 * timers become ready during the same loop iteration then the ones with
 * earlier time-out values are invoked before ones of the same priority
 * with later time-out values (but this is no longer true when a callback
 * calls EvLoop::run recursively). The timer itself will do a best-effort
 * at avoiding drift, that is, if a timer is configured to trigger every
 * 10 seconds, then it will normally trigger at exactly 10 second
 * intervals. If, however, the script cannot keep up with the timer
 * because it takes longer than those 10 seconds to do) the timer will
 * not fire more than once per event loop iteration.
 **/
class EvTimer extends EvWatcher {
    /**
     * Returns the remaining time until a timer fires. If the timer is
     * active, then this time is relative to the current event loop time,
     * otherwise its the timeout value currently configured.
     *
     * That is, after instanciating an EvTimer with an {@link after} value of
     * 5.0 and {@link repeat} value of 7.0 , remaining returns 5.0 . When the
     * timer is started and one second passes, remaining will return 4.0 .
     * When the timer expires and is restarted, it will return roughly 7.0
     * (likely slightly less as callback invocation takes some time too), and
     * so on.
     *
     * @var mixed
     **/
    public $remaining;

    /**
     * If repeat is 0.0 , then it will automatically be stopped once the
     * timeout is reached. If it is positive, then the timer will
     * automatically be configured to trigger again every repeat seconds
     * later, until stopped manually.
     *
     * @var mixed
     **/
    public $repeat;

    /**
     * Restarts the timer watcher
     *
     * This will act as if the timer timed out and restart it again if it is
     * repeating. The exact semantics are:
     *
     * @return void
     * @since PECL ev >= 0.2.0
     **/
    public function again(){}

    /**
     * Creates EvTimer stopped watcher object
     *
     * Creates EvTimer stopped watcher object. Unlike EvTimer::__construct ,
     * this method doesn't start the watcher automatically.
     *
     * @param float $after Configures the timer to trigger after {@link
     *   after} seconds.
     * @param float $repeat If repeat is 0.0 , then it will automatically
     *   be stopped once the timeout is reached. If it is positive, then the
     *   timer will automatically be configured to trigger again every repeat
     *   seconds later, until stopped manually.
     * @param callable $callback See Watcher callbacks .
     * @param mixed $data Custom data associated with the watcher.
     * @param int $priority Watcher priority
     * @return EvTimer Returns EvTimer watcher object on success.
     * @since PECL ev >= 0.2.0
     **/
    final public static function createStopped($after, $repeat, $callback, $data, $priority){}

    /**
     * Configures the watcher
     *
     * @param float $after Configures the timer to trigger after {@link
     *   after} seconds.
     * @param float $repeat If repeat is 0.0 , then it will automatically
     *   be stopped once the timeout is reached. If it is positive, then the
     *   timer will automatically be configured to trigger again every repeat
     *   seconds later, until stopped manually.
     * @return void
     * @since PECL ev >= 0.2.0
     **/
    public function set($after, $repeat){}

    /**
     * Constructs an EvTimer watcher object
     *
     * @param float $after Configures the timer to trigger after {@link
     *   after} seconds.
     * @param float $repeat If repeat is 0.0 , then it will automatically
     *   be stopped once the timeout is reached. If it is positive, then the
     *   timer will automatically be configured to trigger again every repeat
     *   seconds later, until stopped manually.
     * @param callable $callback See Watcher callbacks .
     * @param mixed $data Custom data associated with the watcher.
     * @param int $priority Watcher priority
     * @since PECL ev >= 0.2.0
     **/
    public function __construct($after, $repeat, $callback, $data, $priority){}

}
/**
 * EvWatcher is a base class for all watchers( EvCheck , EvChild etc.).
 * Since EvWatcher s constructor is abstract , one cant(and dont need to)
 * create EvWatcher objects directly.
 **/
abstract class EvWatcher {
    /**
     * User custom data associated with the watcher
     *
     * @var mixed
     **/
    public $data;

    /**
     * @var mixed
     **/
    public $is_active;

    /**
     * @var mixed
     **/
    public $is_pending;

    /**
     * Integer between Ev::MINPRI and Ev::MAXPRI . Pending watchers with
     * higher priority will be invoked before watchers with lower priority,
     * but priority will not keep watchers from being executed(except for
     * EvIdle watchers). EvIdle watchers provide functionality to suppress
     * invocation when higher priority events are pending.
     *
     * @var mixed
     **/
    public $priority;

    /**
     * Clear watcher pending status
     *
     * If the watcher is pending, this method clears its pending status and
     * returns its revents bitset(as if its callback was invoked). If the
     * watcher isnt pending it does nothing and returns 0 .
     *
     * Sometimes it can be useful to "poll" a watcher instead of waiting for
     * its callback to be invoked, which can be accomplished with this
     * function.
     *
     * @return int In case if the watcher is pending, returns revents
     *   bitset as if the watcher callback had been invoked. Otherwise
     *   returns 0 .
     * @since PECL ev >= 0.2.0
     **/
    public function clear(){}

    /**
     * Feeds the given revents set into the event loop
     *
     * Feeds the given revents set into the event loop, as if the specified
     * event had happened for the watcher.
     *
     * @param int $revents Bit mask of watcher received events .
     * @return void
     * @since PECL ev >= 0.2.0
     **/
    public function feed($revents){}

    /**
     * Returns the loop responsible for the watcher
     *
     * @return EvLoop Returns EvLoop event loop object responsible for the
     *   watcher.
     * @since PECL ev >= 0.2.0
     **/
    public function getLoop(){}

    /**
     * Invokes the watcher callback with the given received events bit mask
     *
     * Invokes the watcher callback with the given received events bit mask.
     *
     * @param int $revents Bit mask of watcher received events .
     * @return void
     * @since PECL ev >= 0.2.0
     **/
    public function invoke($revents){}

    /**
     * Configures whether to keep the loop from returning
     *
     * Configures whether to keep the loop from returning. With keepalive
     * {@link value} set to FALSE the watcher wont keep Ev::run / EvLoop::run
     * from returning even though the watcher is active.
     *
     * Watchers have keepalive {@link value} TRUE by default.
     *
     * Clearing keepalive status is useful when returning from Ev::run /
     * EvLoop::run just because of the watcher is undesirable. It could be a
     * long running UDP socket watcher or so.
     *
     * @param bool $value With keepalive {@link value} set to FALSE the
     *   watcher wont keep Ev::run / EvLoop::run from returning even though
     *   the watcher is active.
     * @return bool Returns the previous state.
     * @since PECL ev >= 0.2.0
     **/
    public function keepalive($value){}

    /**
     * Sets new callback for the watcher
     *
     * @param callable $callback See Watcher callbacks .
     * @return void
     * @since PECL ev >= 0.2.0
     **/
    public function setCallback($callback){}

    /**
     * Starts the watcher
     *
     * Marks the watcher as active. Note that only active watchers will
     * receive events.
     *
     * @return void
     * @since PECL ev >= 0.2.0
     **/
    public function start(){}

    /**
     * Stops the watcher
     *
     * Marks the watcher as inactive. Note that only active watchers will
     * receive events.
     *
     * @return void
     * @since PECL ev >= 0.2.0
     **/
    public function stop(){}

    /**
     * Abstract constructor of a watcher object
     *
     * EvWatcher::__construct is an abstract constructor of a watcher object
     * implemented in the derived classes.
     *
     * @since PECL ev >= 0.2.0
     **/
    abstract public function __construct();

}
/**
 * FANNConnection is used for the neural network connection. The objects
 * of this class are used in {@link fann_get_connection_array} and {@link
 * fann_set_weight_array}.
 **/
class FANNConnection {
    /**
     * @var mixed
     **/
    public $from_neuron;

    /**
     * @var mixed
     **/
    public $to_neuron;

    /**
     * The weight of the connection.
     *
     * @var mixed
     **/
    public $weight;

    /**
     * Returns the postions of starting neuron
     *
     * @return int The postions of starting neuron.
     * @since PECL fann >= 1.0.0
     **/
    public function getFromNeuron(){}

    /**
     * Returns the postions of terminating neuron
     *
     * @return int The postions of terminating neuron.
     * @since PECL fann >= 1.0.0
     **/
    public function getToNeuron(){}

    /**
     * Returns the connection weight
     *
     * @return void The connection weight.
     * @since PECL fann >= 1.0.0
     **/
    public function getWeight(){}

    /**
     * Sets the connections weight
     *
     * Sets the connection weight.
     *
     * This method is different than {@link fann_set_weight}. It does not
     * update the weight value in the network. The network value is updated
     * only after calling {@link fann_set_weight_array}.
     *
     * @param float $weight The connection weight.
     * @return void
     * @since PECL fann >= 1.0.0
     **/
    public function setWeight($weight){}

    /**
     * The connection constructor
     *
     * Create new connection and initialize its params. After creating the
     * connection, only weight can be changed.
     *
     * @param int $from_neuron The postion number of starting neuron.
     * @param int $to_neuron The postion number of terminating neuron.
     * @param float $weight The connection weight value.
     * @since PECL fann >= 1.0.0
     **/
    public function __construct($from_neuron, $to_neuron, $weight){}

}
/**
 * Objects of this class are created by the factory methods FFI::cdef,
 * FFI::load or FFI::scope. Defined C variables are made available as
 * properties of the FFI instance, and defined C functions are made
 * available as methods of the FFI instance. Declared C types can be used
 * to create new C data structures using FFI::new and FFI::type. FFI
 * definition parsing and shared library loading may take significant
 * time. It is not useful to do it on each HTTP request in a Web
 * environment. However, it is possible to preload FFI definitions and
 * libraries at PHP startup, and to instantiate FFI objects when
 * necessary. Header files may be extended with special FFI_SCOPE defines
 * (e.g. #define FFI_SCOPE "foo"”"; the default scope is "C") and then
 * loaded by FFI::load during preloading. This leads to the creation of a
 * persistent binding, that will be available to all the following
 * requests through FFI::scope. Refer to the complete PHP/FFI/preloading
 * example for details. It is possible to preload more than one C header
 * file into the same scope.
 **/
class FFI {
    /**
     * Creates an unmanaged pointer to C data
     *
     * Creates an unmanaged pointer to the C data represented by the given
     * FFI\CData. The source {@link ptr} must survive the resulting pointer.
     * This function is mainly useful to pass arguments to C functions by
     * pointer.
     *
     * @param FFI\CData $ptr The handle of the pointer to a C data
     *   structure.
     * @return FFI\CData Returns the freshly created FFI\CData object.
     * @since PHP 7 >= 7.4.0
     **/
    public static function addr(&$ptr){}

    /**
     * Gets the alignment
     *
     * Gets the alignment of the given FFI\CData or FFI\CType object.
     *
     * @param mixed $ptr The handle of the C data or type.
     * @return int Returns the alignment of the given FFI\CData or
     *   FFI\CType object.
     * @since PHP 7 >= 7.4.0
     **/
    public static function alignof(&$ptr){}

    /**
     * Dynamically constructs a new C array type
     *
     * Dynamically constructs a new C array type with elements of type
     * defined by {@link type}, and dimensions specified by {@link dims}. In
     * the following example $t1 and $t2 are equivalent array types:
     *
     * <?php $t1 = FFI::type("int[2][3]"); $t2 =
     * FFI::arrayType(FFI::type("int"), [2, 3]); ?>
     *
     * @param FFI\CType $type A valid C declaration as string, or an
     *   instance of FFI\CType which has already been created.
     * @param array $dims The dimensions of the type as array.
     * @return FFI\CType Returns the freshly created FFI\CType object.
     * @since PHP 7 >= 7.4.0
     **/
    public static function arrayType($type, $dims){}

    /**
     * Performs a C type cast
     *
     * FFI::cast creates a new FFI\CData object, that references the same C
     * data structure, but is associated with a different type. The resulting
     * object does not own the C data, and the source {@link ptr} must
     * survive the result. The C type may be specified as a string with any
     * valid C type declaration or as FFI\CType object, created before. If
     * this method is called statically, it must only use predefined C type
     * names (e.g. int, char, etc.); if the method is called as instance
     * method, any type declared for the instance is allowed.
     *
     * @param mixed $type A valid C declaration as string, or an instance
     *   of FFI\CType which has already been created.
     * @param FFI\CData $ptr The handle of the pointer to a C data
     *   structure.
     * @return FFI\CData Returns the freshly created FFI\CData object.
     * @since PHP 7 >= 7.4.0
     **/
    public static function cast($type, &$ptr){}

    /**
     * Creates a new FFI object
     *
     * @param string $code A string containing a sequence of declarations
     *   in regular C language (types, structures, functions, variables,
     *   etc). Actually, this string may be copy-pasted from C header files.
     * @param string $lib The name of a shared library file, to be loaded
     *   and linked with the definitions.
     * @return FFI Returns the freshly created FFI object.
     * @since PHP 7 >= 7.4.0
     **/
    public static function cdef($code, $lib){}

    /**
     * Releases an unmanaged data structure
     *
     * Manually releases a previously created unmanaged data structure.
     *
     * @param FFI\CData $ptr The handle of the unmanaged pointer to a C
     *   data structure.
     * @return void
     * @since PHP 7 >= 7.4.0
     **/
    public static function free(&$ptr){}

    /**
     * Checks whether a FFI\CData is a null pointer
     *
     * @param FFI\CData $ptr The handle of the pointer to a C data
     *   structure.
     * @return bool Returns whether a FFI\CData is a null pointer.
     * @since PHP 7 >= 7.4.0
     **/
    public static function isNull(&$ptr){}

    /**
     * Loads C declarations from a C header file
     *
     * Loads C declarations from a C header file. It is possible to specify
     * shared libraries that should be loaded, using special FFI_LIB defines
     * in the loaded C header file.
     *
     * @param string $filename The name of a C header file.
     * @return FFI Returns the freshly created FFI object.
     * @since PHP 7 >= 7.4.0
     **/
    public static function load($filename){}

    /**
     * Compares memory areas
     *
     * Compares {@link size} bytes from the memory areas {@link ptr1} and
     * {@link ptr2}. Both {@link ptr1} and {@link ptr2} can be any native
     * data structures (FFI\CData) or PHP strings.
     *
     * @param mixed $ptr1 The start of one memory area.
     * @param mixed $ptr2 The start of another memory area.
     * @param int $size The number of bytes to compare.
     * @return int Returns < 0 if the contents of the memory area starting
     *   at {@link ptr1} are considered less than the contents of the memory
     *   area starting at {@link ptr2}, > 0 if the contents of the first
     *   memory area are considered greater than the second, and 0 if they
     *   are equal.
     * @since PHP 7 >= 7.4.0
     **/
    public static function memcmp(&$ptr1, &$ptr2, $size){}

    /**
     * Copies one memory area to another
     *
     * Copies {@link size} bytes from the memory area {@link src} to the
     * memory area {@link dst}. Both {@link src} and {@link dst} can be any
     * native data structures (FFI\CData) or PHP strings.
     *
     * @param FFI\CData $dst The start of the memory area to copy to.
     * @param mixed $src The start of the memory area to copy from.
     * @param int $size The number of bytes to copy.
     * @return void
     * @since PHP 7 >= 7.4.0
     **/
    public static function memcpy(&$dst, &$src, $size){}

    /**
     * Fills a memory area
     *
     * Fills {@link size} bytes of the memory area pointed to by {@link ptr}
     * with the given byte {@link ch}.
     *
     * @param FFI\CData $ptr The start of the memory area to fill.
     * @param int $ch The byte to fill with.
     * @param int $size The number of bytes to fill.
     * @return void
     * @since PHP 7 >= 7.4.0
     **/
    public static function memset(&$ptr, $ch, $size){}

    /**
     * Creates a C data structure
     *
     * Creates a native data structure of the given C type. If this method is
     * called statically, it must only use predefined C type names (e.g. int,
     * char, etc.); if the method is called as instance method, any type
     * declared for the instance is allowed.
     *
     * @param mixed $type {@link type} is a valid C declaration as string,
     *   or an instance of FFI\CType which has already been created.
     * @param bool $owned Whether to create owned (i.e. managed) or
     *   unmanaged data. Managed data lives together with the returned
     *   FFI\CData object, and is released when the last reference to that
     *   object is released by regular PHP reference counting or GC.
     *   Unmanaged data should be released by calling FFI::free, when no
     *   longer needed.
     * @param bool $persistent Whether to allocate the C data structure
     *   permanently on the system heap (using {@link malloc}), or on the PHP
     *   request heap (using {@link emalloc}).
     * @return FFI\CData Returns the freshly created FFI\CData object.
     * @since PHP 7 >= 7.4.0
     **/
    public static function new($type, $owned, $persistent){}

    /**
     * Instantiates an FFI object with C declarations parsed during
     * preloading
     *
     * @param string $scope_name The scope name defined by a special
     *   FFI_SCOPE define.
     * @return FFI Returns the freshly created FFI object.
     * @since PHP 7 >= 7.4.0
     **/
    public static function scope($scope_name){}

    /**
     * Gets the size of C data or types
     *
     * Returns the size of the given FFI\CData or FFI\CType object.
     *
     * @param mixed $ptr The handle of the C data or type.
     * @return int The size of the memory area pointed at by {@link ptr}.
     * @since PHP 7 >= 7.4.0
     **/
    public static function sizeof(&$ptr){}

    /**
     * Creates a PHP string from a memory area
     *
     * Creates a PHP string from {@link size} bytes of the memory area
     * pointed to by {@link ptr}.
     *
     * @param FFI\CData $ptr The start of the memory area from which to
     *   create a string.
     * @param int $size The number of bytes to copy to the string. If
     *   {@link size} is omitted, {@link ptr} must be a zero terminated array
     *   of C chars.
     * @return string The freshly created PHP string.
     * @since PHP 7 >= 7.4.0
     **/
    public static function string(&$ptr, $size){}

    /**
     * Creates an FFI\CType object from a C declaration
     *
     * This function creates and returns a FFI\CType object for the given
     * string containing a C type declaration. If this method is called
     * statically, it must only use predefined C type names (e.g. int, char,
     * etc.); if the method is called as instance method, any type declared
     * for the instance is allowed.
     *
     * @param mixed $type A valid C declaration as string, or an instance
     *   of FFI\CType which has already been created.
     * @return FFI\CType Returns the freshly created FFI\CType object.
     * @since PHP 7 >= 7.4.0
     **/
    public static function type($type){}

    /**
     * Gets the FFI\CType of FFI\CData
     *
     * Gets the FFI\CType object representing the type of the given FFI\CData
     * object.
     *
     * @param FFI\CData $ptr The handle of the pointer to a C data
     *   structure.
     * @return FFI\CType Returns the FFI\CType object representing the type
     *   of the given FFI\CData object.
     * @since PHP 7 >= 7.4.0
     **/
    public static function typeof(&$ptr){}

}
namespace FFI {
class CData {
}
}
namespace FFI {
class CType {
}
}
namespace FFI {
class Exception extends Error implements Throwable {
}
}
namespace FFI {
class ParserException extends FFI\Exception implements Throwable {
}
}
/**
 * The Filesystem iterator
 **/
class FilesystemIterator extends DirectoryIterator implements SeekableIterator {
    /**
     * @var integer
     **/
    const CURRENT_AS_FILEINFO = 0;

    /**
     * @var integer
     **/
    const CURRENT_AS_PATHNAME = 0;

    /**
     * @var integer
     **/
    const CURRENT_AS_SELF = 0;

    /**
     * @var integer
     **/
    const CURRENT_MODE_MASK = 0;

    /**
     * @var integer
     **/
    const FOLLOW_SYMLINKS = 0;

    /**
     * @var integer
     **/
    const KEY_AS_FILENAME = 0;

    /**
     * @var integer
     **/
    const KEY_AS_PATHNAME = 0;

    /**
     * @var integer
     **/
    const KEY_MODE_MASK = 0;

    /**
     * @var integer
     **/
    const NEW_CURRENT_AND_KEY = 0;

    /**
     * @var integer
     **/
    const SKIP_DOTS = 0;

    /**
     * @var integer
     **/
    const UNIX_PATHS = 0;

    /**
     * The current file
     *
     * Get file information of the current element.
     *
     * @return mixed The filename, file information, or $this depending on
     *   the set flags. See the FilesystemIterator constants.
     * @since PHP 5 >= 5.3.0, PHP 7
     **/
    public function current(){}

    /**
     * Get the handling flags
     *
     * Gets the handling flags, as set in FilesystemIterator::__construct or
     * FilesystemIterator::setFlags.
     *
     * @return int The integer value of the set flags.
     * @since PHP 5 >= 5.3.0, PHP 7
     **/
    public function getFlags(){}

    /**
     * Retrieve the key for the current file
     *
     * @return string Returns the pathname or filename depending on the set
     *   flags. See the FilesystemIterator constants.
     * @since PHP 5 >= 5.3.0, PHP 7
     **/
    public function key(){}

    /**
     * Move to the next file
     *
     * @return void
     * @since PHP 5 >= 5.3.0, PHP 7
     **/
    public function next(){}

    /**
     * Rewinds back to the beginning
     *
     * Rewinds the directory back to the start.
     *
     * @return void
     * @since PHP 5 >= 5.3.0, PHP 7
     **/
    public function rewind(){}

    /**
     * Sets handling flags
     *
     * @param int $flags The handling flags to set. See the
     *   FilesystemIterator constants.
     * @return void
     * @since PHP 5 >= 5.3.0, PHP 7
     **/
    public function setFlags($flags){}

    /**
     * Constructs a new filesystem iterator
     *
     * Constructs a new filesystem iterator from the {@link path}.
     *
     * @param string $path The path of the filesystem item to be iterated
     *   over.
     * @param int $flags Flags may be provided which will affect the
     *   behavior of some methods. A list of the flags can found under
     *   FilesystemIterator predefined constants. They can also be set later
     *   with FilesystemIterator::setFlags
     * @since PHP 5 >= 5.3.0, PHP 7
     **/
    public function __construct($path, $flags){}

}
/**
 * This abstract iterator filters out unwanted values. This class should
 * be extended to implement custom iterator filters. The
 * FilterIterator::accept must be implemented in the subclass.
 **/
abstract class FilterIterator extends IteratorIterator implements OuterIterator {
    /**
     * Check whether the current element of the iterator is acceptable
     *
     * Returns whether the current element of the iterator is acceptable
     * through this filter.
     *
     * @return bool TRUE if the current element is acceptable, otherwise
     *   FALSE.
     * @since PHP 5 >= 5.1.0, PHP 7
     **/
    public abstract function accept();

    /**
     * Get the current element value
     *
     * @return mixed The current element value.
     * @since PHP 5 >= 5.1.0, PHP 7
     **/
    public function current(){}

    /**
     * Get the inner iterator
     *
     * @return Iterator The inner iterator.
     * @since PHP 5 >= 5.1.0, PHP 7
     **/
    public function getInnerIterator(){}

    /**
     * Get the current key
     *
     * @return mixed The current key.
     * @since PHP 5 >= 5.1.0, PHP 7
     **/
    public function key(){}

    /**
     * Move the iterator forward
     *
     * @return void
     * @since PHP 5 >= 5.1.0, PHP 7
     **/
    public function next(){}

    /**
     * Rewind the iterator
     *
     * @return void
     * @since PHP 5 >= 5.1.0, PHP 7
     **/
    public function rewind(){}

    /**
     * Check whether the current element is valid
     *
     * Checks whether the current element is valid.
     *
     * @return bool TRUE if the current element is valid, otherwise FALSE
     * @since PHP 5 >= 5.1.0, PHP 7
     **/
    public function valid(){}

    /**
     * Construct a filterIterator
     *
     * Constructs a new FilterIterator, which consists of a passed in {@link
     * iterator} with filters applied to it.
     *
     * @param Iterator $iterator The iterator that is being filtered.
     * @since PHP 5 >= 5.1.0, PHP 7
     **/
    public function __construct($iterator){}

}
/**
 * This class provides an object oriented interface into the fileinfo
 * functions.
 **/
class finfo {
    /**
     * finfo_buffer()
     *
     * @param string $string
     * @param int $options
     * @param resource $context
     * @return string
     * @since PHP 5 >= 5.3.0, PHP 7, PECL fileinfo >= 0.1.0
     **/
    public function buffer($string, $options, $context){}

    /**
     * finfo_file()
     *
     * @param string $file_name
     * @param int $options
     * @param resource $context
     * @return string
     * @since PHP >= 5.3.0, PECL fileinfo >= 0.1.0
     **/
    public function file($file_name, $options, $context){}

    /**
     * finfo_set_flags()
     *
     * @param int $options
     * @return bool
     * @since PHP >= 5.3.0, PECL fileinfo >= 0.1.0
     **/
    public function set_flags($options){}

}
/**
 * Represents a class for connecting to a Gearman job server and making
 * requests to perform some function on provided data. The function
 * performed must be one registered by a Gearman worker and the data
 * passed is opaque to the job server.
 **/
class GearmanClient {
    /**
     * Add client options
     *
     * Adds one or more options to those already set.
     *
     * @param int $options The options to add. One of the following
     *   constants, or a combination of them using the bitwise OR operator
     *   (|): GEARMAN_CLIENT_GENERATE_UNIQUE, GEARMAN_CLIENT_NON_BLOCKING,
     *   GEARMAN_CLIENT_UNBUFFERED_RESULT or GEARMAN_CLIENT_FREE_TASKS.
     * @return bool Always returns TRUE.
     * @since PECL gearman >= 0.6.0
     **/
    public function addOptions($options){}

    /**
     * Add a job server to the client
     *
     * Adds a job server to a list of servers that can be used to run a task.
     * No socket I/O happens here; the server is simply added to the list.
     *
     * @param string $host
     * @param int $port
     * @return bool
     * @since PECL gearman >= 0.5.0
     **/
    public function addServer($host, $port){}

    /**
     * Add a list of job servers to the client
     *
     * Adds a list of job servers that can be used to run a task. No socket
     * I/O happens here; the servers are simply added to the full list of
     * servers.
     *
     * @param string $servers A comma-separated list of servers, each
     *   server specified in the format host:port.
     * @return bool
     * @since PECL gearman >= 0.5.0
     **/
    public function addServers($servers){}

    /**
     * Add a task to be run in parallel
     *
     * Adds a task to be run in parallel with other tasks. Call this method
     * for all the tasks to be run in parallel, then call
     * GearmanClient::runTasks to perform the work. Note that enough workers
     * need to be available for the tasks to all run in parallel.
     *
     * @param string $function_name
     * @param string $workload
     * @param mixed $context
     * @param string $unique
     * @return GearmanTask A GearmanTask object or FALSE if the task could
     *   not be added.
     * @since PECL gearman >= 0.5.0
     **/
    public function addTask($function_name, $workload, &$context, $unique){}

    /**
     * Add a background task to be run in parallel
     *
     * Adds a background task to be run in parallel with other tasks. Call
     * this method for all the tasks to be run in parallel, then call
     * GearmanClient::runTasks to perform the work.
     *
     * @param string $function_name
     * @param string $workload
     * @param mixed $context
     * @param string $unique
     * @return GearmanTask A GearmanTask object or FALSE if the task could
     *   not be added.
     * @since PECL gearman >= 0.5.0
     **/
    public function addTaskBackground($function_name, $workload, &$context, $unique){}

    /**
     * Add a high priority task to run in parallel
     *
     * Adds a high priority task to be run in parallel with other tasks. Call
     * this method for all the high priority tasks to be run in parallel,
     * then call GearmanClient::runTasks to perform the work. Tasks with a
     * high priority will be selected from the queue before those of normal
     * or low priority.
     *
     * @param string $function_name
     * @param string $workload
     * @param mixed $context
     * @param string $unique
     * @return GearmanTask A GearmanTask object or FALSE if the task could
     *   not be added.
     * @since PECL gearman >= 0.5.0
     **/
    public function addTaskHigh($function_name, $workload, &$context, $unique){}

    /**
     * Add a high priority background task to be run in parallel
     *
     * Adds a high priority background task to be run in parallel with other
     * tasks. Call this method for all the tasks to be run in parallel, then
     * call GearmanClient::runTasks to perform the work. Tasks with a high
     * priority will be selected from the queue before those of normal or low
     * priority.
     *
     * @param string $function_name
     * @param string $workload
     * @param mixed $context
     * @param string $unique
     * @return GearmanTask A GearmanTask object or FALSE if the task could
     *   not be added.
     * @since PECL gearman >= 0.5.0
     **/
    public function addTaskHighBackground($function_name, $workload, &$context, $unique){}

    /**
     * Add a low priority task to run in parallel
     *
     * Adds a low priority background task to be run in parallel with other
     * tasks. Call this method for all the tasks to be run in parallel, then
     * call GearmanClient::runTasks to perform the work. Tasks with a low
     * priority will be selected from the queue after those of normal or low
     * priority.
     *
     * @param string $function_name
     * @param string $workload
     * @param mixed $context
     * @param string $unique
     * @return GearmanTask A GearmanTask object or FALSE if the task could
     *   not be added.
     * @since PECL gearman >= 0.5.0
     **/
    public function addTaskLow($function_name, $workload, &$context, $unique){}

    /**
     * Add a low priority background task to be run in parallel
     *
     * Adds a low priority background task to be run in parallel with other
     * tasks. Call this method for all the tasks to be run in parallel, then
     * call GearmanClient::runTasks to perform the work. Tasks with a low
     * priority will be selected from the queue after those of normal or high
     * priority.
     *
     * @param string $function_name
     * @param string $workload
     * @param mixed $context
     * @param string $unique
     * @return GearmanTask A GearmanTask object or FALSE if the task could
     *   not be added.
     * @since PECL gearman >= 0.5.0
     **/
    public function addTaskLowBackground($function_name, $workload, &$context, $unique){}

    /**
     * Add a task to get status
     *
     * Used to request status information from the Gearman server, which will
     * call the specified status callback (set using
     * GearmanClient::setStatusCallback).
     *
     * @param string $job_handle The job handle for the task to get status
     *   for
     * @param string $context Data to be passed to the status callback,
     *   generally a reference to an array or object
     * @return GearmanTask A GearmanTask object.
     * @since PECL gearman >= 0.5.0
     **/
    public function addTaskStatus($job_handle, &$context){}

    /**
     * Clear all task callback functions
     *
     * Clears all the task callback functions that have previously been set.
     *
     * @return bool Always returns TRUE.
     * @since PECL gearman >= 0.5.0
     **/
    public function clearCallbacks(){}

    /**
     * Get the application context
     *
     * Get the application context previously set with
     * GearmanClient::setContext.
     *
     * @return string The same context data structure set with
     *   GearmanClient::setContext
     * @since PECL gearman >= 0.6.0
     **/
    public function context(){}

    /**
     * Get the application data (deprecated)
     *
     * Get the application data previously set with GearmanClient::setData.
     *
     * @return string The same string data set with GearmanClient::setData
     * @since PECL gearman
     **/
    public function data(){}

    /**
     * Run a task in the background
     *
     * Runs a task in the background, returning a job handle which can be
     * used to get the status of the running task.
     *
     * @param string $function_name
     * @param string $workload
     * @param string $unique
     * @return string The job handle for the submitted task.
     * @since PECL gearman >= 0.5.0
     **/
    public function doBackground($function_name, $workload, $unique){}

    /**
     * Run a single high priority task
     *
     * Runs a single high priority task and returns a string representation
     * of the result. It is up to the GearmanClient and GearmanWorker to
     * agree on the format of the result. High priority tasks will get
     * precedence over normal and low priority tasks in the job queue.
     *
     * @param string $function_name
     * @param string $workload
     * @param string $unique
     * @return string A string representing the results of running a task.
     * @since PECL gearman >= 0.5.0
     **/
    public function doHigh($function_name, $workload, $unique){}

    /**
     * Run a high priority task in the background
     *
     * Runs a high priority task in the background, returning a job handle
     * which can be used to get the status of the running task. High priority
     * tasks take precedence over normal and low priority tasks in the job
     * queue.
     *
     * @param string $function_name
     * @param string $workload
     * @param string $unique
     * @return string The job handle for the submitted task.
     * @since PECL gearman >= 0.5.0
     **/
    public function doHighBackground($function_name, $workload, $unique){}

    /**
     * Get the job handle for the running task
     *
     * Gets that job handle for a running task. This should be used between
     * repeated GearmanClient::doNormal calls. The job handle can then be
     * used to get information on the task.
     *
     * @return string The job handle for the running task.
     * @since PECL gearman >= 0.5.0
     **/
    public function doJobHandle(){}

    /**
     * Run a single low priority task
     *
     * Runs a single low priority task and returns a string representation of
     * the result. It is up to the GearmanClient and GearmanWorker to agree
     * on the format of the result. Normal and high priority tasks will get
     * precedence over low priority tasks in the job queue.
     *
     * @param string $function_name
     * @param string $workload
     * @param string $unique
     * @return string A string representing the results of running a task.
     * @since PECL gearman >= 0.5.0
     **/
    public function doLow($function_name, $workload, $unique){}

    /**
     * Run a low priority task in the background
     *
     * Runs a low priority task in the background, returning a job handle
     * which can be used to get the status of the running task. Normal and
     * high priority tasks take precedence over low priority tasks in the job
     * queue.
     *
     * @param string $function_name
     * @param string $workload
     * @param string $unique
     * @return string The job handle for the submitted task.
     * @since PECL gearman >= 0.5.0
     **/
    public function doLowBackground($function_name, $workload, $unique){}

    /**
     * Run a single task and return a result
     *
     * Runs a single task and returns a string representation of the result.
     * It is up to the GearmanClient and GearmanWorker to agree on the format
     * of the result.
     *
     * @param string $function_name
     * @param string $workload
     * @param string $unique
     * @return string A string representing the results of running a task.
     **/
    public function doNormal($function_name, $workload, $unique){}

    /**
     * Get the status for the running task
     *
     * Returns the status for the running task. This should be used between
     * repeated GearmanClient::doNormal calls.
     *
     * @return array An array representing the percentage completion given
     *   as a fraction, with the first element the numerator and the second
     *   element the denomintor.
     * @since PECL gearman >= 0.5.0
     **/
    public function doStatus(){}

    /**
     * Returns an error string for the last error encountered
     *
     * @return string A human readable error string.
     * @since PECL gearman >= 0.5.0
     **/
    public function error(){}

    /**
     * Get an errno value
     *
     * Value of errno in the case of a GEARMAN_ERRNO return value.
     *
     * @return int A valid Gearman errno.
     * @since PECL gearman >= 0.5.0
     **/
    public function getErrno(){}

    /**
     * Get the status of a background job
     *
     * Gets the status for a background job given a job handle. The status
     * information will specify whether the job is known, whether the job is
     * currently running, and the percentage completion.
     *
     * @param string $job_handle
     * @return array An array containing status information for the job
     *   corresponding to the supplied job handle. The first array element is
     *   a boolean indicating whether the job is even known, the second is a
     *   boolean indicating whether the job is still running, and the third
     *   and fourth elements correspond to the numerator and denominator of
     *   the fractional completion percentage, respectively.
     * @since PECL gearman >= 0.5.0
     **/
    public function jobStatus($job_handle){}

    /**
     * Send data to all job servers to see if they echo it back
     *
     * Sends some arbitrary data to all job servers to see if they echo it
     * back. The data sent is not used or processed in any other way.
     * Primarily used for testing and debugging.
     *
     * @param string $workload Some arbitrary serialized data to be echo
     *   back
     * @return bool
     **/
    public function ping($workload){}

    /**
     * Remove client options
     *
     * Removes (unsets) one or more options.
     *
     * @param int $options The options to be removed (unset)
     * @return bool Always returns TRUE.
     * @since PECL gearman >= 0.6.0
     **/
    public function removeOptions($options){}

    /**
     * Get the last Gearman return code
     *
     * Returns the last Gearman return code.
     *
     * @return int A valid Gearman return code.
     * @since PECL gearman >= 0.5.0
     **/
    public function returnCode(){}

    /**
     * Run a list of tasks in parallel
     *
     * For a set of tasks previously added with GearmanClient::addTask,
     * GearmanClient::addTaskHigh, GearmanClient::addTaskLow,
     * GearmanClient::addTaskBackground,
     * GearmanClient::addTaskHighBackground, or
     * GearmanClient::addTaskLowBackground, this call starts running the
     * tasks in parallel.
     *
     * @return bool
     * @since PECL gearman >= 0.5.0
     **/
    public function runTasks(){}

    /**
     * Callback function when there is a data packet for a task (deprecated)
     *
     * Sets the callback function for accepting data packets for a task. The
     * callback function should take a single argument, a GearmanTask object.
     *
     * @param callable $callback A function or method to call
     * @return void
     * @since PECL gearman
     **/
    public function setClientCallback($callback){}

    /**
     * Set a function to be called on task completion
     *
     * Use to set a function to be called when a GearmanTask is completed, or
     * when GearmanJob::sendComplete is invoked by a worker (whichever
     * happens first).
     *
     * This callback executes only when executing a GearmanTask using
     * GearmanClient::runTasks. It is not used for individual jobs.
     *
     * @param callable $callback A function to be called
     * @return bool
     * @since PECL gearman >= 0.5.0
     **/
    public function setCompleteCallback($callback){}

    /**
     * Set application context
     *
     * Sets an arbitrary string to provide application context that can later
     * be retrieved by GearmanClient::context.
     *
     * @param string $context Arbitrary context data
     * @return bool Always returns TRUE.
     * @since PECL gearman >= 0.6.0
     **/
    public function setContext($context){}

    /**
     * Set a callback for when a task is queued
     *
     * Sets a function to be called when a task is received and queued by the
     * Gearman job server. The callback should accept a single argument, a
     * GearmanTask object.
     *
     * @param string $callback A function to call
     * @return bool
     * @since PECL gearman >= 0.5.0
     **/
    public function setCreatedCallback($callback){}

    /**
     * Set application data (deprecated)
     *
     * Sets some arbitrary application data that can later be retrieved by
     * GearmanClient::data.
     *
     * @param string $data
     * @return bool Always returns TRUE.
     * @since PECL gearman
     **/
    public function setData($data){}

    /**
     * Callback function when there is a data packet for a task
     *
     * Sets the callback function for accepting data packets for a task. The
     * callback function should take a single argument, a GearmanTask object.
     *
     * @param callable $callback A function or method to call
     * @return bool
     * @since PECL gearman >= 0.6.0
     **/
    public function setDataCallback($callback){}

    /**
     * Set a callback for worker exceptions
     *
     * Specifies a function to call when a worker for a task sends an
     * exception.
     *
     * @param callable $callback Function to call when the worker throws an
     *   exception
     * @return bool
     * @since PECL gearman >= 0.5.0
     **/
    public function setExceptionCallback($callback){}

    /**
     * Set callback for job failure
     *
     * Sets the callback function to be used when a task does not complete
     * successfully. The function should accept a single argument, a
     * GearmanTask object.
     *
     * @param callable $callback A function to call
     * @return bool
     * @since PECL gearman >= 0.5.0
     **/
    public function setFailCallback($callback){}

    /**
     * Set client options
     *
     * Sets one or more client options.
     *
     * @param int $options The options to be set
     * @return bool Always returns TRUE.
     * @since PECL gearman >= 0.5.0
     **/
    public function setOptions($options){}

    /**
     * Set a callback for collecting task status
     *
     * Sets a callback function used for getting updated status information
     * from a worker. The function should accept a single argument, a
     * GearmanTask object.
     *
     * @param callable $callback A function to call
     * @return bool
     * @since PECL gearman >= 0.5.0
     **/
    public function setStatusCallback($callback){}

    /**
     * Set socket I/O activity timeout
     *
     * Sets the timeout for socket I/O activity.
     *
     * @param int $timeout An interval of time in milliseconds
     * @return bool Always returns TRUE.
     * @since PECL gearman >= 0.6.0
     **/
    public function setTimeout($timeout){}

    /**
     * Set a callback for worker warnings
     *
     * Sets a function to be called when a worker sends a warning. The
     * callback should accept a single argument, a GearmanTask object.
     *
     * @param callable $callback A function to call
     * @return bool
     * @since PECL gearman >= 0.5.0
     **/
    public function setWarningCallback($callback){}

    /**
     * Set a callback for accepting incremental data updates
     *
     * Sets a function to be called when a worker needs to send back data
     * prior to job completion. A worker can do this when it needs to send
     * updates, send partial results, or flush data during long running jobs.
     * The callback should accept a single argument, a GearmanTask object.
     *
     * @param callable $callback A function to call
     * @return bool
     * @since PECL gearman >= 0.5.0
     **/
    public function setWorkloadCallback($callback){}

    /**
     * Get current socket I/O activity timeout value
     *
     * Returns the timeout in milliseconds to wait for I/O activity.
     *
     * @return int Timeout in milliseconds to wait for I/O activity. A
     *   negative value means an infinite timeout.
     * @since PECL gearman >= 0.6.0
     **/
    public function timeout(){}

    /**
     * Create a GearmanClient instance
     *
     * Creates a GearmanClient instance representing a client that connects
     * to the job server and submits tasks to complete.
     *
     * @since PECL gearman >= 0.5.0
     **/
    public function __construct(){}

}
class GearmanException extends Exception {
}
class GearmanJob {
    /**
     * Send the result and complete status (deprecated)
     *
     * Sends result data and the complete status update for this job.
     *
     * @param string $result Serialized result data.
     * @return bool
     * @since PECL gearman
     **/
    public function complete($result){}

    /**
     * Send data for a running job (deprecated)
     *
     * Sends data to the job server (and any listening clients) for this job.
     *
     * @param string $data Arbitrary serialized data.
     * @return bool
     * @since PECL gearman
     **/
    public function data($data){}

    /**
     * Send exception for running job (deprecated)
     *
     * Sends the supplied exception when this job is running.
     *
     * @param string $exception An exception description.
     * @return bool
     * @since PECL gearman
     **/
    public function exception($exception){}

    /**
     * Send fail status (deprecated)
     *
     * Sends failure status for this job, indicating that the job failed in a
     * known way (as opposed to failing due to a thrown exception).
     *
     * @return bool
     * @since PECL gearman
     **/
    public function fail(){}

    /**
     * Get function name
     *
     * Returns the function name for this job. This is the function the work
     * will execute to perform the job.
     *
     * @return string The name of a function.
     * @since PECL gearman >= 0.5.0
     **/
    public function functionName(){}

    /**
     * Get the job handle
     *
     * Returns the opaque job handle assigned by the job server.
     *
     * @return string An opaque job handle.
     * @since PECL gearman >= 0.5.0
     **/
    public function handle(){}

    /**
     * Get last return code
     *
     * Returns the last return code issued by the job server.
     *
     * @return int A valid Gearman return code.
     * @since PECL gearman >= 0.5.0
     **/
    public function returnCode(){}

    /**
     * Send the result and complete status
     *
     * Sends result data and the complete status update for this job.
     *
     * @param string $result Serialized result data.
     * @return bool
     * @since PECL gearman >= 0.6.0
     **/
    public function sendComplete($result){}

    /**
     * Send data for a running job
     *
     * Sends data to the job server (and any listening clients) for this job.
     *
     * @param string $data Arbitrary serialized data.
     * @return bool
     * @since PECL gearman >= 0.6.0
     **/
    public function sendData($data){}

    /**
     * Send exception for running job (exception)
     *
     * Sends the supplied exception when this job is running.
     *
     * @param string $exception An exception description.
     * @return bool
     * @since PECL gearman >= 0.6.0
     **/
    public function sendException($exception){}

    /**
     * Send fail status
     *
     * Sends failure status for this job, indicating that the job failed in a
     * known way (as opposed to failing due to a thrown exception).
     *
     * @return bool
     * @since PECL gearman >= 0.6.0
     **/
    public function sendFail(){}

    /**
     * Send status
     *
     * Sends status information to the job server and any listening clients.
     * Use this to specify what percentage of the job has been completed.
     *
     * @param int $numerator The numerator of the precentage completed
     *   expressed as a fraction.
     * @param int $denominator The denominator of the precentage completed
     *   expressed as a fraction.
     * @return bool
     * @since PECL gearman >= 0.6.0
     **/
    public function sendStatus($numerator, $denominator){}

    /**
     * Send a warning
     *
     * Sends a warning for this job while it is running.
     *
     * @param string $warning A warning message.
     * @return bool
     * @since PECL gearman >= 0.6.0
     **/
    public function sendWarning($warning){}

    /**
     * Set a return value
     *
     * Sets the return value for this job, indicates how the job completed.
     *
     * @param int $gearman_return_t A valid Gearman return value.
     * @return bool Description...
     * @since PECL gearman >= 0.5.0
     **/
    public function setReturn($gearman_return_t){}

    /**
     * Send status (deprecated)
     *
     * Sends status information to the job server and any listening clients.
     * Use this to specify what percentage of the job has been completed.
     *
     * @param int $numerator The numerator of the precentage completed
     *   expressed as a fraction.
     * @param int $denominator The denominator of the precentage completed
     *   expressed as a fraction.
     * @return bool
     * @since PECL gearman
     **/
    public function status($numerator, $denominator){}

    /**
     * Get the unique identifier
     *
     * Returns the unique identifiter for this job. The identifier is
     * assigned by the client.
     *
     * @return string An opaque unique identifier.
     * @since PECL gearman >= 0.5.0
     **/
    public function unique(){}

    /**
     * Send a warning (deprecated)
     *
     * Sends a warning for this job while it is running.
     *
     * @param string $warning A warning messages.
     * @return bool
     * @since PECL gearman
     **/
    public function warning($warning){}

    /**
     * Get workload
     *
     * Returns the workload for the job. This is serialized data that is to
     * be processed by the worker.
     *
     * @return string Serialized data.
     * @since PECL gearman >= 0.5.0
     **/
    public function workload(){}

    /**
     * Get size of work load
     *
     * Returns the size of the job's work load (the data the worker is to
     * process) in bytes.
     *
     * @return int The size in bytes.
     * @since PECL gearman >= 0.5.0
     **/
    public function workloadSize(){}

    /**
     * Create a GearmanJob instance
     *
     * Creates a GearmanJob instance representing a job the worker is to
     * complete.
     *
     * @since PECL gearman >= 0.5.0
     **/
    public function __construct(){}

}
class GearmanTask {
    /**
     * Create a task (deprecated)
     *
     * Returns a new GearmanTask object.
     *
     * @return GearmanTask A GearmanTask oject.
     * @since PECL gearman
     **/
    public function create(){}

    /**
     * Get data returned for a task
     *
     * Returns data being returned for a task by a worker.
     *
     * @return string The serialized data, or FALSE if no data is present.
     * @since PECL gearman >= 0.5.0
     **/
    public function data(){}

    /**
     * Get the size of returned data
     *
     * Returns the size of the data being returned for a task.
     *
     * @return int The data size, or FALSE if there is no data.
     * @since PECL gearman >= 0.5.0
     **/
    public function dataSize(){}

    /**
     * Get associated function name
     *
     * Returns the name of the function this task is associated with, i.e.,
     * the function the Gearman worker calls.
     *
     * @return string A function name.
     * @since PECL gearman >= 0.6.0
     **/
    public function functionName(){}

    /**
     * Determine if task is known
     *
     * Gets the status information for whether or not this task is known to
     * the job server.
     *
     * @return bool TRUE if the task is known, FALSE otherwise.
     * @since PECL gearman >= 0.5.0
     **/
    public function isKnown(){}

    /**
     * Test whether the task is currently running
     *
     * Indicates whether or not this task is currently running.
     *
     * @return bool TRUE if the task is running, FALSE otherwise.
     * @since PECL gearman >= 0.5.0
     **/
    public function isRunning(){}

    /**
     * Get the job handle
     *
     * Returns the job handle for this task.
     *
     * @return string The opaque job handle.
     * @since PECL gearman >= 0.5.0
     **/
    public function jobHandle(){}

    /**
     * Read work or result data into a buffer for a task
     *
     * @param int $data_len Length of data to be read.
     * @return array An array whose first element is the length of data
     *   read and the second is the data buffer. Returns FALSE if the read
     *   failed.
     * @since PECL gearman >= 0.5.0
     **/
    public function recvData($data_len){}

    /**
     * Get the last return code
     *
     * Returns the last Gearman return code for this task.
     *
     * @return int A valid Gearman return code.
     * @since PECL gearman >= 0.5.0
     **/
    public function returnCode(){}

    /**
     * Send data for a task (deprecated)
     *
     * @param string $data Data to send to the worker.
     * @return int The length of data sent, or FALSE if the send failed.
     * @since PECL gearman
     **/
    public function sendData($data){}

    /**
     * Send data for a task
     *
     * @param string $data Data to send to the worker.
     * @return int The length of data sent, or FALSE if the send failed.
     * @since PECL gearman >= 0.6.0
     **/
    public function sendWorkload($data){}

    /**
     * Get completion percentage denominator
     *
     * Returns the denominator of the percentage of the task that is complete
     * expressed as a fraction.
     *
     * @return int A number between 0 and 100, or FALSE if cannot be
     *   determined.
     * @since PECL gearman >= 0.5.0
     **/
    public function taskDenominator(){}

    /**
     * Get completion percentage numerator
     *
     * Returns the numerator of the percentage of the task that is complete
     * expressed as a fraction.
     *
     * @return int A number between 0 and 100, or FALSE if cannot be
     *   determined.
     * @since PECL gearman >= 0.5.0
     **/
    public function taskNumerator(){}

    /**
     * Get the unique identifier for a task
     *
     * Returns the unique identifier for this task. This is assigned by the
     * GearmanClient, as opposed to the job handle which is set by the
     * Gearman job server.
     *
     * @return string The unique identifier, or FALSE if no identifier is
     *   assigned.
     * @since PECL gearman >= 0.6.0
     **/
    public function unique(){}

    /**
     * Get the unique identifier for a task (deprecated)
     *
     * Returns the unique identifier for this task. This is assigned by the
     * GearmanClient, as opposed to the job handle which is set by the
     * Gearman job server.
     *
     * @return string The unique identifier, or FALSE if no identifier is
     *   assigned.
     * @since PECL gearman
     **/
    public function uuid(){}

    /**
     * Create a GearmanTask instance
     *
     * Creates a GearmanTask instance representing a task to be submitted to
     * a job server.
     *
     * @since PECL gearman >= 0.5.0
     **/
    public function __construct(){}

}
class GearmanWorker {
    /**
     * Register and add callback function
     *
     * Registers a function name with the job server and specifies a callback
     * corresponding to that function. Optionally specify extra application
     * context data to be used when the callback is called and a timeout.
     *
     * @param string $function_name The name of a function to register with
     *   the job server
     * @param callable $function A callback that gets called when a job for
     *   the registered function name is submitted
     * @param mixed $context A reference to arbitrary application context
     *   data that can be modified by the worker function
     * @param int $timeout An interval of time in seconds
     * @return bool
     * @since PECL gearman >= 0.5.0
     **/
    public function addFunction($function_name, $function, &$context, $timeout){}

    /**
     * Add worker options
     *
     * Adds one or more options to the options previously set.
     *
     * @param int $option The options to be added
     * @return bool Always returns TRUE.
     * @since PECL gearman >= 0.6.0
     **/
    public function addOptions($option){}

    /**
     * Add a job server
     *
     * Adds a job server to this worker. This goes into a list of servers
     * than can be used to run jobs. No socket I/O happens here.
     *
     * @param string $host
     * @param int $port
     * @return bool
     * @since PECL gearman >= 0.5.0
     **/
    public function addServer($host, $port){}

    /**
     * Add job servers
     *
     * Adds one or more job servers to this worker. These go into a list of
     * servers that can be used to run jobs. No socket I/O happens here.
     *
     * @param string $servers A comma separated list of job servers in the
     *   format host:port. If no port is specified, it defaults to 4730.
     * @return bool
     * @since PECL gearman >= 0.5.0
     **/
    public function addServers($servers){}

    /**
     * Get the last error encountered
     *
     * Returns an error string for the last error encountered.
     *
     * @return string An error string.
     * @since PECL gearman >= 0.5.0
     **/
    public function error(){}

    /**
     * Get errno
     *
     * Returns the value of errno in the case of a GEARMAN_ERRNO return
     * value.
     *
     * @return int A valid errno.
     * @since PECL gearman >= 0.5.0
     **/
    public function getErrno(){}

    /**
     * Get worker options
     *
     * Gets the options previously set for the worker.
     *
     * @return int The options currently set for the worker.
     * @since PECL gearman >= 0.6.0
     **/
    public function options(){}

    /**
     * Register a function with the job server
     *
     * Registers a function name with the job server with an optional
     * timeout. The timeout specifies how many seconds the server will wait
     * before marking a job as failed. If the timeout is set to zero, there
     * is no timeout.
     *
     * @param string $function_name The name of a function to register with
     *   the job server
     * @param int $timeout An interval of time in seconds
     * @return bool A standard Gearman return value.
     * @since PECL gearman >= 0.6.0
     **/
    public function register($function_name, $timeout){}

    /**
     * Remove worker options
     *
     * Removes (unsets) one or more worker options.
     *
     * @param int $option The options to be removed (unset)
     * @return bool Always returns TRUE.
     * @since PECL gearman >= 0.6.0
     **/
    public function removeOptions($option){}

    /**
     * Get last Gearman return code
     *
     * Returns the last Gearman return code.
     *
     * @return int A valid Gearman return code.
     * @since PECL gearman >= 0.5.0
     **/
    public function returnCode(){}

    /**
     * Give the worker an identifier so it can be tracked when asking
     * gearmand for the list of available workers
     *
     * Assigns the worker an identifier.
     *
     * @param string $id A string identifier.
     * @return bool
     **/
    public function setId($id){}

    /**
     * Set worker options
     *
     * Sets one or more options to the supplied value.
     *
     * @param int $option The options to be set
     * @return bool Always returns TRUE.
     * @since PECL gearman >= 0.5.0
     **/
    public function setOptions($option){}

    /**
     * Set socket I/O activity timeout
     *
     * Sets the interval of time to wait for socket I/O activity.
     *
     * @param int $timeout An interval of time in milliseconds. A negative
     *   value indicates an infinite timeout.
     * @return bool Always returns TRUE.
     * @since PECL gearman >= 0.6.0
     **/
    public function setTimeout($timeout){}

    /**
     * Get socket I/O activity timeout
     *
     * Returns the current time to wait, in milliseconds, for socket I/O
     * activity.
     *
     * @return int A time period is milliseconds. A negative value
     *   indicates an infinite timeout.
     * @since PECL gearman >= 0.6.0
     **/
    public function timeout(){}

    /**
     * Unregister a function name with the job servers
     *
     * Unregisters a function name with the job servers ensuring that no more
     * jobs (for that function) are sent to this worker.
     *
     * @param string $function_name The name of a function to register with
     *   the job server
     * @return bool A standard Gearman return value.
     * @since PECL gearman >= 0.6.0
     **/
    public function unregister($function_name){}

    /**
     * Unregister all function names with the job servers
     *
     * Unregisters all previously registered functions, ensuring that no more
     * jobs are sent to this worker.
     *
     * @return bool A standard Gearman return value.
     * @since PECL gearman >= 0.6.0
     **/
    public function unregisterAll(){}

    /**
     * Wait for activity from one of the job servers
     *
     * Causes the worker to wait for activity from one of the Gearman job
     * servers when operating in non-blocking I/O mode. On failure, issues a
     * E_WARNING with the last Gearman error encountered.
     *
     * @return bool
     * @since PECL gearman >= 0.6.0
     **/
    public function wait(){}

    /**
     * Wait for and perform jobs
     *
     * Waits for a job to be assigned and then calls the appropriate callback
     * function. Issues an E_WARNING with the last Gearman error if the
     * return code is not one of GEARMAN_SUCCESS, GEARMAN_IO_WAIT, or
     * GEARMAN_WORK_FAIL.
     *
     * @return bool
     * @since PECL gearman >= 0.5.0
     **/
    public function work(){}

    /**
     * Create a GearmanWorker instance
     *
     * Creates a GearmanWorker instance representing a worker that connects
     * to the job server and accepts tasks to run.
     *
     * @since PECL gearman >= 0.5.0
     **/
    public function __construct(){}

}
namespace Gender {
class Gender {
    /**
     * Connect to an external name dictionary
     *
     * Connect to an external name dictionary. Currently only streams are
     * supported.
     *
     * @param string $dsn DSN to open.
     * @return bool Boolean as success of failure.
     **/
    public function connect($dsn){}

    /**
     * Get textual country representation
     *
     * Returns the textual representation of a country from a Gender class
     * constant.
     *
     * @param int $country A country ID specified by a Gender\Gender class
     *   constant.
     * @return array Returns an array with the short and full names of the
     *   country on success .
     **/
    public function country($country){}

    /**
     * Get gender of a name
     *
     * Get the gender of the name in a particular country.
     *
     * @param string $name Name to check.
     * @param int $country Country id identified by Gender class constant.
     * @return int Returns gender of the name.
     **/
    public function get($name, $country){}

    /**
     * Check if the name0 is an alias of the name1
     *
     * Check whether the name0 is a nick of the name1.
     *
     * @param string $name0 Name to check.
     * @param string $name1 Name to check.
     * @param int $country Country id identified by Gender class constant.
     *   If ommited ANY_COUNTRY is used.
     * @return array
     **/
    public function isNick($name0, $name1, $country){}

    /**
     * Get similar names
     *
     * Get similar names for the given name and country.
     *
     * @param string $name Name to check.
     * @param int $country Country id identified by Gender class constant.
     *   If ommited ANY_COUNTRY is used.
     * @return array Returns an array with the similar names found.
     **/
    public function similarNames($name, $country){}

    /**
     * Construct the Gender object
     *
     * Create a Gender object optionally connecting to an external name
     * dictionary. When no external database was given, compiled in data will
     * be used.
     *
     * @param string $dsn DSN to open.
     **/
    public function __construct($dsn){}

}
}
/**
 * Generator objects are returned from generators.
 **/
class Generator implements Iterator {
    /**
     * Get the yielded value
     *
     * @return mixed Returns the yielded value.
     * @since PHP 5 >= 5.5.0, PHP 7
     **/
    public function current(){}

    /**
     * Get the return value of a generator
     *
     * @return mixed Returns the generator's return value once it has
     *   finished executing.
     * @since PHP 7
     **/
    public function getReturn(){}

    /**
     * Get the yielded key
     *
     * Gets the key of the yielded value.
     *
     * @return mixed Returns the yielded key.
     * @since PHP 5 >= 5.5.0, PHP 7
     **/
    public function key(){}

    /**
     * Resume execution of the generator
     *
     * Calling Generator::next is equivalent to calling Generator::send with
     * NULL as argument.
     *
     * @return void
     * @since PHP 5 >= 5.5.0, PHP 7
     **/
    public function next(){}

    /**
     * Rewind the iterator
     *
     * If iteration has already begun, this will throw an exception.
     *
     * @return void
     * @since PHP 5 >= 5.5.0, PHP 7
     **/
    public function rewind(){}

    /**
     * Send a value to the generator
     *
     * Sends the given value to the generator as the result of the current
     * expression and resumes execution of the generator.
     *
     * If the generator is not at a expression when this method is called, it
     * will first be let to advance to the first expression before sending
     * the value. As such it is not necessary to "prime" PHP generators with
     * a Generator::next call (like it is done in Python).
     *
     * @param mixed $value Value to send into the generator. This value
     *   will be the return value of the expression the generator is
     *   currently at.
     * @return mixed Returns the yielded value.
     * @since PHP 5 >= 5.5.0, PHP 7
     **/
    public function send($value){}

    /**
     * Throw an exception into the generator
     *
     * Throws an exception into the generator and resumes execution of the
     * generator. The behavior will be the same as if the current expression
     * was replaced with a throw $exception statement.
     *
     * If the generator is already closed when this method is invoked, the
     * exception will be thrown in the caller's context instead.
     *
     * @param Throwable $exception Exception to throw into the generator.
     * @return mixed Returns the yielded value.
     * @since PHP 5 >= 5.5.0, PHP 7
     **/
    public function throw($exception){}

    /**
     * Check if the iterator has been closed
     *
     * @return bool Returns FALSE if the iterator has been closed.
     *   Otherwise returns TRUE.
     * @since PHP 5 >= 5.5.0, PHP 7
     **/
    public function valid(){}

    /**
     * Serialize callback
     *
     * Throws an exception as generators can't be serialized.
     *
     * @return void
     * @since PHP 5 >= 5.5.0, PHP 7
     **/
    public function __wakeup(){}

}
/**
 * Absolute value
 *
 * Returns the absolute value of {@link number}.
 *
 * @param mixed $number The numeric value to process
 * @return number The absolute value of {@link number}. If the argument
 *   {@link number} is of type float, the return type is also float,
 *   otherwise it is integer (as float usually has a bigger value range
 *   than integer).
 * @since PHP 4, PHP 5, PHP 7
 **/
function abs($number){}

/**
 * Arc cosine
 *
 * Returns the arc cosine of {@link arg} in radians. {@link acos} is the
 * inverse function of {@link cos}, which means that a==cos(acos(a)) for
 * every value of a that is within {@link acos}' range.
 *
 * @param float $arg The argument to process
 * @return float The arc cosine of {@link arg} in radians.
 * @since PHP 4, PHP 5, PHP 7
 **/
function acos($arg){}

/**
 * Inverse hyperbolic cosine
 *
 * Returns the inverse hyperbolic cosine of {@link arg}, i.e. the value
 * whose hyperbolic cosine is {@link arg}.
 *
 * @param float $arg The value to process
 * @return float The inverse hyperbolic cosine of {@link arg}
 * @since PHP 4 >= 4.1.0, PHP 5, PHP 7
 **/
function acosh($arg){}

/**
 * Quote string with slashes in a C style
 *
 * Returns a string with backslashes before characters that are listed in
 * {@link charlist} parameter.
 *
 * @param string $str The string to be escaped.
 * @param string $charlist A list of characters to be escaped. If
 *   {@link charlist} contains characters \n, \r etc., they are converted
 *   in C-like style, while other non-alphanumeric characters with ASCII
 *   codes lower than 32 and higher than 126 converted to octal
 *   representation. When you define a sequence of characters in the
 *   charlist argument make sure that you know what characters come
 *   between the characters that you set as the start and end of the
 *   range.
 *   
 *   <?php echo addcslashes('foo[ ]', 'A..z'); // output: \f\o\o\[ \] //
 *   All upper and lower-case letters will be escaped // ... but so will
 *   the [\]^_` ?>
 *   
 *   Also, if the first character in a range has a higher ASCII value
 *   than the second character in the range, no range will be
 *   constructed. Only the start, end and period characters will be
 *   escaped. Use the {@link ord} function to find the ASCII value for a
 *   character.
 *   
 *   <?php echo addcslashes("zoo['.']", 'z..A'); // output: \zoo['\.'] ?>
 *   
 *   Be careful if you choose to escape characters 0, a, b, f, n, r, t
 *   and v. They will be converted to \0, \a, \b, \f, \n, \r, \t and \v,
 *   all of which are predefined escape sequences in C. Many of these
 *   sequences are also defined in other C-derived languages, including
 *   PHP, meaning that you may not get the desired result if you use the
 *   output of {@link addcslashes} to generate code in those languages
 *   with these characters defined in {@link charlist}.
 * @return string Returns the escaped string.
 * @since PHP 4, PHP 5, PHP 7
 **/
function addcslashes($str, $charlist){}

/**
 * Adds a solid fill to the shape
 *
 * {@link SWFShape::addFill} adds a solid fill to the shape's list of
 * fill styles. {@link SWFShape::addFill} accepts three different types
 * of arguments.
 *
 * {@link red}, {@link green}, {@link blue} is a color (RGB mode).
 *
 * The {@link bitmap} argument is an {@link SWFBitmap} object. The {@link
 * flags} argument can be one of the following values:
 * SWFFILL_CLIPPED_BITMAP, SWFFILL_TILED_BITMAP, SWFFILL_LINEAR_GRADIENT
 * or SWFFILL_RADIAL_GRADIENT. Default is SWFFILL_TILED_BITMAP for
 * SWFBitmap and SWFFILL_LINEAR_GRADIENT for SWFGradient.
 *
 * The {@link gradient} argument is an {@link SWFGradient} object. The
 * flags argument can be one of the following values :
 * SWFFILL_RADIAL_GRADIENT or SWFFILL_LINEAR_GRADIENT. Default is
 * SWFFILL_LINEAR_GRADIENT. I'm sure about this one. Really.
 *
 * {@link SWFShape::addFill} returns an {@link SWFFill} object for use
 * with the {@link SWFShape::setLeftFill} and {@link
 * SWFShape::setRightFill} functions described below.
 *
 * @param SWFBitmap $bitmap
 * @param int $flags
 * @return SWFFill
 **/
function addFill($bitmap, $flags){}

/**
 * Quote string with slashes
 *
 * Returns a string with backslashes added before characters that need to
 * be escaped. These characters are: single quote (') double quote (")
 * backslash (\) NUL (the NUL byte)
 *
 * A use case of {@link addslashes} is escaping the aforementioned
 * characters in a string that is to be evaluated by PHP:
 *
 * <?php $str = "O'Reilly?"; eval("echo '" . addslashes($str) . "';"); ?>
 *
 * Prior to PHP 5.4.0, the PHP directive magic_quotes_gpc was on by
 * default and it essentially ran {@link addslashes} on all GET, POST and
 * COOKIE data. {@link addslashes} must not be used on strings that have
 * already been escaped with magic_quotes_gpc, as the strings will be
 * double escaped. {@link get_magic_quotes_gpc} can be used to check if
 * magic_quotes_gpc is on.
 *
 * The {@link addslashes} is sometimes incorrectly used to try to prevent
 * SQL Injection. Instead, database-specific escaping functions and/or
 * prepared statements should be used.
 *
 * @param string $str The string to be escaped.
 * @return string Returns the escaped string.
 * @since PHP 4, PHP 5, PHP 7
 **/
function addslashes($str){}

/**
 * Terminate apache process after this request
 *
 * {@link apache_child_terminate} will register the Apache process
 * executing the current PHP request for termination once execution of
 * PHP code is completed. It may be used to terminate a process after a
 * script with high memory consumption has been run as memory will
 * usually only be freed internally but not given back to the operating
 * system.
 *
 * @return bool Returns TRUE if PHP is running as an Apache 1 module,
 *   the Apache version is non-multithreaded, and the child_terminate PHP
 *   directive is enabled (disabled by default). If these conditions are
 *   not met, FALSE is returned and an error of level E_WARNING is
 *   generated.
 * @since PHP 4 >= 4.0.5, PHP 5, PHP 7
 **/
function apache_child_terminate(){}

/**
 * Get an Apache subprocess_env variable
 *
 * Retrieve an Apache environment variable specified by {@link variable}.
 *
 * This function requires Apache 2 otherwise it's undefined.
 *
 * @param string $variable The Apache environment variable
 * @param bool $walk_to_top Whether to get the top-level variable
 *   available to all Apache layers.
 * @return string The value of the Apache environment variable on
 *   success, or FALSE on failure
 * @since PHP 4 >= 4.3.0, PHP 5, PHP 7
 **/
function apache_getenv($variable, $walk_to_top){}

/**
 * Get a list of loaded Apache modules
 *
 * @return array An array of loaded Apache modules.
 * @since PHP 4 >= 4.3.2, PHP 5, PHP 7
 **/
function apache_get_modules(){}

/**
 * Fetch Apache version
 *
 * Fetch the Apache version.
 *
 * @return string Returns the Apache version on success.
 * @since PHP 4 >= 4.3.2, PHP 5, PHP 7
 **/
function apache_get_version(){}

/**
 * Perform a partial request for the specified URI and return all info
 * about it
 *
 * This performs a partial request for a URI. It goes just far enough to
 * obtain all the important information about the given resource.
 *
 * @param string $filename The filename (URI) that's being requested.
 * @return object An object of related URI information. The properties
 *   of this object are:
 * @since PHP 4, PHP 5, PHP 7
 **/
function apache_lookup_uri($filename){}

/**
 * Get and set apache request notes
 *
 * This function is a wrapper for Apache's table_get and table_set. It
 * edits the table of notes that exists during a request. The table's
 * purpose is to allow Apache modules to communicate.
 *
 * The main use for {@link apache_note} is to pass information from one
 * module to another within the same request.
 *
 * @param string $note_name The name of the note.
 * @param string $note_value The value of the note.
 * @return string If called with one argument, it returns the current
 *   value of note note_name. If called with two arguments, it sets the
 *   value of note note_name to note_value and returns the previous value
 *   of note note_name. If the note cannot be retrieved, FALSE is
 *   returned.
 * @since PHP 4, PHP 5, PHP 7
 **/
function apache_note($note_name, $note_value){}

/**
 * Fetch all HTTP request headers
 *
 * Fetches all HTTP request headers from the current request.
 *
 * @return array An associative array of all the HTTP headers in the
 *   current request, or FALSE on failure.
 * @since PHP 4 >= 4.3.0, PHP 5, PHP 7
 **/
function apache_request_headers(){}

/**
 * Reset the Apache write timer
 *
 * {@link apache_reset_timeout} resets the Apache write timer, which
 * defaults to 300 seconds. With set_time_limit(0);
 * ignore_user_abort(true) and periodic {@link apache_reset_timeout}
 * calls, Apache can theoretically run forever.
 *
 * This function requires Apache 1.
 *
 * @return bool
 * @since PHP 5 >= 5.1.0, PHP 7
 **/
function apache_reset_timeout(){}

/**
 * Fetch all HTTP response headers
 *
 * @return array An array of all Apache response headers on success.
 * @since PHP 4 >= 4.3.0, PHP 5, PHP 7
 **/
function apache_response_headers(){}

/**
 * Set an Apache subprocess_env variable
 *
 * {@link apache_setenv} sets the value of the Apache environment
 * variable specified by {@link variable}.
 *
 * @param string $variable The environment variable that's being set.
 * @param string $value The new {@link variable} value.
 * @param bool $walk_to_top Whether to set the top-level variable
 *   available to all Apache layers.
 * @return bool
 * @since PHP 4 >= 4.2.0, PHP 5, PHP 7
 **/
function apache_setenv($variable, $value, $walk_to_top){}

/**
 * Cache a new variable in the data store
 *
 * Caches a variable in the data store, only if it's not already stored.
 *
 * @param string $key Store the variable using this name. {@link key}s
 *   are cache-unique, so attempting to use {@link apcu_add} to store
 *   data with a key that already exists will not overwrite the existing
 *   data, and will instead return FALSE. (This is the only difference
 *   between {@link apcu_add} and {@link apcu_store}.)
 * @param mixed $var The variable to store
 * @param int $ttl Time To Live; store {@link var} in the cache for
 *   {@link ttl} seconds. After the {@link ttl} has passed, the stored
 *   variable will be expunged from the cache (on the next request). If
 *   no {@link ttl} is supplied (or if the {@link ttl} is 0), the value
 *   will persist until it is removed from the cache manually, or
 *   otherwise fails to exist in the cache (clear, restart, etc.).
 * @return bool Returns TRUE if something has effectively been added
 *   into the cache, FALSE otherwise. Second syntax returns array with
 *   error keys.
 * @since PECL apcu >= 4.0.0
 **/
function apcu_add($key, $var, $ttl){}

/**
 * Retrieves cached information from APCu's data store
 *
 * Retrieves cached information and meta-data from APC's data store.
 *
 * @param bool $limited If {@link limited} is TRUE, the return value
 *   will exclude the individual list of cache entries. This is useful
 *   when trying to optimize calls for statistics gathering.
 * @return array Array of cached data (and meta-data)
 * @since PECL apcu >= 4.0.0
 **/
function apcu_cache_info($limited){}

/**
 * Updates an old value with a new value
 *
 * {@link apcu_cas} updates an already existing integer value if the
 * {@link old} parameter matches the currently stored value with the
 * value of the {@link new} parameter.
 *
 * @param string $key The key of the value being updated.
 * @param int $old The old value (the value currently stored).
 * @param int $new The new value to update to.
 * @return bool
 * @since PECL apcu >= 4.0.0
 **/
function apcu_cas($key, $old, $new){}

/**
 * Clears the APCu cache
 *
 * Clears the cache.
 *
 * @return bool Returns TRUE always
 * @since PECL apcu >= 4.0.0
 **/
function apcu_clear_cache(){}

/**
 * Decrease a stored number
 *
 * Decreases a stored integer value.
 *
 * @param string $key The key of the value being decreased.
 * @param int $step The step, or value to decrease.
 * @param bool $success Optionally pass the success or fail boolean
 *   value to this referenced variable.
 * @param int $ttl TTL to use if the operation inserts a new value
 *   (rather than decrementing an existing one).
 * @return int Returns the current value of {@link key}'s value on
 *   success,
 * @since PECL apcu >= 4.0.0
 **/
function apcu_dec($key, $step, &$success, $ttl){}

/**
 * Removes a stored variable from the cache
 *
 * Removes a stored variable from the cache.
 *
 * @param mixed $key A {@link key} used to store the value as a string
 *   for a single key, or as an array of strings for several keys, or as
 *   an APCUIterator object.
 * @return mixed If {@link key} is an , an indexed of the keys is
 *   returned. Otherwise TRUE is returned on success, or FALSE on
 *   failure.
 * @since PECL apcu >= 4.0.0
 **/
function apcu_delete($key){}

/**
 * Atomically fetch or generate a cache entry
 *
 * Atomically attempts to find {@link key} in the cache, if it cannot be
 * found {@link generator} is called, passing {@link key} as the only
 * argument. The return value of the call is then cached with the
 * optionally specified {@link ttl}, and returned.
 *
 * @param string $key Identity of cache entry
 * @param callable $generator A callable that accepts {@link key} as
 *   the only argument and returns the value to cache.
 * @param int $ttl Time To Live; store {@link var} in the cache for
 *   {@link ttl} seconds. After the {@link ttl} has passed, the stored
 *   variable will be expunged from the cache (on the next request). If
 *   no {@link ttl} is supplied (or if the {@link ttl} is 0), the value
 *   will persist until it is removed from the cache manually, or
 *   otherwise fails to exist in the cache (clear, restart, etc.).
 * @return mixed Returns the cached value
 * @since PECL apcu >= 5.1.0
 **/
function apcu_entry($key, $generator, $ttl){}

/**
 * Checks if entry exists
 *
 * Checks if one or more APCu entries exist.
 *
 * @param mixed $keys A string, or an array of strings, that contain
 *   keys.
 * @return mixed Returns TRUE if the key exists, otherwise FALSE Or if
 *   an array was passed to {@link keys}, then an array is returned that
 *   contains all existing keys, or an empty array if none exist.
 * @since PECL apcu >= 4.0.0
 **/
function apcu_exists($keys){}

/**
 * Fetch a stored variable from the cache
 *
 * Fetchs an entry from the cache.
 *
 * @param mixed $key The {@link key} used to store the value (with
 *   {@link apcu_store}). If an array is passed then each element is
 *   fetched and returned.
 * @param bool $success Set to TRUE in success and FALSE in failure.
 * @return mixed The stored variable or array of variables on success;
 *   FALSE on failure
 * @since PECL apcu >= 4.0.0
 **/
function apcu_fetch($key, &$success){}

/**
 * Increase a stored number
 *
 * Increases a stored number.
 *
 * @param string $key The key of the value being increased.
 * @param int $step The step, or value to increase.
 * @param bool $success Optionally pass the success or fail boolean
 *   value to this referenced variable.
 * @param int $ttl TTL to use if the operation inserts a new value
 *   (rather than incrementing an existing one).
 * @return int Returns the current value of {@link key}'s value on
 *   success,
 * @since PECL apcu >= 4.0.0
 **/
function apcu_inc($key, $step, &$success, $ttl){}

/**
 * Retrieves APCu Shared Memory Allocation information
 *
 * Retrieves APCu Shared Memory Allocation information.
 *
 * @param bool $limited When set to FALSE (default) {@link
 *   apcu_sma_info} will return a detailed information about each
 *   segment.
 * @return array Array of Shared Memory Allocation data; FALSE on
 *   failure.
 * @since PECL apcu >= 4.0.0
 **/
function apcu_sma_info($limited){}

/**
 * Cache a variable in the data store
 *
 * Cache a variable in the data store.
 *
 * @param string $key Store the variable using this name. {@link key}s
 *   are cache-unique, so storing a second value with the same {@link
 *   key} will overwrite the original value.
 * @param mixed $var The variable to store
 * @param int $ttl Time To Live; store {@link var} in the cache for
 *   {@link ttl} seconds. After the {@link ttl} has passed, the stored
 *   variable will be expunged from the cache (on the next request). If
 *   no {@link ttl} is supplied (or if the {@link ttl} is 0), the value
 *   will persist until it is removed from the cache manually, or
 *   otherwise fails to exist in the cache (clear, restart, etc.).
 * @return bool Second syntax returns array with error keys.
 * @since PECL apcu >= 4.0.0
 **/
function apcu_store($key, $var, $ttl){}

/**
 * Cache a new variable in the data store
 *
 * Caches a variable in the data store, only if it's not already stored.
 *
 * @param string $key Store the variable using this name. {@link key}s
 *   are cache-unique, so attempting to use {@link apc_add} to store data
 *   with a key that already exists will not overwrite the existing data,
 *   and will instead return FALSE. (This is the only difference between
 *   {@link apc_add} and {@link apc_store}.)
 * @param mixed $var The variable to store
 * @param int $ttl Time To Live; store {@link var} in the cache for
 *   {@link ttl} seconds. After the {@link ttl} has passed, the stored
 *   variable will be expunged from the cache (on the next request). If
 *   no {@link ttl} is supplied (or if the {@link ttl} is 0), the value
 *   will persist until it is removed from the cache manually, or
 *   otherwise fails to exist in the cache (clear, restart, etc.).
 * @return bool Returns TRUE if something has effectively been added
 *   into the cache, FALSE otherwise. Second syntax returns array with
 *   error keys.
 * @since PECL apc >= 3.0.13
 **/
function apc_add($key, $var, $ttl){}

/**
 * Get a binary dump of the given files and user variables
 *
 * Returns a binary dump of the given files and user variables from the
 * APC cache. A NULL for files or user_vars signals a dump of every
 * entry, whereas array() will dump nothing.
 *
 * @param array $files The files. Passing in NULL signals a dump of
 *   every entry, while passing in {@link array} will dump nothing.
 * @param array $user_vars The user vars. Passing in NULL signals a
 *   dump of every entry, while passing in {@link array} will dump
 *   nothing.
 * @return string Returns a binary dump of the given files and user
 *   variables from the APC cache, FALSE if APC is not enabled, or NULL
 *   if an unknown error is encountered.
 * @since PECL apc >= 3.1.4
 **/
function apc_bin_dump($files, $user_vars){}

/**
 * Output a binary dump of cached files and user variables to a file
 *
 * Outputs a binary dump of the given files and user variables from the
 * APC cache to the named file.
 *
 * @param array $files The file names being dumped.
 * @param array $user_vars The user variables being dumped.
 * @param string $filename The filename where the dump is being saved.
 * @param int $flags Flags passed to the {@link filename} stream. See
 *   the {@link file_put_contents} documentation for details.
 * @param resource $context The context passed to the {@link filename}
 *   stream. See the {@link file_put_contents} documentation for details.
 * @return int The number of bytes written to the file, otherwise FALSE
 *   if APC is not enabled, {@link filename} is an invalid file name,
 *   {@link filename} can't be opened, the file dump can't be completed
 *   (e.g., the hard drive is out of disk space), or an unknown error was
 *   encountered.
 * @since PECL apc >= 3.1.4
 **/
function apc_bin_dumpfile($files, $user_vars, $filename, $flags, $context){}

/**
 * Load a binary dump into the APC file/user cache
 *
 * Loads the given binary dump into the APC file/user cache.
 *
 * @param string $data The binary dump being loaded, likely from {@link
 *   apc_bin_dump}.
 * @param int $flags Either APC_BIN_VERIFY_CRC32, APC_BIN_VERIFY_MD5,
 *   or both.
 * @return bool Returns TRUE if the binary dump {@link data} was loaded
 *   with success, otherwise FALSE is returned. FALSE is returned if APC
 *   is not enabled, or if the {@link data} is not a valid APC binary
 *   dump (e.g., unexpected size).
 * @since PECL apc >= 3.1.4
 **/
function apc_bin_load($data, $flags){}

/**
 * Load a binary dump from a file into the APC file/user cache
 *
 * Loads a binary dump from a file into the APC file/user cache.
 *
 * @param string $filename The file name containing the dump, likely
 *   from {@link apc_bin_dumpfile}.
 * @param resource $context The files context.
 * @param int $flags Either APC_BIN_VERIFY_CRC32, APC_BIN_VERIFY_MD5,
 *   or both.
 * @return bool Returns TRUE on success, otherwise FALSE Reasons it may
 *   return FALSE include APC is not enabled, {@link filename} is an
 *   invalid file name or empty, {@link filename} can't be opened, the
 *   file dump can't be completed, or if the {@link data} is not a valid
 *   APC binary dump (e.g., unexpected size).
 * @since PECL apc >= 3.1.4
 **/
function apc_bin_loadfile($filename, $context, $flags){}

/**
 * Retrieves cached information from APC's data store
 *
 * Retrieves cached information and meta-data from APC's data store.
 *
 * @param string $cache_type If {@link cache_type} is "user",
 *   information about the user cache will be returned. If {@link
 *   cache_type} is "filehits", information about which files have been
 *   served from the bytecode cache for the current request will be
 *   returned. This feature must be enabled at compile time using
 *   --enable-filehits. If an invalid or no {@link cache_type} is
 *   specified, information about the system cache (cached files) will be
 *   returned.
 * @param bool $limited If {@link limited} is TRUE, the return value
 *   will exclude the individual list of cache entries. This is useful
 *   when trying to optimize calls for statistics gathering.
 * @return array Array of cached data (and meta-data)
 * @since PECL apc >= 2.0.0
 **/
function apc_cache_info($cache_type, $limited){}

/**
 * Updates an old value with a new value
 *
 * {@link apc_cas} updates an already existing integer value if the
 * {@link old} parameter matches the currently stored value with the
 * value of the {@link new} parameter.
 *
 * @param string $key The key of the value being updated.
 * @param int $old The old value (the value currently stored).
 * @param int $new The new value to update to.
 * @return bool
 * @since PECL apc >= 3.1.1
 **/
function apc_cas($key, $old, $new){}

/**
 * Clears the APC cache
 *
 * Clears the user/system cache.
 *
 * @param string $cache_type If {@link cache_type} is "user", the user
 *   cache will be cleared; otherwise, the system cache (cached files)
 *   will be cleared.
 * @return bool Returns TRUE always
 * @since PECL apc >= 2.0.0
 **/
function apc_clear_cache($cache_type){}

/**
 * Stores a file in the bytecode cache, bypassing all filters
 *
 * Stores a file in the bytecode cache, bypassing all filters.
 *
 * @param string $filename Full or relative path to a PHP file that
 *   will be compiled and stored in the bytecode cache.
 * @param bool $atomic
 * @return mixed
 * @since PECL apc >= 3.0.13
 **/
function apc_compile_file($filename, $atomic){}

/**
 * Decrease a stored number
 *
 * Decreases a stored integer value.
 *
 * @param string $key The key of the value being decreased.
 * @param int $step The step, or value to decrease.
 * @param bool $success Optionally pass the success or fail boolean
 *   value to this referenced variable.
 * @return int Returns the current value of {@link key}'s value on
 *   success,
 * @since PECL apc >= 3.1.1
 **/
function apc_dec($key, $step, &$success){}

/**
 * Defines a set of constants for retrieval and mass-definition
 *
 * {@link define} is notoriously slow. Since the main benefit of APC is
 * to increase the performance of scripts/applications, this mechanism is
 * provided to streamline the process of mass constant definition.
 * However, this function does not perform as well as anticipated.
 *
 * For a better-performing solution, try the hidef extension from PECL.
 *
 * @param string $key The {@link key} serves as the name of the
 *   constant set being stored. This {@link key} is used to retrieve the
 *   stored constants in {@link apc_load_constants}.
 * @param array $constants An associative array of constant_name =>
 *   value pairs. The constant_name must follow the normal constant
 *   naming rules. value must evaluate to a scalar value.
 * @param bool $case_sensitive The default behaviour for constants is
 *   to be declared case-sensitive; i.e. CONSTANT and Constant represent
 *   different values. If this parameter evaluates to FALSE the constants
 *   will be declared as case-insensitive symbols.
 * @return bool
 * @since PECL apc >= 3.0.0
 **/
function apc_define_constants($key, $constants, $case_sensitive){}

/**
 * Removes a stored variable from the cache
 *
 * Removes a stored variable from the cache.
 *
 * @param string $key The {@link key} used to store the value (with
 *   {@link apc_store}).
 * @return mixed
 * @since PECL apc >= 3.0.0
 **/
function apc_delete($key){}

/**
 * Deletes files from the opcode cache
 *
 * Deletes the given files from the opcode cache.
 *
 * @param mixed $keys The files to be deleted. Accepts a string, array
 *   of strings, or an APCIterator object.
 * @return mixed Or if {@link keys} is an array, then an empty array is
 *   returned on success, or an array of failed files is returned.
 * @since PECL apc >= 3.1.1
 **/
function apc_delete_file($keys){}

/**
 * Checks if APC key exists
 *
 * Checks if one or more APC keys exist.
 *
 * @param mixed $keys A string, or an array of strings, that contain
 *   keys.
 * @return mixed Returns TRUE if the key exists, otherwise FALSE Or if
 *   an array was passed to {@link keys}, then an array is returned that
 *   contains all existing keys, or an empty array if none exist.
 * @since PECL apc >= 3.1.4
 **/
function apc_exists($keys){}

/**
 * Fetch a stored variable from the cache
 *
 * Fetchs a stored variable from the cache.
 *
 * @param mixed $key The {@link key} used to store the value (with
 *   {@link apc_store}). If an array is passed then each element is
 *   fetched and returned.
 * @param bool $success Set to TRUE in success and FALSE in failure.
 * @return mixed The stored variable or array of variables on success;
 *   FALSE on failure
 * @since PECL apc >= 3.0.0
 **/
function apc_fetch($key, &$success){}

/**
 * Increase a stored number
 *
 * Increases a stored number.
 *
 * @param string $key The key of the value being increased.
 * @param int $step The step, or value to increase.
 * @param bool $success Optionally pass the success or fail boolean
 *   value to this referenced variable.
 * @return int Returns the current value of {@link key}'s value on
 *   success,
 * @since PECL apc >= 3.1.1
 **/
function apc_inc($key, $step, &$success){}

/**
 * Loads a set of constants from the cache
 *
 * Loads a set of constants from the cache.
 *
 * @param string $key The name of the constant set (that was stored
 *   with {@link apc_define_constants}) to be retrieved.
 * @param bool $case_sensitive The default behaviour for constants is
 *   to be declared case-sensitive; i.e. CONSTANT and Constant represent
 *   different values. If this parameter evaluates to FALSE the constants
 *   will be declared as case-insensitive symbols.
 * @return bool
 * @since PECL apc >= 3.0.0
 **/
function apc_load_constants($key, $case_sensitive){}

/**
 * Retrieves APC's Shared Memory Allocation information
 *
 * Retrieves APC's Shared Memory Allocation information.
 *
 * @param bool $limited When set to FALSE (default) {@link
 *   apc_sma_info} will return a detailed information about each segment.
 * @return array Array of Shared Memory Allocation data; FALSE on
 *   failure.
 * @since PECL apc >= 2.0.0
 **/
function apc_sma_info($limited){}

/**
 * Cache a variable in the data store
 *
 * Cache a variable in the data store.
 *
 * @param string $key Store the variable using this name. {@link key}s
 *   are cache-unique, so storing a second value with the same {@link
 *   key} will overwrite the original value.
 * @param mixed $var The variable to store
 * @param int $ttl Time To Live; store {@link var} in the cache for
 *   {@link ttl} seconds. After the {@link ttl} has passed, the stored
 *   variable will be expunged from the cache (on the next request). If
 *   no {@link ttl} is supplied (or if the {@link ttl} is 0), the value
 *   will persist until it is removed from the cache manually, or
 *   otherwise fails to exist in the cache (clear, restart, etc.).
 * @return bool Second syntax returns array with error keys.
 * @since PECL apc >= 3.0.0
 **/
function apc_store($key, $var, $ttl){}

/**
 * Stops the interpreter and waits on a CR from the socket
 *
 * This can be used to stop the running of your script, and await
 * responses on the connected socket. To step the program, just send
 * enter (a blank line), or enter a php command to be executed.
 *
 * @param int $debug_level
 * @return bool
 * @since PECL apd >= 0.2
 **/
function apd_breakpoint($debug_level){}

/**
 * Returns the current call stack as an array
 *
 * @return array An array containing the current call stack.
 * @since PECL apd 0.2-0.4
 **/
function apd_callstack(){}

/**
 * Throw a warning and a callstack
 *
 * Behaves like perl's Carp::cluck. Throw a warning and a callstack.
 *
 * @param string $warning The warning to throw.
 * @param string $delimiter The delimiter. Default to <BR />.
 * @return void
 * @since PECL apd 0.2-0.4
 **/
function apd_clunk($warning, $delimiter){}

/**
 * Restarts the interpreter
 *
 * Usually sent via the socket to restart the interpreter.
 *
 * @param int $debug_level
 * @return bool
 * @since PECL apd >= 0.2
 **/
function apd_continue($debug_level){}

/**
 * Throw an error, a callstack and then exit
 *
 * Behaves like perl's Carp::croak. Throw an error, a callstack and then
 * exit.
 *
 * @param string $warning The warning to throw.
 * @param string $delimiter The delimiter. Default to <BR />.
 * @return void
 * @since PECL apd 0.2-0.4
 **/
function apd_croak($warning, $delimiter){}

/**
 * Outputs the current function table
 *
 * @return void
 * @since Unknown
 **/
function apd_dump_function_table(){}

/**
 * Return all persistent resources as an array
 *
 * @return array An array containing the current persistent resources.
 * @since PECL apd 0.2-0.4
 **/
function apd_dump_persistent_resources(){}

/**
 * Return all current regular resources as an array
 *
 * @return array An array containing the current regular resources.
 * @since PECL apd 0.2-0.4
 **/
function apd_dump_regular_resources(){}

/**
 * Echo to the debugging socket
 *
 * Usually sent via the socket to request information about the running
 * script.
 *
 * @param string $output The debugged variable.
 * @return bool
 * @since PECL apd >= 0.2
 **/
function apd_echo($output){}

/**
 * Get an array of the current variables names in the local scope
 *
 * Returns the names of all the variables defined in the active scope,
 * (not their values).
 *
 * @return array A multidimensional array with all the variables.
 * @since PECL apd 0.2
 **/
function apd_get_active_symbols(){}

/**
 * Starts the session debugging
 *
 * Starts debugging to pprof_{process_id} in the dump directory.
 *
 * @param string $dump_directory The directory in which the profile
 *   dump file is written. If not set, the apd.dumpdir setting from the
 *   file is used.
 * @param string $fragment
 * @return string Returns path of the destination file.
 * @since PECL apd >= 0.2
 **/
function apd_set_pprof_trace($dump_directory, $fragment){}

/**
 * Changes or sets the current debugging level
 *
 * This can be used to increase or decrease debugging in a different area
 * of your application.
 *
 * @param int $debug_level
 * @return void
 * @since PECL apd 0.2-0.4
 **/
function apd_set_session($debug_level){}

/**
 * Starts the session debugging
 *
 * Starts debugging to apd_dump_{process_id} in the dump directory.
 *
 * @param int $debug_level The directory in which the profile dump file
 *   is written. If not set, the apd.dumpdir setting from the file is
 *   used.
 * @param string $dump_directory
 * @return void
 * @since PECL apd 0.2-0.4
 **/
function apd_set_session_trace($debug_level, $dump_directory){}

/**
 * Starts the remote session debugging
 *
 * Connects to the specified {@link tcp_server} (eg. tcplisten) and sends
 * debugging data to the socket.
 *
 * @param string $tcp_server IP or Unix Domain socket (like a file) of
 *   the TCP server.
 * @param int $socket_type Can be AF_UNIX for file based sockets or
 *   APD_AF_INET for standard tcp/ip.
 * @param int $port You can use any port, but higher numbers are better
 *   as most of the lower numbers may be used by other system services.
 * @param int $debug_level
 * @return bool
 * @since PECL apd >= 0.2
 **/
function apd_set_session_trace_socket($tcp_server, $socket_type, $port, $debug_level){}

/**
 * Changes the case of all keys in an array
 *
 * Returns an array with all keys from {@link array} lowercased or
 * uppercased. Numbered indices are left as is.
 *
 * @param array $array The array to work on
 * @param int $case Either CASE_UPPER or CASE_LOWER (default)
 * @return array Returns an array with its keys lower or uppercased, or
 *   FALSE if {@link array} is not an array.
 * @since PHP 4 >= 4.2.0, PHP 5, PHP 7
 **/
function array_change_key_case($array, $case){}

/**
 * Split an array into chunks
 *
 * Chunks an array into arrays with {@link size} elements. The last chunk
 * may contain less than {@link size} elements.
 *
 * @param array $array The array to work on
 * @param int $size The size of each chunk
 * @param bool $preserve_keys When set to TRUE keys will be preserved.
 *   Default is FALSE which will reindex the chunk numerically
 * @return array Returns a multidimensional numerically indexed array,
 *   starting with zero, with each dimension containing {@link size}
 *   elements.
 * @since PHP 4 >= 4.2.0, PHP 5, PHP 7
 **/
function array_chunk($array, $size, $preserve_keys){}

/**
 * Return the values from a single column in the input array
 *
 * {@link array_column} returns the values from a single column of the
 * {@link input}, identified by the {@link column_key}. Optionally, an
 * {@link index_key} may be provided to index the values in the returned
 * array by the values from the {@link index_key} column of the input
 * array.
 *
 * @param array $input A multi-dimensional array or an array of objects
 *   from which to pull a column of values from. If an array of objects
 *   is provided, then public properties can be directly pulled. In order
 *   for protected or private properties to be pulled, the class must
 *   implement both the {@link __get} and {@link __isset} magic methods.
 * @param mixed $column_key The column of values to return. This value
 *   may be an integer key of the column you wish to retrieve, or it may
 *   be a string key name for an associative array or property name. It
 *   may also be NULL to return complete arrays or objects (this is
 *   useful together with {@link index_key} to reindex the array).
 * @param mixed $index_key The column to use as the index/keys for the
 *   returned array. This value may be the integer key of the column, or
 *   it may be the string key name. The value is cast as usual for array
 *   keys (however, objects supporting conversion to string are also
 *   allowed).
 * @return array Returns an array of values representing a single
 *   column from the input array.
 * @since PHP 5 >= 5.5.0, PHP 7
 **/
function array_column($input, $column_key, $index_key){}

/**
 * Creates an array by using one array for keys and another for its
 * values
 *
 * Creates an array by using the values from the {@link keys} array as
 * keys and the values from the {@link values} array as the corresponding
 * values.
 *
 * @param array $keys Array of keys to be used. Illegal values for key
 *   will be converted to string.
 * @param array $values Array of values to be used
 * @return array Returns the combined array, FALSE if the number of
 *   elements for each array isn't equal.
 * @since PHP 5, PHP 7
 **/
function array_combine($keys, $values){}

/**
 * Counts all the values of an array
 *
 * {@link array_count_values} returns an array using the values of {@link
 * array} as keys and their frequency in {@link array} as values.
 *
 * @param array $array The array of values to count
 * @return array Returns an associative array of values from {@link
 *   array} as keys and their count as value.
 * @since PHP 4, PHP 5, PHP 7
 **/
function array_count_values($array){}

/**
 * Computes the difference of arrays
 *
 * Compares {@link array1} against one or more other arrays and returns
 * the values in {@link array1} that are not present in any of the other
 * arrays.
 *
 * @param array $array1 The array to compare from
 * @param array $array2 An array to compare against
 * @param array ...$vararg More arrays to compare against
 * @return array Returns an array containing all the entries from
 *   {@link array1} that are not present in any of the other arrays.
 * @since PHP 4 >= 4.0.1, PHP 5, PHP 7
 **/
function array_diff($array1, $array2, ...$vararg){}

/**
 * Computes the difference of arrays with additional index check
 *
 * Compares {@link array1} against {@link array2} and returns the
 * difference. Unlike {@link array_diff} the array keys are also used in
 * the comparison.
 *
 * @param array $array1 The array to compare from
 * @param array $array2 An array to compare against
 * @param array ...$vararg More arrays to compare against
 * @return array Returns an array containing all the values from {@link
 *   array1} that are not present in any of the other arrays.
 * @since PHP 4 >= 4.3.0, PHP 5, PHP 7
 **/
function array_diff_assoc($array1, $array2, ...$vararg){}

/**
 * Computes the difference of arrays using keys for comparison
 *
 * Compares the keys from {@link array1} against the keys from {@link
 * array2} and returns the difference. This function is like {@link
 * array_diff} except the comparison is done on the keys instead of the
 * values.
 *
 * @param array $array1 The array to compare from
 * @param array $array2 An array to compare against
 * @param array ...$vararg More arrays to compare against
 * @return array Returns an array containing all the entries from
 *   {@link array1} whose keys are absent from all of the other arrays.
 * @since PHP 5 >= 5.1.0, PHP 7
 **/
function array_diff_key($array1, $array2, ...$vararg){}

/**
 * Computes the difference of arrays with additional index check which is
 * performed by a user supplied callback function
 *
 * Compares {@link array1} against {@link array2} and returns the
 * difference. Unlike {@link array_diff} the array keys are used in the
 * comparison.
 *
 * Unlike {@link array_diff_assoc} a user supplied callback function is
 * used for the indices comparison, not internal function.
 *
 * @param array $array1 The array to compare from
 * @param array $array2 An array to compare against
 * @param array ...$vararg More arrays to compare against
 * @param callable $key_compare_func
 * @return array Returns an array containing all the entries from
 *   {@link array1} that are not present in any of the other arrays.
 * @since PHP 5, PHP 7
 **/
function array_diff_uassoc($array1, $array2, $key_compare_func){}

/**
 * Computes the difference of arrays using a callback function on the
 * keys for comparison
 *
 * Compares the keys from {@link array1} against the keys from {@link
 * array2} and returns the difference. This function is like {@link
 * array_diff} except the comparison is done on the keys instead of the
 * values.
 *
 * Unlike {@link array_diff_key} a user supplied callback function is
 * used for the indices comparison, not internal function.
 *
 * @param array $array1 The array to compare from
 * @param array $array2 An array to compare against
 * @param array ...$vararg More arrays to compare against
 * @param callable $key_compare_func
 * @return array Returns an array containing all the entries from
 *   {@link array1} that are not present in any of the other arrays.
 * @since PHP 5 >= 5.1.0, PHP 7
 **/
function array_diff_ukey($array1, $array2, $key_compare_func){}

/**
 * Fill an array with values
 *
 * Fills an array with {@link num} entries of the value of the {@link
 * value} parameter, keys starting at the {@link start_index} parameter.
 *
 * @param int $start_index The first index of the returned array. If
 *   {@link start_index} is negative, the first index of the returned
 *   array will be {@link start_index} and the following indices will
 *   start from zero (see example).
 * @param int $num Number of elements to insert. Must be greater than
 *   or equal to zero.
 * @param mixed $value Value to use for filling
 * @return array Returns the filled array
 * @since PHP 4 >= 4.2.0, PHP 5, PHP 7
 **/
function array_fill($start_index, $num, $value){}

/**
 * Fill an array with values, specifying keys
 *
 * Fills an array with the value of the {@link value} parameter, using
 * the values of the {@link keys} array as keys.
 *
 * @param array $keys Array of values that will be used as keys.
 *   Illegal values for key will be converted to string.
 * @param mixed $value Value to use for filling
 * @return array Returns the filled array
 * @since PHP 5 >= 5.2.0, PHP 7
 **/
function array_fill_keys($keys, $value){}

/**
 * Filters elements of an array using a callback function
 *
 * Iterates over each value in the {@link array} passing them to the
 * {@link callback} function. If the {@link callback} function returns
 * TRUE, the current value from {@link array} is returned into the result
 * . Array keys are preserved.
 *
 * @param array $array The array to iterate over
 * @param callable $callback The callback function to use If no {@link
 *   callback} is supplied, all entries of {@link array} equal to FALSE
 *   (see converting to boolean) will be removed.
 * @param int $flag Flag determining what arguments are sent to {@link
 *   callback}: ARRAY_FILTER_USE_KEY - pass key as the only argument to
 *   {@link callback} instead of the value ARRAY_FILTER_USE_BOTH - pass
 *   both value and key as arguments to {@link callback} instead of the
 *   value Default is 0 which will pass value as the only argument to
 *   {@link callback} instead.
 * @return array Returns the filtered array.
 * @since PHP 4 >= 4.0.6, PHP 5, PHP 7
 **/
function array_filter($array, $callback, $flag){}

/**
 * Exchanges all keys with their associated values in an array
 *
 * {@link array_flip} returns an array in flip order, i.e. keys from
 * {@link array} become values and values from {@link array} become keys.
 *
 * Note that the values of {@link array} need to be valid keys, i.e. they
 * need to be either integer or string. A warning will be emitted if a
 * value has the wrong type, and the key/value pair in question will not
 * be included in the result.
 *
 * If a value has several occurrences, the latest key will be used as its
 * value, and all others will be lost.
 *
 * @param array $array An array of key/value pairs to be flipped.
 * @return array Returns the flipped array on success and NULL on
 *   failure.
 * @since PHP 4, PHP 5, PHP 7
 **/
function array_flip($array){}

/**
 * Computes the intersection of arrays
 *
 * {@link array_intersect} returns an array containing all the values of
 * {@link array1} that are present in all the arguments. Note that keys
 * are preserved.
 *
 * @param array $array1 The array with master values to check.
 * @param array $array2 An array to compare values against.
 * @param array ...$vararg A variable list of arrays to compare.
 * @return array Returns an array containing all of the values in
 *   {@link array1} whose values exist in all of the parameters.
 * @since PHP 4 >= 4.0.1, PHP 5, PHP 7
 **/
function array_intersect($array1, $array2, ...$vararg){}

/**
 * Computes the intersection of arrays with additional index check
 *
 * @param array $array1 The array with master values to check.
 * @param array $array2 An array to compare values against.
 * @param array ...$vararg A variable list of arrays to compare.
 * @return array Returns an associative array containing all the values
 *   in {@link array1} that are present in all of the arguments.
 * @since PHP 4 >= 4.3.0, PHP 5, PHP 7
 **/
function array_intersect_assoc($array1, $array2, ...$vararg){}

/**
 * Computes the intersection of arrays using keys for comparison
 *
 * {@link array_intersect_key} returns an array containing all the
 * entries of {@link array1} which have keys that are present in all the
 * arguments.
 *
 * @param array $array1 The array with master keys to check.
 * @param array $array2 An array to compare keys against.
 * @param array ...$vararg A variable list of arrays to compare.
 * @return array Returns an associative array containing all the
 *   entries of {@link array1} which have keys that are present in all
 *   arguments.
 * @since PHP 5 >= 5.1.0, PHP 7
 **/
function array_intersect_key($array1, $array2, ...$vararg){}

/**
 * Computes the intersection of arrays with additional index check,
 * compares indexes by a callback function
 *
 * {@link array_intersect_uassoc} returns an array containing all the
 * values of {@link array1} that are present in all the arguments. Note
 * that the keys are used in the comparison unlike in {@link
 * array_intersect}.
 *
 * @param array $array1 Initial array for comparison of the arrays.
 * @param array $array2 First array to compare keys against.
 * @param array ...$vararg Variable list of array arguments to compare
 *   values against.
 * @param callable $key_compare_func
 * @return array Returns the values of {@link array1} whose values
 *   exist in all of the arguments.
 * @since PHP 5, PHP 7
 **/
function array_intersect_uassoc($array1, $array2, $key_compare_func){}

/**
 * Computes the intersection of arrays using a callback function on the
 * keys for comparison
 *
 * {@link array_intersect_ukey} returns an array containing all the
 * values of {@link array1} which have matching keys that are present in
 * all the arguments.
 *
 * @param array $array1 Initial array for comparison of the arrays.
 * @param array $array2 First array to compare keys against.
 * @param array ...$vararg Variable list of array arguments to compare
 *   keys against.
 * @param callable $key_compare_func
 * @return array Returns the values of {@link array1} whose keys exist
 *   in all the arguments.
 * @since PHP 5 >= 5.1.0, PHP 7
 **/
function array_intersect_ukey($array1, $array2, $key_compare_func){}

/**
 * Return all the keys or a subset of the keys of an array
 *
 * {@link array_keys} returns the keys, numeric and string, from the
 * {@link array}.
 *
 * If a {@link search_value} is specified, then only the keys for that
 * value are returned. Otherwise, all the keys from the {@link array} are
 * returned.
 *
 * @param array $array An array containing keys to return.
 * @return array Returns an array of all the keys in {@link array}.
 * @since PHP 4, PHP 5, PHP 7
 **/
function array_keys($array){}

/**
 * Checks if the given key or index exists in the array
 *
 * {@link array_key_exists} returns TRUE if the given {@link key} is set
 * in the array. {@link key} can be any value possible for an array
 * index.
 *
 * @param mixed $key Value to check.
 * @param array $array An array with keys to check.
 * @return bool
 * @since PHP 4 >= 4.0.7, PHP 5, PHP 7
 **/
function array_key_exists($key, $array){}

/**
 * Gets the first key of an array
 *
 * Get the first key of the given {@link array} without affecting the
 * internal array pointer.
 *
 * @param array $array An array.
 * @return mixed Returns the first key of {@link array} if the array is
 *   not empty; NULL otherwise.
 * @since PHP 7 >= 7.3.0
 **/
function array_key_first($array){}

/**
 * Gets the last key of an array
 *
 * Get the last key of the given {@link array} without affecting the
 * internal array pointer.
 *
 * @param array $array An array.
 * @return mixed Returns the last key of {@link array} if the array is
 *   not empty; NULL otherwise.
 * @since PHP 7 >= 7.3.0
 **/
function array_key_last($array){}

/**
 * Applies the callback to the elements of the given arrays
 *
 * {@link array_map} returns an containing the results of applying the
 * {@link callback} function to the corresponding index of {@link array1}
 * (and {@link ...} if more arrays are provided) used as arguments for
 * the callback. The number of parameters that the {@link callback}
 * function accepts should match the number of arrays passed to {@link
 * array_map}.
 *
 * @param callable $callback Callback function to run for each element
 *   in each array. NULL can be passed as a value to {@link callback} to
 *   perform a zip operation on multiple arrays. If only {@link array1}
 *   is provided, array_map will return the input array.
 * @param array $array1 An array to run through the {@link callback}
 *   function.
 * @param array ...$vararg Supplementary variable list of array
 *   arguments to run through the {@link callback} function.
 * @return array Returns an array containing the results of applying
 *   the {@link callback} function to the corresponding index of {@link
 *   array1} (and {@link ...} if more arrays are provided) used as
 *   arguments for the callback.
 * @since PHP 4 >= 4.0.6, PHP 5, PHP 7
 **/
function array_map($callback, $array1, ...$vararg){}

/**
 * Merge one or more arrays
 *
 * Merges the elements of one or more arrays together so that the values
 * of one are appended to the end of the previous one. It returns the
 * resulting array.
 *
 * If the input arrays have the same string keys, then the later value
 * for that key will overwrite the previous one. If, however, the arrays
 * contain numeric keys, the later value will not overwrite the original
 * value, but will be appended.
 *
 * Values in the input arrays with numeric keys will be renumbered with
 * incrementing keys starting from zero in the result array.
 *
 * @param array ...$vararg Variable list of arrays to merge.
 * @return array Returns the resulting array. If called without any
 *   arguments, returns an empty .
 * @since PHP 4, PHP 5, PHP 7
 **/
function array_merge(...$vararg){}

/**
 * Merge one or more arrays recursively
 *
 * {@link array_merge_recursive} merges the elements of one or more
 * arrays together so that the values of one are appended to the end of
 * the previous one. It returns the resulting array.
 *
 * If the input arrays have the same string keys, then the values for
 * these keys are merged together into an array, and this is done
 * recursively, so that if one of the values is an array itself, the
 * function will merge it with a corresponding entry in another array
 * too. If, however, the arrays have the same numeric key, the later
 * value will not overwrite the original value, but will be appended.
 *
 * @param array ...$vararg Variable list of arrays to recursively
 *   merge.
 * @return array An array of values resulted from merging the arguments
 *   together. If called without any arguments, returns an empty .
 * @since PHP 4 >= 4.0.1, PHP 5, PHP 7
 **/
function array_merge_recursive(...$vararg){}

/**
 * Sort multiple or multi-dimensional arrays
 *
 * {@link array_multisort} can be used to sort several arrays at once, or
 * a multi-dimensional array by one or more dimensions.
 *
 * Associative (string) keys will be maintained, but numeric keys will be
 * re-indexed.
 *
 * @param array $array1 An array being sorted.
 * @param mixed $array1_sort_order The order used to sort the previous
 *   array argument. Either SORT_ASC to sort ascendingly or SORT_DESC to
 *   sort descendingly. This argument can be swapped with {@link
 *   array1_sort_flags} or omitted entirely, in which case SORT_ASC is
 *   assumed.
 * @param mixed $array1_sort_flags Sort options for the previous array
 *   argument: Sorting type flags: SORT_REGULAR - compare items normally
 *   (don't change types) SORT_NUMERIC - compare items numerically
 *   SORT_STRING - compare items as strings SORT_LOCALE_STRING - compare
 *   items as strings, based on the current locale. It uses the locale,
 *   which can be changed using {@link setlocale} SORT_NATURAL - compare
 *   items as strings using "natural ordering" like {@link natsort}
 *   SORT_FLAG_CASE - can be combined (bitwise OR) with SORT_STRING or
 *   SORT_NATURAL to sort strings case-insensitively This argument can be
 *   swapped with {@link array1_sort_order} or omitted entirely, in which
 *   case SORT_REGULAR is assumed.
 * @param mixed ...$vararg More arrays, optionally followed by sort
 *   order and flags. Only elements corresponding to equivalent elements
 *   in previous arrays are compared. In other words, the sort is
 *   lexicographical.
 * @return bool
 * @since PHP 4, PHP 5, PHP 7
 **/
function array_multisort(&$array1, $array1_sort_order, $array1_sort_flags, ...$vararg){}

/**
 * Pad array to the specified length with a value
 *
 * {@link array_pad} returns a copy of the {@link array} padded to size
 * specified by {@link size} with value {@link value}. If {@link size} is
 * positive then the array is padded on the right, if it's negative then
 * on the left. If the absolute value of {@link size} is less than or
 * equal to the length of the {@link array} then no padding takes place.
 * It is possible to add at most 1048576 elements at a time.
 *
 * @param array $array Initial array of values to pad.
 * @param int $size New size of the array.
 * @param mixed $value Value to pad if {@link array} is less than
 *   {@link size}.
 * @return array Returns a copy of the {@link array} padded to size
 *   specified by {@link size} with value {@link value}. If {@link size}
 *   is positive then the array is padded on the right, if it's negative
 *   then on the left. If the absolute value of {@link size} is less than
 *   or equal to the length of the {@link array} then no padding takes
 *   place.
 * @since PHP 4, PHP 5, PHP 7
 **/
function array_pad($array, $size, $value){}

/**
 * Pop the element off the end of array
 *
 * {@link array_pop} pops and returns the value of the last element of
 * {@link array}, shortening the {@link array} by one element.
 *
 * @param array $array The array to get the value from.
 * @return mixed Returns the value of the last element of {@link
 *   array}. If {@link array} is empty (or is not an array), NULL will be
 *   returned.
 * @since PHP 4, PHP 5, PHP 7
 **/
function array_pop(&$array){}

/**
 * Calculate the product of values in an array
 *
 * {@link array_product} returns the product of values in an array.
 *
 * @param array $array The array.
 * @return number Returns the product as an integer or float.
 * @since PHP 5 >= 5.1.0, PHP 7
 **/
function array_product($array){}

/**
 * Push one or more elements onto the end of array
 *
 * {@link array_push} treats {@link array} as a stack, and pushes the
 * passed variables onto the end of {@link array}. The length of {@link
 * array} increases by the number of variables pushed. Has the same
 * effect as:
 *
 * <?php $array[] = $var; ?>
 *
 * repeated for each passed value.
 *
 * @param array $array The input array.
 * @param mixed ...$vararg The values to push onto the end of the
 *   {@link array}.
 * @return int Returns the new number of elements in the array.
 * @since PHP 4, PHP 5, PHP 7
 **/
function array_push(&$array, ...$vararg){}

/**
 * Pick one or more random keys out of an array
 *
 * Picks one or more random entries out of an array, and returns the key
 * (or keys) of the random entries. It uses a pseudo random number
 * generator that is not suitable for cryptographic purposes.
 *
 * @param array $array The input array.
 * @param int $num Specifies how many entries should be picked.
 * @return mixed When picking only one entry, {@link array_rand}
 *   returns the key for a random entry. Otherwise, an array of keys for
 *   the random entries is returned. This is done so that random keys can
 *   be picked from the array as well as random values. Trying to pick
 *   more elements than there are in the array will result in an
 *   E_WARNING level error, and NULL will be returned.
 * @since PHP 4, PHP 5, PHP 7
 **/
function array_rand($array, $num){}

/**
 * Iteratively reduce the array to a single value using a callback
 * function
 *
 * {@link array_reduce} applies iteratively the {@link callback} function
 * to the elements of the {@link array}, so as to reduce the array to a
 * single value.
 *
 * @param array $array The input array.
 * @param callable $callback
 * @param mixed $initial Holds the return value of the previous
 *   iteration; in the case of the first iteration it instead holds the
 *   value of {@link initial}.
 * @return mixed Returns the resulting value.
 * @since PHP 4 >= 4.0.5, PHP 5, PHP 7
 **/
function array_reduce($array, $callback, $initial){}

/**
 * Replaces elements from passed arrays into the first array
 *
 * {@link array_replace} replaces the values of {@link array1} with
 * values having the same keys in each of the following arrays. If a key
 * from the first array exists in the second array, its value will be
 * replaced by the value from the second array. If the key exists in the
 * second array, and not the first, it will be created in the first
 * array. If a key only exists in the first array, it will be left as is.
 * If several arrays are passed for replacement, they will be processed
 * in order, the later arrays overwriting the previous values.
 *
 * {@link array_replace} is not recursive : it will replace values in the
 * first array by whatever type is in the second array.
 *
 * @param array $array1 The array in which elements are replaced.
 * @param array ...$vararg Arrays from which elements will be
 *   extracted. Values from later arrays overwrite the previous values.
 * @return array Returns an array, or NULL if an error occurs.
 * @since PHP 5 >= 5.3.0, PHP 7
 **/
function array_replace($array1, ...$vararg){}

/**
 * Replaces elements from passed arrays into the first array recursively
 *
 * {@link array_replace_recursive} replaces the values of {@link array1}
 * with the same values from all the following arrays. If a key from the
 * first array exists in the second array, its value will be replaced by
 * the value from the second array. If the key exists in the second
 * array, and not the first, it will be created in the first array. If a
 * key only exists in the first array, it will be left as is. If several
 * arrays are passed for replacement, they will be processed in order,
 * the later array overwriting the previous values.
 *
 * {@link array_replace_recursive} is recursive : it will recurse into
 * arrays and apply the same process to the inner value.
 *
 * When the value in the first array is scalar, it will be replaced by
 * the value in the second array, may it be scalar or array. When the
 * value in the first array and the second array are both arrays, {@link
 * array_replace_recursive} will replace their respective value
 * recursively.
 *
 * @param array $array1 The array in which elements are replaced.
 * @param array ...$vararg Optional. Arrays from which elements will be
 *   extracted.
 * @return array Returns an array, or NULL if an error occurs.
 * @since PHP 5 >= 5.3.0, PHP 7
 **/
function array_replace_recursive($array1, ...$vararg){}

/**
 * Return an array with elements in reverse order
 *
 * Takes an input {@link array} and returns a new array with the order of
 * the elements reversed.
 *
 * @param array $array The input array.
 * @param bool $preserve_keys If set to TRUE numeric keys are
 *   preserved. Non-numeric keys are not affected by this setting and
 *   will always be preserved.
 * @return array Returns the reversed array.
 * @since PHP 4, PHP 5, PHP 7
 **/
function array_reverse($array, $preserve_keys){}

/**
 * Searches the array for a given value and returns the first
 * corresponding key if successful
 *
 * Searches for {@link needle} in {@link haystack}.
 *
 * @param mixed $needle The searched value.
 * @param array $haystack The array.
 * @param bool $strict If the third parameter {@link strict} is set to
 *   TRUE then the {@link array_search} function will search for
 *   identical elements in the {@link haystack}. This means it will also
 *   perform a strict type comparison of the {@link needle} in the {@link
 *   haystack}, and objects must be the same instance.
 * @return mixed Returns the key for {@link needle} if it is found in
 *   the array, FALSE otherwise.
 * @since PHP 4 >= 4.0.5, PHP 5, PHP 7
 **/
function array_search($needle, $haystack, $strict){}

/**
 * Shift an element off the beginning of array
 *
 * {@link array_shift} shifts the first value of the {@link array} off
 * and returns it, shortening the {@link array} by one element and moving
 * everything down. All numerical array keys will be modified to start
 * counting from zero while literal keys won't be affected.
 *
 * @param array $array The input array.
 * @return mixed Returns the shifted value, or NULL if {@link array} is
 *   empty or is not an array.
 * @since PHP 4, PHP 5, PHP 7
 **/
function array_shift(&$array){}

/**
 * Extract a slice of the array
 *
 * {@link array_slice} returns the sequence of elements from the array
 * {@link array} as specified by the {@link offset} and {@link length}
 * parameters.
 *
 * @param array $array The input array.
 * @param int $offset If {@link offset} is non-negative, the sequence
 *   will start at that offset in the {@link array}. If {@link offset} is
 *   negative, the sequence will start that far from the end of the
 *   {@link array}.
 * @param int $length If {@link length} is given and is positive, then
 *   the sequence will have up to that many elements in it. If the array
 *   is shorter than the {@link length}, then only the available array
 *   elements will be present. If {@link length} is given and is negative
 *   then the sequence will stop that many elements from the end of the
 *   array. If it is omitted, then the sequence will have everything from
 *   {@link offset} up until the end of the {@link array}.
 * @param bool $preserve_keys
 * @return array Returns the slice. If the offset is larger than the
 *   size of the array, an empty array is returned.
 * @since PHP 4, PHP 5, PHP 7
 **/
function array_slice($array, $offset, $length, $preserve_keys){}

/**
 * Remove a portion of the array and replace it with something else
 *
 * Removes the elements designated by {@link offset} and {@link length}
 * from the {@link input} array, and replaces them with the elements of
 * the {@link replacement} array, if supplied.
 *
 * @param array $input The input array.
 * @param int $offset If {@link offset} is positive then the start of
 *   the removed portion is at that offset from the beginning of the
 *   {@link input} array. If {@link offset} is negative then the start of
 *   the removed portion is at that offset from the end of the {@link
 *   input} array.
 * @param int $length If {@link length} is omitted, removes everything
 *   from {@link offset} to the end of the array. If {@link length} is
 *   specified and is positive, then that many elements will be removed.
 *   If {@link length} is specified and is negative, then the end of the
 *   removed portion will be that many elements from the end of the
 *   array. If {@link length} is specified and is zero, no elements will
 *   be removed.
 * @param mixed $replacement If {@link replacement} array is specified,
 *   then the removed elements are replaced with elements from this
 *   array. If {@link offset} and {@link length} are such that nothing is
 *   removed, then the elements from the {@link replacement} array are
 *   inserted in the place specified by the {@link offset}. If {@link
 *   replacement} is just one element it is not necessary to put array()
 *   or square brackets around it, unless the element is an array itself,
 *   an object or NULL.
 * @return array Returns an array consisting of the extracted elements.
 * @since PHP 4, PHP 5, PHP 7
 **/
function array_splice(&$input, $offset, $length, $replacement){}

/**
 * Calculate the sum of values in an array
 *
 * {@link array_sum} returns the sum of values in an array.
 *
 * @param array $array The input array.
 * @return number Returns the sum of values as an integer or float; 0
 *   if the {@link array} is empty.
 * @since PHP 4 >= 4.0.4, PHP 5, PHP 7
 **/
function array_sum($array){}

/**
 * Computes the difference of arrays by using a callback function for
 * data comparison
 *
 * Computes the difference of arrays by using a callback function for
 * data comparison. This is unlike {@link array_diff} which uses an
 * internal function for comparing the data.
 *
 * @param array $array1 The first array.
 * @param array $array2 The second array.
 * @param array ...$vararg The callback comparison function.
 * @param callable $value_compare_func
 * @return array Returns an array containing all the values of {@link
 *   array1} that are not present in any of the other arguments.
 * @since PHP 5, PHP 7
 **/
function array_udiff($array1, $array2, $value_compare_func){}

/**
 * Computes the difference of arrays with additional index check,
 * compares data by a callback function
 *
 * Computes the difference of arrays with additional index check,
 * compares data by a callback function.
 *
 * @param array $array1 The first array.
 * @param array $array2 The second array.
 * @param array ...$vararg
 * @param callable $value_compare_func
 * @return array {@link array_udiff_assoc} returns an array containing
 *   all the values from {@link array1} that are not present in any of
 *   the other arguments. Note that the keys are used in the comparison
 *   unlike {@link array_diff} and {@link array_udiff}. The comparison of
 *   arrays' data is performed by using an user-supplied callback. In
 *   this aspect the behaviour is opposite to the behaviour of {@link
 *   array_diff_assoc} which uses internal function for comparison.
 * @since PHP 5, PHP 7
 **/
function array_udiff_assoc($array1, $array2, $value_compare_func){}

/**
 * Computes the difference of arrays with additional index check,
 * compares data and indexes by a callback function
 *
 * Computes the difference of arrays with additional index check,
 * compares data and indexes by a callback function.
 *
 * Note that the keys are used in the comparison unlike {@link
 * array_diff} and {@link array_udiff}.
 *
 * @param array $array1 The first array.
 * @param array $array2 The second array.
 * @param array ...$vararg
 * @param callable $value_compare_func The comparison of keys (indices)
 *   is done also by the callback function {@link key_compare_func}. This
 *   behaviour is unlike what {@link array_udiff_assoc} does, since the
 *   latter compares the indices by using an internal function.
 * @param callable $key_compare_func
 * @return array Returns an array containing all the values from {@link
 *   array1} that are not present in any of the other arguments.
 * @since PHP 5, PHP 7
 **/
function array_udiff_uassoc($array1, $array2, $value_compare_func, $key_compare_func){}

/**
 * Computes the intersection of arrays, compares data by a callback
 * function
 *
 * @param array $array1 The first array.
 * @param array $array2 The second array.
 * @param array ...$vararg
 * @param callable $value_compare_func
 * @return array Returns an array containing all the values of {@link
 *   array1} that are present in all the arguments.
 * @since PHP 5, PHP 7
 **/
function array_uintersect($array1, $array2, $value_compare_func){}

/**
 * Computes the intersection of arrays with additional index check,
 * compares data by a callback function
 *
 * Computes the intersection of arrays with additional index check,
 * compares data by a callback function.
 *
 * Note that the keys are used in the comparison unlike in {@link
 * array_uintersect}. The data is compared by using a callback function.
 *
 * @param array $array1 The first array.
 * @param array $array2 The second array.
 * @param array ...$vararg
 * @param callable $value_compare_func
 * @return array Returns an array containing all the values of {@link
 *   array1} that are present in all the arguments.
 * @since PHP 5, PHP 7
 **/
function array_uintersect_assoc($array1, $array2, $value_compare_func){}

/**
 * Computes the intersection of arrays with additional index check,
 * compares data and indexes by separate callback functions
 *
 * Computes the intersection of arrays with additional index check,
 * compares data and indexes by separate callback functions.
 *
 * @param array $array1 The first array.
 * @param array $array2 The second array.
 * @param array ...$vararg
 * @param callable $value_compare_func Key comparison callback
 *   function.
 * @param callable $key_compare_func
 * @return array Returns an array containing all the values of {@link
 *   array1} that are present in all the arguments.
 * @since PHP 5, PHP 7
 **/
function array_uintersect_uassoc($array1, $array2, $value_compare_func, $key_compare_func){}

/**
 * Removes duplicate values from an array
 *
 * Takes an input {@link array} and returns a new array without duplicate
 * values.
 *
 * Note that keys are preserved. If multiple elements compare equal under
 * the given {@link sort_flags}, then the key and value of the first
 * equal element will be retained.
 *
 * @param array $array The input array.
 * @param int $sort_flags The optional second parameter {@link
 *   sort_flags} may be used to modify the sorting behavior using these
 *   values: Sorting type flags: SORT_REGULAR - compare items normally
 *   (don't change types) SORT_NUMERIC - compare items numerically
 *   SORT_STRING - compare items as strings SORT_LOCALE_STRING - compare
 *   items as strings, based on the current locale.
 * @return array Returns the filtered array.
 * @since PHP 4 >= 4.0.1, PHP 5, PHP 7
 **/
function array_unique($array, $sort_flags){}

/**
 * Prepend one or more elements to the beginning of an array
 *
 * {@link array_unshift} prepends passed elements to the front of the
 * {@link array}. Note that the list of elements is prepended as a whole,
 * so that the prepended elements stay in the same order. All numerical
 * array keys will be modified to start counting from zero while literal
 * keys won't be changed.
 *
 * @param array $array The input array.
 * @param mixed ...$vararg The values to prepend.
 * @return int Returns the new number of elements in the {@link array}.
 * @since PHP 4, PHP 5, PHP 7
 **/
function array_unshift(&$array, ...$vararg){}

/**
 * Return all the values of an array
 *
 * {@link array_values} returns all the values from the {@link array} and
 * indexes the array numerically.
 *
 * @param array $array The array.
 * @return array Returns an indexed array of values.
 * @since PHP 4, PHP 5, PHP 7
 **/
function array_values($array){}

/**
 * Apply a user supplied function to every member of an array
 *
 * {@link array_walk} is not affected by the internal array pointer of
 * {@link array}. {@link array_walk} will walk through the entire array
 * regardless of pointer position.
 *
 * @param array $array The input array.
 * @param callable $callback Typically, {@link callback} takes on two
 *   parameters. The {@link array} parameter's value being the first, and
 *   the key/index second. Only the values of the {@link array} may
 *   potentially be changed; its structure cannot be altered, i.e., the
 *   programmer cannot add, unset or reorder elements. If the callback
 *   does not respect this requirement, the behavior of this function is
 *   undefined, and unpredictable.
 * @param mixed $userdata If the optional {@link userdata} parameter is
 *   supplied, it will be passed as the third parameter to the {@link
 *   callback}.
 * @return bool Returns TRUE.
 * @since PHP 4, PHP 5, PHP 7
 **/
function array_walk(&$array, $callback, $userdata){}

/**
 * Apply a user function recursively to every member of an array
 *
 * Applies the user-defined {@link callback} function to each element of
 * the {@link array}. This function will recurse into deeper arrays.
 *
 * @param array $array The input array.
 * @param callable $callback Typically, {@link callback} takes on two
 *   parameters. The {@link array} parameter's value being the first, and
 *   the key/index second.
 * @param mixed $userdata If the optional {@link userdata} parameter is
 *   supplied, it will be passed as the third parameter to the {@link
 *   callback}.
 * @return bool
 * @since PHP 5, PHP 7
 **/
function array_walk_recursive(&$array, $callback, $userdata){}

/**
 * Sort an array in reverse order and maintain index association
 *
 * This function sorts an array such that array indices maintain their
 * correlation with the array elements they are associated with.
 *
 * This is used mainly when sorting associative arrays where the actual
 * element order is significant.
 *
 * @param array $array The input array.
 * @param int $sort_flags You may modify the behavior of the sort using
 *   the optional parameter {@link sort_flags}, for details see {@link
 *   sort}.
 * @return bool
 * @since PHP 4, PHP 5, PHP 7
 **/
function arsort(&$array, $sort_flags){}

/**
 * Arc sine
 *
 * Returns the arc sine of {@link arg} in radians. {@link asin} is the
 * inverse function of {@link sin}, which means that a==sin(asin(a)) for
 * every value of a that is within {@link asin}'s range.
 *
 * @param float $arg The argument to process
 * @return float The arc sine of {@link arg} in radians
 * @since PHP 4, PHP 5, PHP 7
 **/
function asin($arg){}

/**
 * Inverse hyperbolic sine
 *
 * Returns the inverse hyperbolic sine of {@link arg}, i.e. the value
 * whose hyperbolic sine is {@link arg}.
 *
 * @param float $arg The argument to process
 * @return float The inverse hyperbolic sine of {@link arg}
 * @since PHP 4 >= 4.1.0, PHP 5, PHP 7
 **/
function asinh($arg){}

/**
 * Sort an array and maintain index association
 *
 * This function sorts an array such that array indices maintain their
 * correlation with the array elements they are associated with. This is
 * used mainly when sorting associative arrays where the actual element
 * order is significant.
 *
 * @param array $array The input array.
 * @param int $sort_flags You may modify the behavior of the sort using
 *   the optional parameter {@link sort_flags}, for details see {@link
 *   sort}.
 * @return bool
 * @since PHP 4, PHP 5, PHP 7
 **/
function asort(&$array, $sort_flags){}

/**
 * Checks if assertion is FALSE
 *
 * PHP 5 and 7
 *
 * PHP 7
 *
 * {@link assert} will check the given {@link assertion} and take
 * appropriate action if its result is FALSE.
 *
 * @param mixed $assertion The assertion. In PHP 5, this must be either
 *   a string to be evaluated or a boolean to be tested. In PHP 7, this
 *   may also be any expression that returns a value, which will be
 *   executed and the result used to indicate whether the assertion
 *   succeeded or failed.
 * @param string $description An optional description that will be
 *   included in the failure message if the {@link assertion} fails.
 * @return bool FALSE if the assertion is false, TRUE otherwise.
 * @since PHP 4, PHP 5, PHP 7
 **/
function assert($assertion, $description){}

/**
 * Set/get the various assert flags
 *
 * Set the various {@link assert} control options or just query their
 * current settings.
 *
 * @param int $what Assert Options Option INI Setting Default value
 *   Description ASSERT_ACTIVE assert.active 1 enable {@link assert}
 *   evaluation ASSERT_WARNING assert.warning 1 issue a PHP warning for
 *   each failed assertion ASSERT_BAIL assert.bail 0 terminate execution
 *   on failed assertions ASSERT_QUIET_EVAL assert.quiet_eval 0 disable
 *   error_reporting during assertion expression evaluation
 *   ASSERT_CALLBACK assert.callback (NULL) Callback to call on failed
 *   assertions
 * @param mixed $value An optional new value for the option.
 * @return mixed Returns the original setting of any option or FALSE on
 *   errors.
 * @since PHP 4, PHP 5, PHP 7
 **/
function assert_options($what, $value){}

/**
 * Arc tangent
 *
 * Returns the arc tangent of {@link arg} in radians. {@link atan} is the
 * inverse function of {@link tan}, which means that a==tan(atan(a)) for
 * every value of a that is within {@link atan}'s range.
 *
 * @param float $arg The argument to process
 * @return float The arc tangent of {@link arg} in radians.
 * @since PHP 4, PHP 5, PHP 7
 **/
function atan($arg){}

/**
 * Arc tangent of two variables
 *
 * @param float $y Dividend parameter
 * @param float $x Divisor parameter
 * @return float The arc tangent of {@link y}/{@link x} in radians.
 * @since PHP 4, PHP 5, PHP 7
 **/
function atan2($y, $x){}

/**
 * Inverse hyperbolic tangent
 *
 * Returns the inverse hyperbolic tangent of {@link arg}, i.e. the value
 * whose hyperbolic tangent is {@link arg}.
 *
 * @param float $arg The argument to process
 * @return float Inverse hyperbolic tangent of {@link arg}
 * @since PHP 4 >= 4.1.0, PHP 5, PHP 7
 **/
function atanh($arg){}

/**
 * Decodes data encoded with MIME base64
 *
 * Decodes a base64 encoded {@link data}.
 *
 * @param string $data The encoded data.
 * @param bool $strict If the {@link strict} parameter is set to TRUE
 *   then the {@link base64_decode} function will return FALSE if the
 *   input contains character from outside the base64 alphabet. Otherwise
 *   invalid characters will be silently discarded.
 * @return string Returns the decoded data. The returned data may be
 *   binary.
 * @since PHP 4, PHP 5, PHP 7
 **/
function base64_decode($data, $strict){}

/**
 * Encodes data with MIME base64
 *
 * Encodes the given {@link data} with base64.
 *
 * This encoding is designed to make binary data survive transport
 * through transport layers that are not 8-bit clean, such as mail
 * bodies.
 *
 * Base64-encoded data takes about 33% more space than the original data.
 *
 * @param string $data The data to encode.
 * @return string The encoded data, as a string.
 * @since PHP 4, PHP 5, PHP 7
 **/
function base64_encode($data){}

/**
 * Returns trailing name component of path
 *
 * Given a string containing the path to a file or directory, this
 * function will return the trailing name component.
 *
 * @param string $path A path. On Windows, both slash (/) and backslash
 *   (\) are used as directory separator character. In other
 *   environments, it is the forward slash (/).
 * @param string $suffix If the name component ends in {@link suffix}
 *   this will also be cut off.
 * @return string Returns the base name of the given {@link path}.
 * @since PHP 4, PHP 5, PHP 7
 **/
function basename($path, $suffix){}

/**
 * Convert a number between arbitrary bases
 *
 * Returns a string containing {@link number} represented in base {@link
 * tobase}. The base in which {@link number} is given is specified in
 * {@link frombase}. Both {@link frombase} and {@link tobase} have to be
 * between 2 and 36, inclusive. Digits in numbers with a base higher than
 * 10 will be represented with the letters a-z, with a meaning 10, b
 * meaning 11 and z meaning 35. The case of the letters doesn't matter,
 * i.e. {@link number} is interpreted case-insensitively.
 *
 * @param string $number The number to convert. Any invalid characters
 *   in {@link number} are silently ignored.
 * @param int $frombase The base {@link number} is in
 * @param int $tobase The base to convert {@link number} to
 * @return string {@link number} converted to base {@link tobase}
 * @since PHP 4, PHP 5, PHP 7
 **/
function base_convert($number, $frombase, $tobase){}

/**
 * Adds a bbcode element
 *
 * Adds a tag to an existing BBCode_Container tag_set using tag_rules.
 *
 * @param resource $bbcode_container BBCode_Container resource,
 *   returned by {@link bbcode_create}.
 * @param string $tag_name The new tag to add to the BBCode_Container
 *   tag_set.
 * @param array $tag_rules An associative array containing the parsing
 *   rules; see {@link bbcode_create} for the available keys.
 * @return bool
 * @since PECL bbcode >= 0.9.0
 **/
function bbcode_add_element($bbcode_container, $tag_name, $tag_rules){}

/**
 * Adds a smiley to the parser
 *
 * @param resource $bbcode_container BBCode_Container resource,
 *   returned by {@link bbcode_create}.
 * @param string $smiley The string that will be replaced when found.
 * @param string $replace_by The string that replace smiley when found.
 * @return bool
 * @since PECL bbcode >= 0.10.2
 **/
function bbcode_add_smiley($bbcode_container, $smiley, $replace_by){}

/**
 * Create a BBCode Resource
 *
 * This function returns a new BBCode Resource used to parse BBCode
 * strings.
 *
 * @param array $bbcode_initial_tags An associative array containing
 *   the tag names as keys and parameters required to correctly parse
 *   BBCode as their value. The following key/value pairs are supported:
 *   flags optional - a flag set based on the BBCODE_FLAGS_* constants.
 *   type required - an int indicating the type of tag. Use the
 *   BBCODE_TYPE_* constants. open_tag required - the HTML replacement
 *   string for the open tag. close_tag required - the HTML replacement
 *   string for the close tag. default_arg optional - use this value as
 *   the default argument if none is provided and tag_type is of type
 *   OPTARG. content_handling optional - Gives the callback used for
 *   modification of the content. Object Oriented Notation supported only
 *   since 0.10.1 callback prototype is string name(string $content,
 *   string $argument) param_handling optional - Gives the callback used
 *   for modification of the argument. Object Oriented Notation supported
 *   only since 0.10.1 callback prototype is string name(string $content,
 *   string $argument) childs optional - List of accepted children for
 *   the tag. The format of the list is a comma separated string. If the
 *   list starts with ! it will be the list of rejected children for the
 *   tag. parent optional - List of accepted parents for the tag. The
 *   format of the list is a comma separated string.
 * @return resource Returns a BBCode_Container
 * @since PECL bbcode >= 0.9.0
 **/
function bbcode_create($bbcode_initial_tags){}

/**
 * Close BBCode_container resource
 *
 * This function closes the resource opened by {@link bbcode_create}.
 *
 * @param resource $bbcode_container BBCode_Container resource returned
 *   by {@link bbcode_create}.
 * @return bool
 * @since PECL bbcode >= 0.9.0
 **/
function bbcode_destroy($bbcode_container){}

/**
 * Parse a string following a given rule set
 *
 * This function parse the string to_parse following the rules in the
 * bbcode_container created by {@link bbcode_create}
 *
 * @param resource $bbcode_container BBCode_Container resource returned
 *   by {@link bbcode_create}.
 * @param string $to_parse The string we need to parse.
 * @return string Returns the parsed string, .
 * @since PECL bbcode >= 0.9.0
 **/
function bbcode_parse($bbcode_container, $to_parse){}

/**
 * Attach another parser in order to use another rule set for argument
 * parsing
 *
 * Attaches another parser to the bbcode_container. This parser is used
 * only when arguments must be parsed. If this function is not used, the
 * default argument parser is the parser itself.
 *
 * @param resource $bbcode_container BBCode_Container resource,
 *   returned by {@link bbcode_create}.
 * @param resource $bbcode_arg_parser BBCode_Container resource,
 *   returned by {@link bbcode_create}. It will be used only for parsed
 *   arguments
 * @return bool
 * @since PECL bbcode >= 0.10.2
 **/
function bbcode_set_arg_parser($bbcode_container, $bbcode_arg_parser){}

/**
 * Set or alter parser options
 *
 * @param resource $bbcode_container BBCode_Container resource,
 *   returned by {@link bbcode_create}.
 * @param int $flags The flag set that must be applied to the
 *   bbcode_container options
 * @param int $mode One of the BBCODE_SET_FLAGS_* constant to set,
 *   unset a specific flag set or to replace the flag set by flags.
 * @return bool
 * @since PECL bbcode >= 0.10.2
 **/
function bbcode_set_flags($bbcode_container, $flags, $mode){}

/**
 * Add two arbitrary precision numbers
 *
 * Sums {@link left_operand} and {@link right_operand}.
 *
 * @param string $left_operand The left operand, as a string.
 * @param string $right_operand The right operand, as a string.
 * @param int $scale
 * @return string The sum of the two operands, as a string.
 * @since PHP 4, PHP 5, PHP 7
 **/
function bcadd($left_operand, $right_operand, $scale){}

/**
 * Compare two arbitrary precision numbers
 *
 * Compares the {@link left_operand} to the {@link right_operand} and
 * returns the result as an integer.
 *
 * @param string $left_operand The left operand, as a string.
 * @param string $right_operand The right operand, as a string.
 * @param int $scale The optional {@link scale} parameter is used to
 *   set the number of digits after the decimal place which will be used
 *   in the comparison.
 * @return int Returns 0 if the two operands are equal, 1 if the {@link
 *   left_operand} is larger than the {@link right_operand}, -1
 *   otherwise.
 * @since PHP 4, PHP 5, PHP 7
 **/
function bccomp($left_operand, $right_operand, $scale){}

/**
 * Divide two arbitrary precision numbers
 *
 * Divides the {@link dividend} by the {@link divisor}.
 *
 * @param string $dividend The dividend, as a string.
 * @param string $divisor The divisor, as a string.
 * @param int $scale
 * @return string Returns the result of the division as a string, or
 *   NULL if {@link divisor} is 0.
 * @since PHP 4, PHP 5, PHP 7
 **/
function bcdiv($dividend, $divisor, $scale){}

/**
 * Get modulus of an arbitrary precision number
 *
 * Get the remainder of dividing {@link dividend} by {@link divisor}.
 * Unless {@link divisor} is zero, the result has the same sign as {@link
 * dividend}.
 *
 * @param string $dividend The dividend, as a string.
 * @param string $divisor The divisor, as a string.
 * @param int $scale
 * @return string Returns the modulus as a string, or NULL if {@link
 *   divisor} is 0.
 * @since PHP 4, PHP 5, PHP 7
 **/
function bcmod($dividend, $divisor, $scale){}

/**
 * Multiply two arbitrary precision numbers
 *
 * Multiply the {@link left_operand} by the {@link right_operand}.
 *
 * @param string $left_operand The left operand, as a string.
 * @param string $right_operand The right operand, as a string.
 * @param int $scale
 * @return string Returns the result as a string.
 * @since PHP 4, PHP 5, PHP 7
 **/
function bcmul($left_operand, $right_operand, $scale){}

/**
 * Reads and creates classes from a bz compressed file
 *
 * Reads data from a bzcompressed file and creates classes from the
 * bytecodes.
 *
 * @param string $filename The bzcompressed file path, as a string.
 * @return bool
 * @since PECL bcompiler >= 0.4
 **/
function bcompiler_load($filename){}

/**
 * Reads and creates classes from a bcompiler exe file
 *
 * Reads data from a bcompiler exe file and creates classes from the
 * bytecodes.
 *
 * @param string $filename The exe file path, as a string.
 * @return bool
 * @since PECL bcompiler >= 0.4
 **/
function bcompiler_load_exe($filename){}

/**
 * Reads the bytecodes of a class and calls back to a user function
 *
 * @param string $class The class name, as a string.
 * @param string $callback
 * @return bool
 * @since PECL bcompiler >= 0.4
 **/
function bcompiler_parse_class($class, $callback){}

/**
 * Reads and creates classes from a filehandle
 *
 * Reads data from a open file handle and creates classes from the
 * bytecodes.
 *
 * @param resource $filehandle A file handle as returned by {@link
 *   fopen}.
 * @return bool
 * @since PECL bcompiler >= 0.4
 **/
function bcompiler_read($filehandle){}

/**
 * Writes a defined class as bytecodes
 *
 * Reads the bytecodes from PHP for an existing class, and writes them to
 * the open file handle.
 *
 * @param resource $filehandle A file handle as returned by {@link
 *   fopen}.
 * @param string $className The class name, as a string.
 * @param string $extends
 * @return bool
 * @since PECL bcompiler >= 0.4
 **/
function bcompiler_write_class($filehandle, $className, $extends){}

/**
 * Writes a defined constant as bytecodes
 *
 * Reads the bytecodes from PHP for an existing constant, and writes them
 * to the open file handle.
 *
 * @param resource $filehandle A file handle as returned by {@link
 *   fopen}.
 * @param string $constantName The name of the defined constant, as a
 *   string.
 * @return bool
 * @since PECL bcompiler >= 0.5
 **/
function bcompiler_write_constant($filehandle, $constantName){}

/**
 * Writes the start pos, and sig to the end of a exe type file
 *
 * An EXE (or self executable) file consists of 3 parts: The stub
 * (executable code, e.g. a compiled C program) that loads PHP
 * interpreter, bcompiler extension, stored Bytecodes and initiates a
 * call for the specified function (e.g. main) or class method (e.g.
 * main::main) The Bytecodes (uncompressed only for the moment) The
 * bcompiler EXE footer
 *
 * To obtain a suitable stub you can compile php_embed-based stub phpe.c
 * located in the examples/embed directory on bcompiler's CVS.
 *
 * @param resource $filehandle A file handle as returned by {@link
 *   fopen}.
 * @param int $startpos The file position at which the Bytecodes start,
 *   and can be obtained using {@link ftell}.
 * @return bool
 * @since PECL bcompiler >= 0.4
 **/
function bcompiler_write_exe_footer($filehandle, $startpos){}

/**
 * Writes a php source file as bytecodes
 *
 * This function compiles specified source file into bytecodes, and
 * writes them to the open file handle.
 *
 * @param resource $filehandle A file handle as returned by {@link
 *   fopen}.
 * @param string $filename The source file path, as a string.
 * @return bool
 * @since PECL bcompiler >= 0.6
 **/
function bcompiler_write_file($filehandle, $filename){}

/**
 * Writes the single character \x00 to indicate End of compiled data
 *
 * Writes the single character \x00 to indicate End of compiled data.
 *
 * @param resource $filehandle A file handle as returned by {@link
 *   fopen}.
 * @return bool
 * @since PECL bcompiler >= 0.4
 **/
function bcompiler_write_footer($filehandle){}

/**
 * Writes a defined function as bytecodes
 *
 * Reads the bytecodes from PHP for an existing function, and writes them
 * to the open file handle. Order is not important, (eg. if function b
 * uses function a, and you compile it like the example below, it will
 * work perfectly OK).
 *
 * @param resource $filehandle A file handle as returned by {@link
 *   fopen}.
 * @param string $functionName The function name, as a string.
 * @return bool
 * @since PECL bcompiler >= 0.5
 **/
function bcompiler_write_function($filehandle, $functionName){}

/**
 * Writes all functions defined in a file as bytecodes
 *
 * Searches for all functions declared in the given file, and writes
 * their correspondent bytecodes to the open file handle.
 *
 * @param resource $filehandle A file handle as returned by {@link
 *   fopen}.
 * @param string $fileName The file to be compiled. You must always
 *   include or require the file you intend to compile.
 * @return bool
 * @since PECL bcompiler >= 0.5
 **/
function bcompiler_write_functions_from_file($filehandle, $fileName){}

/**
 * Writes the bcompiler header
 *
 * Writes the header part of a bcompiler file.
 *
 * @param resource $filehandle A file handle as returned by {@link
 *   fopen}.
 * @param string $write_ver Can be used to write bytecode in a
 *   previously used format, so that you can use it with older versions
 *   of bcompiler.
 * @return bool
 * @since PECL bcompiler >= 0.3
 **/
function bcompiler_write_header($filehandle, $write_ver){}

/**
 * Writes an included file as bytecodes
 *
 * @param resource $filehandle
 * @param string $filename
 * @return bool
 * @since PECL bcompiler >= 0.5
 **/
function bcompiler_write_included_filename($filehandle, $filename){}

/**
 * Raise an arbitrary precision number to another
 *
 * Raise {@link base} to the power {@link exponent}.
 *
 * @param string $base The base, as a string.
 * @param string $exponent The exponent, as a string. If the exponent
 *   is non-integral, it is truncated. The valid range of the exponent is
 *   platform specific, but is at least -2147483648 to 2147483647.
 * @param int $scale
 * @return string Returns the result as a string.
 * @since PHP 4, PHP 5, PHP 7
 **/
function bcpow($base, $exponent, $scale){}

/**
 * Raise an arbitrary precision number to another, reduced by a specified
 * modulus
 *
 * Use the fast-exponentiation method to raise {@link base} to the power
 * {@link exponent} with respect to the modulus {@link modulus}.
 *
 * @param string $base The base, as an integral string (i.e. the scale
 *   has to be zero).
 * @param string $exponent The exponent, as an non-negative, integral
 *   string (i.e. the scale has to be zero).
 * @param string $modulus The modulus, as an integral string (i.e. the
 *   scale has to be zero).
 * @param int $scale
 * @return string Returns the result as a string, or NULL if {@link
 *   modulus} is 0 or {@link exponent} is negative.
 * @since PHP 5, PHP 7
 **/
function bcpowmod($base, $exponent, $modulus, $scale){}

/**
 * Set or get default scale parameter for all bc math functions
 *
 * Sets the default scale parameter for all subsequent calls to bc math
 * functions that do not explicitly specify a scale parameter.
 *
 * Gets the current scale factor.
 *
 * @param int $scale The scale factor.
 * @return int Returns the old scale when used as setter. Otherwise the
 *   current scale is returned.
 * @since PHP 4, PHP 5, PHP 7
 **/
function bcscale($scale){}

/**
 * Get the square root of an arbitrary precision number
 *
 * Return the square root of the {@link operand}.
 *
 * @param string $operand The operand, as a string.
 * @param int $scale
 * @return string Returns the square root as a string, or NULL if
 *   {@link operand} is negative.
 * @since PHP 4, PHP 5, PHP 7
 **/
function bcsqrt($operand, $scale){}

/**
 * Subtract one arbitrary precision number from another
 *
 * Subtracts the {@link right_operand} from the {@link left_operand}.
 *
 * @param string $left_operand The left operand, as a string.
 * @param string $right_operand The right operand, as a string.
 * @param int $scale
 * @return string The result of the subtraction, as a string.
 * @since PHP 4, PHP 5, PHP 7
 **/
function bcsub($left_operand, $right_operand, $scale){}

/**
 * Convert binary data into hexadecimal representation
 *
 * Returns an ASCII string containing the hexadecimal representation of
 * {@link str}. The conversion is done byte-wise with the high-nibble
 * first.
 *
 * @param string $str A string.
 * @return string Returns the hexadecimal representation of the given
 *   string.
 * @since PHP 4, PHP 5, PHP 7
 **/
function bin2hex($str){}

/**
 * Binary to decimal
 *
 * Returns the decimal equivalent of the binary number represented by the
 * {@link binary_string} argument.
 *
 * {@link bindec} converts a binary number to an integer or, if needed
 * for size reasons, float.
 *
 * {@link bindec} interprets all {@link binary_string} values as unsigned
 * integers. This is because {@link bindec} sees the most significant bit
 * as another order of magnitude rather than as the sign bit.
 *
 * @param string $binary_string The binary string to convert
 * @return number The decimal value of {@link binary_string}
 * @since PHP 4, PHP 5, PHP 7
 **/
function bindec($binary_string){}

/**
 * Sets the path for a domain
 *
 * The {@link bindtextdomain} function sets the path for a domain.
 *
 * @param string $domain The domain
 * @param string $directory The directory path
 * @return string The full pathname for the {@link domain} currently
 *   being set.
 * @since PHP 4, PHP 5, PHP 7
 **/
function bindtextdomain($domain, $directory){}

/**
 * Specify the character encoding in which the messages from the DOMAIN
 * message catalog will be returned
 *
 * With {@link bind_textdomain_codeset}, you can set in which encoding
 * will be messages from {@link domain} returned by {@link gettext} and
 * similar functions.
 *
 * @param string $domain The domain
 * @param string $codeset The code set
 * @return string A string on success.
 * @since PHP 4 >= 4.2.0, PHP 5, PHP 7
 **/
function bind_textdomain_codeset($domain, $codeset){}

/**
 * Encrypt a PHP script with BLENC
 *
 * Encrypt the {@link plaintext} content and write it into {@link
 * encodedfile}
 *
 * @param string $plaintext A source code to encrypt. Does not need to
 *   contain opening/closing PHP tags
 * @param string $encodedfile The filename where BLENC will save the
 *   encoded source.
 * @param string $encryption_key The key that BLENC will use to encrypt
 *   plaintext content. If not given BLENC will create a valid key.
 * @return string BLENC will return the redistributable key that must
 *   be saved into key_file: the path of key_file is specified at runtime
 *   with the option blenc.key_file
 * @since PECL blenc >= 5
 **/
function blenc_encrypt($plaintext, $encodedfile, $encryption_key){}

/**
 * Get the boolean value of a variable
 *
 * Returns the boolean value of {@link var}.
 *
 * @param mixed $var The scalar value being converted to a boolean.
 * @return bool The boolean value of {@link var}.
 * @since PHP 5 >= 5.5.0, PHP 7
 **/
function boolval($var){}

/**
 * Deserializes a BSON object into a PHP array
 *
 * This function is very beta and entirely useless for 99% of users. It
 * is only useful if you're doing something weird, such as writing your
 * own driver on top of the PHP driver.
 *
 * @param string $bson The BSON to be deserialized.
 * @return array Returns the deserialized BSON object.
 * @since PECL mongo >=1.0.1
 **/
function bson_decode($bson){}

/**
 * Serializes a PHP variable into a BSON string
 *
 * This function is very beta and entirely useless for 99% of users. It
 * is only useful if you're doing something weird, such as writing your
 * own driver on top of the PHP driver.
 *
 * @param mixed $anything The variable to be serialized.
 * @return string Returns the serialized string.
 * @since PECL mongo >=1.0.1
 **/
function bson_encode($anything){}

/**
 * Close a bzip2 file
 *
 * Closes the given bzip2 file pointer.
 *
 * @param resource $bz The file pointer. It must be valid and must
 *   point to a file successfully opened by {@link bzopen}.
 * @return bool
 * @since PHP 4 >= 4.0.4, PHP 5, PHP 7
 **/
function bzclose($bz){}

/**
 * Compress a string into bzip2 encoded data
 *
 * {@link bzcompress} compresses the given string and returns it as bzip2
 * encoded data.
 *
 * @param string $source The string to compress.
 * @param int $blocksize Specifies the blocksize used during
 *   compression and should be a number from 1 to 9 with 9 giving the
 *   best compression, but using more resources to do so.
 * @param int $workfactor Controls how the compression phase behaves
 *   when presented with worst case, highly repetitive, input data. The
 *   value can be between 0 and 250 with 0 being a special case.
 *   Regardless of the {@link workfactor}, the generated output is the
 *   same.
 * @return mixed The compressed string, or an error number if an error
 *   occurred.
 * @since PHP 4 >= 4.0.4, PHP 5, PHP 7
 **/
function bzcompress($source, $blocksize, $workfactor){}

/**
 * Decompresses bzip2 encoded data
 *
 * {@link bzdecompress} decompresses the given string containing bzip2
 * encoded data.
 *
 * @param string $source The string to decompress.
 * @param int $small If TRUE, an alternative decompression algorithm
 *   will be used which uses less memory (the maximum memory requirement
 *   drops to around 2300K) but works at roughly half the speed. See the
 *   bzip2 documentation for more information about this feature.
 * @return mixed The decompressed string, or an error number if an
 *   error occurred.
 * @since PHP 4 >= 4.0.4, PHP 5, PHP 7
 **/
function bzdecompress($source, $small){}

/**
 * Returns a bzip2 error number
 *
 * Returns the error number of any bzip2 error returned by the given file
 * pointer.
 *
 * @param resource $bz The file pointer. It must be valid and must
 *   point to a file successfully opened by {@link bzopen}.
 * @return int Returns the error number as an integer.
 * @since PHP 4 >= 4.0.4, PHP 5, PHP 7
 **/
function bzerrno($bz){}

/**
 * Returns the bzip2 error number and error string in an array
 *
 * Returns the error number and error string of any bzip2 error returned
 * by the given file pointer.
 *
 * @param resource $bz The file pointer. It must be valid and must
 *   point to a file successfully opened by {@link bzopen}.
 * @return array Returns an associative array, with the error code in
 *   the errno entry, and the error message in the errstr entry.
 * @since PHP 4 >= 4.0.4, PHP 5, PHP 7
 **/
function bzerror($bz){}

/**
 * Returns a bzip2 error string
 *
 * Gets the error string of any bzip2 error returned by the given file
 * pointer.
 *
 * @param resource $bz The file pointer. It must be valid and must
 *   point to a file successfully opened by {@link bzopen}.
 * @return string Returns a string containing the error message.
 * @since PHP 4 >= 4.0.4, PHP 5, PHP 7
 **/
function bzerrstr($bz){}

/**
 * Force a write of all buffered data
 *
 * Forces a write of all buffered bzip2 data for the file pointer {@link
 * bz}.
 *
 * @param resource $bz The file pointer. It must be valid and must
 *   point to a file successfully opened by {@link bzopen}.
 * @return bool
 * @since PHP 4 >= 4.0.4, PHP 5, PHP 7
 **/
function bzflush($bz){}

/**
 * Opens a bzip2 compressed file
 *
 * {@link bzopen} opens a bzip2 (.bz2) file for reading or writing.
 *
 * @param mixed $file The name of the file to open, or an existing
 *   stream resource.
 * @param string $mode The modes 'r' (read), and 'w' (write) are
 *   supported. Everything else will cause {@link bzopen} to return
 *   FALSE.
 * @return resource If the open fails, {@link bzopen} returns FALSE,
 *   otherwise it returns a pointer to the newly opened file.
 * @since PHP 4 >= 4.0.4, PHP 5, PHP 7
 **/
function bzopen($file, $mode){}

/**
 * Binary safe bzip2 file read
 *
 * {@link bzread} reads from the given bzip2 file pointer.
 *
 * Reading stops when {@link length} (uncompressed) bytes have been read
 * or EOF is reached, whichever comes first.
 *
 * @param resource $bz The file pointer. It must be valid and must
 *   point to a file successfully opened by {@link bzopen}.
 * @param int $length If not specified, {@link bzread} will read 1024
 *   (uncompressed) bytes at a time. A maximum of 8192 uncompressed bytes
 *   will be read at a time.
 * @return string Returns the uncompressed data, or FALSE on error.
 * @since PHP 4 >= 4.0.4, PHP 5, PHP 7
 **/
function bzread($bz, $length){}

/**
 * Binary safe bzip2 file write
 *
 * {@link bzwrite} writes a string into the given bzip2 file stream.
 *
 * @param resource $bz The file pointer. It must be valid and must
 *   point to a file successfully opened by {@link bzopen}.
 * @param string $data The written data.
 * @param int $length If supplied, writing will stop after {@link
 *   length} (uncompressed) bytes have been written or the end of {@link
 *   data} is reached, whichever comes first.
 * @return int Returns the number of bytes written, or FALSE on error.
 * @since PHP 4 >= 4.0.4, PHP 5, PHP 7
 **/
function bzwrite($bz, $data, $length){}

/**
 * Appends a path to current path
 *
 * Appends the {@link path} onto the current path. The {@link path} may
 * be either the return value from one of CairoContext::copyPath or
 * CairoContext::copyPathFlat;
 *
 * if {@link path} is not a valid CairoPath instance a CairoException
 * will be thrown
 *
 * @param CairoContext $context CairoContext object
 * @param CairoPath $path CairoPath object
 * @return void
 * @since PECL cairo >= 0.1.0
 **/
function cairo_append_path($context, $path){}

/**
 * Adds a circular arc
 *
 * Adds a circular arc of the given radius to the current path. The arc
 * is centered at ({@link x}, {@link y}), begins at {@link angle1} and
 * proceeds in the direction of increasing angles to end at {@link
 * angle2}. If {@link angle2} is less than {@link angle1} it will be
 * progressively increased by 2*M_PI until it is greater than {@link
 * angle1}. If there is a current point, an initial line segment will be
 * added to the path to connect the current point to the beginning of the
 * arc. If this initial line is undesired, it can be avoided by calling
 * CairoContext::newSubPath or procedural {@link cairo_new_sub_path}
 * before calling CairoContext::arc or {@link cairo_arc}.
 *
 * Angles are measured in radians. An angle of 0.0 is in the direction of
 * the positive X axis (in user space). An angle of M_PI/2.0 radians (90
 * degrees) is in the direction of the positive Y axis (in user space).
 * Angles increase in the direction from the positive X axis toward the
 * positive Y axis. So with the default transformation matrix, angles
 * increase in a clockwise direction.
 *
 * (To convert from degrees to radians, use degrees * (M_PI / 180.).)
 * This function gives the arc in the direction of increasing angles; see
 * CairoContext::arcNegative or {@link cairo_arc_negative} to get the arc
 * in the direction of decreasing angles.
 *
 * @param CairoContext $context A valid CairoContext object
 * @param float $x x position
 * @param float $y y position
 * @param float $radius Radius of the arc
 * @param float $angle1 start angle
 * @param float $angle2 end angle
 * @return void
 * @since PECL cairo >= 0.1.0
 **/
function cairo_arc($context, $x, $y, $radius, $angle1, $angle2){}

/**
 * Adds a negative arc
 *
 * Adds a circular arc of the given {@link radius} to the current path.
 * The arc is centered at ({@link x}, {@link y}), begins at {@link
 * angle1} and proceeds in the direction of decreasing angles to end at
 * {@link angle2}. If {@link angle2} is greater than {@link angle1} it
 * will be progressively decreased by 2*M_PI until it is less than {@link
 * angle1}.
 *
 * See CairoContext::arc or {@link cairo_arc} for more details. This
 * function differs only in the direction of the arc between the two
 * angles.
 *
 * @param CairoContext $context A valid CairoContext object
 * @param float $x double x position
 * @param float $y double y position
 * @param float $radius The radius of the desired negative arc
 * @param float $angle1 Start angle of the arc
 * @param float $angle2 End angle of the arc
 * @return void
 * @since PECL cairo >= 0.1.0
 **/
function cairo_arc_negative($context, $x, $y, $radius, $angle1, $angle2){}

/**
 * Retrieves the availables font types
 *
 * Returns an array with the available font backends
 *
 * @return array A list-type array with all available font backends.
 **/
function cairo_available_fonts(){}

/**
 * Retrieves all available surfaces
 *
 * Returns an array with the available surface backends
 *
 * @return array A list-type array with all available surface backends.
 **/
function cairo_available_surfaces(){}

/**
 * Establishes a new clip region
 *
 * Establishes a new clip region by intersecting the current clip region
 * with the current path as it would be filled by CairoContext::fill or
 * {@link cairo_fill} and according to the current fill rule (see
 * CairoContext::setFillRule or {@link cairo_set_fill_rule}).
 *
 * After CairoContext::clip or {@link cairo_clip}, the current path will
 * be cleared from the cairo context.
 *
 * The current clip region affects all drawing operations by effectively
 * masking out any changes to the surface that are outside the current
 * clip region.
 *
 * Calling CairoContext::clip or {@link cairo_clip} can only make the
 * clip region smaller, never larger. But the current clip is part of the
 * graphics state, so a temporary restriction of the clip region can be
 * achieved by calling CairoContext::clip or {@link cairo_clip} within a
 * CairoContext::save/CairoContext::restore or {@link cairo_save}/{@link
 * cairo_restore} pair. The only other means of increasing the size of
 * the clip region is CairoContext::resetClip or procedural {@link
 * cairo_reset_clip}.
 *
 * @param CairoContext $context A valid CairoContext object
 * @return void
 * @since PECL cairo >= 0.1.0
 **/
function cairo_clip($context){}

/**
 * Computes the area inside the current clip
 *
 * Computes a bounding box in user coordinates covering the area inside
 * the current clip.
 *
 * @param CairoContext $context A valid CairoContext object
 * @return array An array containing the (float)x1, (float)y1,
 *   (float)x2, (float)y2, coordinates covering the area inside the
 *   current clip
 * @since PECL cairo >= 0.1.0
 **/
function cairo_clip_extents($context){}

/**
 * Establishes a new clip region from the current clip
 *
 * Establishes a new clip region by intersecting the current clip region
 * with the current path as it would be filled by Context.fill and
 * according to the current FILL RULE (see CairoContext::setFillRule or
 * {@link cairo_set_fill_rule}).
 *
 * Unlike CairoContext::clip, CairoContext::clipPreserve preserves the
 * path within the Context. The current clip region affects all drawing
 * operations by effectively masking out any changes to the surface that
 * are outside the current clip region.
 *
 * Calling CairoContext::clipPreserve can only make the clip region
 * smaller, never larger. But the current clip is part of the graphics
 * state, so a temporary restriction of the clip region can be achieved
 * by calling CairoContext::clipPreserve within a
 * CairoContext::save/CairoContext::restore pair. The only other means of
 * increasing the size of the clip region is CairoContext::resetClip.
 *
 * @param CairoContext $context A valid CairoContext object
 * @return void
 * @since PECL cairo >= 0.1.0
 **/
function cairo_clip_preserve($context){}

/**
 * Retrieves the current clip as a list of rectangles
 *
 * Returns a list-type array with the current clip region as a list of
 * rectangles in user coordinates
 *
 * @param CairoContext $context A valid CairoContext object created
 *   with CairoContext::__construct or {@link cairo_create}
 * @return array An array of user-space represented rectangles for the
 *   current clip
 * @since PECL cairo >= 0.1.0
 **/
function cairo_clip_rectangle_list($context){}

/**
 * Closes the current path
 *
 * Adds a line segment to the path from the current point to the
 * beginning of the current sub-path, (the most recent point passed to
 * CairoContext::moveTo), and closes this sub-path. After this call the
 * current point will be at the joined endpoint of the sub-path.
 *
 * The behavior of close_path() is distinct from simply calling
 * CairoContext::lineTo with the equivalent coordinate in the case of
 * stroking. When a closed sub-path is stroked, there are no caps on the
 * ends of the sub-path. Instead, there is a line join connecting the
 * final and initial segments of the sub-path.
 *
 * If there is no current point before the call to
 * CairoContext::closePath, this function will have no effect.
 *
 * @param CairoContext $context A valid CairoContext object created
 *   with CairoContext::__construct or {@link cairo_create}
 * @return void
 * @since PECL cairo >= 0.1.0
 **/
function cairo_close_path($context){}

/**
 * The copyPage purpose
 *
 * Emits the current page for backends that support multiple pages, but
 * doesn't clear it, so that the contents of the current page will be
 * retained for the next page. Use CairoSurface::showPage() if you want
 * to get an empty page after the emission.
 *
 * @param CairoContext $context A CairoContext object
 * @return void Description...
 * @since PECL cairo >= 0.1.0
 **/
function cairo_copy_page($context){}

/**
 * Creates a copy of the current path
 *
 * Creates a copy of the current path and returns it to the user as a
 * CairoPath. See CairoPath for hints on how to iterate over the returned
 * data structure.
 *
 * This function will always return a valid CairoPath object, but the
 * result will have no data, if either of the following conditions hold:
 * 1. If there is insufficient memory to copy the path. In this case
 * CairoPath->status will be set to CAIRO_STATUS_NO_MEMORY. 2. If {@link
 * context} is already in an error state. In this case CairoPath->status
 * will contain the same status that would be returned by {@link
 * cairo_status}.
 *
 * In either case, CairoPath->status will be set to
 * CAIRO_STATUS_NO_MEMORY (regardless of what the error status in cr
 * might have been).
 *
 * @param CairoContext $context A valid CairoContext object created
 *   with CairoContext::__construct or {@link cairo_create}
 * @return CairoPath A copy of the current CairoPath in the context
 * @since PECL cairo >= 0.1.0
 **/
function cairo_copy_path($context){}

/**
 * Gets a flattened copy of the current path
 *
 * Gets a flattened copy of the current path and returns it to the user
 * as a CairoPath.
 *
 * This function is like CairoContext::copyPath except that any curves in
 * the path will be approximated with piecewise-linear approximations,
 * (accurate to within the current tolerance value). That is, the result
 * is guaranteed to not have any elements of type CAIRO_PATH_CURVE_TO
 * which will instead be replaced by a series of CAIRO_PATH_LINE_TO
 * elements.
 *
 * @param CairoContext $context A CairoContext object
 * @return CairoPath A copy of the current path
 * @since PECL cairo >= 0.1.0
 **/
function cairo_copy_path_flat($context){}

/**
 * Returns a new CairoContext object on the requested surface
 *
 * @param CairoSurface $surface Description...
 * @return CairoContext What is returned on success and failure
 * @since PECL cairo >= 0.1.0
 **/
function cairo_create($surface){}

/**
 * Adds a curve
 *
 * Adds a cubic Bezier spline to the path from the current point to
 * position {@link x3} ,{@link y3} in user-space coordinates, using
 * {@link x1}, {@link y1} and {@link x2}, {@link y2} as the control
 * points. After this call the current point will be {@link x3}, {@link
 * y3}.
 *
 * If there is no current point before the call to CairoContext::curveTo
 * this function will behave as if preceded by a call to
 * CairoContext::moveTo ({@link x1}, {@link y1}).
 *
 * @param CairoContext $context A valid CairoContext object created
 *   with CairoContext::__construct or {@link cairo_create}
 * @param float $x1 First control point in the x axis for the curve
 * @param float $y1 First control point in the y axis for the curve
 * @param float $x2 Second control point in x axis for the curve
 * @param float $y2 Second control point in y axis for the curve
 * @param float $x3 Final point in the x axis for the curve
 * @param float $y3 Final point in the y axis for the curve
 * @return void
 * @since PECL cairo >= 0.1.0
 **/
function cairo_curve_to($context, $x1, $y1, $x2, $y2, $x3, $y3){}

/**
 * Transform a coordinate
 *
 * Transform a coordinate from device space to user space by multiplying
 * the given point by the inverse of the current transformation matrix
 * (CTM).
 *
 * @param CairoContext $context A valid CairoContext object created
 *   with CairoContext::__construct or {@link cairo_create}
 * @param float $x x value of the coordinate
 * @param float $y y value of the coordinate
 * @return array An array containing the x and y coordinates in the
 *   user-space
 * @since PECL cairo >= 0.1.0
 **/
function cairo_device_to_user($context, $x, $y){}

/**
 * Transform a distance
 *
 * Transform a distance vector from device space to user space. This
 * function is similar to CairoContext::deviceToUser or {@link
 * cairo_device_to_user} except that the translation components of the
 * inverse Cairo Transformation Matrix will be ignored when transforming
 * ({@link x},{@link y}).
 *
 * @param CairoContext $context A valid CairoContext object created
 *   with CairoContext::__construct or {@link cairo_create}
 * @param float $x X component of a distance vector
 * @param float $y Y component of a distance vector
 * @return array Returns an array with the x and y values of a distance
 *   vector in the user-space
 * @since PECL cairo >= 0.1.0
 **/
function cairo_device_to_user_distance($context, $x, $y){}

/**
 * Fills the current path
 *
 * A drawing operator that fills the current path according to the
 * current CairoFillRule, (each sub-path is implicitly closed before
 * being filled). After CairoContext::fill or {@link cairo_fill}, the
 * current path will be cleared from the CairoContext.
 *
 * @param CairoContext $context A valid CairoContext object created
 *   with CairoContext::__construct or {@link cairo_create}
 * @return void
 * @since PECL cairo >= 0.1.0
 **/
function cairo_fill($context){}

/**
 * Computes the filled area
 *
 * Computes a bounding box in user coordinates covering the area that
 * would be affected, (the “inked” area), by a CairoContext::fill
 * operation given the current path and fill parameters. If the current
 * path is empty, returns an empty rectangle (0,0,0,0). Surface
 * dimensions and clipping are not taken into account.
 *
 * Contrast with CairoContext::pathExtents, which is similar, but returns
 * non-zero extents for some paths with no inked area, (such as a simple
 * line segment).
 *
 * Note that CairoContext::fillExtents must necessarily do more work to
 * compute the precise inked areas in light of the fill rule, so
 * CairoContext::pathExtents may be more desirable for sake of
 * performance if the non-inked path extents are desired.
 *
 * @param CairoContext $context A valid CairoContext object created
 *   with CairoContext::__construct or {@link cairo_create}
 * @return array An array with the coordinates of the afected area
 * @since PECL cairo >= 0.1.0
 **/
function cairo_fill_extents($context){}

/**
 * Fills and preserve the current path
 *
 * A drawing operator that fills the current path according to the
 * current CairoFillRule, (each sub-path is implicitly closed before
 * being filled). Unlike CairoContext::fill, CairoContext::fillPreserve
 * (Procedural {@link cairo_fill}, {@link cairo_fill_preserve},
 * respectively) preserves the path within the Context.
 *
 * @param CairoContext $context A valid CairoContext object created
 *   with CairoContext::__construct or {@link cairo_create}
 * @return void
 * @since PECL cairo >= 0.1.0
 **/
function cairo_fill_preserve($context){}

/**
 * Get the font extents
 *
 * Gets the font extents for the currently selected font.
 *
 * @param CairoContext $context Description...
 * @return array An array containing the font extents for the current
 *   font.
 * @since PECL cairo >= 0.1.0
 **/
function cairo_font_extents($context){}

/**
 * Retrieves the font face type
 *
 * This function returns the type of the backend used to create a font
 * face. See CairoFontType class constants for available types.
 *
 * @param CairoFontFace $fontface
 * @return int A font type that can be any one defined in CairoFontType
 * @since PECL cairo >= 0.1.0
 **/
function cairo_font_face_get_type($fontface){}

/**
 * Check for CairoFontFace errors
 *
 * Checks whether an error has previously occurred for this font face
 *
 * @param CairoFontFace $fontface A valid CairoFontFace object
 * @return int CAIRO_STATUS_SUCCESS or another error such as
 *   CAIRO_STATUS_NO_MEMORY.
 * @since PECL cairo >= 0.1.0
 **/
function cairo_font_face_status($fontface){}

/**
 * @return CairoFontOptions What is returned on success and failure
 * @since PECL cairo >= 0.1.0
 **/
function cairo_font_options_create(){}

/**
 * @param CairoFontOptions $options Description...
 * @param CairoFontOptions $other Description...
 * @return bool What is returned on success and failure
 * @since PECL cairo >= 0.1.0
 **/
function cairo_font_options_equal($options, $other){}

/**
 * @param CairoFontOptions $options Description...
 * @return int What is returned on success and failure
 * @since PECL cairo >= 0.1.0
 **/
function cairo_font_options_get_antialias($options){}

/**
 * @param CairoFontOptions $options Description...
 * @return int What is returned on success and failure
 * @since PECL cairo >= 0.1.0
 **/
function cairo_font_options_get_hint_metrics($options){}

/**
 * @param CairoFontOptions $options Description...
 * @return int What is returned on success and failure
 * @since PECL cairo >= 0.1.0
 **/
function cairo_font_options_get_hint_style($options){}

/**
 * @param CairoFontOptions $options Description...
 * @return int What is returned on success and failure
 * @since PECL cairo >= 0.1.0
 **/
function cairo_font_options_get_subpixel_order($options){}

/**
 * @param CairoFontOptions $options Description...
 * @return int What is returned on success and failure
 * @since PECL cairo >= 0.1.0
 **/
function cairo_font_options_hash($options){}

/**
 * @param CairoFontOptions $options Description...
 * @param CairoFontOptions $other Description...
 * @return void What is returned on success and failure
 * @since PECL cairo >= 0.1.0
 **/
function cairo_font_options_merge($options, $other){}

/**
 * @param CairoFontOptions $options Description...
 * @param int $antialias Description...
 * @return void What is returned on success and failure
 * @since PECL cairo >= 0.1.0
 **/
function cairo_font_options_set_antialias($options, $antialias){}

/**
 * @param CairoFontOptions $options Description...
 * @param int $hint_metrics Description...
 * @return void What is returned on success and failure
 * @since PECL cairo >= 0.1.0
 **/
function cairo_font_options_set_hint_metrics($options, $hint_metrics){}

/**
 * @param CairoFontOptions $options Description...
 * @param int $hint_style Description...
 * @return void What is returned on success and failure
 * @since PECL cairo >= 0.1.0
 **/
function cairo_font_options_set_hint_style($options, $hint_style){}

/**
 * @param CairoFontOptions $options Description...
 * @param int $subpixel_order Description...
 * @return void What is returned on success and failure
 * @since PECL cairo >= 0.1.0
 **/
function cairo_font_options_set_subpixel_order($options, $subpixel_order){}

/**
 * @param CairoFontOptions $options Description...
 * @return int What is returned on success and failure
 * @since PECL cairo >= 0.1.0
 **/
function cairo_font_options_status($options){}

/**
 * @param int $format Description...
 * @param int $width Description...
 * @return int What is returned on success and failure
 * @since PECL cairo >= 0.1.0
 **/
function cairo_format_stride_for_width($format, $width){}

/**
 * The getAntialias purpose
 *
 * @param CairoContext $context Description...
 * @return int Description...
 * @since PECL cairo >= 0.1.0
 **/
function cairo_get_antialias($context){}

/**
 * The getCurrentPoint purpose
 *
 * Gets the current point of the current path, which is conceptually the
 * final point reached by the path so far.
 *
 * The current point is returned in the user-space coordinate system. If
 * there is no defined current point or if cr is in an error status, x
 * and y will both be set to 0.0. It is possible to check this in advance
 * with CairoContext::hasCurrentPoint.
 *
 * Most path construction functions alter the current point. See the
 * following for details on how they affect the current point:
 * CairoContext::newPath, CairoContext::newSubPath,
 * CairoContext::appendPath, CairoContext::closePath,
 * CairoContext::moveTo, CairoContext::lineTo, CairoContext::curveTo,
 * CairoContext::relMoveTo, CairoContext::relLineTo,
 * CairoContext::relCurveTo, CairoContext::arc,
 * CairoContext::arcNegative, CairoContext::rectangle,
 * CairoContext::textPath, CairoContext::glyphPath.
 *
 * Some functions use and alter the current point but do not otherwise
 * change current path: CairoContext::showText.
 *
 * Some functions unset the current path and as a result, current point:
 * CairoContext::fill, CairoContext::stroke.
 *
 * @param CairoContext $context A valid CairoContext object.
 * @return array An array containing the x (index 0) and y (index 1)
 *   coordinates of the current point.
 * @since PECL cairo >= 0.1.0
 **/
function cairo_get_current_point($context){}

/**
 * The getDash purpose
 *
 * @param CairoContext $context Description...
 * @return array Description...
 * @since PECL cairo >= 0.1.0
 **/
function cairo_get_dash($context){}

/**
 * The getDashCount purpose
 *
 * @param CairoContext $context Description...
 * @return int Description...
 * @since PECL cairo >= 0.1.0
 **/
function cairo_get_dash_count($context){}

/**
 * The getFillRule purpose
 *
 * @param CairoContext $context Description...
 * @return int Description...
 * @since PECL cairo >= 0.1.0
 **/
function cairo_get_fill_rule($context){}

/**
 * The getFontFace purpose
 *
 * @param CairoContext $context Description...
 * @return void Description...
 * @since PECL cairo >= 0.1.0
 **/
function cairo_get_font_face($context){}

/**
 * The getFontMatrix purpose
 *
 * @param CairoContext $context Description...
 * @return void Description...
 * @since PECL cairo >= 0.1.0
 **/
function cairo_get_font_matrix($context){}

/**
 * The getFontOptions purpose
 *
 * @param CairoContext $context Description...
 * @return void Description...
 * @since PECL cairo >= 0.1.0
 **/
function cairo_get_font_options($context){}

/**
 * The getGroupTarget purpose
 *
 * @param CairoContext $context Description...
 * @return void Description...
 * @since PECL cairo >= 0.1.0
 **/
function cairo_get_group_target($context){}

/**
 * The getLineCap purpose
 *
 * @param CairoContext $context Description...
 * @return int Description...
 * @since PECL cairo >= 0.1.0
 **/
function cairo_get_line_cap($context){}

/**
 * The getLineJoin purpose
 *
 * @param CairoContext $context Description...
 * @return int Description...
 * @since PECL cairo >= 0.1.0
 **/
function cairo_get_line_join($context){}

/**
 * The getLineWidth purpose
 *
 * @param CairoContext $context Description...
 * @return float Description...
 * @since PECL cairo >= 0.1.0
 **/
function cairo_get_line_width($context){}

/**
 * The getMatrix purpose
 *
 * @param CairoContext $context Description...
 * @return void Description...
 * @since PECL cairo >= 0.1.0
 **/
function cairo_get_matrix($context){}

/**
 * The getMiterLimit purpose
 *
 * @param CairoContext $context Description...
 * @return float Description...
 * @since PECL cairo >= 0.1.0
 **/
function cairo_get_miter_limit($context){}

/**
 * The getOperator purpose
 *
 * @param CairoContext $context Description...
 * @return int Description...
 * @since PECL cairo >= 0.1.0
 **/
function cairo_get_operator($context){}

/**
 * The getScaledFont purpose
 *
 * @param CairoContext $context Description...
 * @return void Description...
 * @since PECL cairo >= 0.1.0
 **/
function cairo_get_scaled_font($context){}

/**
 * The getSource purpose
 *
 * @param CairoContext $context Description...
 * @return void Description...
 * @since PECL cairo >= 0.1.0
 **/
function cairo_get_source($context){}

/**
 * The getTarget purpose
 *
 * @param CairoContext $context Description...
 * @return void Description...
 * @since PECL cairo >= 0.1.0
 **/
function cairo_get_target($context){}

/**
 * The getTolerance purpose
 *
 * @param CairoContext $context Description...
 * @return float Description...
 * @since PECL cairo >= 0.1.0
 **/
function cairo_get_tolerance($context){}

/**
 * The glyphPath purpose
 *
 * Adds closed paths for the glyphs to the current path. The generated
 * path if filled, achieves an effect similar to that of
 * CairoContext::showGlyphs.
 *
 * @param CairoContext $context A CairoContext object
 * @param array $glyphs Array of glyphs
 * @return void
 * @since PECL cairo >= 0.1.0
 **/
function cairo_glyph_path($context, $glyphs){}

/**
 * The hasCurrentPoint purpose
 *
 * Returns whether a current point is defined on the current path. See
 * CairoContext::getCurrentPoint for details on the current point.
 *
 * @param CairoContext $context A valid CairoContext object.
 * @return bool Whether a current point is defined
 * @since PECL cairo >= 0.1.0
 **/
function cairo_has_current_point($context){}

/**
 * The identityMatrix purpose
 *
 * @param CairoContext $context Description...
 * @return void Description...
 * @since PECL cairo >= 0.1.0
 **/
function cairo_identity_matrix($context){}

/**
 * @param int $format Description...
 * @param int $width Description...
 * @param int $height Description...
 * @return CairoImageSurface What is returned on success and failure
 * @since PECL cairo >= 0.1.0
 **/
function cairo_image_surface_create($format, $width, $height){}

/**
 * @param string $data Description...
 * @param int $format Description...
 * @param int $width Description...
 * @param int $height Description...
 * @param int $stride Description...
 * @return CairoImageSurface What is returned on success and failure
 * @since PECL cairo >= 0.1.0
 **/
function cairo_image_surface_create_for_data($data, $format, $width, $height, $stride){}

/**
 * @param mixed $file Description...
 * @return CairoImageSurface What is returned on success and failure
 * @since PECL cairo >= 0.1.0
 **/
function cairo_image_surface_create_from_png($file){}

/**
 * @param CairoImageSurface $surface Description...
 * @return string What is returned on success and failure
 * @since PECL cairo >= 0.1.0
 **/
function cairo_image_surface_get_data($surface){}

/**
 * @param CairoImageSurface $surface Description...
 * @return int What is returned on success and failure
 * @since PECL cairo >= 0.1.0
 **/
function cairo_image_surface_get_format($surface){}

/**
 * @param CairoImageSurface $surface Description...
 * @return int What is returned on success and failure
 * @since PECL cairo >= 0.1.0
 **/
function cairo_image_surface_get_height($surface){}

/**
 * @param CairoImageSurface $surface Description...
 * @return int What is returned on success and failure
 * @since PECL cairo >= 0.1.0
 **/
function cairo_image_surface_get_stride($surface){}

/**
 * @param CairoImageSurface $surface Description...
 * @return int What is returned on success and failure
 * @since PECL cairo >= 0.1.0
 **/
function cairo_image_surface_get_width($surface){}

/**
 * The inFill purpose
 *
 * @param CairoContext $context Description...
 * @param float $x Description...
 * @param float $y Description...
 * @return bool Description...
 * @since PECL cairo >= 0.1.0
 **/
function cairo_in_fill($context, $x, $y){}

/**
 * The inStroke purpose
 *
 * @param CairoContext $context Description...
 * @param float $x Description...
 * @param float $y Description...
 * @return bool Description...
 * @since PECL cairo >= 0.1.0
 **/
function cairo_in_stroke($context, $x, $y){}

/**
 * The lineTo purpose
 *
 * @param CairoContext $context Description...
 * @param float $x Description...
 * @param float $y Description...
 * @return void Description...
 * @since PECL cairo >= 0.1.0
 **/
function cairo_line_to($context, $x, $y){}

/**
 * The mask purpose
 *
 * @param CairoContext $context Description...
 * @param CairoPattern $pattern Description...
 * @return void Description...
 * @since PECL cairo >= 0.1.0
 **/
function cairo_mask($context, $pattern){}

/**
 * The maskSurface purpose
 *
 * @param CairoContext $context Description...
 * @param CairoSurface $surface Description...
 * @param float $x Description...
 * @param float $y Description...
 * @return void Description...
 * @since PECL cairo >= 0.1.0
 **/
function cairo_mask_surface($context, $surface, $x, $y){}

/**
 * Creates a new scaling matrix
 *
 * Creates a new matrix to a transformation that scales by sx and sy in
 * the X and Y dimensions, respectively.
 *
 * @param float $sx scale factor in the X direction
 * @param float $sy scale factor in the Y direction
 * @return void Returns a new CairoMatrix object that can be used with
 *   surfaces, contexts, and patterns.
 * @since PECL cairo >= 0.1.0
 **/
function cairo_matrix_create_scale($sx, $sy){}

/**
 * Creates a new translation matrix
 *
 * Creates a new matrix to a transformation that translates by tx and ty
 * in the X and Y dimensions, respectively.
 *
 * @param float $tx amount to translate in the X direction
 * @param float $ty amount to translate in the Y direction
 * @return void Returns a new CairoMatrix object that can be used with
 *   surfaces, contexts, and patterns.
 * @since PECL cairo >= 0.1.0
 **/
function cairo_matrix_create_translate($tx, $ty){}

/**
 * Creates a new CairoMatrix object
 *
 * Returns new CairoMatrix object. Matrices are used throughout cairo to
 * convert between different coordinate spaces. Sets matrix to be the
 * affine transformation given by xx, yx, xy, yy, x0, y0. The
 * transformation is given by: x_new = xx * x + xy * y + x0; and y_new =
 * yx * x + yy * y + y0;
 *
 * @param float $xx xx component of the affine transformation
 * @param float $yx yx component of the affine transformation
 * @param float $xy xy component of the affine transformation
 * @param float $yy yy component of the affine transformation
 * @param float $x0 X translation component of the affine
 *   transformation
 * @param float $y0 Y translation component of the affine
 *   transformation
 * @return object Returns a new CairoMatrix object that can be used
 *   with surfaces, contexts, and patterns.
 **/
function cairo_matrix_init($xx, $yx, $xy, $yy, $x0, $y0){}

/**
 * Creates a new identity matrix
 *
 * Creates a new matrix that is an identity transformation. An identity
 * transformation means the source data is copied into the destination
 * data without change
 *
 * @return object Returns a new CairoMatrix object that can be used
 *   with surfaces, contexts, and patterns.
 **/
function cairo_matrix_init_identity(){}

/**
 * Creates a new rotated matrix
 *
 * Creates a new matrix to a transformation that rotates by radians
 * provided
 *
 * @param float $radians angle of rotation, in radians. The direction
 *   of rotation is defined such that positive angles rotate in the
 *   direction from the positive X axis toward the positive Y axis. With
 *   the default axis orientation of cairo, positive angles rotate in a
 *   clockwise direction.
 * @return object Returns a new CairoMatrix object that can be used
 *   with surfaces, contexts, and patterns.
 **/
function cairo_matrix_init_rotate($radians){}

/**
 * Creates a new scaling matrix
 *
 * Creates a new matrix to a transformation that scales by sx and sy in
 * the X and Y dimensions, respectively.
 *
 * @param float $sx scale factor in the X direction
 * @param float $sy scale factor in the Y direction
 * @return object Returns a new CairoMatrix object that can be used
 *   with surfaces, contexts, and patterns.
 **/
function cairo_matrix_init_scale($sx, $sy){}

/**
 * Creates a new translation matrix
 *
 * Creates a new matrix to a transformation that translates by tx and ty
 * in the X and Y dimensions, respectively.
 *
 * @param float $tx amount to translate in the X direction
 * @param float $ty amount to translate in the Y direction
 * @return object Returns a new CairoMatrix object that can be used
 *   with surfaces, contexts, and patterns.
 **/
function cairo_matrix_init_translate($tx, $ty){}

/**
 * @param CairoMatrix $matrix Description...
 * @return void What is returned on success and failure
 * @since PECL cairo >= 0.1.0
 **/
function cairo_matrix_invert($matrix){}

/**
 * @param CairoMatrix $matrix1 Description...
 * @param CairoMatrix $matrix2 Description...
 * @return CairoMatrix What is returned on success and failure
 * @since PECL cairo >= 0.1.0
 **/
function cairo_matrix_multiply($matrix1, $matrix2){}

/**
 * The rotate purpose
 *
 * @param CairoContext $context Description...
 * @param string $radians Description...
 * @return void Description...
 * @since PECL cairo >= 0.1.0
 **/
function cairo_matrix_rotate($context, $radians){}

/**
 * Applies scaling to a matrix
 *
 * Applies scaling by sx, sy to the transformation in the matrix. The
 * effect of the new transformation is to first scale the coordinates by
 * sx and sy, then apply the original transformation to the coordinates.
 *
 * @param CairoContext $context Procedural only - CairoMatrix instance
 * @param float $sx scale factor in the X direction
 * @param float $sy scale factor in the Y direction
 * @return void
 * @since PECL cairo >= 0.1.0
 **/
function cairo_matrix_scale($context, $sx, $sy){}

/**
 * @param CairoMatrix $matrix Description...
 * @param float $dx Description...
 * @param float $dy Description...
 * @return array What is returned on success and failure
 * @since PECL cairo >= 0.1.0
 **/
function cairo_matrix_transform_distance($matrix, $dx, $dy){}

/**
 * @param CairoMatrix $matrix Description...
 * @param float $dx Description...
 * @param float $dy Description...
 * @return array What is returned on success and failure
 * @since PECL cairo >= 0.1.0
 **/
function cairo_matrix_transform_point($matrix, $dx, $dy){}

/**
 * @param CairoMatrix $matrix Description...
 * @param float $tx Description...
 * @param float $ty Description...
 * @return void What is returned on success and failure
 * @since PECL cairo >= 0.1.0
 **/
function cairo_matrix_translate($matrix, $tx, $ty){}

/**
 * The moveTo purpose
 *
 * Begin a new sub-path. After this call the current point will be (x,
 * y).
 *
 * @param CairoContext $context A valid CairoContext object.
 * @param float $x The x coordinate of the new position.
 * @param float $y The y coordinate of the new position
 * @return void
 * @since PECL cairo >= 0.1.0
 **/
function cairo_move_to($context, $x, $y){}

/**
 * The newPath purpose
 *
 * Clears the current path. After this call there will be no path and no
 * current point.
 *
 * @param CairoContext $context A valid CairoContext object.
 * @return void
 * @since PECL cairo >= 0.1.0
 **/
function cairo_new_path($context){}

/**
 * The newSubPath purpose
 *
 * @param CairoContext $context Description...
 * @return void Description...
 * @since PECL cairo >= 0.1.0
 **/
function cairo_new_sub_path($context){}

/**
 * The paint purpose
 *
 * @param CairoContext $context Description...
 * @return void Description...
 * @since PECL cairo >= 0.1.0
 **/
function cairo_paint($context){}

/**
 * The paintWithAlpha purpose
 *
 * @param CairoContext $context Description...
 * @param float $alpha Description...
 * @return void Description...
 * @since PECL cairo >= 0.1.0
 **/
function cairo_paint_with_alpha($context, $alpha){}

/**
 * The pathExtents purpose
 *
 * @param CairoContext $context Description...
 * @return array Description...
 * @since PECL cairo >= 0.1.0
 **/
function cairo_path_extents($context){}

/**
 * @param CairoGradientPattern $pattern Description...
 * @param float $offset Description...
 * @param float $red Description...
 * @param float $green Description...
 * @param float $blue Description...
 * @return void What is returned on success and failure
 * @since PECL cairo >= 0.1.0
 **/
function cairo_pattern_add_color_stop_rgb($pattern, $offset, $red, $green, $blue){}

/**
 * @param CairoGradientPattern $pattern Description...
 * @param float $offset Description...
 * @param float $red Description...
 * @param float $green Description...
 * @param float $blue Description...
 * @param float $alpha Description...
 * @return void What is returned on success and failure
 * @since PECL cairo >= 0.1.0
 **/
function cairo_pattern_add_color_stop_rgba($pattern, $offset, $red, $green, $blue, $alpha){}

/**
 * @param CairoSurface $surface Description...
 * @return CairoPattern What is returned on success and failure
 * @since PECL cairo >= 0.1.0
 **/
function cairo_pattern_create_for_surface($surface){}

/**
 * @param float $x0 Description...
 * @param float $y0 Description...
 * @param float $x1 Description...
 * @param float $y1 Description...
 * @return CairoPattern What is returned on success and failure
 * @since PECL cairo >= 0.1.0
 **/
function cairo_pattern_create_linear($x0, $y0, $x1, $y1){}

/**
 * @param float $x0 Description...
 * @param float $y0 Description...
 * @param float $r0 Description...
 * @param float $x1 Description...
 * @param float $y1 Description...
 * @param float $r1 Description...
 * @return CairoPattern What is returned on success and failure
 * @since PECL cairo >= 0.1.0
 **/
function cairo_pattern_create_radial($x0, $y0, $r0, $x1, $y1, $r1){}

/**
 * @param float $red Description...
 * @param float $green Description...
 * @param float $blue Description...
 * @return CairoPattern What is returned on success and failure
 * @since PECL cairo >= 0.1.0
 **/
function cairo_pattern_create_rgb($red, $green, $blue){}

/**
 * @param float $red Description...
 * @param float $green Description...
 * @param float $blue Description...
 * @param float $alpha Description...
 * @return CairoPattern What is returned on success and failure
 * @since PECL cairo >= 0.1.0
 **/
function cairo_pattern_create_rgba($red, $green, $blue, $alpha){}

/**
 * @param CairoGradientPattern $pattern Description...
 * @return int What is returned on success and failure
 * @since PECL cairo >= 0.1.0
 **/
function cairo_pattern_get_color_stop_count($pattern){}

/**
 * @param CairoGradientPattern $pattern Description...
 * @param int $index Description...
 * @return array What is returned on success and failure
 * @since PECL cairo >= 0.1.0
 **/
function cairo_pattern_get_color_stop_rgba($pattern, $index){}

/**
 * @param string $pattern Description...
 * @return int What is returned on success and failure
 * @since PECL cairo >= 0.1.0
 **/
function cairo_pattern_get_extend($pattern){}

/**
 * @param CairoSurfacePattern $pattern Description...
 * @return int What is returned on success and failure
 * @since PECL cairo >= 0.1.0
 **/
function cairo_pattern_get_filter($pattern){}

/**
 * @param CairoLinearGradient $pattern Description...
 * @return array What is returned on success and failure
 * @since PECL cairo >= 0.1.0
 **/
function cairo_pattern_get_linear_points($pattern){}

/**
 * @param CairoPattern $pattern Description...
 * @return CairoMatrix What is returned on success and failure
 * @since PECL cairo >= 0.1.0
 **/
function cairo_pattern_get_matrix($pattern){}

/**
 * @param CairoRadialGradient $pattern Description...
 * @return array What is returned on success and failure
 * @since PECL cairo >= 0.1.0
 **/
function cairo_pattern_get_radial_circles($pattern){}

/**
 * @param CairoSolidPattern $pattern Description...
 * @return array What is returned on success and failure
 * @since PECL cairo >= 0.1.0
 **/
function cairo_pattern_get_rgba($pattern){}

/**
 * @param CairoSurfacePattern $pattern Description...
 * @return CairoSurface What is returned on success and failure
 * @since PECL cairo >= 0.1.0
 **/
function cairo_pattern_get_surface($pattern){}

/**
 * @param CairoPattern $pattern Description...
 * @return int What is returned on success and failure
 * @since PECL cairo >= 0.1.0
 **/
function cairo_pattern_get_type($pattern){}

/**
 * @param string $pattern Description...
 * @param string $extend Description...
 * @return void What is returned on success and failure
 * @since PECL cairo >= 0.1.0
 **/
function cairo_pattern_set_extend($pattern, $extend){}

/**
 * @param CairoSurfacePattern $pattern Description...
 * @param int $filter Description...
 * @return void What is returned on success and failure
 * @since PECL cairo >= 0.1.0
 **/
function cairo_pattern_set_filter($pattern, $filter){}

/**
 * @param CairoPattern $pattern Description...
 * @param CairoMatrix $matrix Description...
 * @return void What is returned on success and failure
 * @since PECL cairo >= 0.1.0
 **/
function cairo_pattern_set_matrix($pattern, $matrix){}

/**
 * @param CairoPattern $pattern Description...
 * @return int What is returned on success and failure
 * @since PECL cairo >= 0.1.0
 **/
function cairo_pattern_status($pattern){}

/**
 * @param string $file Description...
 * @param float $width Description...
 * @param float $height Description...
 * @return CairoPdfSurface What is returned on success and failure
 * @since PECL cairo >= 0.1.0
 **/
function cairo_pdf_surface_create($file, $width, $height){}

/**
 * @param CairoPdfSurface $surface Description...
 * @param float $width Description...
 * @param float $height Description...
 * @return void What is returned on success and failure
 * @since PECL cairo >= 0.1.0
 **/
function cairo_pdf_surface_set_size($surface, $width, $height){}

/**
 * The popGroup purpose
 *
 * @param CairoContext $context Description...
 * @return void Description...
 * @since PECL cairo >= 0.1.0
 **/
function cairo_pop_group($context){}

/**
 * The popGroupToSource purpose
 *
 * @param CairoContext $context Description...
 * @return void Description...
 * @since PECL cairo >= 0.1.0
 **/
function cairo_pop_group_to_source($context){}

/**
 * @return array What is returned on success and failure
 * @since PECL cairo >= 0.1.0
 **/
function cairo_ps_get_levels(){}

/**
 * @param int $level Description...
 * @return string What is returned on success and failure
 * @since PECL cairo >= 0.1.0
 **/
function cairo_ps_level_to_string($level){}

/**
 * @param string $file Description...
 * @param float $width Description...
 * @param float $height Description...
 * @return CairoPsSurface What is returned on success and failure
 * @since PECL cairo >= 0.1.0
 **/
function cairo_ps_surface_create($file, $width, $height){}

/**
 * @param CairoPsSurface $surface Description...
 * @return void What is returned on success and failure
 * @since PECL cairo >= 0.1.0
 **/
function cairo_ps_surface_dsc_begin_page_setup($surface){}

/**
 * @param CairoPsSurface $surface Description...
 * @return void What is returned on success and failure
 * @since PECL cairo >= 0.1.0
 **/
function cairo_ps_surface_dsc_begin_setup($surface){}

/**
 * @param CairoPsSurface $surface Description...
 * @param string $comment Description...
 * @return void What is returned on success and failure
 * @since PECL cairo >= 0.1.0
 **/
function cairo_ps_surface_dsc_comment($surface, $comment){}

/**
 * @param CairoPsSurface $surface Description...
 * @return bool What is returned on success and failure
 * @since PECL cairo >= 0.1.0
 **/
function cairo_ps_surface_get_eps($surface){}

/**
 * @param CairoPsSurface $surface Description...
 * @param int $level Description...
 * @return void What is returned on success and failure
 * @since PECL cairo >= 0.1.0
 **/
function cairo_ps_surface_restrict_to_level($surface, $level){}

/**
 * @param CairoPsSurface $surface Description...
 * @param bool $level Description...
 * @return void What is returned on success and failure
 * @since PECL cairo >= 0.1.0
 **/
function cairo_ps_surface_set_eps($surface, $level){}

/**
 * @param CairoPsSurface $surface Description...
 * @param float $width Description...
 * @param float $height Description...
 * @return void What is returned on success and failure
 * @since PECL cairo >= 0.1.0
 **/
function cairo_ps_surface_set_size($surface, $width, $height){}

/**
 * The pushGroup purpose
 *
 * @param CairoContext $context Description...
 * @return void Description...
 * @since PECL cairo >= 0.1.0
 **/
function cairo_push_group($context){}

/**
 * The pushGroupWithContent purpose
 *
 * @param CairoContext $context Description...
 * @param int $content Description...
 * @return void Description...
 * @since PECL cairo >= 0.1.0
 **/
function cairo_push_group_with_content($context, $content){}

/**
 * The rectangle purpose
 *
 * @param CairoContext $context Description...
 * @param float $x Description...
 * @param float $y Description...
 * @param float $width Description...
 * @param float $height Description...
 * @return void Description...
 * @since PECL cairo >= 0.1.0
 **/
function cairo_rectangle($context, $x, $y, $width, $height){}

/**
 * The relCurveTo purpose
 *
 * @param CairoContext $context Description...
 * @param float $x1 Description...
 * @param float $y1 Description...
 * @param float $x2 Description...
 * @param float $y2 Description...
 * @param float $x3 Description...
 * @param float $y3 Description...
 * @return void Description...
 * @since PECL cairo >= 0.1.0
 **/
function cairo_rel_curve_to($context, $x1, $y1, $x2, $y2, $x3, $y3){}

/**
 * The relLineTo purpose
 *
 * @param CairoContext $context Description...
 * @param float $x Description...
 * @param float $y Description...
 * @return void Description...
 * @since PECL cairo >= 0.1.0
 **/
function cairo_rel_line_to($context, $x, $y){}

/**
 * The relMoveTo purpose
 *
 * @param CairoContext $context Description...
 * @param float $x Description...
 * @param float $y Description...
 * @return void Description...
 * @since PECL cairo >= 0.1.0
 **/
function cairo_rel_move_to($context, $x, $y){}

/**
 * The resetClip purpose
 *
 * @param CairoContext $context Description...
 * @return void Description...
 * @since PECL cairo >= 0.1.0
 **/
function cairo_reset_clip($context){}

/**
 * The restore purpose
 *
 * @param CairoContext $context Description...
 * @return void Description...
 * @since PECL cairo >= 0.1.0
 **/
function cairo_restore($context){}

/**
 * The rotate purpose
 *
 * @param CairoContext $context Description...
 * @param float $angle Description...
 * @return void Description...
 * @since PECL cairo >= 0.1.0
 **/
function cairo_rotate($context, $angle){}

/**
 * The save purpose
 *
 * @param CairoContext $context Description...
 * @return void Description...
 * @since PECL cairo >= 0.1.0
 **/
function cairo_save($context){}

/**
 * The scale purpose
 *
 * @param CairoContext $context Description...
 * @param float $x Description...
 * @param float $y Description...
 * @return void Description...
 * @since PECL cairo >= 0.1.0
 **/
function cairo_scale($context, $x, $y){}

/**
 * @param CairoFontFace $fontface Description...
 * @param CairoMatrix $matrix Description...
 * @param CairoMatrix $ctm Description...
 * @param CairoFontOptions $fontoptions Description...
 * @return CairoScaledFont What is returned on success and failure
 * @since PECL cairo >= 0.1.0
 **/
function cairo_scaled_font_create($fontface, $matrix, $ctm, $fontoptions){}

/**
 * @param CairoScaledFont $scaledfont Description...
 * @return array What is returned on success and failure
 * @since PECL cairo >= 0.1.0
 **/
function cairo_scaled_font_extents($scaledfont){}

/**
 * @param CairoScaledFont $scaledfont Description...
 * @return CairoMatrix What is returned on success and failure
 * @since PECL cairo >= 0.1.0
 **/
function cairo_scaled_font_get_ctm($scaledfont){}

/**
 * @param CairoScaledFont $scaledfont Description...
 * @return CairoFontFace What is returned on success and failure
 * @since PECL cairo >= 0.1.0
 **/
function cairo_scaled_font_get_font_face($scaledfont){}

/**
 * @param CairoScaledFont $scaledfont Description...
 * @return CairoFontOptions What is returned on success and failure
 * @since PECL cairo >= 0.1.0
 **/
function cairo_scaled_font_get_font_matrix($scaledfont){}

/**
 * @param CairoScaledFont $scaledfont Description...
 * @return CairoFontOptions What is returned on success and failure
 * @since PECL cairo >= 0.1.0
 **/
function cairo_scaled_font_get_font_options($scaledfont){}

/**
 * @param CairoScaledFont $scaledfont Description...
 * @return CairoMatrix What is returned on success and failure
 * @since PECL cairo >= 0.1.0
 **/
function cairo_scaled_font_get_scale_matrix($scaledfont){}

/**
 * @param CairoScaledFont $scaledfont Description...
 * @return int What is returned on success and failure
 * @since PECL cairo >= 0.1.0
 **/
function cairo_scaled_font_get_type($scaledfont){}

/**
 * @param CairoScaledFont $scaledfont Description...
 * @param array $glyphs Description...
 * @return array What is returned on success and failure
 * @since PECL cairo >= 0.1.0
 **/
function cairo_scaled_font_glyph_extents($scaledfont, $glyphs){}

/**
 * @param CairoScaledFont $scaledfont Description...
 * @return int What is returned on success and failure
 * @since PECL cairo >= 0.1.0
 **/
function cairo_scaled_font_status($scaledfont){}

/**
 * @param CairoScaledFont $scaledfont Description...
 * @param string $text Description...
 * @return array What is returned on success and failure
 * @since PECL cairo >= 0.1.0
 **/
function cairo_scaled_font_text_extents($scaledfont, $text){}

/**
 * The selectFontFace purpose
 *
 * @param CairoContext $context Description...
 * @param string $family Description...
 * @param int $slant Description...
 * @param int $weight Description...
 * @return void Description...
 * @since PECL cairo >= 0.1.0
 **/
function cairo_select_font_face($context, $family, $slant, $weight){}

/**
 * The setAntialias purpose
 *
 * @param CairoContext $context Description...
 * @param int $antialias Description...
 * @return void Description...
 * @since PECL cairo >= 0.1.0
 **/
function cairo_set_antialias($context, $antialias){}

/**
 * The setDash purpose
 *
 * @param CairoContext $context Description...
 * @param array $dashes Description...
 * @param float $offset Description...
 * @return void Description...
 * @since PECL cairo >= 0.1.0
 **/
function cairo_set_dash($context, $dashes, $offset){}

/**
 * The setFillRule purpose
 *
 * @param CairoContext $context Description...
 * @param int $setting Description...
 * @return void Description...
 * @since PECL cairo >= 0.1.0
 **/
function cairo_set_fill_rule($context, $setting){}

/**
 * The setFontFace purpose
 *
 * Sets the font-face for a given context.
 *
 * @param CairoContext $context A CairoContext object to change the
 *   font-face for.
 * @param CairoFontFace $fontface A CairoFontFace object
 * @return void No value is returned
 * @since PECL cairo >= 0.1.0
 **/
function cairo_set_font_face($context, $fontface){}

/**
 * The setFontMatrix purpose
 *
 * @param CairoContext $context Description...
 * @param CairoMatrix $matrix Description...
 * @return void Description...
 * @since PECL cairo >= 0.1.0
 **/
function cairo_set_font_matrix($context, $matrix){}

/**
 * The setFontOptions purpose
 *
 * @param CairoContext $context Description...
 * @param CairoFontOptions $fontoptions Description...
 * @return void Description...
 * @since PECL cairo >= 0.1.0
 **/
function cairo_set_font_options($context, $fontoptions){}

/**
 * The setFontSize purpose
 *
 * @param CairoContext $context Description...
 * @param float $size Description...
 * @return void Description...
 * @since PECL cairo >= 0.1.0
 **/
function cairo_set_font_size($context, $size){}

/**
 * The setLineCap purpose
 *
 * @param CairoContext $context Description...
 * @param int $setting Description...
 * @return void Description...
 * @since PECL cairo >= 0.1.0
 **/
function cairo_set_line_cap($context, $setting){}

/**
 * The setLineJoin purpose
 *
 * @param CairoContext $context Description...
 * @param int $setting Description...
 * @return void Description...
 * @since PECL cairo >= 0.1.0
 **/
function cairo_set_line_join($context, $setting){}

/**
 * The setLineWidth purpose
 *
 * @param CairoContext $context Description...
 * @param float $width Description...
 * @return void Description...
 * @since PECL cairo >= 0.1.0
 **/
function cairo_set_line_width($context, $width){}

/**
 * The setMatrix purpose
 *
 * @param CairoContext $context Description...
 * @param CairoMatrix $matrix Description...
 * @return void Description...
 * @since PECL cairo >= 0.1.0
 **/
function cairo_set_matrix($context, $matrix){}

/**
 * The setMiterLimit purpose
 *
 * @param CairoContext $context Description...
 * @param float $limit Description...
 * @return void Description...
 * @since PECL cairo >= 0.1.0
 **/
function cairo_set_miter_limit($context, $limit){}

/**
 * The setOperator purpose
 *
 * @param CairoContext $context Description...
 * @param int $setting Description...
 * @return void Description...
 * @since PECL cairo >= 0.1.0
 **/
function cairo_set_operator($context, $setting){}

/**
 * The setScaledFont purpose
 *
 * @param CairoContext $context Description...
 * @param CairoScaledFont $scaledfont Description...
 * @return void Description...
 * @since PECL cairo >= 0.1.0
 **/
function cairo_set_scaled_font($context, $scaledfont){}

/**
 * The setSourceRGB purpose
 *
 * @param CairoContext $context Description...
 * @param float $red Description...
 * @param float $green Description...
 * @param float $blue Description...
 * @return void Description...
 * @since PECL cairo >= 0.1.0
 **/
function cairo_set_source($context, $red, $green, $blue){}

/**
 * The setSourceSurface purpose
 *
 * @param CairoContext $context Description...
 * @param CairoSurface $surface Description...
 * @param float $x Description...
 * @param float $y Description...
 * @return void Description...
 * @since PECL cairo >= 0.1.0
 **/
function cairo_set_source_surface($context, $surface, $x, $y){}

/**
 * The setTolerance purpose
 *
 * @param CairoContext $context Description...
 * @param float $tolerance Description...
 * @return void Description...
 * @since PECL cairo >= 0.1.0
 **/
function cairo_set_tolerance($context, $tolerance){}

/**
 * The showPage purpose
 *
 * @param CairoContext $context Description...
 * @return void Description...
 * @since PECL cairo >= 0.1.0
 **/
function cairo_show_page($context){}

/**
 * The showText purpose
 *
 * @param CairoContext $context Description...
 * @param string $text Description...
 * @return void Description...
 * @since PECL cairo >= 0.1.0
 **/
function cairo_show_text($context, $text){}

/**
 * The status purpose
 *
 * @param CairoContext $context Description...
 * @return int Description...
 * @since PECL cairo >= 0.1.0
 **/
function cairo_status($context){}

/**
 * Retrieves the current status as string
 *
 * Retrieves the current status as a readable string
 *
 * @param int $status A valid status code given by {@link cairo_status}
 *   or CairoContext::status
 * @return string A string containing the current status of a
 *   CairoContext object
 **/
function cairo_status_to_string($status){}

/**
 * The stroke purpose
 *
 * @param CairoContext $context Description...
 * @return void Description...
 * @since PECL cairo >= 0.1.0
 **/
function cairo_stroke($context){}

/**
 * The strokeExtents purpose
 *
 * @param CairoContext $context Description...
 * @return array Description...
 * @since PECL cairo >= 0.1.0
 **/
function cairo_stroke_extents($context){}

/**
 * The strokePreserve purpose
 *
 * @param CairoContext $context Description...
 * @return void Description...
 * @since PECL cairo >= 0.1.0
 **/
function cairo_stroke_preserve($context){}

/**
 * @param CairoSurface $surface Description...
 * @return void What is returned on success and failure
 * @since PECL cairo >= 0.1.0
 **/
function cairo_surface_copy_page($surface){}

/**
 * @param CairoSurface $surface Description...
 * @param int $content Description...
 * @param float $width Description...
 * @param float $height Description...
 * @return CairoSurface What is returned on success and failure
 * @since PECL cairo >= 0.1.0
 **/
function cairo_surface_create_similar($surface, $content, $width, $height){}

/**
 * @param CairoSurface $surface Description...
 * @return void What is returned on success and failure
 * @since PECL cairo >= 0.1.0
 **/
function cairo_surface_finish($surface){}

/**
 * @param CairoSurface $surface Description...
 * @return void What is returned on success and failure
 * @since PECL cairo >= 0.1.0
 **/
function cairo_surface_flush($surface){}

/**
 * @param CairoSurface $surface Description...
 * @return int What is returned on success and failure
 * @since PECL cairo >= 0.1.0
 **/
function cairo_surface_get_content($surface){}

/**
 * @param CairoSurface $surface Description...
 * @return array What is returned on success and failure
 * @since PECL cairo >= 0.1.0
 **/
function cairo_surface_get_device_offset($surface){}

/**
 * @param CairoSurface $surface Description...
 * @return CairoFontOptions What is returned on success and failure
 * @since PECL cairo >= 0.1.0
 **/
function cairo_surface_get_font_options($surface){}

/**
 * @param CairoSurface $surface Description...
 * @return int What is returned on success and failure
 * @since PECL cairo >= 0.1.0
 **/
function cairo_surface_get_type($surface){}

/**
 * @param CairoSurface $surface Description...
 * @return void What is returned on success and failure
 * @since PECL cairo >= 0.1.0
 **/
function cairo_surface_mark_dirty($surface){}

/**
 * @param CairoSurface $surface Description...
 * @param float $x Description...
 * @param float $y Description...
 * @param float $width Description...
 * @param float $height Description...
 * @return void What is returned on success and failure
 * @since PECL cairo >= 0.1.0
 **/
function cairo_surface_mark_dirty_rectangle($surface, $x, $y, $width, $height){}

/**
 * @param CairoSurface $surface Description...
 * @param float $x Description...
 * @param float $y Description...
 * @return void What is returned on success and failure
 * @since PECL cairo >= 0.1.0
 **/
function cairo_surface_set_device_offset($surface, $x, $y){}

/**
 * @param CairoSurface $surface Description...
 * @param float $x Description...
 * @param float $y Description...
 * @return void What is returned on success and failure
 * @since PECL cairo >= 0.1.0
 **/
function cairo_surface_set_fallback_resolution($surface, $x, $y){}

/**
 * @param CairoSurface $surface Description...
 * @return void What is returned on success and failure
 * @since PECL cairo >= 0.1.0
 **/
function cairo_surface_show_page($surface){}

/**
 * @param CairoSurface $surface Description...
 * @return int What is returned on success and failure
 * @since PECL cairo >= 0.1.0
 **/
function cairo_surface_status($surface){}

/**
 * @param CairoSurface $surface Description...
 * @param resource $stream Description...
 * @return void What is returned on success and failure
 * @since PECL cairo >= 0.1.0
 **/
function cairo_surface_write_to_png($surface, $stream){}

/**
 * Used to retrieve a list of supported SVG versions
 *
 * Returns a numerically indexed array of currently available
 * CairoSvgVersion constants. In order to retrieve the string values for
 * each item, use CairoSvgSurface::versionToString.
 *
 * @return array Returns a numerically indexed array of integer values.
 * @since PECL cairo >= 0.1.0
 **/
function cairo_svg_get_versions(){}

/**
 * @param string $file Description...
 * @param float $width Description...
 * @param float $height Description...
 * @return CairoSvgSurface What is returned on success and failure
 * @since PECL cairo >= 0.1.0
 **/
function cairo_svg_surface_create($file, $width, $height){}

/**
 * @param CairoSvgSurface $surface Description...
 * @param int $version Description...
 * @return void What is returned on success and failure
 * @since PECL cairo >= 0.1.0
 **/
function cairo_svg_surface_restrict_to_version($surface, $version){}

/**
 * @param int $version Description...
 * @return string What is returned on success and failure
 * @since PECL cairo >= 0.1.0
 **/
function cairo_svg_version_to_string($version){}

/**
 * The textExtents purpose
 *
 * @param CairoContext $context Description...
 * @return array Description...
 * @since PECL cairo >= 0.1.0
 **/
function cairo_text_extents($context){}

/**
 * The textPath purpose
 *
 * Adds closed paths for text to the current path. The generated path, if
 * filled, achieves an effect similar to that of CairoContext::showText.
 *
 * Text conversion and positioning is done similar to
 * CairoContext::showText.
 *
 * Like CairoContext::showText, after this call the current point is
 * moved to the origin of where the next glyph would be placed in this
 * same progression. That is, the current point will be at the origin of
 * the final glyph offset by its advance values. This allows for chaining
 * multiple calls to CairoContext::showText without having to set current
 * point in between.
 *
 * Note: The CairoContext::textPath function call is part of what the
 * cairo designers call the "toy" text API. It is convenient for short
 * demos and simple programs, but it is not expected to be adequate for
 * serious text-using applications. See CairoContext::glyphPath for the
 * "real" text path API in cairo.
 *
 * @param CairoContext $context A CairoContext object
 * @param string $text Description...
 * @return void Description...
 * @since PECL cairo >= 0.1.0
 **/
function cairo_text_path($context, $text){}

/**
 * The transform purpose
 *
 * @param CairoContext $context Description...
 * @param CairoMatrix $matrix Description...
 * @return void Description...
 * @since PECL cairo >= 0.1.0
 **/
function cairo_transform($context, $matrix){}

/**
 * The translate purpose
 *
 * @param CairoContext $context Description...
 * @param float $x Description...
 * @param float $y Description...
 * @return void Description...
 * @since PECL cairo >= 0.1.0
 **/
function cairo_translate($context, $x, $y){}

/**
 * The userToDevice purpose
 *
 * @param CairoContext $context Description...
 * @param float $x Description...
 * @param float $y Description...
 * @return array Description...
 * @since PECL cairo >= 0.1.0
 **/
function cairo_user_to_device($context, $x, $y){}

/**
 * The userToDeviceDistance purpose
 *
 * @param CairoContext $context Description...
 * @param float $x Description...
 * @param float $y Description...
 * @return array Description...
 * @since PECL cairo >= 0.1.0
 **/
function cairo_user_to_device_distance($context, $x, $y){}

/**
 * Retrieves cairo's library version
 *
 * Retrieves the current version of the cairo library as an integer value
 *
 * @return int Current Cairo library version integer
 **/
function cairo_version(){}

/**
 * Retrieves cairo version as string
 *
 * Retrieves the current cairo library version as a string.
 *
 * @return string Current Cairo library version string
 **/
function cairo_version_string(){}

/**
 * Call the callback given by the first parameter
 *
 * Calls the {@link callback} given by the first parameter and passes the
 * remaining parameters as arguments.
 *
 * @param callable $callback The callable to be called.
 * @param mixed ...$vararg Zero or more parameters to be passed to the
 *   callback.
 * @return mixed Returns the return value of the callback.
 * @since PHP 4, PHP 5, PHP 7
 **/
function call_user_func($callback, ...$vararg){}

/**
 * Call a callback with an array of parameters
 *
 * Calls the {@link callback} given by the first parameter with the
 * parameters in {@link param_arr}.
 *
 * @param callable $callback The callable to be called.
 * @param array $param_arr The parameters to be passed to the callback,
 *   as an indexed array.
 * @return mixed Returns the return value of the callback, or FALSE on
 *   error.
 * @since PHP 4 >= 4.0.4, PHP 5, PHP 7
 **/
function call_user_func_array($callback, $param_arr){}

/**
 * Call a user method on an specific object
 *
 * @param string $method_name The method name being called.
 * @param object $obj The object that {@link method_name} is being
 *   called on.
 * @param mixed ...$vararg The optional parameters.
 * @return mixed
 * @since PHP 4, PHP 5
 **/
function call_user_method($method_name, &$obj, ...$vararg){}

/**
 * Call a user method given with an array of parameters
 *
 * @param string $method_name The method name being called.
 * @param object $obj The object that {@link method_name} is being
 *   called on.
 * @param array $params An array of parameters.
 * @return mixed
 * @since PHP 4 >= 4.0.5, PHP 5
 **/
function call_user_method_array($method_name, &$obj, $params){}

/**
 * Return the number of days in a month for a given year and calendar
 *
 * This function will return the number of days in the {@link month} of
 * {@link year} for the specified {@link calendar}.
 *
 * @param int $calendar Calendar to use for calculation
 * @param int $month Month in the selected calendar
 * @param int $year Year in the selected calendar
 * @return int The length in days of the selected month in the given
 *   calendar
 * @since PHP 4 >= 4.1.0, PHP 5, PHP 7
 **/
function cal_days_in_month($calendar, $month, $year){}

/**
 * Converts from Julian Day Count to a supported calendar
 *
 * {@link cal_from_jd} converts the Julian day given in {@link jd} into a
 * date of the specified {@link calendar}. Supported {@link calendar}
 * values are CAL_GREGORIAN, CAL_JULIAN, CAL_JEWISH and CAL_FRENCH.
 *
 * @param int $jd Julian day as integer
 * @param int $calendar Calendar to convert to
 * @return array Returns an array containing calendar information like
 *   month, day, year, day of week (dow), abbreviated and full names of
 *   weekday and month and the date in string form "month/day/year". The
 *   day of week ranges from 0 (Sunday) to 6 (Saturday).
 * @since PHP 4 >= 4.1.0, PHP 5, PHP 7
 **/
function cal_from_jd($jd, $calendar){}

/**
 * Returns information about a particular calendar
 *
 * {@link cal_info} returns information on the specified {@link
 * calendar}.
 *
 * Calendar information is returned as an array containing the elements
 * calname, calsymbol, month, abbrevmonth and maxdaysinmonth. The names
 * of the different calendars which can be used as {@link calendar} are
 * as follows: 0 or CAL_GREGORIAN - Gregorian Calendar 1 or CAL_JULIAN -
 * Julian Calendar 2 or CAL_JEWISH - Jewish Calendar 3 or CAL_FRENCH -
 * French Revolutionary Calendar
 *
 * If no {@link calendar} is specified information on all supported
 * calendars is returned as an array.
 *
 * @param int $calendar Calendar to return information for. If no
 *   calendar is specified information about all calendars is returned.
 * @return array
 * @since PHP 4 >= 4.1.0, PHP 5, PHP 7
 **/
function cal_info($calendar){}

/**
 * Converts from a supported calendar to Julian Day Count
 *
 * {@link cal_to_jd} calculates the Julian day count for a date in the
 * specified {@link calendar}. Supported {@link calendar}s are
 * CAL_GREGORIAN, CAL_JULIAN, CAL_JEWISH and CAL_FRENCH.
 *
 * @param int $calendar Calendar to convert from, one of CAL_GREGORIAN,
 *   CAL_JULIAN, CAL_JEWISH or CAL_FRENCH.
 * @param int $month The month as a number, the valid range depends on
 *   the {@link calendar}
 * @param int $day The day as a number, the valid range depends on the
 *   {@link calendar}
 * @param int $year The year as a number, the valid range depends on
 *   the {@link calendar}
 * @return int A Julian Day number.
 * @since PHP 4 >= 4.1.0, PHP 5, PHP 7
 **/
function cal_to_jd($calendar, $month, $day, $year){}

/**
 * Round fractions up
 *
 * @param float $value The value to round
 * @return float {@link value} rounded up to the next highest integer.
 *   The return value of {@link ceil} is still of type float as the value
 *   range of float is usually bigger than that of integer.
 * @since PHP 4, PHP 5, PHP 7
 **/
function ceil($value){}

/**
 * Creates a chdb file
 *
 * {@link chdb_create} creates a chdb file containing the specified
 * key-value pairs.
 *
 * @param string $pathname The name of the file to create. If a file
 *   with the same name already exists, it is overwritten.
 * @param array $data An array containing the key-value pairs to store
 *   in the chdb file. Keys and values are converted to strings before
 *   being written to the file, as chdb only support the string type.
 *   Note that binary strings are supported as well, both as keys and
 *   values.
 * @return bool
 * @since PECL chdb >= 0.1.0
 **/
function chdb_create($pathname, $data){}

/**
 * Change directory
 *
 * Changes PHP's current directory to {@link directory}.
 *
 * @param string $directory The new current directory
 * @return bool
 * @since PHP 4, PHP 5, PHP 7
 **/
function chdir($directory){}

/**
 * Validate a Gregorian date
 *
 * Checks the validity of the date formed by the arguments. A date is
 * considered valid if each parameter is properly defined.
 *
 * @param int $month The month is between 1 and 12 inclusive.
 * @param int $day The day is within the allowed number of days for the
 *   given {@link month}. Leap {@link year}s are taken into
 *   consideration.
 * @param int $year The year is between 1 and 32767 inclusive.
 * @return bool Returns TRUE if the date given is valid; otherwise
 *   returns FALSE.
 * @since PHP 4, PHP 5, PHP 7
 **/
function checkdate($month, $day, $year){}

/**
 * Check DNS records corresponding to a given Internet host name or IP
 * address
 *
 * Searches DNS for records of type {@link type} corresponding to {@link
 * host}.
 *
 * @param string $host {@link host} may either be the IP address in
 *   dotted-quad notation or the host name.
 * @param string $type {@link type} may be any one of: A, MX, NS, SOA,
 *   PTR, CNAME, AAAA, A6, SRV, NAPTR, TXT or ANY.
 * @return bool Returns TRUE if any records are found; returns FALSE if
 *   no records were found or if an error occurred.
 * @since PHP 4, PHP 5, PHP 7
 **/
function checkdnsrr($host, $type){}

/**
 * Changes file group
 *
 * Attempts to change the group of the file {@link filename} to {@link
 * group}.
 *
 * Only the superuser may change the group of a file arbitrarily; other
 * users may change the group of a file to any group of which that user
 * is a member.
 *
 * @param string $filename Path to the file.
 * @param mixed $group A group name or number.
 * @return bool
 * @since PHP 4, PHP 5, PHP 7
 **/
function chgrp($filename, $group){}

/**
 * Changes file mode
 *
 * Attempts to change the mode of the specified file to that given in
 * {@link mode}.
 *
 * @param string $filename Path to the file.
 * @param int $mode Note that {@link mode} is not automatically assumed
 *   to be an octal value, so to ensure the expected operation, you need
 *   to prefix {@link mode} with a zero (0). Strings such as "g+w" will
 *   not work properly.
 *   
 *   <?php chmod("/somedir/somefile", 755); // decimal; probably
 *   incorrect chmod("/somedir/somefile", "u+rwx,go+rx"); // string;
 *   incorrect chmod("/somedir/somefile", 0755); // octal; correct value
 *   of mode ?>
 *   
 *   The {@link mode} parameter consists of three octal number components
 *   specifying access restrictions for the owner, the user group in
 *   which the owner is in, and to everybody else in this order. One
 *   component can be computed by adding up the needed permissions for
 *   that target user base. Number 1 means that you grant execute rights,
 *   number 2 means that you make the file writeable, number 4 means that
 *   you make the file readable. Add up these numbers to specify needed
 *   rights. You can also read more about modes on Unix systems with 'man
 *   1 chmod' and 'man 2 chmod'.
 *   
 *   <?php // Read and write for owner, nothing for everybody else
 *   chmod("/somedir/somefile", 0600);
 *   
 *   // Read and write for owner, read for everybody else
 *   chmod("/somedir/somefile", 0644);
 *   
 *   // Everything for owner, read and execute for others
 *   chmod("/somedir/somefile", 0755);
 *   
 *   // Everything for owner, read and execute for owner's group
 *   chmod("/somedir/somefile", 0750); ?>
 * @return bool
 * @since PHP 4, PHP 5, PHP 7
 **/
function chmod($filename, $mode){}

/**
 * Strip whitespace (or other characters) from the end of a string
 *
 * This function returns a string with whitespace (or other characters)
 * stripped from the end of {@link str}.
 *
 * Without the second parameter, {@link chop} will strip these
 * characters: " " (ASCII 32 (0x20)), an ordinary space. "\t" (ASCII 9
 * (0x09)), a tab. "\n" (ASCII 10 (0x0A)), a new line (line feed). "\r"
 * (ASCII 13 (0x0D)), a carriage return. "\0" (ASCII 0 (0x00)), the
 * NULL-byte. "\x0B" (ASCII 11 (0x0B)), a vertical tab.
 *
 * @param string $str The input string.
 * @param string $character_mask You can also specify the characters
 *   you want to strip, by means of the {@link character_mask} parameter.
 *   Simply list all characters that you want to be stripped. With .. you
 *   can specify a range of characters.
 * @return string Returns the modified string.
 * @since PHP 4, PHP 5, PHP 7
 **/
function chop($str, $character_mask){}

/**
 * Changes file owner
 *
 * Attempts to change the owner of the file {@link filename} to user
 * {@link user}. Only the superuser may change the owner of a file.
 *
 * @param string $filename Path to the file.
 * @param mixed $user A user name or number.
 * @return bool
 * @since PHP 4, PHP 5, PHP 7
 **/
function chown($filename, $user){}

/**
 * Generate a single-byte string from a number
 *
 * Returns a one-character string containing the character specified by
 * interpreting {@link bytevalue} as an unsigned integer.
 *
 * This can be used to create a one-character string in a single-byte
 * encoding such as ASCII, ISO-8859, or Windows 1252, by passing the
 * position of a desired character in the encoding's mapping table.
 * However, note that this function is not aware of any string encoding,
 * and in particular cannot be passed a Unicode code point value to
 * generate a string in a multibyte encoding like UTF-8 or UTF-16.
 *
 * This function complements {@link ord}.
 *
 * @param int $bytevalue An integer between 0 and 255. Values outside
 *   the valid range (0..255) will be bitwise and'ed with 255, which is
 *   equivalent to the following algorithm:
 *   
 *   while ($bytevalue < 0) { $bytevalue += 256; } $bytevalue %= 256;
 * @return string A single-character string containing the specified
 *   byte.
 * @since PHP 4, PHP 5, PHP 7
 **/
function chr($bytevalue){}

/**
 * Change the root directory
 *
 * Changes the root directory of the current process to {@link
 * directory}, and changes the current working directory to "/".
 *
 * This function is only available to GNU and BSD systems, and only when
 * using the CLI, CGI or Embed SAPI. Also, this function requires root
 * privileges.
 *
 * @param string $directory The path to change the root directory to.
 * @return bool
 * @since PHP 4 >= 4.0.5, PHP 5, PHP 7
 **/
function chroot($directory){}

/**
 * Split a string into smaller chunks
 *
 * Can be used to split a string into smaller chunks which is useful for
 * e.g. converting {@link base64_encode} output to match RFC 2045
 * semantics. It inserts {@link end} every {@link chunklen} characters.
 *
 * @param string $body The string to be chunked.
 * @param int $chunklen The chunk length.
 * @param string $end The line ending sequence.
 * @return string Returns the chunked string.
 * @since PHP 4, PHP 5, PHP 7
 **/
function chunk_split($body, $chunklen, $end){}

/**
 * Import new class method definitions from a file
 *
 * @param string $filename The filename of the class method definitions
 *   to import
 * @return array Associative array of imported methods
 * @since PECL classkit >= 0.3
 **/
function classkit_import($filename){}

/**
 * Dynamically adds a new method to a given class
 *
 * @param string $classname The class to which this method will be
 *   added
 * @param string $methodname The name of the method to add
 * @param string $args Comma-delimited list of arguments for the
 *   newly-created method
 * @param string $code The code to be evaluated when {@link methodname}
 *   is called
 * @param int $flags The type of method to create, can be
 *   CLASSKIT_ACC_PUBLIC, CLASSKIT_ACC_PROTECTED or CLASSKIT_ACC_PRIVATE
 * @return bool
 * @since PECL classkit >= 0.1
 **/
function classkit_method_add($classname, $methodname, $args, $code, $flags){}

/**
 * Copies a method from class to another
 *
 * @param string $dClass Destination class for copied method
 * @param string $dMethod Destination method name
 * @param string $sClass Source class of the method to copy
 * @param string $sMethod Name of the method to copy from the source
 *   class. If this parameter is omitted, the value of {@link dMethod} is
 *   assumed.
 * @return bool
 * @since PECL classkit >= 0.2
 **/
function classkit_method_copy($dClass, $dMethod, $sClass, $sMethod){}

/**
 * Dynamically changes the code of the given method
 *
 * @param string $classname The class in which to redefine the method
 * @param string $methodname The name of the method to redefine
 * @param string $args Comma-delimited list of arguments for the
 *   redefined method
 * @param string $code The new code to be evaluated when {@link
 *   methodname} is called
 * @param int $flags The redefined method can be CLASSKIT_ACC_PUBLIC,
 *   CLASSKIT_ACC_PROTECTED or CLASSKIT_ACC_PRIVATE
 * @return bool
 * @since PECL classkit >= 0.1
 **/
function classkit_method_redefine($classname, $methodname, $args, $code, $flags){}

/**
 * Dynamically removes the given method
 *
 * @param string $classname The class in which to remove the method
 * @param string $methodname The name of the method to remove
 * @return bool
 * @since PECL classkit >= 0.1
 **/
function classkit_method_remove($classname, $methodname){}

/**
 * Dynamically changes the name of the given method
 *
 * @param string $classname The class in which to rename the method
 * @param string $methodname The name of the method to rename
 * @param string $newname The new name to give to the renamed method
 * @return bool
 * @since PECL classkit >= 0.1
 **/
function classkit_method_rename($classname, $methodname, $newname){}

/**
 * Creates an alias for a class
 *
 * Creates an alias named {@link alias} based on the user defined class
 * {@link original}. The aliased class is exactly the same as the
 * original class.
 *
 * @param string $original The original class.
 * @param string $alias The alias name for the class.
 * @param bool $autoload Whether to autoload if the original class is
 *   not found.
 * @return bool
 * @since PHP 5 >= 5.3.0, PHP 7
 **/
function class_alias($original, $alias, $autoload){}

/**
 * Checks if the class has been defined
 *
 * This function checks whether or not the given class has been defined.
 *
 * @param string $class_name The class name. The name is matched in a
 *   case-insensitive manner.
 * @param bool $autoload Whether or not to call by default.
 * @return bool Returns TRUE if {@link class_name} is a defined class,
 *   FALSE otherwise.
 * @since PHP 4, PHP 5, PHP 7
 **/
function class_exists($class_name, $autoload){}

/**
 * Return the interfaces which are implemented by the given class or
 * interface
 *
 * This function returns an array with the names of the interfaces that
 * the given {@link class} and its parents implement.
 *
 * @param mixed $class An object (class instance) or a string (class or
 *   interface name).
 * @param bool $autoload Whether to allow this function to load the
 *   class automatically through the {@link __autoload} magic method.
 * @return array An array on success, or FALSE on error.
 * @since PHP 5, PHP 7
 **/
function class_implements($class, $autoload){}

/**
 * Return the parent classes of the given class
 *
 * This function returns an array with the name of the parent classes of
 * the given {@link class}.
 *
 * @param mixed $class An object (class instance) or a string (class
 *   name).
 * @param bool $autoload Whether to allow this function to load the
 *   class automatically through the {@link __autoload} magic method.
 * @return array An array on success, or FALSE on error.
 * @since PHP 5, PHP 7
 **/
function class_parents($class, $autoload){}

/**
 * Return the traits used by the given class
 *
 * This function returns an array with the names of the traits that the
 * given {@link class} uses. This does however not include any traits
 * used by a parent class.
 *
 * @param mixed $class An object (class instance) or a string (class
 *   name).
 * @param bool $autoload Whether to allow this function to load the
 *   class automatically through the {@link __autoload} magic method.
 * @return array An array on success, or FALSE on error.
 * @since PHP 5 >= 5.4.0, PHP 7
 **/
function class_uses($class, $autoload){}

/**
 * Clears file status cache
 *
 * When you use {@link stat}, {@link lstat}, or any of the other
 * functions listed in the affected functions list (below), PHP caches
 * the information those functions return in order to provide faster
 * performance. However, in certain cases, you may want to clear the
 * cached information. For instance, if the same file is being checked
 * multiple times within a single script, and that file is in danger of
 * being removed or changed during that script's operation, you may elect
 * to clear the status cache. In these cases, you can use the {@link
 * clearstatcache} function to clear the information that PHP caches
 * about a file.
 *
 * You should also note that PHP doesn't cache information about
 * non-existent files. So, if you call {@link file_exists} on a file that
 * doesn't exist, it will return FALSE until you create the file. If you
 * create the file, it will return TRUE even if you then delete the file.
 * However {@link unlink} clears the cache automatically.
 *
 * Affected functions include {@link stat}, {@link lstat}, {@link
 * file_exists}, {@link is_writable}, {@link is_readable}, {@link
 * is_executable}, {@link is_file}, {@link is_dir}, {@link is_link},
 * {@link filectime}, {@link fileatime}, {@link filemtime}, {@link
 * fileinode}, {@link filegroup}, {@link fileowner}, {@link filesize},
 * {@link filetype}, and {@link fileperms}.
 *
 * @param bool $clear_realpath_cache Whether to clear the realpath
 *   cache or not.
 * @param string $filename Clear the realpath and the stat cache for a
 *   specific filename only; only used if {@link clear_realpath_cache} is
 *   TRUE.
 * @return void
 * @since PHP 4, PHP 5, PHP 7
 **/
function clearstatcache($clear_realpath_cache, $filename){}

/**
 * Returns the current process title
 *
 * Returns the current process title, as set by {@link
 * cli_set_process_title}. Note that this may not exactly match what is
 * shown in ps or top, depending on your operating system.
 *
 * This function is available only in CLI mode.
 *
 * @return string Return a string with the current process title or
 *   NULL on error.
 * @since PHP 5 >= 5.5.0, PHP 7
 **/
function cli_get_process_title(){}

/**
 * Sets the process title
 *
 * Sets the process title visible in tools such as top and ps. This
 * function is available only in CLI mode.
 *
 * @param string $title The new title.
 * @return bool
 * @since PHP 5 >= 5.5.0, PHP 7
 **/
function cli_set_process_title($title){}

/**
 * Close directory handle
 *
 * Closes the directory stream indicated by {@link dir_handle}. The
 * stream must have previously been opened by {@link opendir}.
 *
 * @param resource $dir_handle The directory handle resource previously
 *   opened with {@link opendir}. If the directory handle is not
 *   specified, the last link opened by {@link opendir} is assumed.
 * @return void
 * @since PHP 4, PHP 5, PHP 7
 **/
function closedir($dir_handle){}

/**
 * Close connection to system logger
 *
 * {@link closelog} closes the descriptor being used to write to the
 * system logger. The use of {@link closelog} is optional.
 *
 * @return bool
 * @since PHP 4, PHP 5, PHP 7
 **/
function closelog(){}

/**
 * Sort array maintaining index association
 *
 * This function sorts an array such that array indices maintain their
 * correlation with the array elements they are associated with. This is
 * used mainly when sorting associative arrays where the actual element
 * order is significant. Array elements will have sort order according to
 * current locale rules.
 *
 * Equivalent to standard PHP {@link asort}.
 *
 * @param Collator $coll Collator object.
 * @param array $arr Array of strings to sort.
 * @param int $sort_flag Optional sorting type, one of the following:
 *   Collator::SORT_REGULAR - compare items normally (don't change types)
 *   Collator::SORT_NUMERIC - compare items numerically
 *   Collator::SORT_STRING - compare items as strings Default $sort_flag
 *   value is Collator::SORT_REGULAR. It is also used if an invalid
 *   $sort_flag value has been specified.
 * @return bool
 * @since PHP 5 >= 5.3.0, PHP 7, PECL intl >= 1.0.0
 **/
function collator_asort($coll, &$arr, $sort_flag){}

/**
 * Compare two Unicode strings
 *
 * Compare two Unicode strings according to collation rules.
 *
 * @param Collator $coll Collator object.
 * @param string $str1 The first string to compare.
 * @param string $str2 The second string to compare.
 * @return int Return comparison result:
 * @since PHP 5 >= 5.3.0, PHP 7, PECL intl >= 1.0.0
 **/
function collator_compare($coll, $str1, $str2){}

/**
 * Create a collator
 *
 * The strings will be compared using the options already specified.
 *
 * @param string $locale The locale containing the required collation
 *   rules. Special values for locales can be passed in - if null is
 *   passed for the locale, the default locale collation rules will be
 *   used. If empty string ("") or "root" are passed, UCA rules will be
 *   used.
 * @return Collator Return new instance of Collator object, or NULL on
 *   error.
 * @since PHP 5 >= 5.3.0, PHP 7, PECL intl >= 1.0.0
 **/
function collator_create($locale){}

/**
 * Get collation attribute value
 *
 * Get a value of an integer collator attribute.
 *
 * @param Collator $coll Collator object.
 * @param int $attr Attribute to get value for.
 * @return int Attribute value, or boolean FALSE on error.
 * @since PHP 5 >= 5.3.0, PHP 7, PECL intl >= 1.0.0
 **/
function collator_get_attribute($coll, $attr){}

/**
 * Get collator's last error code
 *
 * @param Collator $coll Collator object.
 * @return int Error code returned by the last Collator API function
 *   call.
 * @since PHP 5 >= 5.3.0, PHP 7, PECL intl >= 1.0.0
 **/
function collator_get_error_code($coll){}

/**
 * Get text for collator's last error code
 *
 * Retrieves the message for the last error.
 *
 * @param Collator $coll Collator object.
 * @return string Description of an error occurred in the last Collator
 *   API function call.
 * @since PHP 5 >= 5.3.0, PHP 7, PECL intl >= 1.0.0
 **/
function collator_get_error_message($coll){}

/**
 * Get the locale name of the collator
 *
 * Get collector locale name.
 *
 * @param Collator $coll Collator object.
 * @param int $type You can choose between valid and actual locale (
 *   Locale::VALID_LOCALE and Locale::ACTUAL_LOCALE, respectively).
 * @return string Real locale name from which the collation data comes.
 *   If the collator was instantiated from rules or an error occurred,
 *   returns boolean FALSE.
 * @since PHP 5 >= 5.3.0, PHP 7, PECL intl >= 1.0.0
 **/
function collator_get_locale($coll, $type){}

/**
 * Get sorting key for a string
 *
 * Return collation key for a string.
 *
 * @param Collator $coll Collator object.
 * @param string $str The string to produce the key from.
 * @return string Returns the collation key for the string. Collation
 *   keys can be compared directly instead of strings.
 * @since PHP 5 >= 5.3.2, PHP 7
 **/
function collator_get_sort_key($coll, $str){}

/**
 * Get current collation strength
 *
 * @param Collator $coll Collator object.
 * @return int Returns current collation strength, or boolean FALSE on
 *   error.
 * @since PHP 5 >= 5.3.0, PHP 7, PECL intl >= 1.0.0
 **/
function collator_get_strength($coll){}

/**
 * Set collation attribute
 *
 * @param Collator $coll Collator object.
 * @param int $attr Attribute.
 * @param int $val Attribute value.
 * @return bool
 * @since PHP 5 >= 5.3.0, PHP 7, PECL intl >= 1.0.0
 **/
function collator_set_attribute($coll, $attr, $val){}

/**
 * Set collation strength
 *
 * The ICU Collation Service supports many levels of comparison (named
 * "Levels", but also known as "Strengths"). Having these categories
 * enables ICU to sort strings precisely according to local conventions.
 * However, by allowing the levels to be selectively employed, searching
 * for a string in text can be performed with various matching
 * conditions.
 *
 * Primary Level: Typically, this is used to denote differences between
 * base characters (for example, "a" < "b"). It is the strongest
 * difference. For example, dictionaries are divided into different
 * sections by base character. This is also called the level1 strength.
 * Secondary Level: Accents in the characters are considered secondary
 * differences (for example, "as" < "às" < "at"). Other differences
 * between letters can also be considered secondary differences,
 * depending on the language. A secondary difference is ignored when
 * there is a primary difference anywhere in the strings. This is also
 * called the level2 strength. Note: In some languages (such as Danish),
 * certain accented letters are considered to be separate base
 * characters. In most languages, however, an accented letter only has a
 * secondary difference from the unaccented version of that letter.
 * Tertiary Level: Upper and lower case differences in characters are
 * distinguished at the tertiary level (for example, "ao" < "Ao" <
 * "aò"). In addition, a variant of a letter differs from the base form
 * on the tertiary level (such as "A" and " "). Another example is the
 * difference between large and small Kana. A tertiary difference is
 * ignored when there is a primary or secondary difference anywhere in
 * the strings. This is also called the level3 strength. Quaternary
 * Level: When punctuation is ignored (see Ignoring Punctuations ) at
 * level 13, an additional level can be used to distinguish words with
 * and without punctuation (for example, "ab" < "a-b" < "aB"). This
 * difference is ignored when there is a primary, secondary or tertiary
 * difference. This is also known as the level4 strength. The quaternary
 * level should only be used if ignoring punctuation is required or when
 * processing Japanese text (see Hiragana processing). Identical Level:
 * When all other levels are equal, the identical level is used as a
 * tiebreaker. The Unicode code point values of the NFD form of each
 * string are compared at this level, just in case there is no difference
 * at levels 14. For example, Hebrew cantillation marks are only
 * distinguished at this level. This level should be used sparingly, as
 * only code point values differences between two strings is an extremely
 * rare occurrence. Using this level substantially decreases the
 * performance for both incremental comparison and sort key generation
 * (as well as increasing the sort key length). It is also known as level
 * 5 strength.
 *
 * For example, people may choose to ignore accents or ignore accents and
 * case when searching for text. Almost all characters are distinguished
 * by the first three levels, and in most locales the default value is
 * thus Tertiary. However, if Alternate is set to be Shifted, then the
 * Quaternary strength can be used to break ties among whitespace,
 * punctuation, and symbols that would otherwise be ignored. If very fine
 * distinctions among characters are required, then the Identical
 * strength can be used (for example, Identical Strength distinguishes
 * between the Mathematical Bold Small A and the Mathematical Italic
 * Small A.). However, using levels higher than Tertiary the Identical
 * strength result in significantly longer sort keys, and slower string
 * comparison performance for equal strings.
 *
 * @param Collator $coll Collator object.
 * @param int $strength Strength to set. Possible values are:
 *   Collator::PRIMARY Collator::SECONDARY Collator::TERTIARY
 *   Collator::QUATERNARY Collator::IDENTICAL Collator::DEFAULT_STRENGTH
 * @return bool
 * @since PHP 5 >= 5.3.0, PHP 7, PECL intl >= 1.0.0
 **/
function collator_set_strength($coll, $strength){}

/**
 * Sort array using specified collator
 *
 * This function sorts an array according to current locale rules.
 *
 * Equivalent to standard PHP {@link sort} .
 *
 * @param Collator $coll Collator object.
 * @param array $arr Array of strings to sort.
 * @param int $sort_flag Optional sorting type, one of the following:
 *   
 *   Collator::SORT_REGULAR - compare items normally (don't change types)
 *   Collator::SORT_NUMERIC - compare items numerically
 *   Collator::SORT_STRING - compare items as strings Default sorting
 *   type is Collator::SORT_REGULAR. It is also used if an invalid {@link
 *   sort_flag} value has been specified.
 * @return bool
 * @since PHP 5 >= 5.3.0, PHP 7, PECL intl >= 1.0.0
 **/
function collator_sort($coll, &$arr, $sort_flag){}

/**
 * Sort array using specified collator and sort keys
 *
 * Similar to {@link collator_sort} but uses ICU sorting keys produced by
 * ucol_getSortKey() to gain more speed on large arrays.
 *
 * @param Collator $coll Collator object.
 * @param array $arr Array of strings to sort
 * @return bool
 * @since PHP 5 >= 5.3.0, PHP 7, PECL intl >= 1.0.0
 **/
function collator_sort_with_sort_keys($coll, &$arr){}

namespace CommonMark {

/**
 * Parsing
 *
 * Shall parse {@link content}
 *
 * @param string $content markdown string
 * @param int $options A mask of:
 * @return CommonMark\Node Shall return root CommonMark\Node
 **/
function Parse($content, $options){}

}

namespace CommonMark {

/**
 * Rendering
 *
 * @param CommonMark\Node $node
 * @param int $options A mask of:
 * @param int $width
 * @return string
 **/
function Render($node, $options, $width){}

}

namespace CommonMark\Render {

/**
 * Rendering
 *
 * @param CommonMark\Node $node
 * @param int $options A mask of:
 * @return string
 **/
function HTML($node, $options){}

}

namespace CommonMark\Render {

/**
 * Rendering
 *
 * @param CommonMark\Node $node
 * @param int $options A mask of:
 * @param int $width
 * @return string
 **/
function Latex($node, $options, $width){}

}

namespace CommonMark\Render {

/**
 * Rendering
 *
 * @param CommonMark\Node $node
 * @param int $options A mask of:
 * @param int $width
 * @return string
 **/
function Man($node, $options, $width){}

}

namespace CommonMark\Render {

/**
 * Rendering
 *
 * @param CommonMark\Node $node
 * @param int $options A mask of:
 * @return string
 **/
function XML($node, $options){}

}

/**
 * Create array containing variables and their values
 *
 * Creates an array containing variables and their values.
 *
 * For each of these, {@link compact} looks for a variable with that name
 * in the current symbol table and adds it to the output array such that
 * the variable name becomes the key and the contents of the variable
 * become the value for that key. In short, it does the opposite of
 * {@link extract}.
 *
 * @param mixed $varname1 {@link compact} takes a variable number of
 *   parameters. Each parameter can be either a string containing the
 *   name of the variable, or an array of variable names. The array can
 *   contain other arrays of variable names inside it; {@link compact}
 *   handles it recursively.
 * @param mixed ...$vararg
 * @return array Returns the output array with all the variables added
 *   to it.
 * @since PHP 4, PHP 5, PHP 7
 **/
function compact($varname1, ...$vararg){}

namespace Componere {

/**
 * Casting
 *
 * @param Type $type A user defined type
 * @param $object An object with a user defined type compatible with
 *   Type
 * @return Type An object of type Type, cast from {@link object}
 **/
function cast($type, $object){}

}

namespace Componere {

/**
 * Casting
 *
 * @param Type $type A user defined type
 * @param $object An object with a user defined type compatible with
 *   Type
 * @return Type An object of type Type, cast from {@link object}, where
 *   members are references to {@link object} members
 **/
function cast_by_ref($type, $object){}

}

/**
 * Generate a globally unique identifier (GUID)
 *
 * Generates a Globally Unique Identifier (GUID).
 *
 * A GUID is generated in the same way as DCE UUID's, except that the
 * Microsoft convention is to enclose a GUID in curly braces.
 *
 * @return string Returns the GUID as a string.
 * @since PHP 5, PHP 7
 **/
function com_create_guid(){}

/**
 * Connect events from a COM object to a PHP object
 *
 * Instructs COM to sink events generated by {@link comobject} into the
 * PHP object {@link sinkobject}.
 *
 * Be careful how you use this feature; if you are doing something
 * similar to the example below, then it doesn't really make sense to run
 * it in a web server context.
 *
 * @param variant $comobject
 * @param object $sinkobject {@link sinkobject} should be an instance
 *   of a class with methods named after those of the desired
 *   dispinterface; you may use {@link com_print_typeinfo} to help
 *   generate a template class for this purpose.
 * @param mixed $sinkinterface PHP will attempt to use the default
 *   dispinterface type specified by the typelibrary associated with
 *   {@link comobject}, but you may override this choice by setting
 *   {@link sinkinterface} to the name of the dispinterface that you want
 *   to use.
 * @return bool
 * @since PHP 4 >= 4.2.0, PHP 5, PHP 7
 **/
function com_event_sink($comobject, $sinkobject, $sinkinterface){}

/**
 * Returns a handle to an already running instance of a COM object
 *
 * {@link com_get_active_object} is similar to creating a new instance of
 * a object, except that it will only return an object to your script if
 * the object is already running. OLE applications use something known as
 * the "Running Object Table" to allow well-known applications to be
 * launched only once; this function exposes the COM library function
 * GetActiveObject() to get a handle on a running instance.
 *
 * @param string $progid {@link progid} must be either the ProgID or
 *   CLSID for the object that you want to access (for example
 *   Word.Application).
 * @param int $code_page Acts in precisely the same way that it does
 *   for the class.
 * @return variant If the requested object is running, it will be
 *   returned to your script just like any other COM object.
 * @since PHP 5, PHP 7
 **/
function com_get_active_object($progid, $code_page){}

/**
 * Loads a Typelib
 *
 * Loads a type-library and registers its constants in the engine, as
 * though they were defined using {@link define}.
 *
 * Note that it is much more efficient to use the configuration setting
 * to pre-load and register the constants, although not so flexible.
 *
 * If you have turned on , then PHP will attempt to automatically
 * register the constants associated with a COM object when you
 * instantiate it. This depends on the interfaces provided by the COM
 * object itself, and may not always be possible.
 *
 * @param string $typelib_name {@link typelib_name} can be one of the
 *   following: The filename of a .tlb file or the executable module that
 *   contains the type library. The type library GUID, followed by its
 *   version number, for example
 *   {00000200-0000-0010-8000-00AA006D2EA4},2,0. The type library name,
 *   e.g. Microsoft OLE DB ActiveX Data Objects 1.0 Library. PHP will
 *   attempt to resolve the type library in this order, as the process
 *   gets more and more expensive as you progress down the list;
 *   searching for the type library by name is handled by physically
 *   enumerating the registry until we find a match.
 * @param bool $case_sensitive The {@link case_sensitive} behaves
 *   inversely to the parameter $case_insensitive in the {@link define}
 *   function.
 * @return bool
 * @since PHP 4 >= 4.1.0, PHP 5, PHP 7
 **/
function com_load_typelib($typelib_name, $case_sensitive){}

/**
 * Process COM messages, sleeping for up to timeoutms milliseconds
 *
 * This function will sleep for up to {@link timeoutms} milliseconds, or
 * until a message arrives in the queue.
 *
 * The purpose of this function is to route COM calls between apartments
 * and handle various synchronization issues. This allows your script to
 * wait efficiently for events to be triggered, while still handling
 * other events or running other code in the background. You should use
 * it in a loop, as demonstrated by the example in the {@link
 * com_event_sink} function, until you are finished using event bound COM
 * objects.
 *
 * @param int $timeoutms The timeout, in milliseconds. If you do not
 *   specify a value for {@link timeoutms}, then 0 will be assumed. A 0
 *   value means that no waiting will be performed; if there are messages
 *   pending they will be dispatched as before; if there are no messages
 *   pending, the function will return FALSE immediately without
 *   sleeping.
 * @return bool If a message or messages arrives before the timeout,
 *   they will be dispatched, and the function will return TRUE. If the
 *   timeout occurs and no messages were processed, the return value will
 *   be FALSE.
 * @since PHP 4 >= 4.2.0, PHP 5, PHP 7
 **/
function com_message_pump($timeoutms){}

/**
 * Print out a PHP class definition for a dispatchable interface
 *
 * The purpose of this function is to help generate a skeleton class for
 * use as an event sink. You may also use it to generate a dump of any
 * COM object, provided that it supports enough of the introspection
 * interfaces, and that you know the name of the interface you want to
 * display.
 *
 * @param object $comobject {@link comobject} should be either an
 *   instance of a COM object, or be the name of a typelibrary (which
 *   will be resolved according to the rules set out in {@link
 *   com_load_typelib}).
 * @param string $dispinterface The name of an IDispatch descendant
 *   interface that you want to display.
 * @param bool $wantsink If set to TRUE, the corresponding sink
 *   interface will be displayed instead.
 * @return bool
 * @since PHP 4 >= 4.2.0, PHP 5, PHP 7
 **/
function com_print_typeinfo($comobject, $dispinterface, $wantsink){}

/**
 * Check whether client disconnected
 *
 * Checks whether the client disconnected.
 *
 * @return int Returns 1 if client disconnected, 0 otherwise.
 * @since PHP 4, PHP 5, PHP 7
 **/
function connection_aborted(){}

/**
 * Returns connection status bitfield
 *
 * Gets the connection status bitfield.
 *
 * @return int Returns the connection status bitfield, which can be
 *   used against the CONNECTION_XXX constants to determine the
 *   connection status.
 * @since PHP 4, PHP 5, PHP 7
 **/
function connection_status(){}

/**
 * Returns the value of a constant
 *
 * @param string $name The constant name.
 * @return mixed Returns the value of the constant, or NULL if the
 *   constant is not defined.
 * @since PHP 4 >= 4.0.4, PHP 5, PHP 7
 **/
function constant($name){}

/**
 * Convert from one Cyrillic character set to another
 *
 * Converts from one Cyrillic character set to another.
 *
 * @param string $str The string to be converted.
 * @param string $from The source Cyrillic character set, as a single
 *   character.
 * @param string $to The target Cyrillic character set, as a single
 *   character.
 * @return string Returns the converted string.
 * @since PHP 4, PHP 5, PHP 7
 **/
function convert_cyr_string($str, $from, $to){}

/**
 * Decode a uuencoded string
 *
 * {@link convert_uudecode} decodes a uuencoded string.
 *
 * @param string $data The uuencoded data.
 * @return string Returns the decoded data as a string .
 * @since PHP 5, PHP 7
 **/
function convert_uudecode($data){}

/**
 * Uuencode a string
 *
 * {@link convert_uuencode} encodes a string using the uuencode
 * algorithm.
 *
 * Uuencode translates all strings (including binary data) into printable
 * characters, making them safe for network transmissions. Uuencoded data
 * is about 35% larger than the original.
 *
 * @param string $data The data to be encoded.
 * @return string Returns the uuencoded data .
 * @since PHP 5, PHP 7
 **/
function convert_uuencode($data){}

/**
 * Copies file
 *
 * Makes a copy of the file {@link source} to {@link dest}.
 *
 * If you wish to move a file, use the {@link rename} function.
 *
 * @param string $source Path to the source file.
 * @param string $dest The destination path. If {@link dest} is a URL,
 *   the copy operation may fail if the wrapper does not support
 *   overwriting of existing files.
 * @param resource $context A valid context resource created with
 *   {@link stream_context_create}.
 * @return bool
 * @since PHP 4, PHP 5, PHP 7
 **/
function copy($source, $dest, $context){}

/**
 * Cosine
 *
 * {@link cos} returns the cosine of the {@link arg} parameter. The
 * {@link arg} parameter is in radians.
 *
 * @param float $arg An angle in radians
 * @return float The cosine of {@link arg}
 * @since PHP 4, PHP 5, PHP 7
 **/
function cos($arg){}

/**
 * Hyperbolic cosine
 *
 * Returns the hyperbolic cosine of {@link arg}, defined as (exp(arg) +
 * exp(-arg))/2.
 *
 * @param float $arg The argument to process
 * @return float The hyperbolic cosine of {@link arg}
 * @since PHP 4 >= 4.1.0, PHP 5, PHP 7
 **/
function cosh($arg){}

/**
 * Count all elements in an array, or something in an object
 *
 * Counts all elements in an array, or something in an object.
 *
 * For objects, if you have SPL installed, you can hook into {@link
 * count} by implementing interface Countable. The interface has exactly
 * one method, Countable::count, which returns the return value for the
 * {@link count} function.
 *
 * Please see the Array section of the manual for a detailed explanation
 * of how arrays are implemented and used in PHP.
 *
 * @param mixed $array_or_countable An array or Countable object.
 * @param int $mode If the optional {@link mode} parameter is set to
 *   COUNT_RECURSIVE (or 1), {@link count} will recursively count the
 *   array. This is particularly useful for counting all the elements of
 *   a multidimensional array.
 * @return int Returns the number of elements in {@link
 *   array_or_countable}. When the parameter is neither an array nor an
 *   object with implemented Countable interface, 1 will be returned.
 *   There is one exception, if {@link array_or_countable} is NULL, 0
 *   will be returned.
 * @since PHP 4, PHP 5, PHP 7
 **/
function count($array_or_countable, $mode){}

/**
 * Return information about characters used in a string
 *
 * Counts the number of occurrences of every byte-value (0..255) in
 * {@link string} and returns it in various ways.
 *
 * @param string $string The examined string.
 * @param int $mode See return values.
 * @return mixed Depending on {@link mode} {@link count_chars} returns
 *   one of the following: 0 - an array with the byte-value as key and
 *   the frequency of every byte as value. 1 - same as 0 but only
 *   byte-values with a frequency greater than zero are listed. 2 - same
 *   as 0 but only byte-values with a frequency equal to zero are listed.
 *   3 - a string containing all unique characters is returned. 4 - a
 *   string containing all not used characters is returned.
 * @since PHP 4, PHP 5, PHP 7
 **/
function count_chars($string, $mode){}

/**
 * Performs an obscure check with the given password
 *
 * Performs an obscure check with the given password on the specified
 * dictionary. The alternative signature also takes into account the
 * username and the GECOS information.
 *
 * @param resource $dictionary The crack lib dictionary. If not
 *   specified, the last opened dictionary is used.
 * @param string $password The password to be checked.
 * @return bool Returns TRUE if {@link password} is strong, or FALSE
 *   otherwise.
 * @since PECL crack >= 0.1
 **/
function crack_check($dictionary, $password){}

/**
 * Closes an open CrackLib dictionary
 *
 * {@link crack_closedict} closes the specified {@link dictionary}
 * identifier.
 *
 * @param resource $dictionary The dictionary to close. If not
 *   specified, the current dictionary is closed.
 * @return bool
 * @since PECL crack >= 0.1
 **/
function crack_closedict($dictionary){}

/**
 * Returns the message from the last obscure check
 *
 * {@link crack_getlastmessage} returns the message from the last obscure
 * check.
 *
 * @return string The message from the last obscure check or FALSE if
 *   there was no obscure checks made so far.
 * @since PECL crack >= 0.1
 **/
function crack_getlastmessage(){}

/**
 * Opens a new CrackLib dictionary
 *
 * {@link crack_opendict} opens the specified CrackLib {@link dictionary}
 * for use with {@link crack_check}.
 *
 * @param string $dictionary The path to the Cracklib dictionary.
 * @return resource Returns a dictionary resource identifier on
 *   success.
 * @since PECL crack >= 0.1
 **/
function crack_opendict($dictionary){}

/**
 * Calculates the crc32 polynomial of a string
 *
 * Generates the cyclic redundancy checksum polynomial of 32-bit lengths
 * of the {@link str}. This is usually used to validate the integrity of
 * data being transmitted.
 *
 * @param string $str The data.
 * @return int Returns the crc32 checksum of {@link str} as an integer.
 * @since PHP 4 >= 4.0.1, PHP 5, PHP 7
 **/
function crc32($str){}

/**
 * Create an anonymous (lambda-style) function
 *
 * Creates an anonymous function from the parameters passed, and returns
 * a unique name for it.
 *
 * @param string $args The function arguments.
 * @param string $code The function code.
 * @return string Returns a unique function name as a string, or FALSE
 *   on error.
 * @since PHP 4 >= 4.0.1, PHP 5, PHP 7
 **/
function create_function($args, $code){}

/**
 * One-way string hashing
 *
 * {@link crypt} will return a hashed string using the standard Unix
 * DES-based algorithm or alternative algorithms that may be available on
 * the system.
 *
 * The {@link salt} parameter is optional. However, {@link crypt} creates
 * a weak hash without the {@link salt}. PHP 5.6 or later raise an
 * E_NOTICE error without it. Make sure to specify a strong enough salt
 * for better security.
 *
 * {@link password_hash} uses a strong hash, generates a strong salt, and
 * applies proper rounds automatically. {@link password_hash} is a simple
 * {@link crypt} wrapper and compatible with existing password hashes.
 * Use of {@link password_hash} is encouraged.
 *
 * Some operating systems support more than one type of hash. In fact,
 * sometimes the standard DES-based algorithm is replaced by an MD5-based
 * algorithm. The hash type is triggered by the salt argument. Prior to
 * 5.3, PHP would determine the available algorithms at install-time
 * based on the system's crypt(). If no salt is provided, PHP will
 * auto-generate either a standard two character (DES) salt, or a twelve
 * character (MD5), depending on the availability of MD5 crypt(). PHP
 * sets a constant named CRYPT_SALT_LENGTH which indicates the longest
 * valid salt allowed by the available hashes.
 *
 * The standard DES-based {@link crypt} returns the salt as the first two
 * characters of the output. It also only uses the first eight characters
 * of {@link str}, so longer strings that start with the same eight
 * characters will generate the same result (when the same salt is used).
 *
 * @param string $str The string to be hashed.
 * @param string $salt An optional salt string to base the hashing on.
 *   If not provided, the behaviour is defined by the algorithm
 *   implementation and can lead to unexpected results.
 * @return string Returns the hashed string or a string that is shorter
 *   than 13 characters and is guaranteed to differ from the salt on
 *   failure.
 * @since PHP 4, PHP 5, PHP 7
 **/
function crypt($str, $salt){}

/**
 * Check for alphanumeric character(s)
 *
 * Checks if all of the characters in the provided string, {@link text},
 * are alphanumeric.
 *
 * @param string $text The tested string.
 * @return bool Returns TRUE if every character in {@link text} is
 *   either a letter or a digit, FALSE otherwise.
 * @since PHP 4 >= 4.0.4, PHP 5, PHP 7
 **/
function ctype_alnum($text){}

/**
 * Check for alphabetic character(s)
 *
 * Checks if all of the characters in the provided string, {@link text},
 * are alphabetic. In the standard C locale letters are just [A-Za-z] and
 * {@link ctype_alpha} is equivalent to (ctype_upper($text) ||
 * ctype_lower($text)) if $text is just a single character, but other
 * languages have letters that are considered neither upper nor lower
 * case.
 *
 * @param string $text The tested string.
 * @return bool Returns TRUE if every character in {@link text} is a
 *   letter from the current locale, FALSE otherwise.
 * @since PHP 4 >= 4.0.4, PHP 5, PHP 7
 **/
function ctype_alpha($text){}

/**
 * Check for control character(s)
 *
 * Checks if all of the characters in the provided string, {@link text},
 * are control characters. Control characters are e.g. line feed, tab,
 * escape.
 *
 * @param string $text The tested string.
 * @return bool Returns TRUE if every character in {@link text} is a
 *   control character from the current locale, FALSE otherwise.
 * @since PHP 4 >= 4.0.4, PHP 5, PHP 7
 **/
function ctype_cntrl($text){}

/**
 * Check for numeric character(s)
 *
 * Checks if all of the characters in the provided string, {@link text},
 * are numerical.
 *
 * @param string $text The tested string.
 * @return bool Returns TRUE if every character in the string {@link
 *   text} is a decimal digit, FALSE otherwise.
 * @since PHP 4 >= 4.0.4, PHP 5, PHP 7
 **/
function ctype_digit($text){}

/**
 * Check for any printable character(s) except space
 *
 * Checks if all of the characters in the provided string, {@link text},
 * creates visible output.
 *
 * @param string $text The tested string.
 * @return bool Returns TRUE if every character in {@link text} is
 *   printable and actually creates visible output (no white space),
 *   FALSE otherwise.
 * @since PHP 4 >= 4.0.4, PHP 5, PHP 7
 **/
function ctype_graph($text){}

/**
 * Check for lowercase character(s)
 *
 * Checks if all of the characters in the provided string, {@link text},
 * are lowercase letters.
 *
 * @param string $text The tested string.
 * @return bool Returns TRUE if every character in {@link text} is a
 *   lowercase letter in the current locale.
 * @since PHP 4 >= 4.0.4, PHP 5, PHP 7
 **/
function ctype_lower($text){}

/**
 * Check for printable character(s)
 *
 * Checks if all of the characters in the provided string, {@link text},
 * are printable.
 *
 * @param string $text The tested string.
 * @return bool Returns TRUE if every character in {@link text} will
 *   actually create output (including blanks). Returns FALSE if {@link
 *   text} contains control characters or characters that do not have any
 *   output or control function at all.
 * @since PHP 4 >= 4.0.4, PHP 5, PHP 7
 **/
function ctype_print($text){}

/**
 * Check for any printable character which is not whitespace or an
 * alphanumeric character
 *
 * Checks if all of the characters in the provided string, {@link text},
 * are punctuation character.
 *
 * @param string $text The tested string.
 * @return bool Returns TRUE if every character in {@link text} is
 *   printable, but neither letter, digit or blank, FALSE otherwise.
 * @since PHP 4 >= 4.0.4, PHP 5, PHP 7
 **/
function ctype_punct($text){}

/**
 * Check for whitespace character(s)
 *
 * Checks if all of the characters in the provided string, {@link text},
 * creates whitespace.
 *
 * @param string $text The tested string.
 * @return bool Returns TRUE if every character in {@link text} creates
 *   some sort of white space, FALSE otherwise. Besides the blank
 *   character this also includes tab, vertical tab, line feed, carriage
 *   return and form feed characters.
 * @since PHP 4 >= 4.0.4, PHP 5, PHP 7
 **/
function ctype_space($text){}

/**
 * Check for uppercase character(s)
 *
 * Checks if all of the characters in the provided string, {@link text},
 * are uppercase characters.
 *
 * @param string $text The tested string.
 * @return bool Returns TRUE if every character in {@link text} is an
 *   uppercase letter in the current locale.
 * @since PHP 4 >= 4.0.4, PHP 5, PHP 7
 **/
function ctype_upper($text){}

/**
 * Check for character(s) representing a hexadecimal digit
 *
 * Checks if all of the characters in the provided string, {@link text},
 * are hexadecimal 'digits'.
 *
 * @param string $text The tested string.
 * @return bool Returns TRUE if every character in {@link text} is a
 *   hexadecimal 'digit', that is a decimal digit or a character from
 *   [A-Fa-f] , FALSE otherwise.
 * @since PHP 4 >= 4.0.4, PHP 5, PHP 7
 **/
function ctype_xdigit($text){}

/**
 * Return the number of rows affected by the last SQL statement
 *
 * The {@link cubrid_affected_rows} function is used to get the number of
 * rows affected by the SQL statement (INSERT, DELETE, UPDATE).
 *
 * @param resource $conn_identifier The CUBRID connection. If the
 *   connection identifier is not specified, the last link opend by
 *   {@link cubrid_connect} is assumed.
 * @return int Number of rows affected by the SQL statement, when
 *   process is successful.
 * @since PECL CUBRID >= 8.3.0
 **/
function cubrid_affected_rows($conn_identifier){}

/**
 * Bind variables to a prepared statement as parameters
 *
 * The {@link cubrid_bind} function is used to bind values to a
 * corresponding named or question mark placeholder in the SQL statement
 * that was passed to {@link cubrid_prepare}. If {@link bind_value_type}
 * is not given, string will be the default.
 *
 * The following table shows the types of substitute values.
 *
 * CUBRID Bind Date Types Support Bind Type Corresponding SQL Type
 * Supported STRING CHAR, VARCHAR NCHAR NCHAR, NVARCHAR BIT BIT, VARBIT
 * NUMERIC or NUMBER SHORT, INT, NUMERIC FLOAT FLOAT DOUBLE DOUBLE TIME
 * TIME DATE DATE TIMESTAMP TIMESTAMP OBJECT OBJECT ENUM ENUM BLOB BLOB
 * CLOB CLOB NULL NULL Not supported SET SET MULTISET MULTISET SEQUENCE
 * SEQUENCE
 *
 * @param resource $req_identifier Request identifier as a result of
 *   {@link cubrid_prepare}.
 * @param int $bind_index Location of binding parameters. It starts
 *   with 1.
 * @param mixed $bind_value Actual value for binding.
 * @param string $bind_value_type A type of the value to bind. (It is
 *   omitted by default. Thus, the system internally uses string by
 *   default. However, you need to specify the exact type of the value as
 *   an argument when they are NCHAR, BIT, or BLOB/CLOB).
 * @return bool TRUE, when process is successful.
 * @since PECL CUBRID >= 8.3.0
 **/
function cubrid_bind($req_identifier, $bind_index, $bind_value, $bind_value_type){}

/**
 * Return the current CUBRID connection charset
 *
 * This function returns the current CUBRID connection charset and is
 * similar to the CUBRID function {@link cubrid_get_charset}.
 *
 * @param resource $conn_identifier The CUBRID connection. If the
 *   connection identifier is not specified, the last link opened by
 *   {@link cubrid_connect} is assumed.
 * @return string A string that represents the CUBRID connection
 *   charset; on success.
 * @since PECL CUBRID >= 8.3.1
 **/
function cubrid_client_encoding($conn_identifier){}

/**
 * Close CUBRID connection
 *
 * The {@link cubrid_close} function ends the transaction currently in
 * process, closes the connection handle and disconnects from server. If
 * there is any request handles not closed yet at this point, they will
 * be closed. It is similar to the CUBRID function {@link
 * cubrid_disconnect}.
 *
 * @param resource $conn_identifier The CUBRID connection identifier.
 *   If the connection identifier is not specified, the last connection
 *   opened by {@link cubrid_connect} is assumed.
 * @return bool TRUE, when process is successful.
 * @since PECL CUBRID >= 8.3.1
 **/
function cubrid_close($conn_identifier){}

/**
 * Close the request handle
 *
 * The {@link cubrid_close_prepare} function closes the request handle
 * given by the {@link req_identifier} argument, and releases the memory
 * region related to the handle. It is an alias of {@link
 * cubrid_close_request}.
 *
 * @param resource $req_identifier Request identifier.
 * @return bool Return TRUE on success.
 * @since PECL CUBRID >= 8.3.0
 **/
function cubrid_close_prepare($req_identifier){}

/**
 * Close the request handle
 *
 * The {@link cubrid_close_request} function closes the request handle
 * given by the {@link req_identifier} argument, and releases the memory
 * region related to the handle. It is an alias of {@link
 * cubrid_close_prepare}.
 *
 * @param resource $req_identifier Request identifier.
 * @return bool Return TRUE on success.
 * @since PECL CUBRID >= 8.3.0
 **/
function cubrid_close_request($req_identifier){}

/**
 * Get the column names in result
 *
 * The {@link cubrid_column_names} function is used to get the column
 * names of the query result by using {@link req_identifier}.
 *
 * @param resource $req_identifier Request identifier.
 * @return array Array of string values containing the column names,
 *   when process is successful.
 * @since PECL CUBRID >= 8.3.0
 **/
function cubrid_column_names($req_identifier){}

/**
 * Get column types in result
 *
 * The {@link cubrid_column_types} function gets column types of query
 * results by using {@link req_identifier}.
 *
 * @param resource $req_identifier Request identifier.
 * @return array Array of string values containing the column types,
 *   when process is successful.
 * @since PECL CUBRID >= 8.3.0
 **/
function cubrid_column_types($req_identifier){}

/**
 * Get contents of collection type column using OID
 *
 * The {@link cubrid_col_get} function is used to get contents of the
 * elements of the collection type (set, multiset, sequence) attribute
 * you requested as an array.
 *
 * @param resource $conn_identifier Connection identifier.
 * @param string $oid OID of the instance that you want to read.
 * @param string $attr_name Attribute name that you want to read from
 *   the instance.
 * @return array Array (0-based numerical array) containing the
 *   elements you requested, when process is successful;
 * @since PECL CUBRID >= 8.3.0
 **/
function cubrid_col_get($conn_identifier, $oid, $attr_name){}

/**
 * Get the number of elements in collection type column using OID
 *
 * The {@link cubrid_col_size} function is used to get the number of
 * elements in a collection type (set, multiset, sequence) attribute.
 *
 * @param resource $conn_identifier Connection identifier.
 * @param string $oid OID the instance that you want to work with.
 * @param string $attr_name Name of the attribute that you want to work
 *   with.
 * @return int Number of elements, when process is successful.
 * @since PECL CUBRID >= 8.3.0
 **/
function cubrid_col_size($conn_identifier, $oid, $attr_name){}

/**
 * Commit a transaction
 *
 * The {@link cubrid_commit} function is used to execute commit on the
 * transaction pointed by {@link conn_identifier}, currently in progress.
 * Connection to the server is closed after the {@link cubrid_commit}
 * function is called; However, the connection handle is still valid.
 *
 * In CUBRID PHP, auto-commit mode is disabled by default for transaction
 * management. You can set it by using {@link cubrid_set_autocommit}. You
 * can get its status by using {@link cubrid_get_autocommit}. Before you
 * start a transaction, remember to disable the auto-commit mode.
 *
 * @param resource $conn_identifier Connection identifier.
 * @return bool TRUE, when process is successful.
 * @since PECL CUBRID >= 8.3.0
 **/
function cubrid_commit($conn_identifier){}

/**
 * Open a connection to a CUBRID Server
 *
 * The {@link cubrid_connect} function is used to establish the
 * environment for connecting to your server by using your server
 * address, port number, database name, user name, and password. If the
 * user name and password is not given, then the "PUBLIC" connection will
 * be made by default.
 *
 * @param string $host Host name or IP address of CUBRID CAS server.
 * @param int $port Port number of CUBRID CAS server (BROKER_PORT
 *   configured in $CUBRID/conf/cubrid_broker.conf).
 * @param string $dbname Name of database.
 * @param string $userid User name for the database. If not given, the
 *   default value is "public".
 * @param string $passwd User password. If not given, the default value
 *   is "".
 * @param bool $new_link If a second call is made to {@link
 *   cubrid_connect} with the same arguments, no new connection will be
 *   established, but instead, the connection identifier of the already
 *   opened connection will be returned. The {@link new_link} parameter
 *   modifies this behavior and makes {@link cubrid_connect} always open
 *   a new connection, even if {@link cubrid_connect} was called before
 *   with the same parameters.
 * @return resource Connection identifier, when process is successful.
 * @since PECL CUBRID >= 8.3.1
 **/
function cubrid_connect($host, $port, $dbname, $userid, $passwd, $new_link){}

/**
 * Establish the environment for connecting to CUBRID server
 *
 * The {@link cubrid_connect_with_url} function is used to establish the
 * environment for connecting to your server by using connection
 * information passed with an url string argument. If the HA feature is
 * enabled in CUBRID, you must specify the connection information of the
 * standby server, which is used for failover when failure occurs, in the
 * url string argument of this function. If the user name and password is
 * not given, then the "PUBLIC" connection will be made by default.
 *
 * <url> ::=
 * CUBRID:<host>:<db_name>:<db_user>:<db_password>:[?<properties>]
 *
 * <properties> ::= <property> [&<property>]
 *
 * <properties> ::= alhosts=<alternative_hosts>[ &rctime=<time>]
 *
 * <properties> ::= login_timeout=<milli_sec>
 *
 * <properties> ::= query_timeout=<milli_sec>
 *
 * <properties> ::= disconnect_on_query_timeout=true|false
 *
 * <alternative_hosts> ::= <standby_broker1_host>:<port>
 * [,<standby_broker2_host>:<port>]
 *
 * <host> := HOSTNAME | IP_ADDR
 *
 * <time> := SECOND
 *
 * <milli_sec> := MILLI SECOND
 *
 * host : A host name or IP address of the master database db_name : A
 * name of the database db_user : A name of the database user db_password
 * : A database user password alhosts : Specifies the broker information
 * of the standby server, which is used for failover when it is
 * impossible to connect to the active server. You can specify multiple
 * brokers for failover, and the connection to the brokers is attempted
 * in the order listed in alhosts rctime : An interval between the
 * attempts to connect to the active broker in which failure occurred.
 * After a failure occurs, the system connects to the broker specified by
 * althosts (failover), terminates the transaction, and then attempts to
 * connect to the active broker of the master database at every rctime.
 * The default value is 600 seconds. login_timeout : Timeout value (unit:
 * msec.) for database login. The default value is 0, which means
 * infinite postponement. query_timeout : Timeout value (unit: msec.) for
 * query request. Upon timeout, a message to cancel requesting a query
 * transferred to server is sent. The return value can depend on the
 * disconnect_on_query_timeout configuration; even though the message to
 * cancel a request is sent to server, that request may succeed.
 * disconnect_on_query_timeout : Configures a value whether to
 * immediately return an error of function being executed upon timeout.
 * The default value is false.
 *
 * @param string $conn_url A character string that contains server
 *   connection information.
 * @param string $userid User name for the database.
 * @param string $passwd User password.
 * @param bool $new_link If a second call is made to {@link
 *   cubrid_connect_with_url} with the same arguments, no new connection
 *   will be established, but instead, the connection identifier of the
 *   already opened connection will be returned. The {@link new_link}
 *   parameter modifies this behavior and makes {@link
 *   cubrid_connect_with_url} always open a new connection, even if
 *   {@link cubrid_connect_with_url} was called before with the same
 *   parameters.
 * @return resource Connection identifier, when process is successful.
 **/
function cubrid_connect_with_url($conn_url, $userid, $passwd, $new_link){}

/**
 * Get OID of the current cursor location
 *
 * The {@link cubrid_current_oid} function is used to get the oid of the
 * current cursor location from the query result. To use {@link
 * cubrid_current_oid}, the query executed must be a updatable query, and
 * the CUBRID_INCLUDE_OID option must be included during the query
 * execution.
 *
 * @param resource $req_identifier Request identifier.
 * @return string Oid of current cursor location, when process is
 *   successful
 * @since PECL CUBRID >= 8.3.0
 **/
function cubrid_current_oid($req_identifier){}

/**
 * Move the internal row pointer of the CUBRID result
 *
 * This function performs the moving of the internal row pointer of the
 * CUBRID result (associated with the specified result identifier) to
 * point to a specific row number. There are functions, such as {@link
 * cubrid_fetch_assoc}, which use the current stored value of {@link row
 * number}.
 *
 * @param resource $result The result.
 * @param int $row_number This is the desired row number of the new
 *   result pointer.
 * @return bool Returns TRUE on success or FALSE on failure.
 * @since PECL CUBRID >= 8.3.0
 **/
function cubrid_data_seek($result, $row_number){}

/**
 * Get db name from results of cubrid_list_dbs
 *
 * Retrieve the database name from a call to {@link cubrid_list_dbs}.
 *
 * @param array $result The result pointer from a call to {@link
 *   cubrid_list_dbs}.
 * @param int $index The index into the result set.
 * @return string Returns the database name on success, and FALSE on
 *   failure. If FALSE is returned, use {@link cubrid_error} to determine
 *   the nature of the error.
 * @since PECL CUBRID >= 8.3.1
 **/
function cubrid_db_name($result, $index){}

/**
 * Close a database connection
 *
 * The {@link cubrid_disconnect} function closes the connection handle
 * and disconnects from server. If any request handle is not closed at
 * this point, it will be closed. It is similar to the CUBRID MySQL
 * compatible function {@link cubrid_close}.
 *
 * @param resource $conn_identifier Connection identifier.
 * @return bool TRUE, when process is successful.
 * @since PECL CUBRID >= 8.3.0
 **/
function cubrid_disconnect($conn_identifier){}

/**
 * Delete an instance using OID
 *
 * The {@link cubrid_drop} function is used to delete an instance from
 * database by using the {@link oid} of the instance.
 *
 * @param resource $conn_identifier Connection identifier.
 * @param string $oid Oid of the instance that you want to delete.
 * @return bool TRUE, when process is successful.
 * @since PECL CUBRID >= 8.3.0
 **/
function cubrid_drop($conn_identifier, $oid){}

/**
 * Return the numerical value of the error message from previous CUBRID
 * operation
 *
 * Returns the error number from the last CUBRID function.
 *
 * The {@link cubrid_errno} function is used to get the error code of the
 * error that occurred during the API execution. Usually, it gets the
 * error code when API returns false as its return value.
 *
 * @param resource $conn_identifier The CUBRID connection identifier.
 *   If the connection identifier is not specified, the last connection
 *   opened by {@link cubrid_connect} is assumed.
 * @return int Returns the error number from the last CUBRID function,
 *   or 0 (zero) if no error occurred.
 * @since PECL CUBRID >= 8.3.1
 **/
function cubrid_errno($conn_identifier){}

/**
 * Get the error message
 *
 * The {@link cubrid_error} function is used to get the error message
 * that occurred during the use of CUBRID API. Usually, it gets error
 * message when API returns false as its return value.
 *
 * @param resource $connection The CUBRID connection.
 * @return string Error message that occurred.
 * @since PECL CUBRID >= 8.3.1
 **/
function cubrid_error($connection){}

/**
 * Get error code for the most recent function call
 *
 * The {@link cubrid_error_code} function is used to get the error code
 * of the error that occurred during the API execution. Usually, it gets
 * the error code when API returns false as its return value.
 *
 * @return int Error code of the error that occurred, or 0 (zero) if no
 *   error occurred.
 * @since PECL CUBRID >= 8.3.0
 **/
function cubrid_error_code(){}

/**
 * Get the facility code of error
 *
 * The {@link cubrid_error_code_facility} function is used to get the
 * facility code (level in which the error occurred) from the error code
 * of the error that occurred during the API execution. Usually, you can
 * get the error code when API returns false as its return value.
 *
 * @return int Facility code of the error code that occurred:
 *   CUBRID_FACILITY_DBMS, CUBRID_FACILITY_CAS, CUBRID_FACILITY_CCI,
 *   CUBRID_FACILITY_CLIENT
 * @since PECL CUBRID >= 8.3.0
 **/
function cubrid_error_code_facility(){}

/**
 * Get last error message for the most recent function call
 *
 * The {@link cubrid_error_msg} function is used to get the error message
 * that occurred during the use of CUBRID API. Usually, it gets error
 * message when API returns false as its return value.
 *
 * @return string Error message that occurred.
 * @since PECL CUBRID >= 8.3.0
 **/
function cubrid_error_msg(){}

/**
 * Execute a prepared SQL statement
 *
 * The {@link cubrid_execute} function is used to execute the given SQL
 * statement. It executes the query by using {@link conn_identifier} and
 * SQL, and then returns the request identifier created. It is used for
 * simple execution of query, where the parameter binding is not needed.
 * In addition, the {@link cubrid_execute} function is used to execute
 * the prepared statement by means of {@link cubrid_prepare} and {@link
 * cubrid_bind}. At this time, you need to specify arguments of {@link
 * request_identifier} and {@link option}.
 *
 * The {@link option} is used to determine whether to get OID after query
 * execution and whether to execute the query in synchronous or
 * asynchronous mode. CUBRID_INCLUDE_OID and CUBRID_ASYNC (or
 * CUBRID_EXEC_QUERY_ALL if you want to execute multiple SQL statements)
 * can be specified by using a bitwise OR operator. If not specified,
 * neither of them isselected. If the flag CUBRID_EXEC_QUERY_ALL is set,
 * a synchronous mode (sync_mode) is used to retrieve query results, and
 * in such cases the following rules are applied:
 *
 * The return value is the result of the first query. If an error occurs
 * in any query, the execution is processed as a failure. In a query
 * composed of q1 q2 q3, if an error occurs in q2 after q1 succeeds the
 * execution, the result of q1 remains valid. That is, the previous
 * successful query executions are not rolled back when an error occurs.
 * If a query is executed successfully, the result of the second query
 * can be obtained using {@link cubrid_next_result}.
 *
 * If the first argument is {@link request_identifier} to execute the
 * {@link cubrid_prepare} function, you can specify an option,
 * CUBRID_ASYNC only.
 *
 * @param resource $conn_identifier Connection identifier.
 * @param string $sql SQL to be executed.
 * @param int $option Query execution option CUBRID_INCLUDE_OID,
 *   CUBRID_ASYNC, CUBRID_EXEC_QUERY_ALL.
 * @return resource Request identifier, when process is successful and
 *   first param is conn_identifier; TRUE, when process is successful and
 *   first argument is request_identifier.
 * @since PECL CUBRID >= 8.3.0
 **/
function cubrid_execute($conn_identifier, $sql, $option){}

/**
 * Fetch the next row from a result set
 *
 * The {@link cubrid_fetch} function is used to get a single row from the
 * query result. The cursor automatically moves to the next row after
 * getting the result.
 *
 * @param resource $result {@link result} comes from a call to {@link
 *   cubrid_execute}
 * @param int $type Array type of the fetched result CUBRID_NUM,
 *   CUBRID_ASSOC, CUBRID_BOTH, CUBRID_OBJECT. If you want to operate the
 *   lob object, you can use CUBRID_LOB.
 * @return mixed Result array or object, when process is successful.
 * @since PECL CUBRID >= 8.3.0
 **/
function cubrid_fetch($result, $type){}

/**
 * Fetch a result row as an associative array, a numeric array, or both
 *
 * The {@link cubrid_fetch_array} function is used to get a single row
 * from the query result and returns an array. The cursor automatically
 * moves to the next row after getting the result.
 *
 * @param resource $result {@link Result} comes from a call to {@link
 *   cubrid_execute}
 * @param int $type Array type of the fetched result CUBRID_NUM,
 *   CUBRID_ASSOC, CUBRID_BOTH. If you need to operate the lob object,
 *   you can use CUBRID_LOB.
 * @return array Returns an array of strings that corresponds to the
 *   fetched row, when process is successful.
 * @since PECL CUBRID >=8.3.0
 **/
function cubrid_fetch_array($result, $type){}

/**
 * Return the associative array that corresponds to the fetched row
 *
 * This function returns the associative array, that corresponds to the
 * fetched row, and then moves the internal data pointer ahead, or
 * returns FALSE when the end is reached.
 *
 * @param resource $result {@link result} comes from a call to {@link
 *   cubrid_execute}
 * @param int $type Type can only be CUBRID_LOB, this parameter will be
 *   used only when you need to operate the lob object.
 * @return array Associative array, when process is successful.
 * @since PECL CUBRID >= 8.3.0
 **/
function cubrid_fetch_assoc($result, $type){}

/**
 * Get column information from a result and return as an object
 *
 * This function returns an object with certain properties of the
 * specific column. The properties of the object are:
 *
 * {@link name} column name {@link table} name of the table that the
 * column belongs to {@link def} default value of the column {@link
 * max_length} maximum length of the column {@link not_null} 1 if the
 * column cannot be NULL {@link primary_key} 1 if the column is a primary
 * key {@link unique_key} 1 if the column is an unique key {@link
 * multiple_key} 1 if the column is a non-unique key {@link numeric} 1 if
 * the column is numeric {@link blob} 1 if the column is a BLOB {@link
 * type} the type of the column {@link unsigned} 1 if the column is
 * unsigned {@link zerofill} 1 if the column is zero-filled
 *
 * @param resource $result {@link result} comes from a call to {@link
 *   cubrid_execute}
 * @param int $field_offset The numerical field offset. If the field
 *   offset is not specified, the next field (that was not yet retrieved
 *   by this function) is retrieved. The {@link field_offset} starts at
 *   0.
 * @return object Object with certain properties of the specific
 *   column, when process is successful.
 * @since PECL CUBRID >= 8.3.1
 **/
function cubrid_fetch_field($result, $field_offset){}

/**
 * Return an array with the lengths of the values of each field from the
 * current row
 *
 * This function returns an numeric array with the lengths of the values
 * of each field from the current row of the result set or it returns
 * FALSE on failure.
 *
 * @param resource $result {@link result} comes from a call to {@link
 *   cubrid_execute}
 * @return array An numeric array, when process is successful.
 * @since PECL CUBRID >= 8.3.0
 **/
function cubrid_fetch_lengths($result){}

/**
 * Fetch the next row and return it as an object
 *
 * This function returns an object with the column names of the result
 * set as properties. The values of these properties are extracted from
 * the current row of the result.
 *
 * @param resource $result {@link result} comes from a call to {@link
 *   cubrid_execute}
 * @param string $class_name The name of the class to instantiate. If
 *   not specified, a stdClass (stdClass is PHP's generic empty class
 *   that's used when casting other types to objects) object is returned.
 * @param array $params An optional array of parameters to pass to the
 *   constructor for {@link class_name} objects.
 * @param int $type Type can only be CUBRID_LOB, this parameter will be
 *   used only when you need to operate the lob object.
 * @return object An object, when process is successful.
 * @since PECL CUBRID >= 8.3.0
 **/
function cubrid_fetch_object($result, $class_name, $params, $type){}

/**
 * Return a numerical array with the values of the current row
 *
 * This function returns a numerical array with the values of the current
 * row from the result set, starting from 0, and moves the internal data
 * pointer ahead.
 *
 * @param resource $result {@link result} comes from a call to {@link
 *   cubrid_execute}
 * @param int $type Type can only be CUBRID_LOB, this parameter will be
 *   used only when you need to operate the lob object.
 * @return array A numerical array, when process is successful.
 * @since PECL CUBRID >= 8.3.0
 **/
function cubrid_fetch_row($result, $type){}

/**
 * Return a string with the flags of the given field offset
 *
 * This function returns a string with the flags of the given field
 * offset separated by space. You can split the returned value using
 * explode. The possible flags could be: not_null, primary_key,
 * unique_key, foreign_key, auto_increment, shared, reverse_index,
 * reverse_unique and timestamp.
 *
 * @param resource $result {@link result} comes from a call to {@link
 *   cubrid_execute}
 * @param int $field_offset The numerical field offset. The {@link
 *   field_offset} starts at 0. If {@link field_offset} does not exist,
 *   an error of level E_WARNING is also issued.
 * @return string A string with flags, when process is successful.
 * @since PECL CUBRID >= 8.3.0
 **/
function cubrid_field_flags($result, $field_offset){}

/**
 * Get the maximum length of the specified field
 *
 * This function returns the maximum length of the specified field on
 * success, or it returns FALSE on failure.
 *
 * @param resource $result {@link result} comes from a call to {@link
 *   cubrid_execute}
 * @param int $field_offset The numerical field offset. The {@link
 *   field_offset} starts at 0. If {@link field_offset} does not exist,
 *   an error of level E_WARNING is also issued.
 * @return int Maximum length, when process is successful.
 * @since PECL CUBRID >= 8.3.0
 **/
function cubrid_field_len($result, $field_offset){}

/**
 * Return the name of the specified field index
 *
 * This function returns the name of the specified field index on success
 * or it returns FALSE on failure.
 *
 * @param resource $result {@link result} comes from a call to {@link
 *   cubrid_execute}
 * @param int $field_offset The numerical field offset. The {@link
 *   field_offset} starts at 0. If {@link field_offset} does not exist,
 *   an error of level E_WARNING is also issued.
 * @return string Name of specified field index, on success.
 * @since PECL CUBRID >= 8.3.0
 **/
function cubrid_field_name($result, $field_offset){}

/**
 * Move the result set cursor to the specified field offset
 *
 * This function moves the result set cursor to the specified field
 * offset. This offset is used by {@link cubrid_fetch_field} if it
 * doesn't include a field offset. It returns TRUE on success or FALSE on
 * failure.
 *
 * @param resource $result {@link result} comes from a call to {@link
 *   cubrid_execute}
 * @param int $field_offset The numerical field offset. The {@link
 *   field_offset} starts at 0. If {@link field_offset} does not exist,
 *   an error of level E_WARNING is also issued.
 * @return bool TRUE on success.
 * @since PECL CUBRID >= 8.3.0
 **/
function cubrid_field_seek($result, $field_offset){}

/**
 * Return the name of the table of the specified field
 *
 * This function returns the name of the table of the specified field.
 * This is useful when using large select queries with JOINS.
 *
 * @param resource $result {@link result} comes from a call to {@link
 *   cubrid_execute}
 * @param int $field_offset The numerical field offset. The {@link
 *   field_offset} starts at 0. If {@link field_offset} does not exist,
 *   an error of level E_WARNING is also issued.
 * @return string Name of the table of the specified field, on success.
 * @since PECL CUBRID >= 8.3.0
 **/
function cubrid_field_table($result, $field_offset){}

/**
 * Return the type of the column corresponding to the given field offset
 *
 * This function returns the type of the column corresponding to the
 * given field offset. The returned field type could be one of the
 * following: "int", "real", "string", etc.
 *
 * @param resource $result {@link result} comes from a call to {@link
 *   cubrid_execute}
 * @param int $field_offset The numerical field offset. The {@link
 *   field_offset} starts at 0. If {@link field_offset} does not exist,
 *   an error of level E_WARNING is also issued.
 * @return string Type of the column, on success.
 * @since PECL CUBRID >= 8.3.0
 **/
function cubrid_field_type($result, $field_offset){}

/**
 * Free the memory occupied by the result data
 *
 * This function frees the memory occupied by the result data. It returns
 * TRUE on success or FALSE on failure. Note that it can only frees the
 * client fetch buffer now, and if you want free all memory, use function
 * {@link cubrid_close_request}.
 *
 * @param resource $req_identifier This is the request identifier.
 * @return bool TRUE on success.
 * @since PECL CUBRID >= 8.3.0
 **/
function cubrid_free_result($req_identifier){}

/**
 * Get a column using OID
 *
 * The {@link cubrid_get} function is used to get the attribute of the
 * instance of the given {@link oid}. You can get single attribute by
 * using string data type for the {@link attr} argument, or many
 * attributes by using array data type for the {@link attr} argument.
 *
 * @param resource $conn_identifier Connection identifier.
 * @param string $oid OID of the instance that you want to read.
 * @param mixed $attr Name of the attribute that you want to read.
 * @return mixed Content of the requested attribute, when process is
 *   successful; When {@link attr} is set with string data type, the
 *   result is returned as a string; when {@link attr} is set with array
 *   data type (0-based numerical array), then the result is returned in
 *   associative array. When {@link attr} is omitted, then all attributes
 *   are received in array form.
 * @since PECL CUBRID >= 8.3.0
 **/
function cubrid_get($conn_identifier, $oid, $attr){}

/**
 * Get auto-commit mode of the connection
 *
 * The {@link cubrid_get_autocommit} function is used to get the status
 * of CUBRID database connection auto-commit mode.
 *
 * For CUBRID 8.4.0, auto-commit mode is disabled by default for
 * transaction management.
 *
 * For CUBRID 8.4.1, auto-commit mode is enabled by default for
 * transaction management.
 *
 * @param resource $conn_identifier Connection identifier.
 * @return bool TRUE, when auto-commit is on.
 * @since PECL CUBRID >= 8.4.0
 **/
function cubrid_get_autocommit($conn_identifier){}

/**
 * Return the current CUBRID connection charset
 *
 * This function returns the current CUBRID connection charset and is
 * similar to the CUBRID MySQL compatible function {@link
 * cubrid_client_encoding}.
 *
 * @param resource $conn_identifier The CUBRID connection.
 * @return string A string that represents the CUBRID connection
 *   charset; on success.
 * @since PECL CUBRID >= 8.3.0
 **/
function cubrid_get_charset($conn_identifier){}

/**
 * Get the class name using OID
 *
 * The {@link cubrid_get_class_name} function is used to get the class
 * name from {@link oid}. It doesn't work when selecting data from the
 * system tables, for example db_class.
 *
 * @param resource $conn_identifier Connection identifier.
 * @param string $oid OID of the instance that you want to check the
 *   existence.
 * @return string Class name when process is successful.
 * @since PECL CUBRID >= 8.3.0
 **/
function cubrid_get_class_name($conn_identifier, $oid){}

/**
 * Return the client library version
 *
 * This function returns a string that represents the client library
 * version.
 *
 * @return string A string that represents the client library version;
 *   on success.
 * @since PECL CUBRID >= 8.3.0
 **/
function cubrid_get_client_info(){}

/**
 * Returns the CUBRID database parameters
 *
 * This function returns the CUBRID database parameters or it returns
 * FALSE on failure. It returns an associative array with the values for
 * the following parameters:
 *
 * PARAM_ISOLATION_LEVEL PARAM_LOCK_TIMEOUT PARAM_MAX_STRING_LENGTH
 * PARAM_AUTO_COMMIT
 *
 * Database parameters Parameter Description PARAM_ISOLATION_LEVEL The
 * transaction isolation level. LOCK_TIMEOUT CUBRID provides the lock
 * timeout feature, which sets the waiting time (in seconds) for the lock
 * until the transaction lock setting is allowed. The default value of
 * the lock_timeout_in_secs parameter is -1, which means the application
 * client will wait indefinitely until the transaction lock is allowed.
 * PARAM_AUTO_COMMIT In CUBRID PHP, auto-commit mode is disabled by
 * default for transaction management. It can be set by using {@link
 * cubrid_set_autocommit}.
 *
 * The following table shows the isolation levels from 1 to 6. It
 * consists of table schema (row) and isolation level: Levels of
 * Isolation Supported by CUBRID Name Description SERIALIZABLE (6) In
 * this isolation level, problems concerning concurrency (e.g. dirty
 * read, non-repeatable read, phantom read, etc.) do not occur.
 * REPEATABLE READ CLASS with REPEATABLE READ INSTANCES (5) Another
 * transaction T2 cannot update the schema of table A while transaction
 * T1 is viewing table A. Transaction T1 may experience phantom read for
 * the record R that was inserted by another transaction T2 when it is
 * repeatedly retrieving a specific record. REPEATABLE READ CLASS with
 * READ COMMITTED INSTANCES (or CURSOR STABILITY) (4) Another transaction
 * T2 cannot update the schema of table A while transaction T1 is viewing
 * table A. Transaction T1 may experience R read (non-repeatable read)
 * that was updated and committed by another transaction T2 when it is
 * repeatedly retrieving the record R. REPEATABLE READ CLASS with READ
 * UNCOMMITTED INSTANCES (3) Default isolation level. Another transaction
 * T2 cannot update the schema of table A while transaction T1 is viewing
 * table A. Transaction T1 may experience R' read (dirty read) for the
 * record that was updated but not committed by another transaction T2.
 * READ COMMITTED CLASS with READ COMMITTED INSTANCES (2) Transaction T1
 * may experience A' read (non-repeatable read) for the table that was
 * updated and committed by another transaction T2 while it is viewing
 * table A repeatedly. Transaction T1 may experience R' read
 * (non-repeatable read) for the record that was updated and committed by
 * another transaction T2 while it is retrieving the record R repeatedly.
 * READ COMMITTED CLASS with READ UNCOMMITTED INSTANCES (1) Transaction
 * T1 may experience A' read (non-repeatable read) for the table that was
 * updated and committed by another transaction T2 while it is repeatedly
 * viewing table A. Transaction T1 may experience R' read (dirty read)
 * for the record that was updated but not committed by another
 * transaction T2.
 *
 * @param resource $conn_identifier The CUBRID connection. If the
 *   connection identifier is not specified, the last link opened by
 *   {@link cubrid_connect} is assumed.
 * @return array An associative array with CUBRID database parameters;
 *   on success.
 * @since PECL CUBRID >= 8.3.0
 **/
function cubrid_get_db_parameter($conn_identifier){}

/**
 * Get the query timeout value of the request
 *
 * The {@link cubrid_get_query_timeout} function is used to get the query
 * timeout of the request.
 *
 * @param resource $req_identifier Request identifier.
 * @return int Success: the query timeout value of the current request.
 *   Units of msec.
 * @since PECL CUBRID >= 8.4.1
 **/
function cubrid_get_query_timeout($req_identifier){}

/**
 * Return the CUBRID server version
 *
 * This function returns a string that represents the CUBRID server
 * version.
 *
 * @param resource $conn_identifier The CUBRID connection.
 * @return string A string that represents the CUBRID server version;
 *   on success.
 * @since PECL CUBRID >= 8.3.0
 **/
function cubrid_get_server_info($conn_identifier){}

/**
 * Return the ID generated for the last updated column
 *
 * The {@link cubrid_insert_id} function retrieves the ID generated for
 * the AUTO_INCREMENT column which is updated by the previous INSERT
 * query. It returns 0 if the previous query does not generate new rows,
 * or FALSE on failure.
 *
 * @param resource $conn_identifier The connection identifier
 *   previously obtained by a call to {@link cubrid_connect}.
 * @return string A string representing the ID generated for an
 *   AUTO_INCREMENT column by the previous query, on success.
 * @since PECL CUBRID >= 8.3.0
 **/
function cubrid_insert_id($conn_identifier){}

/**
 * Check whether the instance pointed by OID exists
 *
 * The {@link cubrid_is_instance} function is used to check whether the
 * instance pointed by the given {@link oid} exists or not.
 *
 * @param resource $conn_identifier Connection identifier.
 * @param string $oid OID of the instance that you want to check the
 *   existence.
 * @return int 1, if such instance exists;
 * @since PECL CUBRID >= 8.3.0
 **/
function cubrid_is_instance($conn_identifier, $oid){}

/**
 * Return an array with the list of all existing CUBRID databases
 *
 * This function returns an array with the list of all existing Cubrid
 * databases.
 *
 * @param resource $conn_identifier The CUBRID connection.
 * @return array An numeric array with all existing Cubrid databases;
 *   on success.
 * @since PECL CUBRID >= 8.3.0
 **/
function cubrid_list_dbs($conn_identifier){}

/**
 * Read data from a GLO instance and save it in a file
 *
 * The {@link cubrid_load_from_glo} function is used to read a data from
 * a glo instance, and saves it in a designated file.
 *
 * @param resource $conn_identifier Connection identifier.
 * @param string $oid Oid of the glo instance that you want to read the
 *   data from.
 * @param string $file_name Name of the file where you want to save the
 *   data in.
 * @return int TRUE, when process is successful.
 * @since PECL CUBRID >= 8.3.0
 **/
function cubrid_load_from_glo($conn_identifier, $oid, $file_name){}

/**
 * Bind a lob object or a string as a lob object to a prepared statement
 * as parameters
 *
 * The {@link cubrid_lob2_bind} function is used to bind BLOB/CLOB datas
 * to a corresponding question mark placeholder in the SQL statement that
 * was passed to {@link cubrid_prepare}. If {@link bind_value_type} is
 * not given, string will be "BLOB" as the default. But if you use {@link
 * cubrid_lob2_new} before, {@link bind_value_type} will be consistent
 * with {@link type} in {@link cubrid_lob2_new} as the default.
 *
 * @param resource $req_identifier Request identifier as a result of
 *   {@link cubrid_prepare}.
 * @param int $bind_index Location of binding parameters. It starts
 *   with 1.
 * @param mixed $bind_value Actual value for binding.
 * @param string $bind_value_type It must be "BLOB" or "CLOB" and it
 *   won't be case-sensitive. If it not be given, the default value is
 *   "BLOB".
 * @return bool TRUE, when process is successful.
 * @since PECL CUBRID >= 8.4.1
 **/
function cubrid_lob2_bind($req_identifier, $bind_index, $bind_value, $bind_value_type){}

/**
 * Close LOB object
 *
 * The {@link cubrid_lob2_close} function is used to close LOB object
 * returned from {@link cubrid_lob2_new} or got from the result set.
 *
 * @param resource $lob_identifier Lob identifier as a result of {@link
 *   cubrid_lob2_new} or get from the result set.
 * @return bool TRUE, on success.
 * @since PECL CUBRID >= 8.4.1
 **/
function cubrid_lob2_close($lob_identifier){}

/**
 * Export the lob object to a file
 *
 * The {@link cubrid_lob2_export} function is used to save the contents
 * of BLOB/CLOB data to a file. To use this function, you must use {@link
 * cubrid_lob2_new} or fetch a lob object from CUBRID database first. If
 * the file already exists, the operation will fail. This function will
 * not influence the cursor position of the lob object. It operates the
 * entire lob object.
 *
 * @param resource $lob_identifier Lob identifier as a result of {@link
 *   cubrid_lob2_new} or get from the result set.
 * @param string $file_name File name you want to store BLOB/CLOB data.
 *   It also supports the path of the file.
 * @return bool TRUE if the process is successful and FALSE for
 *   failure.
 * @since PECL CUBRID >= 8.4.1
 **/
function cubrid_lob2_export($lob_identifier, $file_name){}

/**
 * Import BLOB/CLOB data from a file
 *
 * The {@link cubrid_lob2_import} function is used to save the contents
 * of BLOB/CLOB data from a file. To use this function, you must use
 * {@link cubrid_lob2_new} or fetch a lob object from CUBRID database
 * first. If the file already exists, the operation will fail. This
 * function will not influence the cursor position of the lob object. It
 * operates the entire lob object.
 *
 * @param resource $lob_identifier Lob identifier as a result of {@link
 *   cubrid_lob2_new} or get from the result set.
 * @param string $file_name File name you want to import BLOB/CLOB
 *   data. It also supports the path of the file.
 * @return bool TRUE if the process is successful and FALSE for
 *   failure.
 * @since PECL CUBRID >= 8.4.1
 **/
function cubrid_lob2_import($lob_identifier, $file_name){}

/**
 * Create a lob object
 *
 * The {@link cubrid_lob2_new} function is used to create a lob object
 * (both BLOB and CLOB). This function should be used before you bind a
 * lob object.
 *
 * @param resource $conn_identifier Connection identifier. If the
 *   connection identifier is not specified, the last connection opened
 *   by {@link cubrid_connect} or {@link cubrid_connect_with_url} is
 *   assumed.
 * @param string $type It may be "BLOB" or "CLOB", it won't be
 *   case-sensitive. The default value is "BLOB".
 * @return resource Lob identifier when it is successful.
 * @since PECL CUBRID >= 8.4.1
 **/
function cubrid_lob2_new($conn_identifier, $type){}

/**
 * Read from BLOB/CLOB data
 *
 * The {@link cubrid_lob2_read} function reads {@link len} bytes from the
 * LOB data and returns the bytes read.
 *
 * @param resource $lob_identifier Lob identifier as a result of {@link
 *   cubrid_lob2_new} or get from the result set.
 * @param int $len Length from buffer you want to read from the lob
 *   data.
 * @return string Returns the contents as a string.
 * @since PECL CUBRID >= 8.4.1
 **/
function cubrid_lob2_read($lob_identifier, $len){}

/**
 * Move the cursor of a lob object
 *
 * The {@link cubrid_lob2_seek} function is used to move the cursor
 * position of a lob object by the value set in the {@link offset}
 * argument, to the direction set in the {@link origin} argument.
 *
 * To set the {@link origin} argument, you can use CUBRID_CURSOR_FIRST to
 * set the cursor position moving forward {@link offset} units from the
 * first beginning. In this case, {@link offset} must be a positive
 * value.
 *
 * If you use CUBRID_CURSOR_CURRENT for {@link origin}, you can move
 * forward or backward. and {@link offset} can be positive or negative.
 *
 * If you use CUBRID_CURSOR_LAST for {@link origin}, you can move
 * backward {@link offset} units from the end of LOB object and {@link
 * offset} only can be positive.
 *
 * @param resource $lob_identifier Lob identifier as a result of {@link
 *   cubrid_lob2_new} or get from the result set.
 * @param int $offset Number of units you want to move the cursor.
 * @param int $origin This parameter can be the following values:
 *   CUBRID_CURSOR_FIRST: move forward from the first beginning.
 *   CUBRID_CURSOR_CURRENT: move forward or backward from the current
 *   position. CUBRID_CURSOR_LAST: move backward at the end of LOB
 *   object.
 * @return bool TRUE if the process is successful and FALSE for
 *   failure.
 * @since PECL CUBRID >= 8.4.1
 **/
function cubrid_lob2_seek($lob_identifier, $offset, $origin){}

/**
 * Move the cursor of a lob object
 *
 * The {@link cubrid_lob2_seek64} function is used to move the cursor
 * position of a lob object by the value set in the {@link offset}
 * argument, to the direction set in the {@link origin} argument. If the
 * {@link offset} you want to move is larger than an integer data can be
 * stored, you can use this function.
 *
 * To set the {@link origin} argument, you can use CUBRID_CURSOR_FIRST to
 * set the cursor position moving forward {@link offset} units from the
 * first beginning. In this case, {@link offset} must be a positive
 * value.
 *
 * If you use CUBRID_CURSOR_CURRENT for {@link origin}, you can move
 * forward or backward. and {@link offset} can be positive or negative.
 *
 * If you use CUBRID_CURSOR_LAST for {@link origin}, you can move
 * backward {@link offset} units from the end of LOB object and {@link
 * offset} only can be positive.
 *
 * @param resource $lob_identifier Lob identifier as a result of {@link
 *   cubrid_lob2_new} or get from the result set.
 * @param string $offset Number of units you want to move the cursor.
 * @param int $origin This parameter can be the following values:
 *   CUBRID_CURSOR_FIRST: move forward from the first beginning.
 *   CUBRID_CURSOR_CURRENT: move forward or backward from the current
 *   position. CUBRID_CURSOR_LAST: move backward at the end of LOB
 *   object.
 * @return bool TRUE if the process is successful and FALSE for
 *   failure.
 * @since PECL CUBRID >= 8.4.1
 **/
function cubrid_lob2_seek64($lob_identifier, $offset, $origin){}

/**
 * Get a lob object's size
 *
 * The {@link cubrid_lob2_size} function is used to get the size of a lob
 * object.
 *
 * @param resource $lob_identifier Lob identifier as a result of {@link
 *   cubrid_lob2_new} or get from the result set.
 * @return int It will return the size of the LOB object when it
 *   processes successfully.
 * @since PECL CUBRID >= 8.4.1
 **/
function cubrid_lob2_size($lob_identifier){}

/**
 * Get a lob object's size
 *
 * The {@link cubrid_lob2_size64} function is used to get the size of a
 * lob object. If the size of a lob object is larger than an integer data
 * can be stored, you can use this function and it will return the size
 * as a string.
 *
 * @param resource $lob_identifier Lob identifier as a result of {@link
 *   cubrid_lob2_new} or get from the result set.
 * @return string It will return the size of the LOB object as a string
 *   when it processes successfully.
 * @since PECL CUBRID >= 8.4.1
 **/
function cubrid_lob2_size64($lob_identifier){}

/**
 * Tell the cursor position of the LOB object
 *
 * The {@link cubrid_lob2_tell} function is used to tell the cursor
 * position of the LOB object.
 *
 * @param resource $lob_identifier Lob identifier as a result of {@link
 *   cubrid_lob2_new} or get from the result set.
 * @return int It will return the cursor position on the LOB object
 *   when it processes successfully.
 * @since PECL CUBRID >= 8.4.1
 **/
function cubrid_lob2_tell($lob_identifier){}

/**
 * Tell the cursor position of the LOB object
 *
 * The {@link cubrid_lob2_tell64} function is used to tell the cursor
 * position of the LOB object. If the size of a lob object is larger than
 * an integer data can be stored, you can use this function and it will
 * return the position information as a string.
 *
 * @param resource $lob_identifier Lob identifier as a result of {@link
 *   cubrid_lob2_new} or get from the result set.
 * @return string It will return the cursor position on the LOB object
 *   as a string when it processes successfully.
 * @since PECL CUBRID >= 8.4.1
 **/
function cubrid_lob2_tell64($lob_identifier){}

/**
 * Write to a lob object
 *
 * The {@link cubrid_lob2_write} function reads as much as data from
 * {@link buf} and stores it to the LOB object. Note that this function
 * can only append characters now.
 *
 * @param resource $lob_identifier Lob identifier as a result of {@link
 *   cubrid_lob2_new} or get from the result set.
 * @param string $buf Data that need to be written to the lob object.
 * @return bool TRUE if the process is successful and FALSE for
 *   failure.
 * @since PECL CUBRID >= 8.4.1
 **/
function cubrid_lob2_write($lob_identifier, $buf){}

/**
 * Close BLOB/CLOB data
 *
 * {@link cubrid_lob_close} is used to close all BLOB/CLOB returned from
 * {@link cubrid_lob_get}.
 *
 * @param array $lob_identifier_array LOB identifier array return from
 *   cubrid_lob_get.
 * @return bool TRUE, when process is successful.
 * @since PECL CUBRID >= 8.3.1
 **/
function cubrid_lob_close($lob_identifier_array){}

/**
 * Export BLOB/CLOB data to file
 *
 * {@link cubrid_lob_export} is used to get BLOB/CLOB data from CUBRID
 * database, and saves its contents to a file. To use this function, you
 * must use {@link cubrid_lob_get} first to get BLOB/CLOB info from
 * CUBRID.
 *
 * @param resource $conn_identifier Connection identifier.
 * @param resource $lob_identifier LOB identifier.
 * @param string $path_name Path name of the file.
 * @return bool TRUE, when process is successful.
 * @since PECL CUBRID >= 8.3.1
 **/
function cubrid_lob_export($conn_identifier, $lob_identifier, $path_name){}

/**
 * Get BLOB/CLOB data
 *
 * {@link cubrid_lob_get} is used to get BLOB/CLOB meta info from CUBRID
 * database, CUBRID gets BLOB/CLOB by executing the SQL statement, and
 * returns all LOBs as a resource array. Be sure that the SQL retrieves
 * only one column and its data type is BLOB or CLOB.
 *
 * Remember to use {@link cubrid_lob_close} to release the LOBs if you
 * don't need it any more.
 *
 * @param resource $conn_identifier Connection identifier.
 * @param string $sql SQL statement to be executed.
 * @return array Return an array of LOB resources, when process is
 *   successful.
 * @since PECL CUBRID >= 8.3.1
 **/
function cubrid_lob_get($conn_identifier, $sql){}

/**
 * Read BLOB/CLOB data and send straight to browser
 *
 * {@link cubrid_lob_send} reads BLOB/CLOB data and passes it straight
 * through to the browser. To use this function, you must use {@link
 * cubrid_lob_get} first to get BLOB/CLOB info from CUBRID.
 *
 * @param resource $conn_identifier Connection identifier.
 * @param resource $lob_identifier LOB identifier.
 * @return bool TRUE, when process is successful.
 * @since PECL CUBRID >= 8.3.1
 **/
function cubrid_lob_send($conn_identifier, $lob_identifier){}

/**
 * Get BLOB/CLOB data size
 *
 * {@link cubrid_lob_size} is used to get BLOB/CLOB data size.
 *
 * @param resource $lob_identifier LOB identifier.
 * @return string A string representing LOB data size, when process is
 *   successful.
 * @since PECL CUBRID >= 8.3.1
 **/
function cubrid_lob_size($lob_identifier){}

/**
 * Set a read lock on the given OID
 *
 * The {@link cubrid_lock_read} function is used to put read lock on the
 * instance pointed by given {@link oid}.
 *
 * @param resource $conn_identifier Connection identifier.
 * @param string $oid OID of the instance that you want to put read
 *   lock on.
 * @return bool TRUE, when process is successful.
 * @since PECL CUBRID >= 8.3.0
 **/
function cubrid_lock_read($conn_identifier, $oid){}

/**
 * Set a write lock on the given OID
 *
 * The {@link cubrid_lock_write} function is used to put write lock on
 * the instance pointed by the given {@link oid}.
 *
 * @param resource $conn_identifier Connection identifier.
 * @param string $oid OID of the instance that you want to put write
 *   lock on.
 * @return bool TRUE, when process is successful.
 * @since PECL CUBRID >= 8.3.0
 **/
function cubrid_lock_write($conn_identifier, $oid){}

/**
 * Move the cursor in the result
 *
 * The {@link cubrid_move_cursor} function is used to move the current
 * cursor location of {@link req_identifier} by the value set in the
 * {@link offset} argument, to the direction set in the {@link origin}
 * argument. To set the {@link origin} argument, you can use
 * CUBRID_CURSOR_FIRST for the first part of the result,
 * CUBRID_CURSOR_CURRENT for the current location of the result, or
 * CUBRID_CURSOR_LAST for the last part of the result. If {@link origin}
 * argument is not explicitly designated, then the function uses
 * CUBRID_CURSOR_CURRENT as its default value.
 *
 * If the value of cursor movement range goes over the valid limit, then
 * the cursor moves to the next location after the valid range for the
 * cursor. For example, if you move 20 units in the result with the size
 * of 10, then the cursor will move to 11th place and return
 * CUBRID_NO_MORE_DATA.
 *
 * @param resource $req_identifier Request identifier.
 * @param int $offset Number of units you want to move the cursor.
 * @param int $origin Location where you want to move the cursor from
 *   CUBRID_CURSOR_FIRST, CUBRID_CURSOR_CURRENT, CUBRID_CURSOR_LAST.
 * @return bool TRUE, when process is successful.
 * @since PECL CUBRID >= 8.3.0
 **/
function cubrid_move_cursor($req_identifier, $offset, $origin){}

/**
 * Create a glo instance
 *
 * The {@link cubrid_new_glo} function is used to create a glo instance
 * in the requested class (glo class). The glo created is a LO type, and
 * is stored in the {@link file_name} file.
 *
 * @param resource $conn_identifier Connection identifier.
 * @param string $class_name Name of the class that you want to create
 *   a glo in.
 * @param string $file_name The file name that you want to save in the
 *   newly created glo.
 * @return string Oid of the instance created, when process is
 *   successful.
 * @since PECL CUBRID >= 8.3.0
 **/
function cubrid_new_glo($conn_identifier, $class_name, $file_name){}

/**
 * Get result of next query when executing multiple SQL statements
 *
 * The {@link cubrid_next_result} function is used to get results of next
 * query if multiple SQL statements are executed and
 * CUBRID_EXEC_QUERY_ALL flag is set upon {@link cubrid_execute}.
 *
 * @param resource $result {@link result} comes from a call to {@link
 *   cubrid_execute}
 * @return bool TRUE, when process is successful.
 * @since PECL CUBRID >= 8.4.0
 **/
function cubrid_next_result($result){}

/**
 * Return the number of columns in the result set
 *
 * The {@link cubrid_num_cols} function is used to get the number of
 * columns from the query result. It can only be used when the query
 * executed is a select statement.
 *
 * @param resource $result Result.
 * @return int Number of columns, when process is successful.
 * @since PECL CUBRID >= 8.3.0
 **/
function cubrid_num_cols($result){}

/**
 * Return the number of columns in the result set
 *
 * This function returns the number of columns in the result set, on
 * success, or it returns FALSE on failure.
 *
 * @param resource $result {@link result} comes from a call to {@link
 *   cubrid_execute}, {@link cubrid_query} and {@link cubrid_prepare}
 * @return int Number of columns, on success.
 * @since PECL CUBRID >= 8.3.0
 **/
function cubrid_num_fields($result){}

/**
 * Get the number of rows in the result set
 *
 * The {@link cubrid_num_rows} function is used to get the number of rows
 * from the query result. You can use it only when the query executed is
 * a select statement. When you want to know such value for INSERT,
 * UPDATE, or DELETE query, you have to use the {@link
 * cubrid_affected_rows} function.
 *
 * Note: The {@link cubrid_num_rows} function can only be used for
 * synchronous query; it returns 0 when it is used for asynchronous
 * query.
 *
 * @param resource $result {@link result} comes from a call to {@link
 *   cubrid_execute}, {@link cubrid_query} and {@link cubrid_prepare}
 * @return int Number of rows, when process is successful.
 * @since PECL CUBRID >= 8.3.0
 **/
function cubrid_num_rows($result){}

/**
 * Open a persistent connection to a CUBRID server
 *
 * Establishes a persistent connection to a CUBRID server.
 *
 * {@link cubrid_pconnect} acts very much like {@link cubrid_connect}
 * with two major differences.
 *
 * First, when connecting, the function would first try to find a
 * (persistent) link that's already open with the same host, port, dbname
 * and userid. If one is found, an identifier for it will be returned
 * instead of opening a new connection.
 *
 * Second, the connection to the SQL server will not be closed when the
 * execution of the script ends. Instead, the link will remain open for
 * future use ({@link cubrid_close} or {@link cubrid_disconnect} will not
 * close links established by {@link cubrid_pconnect}).
 *
 * This type of link is therefore called 'persistent'.
 *
 * @param string $host Host name or IP address of CUBRID CAS server.
 * @param int $port Port number of CUBRID CAS server (BROKER_PORT
 *   configured in $CUBRID/conf/cubrid_broker.conf).
 * @param string $dbname Name of database.
 * @param string $userid User name for the database.
 * @param string $passwd User password.
 * @return resource Connection identifier, when process is successful.
 * @since PECL CUBRID >= 8.3.1
 **/
function cubrid_pconnect($host, $port, $dbname, $userid, $passwd){}

/**
 * Open a persistent connection to CUBRID server
 *
 * Establishes a persistent connection to a CUBRID server.
 *
 * {@link cubrid_pconnect_with_url} acts very much like {@link
 * cubrid_connect_with_url} with two major differences.
 *
 * First, when connecting, the function would first try to find a
 * (persistent) link that's already open with the same host, port, dbname
 * and userid. If one is found, an identifier for it will be returned
 * instead of opening a new connection.
 *
 * Second, the connection to the SQL server will not be closed when the
 * execution of the script ends. Instead, the link will remain open for
 * future use ({@link cubrid_close} or {@link cubrid_disconnect} will not
 * close links established by {@link cubrid_pconnect_with_url}).
 *
 * This type of link is therefore called 'persistent'.
 *
 * <url> ::=
 * CUBRID:<host>:<db_name>:<db_user>:<db_password>:[?<properties>]
 *
 * <properties> ::= <property> [&<property>]
 *
 * <properties> ::= alhosts=<alternative_hosts>[ &rctime=<time>]
 *
 * <properties> ::= login_timeout=<milli_sec>
 *
 * <properties> ::= query_timeout=<milli_sec>
 *
 * <properties> ::= disconnect_on_query_timeout=true|false
 *
 * <alternative_hosts> ::= <standby_broker1_host>:<port>
 * [,<standby_broker2_host>:<port>]
 *
 * <host> := HOSTNAME | IP_ADDR
 *
 * <time> := SECOND
 *
 * <milli_sec> := MILLI SECOND
 *
 * host : A host name or IP address of the master database db_name : A
 * name of the database db_user : A name of the database user db_password
 * : A database user password alhosts : Specifies the broker information
 * of the standby server, which is used for failover when it is
 * impossible to connect to the active server. You can specify multiple
 * brokers for failover, and the connection to the brokers is attempted
 * in the order listed in alhosts rctime : An interval between the
 * attempts to connect to the active broker in which failure occurred.
 * After a failure occurs, the system connects to the broker specified by
 * althosts (failover), terminates the transaction, and then attempts to
 * connect to the active broker of the master database at every rctime.
 * The default value is 600 seconds. login_timeout : Timeout value (unit:
 * msec.) for database login. The default value is 0, which means
 * infinite postponement. query_timeout : Timeout value (unit: msec.) for
 * query request. Upon timeout, a message to cancel requesting a query
 * transferred to server is sent. The return value can depend on the
 * disconnect_on_query_timeout configuration; even though the message to
 * cancel a request is sent to server, that request may succeed.
 * disconnect_on_query_timeout : Configures a value whether to
 * immediately return an error of function being executed upon timeout.
 * The default value is false.
 *
 * @param string $conn_url A character string that contains server
 *   connection information.
 * @param string $userid User name for the database.
 * @param string $passwd User password.
 * @return resource Connection identifier, when process is successful.
 * @since PECL CUBRID >= 8.3.1
 **/
function cubrid_pconnect_with_url($conn_url, $userid, $passwd){}

/**
 * Ping a server connection or reconnect if there is no connection
 *
 * Checks whether or not the connection to the server is working.
 *
 * @param resource $conn_identifier The CUBRID connection identifier.
 *   If the connection identifier is not specified, the last connection
 *   opened by {@link cubrid_connect} is assumed.
 * @return bool Returns TRUE if the connection to the server CUBRID
 *   server is working, otherwise FALSE.
 * @since PECL CUBRID >= 8.3.1
 **/
function cubrid_ping($conn_identifier){}

/**
 * Prepare a SQL statement for execution
 *
 * The {@link cubrid_prepare} function is a sort of API which represents
 * SQL statements compiled previously to a given connection handle. This
 * pre-compiled SQL statement will be included in the {@link
 * cubrid_prepare}.
 *
 * Accordingly, you can use this statement effectively to execute several
 * times repeatedly or to process long data. Only a single statement can
 * be used and a parameter may put a question mark (?) to appropriate
 * area in the SQL statement. Add a parameter when you bind a value in
 * the VALUES clause of INSERT statement or in the WHERE clause. Note
 * that it is allowed to bind a value to a MARK(?) by using the {@link
 * cubrid_bind} function only.
 *
 * @param resource $conn_identifier Connection identifier.
 * @param string $prepare_stmt Prepare query.
 * @param int $option OID return option CUBRID_INCLUDE_OID.
 * @return resource Request identifier, if process is successful;
 * @since PECL CUBRID >= 8.3.0
 **/
function cubrid_prepare($conn_identifier, $prepare_stmt, $option){}

/**
 * Update a column using OID
 *
 * The {@link cubrid_put} function is used to update an attribute of the
 * instance of the given {@link oid}.
 *
 * You can update single attribute by using string data type to set
 * {@link attr}. In such case, you can use integer, floating point or
 * string type data for the {@link value} argument. To update multiple
 * number of attributes, you can disregard the {@link attr} argument, and
 * set {@link value} argument with associative array data type.
 *
 * @param resource $conn_identifier Connection identifier.
 * @param string $oid OID of the instance that you want to update.
 * @param string $attr Name of the attribute that you want to update.
 * @param mixed $value New value that you want to assign to the
 *   attribute.
 * @return bool TRUE, when process is successful.
 * @since PECL CUBRID >= 8.3.0
 **/
function cubrid_put($conn_identifier, $oid, $attr, $value){}

/**
 * Send a CUBRID query
 *
 * {@link cubrid_query} sends a unique query (multiple queries are not
 * supported) to the currently active database on the server that's
 * associated with the specified {@link conn_identifier}.
 *
 * @param string $query An SQL query Data inside the query should be
 *   properly escaped.
 * @param resource $conn_identifier The CUBRID connection. If the
 *   connection identifier is not specified, the last connection opened
 *   by {@link cubrid_connect} is assumed.
 * @return resource For SELECT, SHOW, DESCRIBE, EXPLAIN and other
 *   statements returning resultset, {@link cubrid_query} returns a
 *   resource on success, or FALSE on error.
 * @since PECL CUBRID >= 8.3.1
 **/
function cubrid_query($query, $conn_identifier){}

/**
 * Escape special characters in a string for use in an SQL statement
 *
 * This function returns the escaped string version of the given string.
 * It will escape the following characters: '.
 *
 * In general, single quotations are used to enclose character string.
 * Double quotations may be used as well depending on the value of
 * ansi_quotes, which is a parameter related to SQL statement. If the
 * ansi_quotes value is set to no, character string enclosed by double
 * quotations is handled as character string, not as an identifier. The
 * default value is yes.
 *
 * If you want to include a single quote as part of a character string,
 * enter two single quotes in a row.
 *
 * @param string $unescaped_string The string that is to be escaped.
 * @param resource $conn_identifier The CUBRID connection. If the
 *   connection identifier is not specified, the last connection opened
 *   by {@link cubrid_connect} is assumed.
 * @return string Escaped string version of the given string, on
 *   success.
 * @since PECL CUBRID >= 8.3.0
 **/
function cubrid_real_escape_string($unescaped_string, $conn_identifier){}

/**
 * Return the value of a specific field in a specific row
 *
 * This function returns the value of a specific field in a specific row
 * from a result set.
 *
 * @param resource $result {@link result} comes from a call to {@link
 *   cubrid_execute}
 * @param int $row The row number from the result that is being
 *   retrieved. Row numbers start at 0.
 * @param mixed $field The name or offset of the {@link field} being
 *   retrieved. It can be the field's offset, the field's name, or the
 *   field's table dot field name (tablename.fieldname). If the column
 *   name has been aliased ('select foo as bar from...'), use the alias
 *   instead of the column name. If undefined, the first field is
 *   retrieved.
 * @return string Value of a specific field, on success (NULL if value
 *   if null).
 * @since PECL CUBRID >= 8.3.0
 **/
function cubrid_result($result, $row, $field){}

/**
 * Roll back a transaction
 *
 * The {@link cubrid_rollback} function executes rollback on the
 * transaction pointed by {@link conn_identifier}, currently in progress.
 *
 * Connection to server is closed after calling {@link cubrid_rollback}.
 * Connection handle, however, is still valid.
 *
 * @param resource $conn_identifier Connection identifier.
 * @return bool TRUE, when process is successful.
 * @since PECL CUBRID >= 8.3.0
 **/
function cubrid_rollback($conn_identifier){}

/**
 * Save requested file in a GLO instance
 *
 * The {@link cubrid_save_to_glo} function is used to save requested file
 * in a glo instance.
 *
 * @param resource $conn_identifier Connection identifier.
 * @param string $oid Oid of the glo instance that you want to save a
 *   file in.
 * @param string $file_name The name of the file that you want to save.
 * @return int TRUE, when process is successful.
 * @since PECL CUBRID >= 8.3.0
 **/
function cubrid_save_to_glo($conn_identifier, $oid, $file_name){}

/**
 * Get the requested schema information
 *
 * The {@link cubrid_schema} function is used to get the requested schema
 * information from database. You have to designate {@link class_name},
 * if you want to get information on certain class, {@link attr_name}, if
 * you want to get information on certain attribute (can be used only
 * with CUBRID_ SCH_ATTR_PRIVILEGE).
 *
 * The result of the cubrid_schema function is returned as a
 * two-dimensional array (column (associative array) * row (numeric
 * array)). The following tables shows types of schema and the column
 * structure of the result array to be returned based on the schema type.
 *
 * Result Composition of Each Type Schema Column Number Column Name Value
 * CUBRID_SCH_CLASS 1 NAME 2 TYPE 0:system class 1:vclass 2:class
 *
 * CUBRID_SCH_VCLASS 1 NAME 2 TYPE 1:vclass
 *
 * CUBRID_SCH_QUERY_SPEC 1 QUERY_SPEC
 *
 * CUBRID_SCH_ATTRIBUTE / CUBRID_SCH_CLASS_ATTRIBUTE 1 ATTR_NAME 2 DOMAIN
 * 3 SCALE 4 PRECISION 5 INDEXED 1:indexed 6 NOT NULL 1:not null 7 SHARED
 * 1:shared 8 UNIQUE 1:unique 9 DEFAULT 10 ATTR_ORDER base:1 11
 * CLASS_NAME 12 SOURCE_CLASS 13 IS_KEY 1:key
 *
 * CUBRID_SCH_METHOD / CUBRID_SCH_CLASS_METHOD 1 NAME 2 RET_DOMAIN 3
 * ARG_DOMAIN
 *
 * CUBRID_SCH_METHOD_FILE 1 METHOD_FILE
 *
 * CUBRID_SCH_SUPERCLASS / CUBRID_SCH_DIRECT_SUPER_CLASS /
 * CUBRID_SCH_SUBCLASS 1 CLASS_NAME 2 TYPE 0:system class 1:vclass
 * 2:class
 *
 * CUBRID_SCH_CONSTRAINT 1 TYPE 0:unique 1:index 2:reverse unique
 * 3:reverse index 2 NAME 3 ATTR_NAME 4 NUM_PAGES 5 NUM_KEYS 6
 * PRIMARY_KEY 1:primary key 7 KEY_ORDER base:1
 *
 * CUBRID_SCH_TRIGGER 1 NAME 2 STATUS 3 EVENT 4 TARGET_CLASS 5
 * TARGET_ATTR 6 ACTION_TIME 7 ACTION 8 PRIORITY 9 CONDITION_TIME 10
 * CONDITION
 *
 * CUBRID_SCH_CLASS_PRIVILEGE / CUBRID_SCH_ATTR_PRIVILEGE 1 CLASS_NAME /
 * ATTR_NAME 2 PRIVILEGE 3 GRANTABLE
 *
 * CUBRID_SCH_PRIMARY_KEY 1 CLASS_NAME 2 ATTR_NAME 3 KEY_SEQ base:1 4
 * KEY_NAME
 *
 * CUBRID_SCH_IMPORTED_KEYS / CUBRID_SCH_EXPORTED_KEYS /
 * CUBRID_SCH_CROSS_REFERENCE 1 PKTABLE_NAME 2 PKCOLUMN_NAME 3
 * FKTABLE_NAME base:1 4 FKCOLUMN_NAME 5 KEY_SEQ base:1 6 UPDATE_ACTION
 * 0:cascade 1:restrict 2:no action 3:set null 7 DELETE_ACTION 0:cascade
 * 1:restrict 2:no action 3:set null 8 FK_NAME 9 PK_NAME
 *
 * @param resource $conn_identifier Connection identifier.
 * @param int $schema_type Schema data that you want to know.
 * @param string $class_name Class you want to know the schema of.
 * @param string $attr_name Attribute you want to know the schema of.
 * @return array Array containing the schema information, when process
 *   is successful;
 * @since PECL CUBRID >= 8.3.0
 **/
function cubrid_schema($conn_identifier, $schema_type, $class_name, $attr_name){}

/**
 * Read data from glo and send it to std output
 *
 * The {@link cubrid_send_glo} function is used to read data from glo
 * instance and sends it to the PHP standard output.
 *
 * @param resource $conn_identifier Connection identifier.
 * @param string $oid Oid of the glo instance that you want to read
 *   data from.
 * @return int TRUE, when process is successful.
 * @since PECL CUBRID >= 8.3.0
 **/
function cubrid_send_glo($conn_identifier, $oid){}

/**
 * Delete an element from sequence type column using OID
 *
 * The {@link cubrid_seq_drop} function is used to delete an element you
 * request from the given sequence type attribute in the database.
 *
 * @param resource $conn_identifier Connection identifier.
 * @param string $oid OID of the instance you want to work with.
 * @param string $attr_name Name of the attribute that you want to
 *   delete an element from.
 * @param int $index Index of the element that you want to delete
 *   (1-based).
 * @return bool TRUE, when process is successful.
 * @since PECL CUBRID >= 8.3.0
 **/
function cubrid_seq_drop($conn_identifier, $oid, $attr_name, $index){}

/**
 * Insert an element to a sequence type column using OID
 *
 * The {@link cubrid_col_insert} function is used to insert an element to
 * a sequence type attribute in a requested location.
 *
 * @param resource $conn_identifier Connection identifier.
 * @param string $oid OID of the instance you want to work with.
 * @param string $attr_name Name of the attribute you want to insert an
 *   instance to.
 * @param int $index Location of the element, you want to insert the
 *   element to (1-based).
 * @param string $seq_element Content of the element that you want to
 *   insert.
 * @return bool TRUE, when process is successful.
 * @since PECL CUBRID >= 8.3.0
 **/
function cubrid_seq_insert($conn_identifier, $oid, $attr_name, $index, $seq_element){}

/**
 * Update the element value of sequence type column using OID
 *
 * The {@link cubrid_seq_put} function is used to update the content of
 * the requested element in a sequent type attribute using OID.
 *
 * @param resource $conn_identifier Connection identifier.
 * @param string $oid OID of the instance you want to work with.
 * @param string $attr_name Name of the attribute that you want to
 *   update an element.
 * @param int $index Index (1-based) of the element that you want to
 *   update.
 * @param string $seq_element New content that you want to use for the
 *   update.
 * @return bool TRUE, when process is successful.
 * @since PECL CUBRID >= 8.3.0
 **/
function cubrid_seq_put($conn_identifier, $oid, $attr_name, $index, $seq_element){}

/**
 * Insert a single element to set type column using OID
 *
 * The {@link cubrid_set_add} function is used to insert a single element
 * to a set type attribute (set, multiset, sequence) you requested.
 *
 * @param resource $conn_identifier Connection identifier.
 * @param string $oid OID of the instance you want to work with.
 * @param string $attr_name Name of the attribute you want to insert an
 *   element.
 * @param string $set_element Content of the element you want to
 *   insert.
 * @return bool TRUE, when process is successful.
 * @since PECL CUBRID >= 8.3.0
 **/
function cubrid_set_add($conn_identifier, $oid, $attr_name, $set_element){}

/**
 * Set autocommit mode of the connection
 *
 * The {@link cubrid_set_autocommit} function is used to set the CUBRID
 * database auto-commit mode of the current database connection.
 *
 * In CUBRID PHP, auto-commit mode is disabled by default for transaction
 * management. When auto-commit mode is truned from off to on, any
 * pending work is automatically committed.
 *
 * @param resource $conn_identifier Connection identifier.
 * @param bool $mode Auto-commit mode. The following constants can be
 *   used:
 *   
 *   CUBRID_AUTOCOMMIT_FALSE CUBRID_AUTOCOMMIT_TRUE
 * @return bool TRUE, when process is successful.
 * @since PECL CUBRID >= 8.4.0
 **/
function cubrid_set_autocommit($conn_identifier, $mode){}

/**
 * Sets the CUBRID database parameters
 *
 * The {@link cubrid_set_db_parameter} function is used to set the CUBRID
 * database parameters. It can set the following CUBRID database
 * parameters:
 *
 * PARAM_ISOLATION_LEVEL PARAM_LOCK_TIMEOUT
 *
 * @param resource $conn_identifier The CUBRID connection. If the
 *   connection identifier is not specified, the last link opened by
 *   {@link cubrid_connect} is assumed.
 * @param int $param_type Database parameter type.
 * @param int $param_value Isolation level value (1-6) or lock timeout
 *   (in seconds) value.
 * @return bool TRUE on success.
 * @since PECL CUBRID >= 8.4.0
 **/
function cubrid_set_db_parameter($conn_identifier, $param_type, $param_value){}

/**
 * Delete an element from set type column using OID
 *
 * The {@link cubrid_set_drop} function is used to delete an element that
 * you request from the given set type (set, multiset) attribute of the
 * database.
 *
 * @param resource $conn_identifier Connection identifier.
 * @param string $oid OID of the instance you want to work with.
 * @param string $attr_name Name of the attribute you want to delete an
 *   element from.
 * @param string $set_element Content of the element you want to
 *   delete.
 * @return bool TRUE, when process is successful.
 * @since PECL CUBRID >= 8.3.0
 **/
function cubrid_set_drop($conn_identifier, $oid, $attr_name, $set_element){}

/**
 * Set the timeout time of query execution
 *
 * The {@link cubrid_set_query_timeout} function is used to set the
 * timeout time of query execution.
 *
 * @param resource $req_identifier Request identifier.
 * @param int $timeout Timeout time, unit of msec.
 * @return bool TRUE, when process is successful.
 * @since PECL CUBRID >= 8.4.1
 **/
function cubrid_set_query_timeout($req_identifier, $timeout){}

/**
 * Perform a query without fetching the results into memory
 *
 * This function performs a query without waiting for that all query
 * results have been complete. It will return when the results are being
 * generated.
 *
 * @param string $query A SQL query.
 * @param resource $conn_identifier The CUBRID connection. If the
 *   connection identifier is not specified, the last connection opened
 *   by {@link cubrid_connect} is assumed.
 * @return resource For SELECT, SHOW, DESCRIBE or EXPLAIN statements
 *   returns a request identifier resource on success.
 * @since PECL CUBRID >= 8.3.0
 **/
function cubrid_unbuffered_query($query, $conn_identifier){}

/**
 * Get the CUBRID PHP module's version
 *
 * The {@link cubrid_version} function is used to get the CUBRID PHP
 * module's version.
 *
 * @return string Version information (eg. "8.3.1.0001").
 * @since PECL CUBRID >= 8.3.0
 **/
function cubrid_version(){}

/**
 * Close a cURL session
 *
 * Closes a cURL session and frees all resources. The cURL handle, {@link
 * ch}, is also deleted.
 *
 * @param resource $ch
 * @return void
 * @since PHP 4 >= 4.0.2, PHP 5, PHP 7
 **/
function curl_close($ch){}

/**
 * Copy a cURL handle along with all of its preferences
 *
 * Copies a cURL handle keeping the same preferences.
 *
 * @param resource $ch
 * @return resource Returns a new cURL handle.
 * @since PHP 5, PHP 7
 **/
function curl_copy_handle($ch){}

/**
 * Return the last error number
 *
 * Returns the error number for the last cURL operation.
 *
 * @param resource $ch
 * @return int Returns the error number or 0 (zero) if no error
 *   occurred.
 * @since PHP 4 >= 4.0.3, PHP 5, PHP 7
 **/
function curl_errno($ch){}

/**
 * Return a string containing the last error for the current session
 *
 * Returns a clear text error message for the last cURL operation.
 *
 * @param resource $ch
 * @return string Returns the error message or '' (the empty string) if
 *   no error occurred.
 * @since PHP 4 >= 4.0.3, PHP 5, PHP 7
 **/
function curl_error($ch){}

/**
 * URL encodes the given string
 *
 * This function URL encodes the given string according to RFC 3986.
 *
 * @param resource $ch The string to be encoded.
 * @param string $str
 * @return string Returns escaped string.
 * @since PHP 5 >= 5.5.0, PHP 7
 **/
function curl_escape($ch, $str){}

/**
 * Perform a cURL session
 *
 * Execute the given cURL session.
 *
 * This function should be called after initializing a cURL session and
 * all the options for the session are set.
 *
 * @param resource $ch
 * @return mixed However, if the CURLOPT_RETURNTRANSFER option is set,
 *   it will return the result on success, FALSE on failure.
 * @since PHP 4 >= 4.0.2, PHP 5, PHP 7
 **/
function curl_exec($ch){}

/**
 * Create a CURLFile object
 *
 * Creates a CURLFile object, used to upload a file with
 * CURLOPT_POSTFIELDS.
 *
 * @param string $filename Path to the file which will be uploaded.
 * @param string $mimetype Mimetype of the file.
 * @param string $postname Name of the file to be used in the upload
 *   data.
 * @return CURLFile Returns a CURLFile object.
 * @since PHP 5 >= 5.5.0, PHP 7
 **/
function curl_file_create($filename, $mimetype, $postname){}

/**
 * Get information regarding a specific transfer
 *
 * Gets information about the last transfer.
 *
 * @param resource $ch This may be one of the following constants:
 *   CURLINFO_EFFECTIVE_URL - Last effective URL CURLINFO_HTTP_CODE - The
 *   last response code. As of PHP 5.5.0 and cURL 7.10.8, this is a
 *   legacy alias of CURLINFO_RESPONSE_CODE CURLINFO_FILETIME - Remote
 *   time of the retrieved document, with the CURLOPT_FILETIME enabled;
 *   if -1 is returned the time of the document is unknown
 *   CURLINFO_TOTAL_TIME - Total transaction time in seconds for last
 *   transfer CURLINFO_NAMELOOKUP_TIME - Time in seconds until name
 *   resolving was complete CURLINFO_CONNECT_TIME - Time in seconds it
 *   took to establish the connection CURLINFO_PRETRANSFER_TIME - Time in
 *   seconds from start until just before file transfer begins
 *   CURLINFO_STARTTRANSFER_TIME - Time in seconds until the first byte
 *   is about to be transferred CURLINFO_REDIRECT_COUNT - Number of
 *   redirects, with the CURLOPT_FOLLOWLOCATION option enabled
 *   CURLINFO_REDIRECT_TIME - Time in seconds of all redirection steps
 *   before final transaction was started, with the
 *   CURLOPT_FOLLOWLOCATION option enabled CURLINFO_REDIRECT_URL - With
 *   the CURLOPT_FOLLOWLOCATION option disabled: redirect URL found in
 *   the last transaction, that should be requested manually next. With
 *   the CURLOPT_FOLLOWLOCATION option enabled: this is empty. The
 *   redirect URL in this case is available in CURLINFO_EFFECTIVE_URL
 *   CURLINFO_PRIMARY_IP - IP address of the most recent connection
 *   CURLINFO_PRIMARY_PORT - Destination port of the most recent
 *   connection CURLINFO_LOCAL_IP - Local (source) IP address of the most
 *   recent connection CURLINFO_LOCAL_PORT - Local (source) port of the
 *   most recent connection CURLINFO_SIZE_UPLOAD - Total number of bytes
 *   uploaded CURLINFO_SIZE_DOWNLOAD - Total number of bytes downloaded
 *   CURLINFO_SPEED_DOWNLOAD - Average download speed
 *   CURLINFO_SPEED_UPLOAD - Average upload speed CURLINFO_HEADER_SIZE -
 *   Total size of all headers received CURLINFO_HEADER_OUT - The request
 *   string sent. For this to work, add the CURLINFO_HEADER_OUT option to
 *   the handle by calling {@link curl_setopt} CURLINFO_REQUEST_SIZE -
 *   Total size of issued requests, currently only for HTTP requests
 *   CURLINFO_SSL_VERIFYRESULT - Result of SSL certification verification
 *   requested by setting CURLOPT_SSL_VERIFYPEER
 *   CURLINFO_CONTENT_LENGTH_DOWNLOAD - Content length of download, read
 *   from Content-Length: field CURLINFO_CONTENT_LENGTH_UPLOAD -
 *   Specified size of upload CURLINFO_CONTENT_TYPE - Content-Type: of
 *   the requested document. NULL indicates server did not send valid
 *   Content-Type: header CURLINFO_PRIVATE - Private data associated with
 *   this cURL handle, previously set with the CURLOPT_PRIVATE option of
 *   {@link curl_setopt} CURLINFO_RESPONSE_CODE - The last response code
 *   CURLINFO_HTTP_CONNECTCODE - The CONNECT response code
 *   CURLINFO_HTTPAUTH_AVAIL - Bitmask indicating the authentication
 *   method(s) available according to the previous response
 *   CURLINFO_PROXYAUTH_AVAIL - Bitmask indicating the proxy
 *   authentication method(s) available according to the previous
 *   response CURLINFO_OS_ERRNO - Errno from a connect failure. The
 *   number is OS and system specific. CURLINFO_NUM_CONNECTS - Number of
 *   connections curl had to create to achieve the previous transfer
 *   CURLINFO_SSL_ENGINES - OpenSSL crypto-engines supported
 *   CURLINFO_COOKIELIST - All known cookies CURLINFO_FTP_ENTRY_PATH -
 *   Entry path in FTP server CURLINFO_APPCONNECT_TIME - Time in seconds
 *   it took from the start until the SSL/SSH connect/handshake to the
 *   remote host was completed CURLINFO_CERTINFO - TLS certificate chain
 *   CURLINFO_CONDITION_UNMET - Info on unmet time conditional
 *   CURLINFO_RTSP_CLIENT_CSEQ - Next RTSP client CSeq
 *   CURLINFO_RTSP_CSEQ_RECV - Recently received CSeq
 *   CURLINFO_RTSP_SERVER_CSEQ - Next RTSP server CSeq
 *   CURLINFO_RTSP_SESSION_ID - RTSP session ID
 * @param int $opt
 * @return mixed If {@link opt} is given, returns its value. Otherwise,
 *   returns an associative array with the following elements (which
 *   correspond to {@link opt}), or FALSE on failure: "url"
 *   "content_type" "http_code" "header_size" "request_size" "filetime"
 *   "ssl_verify_result" "redirect_count" "total_time" "namelookup_time"
 *   "connect_time" "pretransfer_time" "size_upload" "size_download"
 *   "speed_download" "speed_upload" "download_content_length"
 *   "upload_content_length" "starttransfer_time" "redirect_time"
 *   "certinfo" "primary_ip" "primary_port" "local_ip" "local_port"
 *   "redirect_url" "request_header" (This is only set if the
 *   CURLINFO_HEADER_OUT is set by a previous call to {@link
 *   curl_setopt}) Note that private data is not included in the
 *   associative array and must be retrieved individually with the
 *   CURLINFO_PRIVATE option.
 * @since PHP 4 >= 4.0.4, PHP 5, PHP 7
 **/
function curl_getinfo($ch, $opt){}

/**
 * Initialize a cURL session
 *
 * Initializes a new session and return a cURL handle for use with the
 * {@link curl_setopt}, {@link curl_exec}, and {@link curl_close}
 * functions.
 *
 * @param string $url If provided, the CURLOPT_URL option will be set
 *   to its value. You can manually set this using the {@link
 *   curl_setopt} function.
 * @return resource Returns a cURL handle on success, FALSE on errors.
 * @since PHP 4 >= 4.0.2, PHP 5, PHP 7
 **/
function curl_init($url){}

/**
 * Add a normal cURL handle to a cURL multi handle
 *
 * Adds the {@link ch} handle to the multi handle {@link mh}
 *
 * @param resource $mh
 * @param resource $ch
 * @return int Returns 0 on success, or one of the CURLM_XXX errors
 *   code.
 * @since PHP 5, PHP 7
 **/
function curl_multi_add_handle($mh, $ch){}

/**
 * Close a set of cURL handles
 *
 * Closes a set of cURL handles.
 *
 * @param resource $mh
 * @return void
 * @since PHP 5, PHP 7
 **/
function curl_multi_close($mh){}

/**
 * Return the last multi curl error number
 *
 * Return an integer containing the last multi curl error number.
 *
 * @param resource $mh
 * @return int Return an integer containing the last multi curl error
 *   number, .
 * @since PHP 7 >= 7.1.0
 **/
function curl_multi_errno($mh){}

/**
 * Run the sub-connections of the current cURL handle
 *
 * Processes each of the handles in the stack. This method can be called
 * whether or not a handle needs to read or write data.
 *
 * @param resource $mh A reference to a flag to tell whether the
 *   operations are still running.
 * @param int $still_running
 * @return int A cURL code defined in the cURL Predefined Constants.
 * @since PHP 5, PHP 7
 **/
function curl_multi_exec($mh, &$still_running){}

/**
 * Return the content of a cURL handle if is set
 *
 * If CURLOPT_RETURNTRANSFER is an option that is set for a specific
 * handle, then this function will return the content of that cURL handle
 * in the form of a string.
 *
 * @param resource $ch
 * @return string Return the content of a cURL handle if
 *   CURLOPT_RETURNTRANSFER is set.
 * @since PHP 5, PHP 7
 **/
function curl_multi_getcontent($ch){}

/**
 * Get information about the current transfers
 *
 * Ask the multi handle if there are any messages or information from the
 * individual transfers. Messages may include information such as an
 * error code from the transfer or just the fact that a transfer is
 * completed.
 *
 * Repeated calls to this function will return a new result each time,
 * until a FALSE is returned as a signal that there is no more to get at
 * this point. The integer pointed to with {@link msgs_in_queue} will
 * contain the number of remaining messages after this function was
 * called.
 *
 * @param resource $mh Number of messages that are still in the queue
 * @param int $msgs_in_queue
 * @return array On success, returns an associative array for the
 *   message, FALSE on failure.
 * @since PHP 5, PHP 7
 **/
function curl_multi_info_read($mh, &$msgs_in_queue){}

/**
 * Returns a new cURL multi handle
 *
 * Allows the processing of multiple cURL handles asynchronously.
 *
 * @return resource Returns a cURL multi handle resource on success,
 *   FALSE on failure.
 * @since PHP 5, PHP 7
 **/
function curl_multi_init(){}

/**
 * Remove a multi handle from a set of cURL handles
 *
 * Removes a given {@link ch} handle from the given {@link mh} handle.
 * When the {@link ch} handle has been removed, it is again perfectly
 * legal to run {@link curl_exec} on this handle. Removing the {@link ch}
 * handle while being used, will effectively halt the transfer in
 * progress involving that handle.
 *
 * @param resource $mh
 * @param resource $ch
 * @return int Returns 0 on success, or one of the CURLM_XXX error
 *   codes.
 * @since PHP 5, PHP 7
 **/
function curl_multi_remove_handle($mh, $ch){}

/**
 * Wait for activity on any curl_multi connection
 *
 * Blocks until there is activity on any of the curl_multi connections.
 *
 * @param resource $mh Time, in seconds, to wait for a response.
 * @param float $timeout
 * @return int On success, returns the number of descriptors contained
 *   in the descriptor sets. This may be 0 if there was no activity on
 *   any of the descriptors. On failure, this function will return -1 on
 *   a select failure (from the underlying select system call).
 * @since PHP 5, PHP 7
 **/
function curl_multi_select($mh, $timeout){}

/**
 * Set an option for the cURL multi handle
 *
 * @param resource $mh
 * @param int $option One of the CURLMOPT_* constants.
 * @param mixed $value The value to be set on {@link option}. {@link
 *   value} should be an int for the following values of the {@link
 *   option} parameter: Option Set {@link value} to CURLMOPT_PIPELINING
 *   Pass 1 to enable or 0 to disable. Enabling pipelining on a multi
 *   handle will make it attempt to perform HTTP Pipelining as far as
 *   possible for transfers using this handle. This means that if you add
 *   a second request that can use an already existing connection, the
 *   second request will be "piped" on the same connection. As of cURL
 *   7.43.0, the value is a bitmask, and you can also pass 2 to try to
 *   multiplex the new transfer over an existing HTTP/2 connection if
 *   possible. Passing 3 instructs cURL to ask for pipelining and
 *   multiplexing independently of each other. As of cURL 7.62.0, setting
 *   the pipelining bit has no effect. Instead of integer literals, you
 *   can also use the CURLPIPE_* constants if available.
 *   CURLMOPT_MAXCONNECTS Pass a number that will be used as the maximum
 *   amount of simultaneously open connections that libcurl may cache. By
 *   default the size will be enlarged to fit four times the number of
 *   handles added via {@link curl_multi_add_handle}. When the cache is
 *   full, curl closes the oldest one in the cache to prevent the number
 *   of open connections from increasing.
 *   CURLMOPT_CHUNK_LENGTH_PENALTY_SIZE Pass a number that specifies the
 *   chunk length threshold for pipelining in bytes.
 *   CURLMOPT_CONTENT_LENGTH_PENALTY_SIZE Pass a number that specifies
 *   the size threshold for pipelining penalty in bytes.
 *   CURLMOPT_MAX_HOST_CONNECTIONS Pass a number that specifies the
 *   maximum number of connections to a single host.
 *   CURLMOPT_MAX_PIPELINE_LENGTH Pass a number that specifies the
 *   maximum number of requests in a pipeline.
 *   CURLMOPT_MAX_TOTAL_CONNECTIONS Pass a number that specifies the
 *   maximum number of simultaneously open connections.
 *   CURLMOPT_PUSHFUNCTION Pass a callable that will be registered to
 *   handle server pushes and should have the following signature:
 *   intpushfunction resource{@link parent_ch} resource{@link pushed_ch}
 *   array{@link headers} {@link parent_ch} The parent cURL handle (the
 *   request the client made). {@link pushed_ch} A new cURL handle for
 *   the pushed request. {@link headers} The push promise headers. The
 *   push function is supposed to return either CURL_PUSH_OK if it can
 *   handle the push, or CURL_PUSH_DENY to reject it.
 * @return bool
 * @since PHP 5 >= 5.5.0, PHP 7
 **/
function curl_multi_setopt($mh, $option, $value){}

/**
 * Return string describing error code
 *
 * Returns a text error message describing the given CURLM error code.
 *
 * @param int $errornum One of the CURLM error codes constants.
 * @return string Returns error string for valid error code, NULL
 *   otherwise.
 * @since PHP 5 >= 5.5.0, PHP 7
 **/
function curl_multi_strerror($errornum){}

/**
 * Pause and unpause a connection
 *
 * @param resource $ch One of CURLPAUSE_* constants.
 * @param int $bitmask
 * @return int Returns an error code (CURLE_OK for no error).
 * @since PHP 5 >= 5.5.0, PHP 7
 **/
function curl_pause($ch, $bitmask){}

/**
 * Reset all options of a libcurl session handle
 *
 * This function re-initializes all options set on the given cURL handle
 * to the default values.
 *
 * @param resource $ch
 * @return void
 * @since PHP 5 >= 5.5.0, PHP 7
 **/
function curl_reset($ch){}

/**
 * Set an option for a cURL transfer
 *
 * Sets an option on the given cURL session handle.
 *
 * @param resource $ch The CURLOPT_XXX option to set.
 * @param int $option The value to be set on {@link option}. {@link
 *   value} should be a bool for the following values of the {@link
 *   option} parameter: Option Set {@link value} to Notes
 *   CURLOPT_AUTOREFERER TRUE to automatically set the Referer: field in
 *   requests where it follows a Location: redirect.
 *   CURLOPT_BINARYTRANSFER TRUE to return the raw output when
 *   CURLOPT_RETURNTRANSFER is used. From PHP 5.1.3, this option has no
 *   effect: the raw output will always be returned when
 *   CURLOPT_RETURNTRANSFER is used. CURLOPT_COOKIESESSION TRUE to mark
 *   this as a new cookie "session". It will force libcurl to ignore all
 *   cookies it is about to load that are "session cookies" from the
 *   previous session. By default, libcurl always stores and loads all
 *   cookies, independent if they are session cookies or not. Session
 *   cookies are cookies without expiry date and they are meant to be
 *   alive and existing for this "session" only. CURLOPT_CERTINFO TRUE to
 *   output SSL certification information to STDERR on secure transfers.
 *   Added in cURL 7.19.1. Available since PHP 5.3.2. Requires
 *   CURLOPT_VERBOSE to be on to have an effect. CURLOPT_CONNECT_ONLY
 *   TRUE tells the library to perform all the required proxy
 *   authentication and connection setup, but no data transfer. This
 *   option is implemented for HTTP, SMTP and POP3. Added in 7.15.2.
 *   Available since PHP 5.5.0. CURLOPT_CRLF TRUE to convert Unix
 *   newlines to CRLF newlines on transfers. CURLOPT_DNS_USE_GLOBAL_CACHE
 *   TRUE to use a global DNS cache. This option is not thread-safe. It
 *   is conditionally enabled by default if PHP is built for non-threaded
 *   use (CLI, FCGI, Apache2-Prefork, etc.). CURLOPT_FAILONERROR TRUE to
 *   fail verbosely if the HTTP code returned is greater than or equal to
 *   400. The default behavior is to return the page normally, ignoring
 *   the code. CURLOPT_SSL_FALSESTART TRUE to enable TLS false start.
 *   Added in cURL 7.42.0. Available since PHP 7.0.7. CURLOPT_FILETIME
 *   TRUE to attempt to retrieve the modification date of the remote
 *   document. This value can be retrieved using the {@link
 *   CURLINFO_FILETIME} option with {@link curl_getinfo}.
 *   CURLOPT_FOLLOWLOCATION TRUE to follow any "Location: " header that
 *   the server sends as part of the HTTP header (note this is recursive,
 *   PHP will follow as many "Location: " headers that it is sent, unless
 *   CURLOPT_MAXREDIRS is set). CURLOPT_FORBID_REUSE TRUE to force the
 *   connection to explicitly close when it has finished processing, and
 *   not be pooled for reuse. CURLOPT_FRESH_CONNECT TRUE to force the use
 *   of a new connection instead of a cached one. CURLOPT_FTP_USE_EPRT
 *   TRUE to use EPRT (and LPRT) when doing active FTP downloads. Use
 *   FALSE to disable EPRT and LPRT and use PORT only.
 *   CURLOPT_FTP_USE_EPSV TRUE to first try an EPSV command for FTP
 *   transfers before reverting back to PASV. Set to FALSE to disable
 *   EPSV. CURLOPT_FTP_CREATE_MISSING_DIRS TRUE to create missing
 *   directories when an FTP operation encounters a path that currently
 *   doesn't exist. CURLOPT_FTPAPPEND TRUE to append to the remote file
 *   instead of overwriting it. CURLOPT_TCP_NODELAY TRUE to disable TCP's
 *   Nagle algorithm, which tries to minimize the number of small packets
 *   on the network. Available since PHP 5.2.1 for versions compiled with
 *   libcurl 7.11.2 or greater. CURLOPT_FTPASCII An alias of
 *   CURLOPT_TRANSFERTEXT. Use that instead. CURLOPT_FTPLISTONLY TRUE to
 *   only list the names of an FTP directory. CURLOPT_HEADER TRUE to
 *   include the header in the output. CURLINFO_HEADER_OUT TRUE to track
 *   the handle's request string. Available since PHP 5.1.3. The
 *   CURLINFO_ prefix is intentional. CURLOPT_HTTPGET TRUE to reset the
 *   HTTP request method to GET. Since GET is the default, this is only
 *   necessary if the request method has been changed.
 *   CURLOPT_HTTPPROXYTUNNEL TRUE to tunnel through a given HTTP proxy.
 *   CURLOPT_MUTE TRUE to be completely silent with regards to the cURL
 *   functions. Removed in cURL 7.15.5 (You can use
 *   CURLOPT_RETURNTRANSFER instead) CURLOPT_NETRC TRUE to scan the
 *   ~/.netrc file to find a username and password for the remote site
 *   that a connection is being established with. CURLOPT_NOBODY TRUE to
 *   exclude the body from the output. Request method is then set to
 *   HEAD. Changing this to FALSE does not change it to GET.
 *   CURLOPT_NOPROGRESS TRUE to disable the progress meter for cURL
 *   transfers. PHP automatically sets this option to TRUE, this should
 *   only be changed for debugging purposes. CURLOPT_NOSIGNAL TRUE to
 *   ignore any cURL function that causes a signal to be sent to the PHP
 *   process. This is turned on by default in multi-threaded SAPIs so
 *   timeout options can still be used. Added in cURL 7.10.
 *   CURLOPT_PATH_AS_IS TRUE to not handle dot dot sequences. Added in
 *   cURL 7.42.0. Available since PHP 7.0.7. CURLOPT_PIPEWAIT TRUE to
 *   wait for pipelining/multiplexing. Added in cURL 7.43.0. Available
 *   since PHP 7.0.7. CURLOPT_POST TRUE to do a regular HTTP POST. This
 *   POST is the normal application/x-www-form-urlencoded kind, most
 *   commonly used by HTML forms. CURLOPT_PUT TRUE to HTTP PUT a file.
 *   The file to PUT must be set with CURLOPT_INFILE and
 *   CURLOPT_INFILESIZE. CURLOPT_RETURNTRANSFER TRUE to return the
 *   transfer as a string of the return value of {@link curl_exec}
 *   instead of outputting it directly. CURLOPT_SAFE_UPLOAD TRUE to
 *   disable support for the @ prefix for uploading files in
 *   CURLOPT_POSTFIELDS, which means that values starting with @ can be
 *   safely passed as fields. CURLFile may be used for uploads instead.
 *   Added in PHP 5.5.0 with FALSE as the default value. PHP 5.6.0
 *   changes the default value to TRUE. PHP 7 removes this option; the
 *   CURLFile interface must be used to upload files. CURLOPT_SASL_IR
 *   TRUE to enable sending the initial response in the first packet.
 *   Added in cURL 7.31.10. Available since PHP 7.0.7.
 *   CURLOPT_SSL_ENABLE_ALPN FALSE to disable ALPN in the SSL handshake
 *   (if the SSL backend libcurl is built to use supports it), which can
 *   be used to negotiate http2. Added in cURL 7.36.0. Available since
 *   PHP 7.0.7. CURLOPT_SSL_ENABLE_NPN FALSE to disable NPN in the SSL
 *   handshake (if the SSL backend libcurl is built to use supports it),
 *   which can be used to negotiate http2. Added in cURL 7.36.0.
 *   Available since PHP 7.0.7. CURLOPT_SSL_VERIFYPEER FALSE to stop cURL
 *   from verifying the peer's certificate. Alternate certificates to
 *   verify against can be specified with the CURLOPT_CAINFO option or a
 *   certificate directory can be specified with the CURLOPT_CAPATH
 *   option. TRUE by default as of cURL 7.10. Default bundle installed as
 *   of cURL 7.10. CURLOPT_SSL_VERIFYSTATUS TRUE to verify the
 *   certificate's status. Added in cURL 7.41.0. Available since PHP
 *   7.0.7. CURLOPT_TCP_FASTOPEN TRUE to enable TCP Fast Open. Added in
 *   cURL 7.49.0. Available since PHP 7.0.7. CURLOPT_TFTP_NO_OPTIONS TRUE
 *   to not send TFTP options requests. Added in cURL 7.48.0. Available
 *   since PHP 7.0.7. CURLOPT_TRANSFERTEXT TRUE to use ASCII mode for FTP
 *   transfers. For LDAP, it retrieves data in plain text instead of
 *   HTML. On Windows systems, it will not set STDOUT to binary mode.
 *   CURLOPT_UNRESTRICTED_AUTH TRUE to keep sending the username and
 *   password when following locations (using CURLOPT_FOLLOWLOCATION),
 *   even when the hostname has changed. CURLOPT_UPLOAD TRUE to prepare
 *   for an upload. CURLOPT_VERBOSE TRUE to output verbose information.
 *   Writes output to STDERR, or the file specified using CURLOPT_STDERR.
 *   {@link value} should be an integer for the following values of the
 *   {@link option} parameter: Option Set {@link value} to Notes
 *   CURLOPT_BUFFERSIZE The size of the buffer to use for each read.
 *   There is no guarantee this request will be fulfilled, however. Added
 *   in cURL 7.10. CURLOPT_CLOSEPOLICY One of the CURLCLOSEPOLICY_*
 *   values. This option is deprecated, as it was never implemented in
 *   cURL and never had any effect. Removed in PHP 5.6.0.
 *   CURLOPT_CONNECTTIMEOUT The number of seconds to wait while trying to
 *   connect. Use 0 to wait indefinitely. CURLOPT_CONNECTTIMEOUT_MS The
 *   number of milliseconds to wait while trying to connect. Use 0 to
 *   wait indefinitely. If libcurl is built to use the standard system
 *   name resolver, that portion of the connect will still use
 *   full-second resolution for timeouts with a minimum timeout allowed
 *   of one second. Added in cURL 7.16.2. Available since PHP 5.2.3.
 *   CURLOPT_DNS_CACHE_TIMEOUT The number of seconds to keep DNS entries
 *   in memory. This option is set to 120 (2 minutes) by default.
 *   CURLOPT_EXPECT_100_TIMEOUT_MS The timeout for Expect: 100-continue
 *   responses in milliseconds. Defaults to 1000 milliseconds. Added in
 *   cURL 7.36.0. Available since PHP 7.0.7. CURLOPT_FTPSSLAUTH The FTP
 *   authentication method (when is activated): CURLFTPAUTH_SSL (try SSL
 *   first), CURLFTPAUTH_TLS (try TLS first), or CURLFTPAUTH_DEFAULT (let
 *   cURL decide). Added in cURL 7.12.2. CURLOPT_HEADEROPT How to deal
 *   with headers. One of the following constants: CURLHEADER_UNIFIED:
 *   the headers specified in CURLOPT_HTTPHEADER will be used in requests
 *   both to servers and proxies. With this option enabled,
 *   CURLOPT_PROXYHEADER will not have any effect. CURLHEADER_SEPARATE:
 *   makes CURLOPT_HTTPHEADER headers only get sent to a server and not
 *   to a proxy. Proxy headers must be set with CURLOPT_PROXYHEADER to
 *   get used. Note that if a non-CONNECT request is sent to a proxy,
 *   libcurl will send both server headers and proxy headers. When doing
 *   CONNECT, libcurl will send CURLOPT_PROXYHEADER headers only to the
 *   proxy and then CURLOPT_HTTPHEADER headers only to the server.
 *   Defaults to CURLHEADER_SEPARATE as of cURL 7.42.1, and
 *   CURLHEADER_UNIFIED before. Added in cURL 7.37.0. Available since PHP
 *   7.0.7. CURLOPT_HTTP_VERSION {@link CURL_HTTP_VERSION_NONE} (default,
 *   lets CURL decide which version to use), {@link
 *   CURL_HTTP_VERSION_1_0} (forces HTTP/1.0), or {@link
 *   CURL_HTTP_VERSION_1_1} (forces HTTP/1.1). CURLOPT_HTTPAUTH The HTTP
 *   authentication method(s) to use. The options are: {@link
 *   CURLAUTH_BASIC}, {@link CURLAUTH_DIGEST}, {@link
 *   CURLAUTH_GSSNEGOTIATE}, {@link CURLAUTH_NTLM}, {@link CURLAUTH_ANY},
 *   and {@link CURLAUTH_ANYSAFE}. The bitwise | (or) operator can be
 *   used to combine more than one method. If this is done, cURL will
 *   poll the server to see what methods it supports and pick the best
 *   one. {@link CURLAUTH_ANY} is an alias for CURLAUTH_BASIC |
 *   CURLAUTH_DIGEST | CURLAUTH_GSSNEGOTIATE | CURLAUTH_NTLM. {@link
 *   CURLAUTH_ANYSAFE} is an alias for CURLAUTH_DIGEST |
 *   CURLAUTH_GSSNEGOTIATE | CURLAUTH_NTLM. CURLOPT_INFILESIZE The
 *   expected size, in bytes, of the file when uploading a file to a
 *   remote site. Note that using this option will not stop libcurl from
 *   sending more data, as exactly what is sent depends on
 *   CURLOPT_READFUNCTION. CURLOPT_LOW_SPEED_LIMIT The transfer speed, in
 *   bytes per second, that the transfer should be below during the count
 *   of CURLOPT_LOW_SPEED_TIME seconds before PHP considers the transfer
 *   too slow and aborts. CURLOPT_LOW_SPEED_TIME The number of seconds
 *   the transfer speed should be below CURLOPT_LOW_SPEED_LIMIT before
 *   PHP considers the transfer too slow and aborts. CURLOPT_MAXCONNECTS
 *   The maximum amount of persistent connections that are allowed. When
 *   the limit is reached, CURLOPT_CLOSEPOLICY is used to determine which
 *   connection to close. CURLOPT_MAXREDIRS The maximum amount of HTTP
 *   redirections to follow. Use this option alongside
 *   CURLOPT_FOLLOWLOCATION. CURLOPT_PORT An alternative port number to
 *   connect to. CURLOPT_POSTREDIR A bitmask of 1 (301 Moved
 *   Permanently), 2 (302 Found) and 4 (303 See Other) if the HTTP POST
 *   method should be maintained when CURLOPT_FOLLOWLOCATION is set and a
 *   specific type of redirect occurs. Added in cURL 7.19.1. Available
 *   since PHP 5.3.2. CURLOPT_PROTOCOLS Bitmask of CURLPROTO_* values. If
 *   used, this bitmask limits what protocols libcurl may use in the
 *   transfer. This allows you to have a libcurl built to support a wide
 *   range of protocols but still limit specific transfers to only be
 *   allowed to use a subset of them. By default libcurl will accept all
 *   protocols it supports. See also CURLOPT_REDIR_PROTOCOLS. Valid
 *   protocol options are: {@link CURLPROTO_HTTP}, {@link
 *   CURLPROTO_HTTPS}, {@link CURLPROTO_FTP}, {@link CURLPROTO_FTPS},
 *   {@link CURLPROTO_SCP}, {@link CURLPROTO_SFTP}, {@link
 *   CURLPROTO_TELNET}, {@link CURLPROTO_LDAP}, {@link CURLPROTO_LDAPS},
 *   {@link CURLPROTO_DICT}, {@link CURLPROTO_FILE}, {@link
 *   CURLPROTO_TFTP}, {@link CURLPROTO_ALL} Added in cURL 7.19.4.
 *   CURLOPT_PROXYAUTH The HTTP authentication method(s) to use for the
 *   proxy connection. Use the same bitmasks as described in
 *   CURLOPT_HTTPAUTH. For proxy authentication, only {@link
 *   CURLAUTH_BASIC} and {@link CURLAUTH_NTLM} are currently supported.
 *   Added in cURL 7.10.7. CURLOPT_PROXYPORT The port number of the proxy
 *   to connect to. This port number can also be set in CURLOPT_PROXY.
 *   CURLOPT_PROXYTYPE Either CURLPROXY_HTTP (default), CURLPROXY_SOCKS4,
 *   CURLPROXY_SOCKS5, CURLPROXY_SOCKS4A or CURLPROXY_SOCKS5_HOSTNAME.
 *   Added in cURL 7.10. CURLOPT_REDIR_PROTOCOLS Bitmask of CURLPROTO_*
 *   values. If used, this bitmask limits what protocols libcurl may use
 *   in a transfer that it follows to in a redirect when
 *   CURLOPT_FOLLOWLOCATION is enabled. This allows you to limit specific
 *   transfers to only be allowed to use a subset of protocols in
 *   redirections. By default libcurl will allow all protocols except for
 *   FILE and SCP. This is a difference compared to pre-7.19.4 versions
 *   which unconditionally would follow to all protocols supported. See
 *   also CURLOPT_PROTOCOLS for protocol constant values. Added in cURL
 *   7.19.4. CURLOPT_RESUME_FROM The offset, in bytes, to resume a
 *   transfer from. CURLOPT_SSL_OPTIONS Set SSL behavior options, which
 *   is a bitmask of any of the following constants:
 *   CURLSSLOPT_ALLOW_BEAST: do not attempt to use any workarounds for a
 *   security flaw in the SSL3 and TLS1.0 protocols.
 *   CURLSSLOPT_NO_REVOKE: disable certificate revocation checks for
 *   those SSL backends where such behavior is present. Added in cURL
 *   7.25.0. Available since PHP 7.0.7. CURLOPT_SSL_VERIFYHOST 1 to check
 *   the existence of a common name in the SSL peer certificate. 2 to
 *   check the existence of a common name and also verify that it matches
 *   the hostname provided. 0 to not check the names. In production
 *   environments the value of this option should be kept at 2 (default
 *   value). Support for value 1 removed in cURL 7.28.1.
 *   CURLOPT_SSLVERSION One of CURL_SSLVERSION_DEFAULT (0),
 *   CURL_SSLVERSION_TLSv1 (1), CURL_SSLVERSION_SSLv2 (2),
 *   CURL_SSLVERSION_SSLv3 (3), CURL_SSLVERSION_TLSv1_0 (4),
 *   CURL_SSLVERSION_TLSv1_1 (5) or CURL_SSLVERSION_TLSv1_2 (6). Your
 *   best bet is to not set this and let it use the default. Setting it
 *   to 2 or 3 is very dangerous given the known vulnerabilities in SSLv2
 *   and SSLv3. CURLOPT_STREAM_WEIGHT Set the numerical stream weight (a
 *   number between 1 and 256). Added in cURL 7.46.0. Available since PHP
 *   7.0.7. CURLOPT_TIMECONDITION How CURLOPT_TIMEVALUE is treated. Use
 *   {@link CURL_TIMECOND_IFMODSINCE} to return the page only if it has
 *   been modified since the time specified in CURLOPT_TIMEVALUE. If it
 *   hasn't been modified, a "304 Not Modified" header will be returned
 *   assuming CURLOPT_HEADER is TRUE. Use {@link
 *   CURL_TIMECOND_IFUNMODSINCE} for the reverse effect. {@link
 *   CURL_TIMECOND_IFMODSINCE} is the default. CURLOPT_TIMEOUT The
 *   maximum number of seconds to allow cURL functions to execute.
 *   CURLOPT_TIMEOUT_MS The maximum number of milliseconds to allow cURL
 *   functions to execute. If libcurl is built to use the standard system
 *   name resolver, that portion of the connect will still use
 *   full-second resolution for timeouts with a minimum timeout allowed
 *   of one second. Added in cURL 7.16.2. Available since PHP 5.2.3.
 *   CURLOPT_TIMEVALUE The time in seconds since January 1st, 1970. The
 *   time will be used by CURLOPT_TIMECONDITION. By default, {@link
 *   CURL_TIMECOND_IFMODSINCE} is used. CURLOPT_MAX_RECV_SPEED_LARGE If a
 *   download exceeds this speed (counted in bytes per second) on
 *   cumulative average during the transfer, the transfer will pause to
 *   keep the average rate less than or equal to the parameter value.
 *   Defaults to unlimited speed. Added in cURL 7.15.5. Available since
 *   PHP 5.4.0. CURLOPT_MAX_SEND_SPEED_LARGE If an upload exceeds this
 *   speed (counted in bytes per second) on cumulative average during the
 *   transfer, the transfer will pause to keep the average rate less than
 *   or equal to the parameter value. Defaults to unlimited speed. Added
 *   in cURL 7.15.5. Available since PHP 5.4.0. CURLOPT_SSH_AUTH_TYPES A
 *   bitmask consisting of one or more of CURLSSH_AUTH_PUBLICKEY,
 *   CURLSSH_AUTH_PASSWORD, CURLSSH_AUTH_HOST, CURLSSH_AUTH_KEYBOARD. Set
 *   to CURLSSH_AUTH_ANY to let libcurl pick one. Added in cURL 7.16.1.
 *   CURLOPT_IPRESOLVE Allows an application to select what kind of IP
 *   addresses to use when resolving host names. This is only interesting
 *   when using host names that resolve addresses using more than one
 *   version of IP, possible values are CURL_IPRESOLVE_WHATEVER,
 *   CURL_IPRESOLVE_V4, CURL_IPRESOLVE_V6, by default
 *   CURL_IPRESOLVE_WHATEVER. Added in cURL 7.10.8.
 *   CURLOPT_FTP_FILEMETHOD Tell curl which method to use to reach a file
 *   on a FTP(S) server. Possible values are CURLFTPMETHOD_MULTICWD,
 *   CURLFTPMETHOD_NOCWD and CURLFTPMETHOD_SINGLECWD. Added in cURL
 *   7.15.1. Available since PHP 5.3.0. {@link value} should be a string
 *   for the following values of the {@link option} parameter: Option Set
 *   {@link value} to Notes CURLOPT_CAINFO The name of a file holding one
 *   or more certificates to verify the peer with. This only makes sense
 *   when used in combination with CURLOPT_SSL_VERIFYPEER. Might require
 *   an absolute path. CURLOPT_CAPATH A directory that holds multiple CA
 *   certificates. Use this option alongside CURLOPT_SSL_VERIFYPEER.
 *   CURLOPT_COOKIE The contents of the "Cookie: " header to be used in
 *   the HTTP request. Note that multiple cookies are separated with a
 *   semicolon followed by a space (e.g., "fruit=apple; colour=red")
 *   CURLOPT_COOKIEFILE The name of the file containing the cookie data.
 *   The cookie file can be in Netscape format, or just plain HTTP-style
 *   headers dumped into a file. If the name is an empty string, no
 *   cookies are loaded, but cookie handling is still enabled.
 *   CURLOPT_COOKIEJAR The name of a file to save all internal cookies to
 *   when the handle is closed, e.g. after a call to curl_close.
 *   CURLOPT_CUSTOMREQUEST A custom request method to use instead of
 *   "GET" or "HEAD" when doing a HTTP request. This is useful for doing
 *   "DELETE" or other, more obscure HTTP requests. Valid values are
 *   things like "GET", "POST", "CONNECT" and so on; i.e. Do not enter a
 *   whole HTTP request line here. For instance, entering "GET
 *   /index.html HTTP/1.0\r\n\r\n" would be incorrect. Don't do this
 *   without making sure the server supports the custom request method
 *   first. CURLOPT_DEFAULT_PROTOCOL The default protocol to use if the
 *   URL is missing a scheme name. Added in cURL 7.45.0. Available since
 *   PHP 7.0.7. CURLOPT_DNS_INTERFACE Set the name of the network
 *   interface that the DNS resolver should bind to. This must be an
 *   interface name (not an address). Added in cURL 7.33.0. Available
 *   since PHP 7.0.7. CURLOPT_DNS_LOCAL_IP4 Set the local IPv4 address
 *   that the resolver should bind to. The argument should contain a
 *   single numerical IPv4 address as a string. Added in cURL 7.33.0.
 *   Available since PHP 7.0.7. CURLOPT_DNS_LOCAL_IP6 Set the local IPv6
 *   address that the resolver should bind to. The argument should
 *   contain a single numerical IPv6 address as a string. Added in cURL
 *   7.33.0. Available since PHP 7.0.7. CURLOPT_EGDSOCKET Like
 *   CURLOPT_RANDOM_FILE, except a filename to an Entropy Gathering
 *   Daemon socket. CURLOPT_ENCODING The contents of the
 *   "Accept-Encoding: " header. This enables decoding of the response.
 *   Supported encodings are "identity", "deflate", and "gzip". If an
 *   empty string, "", is set, a header containing all supported encoding
 *   types is sent. Added in cURL 7.10. CURLOPT_FTPPORT The value which
 *   will be used to get the IP address to use for the FTP "PORT"
 *   instruction. The "PORT" instruction tells the remote server to
 *   connect to our specified IP address. The string may be a plain IP
 *   address, a hostname, a network interface name (under Unix), or just
 *   a plain '-' to use the systems default IP address. CURLOPT_INTERFACE
 *   The name of the outgoing network interface to use. This can be an
 *   interface name, an IP address or a host name. CURLOPT_KEYPASSWD The
 *   password required to use the CURLOPT_SSLKEY or
 *   CURLOPT_SSH_PRIVATE_KEYFILE private key. Added in cURL 7.16.1.
 *   CURLOPT_KRB4LEVEL The KRB4 (Kerberos 4) security level. Any of the
 *   following values (in order from least to most powerful) are valid:
 *   "clear", "safe", "confidential", "private".. If the string does not
 *   match one of these, "private" is used. Setting this option to NULL
 *   will disable KRB4 security. Currently KRB4 security only works with
 *   FTP transactions. CURLOPT_LOGIN_OPTIONS Can be used to set protocol
 *   specific login options, such as the preferred authentication
 *   mechanism via "AUTH=NTLM" or "AUTH=*", and should be used in
 *   conjunction with the CURLOPT_USERNAME option. Added in cURL 7.34.0.
 *   Available since PHP 7.0.7. CURLOPT_PINNEDPUBLICKEY Set the pinned
 *   public key. The string can be the file name of your pinned public
 *   key. The file format expected is "PEM" or "DER". The string can also
 *   be any number of base64 encoded sha256 hashes preceded by "sha256//"
 *   and separated by ";". Added in cURL 7.39.0. Available since PHP
 *   7.0.7. CURLOPT_POSTFIELDS The full data to post in a HTTP "POST"
 *   operation. To post a file, prepend a filename with @ and use the
 *   full path. The filetype can be explicitly specified by following the
 *   filename with the type in the format ';type=mimetype'. This
 *   parameter can either be passed as a urlencoded string like
 *   'para1=val1&para2=val2&...' or as an array with the field name as
 *   key and field data as value. If {@link value} is an array, the
 *   Content-Type header will be set to multipart/form-data. As of PHP
 *   5.2.0, {@link value} must be an array if files are passed to this
 *   option with the @ prefix. As of PHP 5.5.0, the @ prefix is
 *   deprecated and files can be sent using CURLFile. The @ prefix can be
 *   disabled for safe passing of values beginning with @ by setting the
 *   CURLOPT_SAFE_UPLOAD option to TRUE. CURLOPT_PRIVATE Any data that
 *   should be associated with this cURL handle. This data can
 *   subsequently be retrieved with the CURLINFO_PRIVATE option of {@link
 *   curl_getinfo}. cURL does nothing with this data. When using a cURL
 *   multi handle, this private data is typically a unique key to
 *   identify a standard cURL handle. Added in cURL 7.10.3. CURLOPT_PROXY
 *   The HTTP proxy to tunnel requests through.
 *   CURLOPT_PROXY_SERVICE_NAME The proxy authentication service name.
 *   Added in cURL 7.34.0. Available since PHP 7.0.7.
 *   CURLOPT_PROXYUSERPWD A username and password formatted as
 *   "[username]:[password]" to use for the connection to the proxy.
 *   CURLOPT_RANDOM_FILE A filename to be used to seed the random number
 *   generator for SSL. CURLOPT_RANGE Range(s) of data to retrieve in the
 *   format "X-Y" where X or Y are optional. HTTP transfers also support
 *   several intervals, separated with commas in the format "X-Y,N-M".
 *   CURLOPT_REFERER The contents of the "Referer: " header to be used in
 *   a HTTP request. CURLOPT_SERVICE_NAME The authentication service
 *   name. Added in cURL 7.43.0. Available since PHP 7.0.7.
 *   CURLOPT_SSH_HOST_PUBLIC_KEY_MD5 A string containing 32 hexadecimal
 *   digits. The string should be the MD5 checksum of the remote host's
 *   public key, and libcurl will reject the connection to the host
 *   unless the md5sums match. This option is only for SCP and SFTP
 *   transfers. Added in cURL 7.17.1. CURLOPT_SSH_PUBLIC_KEYFILE The file
 *   name for your public key. If not used, libcurl defaults to
 *   $HOME/.ssh/id_dsa.pub if the HOME environment variable is set, and
 *   just "id_dsa.pub" in the current directory if HOME is not set. Added
 *   in cURL 7.16.1. CURLOPT_SSH_PRIVATE_KEYFILE The file name for your
 *   private key. If not used, libcurl defaults to $HOME/.ssh/id_dsa if
 *   the HOME environment variable is set, and just "id_dsa" in the
 *   current directory if HOME is not set. If the file is
 *   password-protected, set the password with CURLOPT_KEYPASSWD. Added
 *   in cURL 7.16.1. CURLOPT_SSL_CIPHER_LIST A list of ciphers to use for
 *   SSL. For example, RC4-SHA and TLSv1 are valid cipher lists.
 *   CURLOPT_SSLCERT The name of a file containing a PEM formatted
 *   certificate. CURLOPT_SSLCERTPASSWD The password required to use the
 *   CURLOPT_SSLCERT certificate. CURLOPT_SSLCERTTYPE The format of the
 *   certificate. Supported formats are "PEM" (default), "DER", and
 *   "ENG". Added in cURL 7.9.3. CURLOPT_SSLENGINE The identifier for the
 *   crypto engine of the private SSL key specified in CURLOPT_SSLKEY.
 *   CURLOPT_SSLENGINE_DEFAULT The identifier for the crypto engine used
 *   for asymmetric crypto operations. CURLOPT_SSLKEY The name of a file
 *   containing a private SSL key. CURLOPT_SSLKEYPASSWD The secret
 *   password needed to use the private SSL key specified in
 *   CURLOPT_SSLKEY. Since this option contains a sensitive password,
 *   remember to keep the PHP script it is contained within safe.
 *   CURLOPT_SSLKEYTYPE The key type of the private SSL key specified in
 *   CURLOPT_SSLKEY. Supported key types are "PEM" (default), "DER", and
 *   "ENG". CURLOPT_UNIX_SOCKET_PATH Enables the use of Unix domain
 *   sockets as connection endpoint and sets the path to the given
 *   string. Added in cURL 7.40.0. Available since PHP 7.0.7. CURLOPT_URL
 *   The URL to fetch. This can also be set when initializing a session
 *   with {@link curl_init}. CURLOPT_USERAGENT The contents of the
 *   "User-Agent: " header to be used in a HTTP request. CURLOPT_USERNAME
 *   The user name to use in authentication. Added in cURL 7.19.1.
 *   Available since PHP 5.5.0. CURLOPT_USERPWD A username and password
 *   formatted as "[username]:[password]" to use for the connection.
 *   CURLOPT_XOAUTH2_BEARER Specifies the OAuth 2.0 access token. Added
 *   in cURL 7.33.0. Available since PHP 7.0.7. {@link value} should be
 *   an array for the following values of the {@link option} parameter:
 *   Option Set {@link value} to Notes CURLOPT_CONNECT_TO Connect to a
 *   specific host and port instead of the URL's host and port. Accepts
 *   an array of strings with the format
 *   HOST:PORT:CONNECT-TO-HOST:CONNECT-TO-PORT. Added in cURL 7.49.0.
 *   Available since PHP 7.0.7. CURLOPT_HTTP200ALIASES An array of HTTP
 *   200 responses that will be treated as valid responses and not as
 *   errors. Added in cURL 7.10.3. CURLOPT_HTTPHEADER An array of HTTP
 *   header fields to set, in the format array('Content-type:
 *   text/plain', 'Content-length: 100') CURLOPT_POSTQUOTE An array of
 *   FTP commands to execute on the server after the FTP request has been
 *   performed. CURLOPT_PROXYHEADER An array of custom HTTP headers to
 *   pass to proxies. Added in cURL 7.37.0. Available since PHP 7.0.7.
 *   CURLOPT_QUOTE An array of FTP commands to execute on the server
 *   prior to the FTP request. CURLOPT_RESOLVE Provide a custom address
 *   for a specific host and port pair. An array of hostname, port, and
 *   IP address strings, each element separated by a colon. In the
 *   format: array("example.com:80:127.0.0.1") Added in cURL 7.21.3.
 *   Available since PHP 5.5.0. {@link value} should be a stream resource
 *   (using {@link fopen}, for example) for the following values of the
 *   {@link option} parameter: Option Set {@link value} to CURLOPT_FILE
 *   The file that the transfer should be written to. The default is
 *   STDOUT (the browser window). CURLOPT_INFILE The file that the
 *   transfer should be read from when uploading. CURLOPT_STDERR An
 *   alternative location to output errors to instead of STDERR.
 *   CURLOPT_WRITEHEADER The file that the header part of the transfer is
 *   written to. {@link value} should be the name of a valid function or
 *   a Closure for the following values of the {@link option} parameter:
 *   Option Set {@link value} to CURLOPT_HEADERFUNCTION A callback
 *   accepting two parameters. The first is the cURL resource, the second
 *   is a string with the header data to be written. The header data must
 *   be written by this callback. Return the number of bytes written.
 *   CURLOPT_PASSWDFUNCTION A callback accepting three parameters. The
 *   first is the cURL resource, the second is a string containing a
 *   password prompt, and the third is the maximum password length.
 *   Return the string containing the password. CURLOPT_PROGRESSFUNCTION
 *   A callback accepting five parameters. The first is the cURL
 *   resource, the second is the total number of bytes expected to be
 *   downloaded in this transfer, the third is the number of bytes
 *   downloaded so far, the fourth is the total number of bytes expected
 *   to be uploaded in this transfer, and the fifth is the number of
 *   bytes uploaded so far. The callback is only called when the
 *   CURLOPT_NOPROGRESS option is set to FALSE. Return a non-zero value
 *   to abort the transfer. In which case, the transfer will set a
 *   CURLE_ABORTED_BY_CALLBACK error. CURLOPT_READFUNCTION A callback
 *   accepting three parameters. The first is the cURL resource, the
 *   second is a stream resource provided to cURL through the option
 *   CURLOPT_INFILE, and the third is the maximum amount of data to be
 *   read. The callback must return a string with a length equal or
 *   smaller than the amount of data requested, typically by reading it
 *   from the passed stream resource. It should return an empty string to
 *   signal EOF. CURLOPT_WRITEFUNCTION A callback accepting two
 *   parameters. The first is the cURL resource, and the second is a
 *   string with the data to be written. The data must be saved by this
 *   callback. It must return the exact number of bytes written or the
 *   transfer will be aborted with an error. Other values: Option Set
 *   {@link value} to CURLOPT_SHARE A result of {@link curl_share_init}.
 *   Makes the cURL handle to use the data from the shared handle.
 * @param mixed $value
 * @return bool
 * @since PHP 4 >= 4.0.2, PHP 5, PHP 7
 **/
function curl_setopt($ch, $option, $value){}

/**
 * Set multiple options for a cURL transfer
 *
 * Sets multiple options for a cURL session. This function is useful for
 * setting a large number of cURL options without repetitively calling
 * {@link curl_setopt}.
 *
 * @param resource $ch An array specifying which options to set and
 *   their values. The keys should be valid {@link curl_setopt} constants
 *   or their integer equivalents.
 * @param array $options
 * @return bool Returns TRUE if all options were successfully set. If
 *   an option could not be successfully set, FALSE is immediately
 *   returned, ignoring any future options in the {@link options} array.
 * @since PHP 5 >= 5.1.3, PHP 7
 **/
function curl_setopt_array($ch, $options){}

/**
 * Close a cURL share handle
 *
 * Closes a cURL share handle and frees all resources.
 *
 * @param resource $sh A cURL share handle returned by {@link
 *   curl_share_init}
 * @return void
 * @since PHP 5 >= 5.5.0, PHP 7
 **/
function curl_share_close($sh){}

/**
 * Return the last share curl error number
 *
 * Return an integer containing the last share curl error number.
 *
 * @param resource $sh A cURL share handle returned by {@link
 *   curl_share_init}.
 * @return int Returns an integer containing the last share curl error
 *   number, .
 * @since PHP 7 >= 7.1.0
 **/
function curl_share_errno($sh){}

/**
 * Initialize a cURL share handle
 *
 * Allows to share data between cURL handles.
 *
 * @return resource Returns resource of type "cURL Share Handle".
 * @since PHP 5 >= 5.5.0, PHP 7
 **/
function curl_share_init(){}

/**
 * Set an option for a cURL share handle
 *
 * Sets an option on the given cURL share handle.
 *
 * @param resource $sh A cURL share handle returned by {@link
 *   curl_share_init}.
 * @param int $option Option Description CURLSHOPT_SHARE Specifies a
 *   type of data that should be shared. CURLSHOPT_UNSHARE Specifies a
 *   type of data that will be no longer shared.
 * @param string $value Value Description CURL_LOCK_DATA_COOKIE Shares
 *   cookie data. CURL_LOCK_DATA_DNS Shares DNS cache. Note that when you
 *   use cURL multi handles, all handles added to the same multi handle
 *   will share DNS cache by default. CURL_LOCK_DATA_SSL_SESSION Shares
 *   SSL session IDs, reducing the time spent on the SSL handshake when
 *   reconnecting to the same server. Note that SSL session IDs are
 *   reused within the same handle by default.
 * @return bool
 * @since PHP 5 >= 5.5.0, PHP 7
 **/
function curl_share_setopt($sh, $option, $value){}

/**
 * Return string describing the given error code
 *
 * Returns a text error message describing the given error code.
 *
 * @param int $errornum One of the cURL error codes constants.
 * @return string Returns error description or NULL for invalid error
 *   code.
 * @since PHP 7 >= 7.1.0
 **/
function curl_share_strerror($errornum){}

/**
 * Return string describing the given error code
 *
 * Returns a text error message describing the given error code.
 *
 * @param int $errornum One of the cURL error codes constants.
 * @return string Returns error description or NULL for invalid error
 *   code.
 * @since PHP 5 >= 5.5.0, PHP 7
 **/
function curl_strerror($errornum){}

/**
 * Decodes the given URL encoded string
 *
 * This function decodes the given URL encoded string.
 *
 * @param resource $ch The URL encoded string to be decoded.
 * @param string $str
 * @return string Returns decoded string .
 * @since PHP 5 >= 5.5.0, PHP 7
 **/
function curl_unescape($ch, $str){}

/**
 * Gets cURL version information
 *
 * Returns information about the cURL version.
 *
 * @param int $age
 * @return array Returns an associative array with the following
 *   elements: Indice Value description version_number cURL 24 bit
 *   version number version cURL version number, as a string
 *   ssl_version_number OpenSSL 24 bit version number ssl_version OpenSSL
 *   version number, as a string libz_version zlib version number, as a
 *   string host Information about the host where cURL was built age
 *   features A bitmask of the CURL_VERSION_XXX constants protocols An
 *   array of protocols names supported by cURL
 * @since PHP 4 >= 4.0.2, PHP 5, PHP 7
 **/
function curl_version($age){}

/**
 * Return the current element in an array
 *
 * Every array has an internal pointer to its "current" element, which is
 * initialized to the first element inserted into the array.
 *
 * @param array $array The array.
 * @return mixed The {@link current} function simply returns the value
 *   of the array element that's currently being pointed to by the
 *   internal pointer. It does not move the pointer in any way. If the
 *   internal pointer points beyond the end of the elements list or the
 *   array is empty, {@link current} returns FALSE.
 * @since PHP 4, PHP 5, PHP 7
 **/
function current($array){}

/**
 * Authenticate against a Cyrus IMAP server
 *
 * @param resource $connection
 * @param string $mechlist
 * @param string $service
 * @param string $user
 * @param int $minssf
 * @param int $maxssf
 * @param string $authname
 * @param string $password
 * @return void
 * @since PHP 4 >= 4.1.0, PECL cyrus 1.0
 **/
function cyrus_authenticate($connection, $mechlist, $service, $user, $minssf, $maxssf, $authname, $password){}

/**
 * Bind callbacks to a Cyrus IMAP connection
 *
 * Binds callbacks to a Cyrus IMAP connection.
 *
 * @param resource $connection The connection handle.
 * @param array $callbacks An array of callbacks.
 * @return bool
 * @since PHP 4 >= 4.1.0, PECL cyrus 1.0
 **/
function cyrus_bind($connection, $callbacks){}

/**
 * Close connection to a Cyrus IMAP server
 *
 * Closes the connection to a Cyrus IMAP server.
 *
 * @param resource $connection The connection handle.
 * @return bool
 * @since PHP 4 >= 4.1.0, PECL cyrus 1.0
 **/
function cyrus_close($connection){}

/**
 * Connect to a Cyrus IMAP server
 *
 * Connects to a Cyrus IMAP server.
 *
 * @param string $host The Cyrus IMAP host name.
 * @param string $port The port number.
 * @param int $flags
 * @return resource Returns a connection handler on success.
 * @since PHP 4 >= 4.1.0, PECL cyrus 1.0
 **/
function cyrus_connect($host, $port, $flags){}

/**
 * Send a query to a Cyrus IMAP server
 *
 * Sends a query to a Cyrus IMAP server.
 *
 * @param resource $connection The connection handle.
 * @param string $query The query string.
 * @return array Returns an associative array with the following keys:
 *   text, msgno, and keyword.
 * @since PHP 4 >= 4.1.0, PECL cyrus 1.0
 **/
function cyrus_query($connection, $query){}

/**
 * Unbind ...
 *
 * @param resource $connection The connection handle.
 * @param string $trigger_name The trigger name.
 * @return bool
 * @since PHP 4 >= 4.1.0, PECL cyrus 1.0
 **/
function cyrus_unbind($connection, $trigger_name){}

/**
 * Format a local time/date
 *
 * Returns a string formatted according to the given format string using
 * the given integer {@link timestamp} or the current time if no
 * timestamp is given. In other words, {@link timestamp} is optional and
 * defaults to the value of {@link time}.
 *
 * @param string $format The format of the outputted date string. See
 *   the formatting options below. There are also several predefined date
 *   constants that may be used instead, so for example DATE_RSS contains
 *   the format string 'D, d M Y H:i:s'.
 *   
 *   The following characters are recognized in the {@link format}
 *   parameter string {@link format} character Description Example
 *   returned values Day --- --- d Day of the month, 2 digits with
 *   leading zeros 01 to 31 D A textual representation of a day, three
 *   letters Mon through Sun j Day of the month without leading zeros 1
 *   to 31 l (lowercase 'L') A full textual representation of the day of
 *   the week Sunday through Saturday N ISO-8601 numeric representation
 *   of the day of the week (added in PHP 5.1.0) 1 (for Monday) through 7
 *   (for Sunday) S English ordinal suffix for the day of the month, 2
 *   characters st, nd, rd or th. Works well with j w Numeric
 *   representation of the day of the week 0 (for Sunday) through 6 (for
 *   Saturday) z The day of the year (starting from 0) 0 through 365 Week
 *   --- --- W ISO-8601 week number of year, weeks starting on Monday
 *   Example: 42 (the 42nd week in the year) Month --- --- F A full
 *   textual representation of a month, such as January or March January
 *   through December m Numeric representation of a month, with leading
 *   zeros 01 through 12 M A short textual representation of a month,
 *   three letters Jan through Dec n Numeric representation of a month,
 *   without leading zeros 1 through 12 t Number of days in the given
 *   month 28 through 31 Year --- --- L Whether it's a leap year 1 if it
 *   is a leap year, 0 otherwise. o ISO-8601 week-numbering year. This
 *   has the same value as Y, except that if the ISO week number (W)
 *   belongs to the previous or next year, that year is used instead.
 *   (added in PHP 5.1.0) Examples: 1999 or 2003 Y A full numeric
 *   representation of a year, 4 digits Examples: 1999 or 2003 y A two
 *   digit representation of a year Examples: 99 or 03 Time --- --- a
 *   Lowercase Ante meridiem and Post meridiem am or pm A Uppercase Ante
 *   meridiem and Post meridiem AM or PM B Swatch Internet time 000
 *   through 999 g 12-hour format of an hour without leading zeros 1
 *   through 12 G 24-hour format of an hour without leading zeros 0
 *   through 23 h 12-hour format of an hour with leading zeros 01 through
 *   12 H 24-hour format of an hour with leading zeros 00 through 23 i
 *   Minutes with leading zeros 00 to 59 s Seconds with leading zeros 00
 *   through 59 u Microseconds (added in PHP 5.2.2). Note that {@link
 *   date} will always generate 000000 since it takes an integer
 *   parameter, whereas DateTime::format does support microseconds if
 *   DateTime was created with microseconds. Example: 654321 v
 *   Milliseconds (added in PHP 7.0.0). Same note applies as for u.
 *   Example: 654 Timezone --- --- e Timezone identifier (added in PHP
 *   5.1.0) Examples: UTC, GMT, Atlantic/Azores I (capital i) Whether or
 *   not the date is in daylight saving time 1 if Daylight Saving Time, 0
 *   otherwise. O Difference to Greenwich time (GMT) in hours Example:
 *   +0200 P Difference to Greenwich time (GMT) with colon between hours
 *   and minutes (added in PHP 5.1.3) Example: +02:00 T Timezone
 *   abbreviation Examples: EST, MDT ... Z Timezone offset in seconds.
 *   The offset for timezones west of UTC is always negative, and for
 *   those east of UTC is always positive. -43200 through 50400 Full
 *   Date/Time --- --- c ISO 8601 date (added in PHP 5)
 *   2004-02-12T15:19:21+00:00 r RFC 2822 formatted date Example: Thu, 21
 *   Dec 2000 16:01:07 +0200 U Seconds since the Unix Epoch (January 1
 *   1970 00:00:00 GMT) See also {@link time} Unrecognized characters in
 *   the format string will be printed as-is. The Z format will always
 *   return 0 when using {@link gmdate}.
 * @param int $timestamp
 * @return string Returns a formatted date string. If a non-numeric
 *   value is used for {@link timestamp}, FALSE is returned and an
 *   E_WARNING level error is emitted.
 * @since PHP 4, PHP 5, PHP 7
 **/
function date($format, $timestamp){}

/**
 * Create a date formatter
 *
 * (constructor)
 *
 * @param string $locale Locale to use when formatting or parsing or
 *   NULL to use the value specified in the ini setting
 *   intl.default_locale.
 * @param int $datetype Date type to use (none, short, medium, long,
 *   full). This is one of the IntlDateFormatter constants. It can also
 *   be NULL, in which case ICUʼs default date type will be used.
 * @param int $timetype Time type to use (none, short, medium, long,
 *   full). This is one of the IntlDateFormatter constants. It can also
 *   be NULL, in which case ICUʼs default time type will be used.
 * @param mixed $timezone Time zone ID. The default (and the one used
 *   if NULL is given) is the one returned by {@link
 *   date_default_timezone_get} or, if applicable, that of the
 *   IntlCalendar object passed for the {@link calendar} parameter. This
 *   ID must be a valid identifier on ICUʼs database or an ID
 *   representing an explicit offset, such as GMT-05:30. This can also be
 *   an IntlTimeZone or a DateTimeZone object.
 * @param mixed $calendar Calendar to use for formatting or parsing.
 *   The default value is NULL, which corresponds to
 *   IntlDateFormatter::GREGORIAN. This can either be one of the
 *   IntlDateFormatter calendar constants or an IntlCalendar. Any
 *   IntlCalendar object passed will be clone; it will not be changed by
 *   the IntlDateFormatter. This will determine the calendar type used
 *   (gregorian, islamic, persian, etc.) and, if NULL is given for the
 *   {@link timezone} parameter, also the timezone used.
 * @param string $pattern Optional pattern to use when formatting or
 *   parsing. Possible patterns are documented at .
 * @return IntlDateFormatter The created IntlDateFormatter or FALSE in
 *   case of failure.
 * @since PHP 5 >= 5.3.0, PHP 7, PECL intl >= 1.0.0
 **/
function datefmt_create($locale, $datetype, $timetype, $timezone, $calendar, $pattern){}

/**
 * Format the date/time value as a string
 *
 * Formats the time value as a string.
 *
 * @param IntlDateFormatter $fmt The date formatter resource.
 * @param mixed $value Value to format. This may be a DateTimeInterface
 *   object, an IntlCalendar object, a numeric type representing a
 *   (possibly fractional) number of seconds since epoch or an array in
 *   the format output by {@link localtime}. If a DateTime or an
 *   IntlCalendar object is passed, its timezone is not considered. The
 *   object will be formatted using the formaterʼs configured timezone.
 *   If one wants to use the timezone of the object to be formatted,
 *   {@link IntlDateFormatter::setTimeZone} must be called before with
 *   the objectʼs timezone. Alternatively, the static function {@link
 *   IntlDateFormatter::formatObject} may be used instead.
 * @return string The formatted string or, if an error occurred, FALSE.
 * @since PHP 5 >= 5.3.0, PHP 7, PECL intl >= 1.0.0
 **/
function datefmt_format($fmt, $value){}

/**
 * Formats an object
 *
 * This function allows formatting an IntlCalendar or DateTime object
 * without first explicitly creating a IntlDateFormatter object.
 *
 * The temporary IntlDateFormatter that will be created will take the
 * timezone from the passed in object. The timezone database bundled with
 * PHP will not be used – ICU's will be used instead. The timezone
 * identifier used in DateTime objects must therefore also exist in ICU's
 * database.
 *
 * @param object $object An object of type IntlCalendar or DateTime.
 *   The timezone information in the object will be used.
 * @param mixed $format How to format the date/time. This can either be
 *   an array with two elements (first the date style, then the time
 *   style, these being one of the constants IntlDateFormatter::NONE,
 *   IntlDateFormatter::SHORT, IntlDateFormatter::MEDIUM,
 *   IntlDateFormatter::LONG, IntlDateFormatter::FULL), an integer with
 *   the value of one of these constants (in which case it will be used
 *   both for the time and the date) or a string with the format
 *   described in the ICU documentation. If NULL, the default style will
 *   be used.
 * @param string $locale The locale to use, or NULL to use the default
 *   one.
 * @return string A string with result.
 * @since PHP 5 >= 5.5.0, PHP 7
 **/
function datefmt_format_object($object, $format, $locale){}

/**
 * Get the calendar type used for the IntlDateFormatter
 *
 * @param IntlDateFormatter $fmt The formatter resource
 * @return int The calendar type being used by the formatter. Either
 *   IntlDateFormatter::TRADITIONAL or IntlDateFormatter::GREGORIAN.
 * @since PHP 5 >= 5.3.0, PHP 7, PECL intl >= 1.0.0
 **/
function datefmt_get_calendar($fmt){}

/**
 * Get copy of formatterʼs calendar object
 *
 * Obtain a copy of the calendar object used internally by this
 * formatter. This calendar will have a type (as in gregorian, japanese,
 * buddhist, roc, persian, islamic, etc.) and a timezone that match the
 * type and timezone used by the formatter. The date/time of the object
 * is unspecified.
 *
 * @return IntlCalendar A copy of the internal calendar object used by
 *   this formatter.
 * @since PHP 5 >= 5.5.0, PHP 7
 **/
function datefmt_get_calendar_object(){}

/**
 * Get the datetype used for the IntlDateFormatter
 *
 * Returns date type used by the formatter.
 *
 * @param IntlDateFormatter $fmt The formatter resource.
 * @return int The current date type value of the formatter.
 * @since PHP 5 >= 5.3.0, PHP 7, PECL intl >= 1.0.0
 **/
function datefmt_get_datetype($fmt){}

/**
 * Get the error code from last operation
 *
 * Get the error code from last operation. Returns error code from the
 * last number formatting operation.
 *
 * @param IntlDateFormatter $fmt The formatter resource.
 * @return int The error code, one of UErrorCode values. Initial value
 *   is U_ZERO_ERROR.
 * @since PHP 5 >= 5.3.0, PHP 7, PECL intl >= 1.0.0
 **/
function datefmt_get_error_code($fmt){}

/**
 * Get the error text from the last operation
 *
 * @param IntlDateFormatter $fmt The formatter resource.
 * @return string Description of the last error.
 * @since PHP 5 >= 5.3.0, PHP 7, PECL intl >= 1.0.0
 **/
function datefmt_get_error_message($fmt){}

/**
 * Get the locale used by formatter
 *
 * Get locale used by the formatter.
 *
 * @param IntlDateFormatter $fmt The formatter resource
 * @param int $which You can choose between valid and actual locale (
 *   Locale::VALID_LOCALE, Locale::ACTUAL_LOCALE, respectively). The
 *   default is the actual locale.
 * @return string the locale of this formatter or 'false' if error
 * @since PHP 5 >= 5.3.0, PHP 7, PECL intl >= 1.0.0
 **/
function datefmt_get_locale($fmt, $which){}

/**
 * Get the pattern used for the IntlDateFormatter
 *
 * Get pattern used by the formatter.
 *
 * @param IntlDateFormatter $fmt The formatter resource.
 * @return string The pattern string being used to format/parse.
 * @since PHP 5 >= 5.3.0, PHP 7, PECL intl >= 1.0.0
 **/
function datefmt_get_pattern($fmt){}

/**
 * Get the timetype used for the IntlDateFormatter
 *
 * Return time type used by the formatter.
 *
 * @param IntlDateFormatter $fmt The formatter resource.
 * @return int The current date type value of the formatter.
 * @since PHP 5 >= 5.3.0, PHP 7, PECL intl >= 1.0.0
 **/
function datefmt_get_timetype($fmt){}

/**
 * Get formatterʼs timezone
 *
 * Returns an IntlTimeZone object representing the timezone that will be
 * used by this object to format dates and times. When formatting
 * IntlCalendar and DateTime objects with this IntlDateFormatter, the
 * timezone used will be the one returned by this method, not the one
 * associated with the objects being formatted.
 *
 * @return IntlTimeZone The associated IntlTimeZone object.
 * @since PHP 5 >= 5.5.0, PHP 7
 **/
function datefmt_get_timezone(){}

/**
 * Get the timezone-id used for the IntlDateFormatter
 *
 * @param IntlDateFormatter $fmt The formatter resource.
 * @return string ID string for the time zone used by this formatter.
 * @since PHP 5 >= 5.3.0, PHP 7, PECL intl >= 1.0.0
 **/
function datefmt_get_timezone_id($fmt){}

/**
 * Get the lenient used for the IntlDateFormatter
 *
 * Check if the parser is strict or lenient in interpreting inputs that
 * do not match the pattern exactly.
 *
 * @param IntlDateFormatter $fmt The formatter resource.
 * @return bool TRUE if parser is lenient, FALSE if parser is strict.
 *   By default the parser is lenient.
 * @since PHP 5 >= 5.3.0, PHP 7, PECL intl >= 1.0.0
 **/
function datefmt_is_lenient($fmt){}

/**
 * Parse string to a field-based time value
 *
 * Converts string $value to a field-based time value ( an array of
 * various fields), starting at $parse_pos and consuming as much of the
 * input value as possible.
 *
 * @param IntlDateFormatter $fmt The formatter resource
 * @param string $value string to convert to a time
 * @param int $position Position at which to start the parsing in
 *   $value (zero-based). If no error occurs before $value is consumed,
 *   $parse_pos will contain -1 otherwise it will contain the position at
 *   which parsing ended . If $parse_pos > strlen($value), the parse
 *   fails immediately.
 * @return array Localtime compatible array of integers : contains 24
 *   hour clock value in tm_hour field
 * @since PHP 5 >= 5.3.0, PHP 7, PECL intl >= 1.0.0
 **/
function datefmt_localtime($fmt, $value, &$position){}

/**
 * Parse string to a timestamp value
 *
 * Converts string $value to an incremental time value, starting at
 * $parse_pos and consuming as much of the input value as possible.
 *
 * @param IntlDateFormatter $fmt The formatter resource
 * @param string $value string to convert to a time
 * @param int $position Position at which to start the parsing in
 *   $value (zero-based). If no error occurs before $value is consumed,
 *   $parse_pos will contain -1 otherwise it will contain the position at
 *   which parsing ended (and the error occurred). This variable will
 *   contain the end position if the parse fails. If $parse_pos >
 *   strlen($value), the parse fails immediately.
 * @return int timestamp parsed value, or FALSE if value can't be
 *   parsed.
 * @since PHP 5 >= 5.3.0, PHP 7, PECL intl >= 1.0.0
 **/
function datefmt_parse($fmt, $value, &$position){}

/**
 * Sets the calendar type used by the formatter
 *
 * Sets the calendar or calendar type used by the formatter.
 *
 * @param IntlDateFormatter $fmt The formatter resource.
 * @param mixed $which This can either be: the calendar type to use
 *   (default is IntlDateFormatter::GREGORIAN, which is also used if NULL
 *   is specified) or an IntlCalendar object. Any IntlCalendar object
 *   passed in will be cloned; no modifications will be made to the
 *   argument object. The timezone of the formatter will only be kept if
 *   an IntlCalendar object is not passed, otherwise the new timezone
 *   will be that of the passed object.
 * @return bool
 * @since PHP 5 >= 5.3.0, PHP 7, PECL intl >= 1.0.0
 **/
function datefmt_set_calendar($fmt, $which){}

/**
 * Set the leniency of the parser
 *
 * Define if the parser is strict or lenient in interpreting inputs that
 * do not match the pattern exactly. Enabling lenient parsing allows the
 * parser to accept otherwise flawed date or time patterns, parsing as
 * much as possible to obtain a value. Extra space, unrecognized tokens,
 * or invalid values ("February 30th") are not accepted.
 *
 * @param IntlDateFormatter $fmt The formatter resource
 * @param bool $lenient Sets whether the parser is lenient or not,
 *   default is TRUE (lenient).
 * @return bool
 * @since PHP 5 >= 5.3.0, PHP 7, PECL intl >= 1.0.0
 **/
function datefmt_set_lenient($fmt, $lenient){}

/**
 * Set the pattern used for the IntlDateFormatter
 *
 * @param IntlDateFormatter $fmt The formatter resource.
 * @param string $pattern New pattern string to use. Possible patterns
 *   are documented at .
 * @return bool Bad formatstrings are usually the cause of the failure.
 * @since PHP 5 >= 5.3.0, PHP 7, PECL intl >= 1.0.0
 **/
function datefmt_set_pattern($fmt, $pattern){}

/**
 * Sets formatterʼs timezone
 *
 * Sets the timezone used for the IntlDateFormatter. object.
 *
 * @param IntlDateFormatter $fmt The formatter resource.
 * @param mixed $zone The timezone to use for this formatter. This can
 *   be specified in the following forms:
 * @return bool Returns TRUE on success and FALSE on failure.
 * @since PHP 5 >= 5.5.0, PHP 7
 **/
function datefmt_set_timezone($fmt, $zone){}

/**
 * Sets the time zone to use
 *
 * @param IntlDateFormatter $fmt The formatter resource.
 * @param string $zone The time zone ID string of the time zone to use.
 *   If NULL or the empty string, the default time zone for the runtime
 *   is used.
 * @return bool
 * @since PHP 5 >= 5.3.0, PECL intl >= 1.0.0
 **/
function datefmt_set_timezone_id($fmt, $zone){}

/**
 * Adds an amount of days, months, years, hours, minutes and seconds to a
 * DateTime object
 *
 * Adds the specified DateInterval object to the specified DateTime
 * object.
 *
 * @param DateTime $object A DateInterval object
 * @param DateInterval $interval
 * @return DateTime
 * @since PHP 5 >= 5.3.0, PHP 7
 **/
function date_add($object, $interval){}

/**
 * Returns new DateTime object
 *
 * @param string $time Enter "now" here to obtain the current time when
 *   using the {@link $timezone} parameter.
 * @param DateTimeZone $timezone A DateTimeZone object representing the
 *   timezone of {@link $time}. If {@link $timezone} is omitted, the
 *   current timezone will be used.
 * @return DateTime Returns a new DateTime instance.
 * @since PHP 5 >= 5.2.0, PHP 7
 **/
function date_create($time, $timezone){}

/**
 * Parses a time string according to a specified format
 *
 * Returns a new DateTime object representing the date and time specified
 * by the {@link time} string, which was formatted in the given {@link
 * format}.
 *
 * @param string $format The format that the passed in string should be
 *   in. See the formatting options below. In most cases, the same
 *   letters as for the {@link date} can be used.
 *   
 *   The following characters are recognized in the {@link format}
 *   parameter string {@link format} character Description Example
 *   parsable values Day --- --- d and j Day of the month, 2 digits with
 *   or without leading zeros 01 to 31 or 1 to 31 D and l A textual
 *   representation of a day Mon through Sun or Sunday through Saturday S
 *   English ordinal suffix for the day of the month, 2 characters. It's
 *   ignored while processing. st, nd, rd or th. z The day of the year
 *   (starting from 0) 0 through 365 Month --- --- F and M A textual
 *   representation of a month, such as January or Sept January through
 *   December or Jan through Dec m and n Numeric representation of a
 *   month, with or without leading zeros 01 through 12 or 1 through 12
 *   Year --- --- Y A full numeric representation of a year, 4 digits
 *   Examples: 1999 or 2003 y A two digit representation of a year (which
 *   is assumed to be in the range 1970-2069, inclusive) Examples: 99 or
 *   03 (which will be interpreted as 1999 and 2003, respectively) Time
 *   --- --- a and A Ante meridiem and Post meridiem am or pm g and h
 *   12-hour format of an hour with or without leading zero 1 through 12
 *   or 01 through 12 G and H 24-hour format of an hour with or without
 *   leading zeros 0 through 23 or 00 through 23 i Minutes with leading
 *   zeros 00 to 59 s Seconds, with leading zeros 00 through 59 u
 *   Microseconds (up to six digits) Example: 45, 654321 Timezone --- ---
 *   e, O, P and T Timezone identifier, or difference to UTC in hours, or
 *   difference to UTC with colon between hours and minutes, or timezone
 *   abbreviation Examples: UTC, GMT, Atlantic/Azores or +0200 or +02:00
 *   or EST, MDT Full Date/Time --- --- U Seconds since the Unix Epoch
 *   (January 1 1970 00:00:00 GMT) Example: 1292177455 Whitespace and
 *   Separators --- --- (space) One space or one tab Example: # One of
 *   the following separation symbol: ;, :, /, ., ,, -, ( or ) Example: /
 *   ;, :, /, ., ,, -, ( or ) The specified character. Example: - ? A
 *   random byte Example: ^ (Be aware that for UTF-8 characters you might
 *   need more than one ?. In this case, using * is probably what you
 *   want instead) * Random bytes until the next separator or digit
 *   Example: * in Y-*-d with the string 2009-aWord-08 will match aWord !
 *   Resets all fields (year, month, day, hour, minute, second, fraction
 *   and timezone information) to the Unix Epoch Without !, all fields
 *   will be set to the current date and time. | Resets all fields (year,
 *   month, day, hour, minute, second, fraction and timezone information)
 *   to the Unix Epoch if they have not been parsed yet Y-m-d| will set
 *   the year, month and day to the information found in the string to
 *   parse, and sets the hour, minute and second to 0. + If this format
 *   specifier is present, trailing data in the string will not cause an
 *   error, but a warning instead Use DateTime::getLastErrors to find out
 *   whether trailing data was present. Unrecognized characters in the
 *   format string will cause the parsing to fail and an error message is
 *   appended to the returned structure. You can query error messages
 *   with DateTime::getLastErrors. To include literal characters in
 *   {@link format}, you have to escape them with a backslash (\). If
 *   {@link format} does not contain the character ! then portions of the
 *   generated time which are not specified in {@link format} will be set
 *   to the current system time. If {@link format} contains the character
 *   !, then portions of the generated time not provided in {@link
 *   format}, as well as values to the left-hand side of the !, will be
 *   set to corresponding values from the Unix epoch. The Unix epoch is
 *   1970-01-01 00:00:00 UTC.
 * @param string $time String representing the time.
 * @param DateTimeZone $timezone A DateTimeZone object representing the
 *   desired time zone. If {@link timezone} is omitted and {@link time}
 *   contains no timezone, the current timezone will be used.
 * @return DateTime Returns a new DateTime instance.
 * @since PHP 5 >= 5.3.0, PHP 7
 **/
function date_create_from_format($format, $time, $timezone){}

/**
 * Returns new DateTimeImmutable object
 *
 * Like DateTime::__construct but works with DateTimeImmutable.
 *
 * @param string $time
 * @param DateTimeZone $timezone
 * @return DateTimeImmutable
 * @since PHP 5 >= 5.5.0, PHP 7
 **/
function date_create_immutable($time, $timezone){}

/**
 * Parses a time string according to a specified format
 *
 * Like DateTime::createFromFormat but works with DateTimeImmutable.
 *
 * @param string $format
 * @param string $time
 * @param DateTimeZone $timezone
 * @return DateTimeImmutable
 * @since PHP 5 >= 5.5.0, PHP 7
 **/
function date_create_immutable_from_format($format, $time, $timezone){}

/**
 * Sets the date
 *
 * Resets the current date of the DateTime object to a different date.
 *
 * @param DateTime $object Year of the date.
 * @param int $year Month of the date.
 * @param int $month Day of the date.
 * @param int $day
 * @return DateTime
 * @since PHP 5 >= 5.2.0, PHP 7
 **/
function date_date_set($object, $year, $month, $day){}

/**
 * Gets the default timezone used by all date/time functions in a script
 *
 * In order of preference, this function returns the default timezone by:
 * Reading the timezone set using the {@link date_default_timezone_set}
 * function (if any) Prior to PHP 5.4.0 only: Reading the TZ environment
 * variable (if non empty) Reading the value of the date.timezone ini
 * option (if set) Prior to PHP 5.4.0 only: Querying the host operating
 * system (if supported and allowed by the OS). This uses an algorithm
 * that has to guess the timezone. This is by no means going to work
 * correctly for every situation. A warning is shown when this stage is
 * reached. Do not rely on it to be guessed correctly, and set
 * date.timezone to the correct timezone instead.
 *
 * If none of the above succeed, date_default_timezone_get will return a
 * default timezone of UTC.
 *
 * @return string Returns a string.
 * @since PHP 5 >= 5.1.0, PHP 7
 **/
function date_default_timezone_get(){}

/**
 * Sets the default timezone used by all date/time functions in a script
 *
 * {@link date_default_timezone_set} sets the default timezone used by
 * all date/time functions.
 *
 * Instead of using this function to set the default timezone in your
 * script, you can also use the INI setting date.timezone to set the
 * default timezone.
 *
 * @param string $timezone_identifier The timezone identifier, like UTC
 *   or Europe/Lisbon. The list of valid identifiers is available in the
 *   .
 * @return bool This function returns FALSE if the {@link
 *   timezone_identifier} isn't valid, or TRUE otherwise.
 * @since PHP 5 >= 5.1.0, PHP 7
 **/
function date_default_timezone_set($timezone_identifier){}

/**
 * Returns the difference between two DateTime objects
 *
 * Returns the difference between two DateTimeInterface objects.
 *
 * @param DateTimeInterface $datetime1 The date to compare to.
 * @param DateTimeInterface $datetime2 Should the interval be forced to
 *   be positive?
 * @param bool $absolute
 * @return DateInterval The DateInterval object representing the
 *   difference between the two dates.
 * @since PHP 5 >= 5.3.0, PHP 7
 **/
function date_diff($datetime1, $datetime2, $absolute){}

/**
 * Returns date formatted according to given format
 *
 * @param DateTimeInterface $object Format accepted by {@link date}.
 * @param string $format
 * @return string Returns the formatted date string on success.
 * @since PHP 5 >= 5.2.0, PHP 7
 **/
function date_format($object, $format){}

/**
 * Returns the warnings and errors
 *
 * Returns an array of warnings and errors found while parsing a
 * date/time string.
 *
 * @return array Returns array containing info about warnings and
 *   errors.
 * @since PHP 5 >= 5.3.0, PHP 7
 **/
function date_get_last_errors(){}

/**
 * Sets up a DateInterval from the relative parts of the string
 *
 * Uses the normal date parsers and sets up a DateInterval from the
 * relative parts of the parsed string.
 *
 * @param string $time A date with relative parts. Specifically, the
 *   relative formats supported by the parser used for {@link strtotime}
 *   and DateTime will be used to construct the DateInterval.
 * @return DateInterval Returns a new DateInterval instance.
 * @since PHP 5 >= 5.3.0, PHP 7
 **/
function date_interval_create_from_date_string($time){}

/**
 * Formats the interval
 *
 * @param string $format The following characters are recognized in the
 *   {@link format} parameter string. Each format character must be
 *   prefixed by a percent sign (%). {@link format} character Description
 *   Example values % Literal % % Y Years, numeric, at least 2 digits
 *   with leading 0 01, 03 y Years, numeric 1, 3 M Months, numeric, at
 *   least 2 digits with leading 0 01, 03, 12 m Months, numeric 1, 3, 12
 *   D Days, numeric, at least 2 digits with leading 0 01, 03, 31 d Days,
 *   numeric 1, 3, 31 a Total number of days as a result of a
 *   DateTime::diff or (unknown) otherwise 4, 18, 8123 H Hours, numeric,
 *   at least 2 digits with leading 0 01, 03, 23 h Hours, numeric 1, 3,
 *   23 I Minutes, numeric, at least 2 digits with leading 0 01, 03, 59 i
 *   Minutes, numeric 1, 3, 59 S Seconds, numeric, at least 2 digits with
 *   leading 0 01, 03, 57 s Seconds, numeric 1, 3, 57 F Microseconds,
 *   numeric, at least 6 digits with leading 0 007701, 052738, 428291 f
 *   Microseconds, numeric 7701, 52738, 428291 R Sign "-" when negative,
 *   "+" when positive -, + r Sign "-" when negative, empty when positive
 *   -,
 * @return string Returns the formatted interval.
 * @since PHP 5 >= 5.3.0, PHP 7
 **/
function date_interval_format($format){}

/**
 * Sets the ISO date
 *
 * Set a date according to the ISO 8601 standard - using weeks and day
 * offsets rather than specific dates.
 *
 * @param DateTime $object Year of the date.
 * @param int $year Week of the date.
 * @param int $week Offset from the first day of the week.
 * @param int $day
 * @return DateTime
 * @since PHP 5 >= 5.2.0, PHP 7
 **/
function date_isodate_set($object, $year, $week, $day){}

/**
 * Alters the timestamp
 *
 * Alter the timestamp of a DateTime object by incrementing or
 * decrementing in a format accepted by {@link strtotime}.
 *
 * @param DateTime $object
 * @param string $modify
 * @return DateTime
 * @since PHP 5 >= 5.2.0, PHP 7
 **/
function date_modify($object, $modify){}

/**
 * Returns the timezone offset
 *
 * @param DateTimeInterface $object
 * @return int Returns the timezone offset in seconds from UTC on
 *   success .
 * @since PHP 5 >= 5.2.0, PHP 7
 **/
function date_offset_get($object){}

/**
 * Returns associative array with detailed info about given date
 *
 * @param string $date Date in format accepted by {@link strtotime}.
 * @return array Returns array with information about the parsed date
 *   on success.
 * @since PHP 5 >= 5.2.0, PHP 7
 **/
function date_parse($date){}

/**
 * Get info about given date formatted according to the specified format
 *
 * Returns associative array with detailed info about given date.
 *
 * @param string $format Format accepted by {@link
 *   DateTime::createFromFormat}.
 * @param string $date String representing the date.
 * @return array Returns associative array with detailed info about
 *   given date.
 * @since PHP 5 >= 5.3.0, PHP 7
 **/
function date_parse_from_format($format, $date){}

/**
 * Subtracts an amount of days, months, years, hours, minutes and seconds
 * from a DateTime object
 *
 * Subtracts the specified DateInterval object from the specified
 * DateTime object.
 *
 * @param DateTime $object A DateInterval object
 * @param DateInterval $interval
 * @return DateTime
 * @since PHP 5 >= 5.3.0, PHP 7
 **/
function date_sub($object, $interval){}

/**
 * Returns time of sunrise for a given day and location
 *
 * {@link date_sunrise} returns the sunrise time for a given day
 * (specified as a {@link timestamp}) and location.
 *
 * @param int $timestamp The {@link timestamp} of the day from which
 *   the sunrise time is taken.
 * @param int $format {@link format} constants constant description
 *   example SUNFUNCS_RET_STRING returns the result as string 16:46
 *   SUNFUNCS_RET_DOUBLE returns the result as float 16.78243132
 *   SUNFUNCS_RET_TIMESTAMP returns the result as integer (timestamp)
 *   1095034606
 * @param float $latitude Defaults to North, pass in a negative value
 *   for South. See also: date.default_latitude
 * @param float $longitude Defaults to East, pass in a negative value
 *   for West. See also: date.default_longitude
 * @param float $zenith {@link zenith} is the angle between the center
 *   of the sun and a line perpendicular to earth's surface. It defaults
 *   to date.sunrise_zenith Common {@link zenith} angles Angle
 *   Description 90°50' Sunrise: the point where the sun becomes
 *   visible. 96° Civil twilight: conventionally used to signify the
 *   start of dawn. 102° Nautical twilight: the point at which the
 *   horizon starts being visible at sea. 108° Astronomical twilight:
 *   the point at which the sun starts being the source of any
 *   illumination.
 * @param float $gmt_offset Specified in hours. The {@link gmtoffset}
 *   is ignored, if {@link format} is SUNFUNCS_RET_TIMESTAMP.
 * @return mixed Returns the sunrise time in a specified {@link format}
 *   on success. One potential reason for failure is that the sun does
 *   not rise at all, which happens inside the polar circles for part of
 *   the year.
 * @since PHP 5, PHP 7
 **/
function date_sunrise($timestamp, $format, $latitude, $longitude, $zenith, $gmt_offset){}

/**
 * Returns time of sunset for a given day and location
 *
 * {@link date_sunset} returns the sunset time for a given day (specified
 * as a {@link timestamp}) and location.
 *
 * @param int $timestamp The {@link timestamp} of the day from which
 *   the sunset time is taken.
 * @param int $format {@link format} constants constant description
 *   example SUNFUNCS_RET_STRING returns the result as string 16:46
 *   SUNFUNCS_RET_DOUBLE returns the result as float 16.78243132
 *   SUNFUNCS_RET_TIMESTAMP returns the result as integer (timestamp)
 *   1095034606
 * @param float $latitude Defaults to North, pass in a negative value
 *   for South. See also: date.default_latitude
 * @param float $longitude Defaults to East, pass in a negative value
 *   for West. See also: date.default_longitude
 * @param float $zenith {@link zenith} is the angle between the center
 *   of the sun and a line perpendicular to earth's surface. It defaults
 *   to date.sunset_zenith Common {@link zenith} angles Angle Description
 *   90°50' Sunset: the point where the sun becomes invisible. 96°
 *   Civil twilight: conventionally used to signify the end of dusk.
 *   102° Nautical twilight: the point at which the horizon ends being
 *   visible at sea. 108° Astronomical twilight: the point at which the
 *   sun ends being the source of any illumination.
 * @param float $gmt_offset Specified in hours. The {@link gmtoffset}
 *   is ignored, if {@link format} is SUNFUNCS_RET_TIMESTAMP.
 * @return mixed Returns the sunset time in a specified {@link format}
 *   on success. One potential reason for failure is that the sun does
 *   not set at all, which happens inside the polar circles for part of
 *   the year.
 * @since PHP 5, PHP 7
 **/
function date_sunset($timestamp, $format, $latitude, $longitude, $zenith, $gmt_offset){}

/**
 * Returns an array with information about sunset/sunrise and twilight
 * begin/end
 *
 * @param int $time Timestamp.
 * @param float $latitude Latitude in degrees.
 * @param float $longitude Longitude in degrees.
 * @return array Returns array on success. The structure of the array
 *   is detailed in the following list:
 * @since PHP 5 >= 5.1.2, PHP 7
 **/
function date_sun_info($time, $latitude, $longitude){}

/**
 * Gets the Unix timestamp
 *
 * @param DateTimeInterface $object
 * @return int Returns the Unix timestamp representing the date.
 * @since PHP 5 >= 5.3.0, PHP 7
 **/
function date_timestamp_get($object){}

/**
 * Sets the date and time based on an Unix timestamp
 *
 * @param DateTime $object Unix timestamp representing the date.
 * @param int $unixtimestamp
 * @return DateTime
 * @since PHP 5 >= 5.3.0, PHP 7
 **/
function date_timestamp_set($object, $unixtimestamp){}

/**
 * Return time zone relative to given DateTime
 *
 * @param DateTimeInterface $object
 * @return DateTimeZone Returns a DateTimeZone object on success .
 * @since PHP 5 >= 5.2.0, PHP 7
 **/
function date_timezone_get($object){}

/**
 * Sets the time zone for the DateTime object
 *
 * Sets a new timezone for a DateTime object.
 *
 * @param DateTime $object A DateTimeZone object representing the
 *   desired time zone.
 * @param DateTimeZone $timezone
 * @return DateTime
 * @since PHP 5 >= 5.2.0, PHP 7
 **/
function date_timezone_set($object, $timezone){}

/**
 * Sets the time
 *
 * Resets the current time of the DateTime object to a different time.
 *
 * @param DateTime $object Hour of the time.
 * @param int $hour Minute of the time.
 * @param int $minute Second of the time.
 * @param int $second Microsecond of the time.
 * @param int $microseconds
 * @return DateTime
 * @since PHP 5 >= 5.2.0, PHP 7
 **/
function date_time_set($object, $hour, $minute, $second, $microseconds){}

/**
 * Returns or sets the AUTOCOMMIT state for a database connection
 *
 * Sets or gets the AUTOCOMMIT behavior of the specified connection
 * resource.
 *
 * @param resource $connection A valid database connection resource
 *   variable as returned from {@link db2_connect} or {@link
 *   db2_pconnect}.
 * @param bool $value One of the following constants:
 *   DB2_AUTOCOMMIT_OFF Turns AUTOCOMMIT off. DB2_AUTOCOMMIT_ON Turns
 *   AUTOCOMMIT on.
 * @return mixed When {@link db2_autocommit} receives only the {@link
 *   connection} parameter, it returns the current state of AUTOCOMMIT
 *   for the requested connection as an integer value. A value of
 *   DB2_AUTOCOMMIT_OFF indicates that AUTOCOMMIT is off, while a value
 *   of DB2_AUTOCOMMIT_ON indicates that AUTOCOMMIT is on.
 * @since PECL ibm_db2 >= 1.0.0
 **/
function db2_autocommit($connection, $value){}

/**
 * Binds a PHP variable to an SQL statement parameter
 *
 * Binds a PHP variable to an SQL statement parameter in a statement
 * resource returned by {@link db2_prepare}. This function gives you more
 * control over the parameter type, data type, precision, and scale for
 * the parameter than simply passing the variable as part of the optional
 * input array to {@link db2_execute}.
 *
 * @param resource $stmt A prepared statement returned from {@link
 *   db2_prepare}.
 * @param int $parameter_number Specifies the 1-indexed position of the
 *   parameter in the prepared statement.
 * @param string $variable_name A string specifying the name of the PHP
 *   variable to bind to the parameter specified by {@link
 *   parameter_number}.
 * @param int $parameter_type A constant specifying whether the PHP
 *   variable should be bound to the SQL parameter as an input parameter
 *   (DB2_PARAM_IN), an output parameter (DB2_PARAM_OUT), or as a
 *   parameter that accepts input and returns output (DB2_PARAM_INOUT).
 *   To avoid memory overhead, you can also specify DB2_PARAM_FILE to
 *   bind the PHP variable to the name of a file that contains large
 *   object (BLOB, CLOB, or DBCLOB) data.
 * @param int $data_type A constant specifying the SQL data type that
 *   the PHP variable should be bound as: one of DB2_BINARY, DB2_CHAR,
 *   DB2_DOUBLE, or DB2_LONG .
 * @param int $precision Specifies the precision with which the
 *   variable should be bound to the database. This parameter can also be
 *   used for retrieving XML output values from stored procedures. A
 *   non-negative value specifies the maximum size of the XML data that
 *   will be retrieved from the database. If this parameter is not used,
 *   a default of 1MB will be assumed for retrieving the XML output value
 *   from the stored procedure.
 * @param int $scale Specifies the scale with which the variable should
 *   be bound to the database.
 * @return bool
 * @since PECL ibm_db2 >= 1.0.0
 **/
function db2_bind_param($stmt, $parameter_number, $variable_name, $parameter_type, $data_type, $precision, $scale){}

/**
 * Returns an object with properties that describe the DB2 database
 * client
 *
 * This function returns an object with read-only properties that return
 * information about the DB2 database client. The following table lists
 * the DB2 client properties: DB2 client properties Property name Return
 * type Description APPL_CODEPAGE int The application code page.
 * CONN_CODEPAGE int The code page for the current connection.
 * DATA_SOURCE_NAME string The data source name (DSN) used to create the
 * current connection to the database. DRIVER_NAME string The name of the
 * library that implements the DB2 Call Level Interface (CLI)
 * specification. DRIVER_ODBC_VER string The version of ODBC that the DB2
 * client supports. This returns a string "MM.mm" where MM is the major
 * version and mm is the minor version. The DB2 client always returns
 * "03.51". DRIVER_VER string The version of the client, in the form of a
 * string "MM.mm.uuuu" where MM is the major version, mm is the minor
 * version, and uuuu is the update. For example, "08.02.0001" represents
 * major version 8, minor version 2, update 1. ODBC_SQL_CONFORMANCE
 * string The level of ODBC SQL grammar supported by the client: MINIMUM
 * Supports the minimum ODBC SQL grammar. CORE Supports the core ODBC SQL
 * grammar. EXTENDED Supports extended ODBC SQL grammar. ODBC_VER string
 * The version of ODBC that the ODBC driver manager supports. This
 * returns a string "MM.mm.rrrr" where MM is the major version, mm is the
 * minor version, and rrrr is the release. The DB2 client always returns
 * "03.01.0000".
 *
 * @param resource $connection Specifies an active DB2 client
 *   connection.
 * @return object Returns an object on a successful call. Returns FALSE
 *   on failure.
 * @since PECL ibm_db2 >= 1.1.1
 **/
function db2_client_info($connection){}

/**
 * Closes a database connection
 *
 * This function closes a DB2 client connection created with {@link
 * db2_connect} and returns the corresponding resources to the database
 * server.
 *
 * If you attempt to close a persistent DB2 client connection created
 * with {@link db2_pconnect}, the close request is ignored and the
 * persistent DB2 client connection remains available for the next
 * caller.
 *
 * @param resource $connection Specifies an active DB2 client
 *   connection.
 * @return bool
 * @since PECL ibm_db2 >= 1.0.0
 **/
function db2_close($connection){}

/**
 * Returns a result set listing the columns and associated metadata for a
 * table
 *
 * Returns a result set listing the columns and associated metadata for a
 * table.
 *
 * @param resource $connection A valid connection to an IBM DB2,
 *   Cloudscape, or Apache Derby database.
 * @param string $qualifier A qualifier for DB2 databases running on
 *   OS/390 or z/OS servers. For other databases, pass NULL or an empty
 *   string.
 * @param string $schema The schema which contains the tables. To match
 *   all schemas, pass '%'.
 * @param string $tablename The name of the table or view. To match all
 *   tables in the database, pass NULL or an empty string.
 * @param string $columnname The name of the column. To match all
 *   columns in the table, pass NULL or an empty string.
 * @return resource Returns a statement resource with a result set
 *   containing rows describing the columns matching the specified
 *   parameters. The rows are composed of the following columns: Column
 *   name Description TABLE_CAT Name of the catalog. The value is NULL if
 *   this table does not have catalogs. TABLE_SCHEM Name of the schema.
 *   TABLE_NAME Name of the table or view. COLUMN_NAME Name of the
 *   column. DATA_TYPE The SQL data type for the column represented as an
 *   integer value. TYPE_NAME A string representing the data type for the
 *   column. COLUMN_SIZE An integer value representing the size of the
 *   column. BUFFER_LENGTH Maximum number of bytes necessary to store
 *   data from this column. DECIMAL_DIGITS The scale of the column, or
 *   NULL where scale is not applicable. NUM_PREC_RADIX An integer value
 *   of either 10 (representing an exact numeric data type), 2
 *   (representing an approximate numeric data type), or NULL
 *   (representing a data type for which radix is not applicable).
 *   NULLABLE An integer value representing whether the column is
 *   nullable or not. REMARKS Description of the column. COLUMN_DEF
 *   Default value for the column. SQL_DATA_TYPE An integer value
 *   representing the size of the column. SQL_DATETIME_SUB Returns an
 *   integer value representing a datetime subtype code, or NULL for SQL
 *   data types to which this does not apply. CHAR_OCTET_LENGTH Maximum
 *   length in octets for a character data type column, which matches
 *   COLUMN_SIZE for single-byte character set data, or NULL for
 *   non-character data types. ORDINAL_POSITION The 1-indexed position of
 *   the column in the table. IS_NULLABLE A string value where 'YES'
 *   means that the column is nullable and 'NO' means that the column is
 *   not nullable.
 * @since PECL ibm_db2 >= 1.0.0
 **/
function db2_columns($connection, $qualifier, $schema, $tablename, $columnname){}

/**
 * Returns a result set listing the columns and associated privileges for
 * a table
 *
 * Returns a result set listing the columns and associated privileges for
 * a table.
 *
 * @param resource $connection A valid connection to an IBM DB2,
 *   Cloudscape, or Apache Derby database.
 * @param string $qualifier A qualifier for DB2 databases running on
 *   OS/390 or z/OS servers. For other databases, pass NULL or an empty
 *   string.
 * @param string $schema The schema which contains the tables. To match
 *   all schemas, pass NULL or an empty string.
 * @param string $tablename The name of the table or view. To match all
 *   tables in the database, pass NULL or an empty string.
 * @param string $columnname The name of the column. To match all
 *   columns in the table, pass NULL or an empty string.
 * @return resource Returns a statement resource with a result set
 *   containing rows describing the column privileges for columns
 *   matching the specified parameters. The rows are composed of the
 *   following columns: Column name Description TABLE_CAT Name of the
 *   catalog. The value is NULL if this table does not have catalogs.
 *   TABLE_SCHEM Name of the schema. TABLE_NAME Name of the table or
 *   view. COLUMN_NAME Name of the column. GRANTOR Authorization ID of
 *   the user who granted the privilege. GRANTEE Authorization ID of the
 *   user to whom the privilege was granted. PRIVILEGE The privilege for
 *   the column. IS_GRANTABLE Whether the GRANTEE is permitted to grant
 *   this privilege to other users.
 * @since PECL ibm_db2 >= 1.0.0
 **/
function db2_column_privileges($connection, $qualifier, $schema, $tablename, $columnname){}

/**
 * Commits a transaction
 *
 * Commits an in-progress transaction on the specified connection
 * resource and begins a new transaction. PHP applications normally
 * default to AUTOCOMMIT mode, so {@link db2_commit} is not necessary
 * unless AUTOCOMMIT has been turned off for the connection resource.
 *
 * @param resource $connection A valid database connection resource
 *   variable as returned from {@link db2_connect} or {@link
 *   db2_pconnect}.
 * @return bool
 * @since PECL ibm_db2 >= 1.0.0
 **/
function db2_commit($connection){}

/**
 * Returns a connection to a database
 *
 * Creates a new connection to an IBM DB2 Universal Database, IBM
 * Cloudscape, or Apache Derby database.
 *
 * @param string $database For a cataloged connection to a database,
 *   {@link database} represents the database alias in the DB2 client
 *   catalog. For an uncataloged connection to a database, {@link
 *   database} represents a complete connection string in the following
 *   format: DATABASE={@link database};HOSTNAME={@link
 *   hostname};PORT={@link port};PROTOCOL=TCPIP;UID={@link
 *   username};PWD={@link password}; where the parameters represent the
 *   following values: {@link database} The name of the database. {@link
 *   hostname} The hostname or IP address of the database server. {@link
 *   port} The TCP/IP port on which the database is listening for
 *   requests. {@link username} The username with which you are
 *   connecting to the database. {@link password} The password with which
 *   you are connecting to the database.
 * @param string $username The name of the database.
 * @param string $password The hostname or IP address of the database
 *   server.
 * @param array $options The TCP/IP port on which the database is
 *   listening for requests.
 * @return resource Returns a connection handle resource if the
 *   connection attempt is successful. If the connection attempt fails,
 *   {@link db2_connect} returns FALSE.
 * @since PECL ibm_db2 >= 1.0.0
 **/
function db2_connect($database, $username, $password, $options){}

/**
 * Returns a string containing the SQLSTATE returned by the last
 * connection attempt
 *
 * {@link db2_conn_error} returns an SQLSTATE value representing the
 * reason the last attempt to connect to a database failed. As {@link
 * db2_connect} returns FALSE in the event of a failed connection
 * attempt, you do not pass any parameters to {@link db2_conn_error} to
 * retrieve the SQLSTATE value.
 *
 * If, however, the connection was successful but becomes invalid over
 * time, you can pass the {@link connection} parameter to retrieve the
 * SQLSTATE value for a specific connection.
 *
 * To learn what the SQLSTATE value means, you can issue the following
 * command at a DB2 Command Line Processor prompt: db2 '? {@link
 * sqlstate-value}'. You can also call {@link db2_conn_errormsg} to
 * retrieve an explicit error message and the associated SQLCODE value.
 *
 * @param resource $connection A connection resource associated with a
 *   connection that initially succeeded, but which over time became
 *   invalid.
 * @return string Returns the SQLSTATE value resulting from a failed
 *   connection attempt. Returns an empty string if there is no error
 *   associated with the last connection attempt.
 * @since PECL ibm_db2 >= 1.0.0
 **/
function db2_conn_error($connection){}

/**
 * Returns the last connection error message and SQLCODE value
 *
 * {@link db2_conn_errormsg} returns an error message and SQLCODE value
 * representing the reason the last database connection attempt failed.
 * As {@link db2_connect} returns FALSE in the event of a failed
 * connection attempt, do not pass any parameters to {@link
 * db2_conn_errormsg} to retrieve the associated error message and
 * SQLCODE value.
 *
 * If, however, the connection was successful but becomes invalid over
 * time, you can pass the {@link connection} parameter to retrieve the
 * associated error message and SQLCODE value for a specific connection.
 *
 * @param resource $connection A connection resource associated with a
 *   connection that initially succeeded, but which over time became
 *   invalid.
 * @return string Returns a string containing the error message and
 *   SQLCODE value resulting from a failed connection attempt. If there
 *   is no error associated with the last connection attempt, {@link
 *   db2_conn_errormsg} returns an empty string.
 * @since PECL ibm_db2 >= 1.0.0
 **/
function db2_conn_errormsg($connection){}

/**
 * Returns the cursor type used by a statement resource
 *
 * Returns the cursor type used by a statement resource. Use this to
 * determine if you are working with a forward-only cursor or scrollable
 * cursor.
 *
 * @param resource $stmt A valid statement resource.
 * @return int Returns either DB2_FORWARD_ONLY if the statement
 *   resource uses a forward-only cursor or DB2_SCROLLABLE if the
 *   statement resource uses a scrollable cursor.
 * @since PECL ibm_db2 >= 1.0.0
 **/
function db2_cursor_type($stmt){}

/**
 * Used to escape certain characters
 *
 * Prepends backslashes to special characters in the string argument.
 *
 * @param string $string_literal The string that contains special
 *   characters that need to be modified. Characters that are prepended
 *   with a backslash are \x00, \n, \r, \, ', " and \x1a.
 * @return string Returns {@link string_literal} with the special
 *   characters noted above prepended with backslashes.
 * @since PECL ibm_db2 >= 1.6.0
 **/
function db2_escape_string($string_literal){}

/**
 * Executes an SQL statement directly
 *
 * Executes an SQL statement directly.
 *
 * If you plan to interpolate PHP variables into the SQL statement,
 * understand that this is one of the more common security exposures.
 * Consider calling {@link db2_prepare} to prepare an SQL statement with
 * parameter markers for input values. Then you can call {@link
 * db2_execute} to pass in the input values and avoid SQL injection
 * attacks.
 *
 * If you plan to repeatedly issue the same SQL statement with different
 * parameters, consider calling {@link db2_prepare} and {@link
 * db2_execute} to enable the database server to reuse its access plan
 * and increase the efficiency of your database access.
 *
 * @param resource $connection A valid database connection resource
 *   variable as returned from {@link db2_connect} or {@link
 *   db2_pconnect}.
 * @param string $statement An SQL statement. The statement cannot
 *   contain any parameter markers.
 * @param array $options An associative array containing statement
 *   options. You can use this parameter to request a scrollable cursor
 *   on database servers that support this functionality. For a
 *   description of valid statement options, see {@link db2_set_option}.
 * @return resource Returns a statement resource if the SQL statement
 *   was issued successfully, or FALSE if the database failed to execute
 *   the SQL statement.
 * @since PECL ibm_db2 >= 1.0.0
 **/
function db2_exec($connection, $statement, $options){}

/**
 * Executes a prepared SQL statement
 *
 * {@link db2_execute} executes an SQL statement that was prepared by
 * {@link db2_prepare}.
 *
 * If the SQL statement returns a result set, for example, a SELECT
 * statement or a CALL to a stored procedure that returns one or more
 * result sets, you can retrieve a row as an array from the stmt resource
 * using {@link db2_fetch_assoc}, {@link db2_fetch_both}, or {@link
 * db2_fetch_array}. Alternatively, you can use {@link db2_fetch_row} to
 * move the result set pointer to the next row and fetch a column at a
 * time from that row with {@link db2_result}.
 *
 * Refer to {@link db2_prepare} for a brief discussion of the advantages
 * of using {@link db2_prepare} and {@link db2_execute} rather than
 * {@link db2_exec}.
 *
 * @param resource $stmt A prepared statement returned from {@link
 *   db2_prepare}.
 * @param array $parameters An array of input parameters matching any
 *   parameter markers contained in the prepared statement.
 * @return bool
 * @since PECL ibm_db2 >= 1.0.0
 **/
function db2_execute($stmt, $parameters){}

/**
 * Returns an array, indexed by column position, representing a row in a
 * result set
 *
 * Returns an array, indexed by column position, representing a row in a
 * result set. The columns are 0-indexed.
 *
 * @param resource $stmt A valid stmt resource containing a result set.
 * @param int $row_number Requests a specific 1-indexed row from the
 *   result set. Passing this parameter results in a PHP warning if the
 *   result set uses a forward-only cursor.
 * @return array Returns a 0-indexed array with column values indexed
 *   by the column position representing the next or requested row in the
 *   result set. Returns FALSE if there are no rows left in the result
 *   set, or if the row requested by {@link row_number} does not exist in
 *   the result set.
 * @since PECL ibm_db2 >= 1.0.1
 **/
function db2_fetch_array($stmt, $row_number){}

/**
 * Returns an array, indexed by column name, representing a row in a
 * result set
 *
 * Returns an array, indexed by column name, representing a row in a
 * result set.
 *
 * @param resource $stmt A valid stmt resource containing a result set.
 * @param int $row_number Requests a specific 1-indexed row from the
 *   result set. Passing this parameter results in a PHP warning if the
 *   result set uses a forward-only cursor.
 * @return array Returns an associative array with column values
 *   indexed by the column name representing the next or requested row in
 *   the result set. Returns FALSE if there are no rows left in the
 *   result set, or if the row requested by {@link row_number} does not
 *   exist in the result set.
 * @since PECL ibm_db2 >= 1.0.0
 **/
function db2_fetch_assoc($stmt, $row_number){}

/**
 * Returns an array, indexed by both column name and position,
 * representing a row in a result set
 *
 * Returns an array, indexed by both column name and position,
 * representing a row in a result set. Note that the row returned by
 * {@link db2_fetch_both} requires more memory than the single-indexed
 * arrays returned by {@link db2_fetch_assoc} or {@link db2_fetch_array}.
 *
 * @param resource $stmt A valid stmt resource containing a result set.
 * @param int $row_number Requests a specific 1-indexed row from the
 *   result set. Passing this parameter results in a PHP warning if the
 *   result set uses a forward-only cursor.
 * @return array Returns an associative array with column values
 *   indexed by both the column name and 0-indexed column number. The
 *   array represents the next or requested row in the result set.
 *   Returns FALSE if there are no rows left in the result set, or if the
 *   row requested by {@link row_number} does not exist in the result
 *   set.
 * @since PECL ibm_db2 >= 1.0.0
 **/
function db2_fetch_both($stmt, $row_number){}

/**
 * Returns an object with properties representing columns in the fetched
 * row
 *
 * Returns an object in which each property represents a column returned
 * in the row fetched from a result set.
 *
 * @param resource $stmt A valid stmt resource containing a result set.
 * @param int $row_number Requests a specific 1-indexed row from the
 *   result set. Passing this parameter results in a PHP warning if the
 *   result set uses a forward-only cursor.
 * @return object Returns an object representing a single row in the
 *   result set. The properties of the object map to the names of the
 *   columns in the result set.
 * @since PECL ibm_db2 >= 1.0.0
 **/
function db2_fetch_object($stmt, $row_number){}

/**
 * Sets the result set pointer to the next row or requested row
 *
 * Use {@link db2_fetch_row} to iterate through a result set, or to point
 * to a specific row in a result set if you requested a scrollable
 * cursor.
 *
 * To retrieve individual fields from the result set, call the {@link
 * db2_result} function.
 *
 * Rather than calling {@link db2_fetch_row} and {@link db2_result}, most
 * applications will call one of {@link db2_fetch_assoc}, {@link
 * db2_fetch_both}, or {@link db2_fetch_array} to advance the result set
 * pointer and return a complete row as an array.
 *
 * @param resource $stmt A valid stmt resource.
 * @param int $row_number With scrollable cursors, you can request a
 *   specific row number in the result set. Row numbering is 1-indexed.
 * @return bool Returns TRUE if the requested row exists in the result
 *   set. Returns FALSE if the requested row does not exist in the result
 *   set.
 * @since PECL ibm_db2 >= 1.0.0
 **/
function db2_fetch_row($stmt, $row_number){}

/**
 * Returns the maximum number of bytes required to display a column
 *
 * Returns the maximum number of bytes required to display a column in a
 * result set.
 *
 * @param resource $stmt Specifies a statement resource containing a
 *   result set.
 * @param mixed $column Specifies the column in the result set. This
 *   can either be an integer representing the 0-indexed position of the
 *   column, or a string containing the name of the column.
 * @return int Returns an integer value with the maximum number of
 *   bytes required to display the specified column. If the column does
 *   not exist in the result set, {@link db2_field_display_size} returns
 *   FALSE.
 * @since PECL ibm_db2 >= 1.0.0
 **/
function db2_field_display_size($stmt, $column){}

/**
 * Returns the name of the column in the result set
 *
 * Returns the name of the specified column in the result set.
 *
 * @param resource $stmt Specifies a statement resource containing a
 *   result set.
 * @param mixed $column Specifies the column in the result set. This
 *   can either be an integer representing the 0-indexed position of the
 *   column, or a string containing the name of the column.
 * @return string Returns a string containing the name of the specified
 *   column. If the specified column does not exist in the result set,
 *   {@link db2_field_name} returns FALSE.
 * @since PECL ibm_db2 >= 1.0.0
 **/
function db2_field_name($stmt, $column){}

/**
 * Returns the position of the named column in a result set
 *
 * Returns the position of the named column in a result set.
 *
 * @param resource $stmt Specifies a statement resource containing a
 *   result set.
 * @param mixed $column Specifies the column in the result set. This
 *   can either be an integer representing the 0-indexed position of the
 *   column, or a string containing the name of the column.
 * @return int Returns an integer containing the 0-indexed position of
 *   the named column in the result set. If the specified column does not
 *   exist in the result set, {@link db2_field_num} returns FALSE.
 * @since PECL ibm_db2 >= 1.0.0
 **/
function db2_field_num($stmt, $column){}

/**
 * Returns the precision of the indicated column in a result set
 *
 * Returns the precision of the indicated column in a result set.
 *
 * @param resource $stmt Specifies a statement resource containing a
 *   result set.
 * @param mixed $column Specifies the column in the result set. This
 *   can either be an integer representing the 0-indexed position of the
 *   column, or a string containing the name of the column.
 * @return int Returns an integer containing the precision of the
 *   specified column. If the specified column does not exist in the
 *   result set, {@link db2_field_precision} returns FALSE.
 * @since PECL ibm_db2 >= 1.0.0
 **/
function db2_field_precision($stmt, $column){}

/**
 * Returns the scale of the indicated column in a result set
 *
 * Returns the scale of the indicated column in a result set.
 *
 * @param resource $stmt Specifies a statement resource containing a
 *   result set.
 * @param mixed $column Specifies the column in the result set. This
 *   can either be an integer representing the 0-indexed position of the
 *   column, or a string containing the name of the column.
 * @return int Returns an integer containing the scale of the specified
 *   column. If the specified column does not exist in the result set,
 *   {@link db2_field_scale} returns FALSE.
 * @since PECL ibm_db2 >= 1.0.0
 **/
function db2_field_scale($stmt, $column){}

/**
 * Returns the data type of the indicated column in a result set
 *
 * Returns the data type of the indicated column in a result set.
 *
 * @param resource $stmt Specifies a statement resource containing a
 *   result set.
 * @param mixed $column Specifies the column in the result set. This
 *   can either be an integer representing the 0-indexed position of the
 *   column, or a string containing the name of the column.
 * @return string Returns a string containing the defined data type of
 *   the specified column. If the specified column does not exist in the
 *   result set, {@link db2_field_type} returns FALSE.
 * @since PECL ibm_db2 >= 1.0.0
 **/
function db2_field_type($stmt, $column){}

/**
 * Returns the width of the current value of the indicated column in a
 * result set
 *
 * Returns the width of the current value of the indicated column in a
 * result set. This is the maximum width of the column for a fixed-length
 * data type, or the actual width of the column for a variable-length
 * data type.
 *
 * @param resource $stmt Specifies a statement resource containing a
 *   result set.
 * @param mixed $column Specifies the column in the result set. This
 *   can either be an integer representing the 0-indexed position of the
 *   column, or a string containing the name of the column.
 * @return int Returns an integer containing the width of the specified
 *   character or binary data type column in a result set. If the
 *   specified column does not exist in the result set, {@link
 *   db2_field_width} returns FALSE.
 * @since PECL ibm_db2 >= 1.0.0
 **/
function db2_field_width($stmt, $column){}

/**
 * Returns a result set listing the foreign keys for a table
 *
 * Returns a result set listing the foreign keys for a table.
 *
 * @param resource $connection A valid connection to an IBM DB2,
 *   Cloudscape, or Apache Derby database.
 * @param string $qualifier A qualifier for DB2 databases running on
 *   OS/390 or z/OS servers. For other databases, pass NULL or an empty
 *   string.
 * @param string $schema The schema which contains the tables. If
 *   {@link schema} is NULL, {@link db2_foreign_keys} matches the schema
 *   for the current connection.
 * @param string $tablename The name of the table.
 * @return resource Returns a statement resource with a result set
 *   containing rows describing the foreign keys for the specified table.
 *   The result set is composed of the following columns: Column name
 *   Description PKTABLE_CAT Name of the catalog for the table containing
 *   the primary key. The value is NULL if this table does not have
 *   catalogs. PKTABLE_SCHEM Name of the schema for the table containing
 *   the primary key. PKTABLE_NAME Name of the table containing the
 *   primary key. PKCOLUMN_NAME Name of the column containing the primary
 *   key. FKTABLE_CAT Name of the catalog for the table containing the
 *   foreign key. The value is NULL if this table does not have catalogs.
 *   FKTABLE_SCHEM Name of the schema for the table containing the
 *   foreign key. FKTABLE_NAME Name of the table containing the foreign
 *   key. FKCOLUMN_NAME Name of the column containing the foreign key.
 *   KEY_SEQ 1-indexed position of the column in the key. UPDATE_RULE
 *   Integer value representing the action applied to the foreign key
 *   when the SQL operation is UPDATE. DELETE_RULE Integer value
 *   representing the action applied to the foreign key when the SQL
 *   operation is DELETE. FK_NAME The name of the foreign key. PK_NAME
 *   The name of the primary key. DEFERRABILITY An integer value
 *   representing whether the foreign key deferrability is
 *   SQL_INITIALLY_DEFERRED, SQL_INITIALLY_IMMEDIATE, or
 *   SQL_NOT_DEFERRABLE.
 * @since PECL ibm_db2 >= 1.0.0
 **/
function db2_foreign_keys($connection, $qualifier, $schema, $tablename){}

/**
 * Frees resources associated with a result set
 *
 * Frees the system and database resources that are associated with a
 * result set. These resources are freed implicitly when a script
 * finishes, but you can call {@link db2_free_result} to explicitly free
 * the result set resources before the end of the script.
 *
 * @param resource $stmt A valid statement resource.
 * @return bool
 * @since PECL ibm_db2 >= 1.0.0
 **/
function db2_free_result($stmt){}

/**
 * Frees resources associated with the indicated statement resource
 *
 * Frees the system and database resources that are associated with a
 * statement resource. These resources are freed implicitly when a script
 * finishes, but you can call {@link db2_free_stmt} to explicitly free
 * the statement resources before the end of the script.
 *
 * @param resource $stmt A valid statement resource.
 * @return bool
 * @since PECL ibm_db2 >= 1.0.0
 **/
function db2_free_stmt($stmt){}

/**
 * Retrieves an option value for a statement resource or a connection
 * resource
 *
 * Retrieves the value of a specified option value for a statement
 * resource or a connection resource.
 *
 * @param resource $resource A valid statement resource as returned
 *   from {@link db2_prepare} or a valid connection resource as returned
 *   from {@link db2_connect} or {@link db2_pconnect}.
 * @param string $option A valid statement or connection options. The
 *   following new options are available as of ibm_db2 version 1.6.0.
 *   They provide useful tracking information that can be set during
 *   execution with {@link db2_get_option}. Prior versions of ibm_db2 do
 *   not support these new options. When the value in each option is
 *   being set, some servers might not handle the entire length provided
 *   and might truncate the value. To ensure that the data specified in
 *   each option is converted correctly when transmitted to a host
 *   system, use only the characters A through Z, 0 through 9, and the
 *   underscore (_) or period (.). {@link userid} SQL_ATTR_INFO_USERID -
 *   A pointer to a null-terminated character string used to identify the
 *   client user ID sent to the host database server when using DB2
 *   Connect. DB2 for z/OS and OS/390 servers support up to a length of
 *   16 characters. This user-id is not to be confused with the
 *   authentication user-id, it is for identification purposes only and
 *   is not used for any authorization. {@link acctstr}
 *   SQL_ATTR_INFO_ACCTSTR - A pointer to a null-terminated character
 *   string used to identify the client accounting string sent to the
 *   host database server when using DB2 Connect. DB2 for z/OS and OS/390
 *   servers support up to a length of 200 characters. {@link applname}
 *   SQL_ATTR_INFO_APPLNAME - A pointer to a null-terminated character
 *   string used to identify the client application name sent to the host
 *   database server when using DB2 Connect. DB2 for z/OS and OS/390
 *   servers support up to a length of 32 characters. {@link wrkstnname}
 *   SQL_ATTR_INFO_WRKSTNNAME - A pointer to a null-terminated character
 *   string used to identify the client workstation name sent to the host
 *   database server when using DB2 Connect. DB2 for z/OS and OS/390
 *   servers support up to a length of 18 characters.
 * @return string Returns the current setting of the connection
 *   attribute provided on success .
 * @since PECL ibm_db2 >= 1.6.0
 **/
function db2_get_option($resource, $option){}

/**
 * Returns the auto generated ID of the last insert query that
 * successfully executed on this connection
 *
 * The result of this function is not affected by any of the following: A
 * single row INSERT statement with a VALUES clause for a table without
 * an identity column. A multiple row INSERT statement with a VALUES
 * clause. An INSERT statement with a fullselect. A ROLLBACK TO SAVEPOINT
 * statement.
 *
 * @param resource $resource A valid connection resource as returned
 *   from {@link db2_connect} or {@link db2_pconnect}. The value of this
 *   parameter cannot be a statement resource or result set resource.
 * @return string Returns the auto generated ID of last insert query
 *   that successfully executed on this connection.
 * @since PECL ibm_db2 >= 1.7.1
 **/
function db2_last_insert_id($resource){}

/**
 * Gets a user defined size of LOB files with each invocation
 *
 * Use {@link db2_lob_read} to iterate through a specified column of a
 * result set and retrieve a user defined size of LOB data.
 *
 * @param resource $stmt A valid stmt resource containing LOB data.
 * @param int $colnum A valid column number in the result set of the
 *   stmt resource.
 * @param int $length The size of the LOB data to be retrieved from the
 *   stmt resource.
 * @return string Returns the amount of data the user specifies.
 *   Returns FALSE if the data cannot be retrieved.
 * @since PECL ibm_db2 >= 1.6.0
 **/
function db2_lob_read($stmt, $colnum, $length){}

/**
 * Requests the next result set from a stored procedure
 *
 * A stored procedure can return zero or more result sets. While you
 * handle the first result set in exactly the same way you would handle
 * the results returned by a simple SELECT statement, to fetch the second
 * and subsequent result sets from a stored procedure you must call the
 * {@link db2_next_result} function and return the result to a uniquely
 * named PHP variable.
 *
 * @param resource $stmt A prepared statement returned from {@link
 *   db2_exec} or {@link db2_execute}.
 * @return resource Returns a new statement resource containing the
 *   next result set if the stored procedure returned another result set.
 *   Returns FALSE if the stored procedure did not return another result
 *   set.
 * @since PECL ibm_db2 >= 1.0.0
 **/
function db2_next_result($stmt){}

/**
 * Returns the number of fields contained in a result set
 *
 * Returns the number of fields contained in a result set. This is most
 * useful for handling the result sets returned by dynamically generated
 * queries, or for result sets returned by stored procedures, where your
 * application cannot otherwise know how to retrieve and use the results.
 *
 * @param resource $stmt A valid statement resource containing a result
 *   set.
 * @return int Returns an integer value representing the number of
 *   fields in the result set associated with the specified statement
 *   resource. Returns FALSE if the statement resource is not a valid
 *   input value.
 * @since PECL ibm_db2 >= 1.0.0
 **/
function db2_num_fields($stmt){}

/**
 * Returns the number of rows affected by an SQL statement
 *
 * Returns the number of rows deleted, inserted, or updated by an SQL
 * statement.
 *
 * To determine the number of rows that will be returned by a SELECT
 * statement, issue SELECT COUNT(*) with the same predicates as your
 * intended SELECT statement and retrieve the value.
 *
 * If your application logic checks the number of rows returned by a
 * SELECT statement and branches if the number of rows is 0, consider
 * modifying your application to attempt to return the first row with one
 * of {@link db2_fetch_assoc}, {@link db2_fetch_both}, {@link
 * db2_fetch_array}, or {@link db2_fetch_row}, and branch if the fetch
 * function returns FALSE.
 *
 * @param resource $stmt A valid stmt resource containing a result set.
 * @return int Returns the number of rows affected by the last SQL
 *   statement issued by the specified statement handle.
 * @since PECL ibm_db2 >= 1.0.0
 **/
function db2_num_rows($stmt){}

/**
 * Closes a persistent database connection
 *
 * This function closes a DB2 client connection created with {@link
 * db2_pconnect} and returns the corresponding resources to the database
 * server. This function is only available on i5/OS in response to i5/OS
 * system administration requests.
 *
 * If you have a persistent DB2 client connection created with {@link
 * db2_pconnect}, you may use this function to close the connection. To
 * avoid substantial connection performance penalties, this function
 * should only be used in rare cases when the persistent connection has
 * become unresponsive or the persistent connection will not be needed
 * for a long period of time.
 *
 * @param resource $resource Specifies an active DB2 client connection.
 * @return bool
 * @since PECL ibm_db2 >= 1.8.0
 **/
function db2_pclose($resource){}

/**
 * Returns a persistent connection to a database
 *
 * Returns a persistent connection to an IBM DB2 Universal Database, IBM
 * Cloudscape, or Apache Derby database.
 *
 * For more information on persistent connections, refer to .
 *
 * Calling {@link db2_close} on a persistent connection always returns
 * TRUE, but the underlying DB2 client connection remains open and
 * waiting to serve the next matching {@link db2_pconnect} request.
 *
 * Users running version 1.9.0 or later of ibm_db2 should be aware that
 * the extension will perform a transaction rollback on persistent
 * connections at the end of a request, thus ending the transaction. This
 * prevents the transaction block from carrying over to the next request
 * which uses that connection if script execution ends before the
 * transaction block does.
 *
 * @param string $database The database alias in the DB2 client
 *   catalog.
 * @param string $username The username with which you are connecting
 *   to the database.
 * @param string $password The password with which you are connecting
 *   to the database.
 * @param array $options An associative array of connection options
 *   that affect the behavior of the connection, where valid array keys
 *   include: {@link autocommit} Passing the DB2_AUTOCOMMIT_ON value
 *   turns autocommit on for this connection handle. Passing the
 *   DB2_AUTOCOMMIT_OFF value turns autocommit off for this connection
 *   handle. {@link DB2_ATTR_CASE} Passing the DB2_CASE_NATURAL value
 *   specifies that column names are returned in natural case. Passing
 *   the DB2_CASE_LOWER value specifies that column names are returned in
 *   lower case. Passing the DB2_CASE_UPPER value specifies that column
 *   names are returned in upper case. {@link CURSOR} Passing the
 *   DB2_FORWARD_ONLY value specifies a forward-only cursor for a
 *   statement resource. This is the default cursor type and is supported
 *   on all database servers. Passing the DB2_SCROLLABLE value specifies
 *   a scrollable cursor for a statement resource. This mode enables
 *   random access to rows in a result set, but currently is supported
 *   only by IBM DB2 Universal Database. The following new option is
 *   available in ibm_db2 version 1.7.0 and later. {@link trustedcontext}
 *   Passing the DB2_TRUSTED_CONTEXT_ENABLE value turns trusted context
 *   on for this connection handle. This parameter cannot be set using
 *   {@link db2_set_option}. This key works only if the database is
 *   cataloged (even if the database is local), or if you specify the
 *   full DSN when you create the connection. To catalog the database,
 *   use following commands: db2 catalog tcpip node loopback remote
 *   <SERVERNAME> server <SERVICENAME> db2 catalog database <LOCALDBNAME>
 *   as <REMOTEDBNAME> at node loopback db2 "update dbm cfg using
 *   svcename <SERVICENAME>" db2set DB2COMM=TCPIP The following new i5/OS
 *   options are available in ibm_db2 version 1.5.1 and later.
 *   Conflicting connection attributes used in conjunction with
 *   persistent connections can produce indeterminate results on i5/OS.
 *   Site policies should be establish for all applications using each
 *   persistent connection user profile. The default DB2_AUTOCOMMIT_ON is
 *   suggested when using persistent connections. {@link i5_lib} A
 *   character value that indicates the default library that will be used
 *   for resolving unqualified file references. This is not valid if the
 *   connection is using system naming mode. {@link i5_naming}
 *   DB2_I5_NAMING_ON value turns on DB2 UDB CLI iSeries system naming
 *   mode. Files are qualified using the slash (/) delimiter. Unqualified
 *   files are resolved using the library list for the job.
 *   DB2_I5_NAMING_OFF value turns off DB2 UDB CLI default naming mode,
 *   which is SQL naming. Files are qualified using the period (.)
 *   delimiter. Unqualified files are resolved using either the default
 *   library or the current user ID. {@link i5_commit} The {@link
 *   i5_commit} attribute should be set before the {@link db2_pconnect}.
 *   If the value is changed after the connection has been established,
 *   and the connection is to a remote data source, the change does not
 *   take effect until the next successful {@link db2_pconnect} for the
 *   connection handle. The php.ini setting {@link
 *   ibm_db2.i5_allow_commit}==0 or DB2_I5_TXN_NO_COMMIT is the default,
 *   but may be overridden with the {@link i5_commit} option.
 *   DB2_I5_TXN_NO_COMMIT - Commitment control is not used.
 *   DB2_I5_TXN_READ_UNCOMMITTED - Dirty reads, nonrepeatable reads, and
 *   phantoms are possible. DB2_I5_TXN_READ_COMMITTED - Dirty reads are
 *   not possible. Nonrepeatable reads, and phantoms are possible.
 *   DB2_I5_TXN_REPEATABLE_READ - Dirty reads and nonrepeatable reads are
 *   not possible. Phantoms are possible. DB2_I5_TXN_SERIALIZABLE -
 *   Transactions are serializable. Dirty reads, non-repeatable reads,
 *   and phantoms are not possible {@link i5_query_optimize} DB2_FIRST_IO
 *   All queries are optimized with the goal of returning the first page
 *   of output as fast as possible. This goal works well when the output
 *   is controlled by a user who is most likely to cancel the query after
 *   viewing the first page of output data. Queries coded with an
 *   OPTIMIZE FOR nnn ROWS clause honor the goal specified by the clause.
 *   DB2_ALL_IO All queries are optimized with the goal of running the
 *   entire query to completion in the shortest amount of elapsed time.
 *   This is a good option when the output of a query is being written to
 *   a file or report, or the interface is queuing the output data.
 *   Queries coded with an OPTIMIZE FOR nnn ROWS clause honor the goal
 *   specified by the clause. This is the default. {@link i5_dbcs_alloc}
 *   DB2_I5_DBCS_ALLOC_ON value turns on DB2 6X allocation scheme for
 *   DBCS translation column size growth. DB2_I5_DBCS_ALLOC_OFF value
 *   turns off DB2 6X allocation scheme for DBCS translation column size
 *   growth. The php.ini setting {@link ibm_db2.i5_dbcs_alloc}==0 or
 *   DB2_I5_DBCS_ALLOC_OFF is the default, but may be overridden with the
 *   {@link i5_dbcs_alloc} option. {@link i5_date_fmt} DB2_I5_FMT_ISO -
 *   The International Organization for Standardization (ISO) date format
 *   yyyy-mm-dd is used. This is the default. DB2_I5_FMT_USA - The United
 *   States date format mm/dd/yyyy is used. DB2_I5_FMT_EUR - The European
 *   date format dd.mm.yyyy is used. DB2_I5_FMT_JIS - The Japanese
 *   Industrial Standard date format yyyy-mm-dd is used. DB2_I5_FMT_MDY -
 *   The date format mm/dd/yyyy is used. DB2_I5_FMT_DMY - The date format
 *   dd/mm/yyyy is used. DB2_I5_FMT_YMD - The date format yy/mm/dd is
 *   used. DB2_I5_FMT_JUL - The Julian date format yy/ddd is used.
 *   DB2_I5_FMT_JOB - The job default is used. {@link i5_date_sep}
 *   DB2_I5_SEP_SLASH - A slash ( / ) is used as the date separator. This
 *   is the default. DB2_I5_SEP_DASH - A dash ( - ) is used as the date
 *   separator. DB2_I5_SEP_PERIOD - A period ( . ) is used as the date
 *   separator. DB2_I5_SEP_COMMA - A comma ( , ) is used as the date
 *   separator. DB2_I5_SEP_BLANK - A blank is used as the date separator.
 *   DB2_I5_SEP_JOB - The job default is used {@link i5_time_fmt}
 *   DB2_I5_FMT_ISO - The International Organization for Standardization
 *   (ISO) time format hh.mm.ss is used. This is the default.
 *   DB2_I5_FMT_USA - The United States time format hh:mmxx is used,
 *   where xx is AM or PM. DB2_I5_FMT_EUR - The European time format
 *   hh.mm.ss is used. DB2_I5_FMT_JIS - The Japanese Industrial Standard
 *   time format hh:mm:ss is used. DB2_I5_FMT_HMS - The hh:mm:ss format
 *   is used. {@link i5_time_sep} DB2_I5_SEP_COLON - A colon ( : ) is
 *   used as the time separator. This is the default. DB2_I5_SEP_PERIOD -
 *   A period ( . ) is used as the time separator. DB2_I5_SEP_COMMA - A
 *   comma ( , ) is used as the time separator. DB2_I5_SEP_BLANK - A
 *   blank is used as the time separator. DB2_I5_SEP_JOB - The job
 *   default is used. {@link i5_decimal_sep} DB2_I5_SEP_PERIOD - A period
 *   ( . ) is used as the decimal separator. This is the default.
 *   DB2_I5_SEP_COMMA - A comma ( , ) is used as the decimal separator.
 *   DB2_I5_SEP_JOB - The job default is used. The following new i5/OS
 *   option is available in ibm_db2 version 1.8.0 and later. {@link
 *   i5_libl} A character value that indicates the library list that will
 *   be used for resolving unqualified file references. Specify the
 *   library list elements separated by blanks 'i5_libl'=>"MYLIB YOURLIB
 *   ANYLIB". i5_libl calls qsys2/qcmdexc('cmd',cmdlen), which is only
 *   available in i5/OS V5R4 and later.
 * @return resource Returns a connection handle resource if the
 *   connection attempt is successful. {@link db2_pconnect} tries to
 *   reuse an existing connection resource that exactly matches the
 *   {@link database}, {@link username}, and {@link password} parameters.
 *   If the connection attempt fails, {@link db2_pconnect} returns FALSE.
 * @since PECL ibm_db2 >= 1.0.0
 **/
function db2_pconnect($database, $username, $password, $options){}

/**
 * Prepares an SQL statement to be executed
 *
 * {@link db2_prepare} creates a prepared SQL statement which can include
 * 0 or more parameter markers (? characters) representing parameters for
 * input, output, or input/output. You can pass parameters to the
 * prepared statement using {@link db2_bind_param}, or for input values
 * only, as an array passed to {@link db2_execute}.
 *
 * There are three main advantages to using prepared statements in your
 * application: Performance: when you prepare a statement, the database
 * server creates an optimized access plan for retrieving data with that
 * statement. Subsequently issuing the prepared statement with {@link
 * db2_execute} enables the statements to reuse that access plan and
 * avoids the overhead of dynamically creating a new access plan for
 * every statement you issue. Security: when you prepare a statement, you
 * can include parameter markers for input values. When you execute a
 * prepared statement with input values for placeholders, the database
 * server checks each input value to ensure that the type matches the
 * column definition or parameter definition. Advanced functionality:
 * Parameter markers not only enable you to pass input values to prepared
 * SQL statements, they also enable you to retrieve OUT and INOUT
 * parameters from stored procedures using {@link db2_bind_param}.
 *
 * @param resource $connection A valid database connection resource
 *   variable as returned from {@link db2_connect} or {@link
 *   db2_pconnect}.
 * @param string $statement An SQL statement, optionally containing one
 *   or more parameter markers..
 * @param array $options An associative array containing statement
 *   options. You can use this parameter to request a scrollable cursor
 *   on database servers that support this functionality. For a
 *   description of valid statement options, see {@link db2_set_option}.
 * @return resource Returns a statement resource if the SQL statement
 *   was successfully parsed and prepared by the database server. Returns
 *   FALSE if the database server returned an error. You can determine
 *   which error was returned by calling {@link db2_stmt_error} or {@link
 *   db2_stmt_errormsg}.
 * @since PECL ibm_db2 >= 1.0.0
 **/
function db2_prepare($connection, $statement, $options){}

/**
 * Returns a result set listing primary keys for a table
 *
 * Returns a result set listing the primary keys for a table.
 *
 * @param resource $connection A valid connection to an IBM DB2,
 *   Cloudscape, or Apache Derby database.
 * @param string $qualifier A qualifier for DB2 databases running on
 *   OS/390 or z/OS servers. For other databases, pass NULL or an empty
 *   string.
 * @param string $schema The schema which contains the tables. If
 *   {@link schema} is NULL, {@link db2_primary_keys} matches the schema
 *   for the current connection.
 * @param string $tablename The name of the table.
 * @return resource Returns a statement resource with a result set
 *   containing rows describing the primary keys for the specified table.
 *   The result set is composed of the following columns: Column name
 *   Description TABLE_CAT Name of the catalog for the table containing
 *   the primary key. The value is NULL if this table does not have
 *   catalogs. TABLE_SCHEM Name of the schema for the table containing
 *   the primary key. TABLE_NAME Name of the table containing the primary
 *   key. COLUMN_NAME Name of the column containing the primary key.
 *   KEY_SEQ 1-indexed position of the column in the key. PK_NAME The
 *   name of the primary key.
 * @since PECL ibm_db2 >= 1.0.0
 **/
function db2_primary_keys($connection, $qualifier, $schema, $tablename){}

/**
 * Returns a result set listing the stored procedures registered in a
 * database
 *
 * Returns a result set listing the stored procedures registered in a
 * database.
 *
 * @param resource $connection A valid connection to an IBM DB2,
 *   Cloudscape, or Apache Derby database.
 * @param string $qualifier A qualifier for DB2 databases running on
 *   OS/390 or z/OS servers. For other databases, pass NULL or an empty
 *   string.
 * @param string $schema The schema which contains the procedures. This
 *   parameter accepts a search pattern containing _ and % as wildcards.
 * @param string $procedure The name of the procedure. This parameter
 *   accepts a search pattern containing _ and % as wildcards.
 * @return resource Returns a statement resource with a result set
 *   containing rows describing the stored procedures matching the
 *   specified parameters. The rows are composed of the following
 *   columns: Column name Description PROCEDURE_CAT The catalog that
 *   contains the procedure. The value is NULL if this table does not
 *   have catalogs. PROCEDURE_SCHEM Name of the schema that contains the
 *   stored procedure. PROCEDURE_NAME Name of the procedure.
 *   NUM_INPUT_PARAMS Number of input (IN) parameters for the stored
 *   procedure. NUM_OUTPUT_PARAMS Number of output (OUT) parameters for
 *   the stored procedure. NUM_RESULT_SETS Number of result sets returned
 *   by the stored procedure. REMARKS Any comments about the stored
 *   procedure. PROCEDURE_TYPE Always returns 1, indicating that the
 *   stored procedure does not return a return value.
 * @since PECL ibm_db2 >= 1.0.0
 **/
function db2_procedures($connection, $qualifier, $schema, $procedure){}

/**
 * Returns a result set listing stored procedure parameters
 *
 * Returns a result set listing the parameters for one or more stored
 * procedures.
 *
 * @param resource $connection A valid connection to an IBM DB2,
 *   Cloudscape, or Apache Derby database.
 * @param string $qualifier A qualifier for DB2 databases running on
 *   OS/390 or z/OS servers. For other databases, pass NULL or an empty
 *   string.
 * @param string $schema The schema which contains the procedures. This
 *   parameter accepts a search pattern containing _ and % as wildcards.
 * @param string $procedure The name of the procedure. This parameter
 *   accepts a search pattern containing _ and % as wildcards.
 * @param string $parameter The name of the parameter. This parameter
 *   accepts a search pattern containing _ and % as wildcards. If this
 *   parameter is NULL, all parameters for the specified stored
 *   procedures are returned.
 * @return resource Returns a statement resource with a result set
 *   containing rows describing the parameters for the stored procedures
 *   matching the specified parameters. The rows are composed of the
 *   following columns: Column name Description PROCEDURE_CAT The catalog
 *   that contains the procedure. The value is NULL if this table does
 *   not have catalogs. PROCEDURE_SCHEM Name of the schema that contains
 *   the stored procedure. PROCEDURE_NAME Name of the procedure.
 *   COLUMN_NAME Name of the parameter. COLUMN_TYPE An integer value
 *   representing the type of the parameter: Return value Parameter type
 *   1 (SQL_PARAM_INPUT) Input (IN) parameter. 2 (SQL_PARAM_INPUT_OUTPUT)
 *   Input/output (INOUT) parameter. 3 (SQL_PARAM_OUTPUT) Output (OUT)
 *   parameter. DATA_TYPE The SQL data type for the parameter represented
 *   as an integer value. TYPE_NAME A string representing the data type
 *   for the parameter. COLUMN_SIZE An integer value representing the
 *   size of the parameter. BUFFER_LENGTH Maximum number of bytes
 *   necessary to store data for this parameter. DECIMAL_DIGITS The scale
 *   of the parameter, or NULL where scale is not applicable.
 *   NUM_PREC_RADIX An integer value of either 10 (representing an exact
 *   numeric data type), 2 (representing an approximate numeric data
 *   type), or NULL (representing a data type for which radix is not
 *   applicable). NULLABLE An integer value representing whether the
 *   parameter is nullable or not. REMARKS Description of the parameter.
 *   COLUMN_DEF Default value for the parameter. SQL_DATA_TYPE An integer
 *   value representing the size of the parameter. SQL_DATETIME_SUB
 *   Returns an integer value representing a datetime subtype code, or
 *   NULL for SQL data types to which this does not apply.
 *   CHAR_OCTET_LENGTH Maximum length in octets for a character data type
 *   parameter, which matches COLUMN_SIZE for single-byte character set
 *   data, or NULL for non-character data types. ORDINAL_POSITION The
 *   1-indexed position of the parameter in the CALL statement.
 *   IS_NULLABLE A string value where 'YES' means that the parameter
 *   accepts or returns NULL values and 'NO' means that the parameter
 *   does not accept or return NULL values.
 * @since PECL ibm_db2 >= 1.0.0
 **/
function db2_procedure_columns($connection, $qualifier, $schema, $procedure, $parameter){}

/**
 * Returns a single column from a row in the result set
 *
 * Use {@link db2_result} to return the value of a specified column in
 * the current row of a result set. You must call {@link db2_fetch_row}
 * before calling {@link db2_result} to set the location of the result
 * set pointer.
 *
 * @param resource $stmt A valid stmt resource.
 * @param mixed $column Either an integer mapping to the 0-indexed
 *   field in the result set, or a string matching the name of the
 *   column.
 * @return mixed Returns the value of the requested field if the field
 *   exists in the result set. Returns NULL if the field does not exist,
 *   and issues a warning.
 * @since PECL ibm_db2 >= 1.0.0
 **/
function db2_result($stmt, $column){}

/**
 * Rolls back a transaction
 *
 * Rolls back an in-progress transaction on the specified connection
 * resource and begins a new transaction. PHP applications normally
 * default to AUTOCOMMIT mode, so {@link db2_rollback} normally has no
 * effect unless AUTOCOMMIT has been turned off for the connection
 * resource.
 *
 * @param resource $connection A valid database connection resource
 *   variable as returned from {@link db2_connect} or {@link
 *   db2_pconnect}.
 * @return bool
 * @since PECL ibm_db2 >= 1.0.0
 **/
function db2_rollback($connection){}

/**
 * Returns an object with properties that describe the DB2 database
 * server
 *
 * This function returns an object with read-only properties that return
 * information about the IBM DB2, Cloudscape, or Apache Derby database
 * server. The following table lists the database server properties:
 * Database server properties Property name Return type Description
 * DBMS_NAME string The name of the database server to which you are
 * connected. For DB2 servers this is a combination of DB2 followed by
 * the operating system on which the database server is running. DBMS_VER
 * string The version of the database server, in the form of a string
 * "MM.mm.uuuu" where MM is the major version, mm is the minor version,
 * and uuuu is the update. For example, "08.02.0001" represents major
 * version 8, minor version 2, update 1. DB_CODEPAGE int The code page of
 * the database to which you are connected. DB_NAME string The name of
 * the database to which you are connected. DFT_ISOLATION string The
 * default transaction isolation level supported by the server: UR
 * Uncommitted read: changes are immediately visible by all concurrent
 * transactions. CS Cursor stability: a row read by one transaction can
 * be altered and committed by a second concurrent transaction. RS Read
 * stability: a transaction can add or remove rows matching a search
 * condition or a pending transaction. RR Repeatable read: data affected
 * by pending transaction is not available to other transactions. NC No
 * commit: any changes are visible at the end of a successful operation.
 * Explicit commits and rollbacks are not allowed. IDENTIFIER_QUOTE_CHAR
 * string The character used to delimit an identifier. INST_NAME string
 * The instance on the database server that contains the database.
 * ISOLATION_OPTION array An array of the isolation options supported by
 * the database server. The isolation options are described in the
 * DFT_ISOLATION property. KEYWORDS array An array of the keywords
 * reserved by the database server. LIKE_ESCAPE_CLAUSE bool TRUE if the
 * database server supports the use of % and _ wildcard characters. FALSE
 * if the database server does not support these wildcard characters.
 * MAX_COL_NAME_LEN int Maximum length of a column name supported by the
 * database server, expressed in bytes. MAX_IDENTIFIER_LEN int Maximum
 * length of an SQL identifier supported by the database server,
 * expressed in characters. MAX_INDEX_SIZE int Maximum size of columns
 * combined in an index supported by the database server, expressed in
 * bytes. MAX_PROC_NAME_LEN int Maximum length of a procedure name
 * supported by the database server, expressed in bytes. MAX_ROW_SIZE int
 * Maximum length of a row in a base table supported by the database
 * server, expressed in bytes. MAX_SCHEMA_NAME_LEN int Maximum length of
 * a schema name supported by the database server, expressed in bytes.
 * MAX_STATEMENT_LEN int Maximum length of an SQL statement supported by
 * the database server, expressed in bytes. MAX_TABLE_NAME_LEN int
 * Maximum length of a table name supported by the database server,
 * expressed in bytes. NON_NULLABLE_COLUMNS bool TRUE if the database
 * server supports columns that can be defined as NOT NULL, FALSE if the
 * database server does not support columns defined as NOT NULL.
 * PROCEDURES bool TRUE if the database server supports the use of the
 * CALL statement to call stored procedures, FALSE if the database server
 * does not support the CALL statement. SPECIAL_CHARS string A string
 * containing all of the characters other than a-Z, 0-9, and underscore
 * that can be used in an identifier name. SQL_CONFORMANCE string The
 * level of conformance to the ANSI/ISO SQL-92 specification offered by
 * the database server: ENTRY Entry-level SQL-92 compliance. FIPS127
 * FIPS-127-2 transitional compliance. FULL Full level SQL-92 compliance.
 * INTERMEDIATE Intermediate level SQL-92 compliance.
 *
 * @param resource $connection Specifies an active DB2 client
 *   connection.
 * @return object Returns an object on a successful call. Returns FALSE
 *   on failure.
 * @since PECL ibm_db2 >= 1.1.1
 **/
function db2_server_info($connection){}

/**
 * Set options for connection or statement resources
 *
 * Sets options for a statement resource or a connection resource. You
 * cannot set options for result set resources.
 *
 * @param resource $resource A valid statement resource as returned
 *   from {@link db2_prepare} or a valid connection resource as returned
 *   from {@link db2_connect} or {@link db2_pconnect}.
 * @param array $options An associative array containing valid
 *   statement or connection options. This parameter can be used to
 *   change autocommit values, cursor types (scrollable or forward), and
 *   to specify the case of the column names (lower, upper, or natural)
 *   that will appear in a result set. {@link autocommit} Passing
 *   DB2_AUTOCOMMIT_ON turns autocommit on for the specified connection
 *   resource. Passing DB2_AUTOCOMMIT_OFF turns autocommit off for the
 *   specified connection resource. {@link cursor} Passing
 *   DB2_FORWARD_ONLY specifies a forward-only cursor for a statement
 *   resource. This is the default cursor type, and is supported by all
 *   database servers. Passing DB2_SCROLLABLE specifies a scrollable
 *   cursor for a statement resource. Scrollable cursors enable result
 *   set rows to be accessed in non-sequential order, but are only
 *   supported by IBM DB2 Universal Database databases. {@link binmode}
 *   Passing DB2_BINARY specifies that binary data will be returned as
 *   is. This is the default mode. This is the equivalent of setting
 *   ibm_db2.binmode=1 in . Passing DB2_CONVERT specifies that binary
 *   data will be converted to hexadecimal encoding, and will be returned
 *   as such. This is the equivalent of setting ibm_db2.binmode=2 in .
 *   Passing DB2_PASSTHRU specifies that binary data will be converted to
 *   NULL. This is the equivalent of setting ibm_db2.binmode=3 in .
 *   {@link db2_attr_case} Passing DB2_CASE_LOWER specifies that column
 *   names of the result set are returned in lower case. Passing
 *   DB2_CASE_UPPER specifies that column names of the result set are
 *   returned in upper case. Passing DB2_CASE_NATURAL specifies that
 *   column names of the result set are returned in natural case. {@link
 *   deferred_prepare} Passing DB2_DEFERRED_PREPARE_ON turns deferred
 *   prepare on for the specified statement resource. Passing
 *   DB2_DEFERRED_PREPARE_OFF turns deferred prepare off for the
 *   specified statement resource. The following new i5/OS options are
 *   available in ibm_db2 version 1.5.1 and later. These options apply
 *   only when running PHP and ibm_db2 natively on i5 systems. {@link
 *   i5_fetch_only} DB2_I5_FETCH_ON - Cursors are read-only and cannot be
 *   used for positioned updates or deletes. This is the default unless
 *   SQL_ATTR_FOR_FETCH_ONLY environment has been set to SQL_FALSE.
 *   DB2_I5_FETCH_OFF - Cursors can be used for positioned updates and
 *   deletes. The following new option is available in ibm_db2 version
 *   1.8.0 and later. {@link rowcount} DB2_ROWCOUNT_PREFETCH_ON - Client
 *   can request the full row count prior to fetching, which means that
 *   {@link db2_num_rows} returns the number of rows selected even when a
 *   ROLLFORWARD_ONLY cursor is used. DB2_ROWCOUNT_PREFETCH_OFF - Client
 *   cannot request the full row count prior to fetching. The following
 *   new options are available in ibm_db2 version 1.7.0 and later. {@link
 *   trusted_user} To switch the user to a trusted user, pass the User ID
 *   (String) of the trusted user as the value of this key. This option
 *   can be set on a connection resource only. To use this option,
 *   trusted context must be enabled on the connection resource. {@link
 *   trusted_password} The password (String) that corresponds to the user
 *   specified by the trusted_user key. The following new options are
 *   available in ibm_db2 version 1.6.0 and later. These options provide
 *   useful tracking information that can be accessed during execution
 *   with {@link db2_get_option}. When the value in each option is being
 *   set, some servers might not handle the entire length provided and
 *   might truncate the value. To ensure that the data specified in each
 *   option is converted correctly when transmitted to a host system, use
 *   only the characters A through Z, 0 through 9, and the underscore (_)
 *   or period (.). {@link userid} SQL_ATTR_INFO_USERID - A pointer to a
 *   null-terminated character string used to identify the client user ID
 *   sent to the host database server when using DB2 Connect. DB2 for
 *   z/OS and OS/390 servers support up to a length of 16 characters.
 *   This user-id is not to be confused with the authentication user-id,
 *   it is for identification purposes only and is not used for any
 *   authorization. {@link acctstr} SQL_ATTR_INFO_ACCTSTR - A pointer to
 *   a null-terminated character string used to identify the client
 *   accounting string sent to the host database server when using DB2
 *   Connect. DB2 for z/OS and OS/390 servers support up to a length of
 *   200 characters. {@link applname} SQL_ATTR_INFO_APPLNAME - A pointer
 *   to a null-terminated character string used to identify the client
 *   application name sent to the host database server when using DB2
 *   Connect. DB2 for z/OS and OS/390 servers support up to a length of
 *   32 characters. {@link wrkstnname} SQL_ATTR_INFO_WRKSTNNAME - A
 *   pointer to a null-terminated character string used to identify the
 *   client workstation name sent to the host database server when using
 *   DB2 Connect. DB2 for z/OS and OS/390 servers support up to a length
 *   of 18 characters.
 * @param int $type Passing DB2_AUTOCOMMIT_ON turns autocommit on for
 *   the specified connection resource. Passing DB2_AUTOCOMMIT_OFF turns
 *   autocommit off for the specified connection resource.
 * @return bool
 * @since PECL ibm_db2 >= 1.0.0
 **/
function db2_set_option($resource, $options, $type){}

/**
 * Returns a result set listing the unique row identifier columns for a
 * table
 *
 * Returns a result set listing the unique row identifier columns for a
 * table.
 *
 * @param resource $connection A valid connection to an IBM DB2,
 *   Cloudscape, or Apache Derby database.
 * @param string $qualifier A qualifier for DB2 databases running on
 *   OS/390 or z/OS servers. For other databases, pass NULL or an empty
 *   string.
 * @param string $schema The schema which contains the tables.
 * @param string $table_name The name of the table.
 * @param int $scope Integer value representing the minimum duration
 *   for which the unique row identifier is valid. This can be one of the
 *   following values: Integer value SQL constant Description 0
 *   SQL_SCOPE_CURROW Row identifier is valid only while the cursor is
 *   positioned on the row. 1 SQL_SCOPE_TRANSACTION Row identifier is
 *   valid for the duration of the transaction. 2 SQL_SCOPE_SESSION Row
 *   identifier is valid for the duration of the connection.
 * @return resource Returns a statement resource with a result set
 *   containing rows with unique row identifier information for a table.
 *   The rows are composed of the following columns: Column name
 *   Description SCOPE Integer value SQL constant Description 0
 *   SQL_SCOPE_CURROW Row identifier is valid only while the cursor is
 *   positioned on the row. 1 SQL_SCOPE_TRANSACTION Row identifier is
 *   valid for the duration of the transaction. 2 SQL_SCOPE_SESSION Row
 *   identifier is valid for the duration of the connection. COLUMN_NAME
 *   Name of the unique column. DATA_TYPE SQL data type for the column.
 *   TYPE_NAME Character string representation of the SQL data type for
 *   the column. COLUMN_SIZE An integer value representing the size of
 *   the column. BUFFER_LENGTH Maximum number of bytes necessary to store
 *   data from this column. DECIMAL_DIGITS The scale of the column, or
 *   NULL where scale is not applicable. NUM_PREC_RADIX An integer value
 *   of either 10 (representing an exact numeric data type), 2
 *   (representing an approximate numeric data type), or NULL
 *   (representing a data type for which radix is not applicable).
 *   PSEUDO_COLUMN Always returns 1.
 * @since PECL ibm_db2 >= 1.0.0
 **/
function db2_special_columns($connection, $qualifier, $schema, $table_name, $scope){}

/**
 * Returns a result set listing the index and statistics for a table
 *
 * Returns a result set listing the index and statistics for a table.
 *
 * @param resource $connection A valid connection to an IBM DB2,
 *   Cloudscape, or Apache Derby database.
 * @param string $qualifier A qualifier for DB2 databases running on
 *   OS/390 or z/OS servers. For other databases, pass NULL or an empty
 *   string.
 * @param string $schema The schema that contains the targeted table.
 *   If this parameter is NULL, the statistics and indexes are returned
 *   for the schema of the current user.
 * @param string $tablename The name of the table.
 * @param bool $unique An integer value representing the type of index
 *   information to return. {@link 0} Return only the information for
 *   unique indexes on the table. {@link 1} Return the information for
 *   all indexes on the table.
 * @return resource Returns a statement resource with a result set
 *   containing rows describing the statistics and indexes for the base
 *   tables matching the specified parameters. The rows are composed of
 *   the following columns: Column name Description TABLE_CAT The catalog
 *   that contains the table. The value is NULL if this table does not
 *   have catalogs. TABLE_SCHEM Name of the schema that contains the
 *   table. TABLE_NAME Name of the table. NON_UNIQUE An integer value
 *   representing whether the index prohibits unique values, or whether
 *   the row represents statistics on the table itself: Return value
 *   Parameter type 0 (SQL_FALSE) The index allows duplicate values. 1
 *   (SQL_TRUE) The index values must be unique. NULL This row is
 *   statistics information for the table itself. INDEX_QUALIFIER A
 *   string value representing the qualifier that would have to be
 *   prepended to INDEX_NAME to fully qualify the index. INDEX_NAME A
 *   string representing the name of the index. TYPE An integer value
 *   representing the type of information contained in this row of the
 *   result set: Return value Parameter type 0 (SQL_TABLE_STAT) The row
 *   contains statistics about the table itself. 1 (SQL_INDEX_CLUSTERED)
 *   The row contains information about a clustered index. 2
 *   (SQL_INDEX_HASH) The row contains information about a hashed index.
 *   3 (SQL_INDEX_OTHER) The row contains information about a type of
 *   index that is neither clustered nor hashed. ORDINAL_POSITION The
 *   1-indexed position of the column in the index. NULL if the row
 *   contains statistics information about the table itself. COLUMN_NAME
 *   The name of the column in the index. NULL if the row contains
 *   statistics information about the table itself. ASC_OR_DESC A if the
 *   column is sorted in ascending order, D if the column is sorted in
 *   descending order, NULL if the row contains statistics information
 *   about the table itself. CARDINALITY If the row contains information
 *   about an index, this column contains an integer value representing
 *   the number of unique values in the index. If the row contains
 *   information about the table itself, this column contains an integer
 *   value representing the number of rows in the table. PAGES If the row
 *   contains information about an index, this column contains an integer
 *   value representing the number of pages used to store the index. If
 *   the row contains information about the table itself, this column
 *   contains an integer value representing the number of pages used to
 *   store the table. FILTER_CONDITION Always returns NULL.
 * @since PECL ibm_db2 >= 1.0.0
 **/
function db2_statistics($connection, $qualifier, $schema, $tablename, $unique){}

/**
 * Returns a string containing the SQLSTATE returned by an SQL statement
 *
 * Returns a string containing the SQLSTATE value returned by an SQL
 * statement.
 *
 * If you do not pass a statement resource as an argument to {@link
 * db2_stmt_error}, the driver returns the SQLSTATE value associated with
 * the last attempt to return a statement resource, for example, from
 * {@link db2_prepare} or {@link db2_exec}.
 *
 * To learn what the SQLSTATE value means, you can issue the following
 * command at a DB2 Command Line Processor prompt: db2 '? {@link
 * sqlstate-value}'. You can also call {@link db2_stmt_errormsg} to
 * retrieve an explicit error message and the associated SQLCODE value.
 *
 * @param resource $stmt A valid statement resource.
 * @return string Returns a string containing an SQLSTATE value.
 * @since PECL ibm_db2 >= 1.0.0
 **/
function db2_stmt_error($stmt){}

/**
 * Returns a string containing the last SQL statement error message
 *
 * Returns a string containing the last SQL statement error message.
 *
 * If you do not pass a statement resource as an argument to {@link
 * db2_stmt_errormsg}, the driver returns the error message associated
 * with the last attempt to return a statement resource, for example,
 * from {@link db2_prepare} or {@link db2_exec}.
 *
 * @param resource $stmt A valid statement resource.
 * @return string Returns a string containing the error message and
 *   SQLCODE value for the last error that occurred issuing an SQL
 *   statement.
 * @since PECL ibm_db2 >= 1.0.0
 **/
function db2_stmt_errormsg($stmt){}

/**
 * Returns a result set listing the tables and associated metadata in a
 * database
 *
 * Returns a result set listing the tables and associated metadata in a
 * database.
 *
 * @param resource $connection A valid connection to an IBM DB2,
 *   Cloudscape, or Apache Derby database.
 * @param string $qualifier A qualifier for DB2 databases running on
 *   OS/390 or z/OS servers. For other databases, pass NULL or an empty
 *   string.
 * @param string $schema The schema which contains the tables. This
 *   parameter accepts a search pattern containing _ and % as wildcards.
 * @param string $tablename The name of the table. This parameter
 *   accepts a search pattern containing _ and % as wildcards.
 * @param string $tabletype A list of comma-delimited table type
 *   identifiers. To match all table types, pass NULL or an empty string.
 *   Valid table type identifiers include: ALIAS, HIERARCHY TABLE,
 *   INOPERATIVE VIEW, NICKNAME, MATERIALIZED QUERY TABLE, SYSTEM TABLE,
 *   TABLE, TYPED TABLE, TYPED VIEW, and VIEW.
 * @return resource Returns a statement resource with a result set
 *   containing rows describing the tables that match the specified
 *   parameters. The rows are composed of the following columns: Column
 *   name Description TABLE_CAT The catalog that contains the table. The
 *   value is NULL if this table does not have catalogs. TABLE_SCHEM Name
 *   of the schema that contains the table. TABLE_NAME Name of the table.
 *   TABLE_TYPE Table type identifier for the table. REMARKS Description
 *   of the table.
 * @since PECL ibm_db2 >= 1.0.0
 **/
function db2_tables($connection, $qualifier, $schema, $tablename, $tabletype){}

/**
 * Returns a result set listing the tables and associated privileges in a
 * database
 *
 * Returns a result set listing the tables and associated privileges in a
 * database.
 *
 * @param resource $connection A valid connection to an IBM DB2,
 *   Cloudscape, or Apache Derby database.
 * @param string $qualifier A qualifier for DB2 databases running on
 *   OS/390 or z/OS servers. For other databases, pass NULL or an empty
 *   string.
 * @param string $schema The schema which contains the tables. This
 *   parameter accepts a search pattern containing _ and % as wildcards.
 * @param string $table_name The name of the table. This parameter
 *   accepts a search pattern containing _ and % as wildcards.
 * @return resource Returns a statement resource with a result set
 *   containing rows describing the privileges for the tables that match
 *   the specified parameters. The rows are composed of the following
 *   columns: Column name Description TABLE_CAT The catalog that contains
 *   the table. The value is NULL if this table does not have catalogs.
 *   TABLE_SCHEM Name of the schema that contains the table. TABLE_NAME
 *   Name of the table. GRANTOR Authorization ID of the user who granted
 *   the privilege. GRANTEE Authorization ID of the user to whom the
 *   privilege was granted. PRIVILEGE The privilege that has been
 *   granted. This can be one of ALTER, CONTROL, DELETE, INDEX, INSERT,
 *   REFERENCES, SELECT, or UPDATE. IS_GRANTABLE A string value of "YES"
 *   or "NO" indicating whether the grantee can grant the privilege to
 *   other users.
 * @since PECL ibm_db2 >= 1.0.0
 **/
function db2_table_privileges($connection, $qualifier, $schema, $table_name){}

/**
 * Adds a record to a database
 *
 * Adds the given data to the database.
 *
 * @param resource $dbase_identifier The database link identifier,
 *   returned by {@link dbase_open} or {@link dbase_create}.
 * @param array $record An indexed array of data. The number of items
 *   must be equal to the number of fields in the database, otherwise
 *   {@link dbase_add_record} will fail.
 * @return bool
 * @since PHP 5 < 5.3.0, dbase 5, dbase 7
 **/
function dbase_add_record($dbase_identifier, $record){}

/**
 * Closes a database
 *
 * Closes the given database link identifier.
 *
 * @param resource $dbase_identifier The database link identifier,
 *   returned by {@link dbase_open} or {@link dbase_create}.
 * @return bool
 * @since PHP 5 < 5.3.0, dbase 5, dbase 7
 **/
function dbase_close($dbase_identifier){}

/**
 * Creates a database
 *
 * {@link dbase_create} creates a dBase database with the given
 * definition. If the file already exists, it is not truncated. {@link
 * dbase_pack} can be called to force truncation.
 *
 * @param string $filename The name of the database. It can be a
 *   relative or absolute path to the file where dBase will store your
 *   data.
 * @param array $fields An array of arrays, each array describing the
 *   format of one field of the database. Each field consists of a name,
 *   a character indicating the field type, and optionally, a length, a
 *   precision and a nullable flag. The supported field types are listed
 *   in the introduction section.
 * @param int $type The type of database to be created. Either
 *   DBASE_TYPE_DBASE or DBASE_TYPE_FOXPRO.
 * @return resource Returns a database link identifier if the database
 *   is successfully created, or FALSE if an error occurred.
 * @since PHP 5 < 5.3.0, dbase 5, dbase 7
 **/
function dbase_create($filename, $fields, $type){}

/**
 * Deletes a record from a database
 *
 * Marks the given record to be deleted from the database.
 *
 * @param resource $dbase_identifier The database link identifier,
 *   returned by {@link dbase_open} or {@link dbase_create}.
 * @param int $record_number An integer which spans from 1 to the
 *   number of records in the database (as returned by {@link
 *   dbase_numrecords}).
 * @return bool
 * @since PHP 5 < 5.3.0, dbase 5, dbase 7
 **/
function dbase_delete_record($dbase_identifier, $record_number){}

/**
 * Gets the header info of a database
 *
 * Returns information on the column structure of the given database link
 * identifier.
 *
 * @param resource $dbase_identifier The database link identifier,
 *   returned by {@link dbase_open} or {@link dbase_create}.
 * @return array An indexed array with an entry for each column in the
 *   database. The array index starts at 0.
 * @since PHP 5 < 5.3.0, dbase 5, dbase 7
 **/
function dbase_get_header_info($dbase_identifier){}

/**
 * Gets a record from a database as an indexed array
 *
 * Gets a record from a database as an indexed array.
 *
 * @param resource $dbase_identifier The database link identifier,
 *   returned by {@link dbase_open} or {@link dbase_create}.
 * @param int $record_number The index of the record between 1 and
 *   dbase_numrecords($dbase_identifier).
 * @return array An indexed array with the record. This array will also
 *   include an associative key named deleted which is set to 1 if the
 *   record has been marked for deletion (see {@link
 *   dbase_delete_record}).
 * @since PHP 5 < 5.3.0, dbase 5, dbase 7
 **/
function dbase_get_record($dbase_identifier, $record_number){}

/**
 * Gets a record from a database as an associative array
 *
 * Gets a record from a dBase database as an associative array.
 *
 * @param resource $dbase_identifier The database link identifier,
 *   returned by {@link dbase_open} or {@link dbase_create}.
 * @param int $record_number The index of the record between 1 and
 *   dbase_numrecords($dbase_identifier).
 * @return array An associative array with the record. This will also
 *   include a key named deleted which is set to 1 if the record has been
 *   marked for deletion (see {@link dbase_delete_record}). Therefore it
 *   is not possible to retrieve the value of a field named deleted with
 *   this function.
 * @since PHP 5 < 5.3.0, dbase 5, dbase 7
 **/
function dbase_get_record_with_names($dbase_identifier, $record_number){}

/**
 * Gets the number of fields of a database
 *
 * Gets the number of fields (columns) in the specified database.
 *
 * @param resource $dbase_identifier The database link identifier,
 *   returned by {@link dbase_open} or {@link dbase_create}.
 * @return int The number of fields in the database, or FALSE if an
 *   error occurs.
 * @since PHP 5 < 5.3.0, dbase 5, dbase 7
 **/
function dbase_numfields($dbase_identifier){}

/**
 * Gets the number of records in a database
 *
 * Gets the number of records (rows) in the specified database.
 *
 * @param resource $dbase_identifier The database link identifier,
 *   returned by {@link dbase_open} or {@link dbase_create}.
 * @return int The number of records in the database, or FALSE if an
 *   error occurs.
 * @since PHP 5 < 5.3.0, dbase 5, dbase 7
 **/
function dbase_numrecords($dbase_identifier){}

/**
 * Opens a database
 *
 * {@link dbase_open} opens a dBase database with the given access mode.
 *
 * @param string $filename The name of the database. It can be a
 *   relative or absolute path to the file where dBase will store your
 *   data.
 * @param int $mode An integer which correspond to those for the open()
 *   system call (Typically 0 means read-only, 1 means write-only, and 2
 *   means read and write). As of dbase 7.0.0 you can use DBASE_RDONLY
 *   and DBASE_RDWR, respectively, to specify the {@link mode}.
 * @return resource Returns a database link identifier if the database
 *   is successfully opened, or FALSE if an error occurred.
 * @since PHP 5 < 5.3.0, dbase 5, dbase 7
 **/
function dbase_open($filename, $mode){}

/**
 * Packs a database
 *
 * Packs the specified database by permanently deleting all records
 * marked for deletion using {@link dbase_delete_record}. Note that the
 * file will be truncated after successful packing (contrary to dBASE
 * III's PACK command).
 *
 * @param resource $dbase_identifier The database link identifier,
 *   returned by {@link dbase_open} or {@link dbase_create}.
 * @return bool
 * @since PHP 5 < 5.3.0, dbase 5, dbase 7
 **/
function dbase_pack($dbase_identifier){}

/**
 * Replaces a record in a database
 *
 * Replaces the given record in the database with the given data.
 *
 * @param resource $dbase_identifier The database link identifier,
 *   returned by {@link dbase_open} or {@link dbase_create}.
 * @param array $record An indexed array of data. The number of items
 *   must be equal to the number of fields in the database, otherwise
 *   {@link dbase_replace_record} will fail.
 * @param int $record_number An integer which spans from 1 to the
 *   number of records in the database (as returned by {@link
 *   dbase_numrecords}).
 * @return bool
 * @since PHP 5 < 5.3.0, dbase 5, dbase 7
 **/
function dbase_replace_record($dbase_identifier, $record, $record_number){}

/**
 * Close a DBA database
 *
 * {@link dba_close} closes the established database and frees all
 * resources of the specified database handle.
 *
 * @param resource $handle The database handler, returned by {@link
 *   dba_open} or {@link dba_popen}.
 * @return void
 * @since PHP 4, PHP 5, PHP 7
 **/
function dba_close($handle){}

/**
 * Delete DBA entry specified by key
 *
 * {@link dba_delete} deletes the specified entry from the database.
 *
 * @param string $key The key of the entry which is deleted.
 * @param resource $handle The database handler, returned by {@link
 *   dba_open} or {@link dba_popen}.
 * @return bool
 * @since PHP 4, PHP 5, PHP 7
 **/
function dba_delete($key, $handle){}

/**
 * Check whether key exists
 *
 * {@link dba_exists} checks whether the specified {@link key} exists in
 * the database.
 *
 * @param string $key The key the check is performed for.
 * @param resource $handle The database handler, returned by {@link
 *   dba_open} or {@link dba_popen}.
 * @return bool Returns TRUE if the key exists, FALSE otherwise.
 * @since PHP 4, PHP 5, PHP 7
 **/
function dba_exists($key, $handle){}

/**
 * Fetch data specified by key
 *
 * {@link dba_fetch} fetches the data specified by {@link key} from the
 * database specified with {@link handle}.
 *
 * @param string $key The key the data is specified by.
 * @param resource $handle The number of key-value pairs to ignore when
 *   using cdb databases. This value is ignored for all other databases
 *   which do not support multiple keys with the same name.
 * @return string Returns the associated string if the key/data pair is
 *   found, FALSE otherwise.
 * @since PHP 4, PHP 5, PHP 7
 **/
function dba_fetch($key, $handle){}

/**
 * Fetch first key
 *
 * {@link dba_firstkey} returns the first key of the database and resets
 * the internal key pointer. This permits a linear search through the
 * whole database.
 *
 * @param resource $handle The database handler, returned by {@link
 *   dba_open} or {@link dba_popen}.
 * @return string Returns the key on success.
 * @since PHP 4, PHP 5, PHP 7
 **/
function dba_firstkey($handle){}

/**
 * List all the handlers available
 *
 * {@link dba_handlers} list all the handlers supported by this
 * extension.
 *
 * @param bool $full_info Turns on/off full information display in the
 *   result.
 * @return array Returns an array of database handlers. If {@link
 *   full_info} is set to TRUE, the array will be associative with the
 *   handlers names as keys, and their version information as value.
 *   Otherwise, the result will be an indexed array of handlers names.
 * @since PHP 4 >= 4.3.0, PHP 5, PHP 7
 **/
function dba_handlers($full_info){}

/**
 * Insert entry
 *
 * {@link dba_insert} inserts the entry described with {@link key} and
 * {@link value} into the database.
 *
 * @param string $key The key of the entry to be inserted. If this key
 *   already exist in the database, this function will fail. Use {@link
 *   dba_replace} if you need to replace an existent key.
 * @param string $value The value to be inserted.
 * @param resource $handle The database handler, returned by {@link
 *   dba_open} or {@link dba_popen}.
 * @return bool
 * @since PHP 4, PHP 5, PHP 7
 **/
function dba_insert($key, $value, $handle){}

/**
 * Splits a key in string representation into array representation
 *
 * {@link dba_key_split} splits a key (string representation) into an
 * array representation.
 *
 * @param mixed $key The key in string representation.
 * @return mixed Returns an array of the form array(0 => group, 1 