/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint;

import java.util.Objects;
import java.util.Optional;
import javax.swing.Icon;
import org.openstreetmap.josm.gui.mappaint.Cascade;
import org.openstreetmap.josm.gui.mappaint.StyleSource;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;

public interface StyleSetting {
    public Object getValue();

    public static class BooleanStyleSetting
    extends LabeledStyleSetting
    implements StyleSetting {
        public final String prefKey;
        public final boolean def;

        public BooleanStyleSetting(StyleSource parentStyle, String prefKey, String label, boolean def) {
            super(parentStyle, label);
            this.prefKey = Objects.requireNonNull(prefKey);
            this.def = def;
        }

        public static BooleanStyleSetting create(Cascade c, StyleSource parentStyle, String key) {
            String label = c.get("label", null, String.class);
            if (label == null) {
                Logging.warn("property 'label' required for boolean style setting");
                return null;
            }
            Boolean def = c.get("default", null, Boolean.class);
            if (def == null) {
                Logging.warn("property 'default' required for boolean style setting");
                return null;
            }
            String prefKey = parentStyle.url + ":boolean:" + key;
            return new BooleanStyleSetting(parentStyle, prefKey, label, def);
        }

        @Override
        public Object getValue() {
            String val = Config.getPref().get(this.prefKey, null);
            if (val == null) {
                return this.def;
            }
            return Boolean.valueOf(val);
        }

        public void setValue(Object o) {
            if (!(o instanceof Boolean)) {
                throw new IllegalArgumentException();
            }
            boolean b = (Boolean)o;
            if (b == this.def) {
                Config.getPref().put(this.prefKey, null);
            } else {
                Config.getPref().putBoolean(this.prefKey, b);
            }
        }
    }

    public static class StyleSettingGroup
    extends LabeledStyleSetting {
        public final String key;
        public final Icon icon;

        public StyleSettingGroup(StyleSource parentStyle, String label, String key, Icon icon) {
            super(parentStyle, label);
            this.key = Objects.requireNonNull(key);
            this.icon = icon;
        }

        public static StyleSettingGroup create(Cascade c, StyleSource parentStyle, String key) {
            String label = c.get("label", null, String.class);
            if (label == null) {
                Logging.warn("property 'label' required for boolean style setting");
                return null;
            }
            Icon icon = Optional.ofNullable(c.get("icon", null, String.class)).map(s -> ImageProvider.get(s, ImageProvider.ImageSizes.MENU)).orElse(null);
            return new StyleSettingGroup(parentStyle, label, key, icon);
        }
    }

    public static abstract class LabeledStyleSetting
    implements Comparable<LabeledStyleSetting> {
        public final StyleSource parentStyle;
        public final String label;

        LabeledStyleSetting(StyleSource parentStyle, String label) {
            this.parentStyle = Objects.requireNonNull(parentStyle);
            this.label = Objects.requireNonNull(label);
        }

        public int hashCode() {
            return Objects.hash(this.label, this.parentStyle);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            LabeledStyleSetting other = (LabeledStyleSetting)obj;
            return Objects.equals(this.label, other.label) && Objects.equals(this.parentStyle, other.parentStyle);
        }

        @Override
        public int compareTo(LabeledStyleSetting o) {
            return this.label.compareTo(o.label);
        }
    }
}

