import { IStorageProvider } from "./IStorageProvider";
import { IFilterInfo } from "../IFilter";
import { IAppserviceStorageProvider } from "./IAppserviceStorageProvider";
export declare class SimpleFsStorageProvider implements IStorageProvider, IAppserviceStorageProvider {
    private trackTransactionsInMemory;
    private maxInMemoryTransactions;
    private db;
    private completedTransactions;
    constructor(filename: string, trackTransactionsInMemory?: boolean, maxInMemoryTransactions?: number);
    setSyncToken(token: string | null): void;
    getSyncToken(): string | null;
    setFilter(filter: IFilterInfo): void;
    getFilter(): IFilterInfo;
    addRegisteredUser(userId: string): void;
    isUserRegistered(userId: string): boolean;
    isTransactionCompleted(transactionId: string): boolean;
    setTransactionCompleted(transactionId: string): void;
}
