/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.core;

import java.text.ParseException;
import java.util.Comparator;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.osgi.util.Version;
import org.apache.ivy.plugins.latest.ArtifactInfo;
import org.apache.ivy.plugins.latest.ComparatorLatestStrategy;
import org.apache.ivy.plugins.version.VersionMatcher;

public class OsgiLatestStrategy
extends ComparatorLatestStrategy {
    private final Comparator mridComparator = new MridComparator();
    private final Comparator artifactInfoComparator = new ArtifactInfoComparator();

    public OsgiLatestStrategy() {
        this.setComparator(this.artifactInfoComparator);
        this.setName("latest-osgi");
    }

    final class ArtifactInfoComparator
    implements Comparator {
        ArtifactInfoComparator() {
        }

        public int compare(Object object, Object object2) {
            return this.compare((ArtifactInfo)object, (ArtifactInfo)object2);
        }

        public int compare(ArtifactInfo artifactInfo, ArtifactInfo artifactInfo2) {
            String string = artifactInfo.getRevision();
            String string2 = artifactInfo2.getRevision();
            VersionMatcher versionMatcher = IvyContext.getContext().getSettings().getVersionMatcher();
            ModuleRevisionId moduleRevisionId = ModuleRevisionId.newInstance("", "", string);
            ModuleRevisionId moduleRevisionId2 = ModuleRevisionId.newInstance("", "", string2);
            if (versionMatcher.isDynamic(moduleRevisionId)) {
                int n = versionMatcher.compare(moduleRevisionId, moduleRevisionId2, OsgiLatestStrategy.this.mridComparator);
                return n >= 0 ? 1 : -1;
            }
            if (versionMatcher.isDynamic(moduleRevisionId2)) {
                int n = versionMatcher.compare(moduleRevisionId2, moduleRevisionId, OsgiLatestStrategy.this.mridComparator);
                return n >= 0 ? -1 : 1;
            }
            return OsgiLatestStrategy.this.mridComparator.compare(moduleRevisionId, moduleRevisionId2);
        }
    }

    final class MridComparator
    implements Comparator {
        MridComparator() {
        }

        public int compare(Object object, Object object2) {
            return this.compare((ModuleRevisionId)object, (ModuleRevisionId)object2);
        }

        public int compare(ModuleRevisionId moduleRevisionId, ModuleRevisionId moduleRevisionId2) {
            Version version;
            Version version2;
            try {
                version2 = new Version(moduleRevisionId.getRevision());
                version = new Version(moduleRevisionId2.getRevision());
            }
            catch (ParseException parseException) {
                throw new RuntimeException("Uncomparable versions:" + moduleRevisionId.getRevision() + " and " + moduleRevisionId2.getRevision() + " (" + parseException.getMessage() + ")");
            }
            return version2.compareTo(version);
        }
    }
}

