/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.lang.ref.SoftReference;
import org.eclipse.jgit.internal.storage.file.PackFile;
import org.eclipse.jgit.storage.file.WindowCacheConfig;

class DeltaBaseCache {
    private static final int CACHE_SZ = 1024;
    static final SoftReference<Entry> DEAD = new SoftReference<Object>(null);
    private static volatile int defaultMaxByteCount;
    private final int maxByteCount = defaultMaxByteCount;
    private final Slot[] cache = new Slot[1024];
    private Slot lruHead;
    private Slot lruTail;
    private int openByteCount;

    private static int hash(long position) {
        return (int)position << 22 >>> 22;
    }

    static void reconfigure(WindowCacheConfig cfg) {
        defaultMaxByteCount = cfg.getDeltaBaseCacheLimit();
    }

    DeltaBaseCache() {
    }

    Entry get(PackFile pack, long position) {
        Entry buf;
        Slot e2 = this.cache[DeltaBaseCache.hash(position)];
        if (e2 == null) {
            return null;
        }
        if (e2.provider == pack && e2.position == position && (buf = e2.data.get()) != null) {
            this.moveToHead(e2);
            return buf;
        }
        return null;
    }

    void store(PackFile pack, long position, byte[] data2, int objectType) {
        if (data2.length > this.maxByteCount) {
            return;
        }
        Slot e2 = this.cache[DeltaBaseCache.hash(position)];
        if (e2 == null) {
            this.cache[DeltaBaseCache.hash((long)position)] = e2 = new Slot();
        } else {
            this.clearEntry(e2);
        }
        this.openByteCount += data2.length;
        this.releaseMemory();
        e2.provider = pack;
        e2.position = position;
        e2.sz = data2.length;
        e2.data = new SoftReference<Entry>(new Entry(data2, objectType));
        this.moveToHead(e2);
    }

    private void releaseMemory() {
        while (this.openByteCount > this.maxByteCount && this.lruTail != null) {
            Slot currOldest = this.lruTail;
            Slot nextOldest = currOldest.lruPrev;
            this.clearEntry(currOldest);
            currOldest.lruPrev = null;
            currOldest.lruNext = null;
            if (nextOldest == null) {
                this.lruHead = null;
            } else {
                nextOldest.lruNext = null;
            }
            this.lruTail = nextOldest;
        }
    }

    private void moveToHead(Slot e2) {
        this.unlink(e2);
        e2.lruPrev = null;
        e2.lruNext = this.lruHead;
        if (this.lruHead != null) {
            this.lruHead.lruPrev = e2;
        } else {
            this.lruTail = e2;
        }
        this.lruHead = e2;
    }

    private void unlink(Slot e2) {
        Slot prev2 = e2.lruPrev;
        Slot next2 = e2.lruNext;
        if (prev2 != null) {
            prev2.lruNext = next2;
        }
        if (next2 != null) {
            next2.lruPrev = prev2;
        }
    }

    private void clearEntry(Slot e2) {
        this.openByteCount -= e2.sz;
        e2.provider = null;
        e2.data = DEAD;
        e2.sz = 0;
    }

    static {
        DeltaBaseCache.reconfigure(new WindowCacheConfig());
    }

    static class Entry {
        final byte[] data;
        final int type;

        Entry(byte[] aData, int aType) {
            this.data = aData;
            this.type = aType;
        }
    }

    private static class Slot {
        Slot lruPrev;
        Slot lruNext;
        PackFile provider;
        long position;
        int sz;
        SoftReference<Entry> data = DEAD;

        private Slot() {
        }
    }
}

