/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.devel.tasks;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.inject.Inject;
import org.gradle.api.GradleException;
import org.gradle.api.Incubating;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Task;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.EmptyFileVisitor;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskValidationException;
import org.gradle.api.tasks.VerificationTask;
import org.gradle.internal.Cast;
import org.gradle.internal.classloader.ClassLoaderFactory;
import org.gradle.internal.classloader.ClassLoaderUtils;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.plugin.devel.tasks.internal.ValidateTaskPropertiesBackwardsCompatibleAdapter;
import org.gradle.util.DeprecationLogger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

@CacheableTask
public class ValidateTaskProperties
extends ConventionTask
implements VerificationTask,
ValidateTaskPropertiesBackwardsCompatibleAdapter {
    private final ConfigurableFileCollection classes;
    private final ConfigurableFileCollection classpath;
    private final RegularFileProperty outputFile;
    private boolean enableStricterValidation;
    private boolean ignoreFailures;
    private boolean failOnWarning;

    @Inject
    public ValidateTaskProperties(ObjectFactory objects, ProjectLayout layout) {
        this.classes = layout.configurableFiles(new Object[0]);
        this.classpath = layout.configurableFiles(new Object[0]);
        this.outputFile = objects.fileProperty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    public void validateTaskClasses() throws IOException {
        ClassLoader previousContextClassLoader = Thread.currentThread().getContextClassLoader();
        ClassPath classPath = DefaultClassPath.of((Iterable)Iterables.concat((Iterable)this.getClasses(), (Iterable)this.getClasspath()));
        ClassLoader classLoader = this.getClassLoaderFactory().createIsolatedClassLoader("task-loader", classPath);
        Thread.currentThread().setContextClassLoader(classLoader);
        try {
            this.validateTaskClasses(classLoader);
        }
        finally {
            Thread.currentThread().setContextClassLoader(previousContextClassLoader);
            ClassLoaderUtils.tryClose((ClassLoader)classLoader);
        }
    }

    private void validateTaskClasses(final ClassLoader classLoader) throws IOException {
        Method validatorMethod;
        Class<?> taskInterface;
        final TreeMap taskValidationProblems = Maps.newTreeMap();
        try {
            taskInterface = classLoader.loadClass(Task.class.getName());
            Class<?> validatorClass = classLoader.loadClass("org.gradle.api.internal.tasks.properties.PropertyValidationAccess");
            validatorMethod = validatorClass.getMethod("collectTaskValidationProblems", Class.class, Map.class, Boolean.TYPE);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        this.getClasses().getAsFileTree().visit((FileVisitor)new EmptyFileVisitor(){

            public void visitFile(FileVisitDetails fileDetails) {
                ClassReader reader;
                if (!fileDetails.getPath().endsWith(".class")) {
                    return;
                }
                try {
                    reader = new ClassReader(Files.asByteSource((File)fileDetails.getFile()).read());
                }
                catch (IOException e) {
                    throw new UncheckedIOException((Throwable)e);
                }
                ArrayList classNames = Lists.newArrayList();
                reader.accept((ClassVisitor)new TaskNameCollectorVisitor(classNames), 1);
                for (String className : classNames) {
                    Class<?> clazz;
                    try {
                        clazz = classLoader.loadClass(className);
                    }
                    catch (IllegalAccessError e) {
                        throw new GradleException("Could not load class: " + className, (Throwable)e);
                    }
                    catch (ClassNotFoundException e) {
                        throw new GradleException("Could not load class: " + className, (Throwable)e);
                    }
                    catch (NoClassDefFoundError e) {
                        throw new GradleException("Could not load class: " + className, (Throwable)e);
                    }
                    if (!Modifier.isPublic(clazz.getModifiers()) || Modifier.isAbstract(clazz.getModifiers()) || !taskInterface.isAssignableFrom(clazz)) continue;
                    Class taskClass = (Class)Cast.uncheckedCast(clazz);
                    try {
                        validatorMethod.invoke(null, taskClass, taskValidationProblems, ValidateTaskProperties.this.enableStricterValidation);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                    catch (InvocationTargetException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        });
        List<String> problemMessages = ValidateTaskProperties.toProblemMessages(taskValidationProblems);
        this.storeResults(problemMessages);
        this.communicateResult(problemMessages, taskValidationProblems.values().contains(Boolean.TRUE));
    }

    private void storeResults(List<String> problemMessages) throws IOException {
        if (this.outputFile.isPresent()) {
            File output = ((RegularFile)this.outputFile.get()).getAsFile();
            output.createNewFile();
            Files.asCharSink((File)output, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)Joiner.on((char)'\n').join(problemMessages));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void communicateResult(List<String> problemMessages, boolean hasErrors) {
        if (problemMessages.isEmpty()) {
            this.getLogger().info("Task property validation finished without warnings.");
            return;
        } else if (hasErrors || this.getFailOnWarning()) {
            if (!this.getIgnoreFailures()) throw new TaskValidationException(String.format("Task property validation failed. See %s for more information on how to annotate task properties.", this.getDocumentationRegistry().getDocumentationFor("more_about_tasks", "sec:task_input_output_annotations")), ValidateTaskProperties.toExceptionList(problemMessages));
            this.getLogger().warn("Task property validation finished with errors. See {} for more information on how to annotate task properties.{}", (Object)this.getDocumentationRegistry().getDocumentationFor("more_about_tasks", "sec:task_input_output_annotations"), (Object)ValidateTaskProperties.toMessageList(problemMessages));
            return;
        } else {
            this.getLogger().warn("Task property validation finished with warnings:{}", (Object)ValidateTaskProperties.toMessageList(problemMessages));
        }
    }

    private static List<String> toProblemMessages(Map<String, Boolean> problems) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Map.Entry<String, Boolean> entry : problems.entrySet()) {
            String problem = entry.getKey();
            Boolean error = entry.getValue();
            builder.add((Object)String.format("%s: %s", Boolean.TRUE.equals(error) ? "Error" : "Warning", problem));
        }
        return builder.build();
    }

    private static CharSequence toMessageList(List<String> problemMessages) {
        StringBuilder builder = new StringBuilder();
        for (String problemMessage : problemMessages) {
            builder.append(String.format("%n  - %s", problemMessage));
        }
        return builder;
    }

    private static List<InvalidUserDataException> toExceptionList(List<String> problemMessages) {
        return Lists.transform(problemMessages, (Function)new Function<String, InvalidUserDataException>(){

            public InvalidUserDataException apply(String problemMessage) {
                return new InvalidUserDataException(problemMessage);
            }
        });
    }

    public boolean getIgnoreFailures() {
        return this.ignoreFailures;
    }

    public void setIgnoreFailures(boolean ignoreFailures) {
        this.ignoreFailures = ignoreFailures;
    }

    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputFiles
    @SkipWhenEmpty
    public ConfigurableFileCollection getClasses() {
        return this.classes;
    }

    @Deprecated
    public void setClasses(FileCollection classes) {
        DeprecationLogger.nagUserOfReplacedMethod((String)"setClasses(FileCollection)", (String)"getClasses().setFrom(FileCollection)");
        this.classes.setFrom((Iterable)classes);
    }

    @Classpath
    public ConfigurableFileCollection getClasspath() {
        return this.classpath;
    }

    @Deprecated
    public void setClasspath(FileCollection classpath) {
        DeprecationLogger.nagUserOfReplacedMethod((String)"setClasspath(FileCollection)", (String)"getClasspath().setFrom(FileCollection)");
        this.classpath.setFrom((Iterable)classpath);
    }

    @Input
    public boolean getFailOnWarning() {
        return this.failOnWarning;
    }

    @Incubating
    @Input
    public boolean getEnableStricterValidation() {
        return this.enableStricterValidation;
    }

    @Incubating
    public void setEnableStricterValidation(boolean enableStricterValidation) {
        this.enableStricterValidation = enableStricterValidation;
    }

    @Optional
    @OutputFile
    public RegularFileProperty getOutputFile() {
        return this.outputFile;
    }

    public void setFailOnWarning(boolean failOnWarning) {
        this.failOnWarning = failOnWarning;
    }

    @Inject
    protected ClassLoaderFactory getClassLoaderFactory() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected DocumentationRegistry getDocumentationRegistry() {
        throw new UnsupportedOperationException();
    }

    private static class TaskNameCollectorVisitor
    extends ClassVisitor {
        private final Collection<String> classNames;

        public TaskNameCollectorVisitor(Collection<String> classNames) {
            super(458752);
            this.classNames = classNames;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            if ((access & 1) != 0) {
                this.classNames.add(name.replace('/', '.'));
            }
        }
    }
}

