/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.rc.plugins.internal;

import java.io.File;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.collections.MinimalFileSet;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.language.base.internal.LanguageSourceSetInternal;
import org.gradle.language.base.internal.SourceTransformTaskConfig;
import org.gradle.language.rc.WindowsResourceSet;
import org.gradle.language.rc.tasks.WindowsResourceCompile;
import org.gradle.nativeplatform.PreprocessingTool;
import org.gradle.nativeplatform.internal.NativeBinarySpecInternal;
import org.gradle.nativeplatform.internal.StaticLibraryBinarySpecInternal;
import org.gradle.nativeplatform.platform.internal.NativePlatformInternal;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainInternal;
import org.gradle.nativeplatform.toolchain.internal.PlatformToolProvider;
import org.gradle.nativeplatform.toolchain.internal.ToolType;
import org.gradle.platform.base.BinarySpec;

public class WindowsResourcesCompileTaskConfig
implements SourceTransformTaskConfig {
    public String getTaskPrefix() {
        return "compile";
    }

    public Class<? extends DefaultTask> getTaskType() {
        return WindowsResourceCompile.class;
    }

    public void configureTask(Task task, BinarySpec binary, LanguageSourceSet sourceSet, ServiceRegistry serviceRegistry) {
        this.configureResourceCompileTask((WindowsResourceCompile)task, (NativeBinarySpecInternal)binary, (WindowsResourceSet)sourceSet);
    }

    private void configureResourceCompileTask(WindowsResourceCompile task, final NativeBinarySpecInternal binary, WindowsResourceSet sourceSet) {
        task.setDescription("Compiles resources of the " + sourceSet + " of " + binary);
        task.getToolChain().set((Object)binary.getToolChain());
        task.getTargetPlatform().set((Object)binary.getTargetPlatform());
        task.includes(sourceSet.getExportedHeaders().getSourceDirectories());
        FileCollectionFactory fileCollectionFactory = (FileCollectionFactory)((ProjectInternal)task.getProject()).getServices().get(FileCollectionFactory.class);
        task.includes(fileCollectionFactory.create(new MinimalFileSet(){

            public Set<File> getFiles() {
                PlatformToolProvider platformToolProvider = ((NativeToolChainInternal)binary.getToolChain()).select((NativePlatformInternal)binary.getTargetPlatform());
                return new LinkedHashSet<File>(platformToolProvider.getSystemLibraries(ToolType.WINDOW_RESOURCES_COMPILER).getIncludeDirs());
            }

            public String getDisplayName() {
                return "System includes for " + binary.getToolChain().getDisplayName();
            }
        }));
        task.source(sourceSet.getSource());
        Project project = task.getProject();
        task.setOutputDir(new File(binary.getNamingScheme().getOutputDirectory(project.getBuildDir(), "objs"), ((LanguageSourceSetInternal)sourceSet).getProjectScopedName()));
        PreprocessingTool rcCompiler = (PreprocessingTool)binary.getToolByName("rcCompiler");
        task.setMacros(rcCompiler.getMacros());
        task.getCompilerArgs().set((Iterable)rcCompiler.getArgs());
        FileTree resourceOutputs = task.getOutputs().getFiles().getAsFileTree().matching((PatternFilterable)new PatternSet().include(new String[]{"**/*.res"}));
        binary.binaryInputs((FileCollection)resourceOutputs);
        if (binary instanceof StaticLibraryBinarySpecInternal) {
            ((StaticLibraryBinarySpecInternal)binary).additionalLinkFiles((FileCollection)resourceOutputs);
        }
    }
}

