/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.util;

import io.micronaut.core.convert.ConversionService;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CollectionUtils {
    public static boolean isEmpty(@Nullable Map map) {
        return map == null || map.isEmpty();
    }

    public static boolean isNotEmpty(@Nullable Map map) {
        return map != null && !map.isEmpty();
    }

    public static boolean isEmpty(@Nullable Collection collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isNotEmpty(@Nullable Collection collection) {
        return collection != null && !collection.isEmpty();
    }

    public static <T> Optional<Iterable<T>> convertCollection(Class<? extends Iterable<T>> iterableType, Collection<T> collection) {
        if (iterableType.isInstance(collection)) {
            return Optional.of(collection);
        }
        if (iterableType.equals(Set.class)) {
            return Optional.of(new HashSet<T>(collection));
        }
        if (iterableType.equals(Queue.class)) {
            return Optional.of(new LinkedList<T>(collection));
        }
        if (iterableType.equals(List.class)) {
            return Optional.of(new ArrayList<T>(collection));
        }
        if (!iterableType.isInterface()) {
            try {
                Constructor<Iterable<T>> constructor = iterableType.getConstructor(Collection.class);
                return Optional.of(constructor.newInstance(collection));
            }
            catch (Throwable e) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    public static Map mapOf(Object ... values) {
        int len = values.length;
        if (len % 2 != 0) {
            throw new IllegalArgumentException("Number of arguments should be an even number representing the keys and values");
        }
        LinkedHashMap<Object, Object> answer = new LinkedHashMap<Object, Object>(len / 2);
        int i = 0;
        while (i < values.length - 1) {
            answer.put(values[i++], values[i++]);
        }
        return answer;
    }

    public static <T> Set<T> iteratorToSet(Iterator<T> iterator) {
        HashSet<T> set = new HashSet<T>();
        while (iterator.hasNext()) {
            set.add(iterator.next());
        }
        return set;
    }

    public static <T> Set<T> enumerationToSet(Enumeration<T> enumeration) {
        HashSet<T> set = new HashSet<T>();
        while (enumeration.hasMoreElements()) {
            set.add(enumeration.nextElement());
        }
        return set;
    }

    @Nonnull
    public static <T> Iterable<T> enumerationToIterable(final @Nullable Enumeration<T> enumeration) {
        if (enumeration == null) {
            return Collections.emptyList();
        }
        return () -> new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return enumeration.hasMoreElements();
            }

            @Override
            public T next() {
                return enumeration.nextElement();
            }
        };
    }

    public static <T> Set<T> setOf(T ... objects) {
        if (objects == null || objects.length == 0) {
            return Collections.emptySet();
        }
        return new HashSet<T>(Arrays.asList(objects));
    }

    public static String toString(Iterable<?> iterable) {
        return CollectionUtils.toString(",", iterable);
    }

    public static String toString(String delimiter, Iterable<?> iterable) {
        StringBuilder builder = new StringBuilder();
        Iterator<?> i = iterable.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (o == null) continue;
            Optional<String> converted = ConversionService.SHARED.convert(o, String.class);
            converted.ifPresent(builder::append);
            if (!i.hasNext()) continue;
            builder.append(delimiter);
        }
        return builder.toString();
    }

    public static <T> List<T> iterableToList(Iterable<T> iterable) {
        if (iterable == null) {
            return Collections.emptyList();
        }
        if (iterable instanceof List) {
            return (List)iterable;
        }
        Iterator<T> i = iterable.iterator();
        if (i.hasNext()) {
            ArrayList<T> list = new ArrayList<T>();
            while (i.hasNext()) {
                list.add(i.next());
            }
            return list;
        }
        return Collections.emptyList();
    }

    public static <T> Set<T> iterableToSet(Iterable<T> iterable) {
        if (iterable == null) {
            return Collections.emptySet();
        }
        if (iterable instanceof Set) {
            return (Set)iterable;
        }
        Iterator<T> i = iterable.iterator();
        if (i.hasNext()) {
            HashSet<T> list = new HashSet<T>();
            while (i.hasNext()) {
                list.add(i.next());
            }
            return list;
        }
        return Collections.emptySet();
    }

    @Nonnull
    public static <T> List<T> unmodifiableList(@Nullable List<T> list) {
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(list);
    }
}

