/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.Arrays;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.lower.SpecialBridgeMethodsKt;
import org.jetbrains.kotlin.backend.common.phaser.PhaseBuildersKt;
import org.jetbrains.kotlin.backend.common.phaser.SameTypeNamedPhaseWrapper;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.lower.BridgeLoweringKt;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOriginImpl;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.org.objectweb.asm.commons.Method;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000<\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\n\u0010\u000b\u001a\u00020\f*\u00020\r\u001a\n\u0010\u000e\u001a\u00020\f*\u00020\u000f\u001a\u0010\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0011*\u00020\u000f\u001a\u0012\u0010\u0012\u001a\u00020\f*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013\"\u0017\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\" \u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"ORIGINS_FROM_JAVA", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOriginImpl;", "getORIGINS_FROM_JAVA", "()Ljava/util/Set;", "bridgePhase", "Lorg/jetbrains/kotlin/backend/common/phaser/SameTypeNamedPhaseWrapper;", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "getBridgePhase", "()Lorg/jetbrains/kotlin/backend/common/phaser/SameTypeNamedPhaseWrapper;", "comesFromJava", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "isCollectionStub", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "overriddenInClasses", "Lkotlin/sequences/Sequence;", "sameCallAs", "Lorg/jetbrains/org/objectweb/asm/commons/Method;", "other", "backend.jvm"})
public final class BridgeLoweringKt {
    @NotNull
    private static final SameTypeNamedPhaseWrapper<JvmBackendContext, IrFile> bridgePhase = PhaseBuildersKt.makeIrFilePhase$default(bridgePhase.1.INSTANCE, "Bridge", "Generate bridges", null, null, null, null, null, 248, null);
    @NotNull
    private static final Set<IrDeclarationOriginImpl> ORIGINS_FROM_JAVA = SetsKt.setOf(IrDeclarationOrigin.IR_EXTERNAL_JAVA_DECLARATION_STUB.INSTANCE, IrDeclarationOrigin.IR_EXTERNAL_DECLARATION_STUB.INSTANCE);

    @NotNull
    public static final SameTypeNamedPhaseWrapper<JvmBackendContext, IrFile> getBridgePhase() {
        return bridgePhase;
    }

    @NotNull
    public static final Sequence<IrSimpleFunction> overriddenInClasses(@NotNull IrSimpleFunction $this$overriddenInClasses) {
        Intrinsics.checkParameterIsNotNull($this$overriddenInClasses, "$this$overriddenInClasses");
        return SequencesKt.filter(SpecialBridgeMethodsKt.allOverridden($this$overriddenInClasses), overriddenInClasses.1.INSTANCE);
    }

    public static final boolean isCollectionStub(@NotNull IrSimpleFunction $this$isCollectionStub) {
        Intrinsics.checkParameterIsNotNull($this$isCollectionStub, "$this$isCollectionStub");
        return Intrinsics.areEqual($this$isCollectionStub.getOrigin(), IrDeclarationOrigin.IR_BUILTINS_STUB.INSTANCE);
    }

    @NotNull
    public static final Set<IrDeclarationOriginImpl> getORIGINS_FROM_JAVA() {
        return ORIGINS_FROM_JAVA;
    }

    public static final boolean comesFromJava(@NotNull IrDeclaration $this$comesFromJava) {
        Intrinsics.checkParameterIsNotNull($this$comesFromJava, "$this$comesFromJava");
        return CollectionsKt.contains((Iterable)ORIGINS_FROM_JAVA, IrUtilsKt.getParentAsClass($this$comesFromJava).getOrigin());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean sameCallAs(@NotNull Method $this$sameCallAs, @NotNull Method other) {
        Intrinsics.checkParameterIsNotNull($this$sameCallAs, "$this$sameCallAs");
        Intrinsics.checkParameterIsNotNull(other, "other");
        if (!Intrinsics.areEqual($this$sameCallAs.getName(), other.getName())) return false;
        Object[] objectArray = $this$sameCallAs.getArgumentTypes();
        if (objectArray == null) return false;
        Object[] objectArray2 = objectArray;
        Object[] objectArray3 = other.getArgumentTypes();
        Intrinsics.checkExpressionValueIsNotNull(objectArray3, "other.argumentTypes");
        Object[] objectArray4 = objectArray3;
        boolean bl = false;
        if (!Arrays.equals(objectArray2, objectArray4)) return false;
        return true;
    }
}

