/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.ant;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.ant.IvyPostResolveTask;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.cache.ArtifactOrigin;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.cache.RepositoryCacheManager;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.module.descriptor.Artifact;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.module.id.ModuleRevisionId;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.report.ArtifactDownloadReport;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.resolve.IvyNode;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.resolve.ResolveOptions;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.resolve.ResolvedModuleRevision;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.retrieve.RetrieveOptions;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.tools.ant.BuildException;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class IvyArtifactReport
extends IvyPostResolveTask {
    private File tofile;
    private String pattern;

    public File getTofile() {
        return this.tofile;
    }

    public void setTofile(File aFile) {
        this.tofile = aFile;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String aPattern) {
        this.pattern = aPattern;
    }

    @Override
    public void doExecute() throws BuildException {
        this.prepareAndCheck();
        if (this.tofile == null) {
            throw new BuildException("no destination file name: please provide it through parameter 'tofile'");
        }
        this.pattern = this.getProperty(this.pattern, this.getSettings(), "ivy.retrieve.pattern");
        try {
            String[] confs = this.splitConfs(this.getConf());
            ModuleDescriptor md = null;
            md = this.getResolveId() != null ? (ModuleDescriptor)this.getResolvedDescriptor(this.getResolveId()) : (ModuleDescriptor)this.getResolvedDescriptor(this.getOrganisation(), this.getModule(), false);
            IvyNode[] dependencies = this.getIvyInstance().getResolveEngine().getDependencies(md, ((ResolveOptions)new ResolveOptions().setLog(this.getLog())).setConfs(confs).setResolveId(this.getResolveId()).setValidate(this.doValidate(this.getSettings())), null);
            Map artifactsToCopy = this.getIvyInstance().getRetrieveEngine().determineArtifactsToCopy(ModuleRevisionId.newInstance(this.getOrganisation(), this.getModule(), this.getRevision()), this.pattern, ((RetrieveOptions)new RetrieveOptions().setLog(this.getLog())).setConfs(confs).setResolveId(this.getResolveId()));
            HashMap<ModuleRevisionId, HashSet<ArtifactDownloadReport>> moduleRevToArtifactsMap = new HashMap<ModuleRevisionId, HashSet<ArtifactDownloadReport>>();
            for (ArtifactDownloadReport artifact : artifactsToCopy.keySet()) {
                HashSet<ArtifactDownloadReport> moduleRevArtifacts = (HashSet<ArtifactDownloadReport>)moduleRevToArtifactsMap.get(artifact.getArtifact().getModuleRevisionId());
                if (moduleRevArtifacts == null) {
                    moduleRevArtifacts = new HashSet<ArtifactDownloadReport>();
                    moduleRevToArtifactsMap.put(artifact.getArtifact().getModuleRevisionId(), moduleRevArtifacts);
                }
                moduleRevArtifacts.add(artifact);
            }
            this.generateXml(dependencies, moduleRevToArtifactsMap, artifactsToCopy);
        }
        catch (ParseException e) {
            this.log(e.getMessage(), 0);
            throw new BuildException("syntax errors in ivy file: " + e, (Throwable)e);
        }
        catch (IOException e) {
            throw new BuildException("impossible to generate report: " + e, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateXml(IvyNode[] dependencies, Map moduleRevToArtifactsMap, Map artifactsToCopy) {
        try (FileOutputStream fileOuputStream = new FileOutputStream(this.tofile);){
            TransformerHandler saxHandler = this.createTransformerHandler(fileOuputStream);
            saxHandler.startDocument();
            saxHandler.startElement(null, "modules", "modules", new AttributesImpl());
            for (int i = 0; i < dependencies.length; ++i) {
                IvyNode dependency = dependencies[i];
                if (dependency.getModuleRevision() == null || dependency.isCompletelyEvicted()) continue;
                this.startModule(saxHandler, dependency);
                Set artifactsOfModuleRev = (Set)moduleRevToArtifactsMap.get(dependency.getModuleRevision().getId());
                if (artifactsOfModuleRev != null) {
                    for (ArtifactDownloadReport artifact : artifactsOfModuleRev) {
                        RepositoryCacheManager cache = dependency.getModuleRevision().getArtifactResolver().getRepositoryCacheManager();
                        this.startArtifact(saxHandler, artifact.getArtifact());
                        this.writeOriginLocationIfPresent(cache, saxHandler, artifact);
                        this.writeCacheLocationIfPresent(cache, saxHandler, artifact);
                        Set artifactDestPaths = (Set)artifactsToCopy.get(artifact);
                        for (String artifactDestPath : artifactDestPaths) {
                            this.writeRetrieveLocation(saxHandler, artifactDestPath);
                        }
                        saxHandler.endElement(null, "artifact", "artifact");
                    }
                }
                saxHandler.endElement(null, "module", "module");
            }
            saxHandler.endElement(null, "modules", "modules");
            saxHandler.endDocument();
        }
        catch (SAXException e) {
            throw new BuildException("impossible to generate report", (Throwable)e);
        }
        catch (TransformerConfigurationException e) {
            throw new BuildException("impossible to generate report", (Throwable)e);
        }
        catch (IOException e) {
            throw new BuildException("impossible to generate report", (Throwable)e);
        }
    }

    private TransformerHandler createTransformerHandler(FileOutputStream fileOuputStream) throws TransformerFactoryConfigurationError, TransformerConfigurationException, SAXException {
        SAXTransformerFactory transformerFact = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        TransformerHandler saxHandler = transformerFact.newTransformerHandler();
        saxHandler.getTransformer().setOutputProperty("encoding", "UTF-8");
        saxHandler.getTransformer().setOutputProperty("indent", "yes");
        saxHandler.setResult(new StreamResult(fileOuputStream));
        return saxHandler;
    }

    private void startModule(TransformerHandler saxHandler, IvyNode dependency) throws SAXException {
        AttributesImpl moduleAttrs = new AttributesImpl();
        moduleAttrs.addAttribute(null, "organisation", "organisation", "CDATA", dependency.getModuleId().getOrganisation());
        moduleAttrs.addAttribute(null, "name", "name", "CDATA", dependency.getModuleId().getName());
        ResolvedModuleRevision moduleRevision = dependency.getModuleRevision();
        moduleAttrs.addAttribute(null, "rev", "rev", "CDATA", moduleRevision.getId().getRevision());
        moduleAttrs.addAttribute(null, "status", "status", "CDATA", moduleRevision.getDescriptor().getStatus());
        saxHandler.startElement(null, "module", "module", moduleAttrs);
    }

    private void startArtifact(TransformerHandler saxHandler, Artifact artifact) throws SAXException {
        AttributesImpl artifactAttrs = new AttributesImpl();
        artifactAttrs.addAttribute(null, "name", "name", "CDATA", artifact.getName());
        artifactAttrs.addAttribute(null, "ext", "ext", "CDATA", artifact.getExt());
        artifactAttrs.addAttribute(null, "type", "type", "CDATA", artifact.getType());
        saxHandler.startElement(null, "artifact", "artifact", artifactAttrs);
    }

    private void writeOriginLocationIfPresent(RepositoryCacheManager cache, TransformerHandler saxHandler, ArtifactDownloadReport artifact) throws IOException, SAXException {
        ArtifactOrigin origin = artifact.getArtifactOrigin();
        if (!ArtifactOrigin.isUnknown(origin)) {
            String originLocation;
            String originName = origin.getLocation();
            boolean isOriginLocal = origin.isLocal();
            AttributesImpl originLocationAttrs = new AttributesImpl();
            if (isOriginLocal) {
                originLocationAttrs.addAttribute(null, "is-local", "is-local", "CDATA", "true");
                originLocation = originName.replace('\\', '/');
            } else {
                originLocationAttrs.addAttribute(null, "is-local", "is-local", "CDATA", "false");
                originLocation = originName;
            }
            saxHandler.startElement(null, "origin-location", "origin-location", originLocationAttrs);
            char[] originLocationAsChars = originLocation.toCharArray();
            saxHandler.characters(originLocationAsChars, 0, originLocationAsChars.length);
            saxHandler.endElement(null, "origin-location", "origin-location");
        }
    }

    private void writeCacheLocationIfPresent(RepositoryCacheManager cache, TransformerHandler saxHandler, ArtifactDownloadReport artifact) throws SAXException {
        File archiveInCache = artifact.getLocalFile();
        if (archiveInCache != null) {
            saxHandler.startElement(null, "cache-location", "cache-location", new AttributesImpl());
            char[] archiveInCacheAsChars = archiveInCache.getPath().replace('\\', '/').toCharArray();
            saxHandler.characters(archiveInCacheAsChars, 0, archiveInCacheAsChars.length);
            saxHandler.endElement(null, "cache-location", "cache-location");
        }
    }

    private void writeRetrieveLocation(TransformerHandler saxHandler, String artifactDestPath) throws SAXException {
        artifactDestPath = this.removeLeadingPath(this.getProject().getBaseDir(), new File(artifactDestPath));
        saxHandler.startElement(null, "retrieve-location", "retrieve-location", new AttributesImpl());
        char[] artifactDestPathAsChars = artifactDestPath.replace('\\', '/').toCharArray();
        saxHandler.characters(artifactDestPathAsChars, 0, artifactDestPathAsChars.length);
        saxHandler.endElement(null, "retrieve-location", "retrieve-location");
    }

    public String removeLeadingPath(File leading, File path) {
        String p;
        String l = leading.getAbsolutePath();
        if (l.equals(p = path.getAbsolutePath())) {
            return "";
        }
        if (!l.endsWith(File.separator)) {
            l = l + File.separator;
        }
        return p.startsWith(l) ? p.substring(l.length()) : p;
    }
}

