/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import org.mariadb.jdbc.MariaDbConnection;
import org.mariadb.jdbc.UrlParser;

public final class Driver
implements java.sql.Driver {
    @Override
    public Connection connect(String url, Properties props) throws SQLException {
        UrlParser urlParser = UrlParser.parse(url, props);
        if (urlParser == null || urlParser.getHostAddresses() == null) {
            return null;
        }
        return MariaDbConnection.newConnection(urlParser, null);
    }

    @Override
    public boolean acceptsURL(String url) {
        return UrlParser.acceptsUrl(url);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return new DriverPropertyInfo[0];
    }

    @Override
    public int getMajorVersion() {
        return 2;
    }

    @Override
    public int getMinorVersion() {
        return 2;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("Use logging parameters for enabling logging.");
    }

    static {
        try {
            DriverManager.registerDriver(new Driver());
        }
        catch (SQLException e) {
            throw new RuntimeException("Could not register driver", e);
        }
    }
}

