/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.deprecation;

import com.google.common.base.Optional;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.deprecation.DeprecationProfile;
import org.protege.editor.owl.ui.AbstractOWLWizardPanel;
import org.protege.editor.owl.ui.deprecation.DeprecateEntityWizardState;
import org.protege.editor.owl.ui.deprecation.DeprecationProfileRenderer;
import org.semanticweb.owlapi.model.IRI;

public class DeprecationProfilePage
extends AbstractOWLWizardPanel {
    public static final String ID = "DeprecationProfilePage";
    @Nonnull
    private final DeprecateEntityWizardState wizardState;
    private final JComboBox<DeprecationProfile> profilesCombo;
    private final JLabel descriptionLabel = new JLabel();
    private final List<DeprecationProfile> deprecationProfiles = new ArrayList<DeprecationProfile>();

    public DeprecationProfilePage(@Nonnull OWLEditorKit owlEditorKit, @Nonnull DeprecateEntityWizardState wizardState, @Nonnull List<DeprecationProfile> deprecationProfiles) {
        super(ID, "Deprecation Profile", owlEditorKit);
        this.deprecationProfiles.addAll(deprecationProfiles);
        this.wizardState = wizardState;
        this.setInstructions("<b>Please choose a deprecation profile</b>");
        this.profilesCombo = new JComboBox<DeprecationProfile>(deprecationProfiles.toArray(new DeprecationProfile[deprecationProfiles.size()]));
        this.profilesCombo.setRenderer(new DeprecationProfileRenderer());
        this.profilesCombo.addActionListener(e -> this.setDescription());
        JPanel content = new JPanel(new BorderLayout(7, 7));
        content.add(this.profilesCombo, "North");
        content.add((Component)this.descriptionLabel, "South");
        this.descriptionLabel.setBorder(BorderFactory.createEmptyBorder(0, 7, 0, 0));
        JPanel holder = new JPanel(new BorderLayout());
        holder.add((Component)content, "North");
        this.setContent(holder);
    }

    private void setActiveSelected() {
        this.deprecationProfiles.forEach(profile -> profile.getActivatedBy().ifPresent(activatedByIri -> {
            Optional ontologyIRI = this.getOWLModelManager().getActiveOntology().getOntologyID().getOntologyIRI();
            if (ontologyIRI.isPresent() && ((IRI)ontologyIRI.get()).equals(activatedByIri)) {
                this.profilesCombo.setSelectedItem(profile);
                this.setDescription();
            }
        }));
        this.setDescription();
    }

    private void setDescription() {
        String description = ((DeprecationProfile)this.profilesCombo.getSelectedItem()).getDescription();
        this.descriptionLabel.setText(String.format("<html><body>%s</body></html>", description.replace("\n", "<br>")));
    }

    @Nullable
    public Object getNextPanelDescriptor() {
        return "DeprecationReason";
    }

    public void aboutToDisplayPanel() {
        this.setActiveSelected();
    }

    public void aboutToHidePanel() {
        this.wizardState.setDeprecationProfile((DeprecationProfile)this.profilesCombo.getSelectedItem());
    }
}

