/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.core;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.ivy.Ivy;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.Configuration;
import org.apache.ivy.core.module.descriptor.DefaultArtifact;
import org.apache.ivy.core.module.descriptor.DefaultDependencyDescriptor;
import org.apache.ivy.core.module.descriptor.DefaultExcludeRule;
import org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import org.apache.ivy.core.module.id.ArtifactId;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.osgi.core.BundleCapability;
import org.apache.ivy.osgi.core.BundleInfo;
import org.apache.ivy.osgi.core.BundleRequirement;
import org.apache.ivy.osgi.core.ExecutionEnvironmentProfile;
import org.apache.ivy.osgi.core.ExecutionEnvironmentProfileProvider;
import org.apache.ivy.osgi.core.ExportPackage;
import org.apache.ivy.osgi.util.Version;
import org.apache.ivy.osgi.util.VersionRange;
import org.apache.ivy.plugins.matcher.ExactOrRegexpPatternMatcher;
import org.apache.ivy.plugins.parser.ModuleDescriptorParser;

public class BundleInfoAdapter {
    public static final String CONF_NAME_DEFAULT = "default";
    public static final Configuration CONF_DEFAULT = new Configuration("default");
    public static final String CONF_NAME_OPTIONAL = "optional";
    public static final Configuration CONF_OPTIONAL = new Configuration("optional", Configuration.Visibility.PUBLIC, "Optional dependencies", new String[]{"default"}, true, null);
    public static final String CONF_NAME_TRANSITIVE_OPTIONAL = "transitive-optional";
    public static final Configuration CONF_TRANSITIVE_OPTIONAL = new Configuration("transitive-optional", Configuration.Visibility.PUBLIC, "Optional dependencies", new String[]{"optional"}, true, null);
    public static final String CONF_USE_PREFIX = "use_";
    public static final String EXTRA_INFO_EXPORT_PREFIX = "_osgi_export_";

    public static DefaultModuleDescriptor toModuleDescriptor(ModuleDescriptorParser moduleDescriptorParser, URI uRI, BundleInfo bundleInfo, ExecutionEnvironmentProfileProvider executionEnvironmentProfileProvider) throws ProfileNotFoundException {
        String[] stringArray;
        Object object2;
        DefaultModuleDescriptor defaultModuleDescriptor = new DefaultModuleDescriptor(moduleDescriptorParser, null);
        defaultModuleDescriptor.addExtraAttributeNamespace("o", Ivy.getIvyHomeURL() + "osgi");
        ModuleRevisionId moduleRevisionId = BundleInfoAdapter.asMrid("bundle", bundleInfo.getSymbolicName(), bundleInfo.getVersion());
        defaultModuleDescriptor.setResolvedPublicationDate(new Date());
        defaultModuleDescriptor.setModuleRevisionId(moduleRevisionId);
        defaultModuleDescriptor.addConfiguration(CONF_DEFAULT);
        defaultModuleDescriptor.addConfiguration(CONF_OPTIONAL);
        defaultModuleDescriptor.addConfiguration(CONF_TRANSITIVE_OPTIONAL);
        HashSet<String> hashSet = new HashSet<String>(bundleInfo.getExports().size());
        for (Object object2 : bundleInfo.getExports()) {
            defaultModuleDescriptor.getExtraInfo().put(EXTRA_INFO_EXPORT_PREFIX + ((BundleCapability)object2).getName(), ((ExportPackage)object2).getVersion().toString());
            hashSet.add(((BundleCapability)object2).getName());
            stringArray = new String[((ExportPackage)object2).getUses().size() + 1];
            int n = 0;
            for (Object object3 : ((ExportPackage)object2).getUses()) {
                stringArray[n++] = CONF_USE_PREFIX + (String)object3;
            }
            stringArray[n] = CONF_NAME_DEFAULT;
            defaultModuleDescriptor.addConfiguration(new Configuration(CONF_USE_PREFIX + ((BundleCapability)object2).getName(), Configuration.Visibility.PUBLIC, "Exported package " + ((BundleCapability)object2).getName(), stringArray, true, null));
        }
        BundleInfoAdapter.requirementAsDependency(defaultModuleDescriptor, bundleInfo, hashSet);
        object2 = bundleInfo.getUri();
        if (object2 != null) {
            stringArray = null;
            if ("ivy".equals(((URI)object2).getScheme())) {
                stringArray = BundleInfoAdapter.decodeIvyURI((URI)object2);
            } else {
                if (!((URI)object2).isAbsolute()) {
                    object2 = uRI.resolve((URI)object2);
                }
                try {
                    stringArray = new DefaultArtifact(moduleRevisionId, null, bundleInfo.getSymbolicName(), "jar", "jar", new URL(((URI)object2).toString()), null);
                }
                catch (MalformedURLException malformedURLException) {
                    throw new RuntimeException("Unable to make the uri into the url", malformedURLException);
                }
            }
            if (stringArray != null) {
                defaultModuleDescriptor.addArtifact(CONF_NAME_DEFAULT, (Artifact)stringArray);
            }
        }
        if (executionEnvironmentProfileProvider != null) {
            for (String string : bundleInfo.getExecutionEnvironments()) {
                ExecutionEnvironmentProfile executionEnvironmentProfile = executionEnvironmentProfileProvider.getProfile(string);
                if (executionEnvironmentProfile == null) {
                    throw new ProfileNotFoundException("Execution environment profile " + string + " not found");
                }
                for (String string2 : executionEnvironmentProfile.getPkgNames()) {
                    ArtifactId artifactId = new ArtifactId(ModuleId.newInstance("bundle", string2), "*", "*", "*");
                    DefaultExcludeRule defaultExcludeRule = new DefaultExcludeRule(artifactId, ExactOrRegexpPatternMatcher.INSTANCE, null);
                    String[] stringArray2 = defaultModuleDescriptor.getConfigurationsNames();
                    for (int i = 0; i < stringArray2.length; ++i) {
                        defaultExcludeRule.addConfiguration(stringArray2[i]);
                    }
                    defaultModuleDescriptor.addExcludeRule(defaultExcludeRule);
                }
            }
        }
        return defaultModuleDescriptor;
    }

    public static List getConfigurations(BundleInfo bundleInfo) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(CONF_DEFAULT);
        arrayList.add(CONF_OPTIONAL);
        arrayList.add(CONF_TRANSITIVE_OPTIONAL);
        for (ExportPackage exportPackage : bundleInfo.getExports()) {
            arrayList.add(CONF_USE_PREFIX + exportPackage.getName());
        }
        return arrayList;
    }

    public static URI buildIvyURI(Artifact artifact) {
        ModuleRevisionId moduleRevisionId = artifact.getModuleRevisionId();
        return BundleInfoAdapter.asIvyURI(moduleRevisionId.getOrganisation(), moduleRevisionId.getName(), moduleRevisionId.getBranch(), moduleRevisionId.getRevision(), artifact.getType(), artifact.getName(), artifact.getExt());
    }

    private static URI asIvyURI(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ivy:///");
        stringBuffer.append(string);
        stringBuffer.append('/');
        stringBuffer.append(string2);
        stringBuffer.append('?');
        if (string3 != null) {
            stringBuffer.append("branch=");
            stringBuffer.append(string3);
        }
        if (string4 != null) {
            stringBuffer.append("&rev=");
            stringBuffer.append(string4);
        }
        if (string5 != null) {
            stringBuffer.append("&type=");
            stringBuffer.append(string5);
        }
        if (string6 != null) {
            stringBuffer.append("&art=");
            stringBuffer.append(string6);
        }
        if (string7 != null) {
            stringBuffer.append("&ext=");
            stringBuffer.append(string7);
        }
        try {
            return new URI(stringBuffer.toString());
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RuntimeException("illformed ivy url", uRISyntaxException);
        }
    }

    private static DefaultArtifact decodeIvyURI(URI uRI) {
        Object object;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = uRI.getPath();
        if (!string8.startsWith("/")) {
            throw new IllegalArgumentException("An ivy url should be of the form ivy:///org/module but was : " + uRI);
        }
        int n = string8.indexOf(47, 1);
        if (n < 0) {
            throw new IllegalArgumentException("Expecting an organisation in the ivy url: " + uRI);
        }
        string = string8.substring(1, n);
        string2 = string8.substring(n + 1);
        String string9 = uRI.getQuery();
        String[] stringArray = string9.split("&");
        for (int i = 0; i < stringArray.length; ++i) {
            object = stringArray[i];
            if (((String)object).length() == 0) continue;
            String[] stringArray2 = ((String)object).split("=");
            if (stringArray2.length != 2) {
                throw new IllegalArgumentException("Malformed query string in the ivy url: " + uRI);
            }
            if (stringArray2[0].equals("branch")) {
                string3 = stringArray2[1];
                continue;
            }
            if (stringArray2[0].equals("rev")) {
                string4 = stringArray2[1];
                continue;
            }
            if (stringArray2[0].equals("art")) {
                string5 = stringArray2[1];
                continue;
            }
            if (stringArray2[0].equals("type")) {
                string6 = stringArray2[1];
                continue;
            }
            if (stringArray2[0].equals("ext")) {
                string7 = stringArray2[1];
                continue;
            }
            throw new IllegalArgumentException("Unrecognized parameter '" + stringArray2[0] + " in the query string of the ivy url: " + uRI);
        }
        ModuleRevisionId moduleRevisionId = ModuleRevisionId.newInstance(string, string2, string3, string4);
        object = new DefaultArtifact(moduleRevisionId, null, string5, string6, string7);
        return object;
    }

    private static void requirementAsDependency(DefaultModuleDescriptor defaultModuleDescriptor, BundleInfo bundleInfo, Set set) {
        for (BundleRequirement bundleRequirement : bundleInfo.getRequirements()) {
            String string = bundleRequirement.getType();
            String string2 = bundleRequirement.getName();
            if ("package".equals(string) && set.contains(string2)) continue;
            ModuleRevisionId moduleRevisionId = BundleInfoAdapter.asMrid(string, string2, bundleRequirement.getVersion());
            DefaultDependencyDescriptor defaultDependencyDescriptor = new DefaultDependencyDescriptor(moduleRevisionId, false);
            String string3 = CONF_NAME_DEFAULT;
            if ("package".equals(string)) {
                string3 = CONF_USE_PREFIX + string2;
                defaultModuleDescriptor.addConfiguration(new Configuration(CONF_USE_PREFIX + string2, Configuration.Visibility.PUBLIC, "Exported package " + string2, new String[]{CONF_NAME_DEFAULT}, true, null));
                defaultDependencyDescriptor.addDependencyConfiguration(string3, string3);
            }
            if (CONF_NAME_OPTIONAL.equals(bundleRequirement.getResolution())) {
                defaultDependencyDescriptor.addDependencyConfiguration(CONF_NAME_OPTIONAL, string3);
                defaultDependencyDescriptor.addDependencyConfiguration(CONF_NAME_TRANSITIVE_OPTIONAL, CONF_NAME_TRANSITIVE_OPTIONAL);
            } else {
                defaultDependencyDescriptor.addDependencyConfiguration(CONF_NAME_DEFAULT, string3);
            }
            defaultModuleDescriptor.addDependency(defaultDependencyDescriptor);
        }
    }

    public static ModuleRevisionId asMrid(String string, String string2, Version version) {
        return ModuleRevisionId.newInstance(string, string2, version == null ? null : version.toString());
    }

    public static ModuleRevisionId asMrid(String string, String string2, VersionRange versionRange) {
        String string3 = versionRange == null ? "[0,)" : versionRange.toIvyRevision();
        return ModuleRevisionId.newInstance(string, string2, string3);
    }

    public static class ProfileNotFoundException
    extends RuntimeException {
        public ProfileNotFoundException(String string) {
            super(string);
        }
    }
}

