/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.resolver;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ivy.core.IvyPatternHelper;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.settings.IvyPattern;
import org.apache.ivy.plugins.repository.file.FileRepository;
import org.apache.ivy.plugins.resolver.RepositoryResolver;
import org.apache.ivy.util.Checks;
import org.apache.ivy.util.Message;

public class FileSystemResolver
extends RepositoryResolver {
    private static final String TRANSACTION_DESTINATION_SUFFIX = ".part";
    private static final Pattern TRANSACTION_PATTERN = Pattern.compile("(.*[/\\\\]\\[revision\\])([/\\\\].+)");
    private String transactional = "auto";
    private Boolean supportTransaction;
    private String baseTransactionPattern;
    private Map fullTransactionPatterns = new HashMap();
    private File transactionTempDir;
    private File transactionDestDir;

    public FileSystemResolver() {
        this.setRepository(new FileRepository());
    }

    @Override
    public String getTypeName() {
        return "file";
    }

    public boolean isLocal() {
        return this.getFileRepository().isLocal();
    }

    public void setLocal(boolean bl) {
        this.getFileRepository().setLocal(bl);
    }

    private FileRepository getFileRepository() {
        return (FileRepository)this.getRepository();
    }

    @Override
    protected String getDestination(String string, Artifact artifact, ModuleRevisionId moduleRevisionId) {
        if (this.supportTransaction() && this.isTransactionStarted()) {
            String string2 = (String)this.fullTransactionPatterns.get(string);
            if (string2 == null) {
                throw new IllegalArgumentException("unsupported pattern for publish destination pattern: " + string + ". supported patterns: " + this.fullTransactionPatterns.keySet());
            }
            return IvyPatternHelper.substitute(string2, moduleRevisionId, artifact);
        }
        return super.getDestination(string, artifact, moduleRevisionId);
    }

    private boolean isTransactionStarted() {
        return this.transactionTempDir != null;
    }

    @Override
    public void abortPublishTransaction() throws IOException {
        if (this.supportTransaction()) {
            if (this.isTransactionStarted()) {
                try {
                    this.getFileRepository().delete(this.transactionTempDir);
                    Message.info("\tpublish aborted: deleted " + this.transactionTempDir);
                }
                finally {
                    this.closeTransaction();
                }
            } else {
                Message.info("\tpublish aborted: nothing was started");
            }
        }
    }

    @Override
    public void commitPublishTransaction() throws IOException {
        if (this.supportTransaction()) {
            if (!this.isTransactionStarted()) {
                throw new IllegalStateException("no current transaction!");
            }
            if (this.transactionDestDir.exists()) {
                throw new IOException("impossible to commit transaction: transaction destination directory already exists: " + this.transactionDestDir + "\npossible cause: usage of identifying tokens after the revision token");
            }
            try {
                this.getFileRepository().move(this.transactionTempDir, this.transactionDestDir);
                Message.info("\tpublish commited: moved " + this.transactionTempDir + " \n\t\tto " + this.transactionDestDir);
            }
            catch (IOException iOException) {
                IOException iOException2;
                try {
                    this.getFileRepository().delete(this.transactionTempDir);
                    iOException2 = new IOException("publish transaction commit error for " + this.transactionDestDir + ": rolled back");
                }
                catch (IOException iOException3) {
                    iOException2 = new IOException("publish transaction commit error for " + this.transactionDestDir + ": rollback impossible either, please remove " + this.transactionTempDir + " manually");
                }
                iOException2.initCause(iOException);
                throw iOException2;
            }
            finally {
                this.closeTransaction();
            }
        }
    }

    @Override
    public void beginPublishTransaction(ModuleRevisionId moduleRevisionId, boolean bl) throws IOException {
        if (this.supportTransaction()) {
            if (this.isTransactionStarted()) {
                throw new IllegalStateException("a transaction is already started and not closed!");
            }
            if (bl) {
                this.unsupportedTransaction("overwrite transaction not supported yet");
            } else {
                this.initTransaction(moduleRevisionId);
                if (this.transactionDestDir.exists()) {
                    this.unsupportedTransaction("transaction destination directory already exists: " + this.transactionDestDir + "\npossible cause: usage of identifying tokens after the revision token");
                    this.closeTransaction();
                } else {
                    Message.verbose("\tstarting transaction: publish during transaction will be done in \n\t\t" + this.transactionTempDir + "\n\tand on commit moved to \n\t\t" + this.transactionDestDir);
                }
            }
        }
    }

    @Override
    protected Collection filterNames(Collection collection) {
        if (this.supportTransaction()) {
            collection = super.filterNames(collection);
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (!string.endsWith(TRANSACTION_DESTINATION_SUFFIX)) continue;
                iterator.remove();
            }
            return collection;
        }
        return super.filterNames(collection);
    }

    public boolean supportTransaction() {
        if ("false".equals(this.transactional)) {
            return false;
        }
        this.checkSupportTransaction();
        return this.supportTransaction;
    }

    private void closeTransaction() {
        this.transactionTempDir = null;
        this.transactionDestDir = null;
    }

    private void checkSupportTransaction() {
        if (this.supportTransaction == null) {
            Matcher matcher;
            String string;
            this.supportTransaction = Boolean.FALSE;
            List list = this.getIvyPatterns();
            List list2 = this.getArtifactPatterns();
            if (list.size() > 0) {
                string = (String)list.get(0);
                matcher = TRANSACTION_PATTERN.matcher(string);
                if (!matcher.matches()) {
                    this.unsupportedTransaction("ivy pattern does not use revision as a directory");
                    return;
                }
                this.baseTransactionPattern = matcher.group(1);
                this.fullTransactionPatterns.put(string, matcher.group(1) + TRANSACTION_DESTINATION_SUFFIX + matcher.group(2));
            }
            if (list2.size() > 0) {
                string = (String)list2.get(0);
                matcher = TRANSACTION_PATTERN.matcher(string);
                if (!matcher.matches()) {
                    this.unsupportedTransaction("artifact pattern does not use revision as a directory");
                    return;
                }
                if (this.baseTransactionPattern != null) {
                    if (!this.baseTransactionPattern.equals(matcher.group(1))) {
                        this.unsupportedTransaction("ivy pattern and artifact pattern do not use the same directory for revision");
                        return;
                    }
                    this.fullTransactionPatterns.put(string, matcher.group(1) + TRANSACTION_DESTINATION_SUFFIX + matcher.group(2));
                } else {
                    this.baseTransactionPattern = matcher.group(1);
                    this.fullTransactionPatterns.put(string, matcher.group(1) + TRANSACTION_DESTINATION_SUFFIX + matcher.group(2));
                }
            }
            this.supportTransaction = Boolean.TRUE;
        }
    }

    private void unsupportedTransaction(String string) {
        String string2 = this.getName() + " do not support transaction. " + string;
        if ("true".equals(this.transactional)) {
            throw new IllegalStateException(string2 + ". Set transactional attribute to 'auto' or 'false' or fix the problem.");
        }
        Message.verbose(string2);
        this.supportTransaction = Boolean.FALSE;
    }

    private void initTransaction(ModuleRevisionId moduleRevisionId) {
        ModuleRevisionId moduleRevisionId2 = moduleRevisionId;
        if (this.isM2compatible()) {
            moduleRevisionId2 = this.convertM2IdForResourceSearch(moduleRevisionId);
        }
        this.transactionTempDir = Checks.checkAbsolute(IvyPatternHelper.substitute(this.baseTransactionPattern, ModuleRevisionId.newInstance(moduleRevisionId2, moduleRevisionId2.getRevision() + TRANSACTION_DESTINATION_SUFFIX)), "baseTransactionPattern");
        this.transactionDestDir = Checks.checkAbsolute(IvyPatternHelper.substitute(this.baseTransactionPattern, moduleRevisionId2), "baseTransactionPattern");
    }

    public String getTransactional() {
        return this.transactional;
    }

    public void setTransactional(String string) {
        this.transactional = string;
    }

    @Override
    public void addConfiguredIvy(IvyPattern ivyPattern) {
        File file = Checks.checkAbsolute(ivyPattern.getPattern(), "ivy pattern");
        ivyPattern.setPattern(file.getAbsolutePath());
        super.addConfiguredIvy(ivyPattern);
    }

    @Override
    public void addIvyPattern(String string) {
        File file = Checks.checkAbsolute(string, "ivy pattern");
        super.addIvyPattern(file.getAbsolutePath());
    }

    @Override
    public void addConfiguredArtifact(IvyPattern ivyPattern) {
        File file = Checks.checkAbsolute(ivyPattern.getPattern(), "artifact pattern");
        ivyPattern.setPattern(file.getAbsolutePath());
        super.addConfiguredArtifact(ivyPattern);
    }

    @Override
    public void addArtifactPattern(String string) {
        File file = Checks.checkAbsolute(string, "artifact pattern");
        super.addArtifactPattern(file.getAbsolutePath());
    }
}

