/*
 * Decompiled with CFR 0.152.
 */
package net.adaptivebox.deps.behavior;

import net.adaptivebox.deps.behavior.AbsGTBehavior;
import net.adaptivebox.goodness.IGoodnessCompareEngine;
import net.adaptivebox.knowledge.Library;
import net.adaptivebox.knowledge.SearchPoint;
import net.adaptivebox.problem.ProblemEncoder;
import net.adaptivebox.space.BasicPoint;
import net.adaptivebox.space.DesignSpace;

public class PSGTBehavior
extends AbsGTBehavior {
    public double c1 = 2.0;
    public double c2 = 2.0;
    public double weight = 0.4;
    public double CL = 0.0;
    private BasicPoint pold_t;
    private BasicPoint pcurrent_t;
    private SearchPoint pbest_t;

    public void setMemPoints(SearchPoint pbest, BasicPoint pcurrent, BasicPoint pold) {
        this.pcurrent_t = pcurrent;
        this.pbest_t = pbest;
        this.pold_t = pold;
    }

    public void generateBehavior(SearchPoint trailPoint, ProblemEncoder problemEncoder) {
        SearchPoint gbest_t = this.socialLib.getGbest();
        DesignSpace designSpace = problemEncoder.getDesignSpace();
        int DIMENSION = designSpace.getDimension();
        for (int b = 0; b < DIMENSION; ++b) {
            double deltaxbm;
            if (Math.random() < this.CL) {
                designSpace.mutationAt(trailPoint.getLocation(), b);
                continue;
            }
            double deltaxb = this.weight * (this.pcurrent_t.getLocation()[b] - this.pold_t.getLocation()[b]) + this.c1 * Math.random() * (this.pbest_t.getLocation()[b] - this.pcurrent_t.getLocation()[b]) + this.c2 * Math.random() * (gbest_t.getLocation()[b] - this.pcurrent_t.getLocation()[b]);
            if (deltaxb < -(deltaxbm = 0.5 * designSpace.getMagnitudeIn(b))) {
                deltaxb = -deltaxbm;
            } else if (deltaxb > deltaxbm) {
                deltaxb = deltaxbm;
            }
            trailPoint.getLocation()[b] = this.pcurrent_t.getLocation()[b] + deltaxb;
        }
    }

    public void testBehavior(SearchPoint trailPoint, IGoodnessCompareEngine qualityComparator) {
        Library.replace(qualityComparator, trailPoint, this.pbest_t);
        this.pold_t.importLocation(this.pcurrent_t);
        this.pcurrent_t.importLocation(trailPoint);
    }
}

